# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'FlowEncryption',
    'FlowEntitlementEncryption',
    'FlowFailoverConfig',
    'FlowOutputEncryption',
    'FlowOutputVpcInterfaceAttachment',
    'FlowSource',
    'FlowSourceEncryption',
]

@pulumi.output_type
class FlowEncryption(dict):
    """
    Information about the encryption of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "constantInitializationVector":
            suggest = "constant_initialization_vector"
        elif key == "deviceId":
            suggest = "device_id"
        elif key == "keyType":
            suggest = "key_type"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "secretArn":
            suggest = "secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: str,
                 algorithm: Optional['FlowEncryptionAlgorithm'] = None,
                 constant_initialization_vector: Optional[str] = None,
                 device_id: Optional[str] = None,
                 key_type: Optional['FlowEncryptionKeyType'] = None,
                 region: Optional[str] = None,
                 resource_id: Optional[str] = None,
                 secret_arn: Optional[str] = None,
                 url: Optional[str] = None):
        """
        Information about the encryption of the flow.
        :param str role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param 'FlowEncryptionAlgorithm' algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param str constant_initialization_vector: A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        :param str device_id: The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param 'FlowEncryptionKeyType' key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        :param str region: The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param str resource_id: An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param str secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param str url: The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def algorithm(self) -> Optional['FlowEncryptionAlgorithm']:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[str]:
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[str]:
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional['FlowEncryptionKeyType']:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[str]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class FlowEntitlementEncryption(dict):
    """
    Information about the encryption of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "constantInitializationVector":
            suggest = "constant_initialization_vector"
        elif key == "deviceId":
            suggest = "device_id"
        elif key == "keyType":
            suggest = "key_type"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "secretArn":
            suggest = "secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowEntitlementEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowEntitlementEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowEntitlementEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: 'FlowEntitlementEncryptionAlgorithm',
                 role_arn: str,
                 constant_initialization_vector: Optional[str] = None,
                 device_id: Optional[str] = None,
                 key_type: Optional['FlowEntitlementEncryptionKeyType'] = None,
                 region: Optional[str] = None,
                 resource_id: Optional[str] = None,
                 secret_arn: Optional[str] = None,
                 url: Optional[str] = None):
        """
        Information about the encryption of the flow.
        :param 'FlowEntitlementEncryptionAlgorithm' algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param str role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param str constant_initialization_vector: A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        :param str device_id: The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param 'FlowEntitlementEncryptionKeyType' key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        :param str region: The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param str resource_id: An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param str secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param str url: The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "role_arn", role_arn)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def algorithm(self) -> 'FlowEntitlementEncryptionAlgorithm':
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[str]:
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[str]:
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional['FlowEntitlementEncryptionKeyType']:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[str]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class FlowFailoverConfig(dict):
    """
    The settings for source failover
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recoveryWindow":
            suggest = "recovery_window"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowFailoverConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowFailoverConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowFailoverConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recovery_window: Optional[int] = None,
                 state: Optional['FlowFailoverConfigState'] = None):
        """
        The settings for source failover
        :param int recovery_window: Search window time to look for dash-7 packets
        """
        if recovery_window is not None:
            pulumi.set(__self__, "recovery_window", recovery_window)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="recoveryWindow")
    def recovery_window(self) -> Optional[int]:
        """
        Search window time to look for dash-7 packets
        """
        return pulumi.get(self, "recovery_window")

    @property
    @pulumi.getter
    def state(self) -> Optional['FlowFailoverConfigState']:
        return pulumi.get(self, "state")


@pulumi.output_type
class FlowOutputEncryption(dict):
    """
    Information about the encryption of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "secretArn":
            suggest = "secret_arn"
        elif key == "keyType":
            suggest = "key_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowOutputEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowOutputEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowOutputEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: str,
                 secret_arn: str,
                 algorithm: Optional['FlowOutputEncryptionAlgorithm'] = None,
                 key_type: Optional['FlowOutputEncryptionKeyType'] = None):
        """
        Information about the encryption of the flow.
        :param str role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param str secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param 'FlowOutputEncryptionAlgorithm' algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param 'FlowOutputEncryptionKeyType' key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "secret_arn", secret_arn)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> str:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @property
    @pulumi.getter
    def algorithm(self) -> Optional['FlowOutputEncryptionAlgorithm']:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional['FlowOutputEncryptionKeyType']:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")


@pulumi.output_type
class FlowOutputVpcInterfaceAttachment(dict):
    """
    The settings for attaching a VPC interface to an output.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcInterfaceName":
            suggest = "vpc_interface_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowOutputVpcInterfaceAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowOutputVpcInterfaceAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowOutputVpcInterfaceAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_interface_name: Optional[str] = None):
        """
        The settings for attaching a VPC interface to an output.
        :param str vpc_interface_name: The name of the VPC interface to use for this output.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[str]:
        """
        The name of the VPC interface to use for this output.
        """
        return pulumi.get(self, "vpc_interface_name")


@pulumi.output_type
class FlowSource(dict):
    """
    The settings for the source of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entitlementArn":
            suggest = "entitlement_arn"
        elif key == "ingestIp":
            suggest = "ingest_ip"
        elif key == "ingestPort":
            suggest = "ingest_port"
        elif key == "maxBitrate":
            suggest = "max_bitrate"
        elif key == "maxLatency":
            suggest = "max_latency"
        elif key == "minLatency":
            suggest = "min_latency"
        elif key == "sourceArn":
            suggest = "source_arn"
        elif key == "sourceIngestPort":
            suggest = "source_ingest_port"
        elif key == "streamId":
            suggest = "stream_id"
        elif key == "vpcInterfaceName":
            suggest = "vpc_interface_name"
        elif key == "whitelistCidr":
            suggest = "whitelist_cidr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 decryption: Optional['outputs.FlowEncryption'] = None,
                 description: Optional[str] = None,
                 entitlement_arn: Optional[str] = None,
                 ingest_ip: Optional[str] = None,
                 ingest_port: Optional[int] = None,
                 max_bitrate: Optional[int] = None,
                 max_latency: Optional[int] = None,
                 min_latency: Optional[int] = None,
                 name: Optional[str] = None,
                 protocol: Optional['FlowSourceProtocol'] = None,
                 source_arn: Optional[str] = None,
                 source_ingest_port: Optional[str] = None,
                 stream_id: Optional[str] = None,
                 vpc_interface_name: Optional[str] = None,
                 whitelist_cidr: Optional[str] = None):
        """
        The settings for the source of the flow.
        :param 'FlowEncryption' decryption: The type of decryption that is used on the content ingested from this source.
        :param str description: A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        :param str entitlement_arn: The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        :param str ingest_ip: The IP address that the flow will be listening on for incoming content.
        :param int ingest_port: The port that the flow will be listening on for incoming content.
        :param int max_bitrate: The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        :param int max_latency: The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        :param int min_latency: The minimum latency in milliseconds.
        :param str name: The name of the source.
        :param 'FlowSourceProtocol' protocol: The protocol that is used by the source or output.
        :param str source_arn: The ARN of the source.
        :param str source_ingest_port: The port that the flow will be listening on for incoming content.(ReadOnly)
        :param str stream_id: The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        :param str vpc_interface_name: The name of the VPC Interface this Source is configured with.
        :param str whitelist_cidr: The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        if decryption is not None:
            pulumi.set(__self__, "decryption", decryption)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entitlement_arn is not None:
            pulumi.set(__self__, "entitlement_arn", entitlement_arn)
        if ingest_ip is not None:
            pulumi.set(__self__, "ingest_ip", ingest_ip)
        if ingest_port is not None:
            pulumi.set(__self__, "ingest_port", ingest_port)
        if max_bitrate is not None:
            pulumi.set(__self__, "max_bitrate", max_bitrate)
        if max_latency is not None:
            pulumi.set(__self__, "max_latency", max_latency)
        if min_latency is not None:
            pulumi.set(__self__, "min_latency", min_latency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)
        if source_ingest_port is not None:
            pulumi.set(__self__, "source_ingest_port", source_ingest_port)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)
        if whitelist_cidr is not None:
            pulumi.set(__self__, "whitelist_cidr", whitelist_cidr)

    @property
    @pulumi.getter
    def decryption(self) -> Optional['outputs.FlowEncryption']:
        """
        The type of decryption that is used on the content ingested from this source.
        """
        return pulumi.get(self, "decryption")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="entitlementArn")
    def entitlement_arn(self) -> Optional[str]:
        """
        The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        """
        return pulumi.get(self, "entitlement_arn")

    @property
    @pulumi.getter(name="ingestIp")
    def ingest_ip(self) -> Optional[str]:
        """
        The IP address that the flow will be listening on for incoming content.
        """
        return pulumi.get(self, "ingest_ip")

    @property
    @pulumi.getter(name="ingestPort")
    def ingest_port(self) -> Optional[int]:
        """
        The port that the flow will be listening on for incoming content.
        """
        return pulumi.get(self, "ingest_port")

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> Optional[int]:
        """
        The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        """
        return pulumi.get(self, "max_bitrate")

    @property
    @pulumi.getter(name="maxLatency")
    def max_latency(self) -> Optional[int]:
        """
        The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        """
        return pulumi.get(self, "max_latency")

    @property
    @pulumi.getter(name="minLatency")
    def min_latency(self) -> Optional[int]:
        """
        The minimum latency in milliseconds.
        """
        return pulumi.get(self, "min_latency")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> Optional['FlowSourceProtocol']:
        """
        The protocol that is used by the source or output.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[str]:
        """
        The ARN of the source.
        """
        return pulumi.get(self, "source_arn")

    @property
    @pulumi.getter(name="sourceIngestPort")
    def source_ingest_port(self) -> Optional[str]:
        """
        The port that the flow will be listening on for incoming content.(ReadOnly)
        """
        return pulumi.get(self, "source_ingest_port")

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[str]:
        """
        The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        """
        return pulumi.get(self, "stream_id")

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[str]:
        """
        The name of the VPC Interface this Source is configured with.
        """
        return pulumi.get(self, "vpc_interface_name")

    @property
    @pulumi.getter(name="whitelistCidr")
    def whitelist_cidr(self) -> Optional[str]:
        """
        The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        return pulumi.get(self, "whitelist_cidr")


@pulumi.output_type
class FlowSourceEncryption(dict):
    """
    Information about the encryption of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "constantInitializationVector":
            suggest = "constant_initialization_vector"
        elif key == "deviceId":
            suggest = "device_id"
        elif key == "keyType":
            suggest = "key_type"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "secretArn":
            suggest = "secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSourceEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSourceEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSourceEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: 'FlowSourceEncryptionAlgorithm',
                 role_arn: str,
                 constant_initialization_vector: Optional[str] = None,
                 device_id: Optional[str] = None,
                 key_type: Optional['FlowSourceEncryptionKeyType'] = None,
                 region: Optional[str] = None,
                 resource_id: Optional[str] = None,
                 secret_arn: Optional[str] = None,
                 url: Optional[str] = None):
        """
        Information about the encryption of the flow.
        :param 'FlowSourceEncryptionAlgorithm' algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param str role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param str constant_initialization_vector: A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        :param str device_id: The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param 'FlowSourceEncryptionKeyType' key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        :param str region: The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param str resource_id: An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param str secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param str url: The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "role_arn", role_arn)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def algorithm(self) -> 'FlowSourceEncryptionAlgorithm':
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[str]:
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[str]:
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional['FlowSourceEncryptionKeyType']:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[str]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "url")


