# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulp_ansible.configuration import Configuration


class AnsibleCollectionVersion(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'file': 'file',
        'repository': 'str',
        'artifact': 'str',
        'upload': 'str',
        'expected_name': 'str',
        'expected_namespace': 'str',
        'expected_version': 'str'
    }

    attribute_map = {
        'file': 'file',
        'repository': 'repository',
        'artifact': 'artifact',
        'upload': 'upload',
        'expected_name': 'expected_name',
        'expected_namespace': 'expected_namespace',
        'expected_version': 'expected_version'
    }

    def __init__(self, file=None, repository=None, artifact=None, upload=None, expected_name=None, expected_namespace=None, expected_version=None, local_vars_configuration=None):  # noqa: E501
        """AnsibleCollectionVersion - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._file = None
        self._repository = None
        self._artifact = None
        self._upload = None
        self._expected_name = None
        self._expected_namespace = None
        self._expected_version = None
        self.discriminator = None

        if file is not None:
            self.file = file
        if repository is not None:
            self.repository = repository
        if artifact is not None:
            self.artifact = artifact
        if upload is not None:
            self.upload = upload
        if expected_name is not None:
            self.expected_name = expected_name
        if expected_namespace is not None:
            self.expected_namespace = expected_namespace
        if expected_version is not None:
            self.expected_version = expected_version

    @property
    def file(self):
        """Gets the file of this AnsibleCollectionVersion.  # noqa: E501

        An uploaded file that may be turned into the artifact of the content unit.  # noqa: E501

        :return: The file of this AnsibleCollectionVersion.  # noqa: E501
        :rtype: file
        """
        return self._file

    @file.setter
    def file(self, file):
        """Sets the file of this AnsibleCollectionVersion.

        An uploaded file that may be turned into the artifact of the content unit.  # noqa: E501

        :param file: The file of this AnsibleCollectionVersion.  # noqa: E501
        :type: file
        """

        self._file = file

    @property
    def repository(self):
        """Gets the repository of this AnsibleCollectionVersion.  # noqa: E501

        A URI of a repository the new content unit should be associated with.  # noqa: E501

        :return: The repository of this AnsibleCollectionVersion.  # noqa: E501
        :rtype: str
        """
        return self._repository

    @repository.setter
    def repository(self, repository):
        """Sets the repository of this AnsibleCollectionVersion.

        A URI of a repository the new content unit should be associated with.  # noqa: E501

        :param repository: The repository of this AnsibleCollectionVersion.  # noqa: E501
        :type: str
        """

        self._repository = repository

    @property
    def artifact(self):
        """Gets the artifact of this AnsibleCollectionVersion.  # noqa: E501

        Artifact file representing the physical content  # noqa: E501

        :return: The artifact of this AnsibleCollectionVersion.  # noqa: E501
        :rtype: str
        """
        return self._artifact

    @artifact.setter
    def artifact(self, artifact):
        """Sets the artifact of this AnsibleCollectionVersion.

        Artifact file representing the physical content  # noqa: E501

        :param artifact: The artifact of this AnsibleCollectionVersion.  # noqa: E501
        :type: str
        """

        self._artifact = artifact

    @property
    def upload(self):
        """Gets the upload of this AnsibleCollectionVersion.  # noqa: E501

        An uncommitted upload that may be turned into the artifact of the content unit.  # noqa: E501

        :return: The upload of this AnsibleCollectionVersion.  # noqa: E501
        :rtype: str
        """
        return self._upload

    @upload.setter
    def upload(self, upload):
        """Sets the upload of this AnsibleCollectionVersion.

        An uncommitted upload that may be turned into the artifact of the content unit.  # noqa: E501

        :param upload: The upload of this AnsibleCollectionVersion.  # noqa: E501
        :type: str
        """

        self._upload = upload

    @property
    def expected_name(self):
        """Gets the expected_name of this AnsibleCollectionVersion.  # noqa: E501

        The name of the collection.  # noqa: E501

        :return: The expected_name of this AnsibleCollectionVersion.  # noqa: E501
        :rtype: str
        """
        return self._expected_name

    @expected_name.setter
    def expected_name(self, expected_name):
        """Sets the expected_name of this AnsibleCollectionVersion.

        The name of the collection.  # noqa: E501

        :param expected_name: The expected_name of this AnsibleCollectionVersion.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                expected_name is not None and len(expected_name) > 64):
            raise ValueError("Invalid value for `expected_name`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                expected_name is not None and len(expected_name) < 1):
            raise ValueError("Invalid value for `expected_name`, length must be greater than or equal to `1`")  # noqa: E501

        self._expected_name = expected_name

    @property
    def expected_namespace(self):
        """Gets the expected_namespace of this AnsibleCollectionVersion.  # noqa: E501

        The namespace of the collection.  # noqa: E501

        :return: The expected_namespace of this AnsibleCollectionVersion.  # noqa: E501
        :rtype: str
        """
        return self._expected_namespace

    @expected_namespace.setter
    def expected_namespace(self, expected_namespace):
        """Sets the expected_namespace of this AnsibleCollectionVersion.

        The namespace of the collection.  # noqa: E501

        :param expected_namespace: The expected_namespace of this AnsibleCollectionVersion.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                expected_namespace is not None and len(expected_namespace) > 64):
            raise ValueError("Invalid value for `expected_namespace`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                expected_namespace is not None and len(expected_namespace) < 1):
            raise ValueError("Invalid value for `expected_namespace`, length must be greater than or equal to `1`")  # noqa: E501

        self._expected_namespace = expected_namespace

    @property
    def expected_version(self):
        """Gets the expected_version of this AnsibleCollectionVersion.  # noqa: E501

        The version of the collection.  # noqa: E501

        :return: The expected_version of this AnsibleCollectionVersion.  # noqa: E501
        :rtype: str
        """
        return self._expected_version

    @expected_version.setter
    def expected_version(self, expected_version):
        """Sets the expected_version of this AnsibleCollectionVersion.

        The version of the collection.  # noqa: E501

        :param expected_version: The expected_version of this AnsibleCollectionVersion.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                expected_version is not None and len(expected_version) > 128):
            raise ValueError("Invalid value for `expected_version`, length must be less than or equal to `128`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                expected_version is not None and len(expected_version) < 1):
            raise ValueError("Invalid value for `expected_version`, length must be greater than or equal to `1`")  # noqa: E501

        self._expected_version = expected_version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AnsibleCollectionVersion):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AnsibleCollectionVersion):
            return True

        return self.to_dict() != other.to_dict()
