/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy;

import hex.genmodel.easy.CategoricalEncoder;
import java.util.HashMap;
import java.util.Map;

public class LabelEncoder
implements CategoricalEncoder {
    private final int targetIndex;
    private final Map<String, Integer> domainMap;

    public LabelEncoder(int targetIndex, String[] domainValues) {
        this.targetIndex = targetIndex;
        this.domainMap = new HashMap<String, Integer>();
        for (int j2 = 0; j2 < domainValues.length; ++j2) {
            this.domainMap.put(domainValues[j2], j2);
        }
    }

    @Override
    public boolean encodeCatValue(String levelName, double[] rawData) {
        Integer levelIndex = this.domainMap.get(levelName);
        if (levelIndex == null) {
            return false;
        }
        boolean useDomain = false;
        try {
            Integer.parseInt(levelName);
            useDomain = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        rawData[this.targetIndex] = useDomain ? (double)Integer.parseInt(levelName) : (double)levelIndex.intValue();
        return true;
    }

    @Override
    public void encodeNA(double[] rawData) {
        rawData[this.targetIndex] = Double.NaN;
    }
}

