/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.reporting;

import org.dmg.pmml.MathContext;
import org.jpmml.evaluator.Report;
import org.jpmml.evaluator.ReportFactory;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactoryFactory;
import org.jpmml.evaluator.Vector;
import org.jpmml.evaluator.reporting.ReportingComplexDoubleVector;
import org.jpmml.evaluator.reporting.ReportingComplexFloatVector;
import org.jpmml.evaluator.reporting.ReportingDoubleValue;
import org.jpmml.evaluator.reporting.ReportingFloatValue;
import org.jpmml.evaluator.reporting.ReportingSimpleDoubleVector;
import org.jpmml.evaluator.reporting.ReportingSimpleFloatVector;
import org.jpmml.evaluator.reporting.ReportingValueFactory;

public class ReportingValueFactoryFactory
extends ValueFactoryFactory {
    private ReportFactory reportFactory = null;

    protected ReportingValueFactoryFactory() {
    }

    public ReportingValueFactory<?> newValueFactory(MathContext mathContext) {
        ReportFactory reportFactory = this.getReportFactory();
        switch (mathContext) {
            case FLOAT: {
                return new ReportingFloatValueFactory(reportFactory);
            }
            case DOUBLE: {
                return new ReportingDoubleValueFactory(reportFactory);
            }
        }
        throw new IllegalArgumentException();
    }

    public ReportFactory getReportFactory() {
        return this.reportFactory;
    }

    public void setReportFactory(ReportFactory reportFactory) {
        this.reportFactory = reportFactory;
    }

    public static ReportingValueFactoryFactory newInstance() {
        return new ReportingValueFactoryFactory();
    }

    protected static class ReportingDoubleValueFactory
    extends ReportingValueFactory<Double> {
        protected ReportingDoubleValueFactory(ReportFactory reportFactory) {
            super(reportFactory);
        }

        public Value<Double> newValue() {
            return new ReportingDoubleValue(0.0, this.newReport(), null);
        }

        public Value<Double> newValue(Number value) {
            return new ReportingDoubleValue(value.doubleValue(), this.newReport());
        }

        public Value<Double> newValue(String value) {
            return new ReportingDoubleValue(Double.parseDouble(value), this.newReport());
        }

        public Vector<Double> newVector(int capacity) {
            if (capacity > 0) {
                return new ReportingComplexDoubleVector(capacity){

                    @Override
                    protected Report newReport() {
                        return this.newReport();
                    }
                };
            }
            return new ReportingSimpleDoubleVector(){

                @Override
                protected Report newReport() {
                    return this.newReport();
                }
            };
        }
    }

    protected static class ReportingFloatValueFactory
    extends ReportingValueFactory<Float> {
        protected ReportingFloatValueFactory(ReportFactory reportFactory) {
            super(reportFactory);
        }

        public Value<Float> newValue() {
            return new ReportingFloatValue(0.0f, this.newReport(), null);
        }

        public Value<Float> newValue(Number value) {
            return new ReportingFloatValue(value.floatValue(), this.newReport());
        }

        public Value<Float> newValue(String value) {
            return new ReportingFloatValue(Float.parseFloat(value), this.newReport());
        }

        public Vector<Float> newVector(int capacity) {
            if (capacity > 0) {
                return new ReportingComplexFloatVector(capacity){

                    @Override
                    protected Report newReport() {
                        return this.newReport();
                    }
                };
            }
            return new ReportingSimpleFloatVector(){

                @Override
                protected Report newReport() {
                    return this.newReport();
                }
            };
        }
    }
}

