/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.BinarySimilarity;
import org.dmg.pmml.Chebychev;
import org.dmg.pmml.CityBlock;
import org.dmg.pmml.CompareFunction;
import org.dmg.pmml.Euclidean;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Jaccard;
import org.dmg.pmml.Measure;
import org.dmg.pmml.Minkowski;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.SimpleMatching;
import org.dmg.pmml.SquaredEuclidean;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Tanimoto;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="ComparisonMeasure", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "measure"})
@JsonRootName(value="ComparisonMeasure")
@JsonPropertyOrder(value={"kind", "compareFunction", "minimum", "maximum", "extensions", "measure"})
public class ComparisonMeasure
extends PMMLObject
implements HasExtensions<ComparisonMeasure> {
    @XmlAttribute(name="kind", required=true)
    @JsonProperty(value="kind")
    private Kind kind;
    @XmlAttribute(name="compareFunction")
    @JsonProperty(value="compareFunction")
    private CompareFunction compareFunction;
    @XmlAttribute(name="minimum")
    @XmlJavaTypeAdapter(value=NumberAdapter.class)
    @JsonProperty(value="minimum")
    private Number minimum;
    @XmlAttribute(name="maximum")
    @XmlJavaTypeAdapter(value=NumberAdapter.class)
    @JsonProperty(value="maximum")
    private Number maximum;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElements(value={@XmlElement(name="euclidean", namespace="http://www.dmg.org/PMML-4_4", type=Euclidean.class), @XmlElement(name="squaredEuclidean", namespace="http://www.dmg.org/PMML-4_4", type=SquaredEuclidean.class), @XmlElement(name="chebychev", namespace="http://www.dmg.org/PMML-4_4", type=Chebychev.class), @XmlElement(name="cityBlock", namespace="http://www.dmg.org/PMML-4_4", type=CityBlock.class), @XmlElement(name="minkowski", namespace="http://www.dmg.org/PMML-4_4", type=Minkowski.class), @XmlElement(name="simpleMatching", namespace="http://www.dmg.org/PMML-4_4", type=SimpleMatching.class), @XmlElement(name="jaccard", namespace="http://www.dmg.org/PMML-4_4", type=Jaccard.class), @XmlElement(name="tanimoto", namespace="http://www.dmg.org/PMML-4_4", type=Tanimoto.class), @XmlElement(name="binarySimilarity", namespace="http://www.dmg.org/PMML-4_4", type=BinarySimilarity.class)})
    @JsonProperty(value="Measure")
    @JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
    @JsonSubTypes(value={@JsonSubTypes.Type(name="Euclidean", value=Euclidean.class), @JsonSubTypes.Type(name="SquaredEuclidean", value=SquaredEuclidean.class), @JsonSubTypes.Type(name="Chebychev", value=Chebychev.class), @JsonSubTypes.Type(name="CityBlock", value=CityBlock.class), @JsonSubTypes.Type(name="Minkowski", value=Minkowski.class), @JsonSubTypes.Type(name="SimpleMatching", value=SimpleMatching.class), @JsonSubTypes.Type(name="Jaccard", value=Jaccard.class), @JsonSubTypes.Type(name="Tanimoto", value=Tanimoto.class), @JsonSubTypes.Type(name="BinarySimilarity", value=BinarySimilarity.class)})
    private Measure measure;
    private static final long serialVersionUID = 0x4040003L;

    public ComparisonMeasure() {
    }

    @ValueConstructor
    public ComparisonMeasure(@Property(value="kind") Kind kind, @Property(value="measure") Measure measure) {
        this.kind = kind;
        this.measure = measure;
    }

    public Kind getKind() {
        return this.kind;
    }

    public ComparisonMeasure setKind(@Property(value="kind") Kind kind) {
        this.kind = kind;
        return this;
    }

    public CompareFunction getCompareFunction() {
        if (this.compareFunction == null) {
            return CompareFunction.ABS_DIFF;
        }
        return this.compareFunction;
    }

    public ComparisonMeasure setCompareFunction(@Property(value="compareFunction") CompareFunction compareFunction) {
        this.compareFunction = compareFunction;
        return this;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public ComparisonMeasure setMinimum(@Property(value="minimum") Number minimum) {
        this.minimum = minimum;
        return this;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public ComparisonMeasure setMaximum(@Property(value="maximum") Number maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ComparisonMeasure addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public ComparisonMeasure setMeasure(@Property(value="measure") Measure measure) {
        this.measure = measure;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getMeasure());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Kind implements StringValue<Kind>
    {
        DISTANCE("distance"),
        SIMILARITY("similarity");

        private final String value;

        private Kind(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static Kind fromValue(String v) {
            for (Kind c : Kind.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

