/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static Double[] readDoubles(DataInput dataInput, int count) throws IOException {
        Double[] result = new Double[count];
        for (int i = 0; i < count; ++i) {
            result[i] = dataInput.readDouble();
        }
        return result;
    }

    public static Double[][] readDoubleArrays(DataInput dataInput, int count, int length) throws IOException {
        Double[][] result = new Double[count][length];
        for (int i = 0; i < count; ++i) {
            result[i] = ResourceUtil.readDoubles(dataInput, length);
        }
        return result;
    }

    public static void writeDoubles(DataOutput dataOutput, Number[] numbers) throws IOException {
        for (Number number : numbers) {
            dataOutput.writeDouble(number.doubleValue());
        }
    }

    public static void writeDoubleArrays(DataOutput dataOutput, Number[][] numberArrays) throws IOException {
        for (Number[] numberArray : numberArrays) {
            ResourceUtil.writeDoubles(dataOutput, numberArray);
        }
    }

    public static Float[] readFloats(DataInput dataInput, int count) throws IOException {
        Float[] result = new Float[count];
        for (int i = 0; i < count; ++i) {
            result[i] = Float.valueOf(dataInput.readFloat());
        }
        return result;
    }

    public static Float[][] readFloatArrays(DataInput dataInput, int count, int length) throws IOException {
        Float[][] result = new Float[count][length];
        for (int i = 0; i < count; ++i) {
            result[i] = ResourceUtil.readFloats(dataInput, length);
        }
        return result;
    }

    public static void writeFloats(DataOutput dataOutput, Number[] numbers) throws IOException {
        for (Number number : numbers) {
            dataOutput.writeFloat(number.floatValue());
        }
    }

    public static void writeFloatArrays(DataOutput dataOutput, Number[][] numberArrays) throws IOException {
        for (Number[] numberArray : numberArrays) {
            ResourceUtil.writeFloats(dataOutput, numberArray);
        }
    }
}

