/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import java.util.List;
import java.util.ListIterator;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasDerivedFields;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.general_regression.BaseCumHazardTables;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.dmg.pmml.naive_bayes.BayesInput;
import org.dmg.pmml.naive_bayes.BayesInputs;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.RichDataField;
import org.jpmml.evaluator.RichDerivedField;
import org.jpmml.evaluator.RichOutputField;
import org.jpmml.evaluator.general_regression.RichBaseCumHazardTables;
import org.jpmml.evaluator.naive_bayes.RichBayesInput;
import org.jpmml.evaluator.visitors.AbstractParser;

public class MapHolderParser
extends AbstractParser {
    public VisitorAction visit(BayesInputs bayesInputs) {
        if (bayesInputs.hasBayesInputs()) {
            List content = bayesInputs.getBayesInputs();
            ListIterator<RichBayesInput> it = content.listIterator();
            while (it.hasNext()) {
                DataType dataType;
                BayesInput bayesInput = (BayesInput)it.next();
                FieldName name = bayesInput.getField();
                if (name == null) {
                    throw new MissingAttributeException((PMMLObject)bayesInput, org.dmg.pmml.naive_bayes.PMMLAttributes.BAYESINPUT_FIELD);
                }
                DerivedField derivedField = bayesInput.getDerivedField();
                if (derivedField != null) {
                    dataType = derivedField.getDataType();
                    if (dataType == null) {
                        throw new MissingAttributeException((PMMLObject)derivedField, PMMLAttributes.DERIVEDFIELD_DATATYPE);
                    }
                } else {
                    dataType = this.resolveDataType(name);
                }
                if (dataType == null) continue;
                it.set(new RichBayesInput(dataType, bayesInput));
            }
        }
        return super.visit(bayesInputs);
    }

    public VisitorAction visit(DataDictionary dataDictionary) {
        if (dataDictionary.hasDataFields()) {
            List dataFields = dataDictionary.getDataFields();
            ListIterator<RichDataField> it = dataFields.listIterator();
            while (it.hasNext()) {
                DataField dataField = (DataField)it.next();
                if (!dataField.hasValues()) continue;
                it.set(new RichDataField(dataField));
            }
        }
        return super.visit(dataDictionary);
    }

    public VisitorAction visit(GeneralRegressionModel generalRegressionModel) {
        DataType dataType;
        FieldName baselineStrataVariable;
        BaseCumHazardTables baseCumHazardTables = generalRegressionModel.getBaseCumHazardTables();
        if (baseCumHazardTables != null && (baselineStrataVariable = generalRegressionModel.getBaselineStrataVariable()) != null && (dataType = this.resolveDataType(baselineStrataVariable)) != null) {
            generalRegressionModel.setBaseCumHazardTables((BaseCumHazardTables)new RichBaseCumHazardTables(dataType, baseCumHazardTables));
        }
        return super.visit(generalRegressionModel);
    }

    public VisitorAction visit(LocalTransformations localTransformations) {
        this.processDerivedFields((HasDerivedFields<?>)localTransformations);
        return super.visit(localTransformations);
    }

    public VisitorAction visit(Output output) {
        if (output.hasOutputFields()) {
            List outputFields = output.getOutputFields();
            ListIterator<RichOutputField> it = outputFields.listIterator();
            while (it.hasNext()) {
                OutputField outputField = (OutputField)it.next();
                if (!outputField.hasValues()) continue;
                it.set(new RichOutputField(outputField));
            }
        }
        return super.visit(output);
    }

    public VisitorAction visit(TransformationDictionary transformationDictionary) {
        this.processDerivedFields((HasDerivedFields<?>)transformationDictionary);
        return super.visit(transformationDictionary);
    }

    private void processDerivedFields(HasDerivedFields<?> hasDerivedFields) {
        if (hasDerivedFields.hasDerivedFields()) {
            List derivedFields = hasDerivedFields.getDerivedFields();
            ListIterator<RichDerivedField> it = derivedFields.listIterator();
            while (it.hasNext()) {
                DerivedField derivedField = (DerivedField)it.next();
                if (!derivedField.hasValues()) continue;
                it.set(new RichDerivedField(derivedField));
            }
        }
    }
}

