"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SpaDistribution = exports.StaticSiteDistribution = exports.BaseDistribution = void 0;
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_cloudfront_origins_1 = require("@aws-cdk/aws-cloudfront-origins");
const core_1 = require("@aws-cdk/core");
const cdk_deletable_bucket_1 = require("@cloudcomponents/cdk-deletable-bucket");
class BaseDistribution extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b, _c, _d, _e, _f, _g;
        super(scope, id);
        const removalPolicy = (_a = props.removalPolicy) !== null && _a !== void 0 ? _a : core_1.RemovalPolicy.DESTROY;
        const origin = (_b = props.origin) !== null && _b !== void 0 ? _b : this.defaultOrigin(removalPolicy === core_1.RemovalPolicy.DESTROY);
        const distribution = new aws_cloudfront_1.Distribution(this, 'Distribution', {
            enabled: (_c = props.enabled) !== null && _c !== void 0 ? _c : true,
            enableIpv6: (_d = props.enableIpv6) !== null && _d !== void 0 ? _d : true,
            comment: props.comment,
            enableLogging: props.enableLogging,
            logBucket: props.logBucket,
            logIncludesCookies: props.logIncludesCookies,
            logFilePrefix: props.logFilePrefix,
            priceClass: (_e = props.priceClass) !== null && _e !== void 0 ? _e : aws_cloudfront_1.PriceClass.PRICE_CLASS_100,
            geoRestriction: props.geoRestriction,
            httpVersion: (_f = props.httpVersion) !== null && _f !== void 0 ? _f : aws_cloudfront_1.HttpVersion.HTTP2,
            webAclId: props.webAclId,
            errorResponses: props.errorResponses,
            domainNames: props.domainNames,
            certificate: props.certificate,
            defaultBehavior: props.authorization.createDefaultBehavior(origin),
            additionalBehaviors: props.authorization.createAdditionalBehaviors(origin),
            defaultRootObject: (_g = props.defaultRootObject) !== null && _g !== void 0 ? _g : 'index.html',
        });
        props.authorization.updateUserPoolClientCallbacks({
            callbackUrls: [`https://${distribution.distributionDomainName}${props.authorization.redirectPaths.signIn}`],
            logoutUrls: [`https://${distribution.distributionDomainName}${props.authorization.redirectPaths.signOut}`],
        });
    }
    defaultOrigin(forceDelete) {
        const bucket = new cdk_deletable_bucket_1.DeletableBucket(this, 'DeletableBucket', {
            forceDelete,
        });
        return new aws_cloudfront_origins_1.S3Origin(bucket);
    }
}
exports.BaseDistribution = BaseDistribution;
class StaticSiteDistribution extends BaseDistribution {
    constructor(scope, id, props) {
        super(scope, id, props);
    }
}
exports.StaticSiteDistribution = StaticSiteDistribution;
class SpaDistribution extends BaseDistribution {
    constructor(scope, id, props) {
        var _a;
        super(scope, id, {
            ...props,
            errorResponses: [
                {
                    httpStatus: 404,
                    responseHttpStatus: 200,
                    ttl: (_a = props.ttl) !== null && _a !== void 0 ? _a : core_1.Duration.seconds(300),
                    responsePagePath: '/index.html',
                },
            ],
        });
    }
}
exports.SpaDistribution = SpaDistribution;
//# sourceMappingURL=data:application/json;base64,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