"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosUsers = exports.RosCluster = exports.RosAutoScaleConfig = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosAutoScaleConfigProps`
 *
 * @param properties - the TypeScript properties of a `RosAutoScaleConfigProps`
 *
 * @returns the result of the validation.
 */
function RosAutoScaleConfigPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.extraNodesGrowRatio && (typeof properties.extraNodesGrowRatio) !== 'object') {
        errors.collect(ros.propertyValidator('extraNodesGrowRatio', ros.validateRange)({
            data: properties.extraNodesGrowRatio,
            min: 0,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('extraNodesGrowRatio', ros.validateNumber)(properties.extraNodesGrowRatio));
    errors.collect(ros.propertyValidator('enableAutoGrow', ros.validateBoolean)(properties.enableAutoGrow));
    errors.collect(ros.propertyValidator('clusterId', ros.requiredValidator)(properties.clusterId));
    errors.collect(ros.propertyValidator('clusterId', ros.validateString)(properties.clusterId));
    if (properties.shrinkIdleTimes && (typeof properties.shrinkIdleTimes) !== 'object') {
        errors.collect(ros.propertyValidator('shrinkIdleTimes', ros.validateRange)({
            data: properties.shrinkIdleTimes,
            min: 2,
            max: 5,
        }));
    }
    errors.collect(ros.propertyValidator('shrinkIdleTimes', ros.validateNumber)(properties.shrinkIdleTimes));
    if (properties.maxNodesInCluster && (typeof properties.maxNodesInCluster) !== 'object') {
        errors.collect(ros.propertyValidator('maxNodesInCluster', ros.validateRange)({
            data: properties.maxNodesInCluster,
            min: 1,
            max: 500,
        }));
    }
    errors.collect(ros.propertyValidator('maxNodesInCluster', ros.validateNumber)(properties.maxNodesInCluster));
    errors.collect(ros.propertyValidator('enableAutoShrink', ros.validateBoolean)(properties.enableAutoShrink));
    if (properties.growRatio && (typeof properties.growRatio) !== 'object') {
        errors.collect(ros.propertyValidator('growRatio', ros.validateRange)({
            data: properties.growRatio,
            min: 1,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('growRatio', ros.validateNumber)(properties.growRatio));
    if (properties.growIntervalInMinutes && (typeof properties.growIntervalInMinutes) !== 'object') {
        errors.collect(ros.propertyValidator('growIntervalInMinutes', ros.validateRange)({
            data: properties.growIntervalInMinutes,
            min: 2,
            max: 10,
        }));
    }
    errors.collect(ros.propertyValidator('growIntervalInMinutes', ros.validateNumber)(properties.growIntervalInMinutes));
    if (properties.growTimeoutInMinutes && (typeof properties.growTimeoutInMinutes) !== 'object') {
        errors.collect(ros.propertyValidator('growTimeoutInMinutes', ros.validateRange)({
            data: properties.growTimeoutInMinutes,
            min: 10,
            max: 60,
        }));
    }
    errors.collect(ros.propertyValidator('growTimeoutInMinutes', ros.validateNumber)(properties.growTimeoutInMinutes));
    errors.collect(ros.propertyValidator('imageId', ros.validateString)(properties.imageId));
    if (properties.shrinkIntervalInMinutes && (typeof properties.shrinkIntervalInMinutes) !== 'object') {
        errors.collect(ros.propertyValidator('shrinkIntervalInMinutes', ros.validateRange)({
            data: properties.shrinkIntervalInMinutes,
            min: 2,
            max: 10,
        }));
    }
    errors.collect(ros.propertyValidator('shrinkIntervalInMinutes', ros.validateNumber)(properties.shrinkIntervalInMinutes));
    errors.collect(ros.propertyValidator('spotPriceLimit', ros.validateNumber)(properties.spotPriceLimit));
    if (properties.queues && (Array.isArray(properties.queues) || (typeof properties.queues) === 'string')) {
        errors.collect(ros.propertyValidator('queues', ros.validateLength)({
            data: properties.queues.length,
            min: undefined,
            max: 8,
        }));
    }
    errors.collect(ros.propertyValidator('queues', ros.listValidator(RosAutoScaleConfig_QueuesPropertyValidator))(properties.queues));
    errors.collect(ros.propertyValidator('excludeNodes', ros.validateString)(properties.excludeNodes));
    if (properties.spotStrategy && (typeof properties.spotStrategy) !== 'object') {
        errors.collect(ros.propertyValidator('spotStrategy', ros.validateAllowedValues)({
            data: properties.spotStrategy,
            allowedValues: ["NoSpot", "SpotWithPriceLimit", "SpotAsPriceGo"],
        }));
    }
    errors.collect(ros.propertyValidator('spotStrategy', ros.validateString)(properties.spotStrategy));
    return errors.wrap('supplied properties not correct for "RosAutoScaleConfigProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::AutoScaleConfig` resource
 *
 * @param properties - the TypeScript properties of a `RosAutoScaleConfigProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::AutoScaleConfig` resource.
 */
// @ts-ignore TS6133
function rosAutoScaleConfigPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosAutoScaleConfigPropsValidator(properties).assertSuccess();
    }
    return {
        'ClusterId': ros.stringToRosTemplate(properties.clusterId),
        'EnableAutoGrow': ros.booleanToRosTemplate(properties.enableAutoGrow),
        'EnableAutoShrink': ros.booleanToRosTemplate(properties.enableAutoShrink),
        'ExcludeNodes': ros.stringToRosTemplate(properties.excludeNodes),
        'ExtraNodesGrowRatio': ros.numberToRosTemplate(properties.extraNodesGrowRatio),
        'GrowIntervalInMinutes': ros.numberToRosTemplate(properties.growIntervalInMinutes),
        'GrowRatio': ros.numberToRosTemplate(properties.growRatio),
        'GrowTimeoutInMinutes': ros.numberToRosTemplate(properties.growTimeoutInMinutes),
        'ImageId': ros.stringToRosTemplate(properties.imageId),
        'MaxNodesInCluster': ros.numberToRosTemplate(properties.maxNodesInCluster),
        'Queues': ros.listMapper(rosAutoScaleConfigQueuesPropertyToRosTemplate)(properties.queues),
        'ShrinkIdleTimes': ros.numberToRosTemplate(properties.shrinkIdleTimes),
        'ShrinkIntervalInMinutes': ros.numberToRosTemplate(properties.shrinkIntervalInMinutes),
        'SpotPriceLimit': ros.numberToRosTemplate(properties.spotPriceLimit),
        'SpotStrategy': ros.stringToRosTemplate(properties.spotStrategy),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::EHPC::AutoScaleConfig`, which is used to configure the auto scaling settings of a cluster.
 * @Note This class does not contain additional functions, so it is recommended to use the `AutoScaleConfig` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ehpc-autoscaleconfig
 */
class RosAutoScaleConfig extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosAutoScaleConfig.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrClusterId = this.getAtt('ClusterId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.clusterId = props.clusterId;
        this.enableAutoGrow = props.enableAutoGrow;
        this.enableAutoShrink = props.enableAutoShrink;
        this.excludeNodes = props.excludeNodes;
        this.extraNodesGrowRatio = props.extraNodesGrowRatio;
        this.growIntervalInMinutes = props.growIntervalInMinutes;
        this.growRatio = props.growRatio;
        this.growTimeoutInMinutes = props.growTimeoutInMinutes;
        this.imageId = props.imageId;
        this.maxNodesInCluster = props.maxNodesInCluster;
        this.queues = props.queues;
        this.shrinkIdleTimes = props.shrinkIdleTimes;
        this.shrinkIntervalInMinutes = props.shrinkIntervalInMinutes;
        this.spotPriceLimit = props.spotPriceLimit;
        this.spotStrategy = props.spotStrategy;
    }
    get rosProperties() {
        return {
            clusterId: this.clusterId,
            enableAutoGrow: this.enableAutoGrow,
            enableAutoShrink: this.enableAutoShrink,
            excludeNodes: this.excludeNodes,
            extraNodesGrowRatio: this.extraNodesGrowRatio,
            growIntervalInMinutes: this.growIntervalInMinutes,
            growRatio: this.growRatio,
            growTimeoutInMinutes: this.growTimeoutInMinutes,
            imageId: this.imageId,
            maxNodesInCluster: this.maxNodesInCluster,
            queues: this.queues,
            shrinkIdleTimes: this.shrinkIdleTimes,
            shrinkIntervalInMinutes: this.shrinkIntervalInMinutes,
            spotPriceLimit: this.spotPriceLimit,
            spotStrategy: this.spotStrategy,
        };
    }
    renderProperties(props) {
        return rosAutoScaleConfigPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosAutoScaleConfig = RosAutoScaleConfig;
/**
 * The resource type name for this resource class.
 */
RosAutoScaleConfig.ROS_RESOURCE_TYPE_NAME = "ALIYUN::EHPC::AutoScaleConfig";
/**
 * Determine whether the given properties match those of a `DataDisksProperty`
 *
 * @param properties - the TypeScript properties of a `DataDisksProperty`
 *
 * @returns the result of the validation.
 */
function RosAutoScaleConfig_DataDisksPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('dataDiskKmsKeyId', ros.validateString)(properties.dataDiskKmsKeyId));
    errors.collect(ros.propertyValidator('dataDiskPerformanceLevel', ros.validateString)(properties.dataDiskPerformanceLevel));
    errors.collect(ros.propertyValidator('dataDiskEncrypted', ros.validateBoolean)(properties.dataDiskEncrypted));
    errors.collect(ros.propertyValidator('dataDiskDeleteWithInstance', ros.validateBoolean)(properties.dataDiskDeleteWithInstance));
    if (properties.dataDiskSize && (typeof properties.dataDiskSize) !== 'object') {
        errors.collect(ros.propertyValidator('dataDiskSize', ros.validateRange)({
            data: properties.dataDiskSize,
            min: 40,
            max: 500,
        }));
    }
    errors.collect(ros.propertyValidator('dataDiskSize', ros.validateNumber)(properties.dataDiskSize));
    errors.collect(ros.propertyValidator('dataDiskCategory', ros.validateString)(properties.dataDiskCategory));
    return errors.wrap('supplied properties not correct for "DataDisksProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::AutoScaleConfig.DataDisks` resource
 *
 * @param properties - the TypeScript properties of a `DataDisksProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::AutoScaleConfig.DataDisks` resource.
 */
// @ts-ignore TS6133
function rosAutoScaleConfigDataDisksPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosAutoScaleConfig_DataDisksPropertyValidator(properties).assertSuccess();
    return {
        'DataDiskKMSKeyId': ros.stringToRosTemplate(properties.dataDiskKmsKeyId),
        'DataDiskPerformanceLevel': ros.stringToRosTemplate(properties.dataDiskPerformanceLevel),
        'DataDiskEncrypted': ros.booleanToRosTemplate(properties.dataDiskEncrypted),
        'DataDiskDeleteWithInstance': ros.booleanToRosTemplate(properties.dataDiskDeleteWithInstance),
        'DataDiskSize': ros.numberToRosTemplate(properties.dataDiskSize),
        'DataDiskCategory': ros.stringToRosTemplate(properties.dataDiskCategory),
    };
}
/**
 * Determine whether the given properties match those of a `InstanceTypesProperty`
 *
 * @param properties - the TypeScript properties of a `InstanceTypesProperty`
 *
 * @returns the result of the validation.
 */
function RosAutoScaleConfig_InstanceTypesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('zoneId', ros.requiredValidator)(properties.zoneId));
    errors.collect(ros.propertyValidator('zoneId', ros.validateString)(properties.zoneId));
    errors.collect(ros.propertyValidator('vSwitchId', ros.requiredValidator)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('spotPriceLimit', ros.validateNumber)(properties.spotPriceLimit));
    errors.collect(ros.propertyValidator('instanceType', ros.requiredValidator)(properties.instanceType));
    errors.collect(ros.propertyValidator('instanceType', ros.validateString)(properties.instanceType));
    if (properties.spotStrategy && (typeof properties.spotStrategy) !== 'object') {
        errors.collect(ros.propertyValidator('spotStrategy', ros.validateAllowedValues)({
            data: properties.spotStrategy,
            allowedValues: ["NoSpot", "SpotWithPriceLimit", "SpotAsPriceGo"],
        }));
    }
    errors.collect(ros.propertyValidator('spotStrategy', ros.validateString)(properties.spotStrategy));
    return errors.wrap('supplied properties not correct for "InstanceTypesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::AutoScaleConfig.InstanceTypes` resource
 *
 * @param properties - the TypeScript properties of a `InstanceTypesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::AutoScaleConfig.InstanceTypes` resource.
 */
// @ts-ignore TS6133
function rosAutoScaleConfigInstanceTypesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosAutoScaleConfig_InstanceTypesPropertyValidator(properties).assertSuccess();
    return {
        'ZoneId': ros.stringToRosTemplate(properties.zoneId),
        'VSwitchId': ros.stringToRosTemplate(properties.vSwitchId),
        'SpotPriceLimit': ros.numberToRosTemplate(properties.spotPriceLimit),
        'InstanceType': ros.stringToRosTemplate(properties.instanceType),
        'SpotStrategy': ros.stringToRosTemplate(properties.spotStrategy),
    };
}
/**
 * Determine whether the given properties match those of a `QueuesProperty`
 *
 * @param properties - the TypeScript properties of a `QueuesProperty`
 *
 * @returns the result of the validation.
 */
function RosAutoScaleConfig_QueuesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('hostNameSuffix', ros.validateString)(properties.hostNameSuffix));
    if (properties.minNodesInQueue && (typeof properties.minNodesInQueue) !== 'object') {
        errors.collect(ros.propertyValidator('minNodesInQueue', ros.validateRange)({
            data: properties.minNodesInQueue,
            min: 0,
            max: 50,
        }));
    }
    errors.collect(ros.propertyValidator('minNodesInQueue', ros.validateNumber)(properties.minNodesInQueue));
    if (properties.maxNodesInQueue && (typeof properties.maxNodesInQueue) !== 'object') {
        errors.collect(ros.propertyValidator('maxNodesInQueue', ros.validateRange)({
            data: properties.maxNodesInQueue,
            min: 0,
            max: 500,
        }));
    }
    errors.collect(ros.propertyValidator('maxNodesInQueue', ros.validateNumber)(properties.maxNodesInQueue));
    errors.collect(ros.propertyValidator('enableAutoGrow', ros.validateBoolean)(properties.enableAutoGrow));
    if (properties.dataDisks && (Array.isArray(properties.dataDisks) || (typeof properties.dataDisks) === 'string')) {
        errors.collect(ros.propertyValidator('dataDisks', ros.validateLength)({
            data: properties.dataDisks.length,
            min: undefined,
            max: 16,
        }));
    }
    errors.collect(ros.propertyValidator('dataDisks', ros.listValidator(RosAutoScaleConfig_DataDisksPropertyValidator))(properties.dataDisks));
    if (properties.systemDiskSize && (typeof properties.systemDiskSize) !== 'object') {
        errors.collect(ros.propertyValidator('systemDiskSize', ros.validateRange)({
            data: properties.systemDiskSize,
            min: 40,
            max: 500,
        }));
    }
    errors.collect(ros.propertyValidator('systemDiskSize', ros.validateNumber)(properties.systemDiskSize));
    errors.collect(ros.propertyValidator('systemDiskLevel', ros.validateString)(properties.systemDiskLevel));
    errors.collect(ros.propertyValidator('queueImageId', ros.validateString)(properties.queueImageId));
    if (properties.minNodesPerCycle && (typeof properties.minNodesPerCycle) !== 'object') {
        errors.collect(ros.propertyValidator('minNodesPerCycle', ros.validateRange)({
            data: properties.minNodesPerCycle,
            min: 1,
            max: 99,
        }));
    }
    errors.collect(ros.propertyValidator('minNodesPerCycle', ros.validateNumber)(properties.minNodesPerCycle));
    if (properties.maxNodesPerCycle && (typeof properties.maxNodesPerCycle) !== 'object') {
        errors.collect(ros.propertyValidator('maxNodesPerCycle', ros.validateRange)({
            data: properties.maxNodesPerCycle,
            min: 0,
            max: 99,
        }));
    }
    errors.collect(ros.propertyValidator('maxNodesPerCycle', ros.validateNumber)(properties.maxNodesPerCycle));
    errors.collect(ros.propertyValidator('enableAutoShrink', ros.validateBoolean)(properties.enableAutoShrink));
    errors.collect(ros.propertyValidator('systemDiskCategory', ros.validateString)(properties.systemDiskCategory));
    errors.collect(ros.propertyValidator('hostNamePrefix', ros.validateString)(properties.hostNamePrefix));
    errors.collect(ros.propertyValidator('spotPriceLimit', ros.validateNumber)(properties.spotPriceLimit));
    if (properties.instanceTypes && (Array.isArray(properties.instanceTypes) || (typeof properties.instanceTypes) === 'string')) {
        errors.collect(ros.propertyValidator('instanceTypes', ros.validateLength)({
            data: properties.instanceTypes.length,
            min: undefined,
            max: 500,
        }));
    }
    errors.collect(ros.propertyValidator('instanceTypes', ros.listValidator(RosAutoScaleConfig_InstanceTypesPropertyValidator))(properties.instanceTypes));
    errors.collect(ros.propertyValidator('instanceType', ros.validateString)(properties.instanceType));
    errors.collect(ros.propertyValidator('queueName', ros.validateString)(properties.queueName));
    if (properties.spotStrategy && (typeof properties.spotStrategy) !== 'object') {
        errors.collect(ros.propertyValidator('spotStrategy', ros.validateAllowedValues)({
            data: properties.spotStrategy,
            allowedValues: ["NoSpot", "SpotWithPriceLimit", "SpotAsPriceGo"],
        }));
    }
    errors.collect(ros.propertyValidator('spotStrategy', ros.validateString)(properties.spotStrategy));
    return errors.wrap('supplied properties not correct for "QueuesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::AutoScaleConfig.Queues` resource
 *
 * @param properties - the TypeScript properties of a `QueuesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::AutoScaleConfig.Queues` resource.
 */
// @ts-ignore TS6133
function rosAutoScaleConfigQueuesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosAutoScaleConfig_QueuesPropertyValidator(properties).assertSuccess();
    return {
        'HostNameSuffix': ros.stringToRosTemplate(properties.hostNameSuffix),
        'MinNodesInQueue': ros.numberToRosTemplate(properties.minNodesInQueue),
        'MaxNodesInQueue': ros.numberToRosTemplate(properties.maxNodesInQueue),
        'EnableAutoGrow': ros.booleanToRosTemplate(properties.enableAutoGrow),
        'DataDisks': ros.listMapper(rosAutoScaleConfigDataDisksPropertyToRosTemplate)(properties.dataDisks),
        'SystemDiskSize': ros.numberToRosTemplate(properties.systemDiskSize),
        'SystemDiskLevel': ros.stringToRosTemplate(properties.systemDiskLevel),
        'QueueImageId': ros.stringToRosTemplate(properties.queueImageId),
        'MinNodesPerCycle': ros.numberToRosTemplate(properties.minNodesPerCycle),
        'MaxNodesPerCycle': ros.numberToRosTemplate(properties.maxNodesPerCycle),
        'EnableAutoShrink': ros.booleanToRosTemplate(properties.enableAutoShrink),
        'SystemDiskCategory': ros.stringToRosTemplate(properties.systemDiskCategory),
        'HostNamePrefix': ros.stringToRosTemplate(properties.hostNamePrefix),
        'SpotPriceLimit': ros.numberToRosTemplate(properties.spotPriceLimit),
        'InstanceTypes': ros.listMapper(rosAutoScaleConfigInstanceTypesPropertyToRosTemplate)(properties.instanceTypes),
        'InstanceType': ros.stringToRosTemplate(properties.instanceType),
        'QueueName': ros.stringToRosTemplate(properties.queueName),
        'SpotStrategy': ros.stringToRosTemplate(properties.spotStrategy),
    };
}
/**
 * Determine whether the given properties match those of a `RosClusterProps`
 *
 * @param properties - the TypeScript properties of a `RosClusterProps`
 *
 * @returns the result of the validation.
 */
function RosClusterPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('volumeProtocol', ros.validateString)(properties.volumeProtocol));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('computeEnableHt', ros.validateBoolean)(properties.computeEnableHt));
    errors.collect(ros.propertyValidator('withoutElasticIp', ros.validateBoolean)(properties.withoutElasticIp));
    errors.collect(ros.propertyValidator('systemDiskType', ros.validateString)(properties.systemDiskType));
    errors.collect(ros.propertyValidator('remoteVisEnable', ros.validateBoolean)(properties.remoteVisEnable));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    errors.collect(ros.propertyValidator('volumeId', ros.validateString)(properties.volumeId));
    errors.collect(ros.propertyValidator('ramRoleName', ros.validateString)(properties.ramRoleName));
    errors.collect(ros.propertyValidator('deployMode', ros.validateString)(properties.deployMode));
    if (properties.postInstallScript && (Array.isArray(properties.postInstallScript) || (typeof properties.postInstallScript) === 'string')) {
        errors.collect(ros.propertyValidator('postInstallScript', ros.validateLength)({
            data: properties.postInstallScript.length,
            min: undefined,
            max: 16,
        }));
    }
    errors.collect(ros.propertyValidator('postInstallScript', ros.listValidator(RosCluster_PostInstallScriptPropertyValidator))(properties.postInstallScript));
    errors.collect(ros.propertyValidator('imageId', ros.validateString)(properties.imageId));
    errors.collect(ros.propertyValidator('isComputeEss', ros.validateBoolean)(properties.isComputeEss));
    errors.collect(ros.propertyValidator('ecsOrderLoginInstanceType', ros.requiredValidator)(properties.ecsOrderLoginInstanceType));
    errors.collect(ros.propertyValidator('ecsOrderLoginInstanceType', ros.validateString)(properties.ecsOrderLoginInstanceType));
    errors.collect(ros.propertyValidator('jobQueue', ros.validateString)(properties.jobQueue));
    errors.collect(ros.propertyValidator('vSwitchId', ros.requiredValidator)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    if (properties.computeSpotStrategy && (typeof properties.computeSpotStrategy) !== 'object') {
        errors.collect(ros.propertyValidator('computeSpotStrategy', ros.validateAllowedValues)({
            data: properties.computeSpotStrategy,
            allowedValues: ["NoSpot", "SpotWithPriceLimit", "SpotAsPriceGo"],
        }));
    }
    errors.collect(ros.propertyValidator('computeSpotStrategy', ros.validateString)(properties.computeSpotStrategy));
    errors.collect(ros.propertyValidator('ecsOrderManagerInstanceType', ros.requiredValidator)(properties.ecsOrderManagerInstanceType));
    errors.collect(ros.propertyValidator('ecsOrderManagerInstanceType', ros.validateString)(properties.ecsOrderManagerInstanceType));
    errors.collect(ros.propertyValidator('ehpcVersion', ros.validateString)(properties.ehpcVersion));
    errors.collect(ros.propertyValidator('volumeMountpoint', ros.validateString)(properties.volumeMountpoint));
    errors.collect(ros.propertyValidator('ecsOrderManagerCount', ros.validateNumber)(properties.ecsOrderManagerCount));
    errors.collect(ros.propertyValidator('ecsOrderComputeInstanceType', ros.requiredValidator)(properties.ecsOrderComputeInstanceType));
    errors.collect(ros.propertyValidator('ecsOrderComputeInstanceType', ros.validateString)(properties.ecsOrderComputeInstanceType));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    if (properties.application && (Array.isArray(properties.application) || (typeof properties.application) === 'string')) {
        errors.collect(ros.propertyValidator('application', ros.validateLength)({
            data: properties.application.length,
            min: undefined,
            max: 10,
        }));
    }
    errors.collect(ros.propertyValidator('application', ros.listValidator(RosCluster_ApplicationPropertyValidator))(properties.application));
    if (properties.periodUnit && (typeof properties.periodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('periodUnit', ros.validateAllowedValues)({
            data: properties.periodUnit,
            allowedValues: ["Week", "Month", "Year"],
        }));
    }
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    if (properties.imageOwnerAlias && (typeof properties.imageOwnerAlias) !== 'object') {
        errors.collect(ros.propertyValidator('imageOwnerAlias', ros.validateAllowedValues)({
            data: properties.imageOwnerAlias,
            allowedValues: ["system", "self", "others", "marketplace"],
        }));
    }
    errors.collect(ros.propertyValidator('imageOwnerAlias', ros.validateString)(properties.imageOwnerAlias));
    errors.collect(ros.propertyValidator('ecsOrderComputeCount', ros.requiredValidator)(properties.ecsOrderComputeCount));
    if (properties.ecsOrderComputeCount && (typeof properties.ecsOrderComputeCount) !== 'object') {
        errors.collect(ros.propertyValidator('ecsOrderComputeCount', ros.validateRange)({
            data: properties.ecsOrderComputeCount,
            min: 0,
            max: 99,
        }));
    }
    errors.collect(ros.propertyValidator('ecsOrderComputeCount', ros.validateNumber)(properties.ecsOrderComputeCount));
    if (properties.description && (Array.isArray(properties.description) || (typeof properties.description) === 'string')) {
        errors.collect(ros.propertyValidator('description', ros.validateLength)({
            data: properties.description.length,
            min: 2,
            max: 128,
        }));
    }
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('securityGroupName', ros.validateString)(properties.securityGroupName));
    errors.collect(ros.propertyValidator('systemDiskSize', ros.validateNumber)(properties.systemDiskSize));
    if (properties.additionalVolumes && (Array.isArray(properties.additionalVolumes) || (typeof properties.additionalVolumes) === 'string')) {
        errors.collect(ros.propertyValidator('additionalVolumes', ros.validateLength)({
            data: properties.additionalVolumes.length,
            min: undefined,
            max: 10,
        }));
    }
    errors.collect(ros.propertyValidator('additionalVolumes', ros.listValidator(RosCluster_AdditionalVolumesPropertyValidator))(properties.additionalVolumes));
    errors.collect(ros.propertyValidator('autoRenew', ros.validateBoolean)(properties.autoRenew));
    errors.collect(ros.propertyValidator('computeSpotPriceLimit', ros.validateString)(properties.computeSpotPriceLimit));
    if (properties.ramNodeTypes && (Array.isArray(properties.ramNodeTypes) || (typeof properties.ramNodeTypes) === 'string')) {
        errors.collect(ros.propertyValidator('ramNodeTypes', ros.validateLength)({
            data: properties.ramNodeTypes.length,
            min: undefined,
            max: 4,
        }));
    }
    errors.collect(ros.propertyValidator('ramNodeTypes', ros.listValidator(ros.validateString))(properties.ramNodeTypes));
    errors.collect(ros.propertyValidator('clientVersion', ros.validateString)(properties.clientVersion));
    errors.collect(ros.propertyValidator('volumeType', ros.validateString)(properties.volumeType));
    errors.collect(ros.propertyValidator('inputFileUrl', ros.validateString)(properties.inputFileUrl));
    if (properties.password && (Array.isArray(properties.password) || (typeof properties.password) === 'string')) {
        errors.collect(ros.propertyValidator('password', ros.validateLength)({
            data: properties.password.length,
            min: 8,
            max: 30,
        }));
    }
    errors.collect(ros.propertyValidator('password', ros.validateString)(properties.password));
    errors.collect(ros.propertyValidator('autoRenewPeriod', ros.validateNumber)(properties.autoRenewPeriod));
    errors.collect(ros.propertyValidator('keyPairName', ros.validateString)(properties.keyPairName));
    errors.collect(ros.propertyValidator('remoteDirectory', ros.validateString)(properties.remoteDirectory));
    errors.collect(ros.propertyValidator('networkInterfaceTrafficMode', ros.validateString)(properties.networkInterfaceTrafficMode));
    errors.collect(ros.propertyValidator('sccClusterId', ros.validateString)(properties.sccClusterId));
    errors.collect(ros.propertyValidator('zoneId', ros.validateString)(properties.zoneId));
    errors.collect(ros.propertyValidator('systemDiskLevel', ros.validateString)(properties.systemDiskLevel));
    errors.collect(ros.propertyValidator('ecsOrderLoginCount', ros.requiredValidator)(properties.ecsOrderLoginCount));
    if (properties.ecsOrderLoginCount && (typeof properties.ecsOrderLoginCount) !== 'object') {
        errors.collect(ros.propertyValidator('ecsOrderLoginCount', ros.validateRange)({
            data: properties.ecsOrderLoginCount,
            min: 1,
            max: 1,
        }));
    }
    errors.collect(ros.propertyValidator('ecsOrderLoginCount', ros.validateNumber)(properties.ecsOrderLoginCount));
    errors.collect(ros.propertyValidator('securityGroupId', ros.validateString)(properties.securityGroupId));
    errors.collect(ros.propertyValidator('schedulerType', ros.validateString)(properties.schedulerType));
    errors.collect(ros.propertyValidator('accountType', ros.validateString)(properties.accountType));
    errors.collect(ros.propertyValidator('haEnable', ros.validateBoolean)(properties.haEnable));
    errors.collect(ros.propertyValidator('osTag', ros.requiredValidator)(properties.osTag));
    errors.collect(ros.propertyValidator('osTag', ros.validateString)(properties.osTag));
    if (properties.ecsChargeType && (typeof properties.ecsChargeType) !== 'object') {
        errors.collect(ros.propertyValidator('ecsChargeType', ros.validateAllowedValues)({
            data: properties.ecsChargeType,
            allowedValues: ["PayAsYouGo", "PostPaid", "PayOnDemand", "Postpaid", "PostPay", "Postpay", "POSTPAY", "POST", "Subscription", "PrePaid", "Prepaid", "PrePay", "Prepay", "PREPAY", "PRE"],
        }));
    }
    errors.collect(ros.propertyValidator('ecsChargeType', ros.validateString)(properties.ecsChargeType));
    return errors.wrap('supplied properties not correct for "RosClusterProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster` resource
 *
 * @param properties - the TypeScript properties of a `RosClusterProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster` resource.
 */
// @ts-ignore TS6133
function rosClusterPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosClusterPropsValidator(properties).assertSuccess();
    }
    return {
        'EcsOrderComputeCount': ros.numberToRosTemplate(properties.ecsOrderComputeCount),
        'EcsOrderComputeInstanceType': ros.stringToRosTemplate(properties.ecsOrderComputeInstanceType),
        'EcsOrderLoginCount': ros.numberToRosTemplate(properties.ecsOrderLoginCount),
        'EcsOrderLoginInstanceType': ros.stringToRosTemplate(properties.ecsOrderLoginInstanceType),
        'EcsOrderManagerInstanceType': ros.stringToRosTemplate(properties.ecsOrderManagerInstanceType),
        'Name': ros.stringToRosTemplate(properties.name),
        'OsTag': ros.stringToRosTemplate(properties.osTag),
        'VSwitchId': ros.stringToRosTemplate(properties.vSwitchId),
        'AccountType': ros.stringToRosTemplate(properties.accountType),
        'AdditionalVolumes': ros.listMapper(rosClusterAdditionalVolumesPropertyToRosTemplate)(properties.additionalVolumes),
        'Application': ros.listMapper(rosClusterApplicationPropertyToRosTemplate)(properties.application),
        'AutoRenew': ros.booleanToRosTemplate(properties.autoRenew),
        'AutoRenewPeriod': ros.numberToRosTemplate(properties.autoRenewPeriod),
        'ClientVersion': ros.stringToRosTemplate(properties.clientVersion),
        'ComputeEnableHt': ros.booleanToRosTemplate(properties.computeEnableHt),
        'ComputeSpotPriceLimit': ros.stringToRosTemplate(properties.computeSpotPriceLimit),
        'ComputeSpotStrategy': ros.stringToRosTemplate(properties.computeSpotStrategy),
        'DeployMode': ros.stringToRosTemplate(properties.deployMode),
        'Description': ros.stringToRosTemplate(properties.description),
        'EcsChargeType': ros.stringToRosTemplate(properties.ecsChargeType),
        'EcsOrderManagerCount': ros.numberToRosTemplate(properties.ecsOrderManagerCount),
        'EhpcVersion': ros.stringToRosTemplate(properties.ehpcVersion),
        'HaEnable': ros.booleanToRosTemplate(properties.haEnable),
        'ImageId': ros.stringToRosTemplate(properties.imageId),
        'ImageOwnerAlias': ros.stringToRosTemplate(properties.imageOwnerAlias),
        'InputFileUrl': ros.stringToRosTemplate(properties.inputFileUrl),
        'IsComputeEss': ros.booleanToRosTemplate(properties.isComputeEss),
        'JobQueue': ros.stringToRosTemplate(properties.jobQueue),
        'KeyPairName': ros.stringToRosTemplate(properties.keyPairName),
        'NetworkInterfaceTrafficMode': ros.stringToRosTemplate(properties.networkInterfaceTrafficMode),
        'Password': ros.stringToRosTemplate(properties.password),
        'Period': ros.numberToRosTemplate(properties.period),
        'PeriodUnit': ros.stringToRosTemplate(properties.periodUnit),
        'PostInstallScript': ros.listMapper(rosClusterPostInstallScriptPropertyToRosTemplate)(properties.postInstallScript),
        'RamNodeTypes': ros.listMapper(ros.stringToRosTemplate)(properties.ramNodeTypes),
        'RamRoleName': ros.stringToRosTemplate(properties.ramRoleName),
        'RemoteDirectory': ros.stringToRosTemplate(properties.remoteDirectory),
        'RemoteVisEnable': ros.booleanToRosTemplate(properties.remoteVisEnable),
        'ResourceGroupId': ros.stringToRosTemplate(properties.resourceGroupId),
        'SccClusterId': ros.stringToRosTemplate(properties.sccClusterId),
        'SchedulerType': ros.stringToRosTemplate(properties.schedulerType),
        'SecurityGroupId': ros.stringToRosTemplate(properties.securityGroupId),
        'SecurityGroupName': ros.stringToRosTemplate(properties.securityGroupName),
        'SystemDiskLevel': ros.stringToRosTemplate(properties.systemDiskLevel),
        'SystemDiskSize': ros.numberToRosTemplate(properties.systemDiskSize),
        'SystemDiskType': ros.stringToRosTemplate(properties.systemDiskType),
        'VolumeId': ros.stringToRosTemplate(properties.volumeId),
        'VolumeMountpoint': ros.stringToRosTemplate(properties.volumeMountpoint),
        'VolumeProtocol': ros.stringToRosTemplate(properties.volumeProtocol),
        'VolumeType': ros.stringToRosTemplate(properties.volumeType),
        'VpcId': ros.stringToRosTemplate(properties.vpcId),
        'WithoutElasticIp': ros.booleanToRosTemplate(properties.withoutElasticIp),
        'ZoneId': ros.stringToRosTemplate(properties.zoneId),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::EHPC::Cluster`, which is used to create an Elastic High Performance Computing (E-HPC) cluster.
 * @Note This class does not contain additional functions, so it is recommended to use the `Cluster` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ehpc-cluster
 */
class RosCluster extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosCluster.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrClusterId = this.getAtt('ClusterId');
        this.attrEcsInfo = this.getAtt('EcsInfo');
        this.attrName = this.getAtt('Name');
        this.attrSecurityGroupId = this.getAtt('SecurityGroupId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.ecsOrderComputeCount = props.ecsOrderComputeCount;
        this.ecsOrderComputeInstanceType = props.ecsOrderComputeInstanceType;
        this.ecsOrderLoginCount = props.ecsOrderLoginCount;
        this.ecsOrderLoginInstanceType = props.ecsOrderLoginInstanceType;
        this.ecsOrderManagerInstanceType = props.ecsOrderManagerInstanceType;
        this.name = props.name;
        this.osTag = props.osTag;
        this.vSwitchId = props.vSwitchId;
        this.accountType = props.accountType;
        this.additionalVolumes = props.additionalVolumes;
        this.application = props.application;
        this.autoRenew = props.autoRenew;
        this.autoRenewPeriod = props.autoRenewPeriod;
        this.clientVersion = props.clientVersion;
        this.computeEnableHt = props.computeEnableHt;
        this.computeSpotPriceLimit = props.computeSpotPriceLimit;
        this.computeSpotStrategy = props.computeSpotStrategy;
        this.deployMode = props.deployMode;
        this.description = props.description;
        this.ecsChargeType = props.ecsChargeType;
        this.ecsOrderManagerCount = props.ecsOrderManagerCount;
        this.ehpcVersion = props.ehpcVersion;
        this.haEnable = props.haEnable;
        this.imageId = props.imageId;
        this.imageOwnerAlias = props.imageOwnerAlias;
        this.inputFileUrl = props.inputFileUrl;
        this.isComputeEss = props.isComputeEss;
        this.jobQueue = props.jobQueue;
        this.keyPairName = props.keyPairName;
        this.networkInterfaceTrafficMode = props.networkInterfaceTrafficMode;
        this.password = props.password;
        this.period = props.period;
        this.periodUnit = props.periodUnit;
        this.postInstallScript = props.postInstallScript;
        this.ramNodeTypes = props.ramNodeTypes;
        this.ramRoleName = props.ramRoleName;
        this.remoteDirectory = props.remoteDirectory;
        this.remoteVisEnable = props.remoteVisEnable;
        this.resourceGroupId = props.resourceGroupId;
        this.sccClusterId = props.sccClusterId;
        this.schedulerType = props.schedulerType;
        this.securityGroupId = props.securityGroupId;
        this.securityGroupName = props.securityGroupName;
        this.systemDiskLevel = props.systemDiskLevel;
        this.systemDiskSize = props.systemDiskSize;
        this.systemDiskType = props.systemDiskType;
        this.volumeId = props.volumeId;
        this.volumeMountpoint = props.volumeMountpoint;
        this.volumeProtocol = props.volumeProtocol;
        this.volumeType = props.volumeType;
        this.vpcId = props.vpcId;
        this.withoutElasticIp = props.withoutElasticIp;
        this.zoneId = props.zoneId;
    }
    get rosProperties() {
        return {
            ecsOrderComputeCount: this.ecsOrderComputeCount,
            ecsOrderComputeInstanceType: this.ecsOrderComputeInstanceType,
            ecsOrderLoginCount: this.ecsOrderLoginCount,
            ecsOrderLoginInstanceType: this.ecsOrderLoginInstanceType,
            ecsOrderManagerInstanceType: this.ecsOrderManagerInstanceType,
            name: this.name,
            osTag: this.osTag,
            vSwitchId: this.vSwitchId,
            accountType: this.accountType,
            additionalVolumes: this.additionalVolumes,
            application: this.application,
            autoRenew: this.autoRenew,
            autoRenewPeriod: this.autoRenewPeriod,
            clientVersion: this.clientVersion,
            computeEnableHt: this.computeEnableHt,
            computeSpotPriceLimit: this.computeSpotPriceLimit,
            computeSpotStrategy: this.computeSpotStrategy,
            deployMode: this.deployMode,
            description: this.description,
            ecsChargeType: this.ecsChargeType,
            ecsOrderManagerCount: this.ecsOrderManagerCount,
            ehpcVersion: this.ehpcVersion,
            haEnable: this.haEnable,
            imageId: this.imageId,
            imageOwnerAlias: this.imageOwnerAlias,
            inputFileUrl: this.inputFileUrl,
            isComputeEss: this.isComputeEss,
            jobQueue: this.jobQueue,
            keyPairName: this.keyPairName,
            networkInterfaceTrafficMode: this.networkInterfaceTrafficMode,
            password: this.password,
            period: this.period,
            periodUnit: this.periodUnit,
            postInstallScript: this.postInstallScript,
            ramNodeTypes: this.ramNodeTypes,
            ramRoleName: this.ramRoleName,
            remoteDirectory: this.remoteDirectory,
            remoteVisEnable: this.remoteVisEnable,
            resourceGroupId: this.resourceGroupId,
            sccClusterId: this.sccClusterId,
            schedulerType: this.schedulerType,
            securityGroupId: this.securityGroupId,
            securityGroupName: this.securityGroupName,
            systemDiskLevel: this.systemDiskLevel,
            systemDiskSize: this.systemDiskSize,
            systemDiskType: this.systemDiskType,
            volumeId: this.volumeId,
            volumeMountpoint: this.volumeMountpoint,
            volumeProtocol: this.volumeProtocol,
            volumeType: this.volumeType,
            vpcId: this.vpcId,
            withoutElasticIp: this.withoutElasticIp,
            zoneId: this.zoneId,
        };
    }
    renderProperties(props) {
        return rosClusterPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosCluster = RosCluster;
/**
 * The resource type name for this resource class.
 */
RosCluster.ROS_RESOURCE_TYPE_NAME = "ALIYUN::EHPC::Cluster";
/**
 * Determine whether the given properties match those of a `AdditionalVolumesProperty`
 *
 * @param properties - the TypeScript properties of a `AdditionalVolumesProperty`
 *
 * @returns the result of the validation.
 */
function RosCluster_AdditionalVolumesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('volumeProtocol', ros.validateString)(properties.volumeProtocol));
    errors.collect(ros.propertyValidator('localDirectory', ros.requiredValidator)(properties.localDirectory));
    errors.collect(ros.propertyValidator('localDirectory', ros.validateString)(properties.localDirectory));
    errors.collect(ros.propertyValidator('volumeId', ros.requiredValidator)(properties.volumeId));
    errors.collect(ros.propertyValidator('volumeId', ros.validateString)(properties.volumeId));
    errors.collect(ros.propertyValidator('remoteDirectory', ros.validateString)(properties.remoteDirectory));
    errors.collect(ros.propertyValidator('volumeType', ros.validateString)(properties.volumeType));
    errors.collect(ros.propertyValidator('jobQueue', ros.validateString)(properties.jobQueue));
    errors.collect(ros.propertyValidator('volumeMountpoint', ros.requiredValidator)(properties.volumeMountpoint));
    errors.collect(ros.propertyValidator('volumeMountpoint', ros.validateString)(properties.volumeMountpoint));
    errors.collect(ros.propertyValidator('location', ros.validateString)(properties.location));
    return errors.wrap('supplied properties not correct for "AdditionalVolumesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster.AdditionalVolumes` resource
 *
 * @param properties - the TypeScript properties of a `AdditionalVolumesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster.AdditionalVolumes` resource.
 */
// @ts-ignore TS6133
function rosClusterAdditionalVolumesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosCluster_AdditionalVolumesPropertyValidator(properties).assertSuccess();
    return {
        'VolumeProtocol': ros.stringToRosTemplate(properties.volumeProtocol),
        'LocalDirectory': ros.stringToRosTemplate(properties.localDirectory),
        'VolumeId': ros.stringToRosTemplate(properties.volumeId),
        'RemoteDirectory': ros.stringToRosTemplate(properties.remoteDirectory),
        'VolumeType': ros.stringToRosTemplate(properties.volumeType),
        'JobQueue': ros.stringToRosTemplate(properties.jobQueue),
        'VolumeMountpoint': ros.stringToRosTemplate(properties.volumeMountpoint),
        'Location': ros.stringToRosTemplate(properties.location),
    };
}
/**
 * Determine whether the given properties match those of a `ApplicationProperty`
 *
 * @param properties - the TypeScript properties of a `ApplicationProperty`
 *
 * @returns the result of the validation.
 */
function RosCluster_ApplicationPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('tag', ros.requiredValidator)(properties.tag));
    errors.collect(ros.propertyValidator('tag', ros.validateString)(properties.tag));
    return errors.wrap('supplied properties not correct for "ApplicationProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster.Application` resource
 *
 * @param properties - the TypeScript properties of a `ApplicationProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster.Application` resource.
 */
// @ts-ignore TS6133
function rosClusterApplicationPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosCluster_ApplicationPropertyValidator(properties).assertSuccess();
    return {
        'Tag': ros.stringToRosTemplate(properties.tag),
    };
}
/**
 * Determine whether the given properties match those of a `PostInstallScriptProperty`
 *
 * @param properties - the TypeScript properties of a `PostInstallScriptProperty`
 *
 * @returns the result of the validation.
 */
function RosCluster_PostInstallScriptPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('args', ros.validateString)(properties.args));
    errors.collect(ros.propertyValidator('url', ros.validateString)(properties.url));
    return errors.wrap('supplied properties not correct for "PostInstallScriptProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster.PostInstallScript` resource
 *
 * @param properties - the TypeScript properties of a `PostInstallScriptProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster.PostInstallScript` resource.
 */
// @ts-ignore TS6133
function rosClusterPostInstallScriptPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosCluster_PostInstallScriptPropertyValidator(properties).assertSuccess();
    return {
        'Args': ros.stringToRosTemplate(properties.args),
        'Url': ros.stringToRosTemplate(properties.url),
    };
}
/**
 * Determine whether the given properties match those of a `RosUsersProps`
 *
 * @param properties - the TypeScript properties of a `RosUsersProps`
 *
 * @returns the result of the validation.
 */
function RosUsersPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('clusterId', ros.requiredValidator)(properties.clusterId));
    errors.collect(ros.propertyValidator('clusterId', ros.validateString)(properties.clusterId));
    errors.collect(ros.propertyValidator('users', ros.requiredValidator)(properties.users));
    if (properties.users && (Array.isArray(properties.users) || (typeof properties.users) === 'string')) {
        errors.collect(ros.propertyValidator('users', ros.validateLength)({
            data: properties.users.length,
            min: undefined,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('users', ros.listValidator(RosUsers_UsersPropertyValidator))(properties.users));
    return errors.wrap('supplied properties not correct for "RosUsersProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Users` resource
 *
 * @param properties - the TypeScript properties of a `RosUsersProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Users` resource.
 */
// @ts-ignore TS6133
function rosUsersPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosUsersPropsValidator(properties).assertSuccess();
    }
    return {
        'ClusterId': ros.stringToRosTemplate(properties.clusterId),
        'Users': ros.listMapper(rosUsersUsersPropertyToRosTemplate)(properties.users),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::EHPC::Users`, which is used to add one or more users to a specified cluster.
 * @Note This class does not contain additional functions, so it is recommended to use the `Users` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ehpc-users
 */
class RosUsers extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosUsers.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.clusterId = props.clusterId;
        this.users = props.users;
    }
    get rosProperties() {
        return {
            clusterId: this.clusterId,
            users: this.users,
        };
    }
    renderProperties(props) {
        return rosUsersPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosUsers = RosUsers;
/**
 * The resource type name for this resource class.
 */
RosUsers.ROS_RESOURCE_TYPE_NAME = "ALIYUN::EHPC::Users";
/**
 * Determine whether the given properties match those of a `UsersProperty`
 *
 * @param properties - the TypeScript properties of a `UsersProperty`
 *
 * @returns the result of the validation.
 */
function RosUsers_UsersPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('group', ros.requiredValidator)(properties.group));
    errors.collect(ros.propertyValidator('group', ros.validateString)(properties.group));
    errors.collect(ros.propertyValidator('password', ros.requiredValidator)(properties.password));
    errors.collect(ros.propertyValidator('password', ros.validateString)(properties.password));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "UsersProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Users.Users` resource
 *
 * @param properties - the TypeScript properties of a `UsersProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Users.Users` resource.
 */
// @ts-ignore TS6133
function rosUsersUsersPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosUsers_UsersPropertyValidator(properties).assertSuccess();
    return {
        'Group': ros.stringToRosTemplate(properties.group),
        'Password': ros.stringToRosTemplate(properties.password),
        'Name': ros.stringToRosTemplate(properties.name),
    };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWhwYy5nZW5lcmF0ZWQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJlaHBjLmdlbmVyYXRlZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEseURBQXlEOzs7QUFFekQsOENBQThDO0FBd0c5Qzs7Ozs7O0dBTUc7QUFDSCxTQUFTLGdDQUFnQyxDQUFDLFVBQWU7SUFDckQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBRyxVQUFVLENBQUMsbUJBQW1CLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLFFBQVEsRUFBRTtRQUN2RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLENBQUM7WUFDM0UsSUFBSSxFQUFFLFVBQVUsQ0FBQyxtQkFBbUI7WUFDcEMsR0FBRyxFQUFFLENBQUM7WUFDTixHQUFHLEVBQUUsR0FBRztTQUNULENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQztJQUNqSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7SUFDeEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQ2hHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDN0YsSUFBRyxVQUFVLENBQUMsZUFBZSxJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsZUFBZSxDQUFDLEtBQUssUUFBUSxFQUFFO1FBQy9FLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsQ0FBQztZQUN2RSxJQUFJLEVBQUUsVUFBVSxDQUFDLGVBQWU7WUFDaEMsR0FBRyxFQUFFLENBQUM7WUFDTixHQUFHLEVBQUUsQ0FBQztTQUNQLENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDekcsSUFBRyxVQUFVLENBQUMsaUJBQWlCLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLFFBQVEsRUFBRTtRQUNuRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLENBQUM7WUFDekUsSUFBSSxFQUFFLFVBQVUsQ0FBQyxpQkFBaUI7WUFDbEMsR0FBRyxFQUFFLENBQUM7WUFDTixHQUFHLEVBQUUsR0FBRztTQUNULENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUM3RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUM1RyxJQUFHLFVBQVUsQ0FBQyxTQUFTLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxTQUFTLENBQUMsS0FBSyxRQUFRLEVBQUU7UUFDbkUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsQ0FBQztZQUNqRSxJQUFJLEVBQUUsVUFBVSxDQUFDLFNBQVM7WUFDMUIsR0FBRyxFQUFFLENBQUM7WUFDTixHQUFHLEVBQUUsR0FBRztTQUNULENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLElBQUcsVUFBVSxDQUFDLHFCQUFxQixJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMscUJBQXFCLENBQUMsS0FBSyxRQUFRLEVBQUU7UUFDM0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsdUJBQXVCLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxDQUFDO1lBQzdFLElBQUksRUFBRSxVQUFVLENBQUMscUJBQXFCO1lBQ3RDLEdBQUcsRUFBRSxDQUFDO1lBQ04sR0FBRyxFQUFFLEVBQUU7U0FDUixDQUFDLENBQUMsQ0FBQztLQUNUO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsdUJBQXVCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDLENBQUM7SUFDckgsSUFBRyxVQUFVLENBQUMsb0JBQW9CLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLLFFBQVEsRUFBRTtRQUN6RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLENBQUM7WUFDNUUsSUFBSSxFQUFFLFVBQVUsQ0FBQyxvQkFBb0I7WUFDckMsR0FBRyxFQUFFLEVBQUU7WUFDUCxHQUFHLEVBQUUsRUFBRTtTQUNSLENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUNuSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3pGLElBQUcsVUFBVSxDQUFDLHVCQUF1QixJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsdUJBQXVCLENBQUMsS0FBSyxRQUFRLEVBQUU7UUFDL0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxDQUFDO1lBQy9FLElBQUksRUFBRSxVQUFVLENBQUMsdUJBQXVCO1lBQ3hDLEdBQUcsRUFBRSxDQUFDO1lBQ04sR0FBRyxFQUFFLEVBQUU7U0FDUixDQUFDLENBQUMsQ0FBQztLQUNUO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDLENBQUM7SUFDekgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLElBQUcsVUFBVSxDQUFDLE1BQU0sSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsTUFBTSxDQUFDLEtBQUssUUFBUSxDQUFDLEVBQUU7UUFDbkcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQztZQUMvRCxJQUFJLEVBQUUsVUFBVSxDQUFDLE1BQU0sQ0FBQyxNQUFNO1lBQzlCLEdBQUcsRUFBRSxTQUFTO1lBQ2QsR0FBRyxFQUFFLENBQUM7U0FDUCxDQUFDLENBQUMsQ0FBQztLQUNUO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsMENBQTBDLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQ2xJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDbkcsSUFBRyxVQUFVLENBQUMsWUFBWSxJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsWUFBWSxDQUFDLEtBQUssUUFBUSxFQUFFO1FBQ3pFLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxHQUFHLENBQUMscUJBQXFCLENBQUMsQ0FBQztZQUM5RSxJQUFJLEVBQUUsVUFBVSxDQUFDLFlBQVk7WUFDN0IsYUFBYSxFQUFFLENBQUMsUUFBUSxFQUFDLG9CQUFvQixFQUFDLGVBQWUsQ0FBQztTQUMvRCxDQUFDLENBQUMsQ0FBQztLQUNQO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsK0RBQStELENBQUMsQ0FBQztBQUN4RixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsb0NBQW9DLENBQUMsVUFBZSxFQUFFLGdDQUF5QztJQUNwRyxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsSUFBRyxnQ0FBZ0MsRUFBRTtRQUNqQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztLQUNoRTtJQUNELE9BQU87UUFDTCxXQUFXLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUM7UUFDMUQsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLG9CQUFvQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDckUsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLG9CQUFvQixDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQztRQUN6RSxjQUFjLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7UUFDaEUscUJBQXFCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQztRQUM5RSx1QkFBdUIsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDO1FBQ2xGLFdBQVcsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUMxRCxzQkFBc0IsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDO1FBQ2hGLFNBQVMsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQztRQUN0RCxtQkFBbUIsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDO1FBQzFFLFFBQVEsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLDZDQUE2QyxDQUFDLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQztRQUMxRixpQkFBaUIsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQztRQUN0RSx5QkFBeUIsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLHVCQUF1QixDQUFDO1FBQ3RGLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDO1FBQ3BFLGNBQWMsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztLQUNqRSxDQUFDO0FBQ04sQ0FBQztBQUVEOzs7O0dBSUc7QUFDSCxNQUFhLGtCQUFtQixTQUFRLEdBQUcsQ0FBQyxXQUFXO0lBNkduRDs7OztPQUlHO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUE4QixFQUFFLGdDQUF5QztRQUNuSCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxrQkFBa0IsQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQztRQUN6RixJQUFJLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDLENBQUM7UUFFOUMsSUFBSSxDQUFDLGdDQUFnQyxHQUFHLGdDQUFnQyxDQUFDO1FBQ3pFLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUM7UUFDM0MsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQztRQUMvQyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDdkMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQztRQUNyRCxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDLHFCQUFxQixDQUFDO1FBQ3pELElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDLG9CQUFvQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1FBQ2pELElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztRQUMzQixJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7UUFDN0MsSUFBSSxDQUFDLHVCQUF1QixHQUFHLEtBQUssQ0FBQyx1QkFBdUIsQ0FBQztRQUM3RCxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUM7UUFDM0MsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO0lBQzNDLENBQUM7SUFHRCxJQUFjLGFBQWE7UUFDdkIsT0FBTztZQUNILFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN6QixjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQjtZQUN2QyxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDL0IsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLG1CQUFtQjtZQUM3QyxxQkFBcUIsRUFBRSxJQUFJLENBQUMscUJBQXFCO1lBQ2pELFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN6QixvQkFBb0IsRUFBRSxJQUFJLENBQUMsb0JBQW9CO1lBQy9DLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztZQUNyQixpQkFBaUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1lBQ3pDLE1BQU0sRUFBRSxJQUFJLENBQUMsTUFBTTtZQUNuQixlQUFlLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDckMsdUJBQXVCLEVBQUUsSUFBSSxDQUFDLHVCQUF1QjtZQUNyRCxjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1NBQ2xDLENBQUM7SUFDTixDQUFDO0lBQ1MsZ0JBQWdCLENBQUMsS0FBMkI7UUFDbEQsT0FBTyxvQ0FBb0MsQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLGdDQUFnQyxDQUFDLENBQUM7SUFDOUYsQ0FBQzs7QUE5SkwsZ0RBK0pDO0FBOUpHOztHQUVHO0FBQ29CLHlDQUFzQixHQUFHLCtCQUErQixDQUFDO0FBc01wRjs7Ozs7O0dBTUc7QUFDSCxTQUFTLDZDQUE2QyxDQUFDLFVBQWU7SUFDbEUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7SUFDM0csTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsMEJBQTBCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLENBQUM7SUFDM0gsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDOUcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsNEJBQTRCLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFVBQVUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDLENBQUM7SUFDaEksSUFBRyxVQUFVLENBQUMsWUFBWSxJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsWUFBWSxDQUFDLEtBQUssUUFBUSxFQUFFO1FBQ3pFLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLENBQUM7WUFDcEUsSUFBSSxFQUFFLFVBQVUsQ0FBQyxZQUFZO1lBQzdCLEdBQUcsRUFBRSxFQUFFO1lBQ1AsR0FBRyxFQUFFLEdBQUc7U0FDVCxDQUFDLENBQUMsQ0FBQztLQUNUO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUMzRyxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMseURBQXlELENBQUMsQ0FBQztBQUNsRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsZ0RBQWdELENBQUMsVUFBZTtJQUNyRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsNkNBQTZDLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDMUUsT0FBTztRQUNMLGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUM7UUFDeEUsMEJBQTBCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQztRQUN4RixtQkFBbUIsRUFBRSxHQUFHLENBQUMsb0JBQW9CLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDO1FBQzNFLDRCQUE0QixFQUFFLEdBQUcsQ0FBQyxvQkFBb0IsQ0FBQyxVQUFVLENBQUMsMEJBQTBCLENBQUM7UUFDN0YsY0FBYyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQ2hFLGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUM7S0FDekUsQ0FBQztBQUNOLENBQUM7QUFpQ0Q7Ozs7OztHQU1HO0FBQ0gsU0FBUyxpREFBaUQsQ0FBQyxVQUFlO0lBQ3RFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFFBQVEsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztJQUMxRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQ3ZGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUNoRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUN2RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDdEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxJQUFHLFVBQVUsQ0FBQyxZQUFZLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxZQUFZLENBQUMsS0FBSyxRQUFRLEVBQUU7UUFDekUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1lBQzlFLElBQUksRUFBRSxVQUFVLENBQUMsWUFBWTtZQUM3QixhQUFhLEVBQUUsQ0FBQyxRQUFRLEVBQUMsb0JBQW9CLEVBQUMsZUFBZSxDQUFDO1NBQy9ELENBQUMsQ0FBQyxDQUFDO0tBQ1A7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQ25HLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyw2REFBNkQsQ0FBQyxDQUFDO0FBQ3RGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxvREFBb0QsQ0FBQyxVQUFlO0lBQ3pFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxpREFBaUQsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUM5RSxPQUFPO1FBQ0wsUUFBUSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDO1FBQ3BELFdBQVcsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUMxRCxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQztRQUNwRSxjQUFjLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7UUFDaEUsY0FBYyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO0tBQ2pFLENBQUM7QUFDTixDQUFDO0FBNEdEOzs7Ozs7R0FNRztBQUNILFNBQVMsMENBQTBDLENBQUMsVUFBZTtJQUMvRCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7SUFDdkcsSUFBRyxVQUFVLENBQUMsZUFBZSxJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsZUFBZSxDQUFDLEtBQUssUUFBUSxFQUFFO1FBQy9FLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsQ0FBQztZQUN2RSxJQUFJLEVBQUUsVUFBVSxDQUFDLGVBQWU7WUFDaEMsR0FBRyxFQUFFLENBQUM7WUFDTixHQUFHLEVBQUUsRUFBRTtTQUNSLENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDekcsSUFBRyxVQUFVLENBQUMsZUFBZSxJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsZUFBZSxDQUFDLEtBQUssUUFBUSxFQUFFO1FBQy9FLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsQ0FBQztZQUN2RSxJQUFJLEVBQUUsVUFBVSxDQUFDLGVBQWU7WUFDaEMsR0FBRyxFQUFFLENBQUM7WUFDTixHQUFHLEVBQUUsR0FBRztTQUNULENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDekcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3hHLElBQUcsVUFBVSxDQUFDLFNBQVMsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsU0FBUyxDQUFDLEtBQUssUUFBUSxDQUFDLEVBQUU7UUFDNUcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQztZQUNsRSxJQUFJLEVBQUUsVUFBVSxDQUFDLFNBQVMsQ0FBQyxNQUFNO1lBQ2pDLEdBQUcsRUFBRSxTQUFTO1lBQ2QsR0FBRyxFQUFFLEVBQUU7U0FDUixDQUFDLENBQUMsQ0FBQztLQUNUO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsNkNBQTZDLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzNJLElBQUcsVUFBVSxDQUFDLGNBQWMsSUFBSSxDQUFDLE9BQU8sVUFBVSxDQUFDLGNBQWMsQ0FBQyxLQUFLLFFBQVEsRUFBRTtRQUM3RSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLENBQUM7WUFDdEUsSUFBSSxFQUFFLFVBQVUsQ0FBQyxjQUFjO1lBQy9CLEdBQUcsRUFBRSxFQUFFO1lBQ1AsR0FBRyxFQUFFLEdBQUc7U0FDVCxDQUFDLENBQUMsQ0FBQztLQUNUO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUN6RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQ25HLElBQUcsVUFBVSxDQUFDLGdCQUFnQixJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsS0FBSyxRQUFRLEVBQUU7UUFDakYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxDQUFDO1lBQ3hFLElBQUksRUFBRSxVQUFVLENBQUMsZ0JBQWdCO1lBQ2pDLEdBQUcsRUFBRSxDQUFDO1lBQ04sR0FBRyxFQUFFLEVBQUU7U0FDUixDQUFDLENBQUMsQ0FBQztLQUNUO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7SUFDM0csSUFBRyxVQUFVLENBQUMsZ0JBQWdCLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxLQUFLLFFBQVEsRUFBRTtRQUNqRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLENBQUM7WUFDeEUsSUFBSSxFQUFFLFVBQVUsQ0FBQyxnQkFBZ0I7WUFDakMsR0FBRyxFQUFFLENBQUM7WUFDTixHQUFHLEVBQUUsRUFBRTtTQUNSLENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUMzRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUM1RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxvQkFBb0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUMvRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7SUFDdkcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLElBQUcsVUFBVSxDQUFDLGFBQWEsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsYUFBYSxDQUFDLEtBQUssUUFBUSxDQUFDLEVBQUU7UUFDeEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZUFBZSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQztZQUN0RSxJQUFJLEVBQUUsVUFBVSxDQUFDLGFBQWEsQ0FBQyxNQUFNO1lBQ3JDLEdBQUcsRUFBRSxTQUFTO1lBQ2QsR0FBRyxFQUFFLEdBQUc7U0FDVCxDQUFDLENBQUMsQ0FBQztLQUNUO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZUFBZSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsaURBQWlELENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO0lBQ3ZKLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDbkcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUM3RixJQUFHLFVBQVUsQ0FBQyxZQUFZLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxZQUFZLENBQUMsS0FBSyxRQUFRLEVBQUU7UUFDekUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1lBQzlFLElBQUksRUFBRSxVQUFVLENBQUMsWUFBWTtZQUM3QixhQUFhLEVBQUUsQ0FBQyxRQUFRLEVBQUMsb0JBQW9CLEVBQUMsZUFBZSxDQUFDO1NBQy9ELENBQUMsQ0FBQyxDQUFDO0tBQ1A7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQ25HLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxzREFBc0QsQ0FBQyxDQUFDO0FBQy9FLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyw2Q0FBNkMsQ0FBQyxVQUFlO0lBQ2xFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCwwQ0FBMEMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN2RSxPQUFPO1FBQ0wsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDcEUsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUM7UUFDdEUsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUM7UUFDdEUsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLG9CQUFvQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDckUsV0FBVyxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsZ0RBQWdELENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO1FBQ25HLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDO1FBQ3BFLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDO1FBQ3RFLGNBQWMsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztRQUNoRSxrQkFBa0IsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDO1FBQ3hFLGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUM7UUFDeEUsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLG9CQUFvQixDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQztRQUN6RSxvQkFBb0IsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDO1FBQzVFLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDO1FBQ3BFLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDO1FBQ3BFLGVBQWUsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLG9EQUFvRCxDQUFDLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQztRQUMvRyxjQUFjLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7UUFDaEUsV0FBVyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO1FBQzFELGNBQWMsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztLQUNqRSxDQUFDO0FBQ04sQ0FBQztBQW1VRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLHdCQUF3QixDQUFDLFVBQWU7SUFDN0MsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUN6RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDMUcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7SUFDNUcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxlQUFlLENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUMxRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDdEYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUNuRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzNGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDakcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUMvRixJQUFHLFVBQVUsQ0FBQyxpQkFBaUIsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLFFBQVEsQ0FBQyxFQUFFO1FBQ3BJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQztZQUMxRSxJQUFJLEVBQUUsVUFBVSxDQUFDLGlCQUFpQixDQUFDLE1BQU07WUFDekMsR0FBRyxFQUFFLFNBQVM7WUFDZCxHQUFHLEVBQUUsRUFBRTtTQUNSLENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLDZDQUE2QyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQzNKLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDekYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxlQUFlLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNwRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQywyQkFBMkIsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMseUJBQXlCLENBQUMsQ0FBQyxDQUFDO0lBQ2hJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLDJCQUEyQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMseUJBQXlCLENBQUMsQ0FBQyxDQUFDO0lBQzdILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQ2hHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDN0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztJQUN2RixJQUFHLFVBQVUsQ0FBQyxtQkFBbUIsSUFBSSxDQUFDLE9BQU8sVUFBVSxDQUFDLG1CQUFtQixDQUFDLEtBQUssUUFBUSxFQUFFO1FBQ3ZGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1lBQ3JGLElBQUksRUFBRSxVQUFVLENBQUMsbUJBQW1CO1lBQ3BDLGFBQWEsRUFBRSxDQUFDLFFBQVEsRUFBQyxvQkFBb0IsRUFBQyxlQUFlLENBQUM7U0FDL0QsQ0FBQyxDQUFDLENBQUM7S0FDUDtJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDO0lBQ2pILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLDZCQUE2QixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDLENBQUM7SUFDcEksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsNkJBQTZCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDLENBQUM7SUFDakksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztJQUNqRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUMzRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUNuSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyw2QkFBNkIsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsMkJBQTJCLENBQUMsQ0FBQyxDQUFDO0lBQ3BJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLDZCQUE2QixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsMkJBQTJCLENBQUMsQ0FBQyxDQUFDO0lBQ2pJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDckYsSUFBRyxVQUFVLENBQUMsV0FBVyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxXQUFXLENBQUMsS0FBSyxRQUFRLENBQUMsRUFBRTtRQUNsSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDO1lBQ3BFLElBQUksRUFBRSxVQUFVLENBQUMsV0FBVyxDQUFDLE1BQU07WUFDbkMsR0FBRyxFQUFFLFNBQVM7WUFDZCxHQUFHLEVBQUUsRUFBRTtTQUNSLENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyx1Q0FBdUMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDekksSUFBRyxVQUFVLENBQUMsVUFBVSxJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsVUFBVSxDQUFDLEtBQUssUUFBUSxFQUFFO1FBQ3JFLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMscUJBQXFCLENBQUMsQ0FBQztZQUM1RSxJQUFJLEVBQUUsVUFBVSxDQUFDLFVBQVU7WUFDM0IsYUFBYSxFQUFFLENBQUMsTUFBTSxFQUFDLE9BQU8sRUFBQyxNQUFNLENBQUM7U0FDdkMsQ0FBQyxDQUFDLENBQUM7S0FDUDtJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFDL0YsSUFBRyxVQUFVLENBQUMsZUFBZSxJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsZUFBZSxDQUFDLEtBQUssUUFBUSxFQUFFO1FBQy9FLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1lBQ2pGLElBQUksRUFBRSxVQUFVLENBQUMsZUFBZTtZQUNoQyxhQUFhLEVBQUUsQ0FBQyxRQUFRLEVBQUMsTUFBTSxFQUFDLFFBQVEsRUFBQyxhQUFhLENBQUM7U0FDeEQsQ0FBQyxDQUFDLENBQUM7S0FDUDtJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUN6RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDO0lBQ3RILElBQUcsVUFBVSxDQUFDLG9CQUFvQixJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsb0JBQW9CLENBQUMsS0FBSyxRQUFRLEVBQUU7UUFDekYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxDQUFDO1lBQzVFLElBQUksRUFBRSxVQUFVLENBQUMsb0JBQW9CO1lBQ3JDLEdBQUcsRUFBRSxDQUFDO1lBQ04sR0FBRyxFQUFFLEVBQUU7U0FDUixDQUFDLENBQUMsQ0FBQztLQUNUO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDbkgsSUFBRyxVQUFVLENBQUMsV0FBVyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxXQUFXLENBQUMsS0FBSyxRQUFRLENBQUMsRUFBRTtRQUNsSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDO1lBQ3BFLElBQUksRUFBRSxVQUFVLENBQUMsV0FBVyxDQUFDLE1BQU07WUFDbkMsR0FBRyxFQUFFLENBQUM7WUFDTixHQUFHLEVBQUUsR0FBRztTQUNULENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ2pHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQzdHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUN2RyxJQUFHLFVBQVUsQ0FBQyxpQkFBaUIsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLFFBQVEsQ0FBQyxFQUFFO1FBQ3BJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQztZQUMxRSxJQUFJLEVBQUUsVUFBVSxDQUFDLGlCQUFpQixDQUFDLE1BQU07WUFDekMsR0FBRyxFQUFFLFNBQVM7WUFDZCxHQUFHLEVBQUUsRUFBRTtTQUNSLENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLDZDQUE2QyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQzNKLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDOUYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsdUJBQXVCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDLENBQUM7SUFDckgsSUFBRyxVQUFVLENBQUMsWUFBWSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxZQUFZLENBQUMsS0FBSyxRQUFRLENBQUMsRUFBRTtRQUNySCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDO1lBQ3JFLElBQUksRUFBRSxVQUFVLENBQUMsWUFBWSxDQUFDLE1BQU07WUFDcEMsR0FBRyxFQUFFLFNBQVM7WUFDZCxHQUFHLEVBQUUsQ0FBQztTQUNQLENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUN0SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO0lBQ3JHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFDL0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxJQUFHLFVBQVUsQ0FBQyxRQUFRLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE9BQU8sVUFBVSxDQUFDLFFBQVEsQ0FBQyxLQUFLLFFBQVEsQ0FBQyxFQUFFO1FBQ3pHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUM7WUFDakUsSUFBSSxFQUFFLFVBQVUsQ0FBQyxRQUFRLENBQUMsTUFBTTtZQUNoQyxHQUFHLEVBQUUsQ0FBQztZQUNOLEdBQUcsRUFBRSxFQUFFO1NBQ1IsQ0FBQyxDQUFDLENBQUM7S0FDVDtJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDO0lBQ3pHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDakcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDO0lBQ3pHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLDZCQUE2QixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsMkJBQTJCLENBQUMsQ0FBQyxDQUFDO0lBQ2pJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDbkcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztJQUN2RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDekcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUNsSCxJQUFHLFVBQVUsQ0FBQyxrQkFBa0IsSUFBSSxDQUFDLE9BQU8sVUFBVSxDQUFDLGtCQUFrQixDQUFDLEtBQUssUUFBUSxFQUFFO1FBQ3JGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsQ0FBQztZQUMxRSxJQUFJLEVBQUUsVUFBVSxDQUFDLGtCQUFrQjtZQUNuQyxHQUFHLEVBQUUsQ0FBQztZQUNOLEdBQUcsRUFBRSxDQUFDO1NBQ1AsQ0FBQyxDQUFDLENBQUM7S0FDVDtJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDO0lBQy9HLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUN6RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO0lBQ3JHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDakcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxlQUFlLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUM1RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDeEYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNyRixJQUFHLFVBQVUsQ0FBQyxhQUFhLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxhQUFhLENBQUMsS0FBSyxRQUFRLEVBQUU7UUFDM0UsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZUFBZSxFQUFFLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1lBQy9FLElBQUksRUFBRSxVQUFVLENBQUMsYUFBYTtZQUM5QixhQUFhLEVBQUUsQ0FBQyxZQUFZLEVBQUMsVUFBVSxFQUFDLGFBQWEsRUFBQyxVQUFVLEVBQUMsU0FBUyxFQUFDLFNBQVMsRUFBQyxTQUFTLEVBQUMsTUFBTSxFQUFDLGNBQWMsRUFBQyxTQUFTLEVBQUMsU0FBUyxFQUFDLFFBQVEsRUFBQyxRQUFRLEVBQUMsUUFBUSxFQUFDLEtBQUssQ0FBQztTQUMzSyxDQUFDLENBQUMsQ0FBQztLQUNQO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZUFBZSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQztJQUNyRyxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsdURBQXVELENBQUMsQ0FBQztBQUNoRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsNEJBQTRCLENBQUMsVUFBZSxFQUFFLGdDQUF5QztJQUM1RixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsSUFBRyxnQ0FBZ0MsRUFBRTtRQUNqQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztLQUN4RDtJQUNELE9BQU87UUFDTCxzQkFBc0IsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDO1FBQ2hGLDZCQUE2QixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsMkJBQTJCLENBQUM7UUFDOUYsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQztRQUM1RSwyQkFBMkIsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLHlCQUF5QixDQUFDO1FBQzFGLDZCQUE2QixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsMkJBQTJCLENBQUM7UUFDOUYsTUFBTSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO1FBQ2hELE9BQU8sRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQztRQUNsRCxXQUFXLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUM7UUFDMUQsYUFBYSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO1FBQzlELG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsZ0RBQWdELENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUM7UUFDbkgsYUFBYSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsMENBQTBDLENBQUMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO1FBQ2pHLFdBQVcsRUFBRSxHQUFHLENBQUMsb0JBQW9CLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUMzRCxpQkFBaUIsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQztRQUN0RSxlQUFlLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7UUFDbEUsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLG9CQUFvQixDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUM7UUFDdkUsdUJBQXVCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQztRQUNsRixxQkFBcUIsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDO1FBQzlFLFlBQVksRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQztRQUM1RCxhQUFhLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUM7UUFDOUQsZUFBZSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDO1FBQ2xFLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUM7UUFDaEYsYUFBYSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO1FBQzlELFVBQVUsRUFBRSxHQUFHLENBQUMsb0JBQW9CLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQztRQUN6RCxTQUFTLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7UUFDdEQsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUM7UUFDdEUsY0FBYyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQ2hFLGNBQWMsRUFBRSxHQUFHLENBQUMsb0JBQW9CLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztRQUNqRSxVQUFVLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDeEQsYUFBYSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO1FBQzlELDZCQUE2QixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsMkJBQTJCLENBQUM7UUFDOUYsVUFBVSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3hELFFBQVEsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQztRQUNwRCxZQUFZLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUM7UUFDNUQsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxnREFBZ0QsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztRQUNuSCxjQUFjLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQ2hGLGFBQWEsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQztRQUM5RCxpQkFBaUIsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQztRQUN0RSxpQkFBaUIsRUFBRSxHQUFHLENBQUMsb0JBQW9CLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQztRQUN2RSxpQkFBaUIsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQztRQUN0RSxjQUFjLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7UUFDaEUsZUFBZSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDO1FBQ2xFLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDO1FBQ3RFLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUM7UUFDMUUsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUM7UUFDdEUsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDcEUsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDcEUsVUFBVSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3hELGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUM7UUFDeEUsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDcEUsWUFBWSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO1FBQzVELE9BQU8sRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQztRQUNsRCxrQkFBa0IsRUFBRSxHQUFHLENBQUMsb0JBQW9CLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDO1FBQ3pFLFFBQVEsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQztLQUNyRCxDQUFDO0FBQ04sQ0FBQztBQUVEOzs7O0dBSUc7QUFDSCxNQUFhLFVBQVcsU0FBUSxHQUFHLENBQUMsV0FBVztJQXdWM0M7Ozs7T0FJRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBc0IsRUFBRSxnQ0FBeUM7UUFDM0csS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUsVUFBVSxDQUFDLHNCQUFzQixFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDO1FBQ2pGLElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxXQUFXLENBQUMsQ0FBQztRQUM5QyxJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLENBQUM7UUFDMUMsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ3BDLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLGlCQUFpQixDQUFDLENBQUM7UUFFMUQsSUFBSSxDQUFDLGdDQUFnQyxHQUFHLGdDQUFnQyxDQUFDO1FBQ3pFLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUMsb0JBQW9CLENBQUM7UUFDdkQsSUFBSSxDQUFDLDJCQUEyQixHQUFHLEtBQUssQ0FBQywyQkFBMkIsQ0FBQztRQUNyRSxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGtCQUFrQixDQUFDO1FBQ25ELElBQUksQ0FBQyx5QkFBeUIsR0FBRyxLQUFLLENBQUMseUJBQXlCLENBQUM7UUFDakUsSUFBSSxDQUFDLDJCQUEyQixHQUFHLEtBQUssQ0FBQywyQkFBMkIsQ0FBQztRQUNyRSxJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7UUFDdkIsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDO1FBQ3pCLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztRQUNqRCxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO1FBQ2pDLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUM7UUFDekMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1FBQzdDLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMscUJBQXFCLENBQUM7UUFDekQsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQztRQUNyRCxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDbkMsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1FBQ3JDLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLGFBQWEsQ0FBQztRQUN6QyxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDLG9CQUFvQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztRQUNyQyxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFDL0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzdCLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDdkMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLDJCQUEyQixHQUFHLEtBQUssQ0FBQywyQkFBMkIsQ0FBQztRQUNyRSxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFDL0IsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1FBQzNCLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1FBQ2pELElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztRQUN2QyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1FBQzdDLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7UUFDN0MsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLGFBQWEsQ0FBQztRQUN6QyxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7UUFDN0MsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztRQUNqRCxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7UUFDN0MsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1FBQzNDLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQztRQUMzQyxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFDL0IsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQztRQUMvQyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUM7UUFDM0MsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDO1FBQ25DLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDLEtBQUssQ0FBQztRQUN6QixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDLGdCQUFnQixDQUFDO1FBQy9DLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztJQUMvQixDQUFDO0lBR0QsSUFBYyxhQUFhO1FBQ3ZCLE9BQU87WUFDSCxvQkFBb0IsRUFBRSxJQUFJLENBQUMsb0JBQW9CO1lBQy9DLDJCQUEyQixFQUFFLElBQUksQ0FBQywyQkFBMkI7WUFDN0Qsa0JBQWtCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtZQUMzQyx5QkFBeUIsRUFBRSxJQUFJLENBQUMseUJBQXlCO1lBQ3pELDJCQUEyQixFQUFFLElBQUksQ0FBQywyQkFBMkI7WUFDN0QsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJO1lBQ2YsS0FBSyxFQUFFLElBQUksQ0FBQyxLQUFLO1lBQ2pCLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN6QixXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtZQUN6QyxXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxhQUFhLEVBQUUsSUFBSSxDQUFDLGFBQWE7WUFDakMsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlO1lBQ3JDLHFCQUFxQixFQUFFLElBQUksQ0FBQyxxQkFBcUI7WUFDakQsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLG1CQUFtQjtZQUM3QyxVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVU7WUFDM0IsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzdCLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYTtZQUNqQyxvQkFBb0IsRUFBRSxJQUFJLENBQUMsb0JBQW9CO1lBQy9DLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztZQUM3QixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO1lBQ3JCLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDL0IsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQy9CLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsMkJBQTJCLEVBQUUsSUFBSSxDQUFDLDJCQUEyQjtZQUM3RCxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO1lBQ25CLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVTtZQUMzQixpQkFBaUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1lBQ3pDLFlBQVksRUFBRSxJQUFJLENBQUMsWUFBWTtZQUMvQixXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlO1lBQ3JDLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxlQUFlLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDckMsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQy9CLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYTtZQUNqQyxlQUFlLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDckMsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtZQUN6QyxlQUFlLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDckMsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjO1lBQ25DLGNBQWMsRUFBRSxJQUFJLENBQUMsY0FBYztZQUNuQyxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQjtZQUN2QyxjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVO1lBQzNCLEtBQUssRUFBRSxJQUFJLENBQUMsS0FBSztZQUNqQixnQkFBZ0IsRUFBRSxJQUFJLENBQUMsZ0JBQWdCO1lBQ3ZDLE1BQU0sRUFBRSxJQUFJLENBQUMsTUFBTTtTQUN0QixDQUFDO0lBQ04sQ0FBQztJQUNTLGdCQUFnQixDQUFDLEtBQTJCO1FBQ2xELE9BQU8sNEJBQTRCLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO0lBQ3RGLENBQUM7O0FBeGRMLGdDQXlkQztBQXhkRzs7R0FFRztBQUNvQixpQ0FBc0IsR0FBRyx1QkFBdUIsQ0FBQztBQWlnQjVFOzs7Ozs7R0FNRztBQUNILFNBQVMsNkNBQTZDLENBQUMsVUFBZTtJQUNsRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7SUFDdkcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7SUFDMUcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUM5RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzNGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUN6RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQy9GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUM5RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUMzRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzNGLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxpRUFBaUUsQ0FBQyxDQUFDO0FBQzFGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxnREFBZ0QsQ0FBQyxVQUFlO0lBQ3JFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCw2Q0FBNkMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUMxRSxPQUFPO1FBQ0wsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDcEUsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDcEUsVUFBVSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3hELGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDO1FBQ3RFLFlBQVksRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQztRQUM1RCxVQUFVLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDeEQsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQztRQUN4RSxVQUFVLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7S0FDekQsQ0FBQztBQUNOLENBQUM7QUFhRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLHVDQUF1QyxDQUFDLFVBQWU7SUFDNUQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ3BGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDakYsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDJEQUEyRCxDQUFDLENBQUM7QUFDcEYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDBDQUEwQyxDQUFDLFVBQWU7SUFDL0QsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELHVDQUF1QyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3BFLE9BQU87UUFDTCxLQUFLLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUM7S0FDL0MsQ0FBQztBQUNOLENBQUM7QUFpQkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyw2Q0FBNkMsQ0FBQyxVQUFlO0lBQ2xFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDbkYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUNqRixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsaUVBQWlFLENBQUMsQ0FBQztBQUMxRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsZ0RBQWdELENBQUMsVUFBZTtJQUNyRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsNkNBQTZDLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDMUUsT0FBTztRQUNMLE1BQU0sRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztRQUNoRCxLQUFLLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUM7S0FDL0MsQ0FBQztBQUNOLENBQUM7QUFtQkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyxzQkFBc0IsQ0FBQyxVQUFlO0lBQzNDLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUNoRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUN4RixJQUFHLFVBQVUsQ0FBQyxLQUFLLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLE9BQU8sVUFBVSxDQUFDLEtBQUssQ0FBQyxLQUFLLFFBQVEsQ0FBQyxFQUFFO1FBQ2hHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUM7WUFDOUQsSUFBSSxFQUFFLFVBQVUsQ0FBQyxLQUFLLENBQUMsTUFBTTtZQUM3QixHQUFHLEVBQUUsU0FBUztZQUNkLEdBQUcsRUFBRSxHQUFHO1NBQ1QsQ0FBQyxDQUFDLENBQUM7S0FDVDtJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLCtCQUErQixDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNySCxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMscURBQXFELENBQUMsQ0FBQztBQUM5RSxDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsMEJBQTBCLENBQUMsVUFBZSxFQUFFLGdDQUF5QztJQUMxRixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsSUFBRyxnQ0FBZ0MsRUFBRTtRQUNqQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztLQUN0RDtJQUNELE9BQU87UUFDTCxXQUFXLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUM7UUFDMUQsT0FBTyxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsa0NBQWtDLENBQUMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDO0tBQzlFLENBQUM7QUFDTixDQUFDO0FBRUQ7Ozs7R0FJRztBQUNILE1BQWEsUUFBUyxTQUFRLEdBQUcsQ0FBQyxXQUFXO0lBbUJ6Qzs7OztPQUlHO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUFvQixFQUFFLGdDQUF5QztRQUN6RyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxRQUFRLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7UUFFL0UsSUFBSSxDQUFDLGdDQUFnQyxHQUFHLGdDQUFnQyxDQUFDO1FBQ3pFLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQyxLQUFLLENBQUM7SUFDN0IsQ0FBQztJQUdELElBQWMsYUFBYTtRQUN2QixPQUFPO1lBQ0gsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLEtBQUssRUFBRSxJQUFJLENBQUMsS0FBSztTQUNwQixDQUFDO0lBQ04sQ0FBQztJQUNTLGdCQUFnQixDQUFDLEtBQTJCO1FBQ2xELE9BQU8sMEJBQTBCLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO0lBQ3BGLENBQUM7O0FBekNMLDRCQTBDQztBQXpDRzs7R0FFRztBQUNvQiwrQkFBc0IsR0FBRyxxQkFBcUIsQ0FBQztBQW9FMUU7Ozs7OztHQU1HO0FBQ0gsU0FBUywrQkFBK0IsQ0FBQyxVQUFlO0lBQ3BELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUN4RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQ3JGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUM5RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzNGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUN0RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ25GLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxxREFBcUQsQ0FBQyxDQUFDO0FBQzlFLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxrQ0FBa0MsQ0FBQyxVQUFlO0lBQ3ZELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCwrQkFBK0IsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUM1RCxPQUFPO1FBQ0wsT0FBTyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDO1FBQ2xELFVBQVUsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQztRQUN4RCxNQUFNLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7S0FDakQsQ0FBQztBQUNOLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cblxuaW1wb3J0ICogYXMgcm9zIGZyb20gJ0BhbGljbG91ZC9yb3MtY2RrLWNvcmUnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYFJvc0F1dG9TY2FsZUNvbmZpZ2AuXG4gKiBTZWUgaHR0cHM6Ly93d3cuYWxpYmFiYWNsb3VkLmNvbS9oZWxwL3Jvcy9kZXZlbG9wZXItcmVmZXJlbmNlL2FsaXl1bi1laHBjLWF1dG9zY2FsZWNvbmZpZ1xuICovXG5leHBvcnQgaW50ZXJmYWNlIFJvc0F1dG9TY2FsZUNvbmZpZ1Byb3BzIHtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBjbHVzdGVySWQ6IENsdXN0ZXIgSUQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgY2x1c3RlcklkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZW5hYmxlQXV0b0dyb3c6IFNwZWNpZmllcyB3aGV0aGVyIHRvIGVuYWJsZSBhdXRvIHNjYWxlLW91dC4gVmFsaWQgdmFsdWVzOlxuICAgICAqIHRydWU6IGVuYWJsZXMgYXV0byBzY2FsZS1vdXQuXG4gICAgICogZmFsc2U6IGRpc2FibGVzIGF1dG8gc2NhbGUtb3V0XG4gICAgICogRGVmYXVsdCB2YWx1ZTogZmFsc2VcbiAgICAgKi9cbiAgICByZWFkb25seSBlbmFibGVBdXRvR3Jvdz86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZW5hYmxlQXV0b1NocmluazogU3BlY2lmaWVzIHdoZXRoZXIgdG8gZW5hYmxlIGF1dG8gc2NhbGUtaW4uIFZhbGlkIHZhbHVlczpcbiAgICAgKiB0cnVlOiBlbmFibGVzIGF1dG8gc2NhbGUtaW4uXG4gICAgICogZmFsc2U6IGRpc2FibGVzIGF1dG8gc2NhbGUtaW5cbiAgICAgKiBEZWZhdWx0IHZhbHVlOiBmYWxzZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVuYWJsZUF1dG9TaHJpbms/OiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGV4Y2x1ZGVOb2RlczogVGhlIGNvbXB1dGUgbm9kZXMgdGhhdCBhcmUgZXhjbHVkZWQgZnJvbSB0aGUgbGlzdCBvZiBhdXRvIHNjYWxpbmcgbm9kZXMuIFNlcGFyYXRlIG11bHRpcGxlIGNvbXB1dGUgbm9kZXMgd2l0aCBjb21tYXMgKCwpLiBJZiB5b3Ugd2FudCB0byByZXRhaW4gYSBjb21wdXRlIG5vZGUsIHlvdSBjYW4gc2V0IHRoZSBub2RlIGFzIGFuIGV4Y2VwdGlvbmFsIG5vZGUuIFRoZW4sIHRoZSBub2RlIGlzIG5vdCByZWxlYXNlZCBpZiBpdCBpcyBpZGxlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGV4Y2x1ZGVOb2Rlcz86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBleHRyYU5vZGVzR3Jvd1JhdGlvOiBUaGUgcGVyY2VudGFnZSBvZiBleHRyYSBjb21wdXRlIG5vZGVzLlxuICAgICAqIERlZmF1bHQgdmFsdWU6IDBcbiAgICAgKi9cbiAgICByZWFkb25seSBleHRyYU5vZGVzR3Jvd1JhdGlvPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGdyb3dJbnRlcnZhbEluTWludXRlczogVGhlIGludGVydmFsIGJldHdlZW4gdHdvIGNvbnNlY3V0aXZlIHJvdW5kcyBvZiBzY2FsZS1vdXQuIFVuaXQ6IG1pbnV0ZXMuXG4gICAgICogRGVmYXVsdCB2YWx1ZTogMlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGdyb3dJbnRlcnZhbEluTWludXRlcz86IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBncm93UmF0aW86IFRoZSBwZXJjZW50YWdlIG9mIGVhY2ggcm91bmQgb2Ygc2NhbGUtb3V0LlxuICAgICAqIERlZmF1bHQgdmFsdWU6IDEwMFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGdyb3dSYXRpbz86IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBncm93VGltZW91dEluTWludXRlczogVGhlIHNjYWxlLW91dCB0aW1lb3V0IHBlcmlvZC4gVW5pdDogbWludXRlcy5cbiAgICAgKiBEZWZhdWx0IHZhbHVlOiAyMFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGdyb3dUaW1lb3V0SW5NaW51dGVzPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGltYWdlSWQ6IFRoZSBJRCBvZiB0aGUgaW1hZ2UuXG4gICAgICogSWYgeW91IHNldCBib3RoIFF1ZXVlcy5OLlF1ZXVlSW1hZ2VJZCBhbmQgSW1hZ2VJZCwgUXVldWVzLk4uUXVldWVJbWFnZUlkIHByZXZhaWxzLlxuICAgICAqIElmIHlvdSBzZXQgUXVldWVzLk4uUXVldWVJbWFnZUlkIG9yIEltYWdlSWQsIHRoZSBwYXJhbWV0ZXIgdGhhdCB5b3Ugc2V0IHRha2VzIGVmZmVjdC5cbiAgICAgKiBJZiB5b3UgbGVhdmUgYm90aCBRdWV1ZXMuTi5RdWV1ZUltYWdlSWQgYW5kIEltYWdlSWQgZW1wdHksIHRoZSBpbWFnZSB0aGF0IHdhcyBzcGVjaWZpZWQgd2hlbiB5b3UgY3JlYXRlZCB0aGUgY2x1c3RlciBvciB0aGUgbGFzdCB0aW1lIHdoZW4geW91IHNjYWxlZCBvdXQgdGhlIGNsdXN0ZXIgaXMgdXNlZCBieSBkZWZhdWx0LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGltYWdlSWQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgbWF4Tm9kZXNJbkNsdXN0ZXI6IFRoZSBtYXhpbXVtIG51bWJlciBvZiBjb21wdXRlIG5vZGVzIHRoYXQgY2FuIGJlIGFkZGVkIGluIHRoZSBjbHVzdGVyLlxuICAgICAqIERlZmF1bHQgdmFsdWU6IDEwMFxuICAgICAqL1xuICAgIHJlYWRvbmx5IG1heE5vZGVzSW5DbHVzdGVyPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHF1ZXVlczpcbiAgICAgKi9cbiAgICByZWFkb25seSBxdWV1ZXM/OiBBcnJheTxSb3NBdXRvU2NhbGVDb25maWcuUXVldWVzUHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHNocmlua0lkbGVUaW1lczogVGhlIG51bWJlciBvZiBjb25zZWN1dGl2ZSB0aW1lcyB0aGF0IGEgY29tcHV0ZSBub2RlIGlzIGlkbGUgZHVyaW5nIHRoZSByZXNvdXJjZSBzY2FsZS1pbiBjaGVjay5cbiAgICAgKiBEZWZhdWx0IHZhbHVlOiAzXG4gICAgICovXG4gICAgcmVhZG9ubHkgc2hyaW5rSWRsZVRpbWVzPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHNocmlua0ludGVydmFsSW5NaW51dGVzOiBTVGhlIGludGVydmFsIGJldHdlZW4gdHdvIGNvbnNlY3V0aXZlIHJvdW5kcyBvZiBzY2FsZS1pbi4gVW5pdDogbWludXRlcy5cbiAgICAgKiBEZWZhdWx0IHZhbHVlOiAyXG4gICAgICovXG4gICAgcmVhZG9ubHkgc2hyaW5rSW50ZXJ2YWxJbk1pbnV0ZXM/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgc3BvdFByaWNlTGltaXQ6IFRoZSBtYXhpbXVtIGhvdXJseSBwcmljZSBvZiB0aGUgY29tcHV0ZSBub2Rlcy4gVGhlIHZhbHVlIGNhbiBiZSBhY2N1cmF0ZSB0byB0aHJlZSBkZWNpbWFsIHBsYWNlcy4gVGhlIHBhcmFtZXRlciB0YWtlcyBlZmZlY3Qgb25seSB3aGVuIFNwb3RTdHJhdGVneSBpcyBzZXQgdG8gU3BvdFdpdGhQcmljZUxpbWl0LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNwb3RQcmljZUxpbWl0PzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHNwb3RTdHJhdGVneTogVGhlIHByZWVtcHRpb24gcG9saWN5IG9mIHRoZSBjb21wdXRlIG5vZGVzLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogTm9TcG90OiBUaGUgY29tcHV0ZSBub2RlcyBhcmUgcGF5LWFzLXlvdS1nbyBpbnN0YW5jZXMuXG4gICAgICogU3BvdFdpdGhQcmljZUxpbWl0OiBUaGUgY29tcHV0ZSBub2RlcyBhcmUgcHJlZW1wdGlibGUgaW5zdGFuY2VzIHRoYXQgaGF2ZSBhIHVzZXItZGVmaW5lZCBtYXhpbXVtIGhvdXJseSBwcmljZS5cbiAgICAgKiBTcG90QXNQcmljZUdvOiBUaGUgY29tcHV0ZSBub2RlcyBhcmUgcHJlZW1wdGlibGUgaW5zdGFuY2VzIGZvciB3aGljaCB0aGUgbWFya2V0IHByaWNlIGF0IHRoZSB0aW1lIG9mIHB1cmNoYXNlIGlzIHVzZWQgYXMgdGhlIGJpZCBwcmljZS5cbiAgICAgKiBEZWZhdWx0IHZhbHVlOiBOb1Nwb3RcbiAgICAgKi9cbiAgICByZWFkb25seSBzcG90U3RyYXRlZ3k/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgUm9zQXV0b1NjYWxlQ29uZmlnUHJvcHNgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFJvc0F1dG9TY2FsZUNvbmZpZ1Byb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIFJvc0F1dG9TY2FsZUNvbmZpZ1Byb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IHJvcy5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiByb3MuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IHJvcy5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmKHByb3BlcnRpZXMuZXh0cmFOb2Rlc0dyb3dSYXRpbyAmJiAodHlwZW9mIHByb3BlcnRpZXMuZXh0cmFOb2Rlc0dyb3dSYXRpbykgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZXh0cmFOb2Rlc0dyb3dSYXRpbycsIHJvcy52YWxpZGF0ZVJhbmdlKSh7XG4gICAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLmV4dHJhTm9kZXNHcm93UmF0aW8sXG4gICAgICAgICAgICBtaW46IDAsXG4gICAgICAgICAgICBtYXg6IDEwMCxcbiAgICAgICAgICB9KSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZXh0cmFOb2Rlc0dyb3dSYXRpbycsIHJvcy52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5leHRyYU5vZGVzR3Jvd1JhdGlvKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdlbmFibGVBdXRvR3JvdycsIHJvcy52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMuZW5hYmxlQXV0b0dyb3cpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2NsdXN0ZXJJZCcsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5jbHVzdGVySWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2NsdXN0ZXJJZCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5jbHVzdGVySWQpKTtcbiAgICBpZihwcm9wZXJ0aWVzLnNocmlua0lkbGVUaW1lcyAmJiAodHlwZW9mIHByb3BlcnRpZXMuc2hyaW5rSWRsZVRpbWVzKSAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdzaHJpbmtJZGxlVGltZXMnLCByb3MudmFsaWRhdGVSYW5nZSkoe1xuICAgICAgICAgICAgZGF0YTogcHJvcGVydGllcy5zaHJpbmtJZGxlVGltZXMsXG4gICAgICAgICAgICBtaW46IDIsXG4gICAgICAgICAgICBtYXg6IDUsXG4gICAgICAgICAgfSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3Nocmlua0lkbGVUaW1lcycsIHJvcy52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5zaHJpbmtJZGxlVGltZXMpKTtcbiAgICBpZihwcm9wZXJ0aWVzLm1heE5vZGVzSW5DbHVzdGVyICYmICh0eXBlb2YgcHJvcGVydGllcy5tYXhOb2Rlc0luQ2x1c3RlcikgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignbWF4Tm9kZXNJbkNsdXN0ZXInLCByb3MudmFsaWRhdGVSYW5nZSkoe1xuICAgICAgICAgICAgZGF0YTogcHJvcGVydGllcy5tYXhOb2Rlc0luQ2x1c3RlcixcbiAgICAgICAgICAgIG1pbjogMSxcbiAgICAgICAgICAgIG1heDogNTAwLFxuICAgICAgICAgIH0pKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdtYXhOb2Rlc0luQ2x1c3RlcicsIHJvcy52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5tYXhOb2Rlc0luQ2x1c3RlcikpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZW5hYmxlQXV0b1NocmluaycsIHJvcy52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMuZW5hYmxlQXV0b1NocmluaykpO1xuICAgIGlmKHByb3BlcnRpZXMuZ3Jvd1JhdGlvICYmICh0eXBlb2YgcHJvcGVydGllcy5ncm93UmF0aW8pICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2dyb3dSYXRpbycsIHJvcy52YWxpZGF0ZVJhbmdlKSh7XG4gICAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLmdyb3dSYXRpbyxcbiAgICAgICAgICAgIG1pbjogMSxcbiAgICAgICAgICAgIG1heDogMTAwLFxuICAgICAgICAgIH0pKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdncm93UmF0aW8nLCByb3MudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMuZ3Jvd1JhdGlvKSk7XG4gICAgaWYocHJvcGVydGllcy5ncm93SW50ZXJ2YWxJbk1pbnV0ZXMgJiYgKHR5cGVvZiBwcm9wZXJ0aWVzLmdyb3dJbnRlcnZhbEluTWludXRlcykgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZ3Jvd0ludGVydmFsSW5NaW51dGVzJywgcm9zLnZhbGlkYXRlUmFuZ2UpKHtcbiAgICAgICAgICAgIGRhdGE6IHByb3BlcnRpZXMuZ3Jvd0ludGVydmFsSW5NaW51dGVzLFxuICAgICAgICAgICAgbWluOiAyLFxuICAgICAgICAgICAgbWF4OiAxMCxcbiAgICAgICAgICB9KSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZ3Jvd0ludGVydmFsSW5NaW51dGVzJywgcm9zLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmdyb3dJbnRlcnZhbEluTWludXRlcykpO1xuICAgIGlmKHByb3BlcnRpZXMuZ3Jvd1RpbWVvdXRJbk1pbnV0ZXMgJiYgKHR5cGVvZiBwcm9wZXJ0aWVzLmdyb3dUaW1lb3V0SW5NaW51dGVzKSAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdncm93VGltZW91dEluTWludXRlcycsIHJvcy52YWxpZGF0ZVJhbmdlKSh7XG4gICAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLmdyb3dUaW1lb3V0SW5NaW51dGVzLFxuICAgICAgICAgICAgbWluOiAxMCxcbiAgICAgICAgICAgIG1heDogNjAsXG4gICAgICAgICAgfSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2dyb3dUaW1lb3V0SW5NaW51dGVzJywgcm9zLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmdyb3dUaW1lb3V0SW5NaW51dGVzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdpbWFnZUlkJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmltYWdlSWQpKTtcbiAgICBpZihwcm9wZXJ0aWVzLnNocmlua0ludGVydmFsSW5NaW51dGVzICYmICh0eXBlb2YgcHJvcGVydGllcy5zaHJpbmtJbnRlcnZhbEluTWludXRlcykgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignc2hyaW5rSW50ZXJ2YWxJbk1pbnV0ZXMnLCByb3MudmFsaWRhdGVSYW5nZSkoe1xuICAgICAgICAgICAgZGF0YTogcHJvcGVydGllcy5zaHJpbmtJbnRlcnZhbEluTWludXRlcyxcbiAgICAgICAgICAgIG1pbjogMixcbiAgICAgICAgICAgIG1heDogMTAsXG4gICAgICAgICAgfSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3Nocmlua0ludGVydmFsSW5NaW51dGVzJywgcm9zLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLnNocmlua0ludGVydmFsSW5NaW51dGVzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdzcG90UHJpY2VMaW1pdCcsIHJvcy52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5zcG90UHJpY2VMaW1pdCkpO1xuICAgIGlmKHByb3BlcnRpZXMucXVldWVzICYmIChBcnJheS5pc0FycmF5KHByb3BlcnRpZXMucXVldWVzKSB8fCAodHlwZW9mIHByb3BlcnRpZXMucXVldWVzKSA9PT0gJ3N0cmluZycpKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigncXVldWVzJywgcm9zLnZhbGlkYXRlTGVuZ3RoKSh7XG4gICAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLnF1ZXVlcy5sZW5ndGgsXG4gICAgICAgICAgICBtaW46IHVuZGVmaW5lZCxcbiAgICAgICAgICAgIG1heDogOCxcbiAgICAgICAgICB9KSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigncXVldWVzJywgcm9zLmxpc3RWYWxpZGF0b3IoUm9zQXV0b1NjYWxlQ29uZmlnX1F1ZXVlc1Byb3BlcnR5VmFsaWRhdG9yKSkocHJvcGVydGllcy5xdWV1ZXMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2V4Y2x1ZGVOb2RlcycsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5leGNsdWRlTm9kZXMpKTtcbiAgICBpZihwcm9wZXJ0aWVzLnNwb3RTdHJhdGVneSAmJiAodHlwZW9mIHByb3BlcnRpZXMuc3BvdFN0cmF0ZWd5KSAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdzcG90U3RyYXRlZ3knLCByb3MudmFsaWRhdGVBbGxvd2VkVmFsdWVzKSh7XG4gICAgICAgICAgZGF0YTogcHJvcGVydGllcy5zcG90U3RyYXRlZ3ksXG4gICAgICAgICAgYWxsb3dlZFZhbHVlczogW1wiTm9TcG90XCIsXCJTcG90V2l0aFByaWNlTGltaXRcIixcIlNwb3RBc1ByaWNlR29cIl0sXG4gICAgICAgIH0pKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdzcG90U3RyYXRlZ3knLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc3BvdFN0cmF0ZWd5KSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlJvc0F1dG9TY2FsZUNvbmZpZ1Byb3BzXCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgcHJvcGVydGllcyBvZiBhbiBgQUxJWVVOOjpFSFBDOjpBdXRvU2NhbGVDb25maWdgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFJvc0F1dG9TY2FsZUNvbmZpZ1Byb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgcHJvcGVydGllcyBvZiBhbiBgQUxJWVVOOjpFSFBDOjpBdXRvU2NhbGVDb25maWdgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gcm9zQXV0b1NjYWxlQ29uZmlnUHJvcHNUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXM6IGFueSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW4pOiBhbnkge1xuICAgIGlmICghcm9zLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBpZihlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCkge1xuICAgICAgICBSb3NBdXRvU2NhbGVDb25maWdQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgfVxuICAgIHJldHVybiB7XG4gICAgICAnQ2x1c3RlcklkJzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5jbHVzdGVySWQpLFxuICAgICAgJ0VuYWJsZUF1dG9Hcm93Jzogcm9zLmJvb2xlYW5Ub1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuZW5hYmxlQXV0b0dyb3cpLFxuICAgICAgJ0VuYWJsZUF1dG9TaHJpbmsnOiByb3MuYm9vbGVhblRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5lbmFibGVBdXRvU2hyaW5rKSxcbiAgICAgICdFeGNsdWRlTm9kZXMnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmV4Y2x1ZGVOb2RlcyksXG4gICAgICAnRXh0cmFOb2Rlc0dyb3dSYXRpbyc6IHJvcy5udW1iZXJUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuZXh0cmFOb2Rlc0dyb3dSYXRpbyksXG4gICAgICAnR3Jvd0ludGVydmFsSW5NaW51dGVzJzogcm9zLm51bWJlclRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5ncm93SW50ZXJ2YWxJbk1pbnV0ZXMpLFxuICAgICAgJ0dyb3dSYXRpbyc6IHJvcy5udW1iZXJUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuZ3Jvd1JhdGlvKSxcbiAgICAgICdHcm93VGltZW91dEluTWludXRlcyc6IHJvcy5udW1iZXJUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuZ3Jvd1RpbWVvdXRJbk1pbnV0ZXMpLFxuICAgICAgJ0ltYWdlSWQnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmltYWdlSWQpLFxuICAgICAgJ01heE5vZGVzSW5DbHVzdGVyJzogcm9zLm51bWJlclRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5tYXhOb2Rlc0luQ2x1c3RlciksXG4gICAgICAnUXVldWVzJzogcm9zLmxpc3RNYXBwZXIocm9zQXV0b1NjYWxlQ29uZmlnUXVldWVzUHJvcGVydHlUb1Jvc1RlbXBsYXRlKShwcm9wZXJ0aWVzLnF1ZXVlcyksXG4gICAgICAnU2hyaW5rSWRsZVRpbWVzJzogcm9zLm51bWJlclRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5zaHJpbmtJZGxlVGltZXMpLFxuICAgICAgJ1Nocmlua0ludGVydmFsSW5NaW51dGVzJzogcm9zLm51bWJlclRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5zaHJpbmtJbnRlcnZhbEluTWludXRlcyksXG4gICAgICAnU3BvdFByaWNlTGltaXQnOiByb3MubnVtYmVyVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnNwb3RQcmljZUxpbWl0KSxcbiAgICAgICdTcG90U3RyYXRlZ3knOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnNwb3RTdHJhdGVneSksXG4gICAgfTtcbn1cblxuLyoqXG4gKiBUaGlzIGNsYXNzIGlzIGEgYmFzZSBlbmNhcHN1bGF0aW9uIGFyb3VuZCB0aGUgUk9TIHJlc291cmNlIHR5cGUgYEFMSVlVTjo6RUhQQzo6QXV0b1NjYWxlQ29uZmlnYCwgd2hpY2ggaXMgdXNlZCB0byBjb25maWd1cmUgdGhlIGF1dG8gc2NhbGluZyBzZXR0aW5ncyBvZiBhIGNsdXN0ZXIuXG4gKiBATm90ZSBUaGlzIGNsYXNzIGRvZXMgbm90IGNvbnRhaW4gYWRkaXRpb25hbCBmdW5jdGlvbnMsIHNvIGl0IGlzIHJlY29tbWVuZGVkIHRvIHVzZSB0aGUgYEF1dG9TY2FsZUNvbmZpZ2AgY2xhc3MgaW5zdGVhZCBvZiB0aGlzIGNsYXNzIGZvciBhIG1vcmUgY29udmVuaWVudCBkZXZlbG9wbWVudCBleHBlcmllbmNlLlxuICogU2VlIGh0dHBzOi8vd3d3LmFsaWJhYmFjbG91ZC5jb20vaGVscC9yb3MvZGV2ZWxvcGVyLXJlZmVyZW5jZS9hbGl5dW4tZWhwYy1hdXRvc2NhbGVjb25maWdcbiAqL1xuZXhwb3J0IGNsYXNzIFJvc0F1dG9TY2FsZUNvbmZpZyBleHRlbmRzIHJvcy5Sb3NSZXNvdXJjZSB7XG4gICAgLyoqXG4gICAgICogVGhlIHJlc291cmNlIHR5cGUgbmFtZSBmb3IgdGhpcyByZXNvdXJjZSBjbGFzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJPU19SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkFMSVlVTjo6RUhQQzo6QXV0b1NjYWxlQ29uZmlnXCI7XG5cbiAgICAvKipcbiAgICAgKiBAQXR0cmlidXRlIENsdXN0ZXJJZDogQ2x1c3RlciBJZC5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckNsdXN0ZXJJZDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgcHVibGljIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OiBib29sZWFuO1xuXG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgY2x1c3RlcklkOiBDbHVzdGVyIElELlxuICAgICAqL1xuICAgIHB1YmxpYyBjbHVzdGVySWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBlbmFibGVBdXRvR3JvdzogU3BlY2lmaWVzIHdoZXRoZXIgdG8gZW5hYmxlIGF1dG8gc2NhbGUtb3V0LiBWYWxpZCB2YWx1ZXM6XG4gICAgICogdHJ1ZTogZW5hYmxlcyBhdXRvIHNjYWxlLW91dC5cbiAgICAgKiBmYWxzZTogZGlzYWJsZXMgYXV0byBzY2FsZS1vdXRcbiAgICAgKiBEZWZhdWx0IHZhbHVlOiBmYWxzZVxuICAgICAqL1xuICAgIHB1YmxpYyBlbmFibGVBdXRvR3JvdzogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBlbmFibGVBdXRvU2hyaW5rOiBTcGVjaWZpZXMgd2hldGhlciB0byBlbmFibGUgYXV0byBzY2FsZS1pbi4gVmFsaWQgdmFsdWVzOlxuICAgICAqIHRydWU6IGVuYWJsZXMgYXV0byBzY2FsZS1pbi5cbiAgICAgKiBmYWxzZTogZGlzYWJsZXMgYXV0byBzY2FsZS1pblxuICAgICAqIERlZmF1bHQgdmFsdWU6IGZhbHNlXG4gICAgICovXG4gICAgcHVibGljIGVuYWJsZUF1dG9TaHJpbms6IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZXhjbHVkZU5vZGVzOiBUaGUgY29tcHV0ZSBub2RlcyB0aGF0IGFyZSBleGNsdWRlZCBmcm9tIHRoZSBsaXN0IG9mIGF1dG8gc2NhbGluZyBub2Rlcy4gU2VwYXJhdGUgbXVsdGlwbGUgY29tcHV0ZSBub2RlcyB3aXRoIGNvbW1hcyAoLCkuIElmIHlvdSB3YW50IHRvIHJldGFpbiBhIGNvbXB1dGUgbm9kZSwgeW91IGNhbiBzZXQgdGhlIG5vZGUgYXMgYW4gZXhjZXB0aW9uYWwgbm9kZS4gVGhlbiwgdGhlIG5vZGUgaXMgbm90IHJlbGVhc2VkIGlmIGl0IGlzIGlkbGUuXG4gICAgICovXG4gICAgcHVibGljIGV4Y2x1ZGVOb2Rlczogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGV4dHJhTm9kZXNHcm93UmF0aW86IFRoZSBwZXJjZW50YWdlIG9mIGV4dHJhIGNvbXB1dGUgbm9kZXMuXG4gICAgICogRGVmYXVsdCB2YWx1ZTogMFxuICAgICAqL1xuICAgIHB1YmxpYyBleHRyYU5vZGVzR3Jvd1JhdGlvOiBudW1iZXIgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZ3Jvd0ludGVydmFsSW5NaW51dGVzOiBUaGUgaW50ZXJ2YWwgYmV0d2VlbiB0d28gY29uc2VjdXRpdmUgcm91bmRzIG9mIHNjYWxlLW91dC4gVW5pdDogbWludXRlcy5cbiAgICAgKiBEZWZhdWx0IHZhbHVlOiAyXG4gICAgICovXG4gICAgcHVibGljIGdyb3dJbnRlcnZhbEluTWludXRlczogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGdyb3dSYXRpbzogVGhlIHBlcmNlbnRhZ2Ugb2YgZWFjaCByb3VuZCBvZiBzY2FsZS1vdXQuXG4gICAgICogRGVmYXVsdCB2YWx1ZTogMTAwXG4gICAgICovXG4gICAgcHVibGljIGdyb3dSYXRpbzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGdyb3dUaW1lb3V0SW5NaW51dGVzOiBUaGUgc2NhbGUtb3V0IHRpbWVvdXQgcGVyaW9kLiBVbml0OiBtaW51dGVzLlxuICAgICAqIERlZmF1bHQgdmFsdWU6IDIwXG4gICAgICovXG4gICAgcHVibGljIGdyb3dUaW1lb3V0SW5NaW51dGVzOiBudW1iZXIgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgaW1hZ2VJZDogVGhlIElEIG9mIHRoZSBpbWFnZS5cbiAgICAgKiBJZiB5b3Ugc2V0IGJvdGggUXVldWVzLk4uUXVldWVJbWFnZUlkIGFuZCBJbWFnZUlkLCBRdWV1ZXMuTi5RdWV1ZUltYWdlSWQgcHJldmFpbHMuXG4gICAgICogSWYgeW91IHNldCBRdWV1ZXMuTi5RdWV1ZUltYWdlSWQgb3IgSW1hZ2VJZCwgdGhlIHBhcmFtZXRlciB0aGF0IHlvdSBzZXQgdGFrZXMgZWZmZWN0LlxuICAgICAqIElmIHlvdSBsZWF2ZSBib3RoIFF1ZXVlcy5OLlF1ZXVlSW1hZ2VJZCBhbmQgSW1hZ2VJZCBlbXB0eSwgdGhlIGltYWdlIHRoYXQgd2FzIHNwZWNpZmllZCB3aGVuIHlvdSBjcmVhdGVkIHRoZSBjbHVzdGVyIG9yIHRoZSBsYXN0IHRpbWUgd2hlbiB5b3Ugc2NhbGVkIG91dCB0aGUgY2x1c3RlciBpcyB1c2VkIGJ5IGRlZmF1bHQuXG4gICAgICovXG4gICAgcHVibGljIGltYWdlSWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBtYXhOb2Rlc0luQ2x1c3RlcjogVGhlIG1heGltdW0gbnVtYmVyIG9mIGNvbXB1dGUgbm9kZXMgdGhhdCBjYW4gYmUgYWRkZWQgaW4gdGhlIGNsdXN0ZXIuXG4gICAgICogRGVmYXVsdCB2YWx1ZTogMTAwXG4gICAgICovXG4gICAgcHVibGljIG1heE5vZGVzSW5DbHVzdGVyOiBudW1iZXIgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgcXVldWVzOlxuICAgICAqL1xuICAgIHB1YmxpYyBxdWV1ZXM6IEFycmF5PFJvc0F1dG9TY2FsZUNvbmZpZy5RdWV1ZXNQcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgc2hyaW5rSWRsZVRpbWVzOiBUaGUgbnVtYmVyIG9mIGNvbnNlY3V0aXZlIHRpbWVzIHRoYXQgYSBjb21wdXRlIG5vZGUgaXMgaWRsZSBkdXJpbmcgdGhlIHJlc291cmNlIHNjYWxlLWluIGNoZWNrLlxuICAgICAqIERlZmF1bHQgdmFsdWU6IDNcbiAgICAgKi9cbiAgICBwdWJsaWMgc2hyaW5rSWRsZVRpbWVzOiBudW1iZXIgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgc2hyaW5rSW50ZXJ2YWxJbk1pbnV0ZXM6IFNUaGUgaW50ZXJ2YWwgYmV0d2VlbiB0d28gY29uc2VjdXRpdmUgcm91bmRzIG9mIHNjYWxlLWluLiBVbml0OiBtaW51dGVzLlxuICAgICAqIERlZmF1bHQgdmFsdWU6IDJcbiAgICAgKi9cbiAgICBwdWJsaWMgc2hyaW5rSW50ZXJ2YWxJbk1pbnV0ZXM6IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBzcG90UHJpY2VMaW1pdDogVGhlIG1heGltdW0gaG91cmx5IHByaWNlIG9mIHRoZSBjb21wdXRlIG5vZGVzLiBUaGUgdmFsdWUgY2FuIGJlIGFjY3VyYXRlIHRvIHRocmVlIGRlY2ltYWwgcGxhY2VzLiBUaGUgcGFyYW1ldGVyIHRha2VzIGVmZmVjdCBvbmx5IHdoZW4gU3BvdFN0cmF0ZWd5IGlzIHNldCB0byBTcG90V2l0aFByaWNlTGltaXQuXG4gICAgICovXG4gICAgcHVibGljIHNwb3RQcmljZUxpbWl0OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgc3BvdFN0cmF0ZWd5OiBUaGUgcHJlZW1wdGlvbiBwb2xpY3kgb2YgdGhlIGNvbXB1dGUgbm9kZXMuIFZhbGlkIHZhbHVlczpcbiAgICAgKiBOb1Nwb3Q6IFRoZSBjb21wdXRlIG5vZGVzIGFyZSBwYXktYXMteW91LWdvIGluc3RhbmNlcy5cbiAgICAgKiBTcG90V2l0aFByaWNlTGltaXQ6IFRoZSBjb21wdXRlIG5vZGVzIGFyZSBwcmVlbXB0aWJsZSBpbnN0YW5jZXMgdGhhdCBoYXZlIGEgdXNlci1kZWZpbmVkIG1heGltdW0gaG91cmx5IHByaWNlLlxuICAgICAqIFNwb3RBc1ByaWNlR286IFRoZSBjb21wdXRlIG5vZGVzIGFyZSBwcmVlbXB0aWJsZSBpbnN0YW5jZXMgZm9yIHdoaWNoIHRoZSBtYXJrZXQgcHJpY2UgYXQgdGhlIHRpbWUgb2YgcHVyY2hhc2UgaXMgdXNlZCBhcyB0aGUgYmlkIHByaWNlLlxuICAgICAqIERlZmF1bHQgdmFsdWU6IE5vU3BvdFxuICAgICAqL1xuICAgIHB1YmxpYyBzcG90U3RyYXRlZ3k6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IHJvcy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBSb3NBdXRvU2NhbGVDb25maWdQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW4pIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IFJvc0F1dG9TY2FsZUNvbmZpZy5ST1NfUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgdGhpcy5hdHRyQ2x1c3RlcklkID0gdGhpcy5nZXRBdHQoJ0NsdXN0ZXJJZCcpO1xuXG4gICAgICAgIHRoaXMuZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgPSBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDtcbiAgICAgICAgdGhpcy5jbHVzdGVySWQgPSBwcm9wcy5jbHVzdGVySWQ7XG4gICAgICAgIHRoaXMuZW5hYmxlQXV0b0dyb3cgPSBwcm9wcy5lbmFibGVBdXRvR3JvdztcbiAgICAgICAgdGhpcy5lbmFibGVBdXRvU2hyaW5rID0gcHJvcHMuZW5hYmxlQXV0b1NocmluaztcbiAgICAgICAgdGhpcy5leGNsdWRlTm9kZXMgPSBwcm9wcy5leGNsdWRlTm9kZXM7XG4gICAgICAgIHRoaXMuZXh0cmFOb2Rlc0dyb3dSYXRpbyA9IHByb3BzLmV4dHJhTm9kZXNHcm93UmF0aW87XG4gICAgICAgIHRoaXMuZ3Jvd0ludGVydmFsSW5NaW51dGVzID0gcHJvcHMuZ3Jvd0ludGVydmFsSW5NaW51dGVzO1xuICAgICAgICB0aGlzLmdyb3dSYXRpbyA9IHByb3BzLmdyb3dSYXRpbztcbiAgICAgICAgdGhpcy5ncm93VGltZW91dEluTWludXRlcyA9IHByb3BzLmdyb3dUaW1lb3V0SW5NaW51dGVzO1xuICAgICAgICB0aGlzLmltYWdlSWQgPSBwcm9wcy5pbWFnZUlkO1xuICAgICAgICB0aGlzLm1heE5vZGVzSW5DbHVzdGVyID0gcHJvcHMubWF4Tm9kZXNJbkNsdXN0ZXI7XG4gICAgICAgIHRoaXMucXVldWVzID0gcHJvcHMucXVldWVzO1xuICAgICAgICB0aGlzLnNocmlua0lkbGVUaW1lcyA9IHByb3BzLnNocmlua0lkbGVUaW1lcztcbiAgICAgICAgdGhpcy5zaHJpbmtJbnRlcnZhbEluTWludXRlcyA9IHByb3BzLnNocmlua0ludGVydmFsSW5NaW51dGVzO1xuICAgICAgICB0aGlzLnNwb3RQcmljZUxpbWl0ID0gcHJvcHMuc3BvdFByaWNlTGltaXQ7XG4gICAgICAgIHRoaXMuc3BvdFN0cmF0ZWd5ID0gcHJvcHMuc3BvdFN0cmF0ZWd5O1xuICAgIH1cblxuXG4gICAgcHJvdGVjdGVkIGdldCByb3NQcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGNsdXN0ZXJJZDogdGhpcy5jbHVzdGVySWQsXG4gICAgICAgICAgICBlbmFibGVBdXRvR3JvdzogdGhpcy5lbmFibGVBdXRvR3JvdyxcbiAgICAgICAgICAgIGVuYWJsZUF1dG9TaHJpbms6IHRoaXMuZW5hYmxlQXV0b1NocmluayxcbiAgICAgICAgICAgIGV4Y2x1ZGVOb2RlczogdGhpcy5leGNsdWRlTm9kZXMsXG4gICAgICAgICAgICBleHRyYU5vZGVzR3Jvd1JhdGlvOiB0aGlzLmV4dHJhTm9kZXNHcm93UmF0aW8sXG4gICAgICAgICAgICBncm93SW50ZXJ2YWxJbk1pbnV0ZXM6IHRoaXMuZ3Jvd0ludGVydmFsSW5NaW51dGVzLFxuICAgICAgICAgICAgZ3Jvd1JhdGlvOiB0aGlzLmdyb3dSYXRpbyxcbiAgICAgICAgICAgIGdyb3dUaW1lb3V0SW5NaW51dGVzOiB0aGlzLmdyb3dUaW1lb3V0SW5NaW51dGVzLFxuICAgICAgICAgICAgaW1hZ2VJZDogdGhpcy5pbWFnZUlkLFxuICAgICAgICAgICAgbWF4Tm9kZXNJbkNsdXN0ZXI6IHRoaXMubWF4Tm9kZXNJbkNsdXN0ZXIsXG4gICAgICAgICAgICBxdWV1ZXM6IHRoaXMucXVldWVzLFxuICAgICAgICAgICAgc2hyaW5rSWRsZVRpbWVzOiB0aGlzLnNocmlua0lkbGVUaW1lcyxcbiAgICAgICAgICAgIHNocmlua0ludGVydmFsSW5NaW51dGVzOiB0aGlzLnNocmlua0ludGVydmFsSW5NaW51dGVzLFxuICAgICAgICAgICAgc3BvdFByaWNlTGltaXQ6IHRoaXMuc3BvdFByaWNlTGltaXQsXG4gICAgICAgICAgICBzcG90U3RyYXRlZ3k6IHRoaXMuc3BvdFN0cmF0ZWd5LFxuICAgICAgICB9O1xuICAgIH1cbiAgICBwcm90ZWN0ZWQgcmVuZGVyUHJvcGVydGllcyhwcm9wczoge1trZXk6IHN0cmluZ106IGFueX0pOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiByb3NBdXRvU2NhbGVDb25maWdQcm9wc1RvUm9zVGVtcGxhdGUocHJvcHMsIHRoaXMuZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpO1xuICAgIH1cbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBSb3NBdXRvU2NhbGVDb25maWcge1xuICAgIC8qKlxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIERhdGFEaXNrc1Byb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEBQcm9wZXJ0eSBkYXRhRGlza0ttc0tleUlkOiBUaGUgS01TIGtleSBJRCBvZiB0aGUgZGF0YSBkaXNrLlxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgZGF0YURpc2tLbXNLZXlJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEBQcm9wZXJ0eSBkYXRhRGlza1BlcmZvcm1hbmNlTGV2ZWw6IFRoZSBwZXJmb3JtYW5jZSBsZXZlbCBvZiB0aGUgRVNTRCB1c2VkIGFzIHRoZSBkYXRhIGRpc2suIFRoZSBwYXJhbWV0ZXIgdGFrZXMgZWZmZWN0IG9ubHkgd2hlbiB0aGUgUXVldWVzLk4uRGF0YURpc2tzLk0uRGF0YURpc2tDYXRlZ29yeSBwYXJhbWV0ZXIgaXMgc2V0IHRvIGNsb3VkX2Vzc2QuIFZhbGlkIHZhbHVlczpcbiAgICAgKiBQTDA6IEEgc2luZ2xlIEVTU0QgY2FuIGRlbGl2ZXIgdXAgdG8gMTAsMDAwIHJhbmRvbSByZWFkXFwvd3JpdGUgSU9QUy5cbiAgICAgKiBQTDE6IEEgc2luZ2xlIEVTU0QgY2FuIGRlbGl2ZXIgdXAgdG8gNTAsMDAwIHJhbmRvbSByZWFkXFwvd3JpdGUgSU9QUy5cbiAgICAgKiBQTDI6IEEgc2luZ2xlIEVTU0QgY2FuIGRlbGl2ZXIgdXAgdG8gMTAwLDAwMCByYW5kb20gcmVhZFxcL3dyaXRlIElPUFMuXG4gICAgICogUEwzOiBBIHNpbmdsZSBFU1NEIGNhbiBkZWxpdmVyIHVwIHRvIDEsMDAwLDAwMCByYW5kb20gcmVhZFxcL3dyaXRlIElPUFMuXG4gICAgICogRGVmYXVsdCB2YWx1ZTogUEwxXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBkYXRhRGlza1BlcmZvcm1hbmNlTGV2ZWw/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBAUHJvcGVydHkgZGF0YURpc2tFbmNyeXB0ZWQ6IFNwZWNpZmllcyB3aGV0aGVyIHRvIGVuY3J5cHQgdGhlIGRhdGEgZGlzay5cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGRhdGFEaXNrRW5jcnlwdGVkPzogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEBQcm9wZXJ0eSBkYXRhRGlza0RlbGV0ZVdpdGhJbnN0YW5jZTogU3BlY2lmaWVzIHdoZXRoZXIgdGhlIGRhdGEgZGlzayBpcyByZWxlYXNlZCB3aGVuIHRoZSBub2RlIGlzIHJlbGVhc2VkLlxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgZGF0YURpc2tEZWxldGVXaXRoSW5zdGFuY2U/OiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogQFByb3BlcnR5IGRhdGFEaXNrU2l6ZTogVGhlIHNpemUgb2YgdGhlIGRhdGEgZGlzay4gVW5pdDogR0IuXG4gICAgICogRGVmYXVsdCB2YWx1ZTogNDBcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGRhdGFEaXNrU2l6ZT86IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEBQcm9wZXJ0eSBkYXRhRGlza0NhdGVnb3J5OiBUaGUgdHlwZSBvZiB0aGUgZGF0YSBkaXNrLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogY2xvdWRfZWZmaWNpZW5jeTogdWx0cmEgZGlzay5cbiAgICAgKiBjbG91ZF9zc2Q6IFNTRC5cbiAgICAgKiBjbG91ZF9lc3NkOiBFU1NELlxuICAgICAqIERlZmF1bHQgdmFsdWU6IGNsb3VkX2VmZmljaWVuY3lcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGRhdGFEaXNrQ2F0ZWdvcnk/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG4gICAgfVxufVxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBEYXRhRGlza3NQcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgRGF0YURpc2tzUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gUm9zQXV0b1NjYWxlQ29uZmlnX0RhdGFEaXNrc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IHJvcy5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiByb3MuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IHJvcy5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZGF0YURpc2tLbXNLZXlJZCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5kYXRhRGlza0ttc0tleUlkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdkYXRhRGlza1BlcmZvcm1hbmNlTGV2ZWwnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZGF0YURpc2tQZXJmb3JtYW5jZUxldmVsKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdkYXRhRGlza0VuY3J5cHRlZCcsIHJvcy52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMuZGF0YURpc2tFbmNyeXB0ZWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2RhdGFEaXNrRGVsZXRlV2l0aEluc3RhbmNlJywgcm9zLnZhbGlkYXRlQm9vbGVhbikocHJvcGVydGllcy5kYXRhRGlza0RlbGV0ZVdpdGhJbnN0YW5jZSkpO1xuICAgIGlmKHByb3BlcnRpZXMuZGF0YURpc2tTaXplICYmICh0eXBlb2YgcHJvcGVydGllcy5kYXRhRGlza1NpemUpICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2RhdGFEaXNrU2l6ZScsIHJvcy52YWxpZGF0ZVJhbmdlKSh7XG4gICAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLmRhdGFEaXNrU2l6ZSxcbiAgICAgICAgICAgIG1pbjogNDAsXG4gICAgICAgICAgICBtYXg6IDUwMCxcbiAgICAgICAgICB9KSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZGF0YURpc2tTaXplJywgcm9zLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmRhdGFEaXNrU2l6ZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZGF0YURpc2tDYXRlZ29yeScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5kYXRhRGlza0NhdGVnb3J5KSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkRhdGFEaXNrc1Byb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgcHJvcGVydGllcyBvZiBhbiBgQUxJWVVOOjpFSFBDOjpBdXRvU2NhbGVDb25maWcuRGF0YURpc2tzYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBEYXRhRGlza3NQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIHByb3BlcnRpZXMgb2YgYW4gYEFMSVlVTjo6RUhQQzo6QXV0b1NjYWxlQ29uZmlnLkRhdGFEaXNrc2AgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiByb3NBdXRvU2NhbGVDb25maWdEYXRhRGlza3NQcm9wZXJ0eVRvUm9zVGVtcGxhdGUocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgUm9zQXV0b1NjYWxlQ29uZmlnX0RhdGFEaXNrc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgJ0RhdGFEaXNrS01TS2V5SWQnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmRhdGFEaXNrS21zS2V5SWQpLFxuICAgICAgJ0RhdGFEaXNrUGVyZm9ybWFuY2VMZXZlbCc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuZGF0YURpc2tQZXJmb3JtYW5jZUxldmVsKSxcbiAgICAgICdEYXRhRGlza0VuY3J5cHRlZCc6IHJvcy5ib29sZWFuVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmRhdGFEaXNrRW5jcnlwdGVkKSxcbiAgICAgICdEYXRhRGlza0RlbGV0ZVdpdGhJbnN0YW5jZSc6IHJvcy5ib29sZWFuVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmRhdGFEaXNrRGVsZXRlV2l0aEluc3RhbmNlKSxcbiAgICAgICdEYXRhRGlza1NpemUnOiByb3MubnVtYmVyVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmRhdGFEaXNrU2l6ZSksXG4gICAgICAnRGF0YURpc2tDYXRlZ29yeSc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuZGF0YURpc2tDYXRlZ29yeSksXG4gICAgfTtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBSb3NBdXRvU2NhbGVDb25maWcge1xuICAgIC8qKlxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIEluc3RhbmNlVHlwZXNQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBAUHJvcGVydHkgem9uZUlkOiBUaGUgem9uZSBJRCBvZiB0aGUgY29tcHV0ZSBub2RlcyB0aGF0IGFyZSBhdXRvbWF0aWNhbGx5IGFkZGVkIGluIHRoZSBxdWV1ZSBiZWxvbmdzLlxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgem9uZUlkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBAUHJvcGVydHkgdlN3aXRjaElkOiBUaGUgdlN3aXRjaCBJRCBvZiB0aGUgY29tcHV0ZSBub2RlcyB0aGF0IGFyZSBhdXRvbWF0aWNhbGx5IGFkZGVkIGluIHRoZSBxdWV1ZS5cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHZTd2l0Y2hJZDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogQFByb3BlcnR5IHNwb3RQcmljZUxpbWl0OiBUaGUgbWF4aW11bSBob3VybHkgcHJpY2Ugb2YgdGhlIGNvbXB1dGUgbm9kZXMgdGhhdCBhcmUgYXV0b21hdGljYWxseSBhZGRlZCBpbiB0aGUgcXVldWUuIFRoZSB2YWx1ZSBjYW4gYmUgYWNjdXJhdGUgdG8gdGhyZWUgZGVjaW1hbCBwbGFjZXMuIFRoZSBwYXJhbWV0ZXIgdGFrZXMgZWZmZWN0IG9ubHkgd2hlbiBRdWV1ZXMuTi5JbnN0YW5jZVR5cGVzLk0uU3BvdFN0cmF0ZWd5IGlzIHNldCB0byBTcG90V2l0aFByaWNlTGltaXRcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHNwb3RQcmljZUxpbWl0PzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogQFByb3BlcnR5IGluc3RhbmNlVHlwZTogVGhlIGluc3RhbmNlIHR5cGUgb2YgdGhlIGNvbXB1dGUgbm9kZXMgdGhhdCBhcmUgYXV0b21hdGljYWxseSBhZGRlZCBpbiB0aGUgcXVldWUuXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBpbnN0YW5jZVR5cGU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEBQcm9wZXJ0eSBzcG90U3RyYXRlZ3k6IFRoZSBiaWRkaW5nIG1ldGhvZCBvZiB0aGUgY29tcHV0ZSBub2RlcyB0aGF0IGFyZSBhdXRvbWF0aWNhbGx5IGFkZGVkIGluIHRoZSBxdWV1ZS4gVmFsaWQgdmFsdWVzOlxuICAgICAqIE5vU3BvdDogVGhlIGNvbXB1dGUgbm9kZXMgYXJlIHBheS1hcy15b3UtZ28gaW5zdGFuY2VzLlxuICAgICAqIFNwb3RXaXRoUHJpY2VMaW1pdDogVGhlIGNvbXB1dGUgbm9kZXMgYXJlIHByZWVtcHRpYmxlIGluc3RhbmNlcyB0aGF0IGhhdmUgYSB1c2VyLWRlZmluZWQgbWF4aW11bSBob3VybHkgcHJpY2UuXG4gICAgICogU3BvdEFzUHJpY2VHbzogVGhlIGNvbXB1dGUgbm9kZXMgYXJlIHByZWVtcHRpYmxlIGluc3RhbmNlcyBmb3Igd2hpY2ggdGhlIG1hcmtldCBwcmljZSBhdCB0aGUgdGltZSBvZiBwdXJjaGFzZSBpcyB1c2VkIGFzIHRoZSBiaWQgcHJpY2UuXG4gICAgICogRGVmYXVsdCB2YWx1ZTogTm9TcG90XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBzcG90U3RyYXRlZ3k/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG4gICAgfVxufVxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBJbnN0YW5jZVR5cGVzUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEluc3RhbmNlVHlwZXNQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBSb3NBdXRvU2NhbGVDb25maWdfSW5zdGFuY2VUeXBlc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IHJvcy5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiByb3MuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IHJvcy5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignem9uZUlkJywgcm9zLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnpvbmVJZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignem9uZUlkJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnpvbmVJZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndlN3aXRjaElkJywgcm9zLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnZTd2l0Y2hJZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndlN3aXRjaElkJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnZTd2l0Y2hJZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignc3BvdFByaWNlTGltaXQnLCByb3MudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMuc3BvdFByaWNlTGltaXQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2luc3RhbmNlVHlwZScsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5pbnN0YW5jZVR5cGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2luc3RhbmNlVHlwZScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5pbnN0YW5jZVR5cGUpKTtcbiAgICBpZihwcm9wZXJ0aWVzLnNwb3RTdHJhdGVneSAmJiAodHlwZW9mIHByb3BlcnRpZXMuc3BvdFN0cmF0ZWd5KSAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdzcG90U3RyYXRlZ3knLCByb3MudmFsaWRhdGVBbGxvd2VkVmFsdWVzKSh7XG4gICAgICAgICAgZGF0YTogcHJvcGVydGllcy5zcG90U3RyYXRlZ3ksXG4gICAgICAgICAgYWxsb3dlZFZhbHVlczogW1wiTm9TcG90XCIsXCJTcG90V2l0aFByaWNlTGltaXRcIixcIlNwb3RBc1ByaWNlR29cIl0sXG4gICAgICAgIH0pKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdzcG90U3RyYXRlZ3knLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc3BvdFN0cmF0ZWd5KSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkluc3RhbmNlVHlwZXNQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIHByb3BlcnRpZXMgb2YgYW4gYEFMSVlVTjo6RUhQQzo6QXV0b1NjYWxlQ29uZmlnLkluc3RhbmNlVHlwZXNgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEluc3RhbmNlVHlwZXNQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIHByb3BlcnRpZXMgb2YgYW4gYEFMSVlVTjo6RUhQQzo6QXV0b1NjYWxlQ29uZmlnLkluc3RhbmNlVHlwZXNgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gcm9zQXV0b1NjYWxlQ29uZmlnSW5zdGFuY2VUeXBlc1Byb3BlcnR5VG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghcm9zLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBSb3NBdXRvU2NhbGVDb25maWdfSW5zdGFuY2VUeXBlc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgJ1pvbmVJZCc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuem9uZUlkKSxcbiAgICAgICdWU3dpdGNoSWQnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnZTd2l0Y2hJZCksXG4gICAgICAnU3BvdFByaWNlTGltaXQnOiByb3MubnVtYmVyVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnNwb3RQcmljZUxpbWl0KSxcbiAgICAgICdJbnN0YW5jZVR5cGUnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmluc3RhbmNlVHlwZSksXG4gICAgICAnU3BvdFN0cmF0ZWd5Jzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5zcG90U3RyYXRlZ3kpLFxuICAgIH07XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgUm9zQXV0b1NjYWxlQ29uZmlnIHtcbiAgICAvKipcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBRdWV1ZXNQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBAUHJvcGVydHkgaG9zdE5hbWVTdWZmaXg6IFRoZSBob3N0bmFtZSBzdWZmaXggb2YgdGhlIGhvc3QgdGhhdCBpcyB1c2VkIHRvIHBlcmZvcm0gc2NhbGUtb3V0IGZvciB0aGUgcXVldWUuIFlvdSBjYW4gbWFuYWdlIG5vZGVzIHRoYXQgaGF2ZSBhIHNwZWNpZmllZCBob3N0bmFtZSBzdWZmaXguXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBob3N0TmFtZVN1ZmZpeD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEBQcm9wZXJ0eSBtaW5Ob2Rlc0luUXVldWU6IFRoZSBtaW5pbXVtIG51bWJlciBvZiB0aGUgY29tcHV0ZSBub2RlcyB0aGF0IGNhbiBiZSByZW1vdmVkIGluIHRoZSBxdWV1ZS5cbiAgICAgKiBEZWZhdWx0IHZhbHVlOiAwXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBtaW5Ob2Rlc0luUXVldWU/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBAUHJvcGVydHkgbWF4Tm9kZXNJblF1ZXVlOiBUaGUgbWF4aW11bSBudW1iZXIgb2YgdGhlIGNvbXB1dGUgbm9kZXMgdGhhdCBjYW4gYmUgYWRkZWQgaW4gdGhlIHF1ZXVlLlxuICAgICAqIERlZmF1bHQgdmFsdWU6IDEwMFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWF4Tm9kZXNJblF1ZXVlPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogQFByb3BlcnR5IGVuYWJsZUF1dG9Hcm93OiBTcGVjaWZpZXMgd2hldGhlciB0aGUgcXVldWUgZW5hYmxlcyBhdXRvIHNjYWxlLW91dC4gVmFsaWQgdmFsdWVzOlxuICAgICAqIHRydWU6IGVuYWJsZXMgYXV0byBzY2FsZS1vdXQuXG4gICAgICogZmFsc2U6IGRpc2FibGVzIGF1dG8gc2NhbGUtb3V0XG4gICAgICogRGVmYXVsdCB2YWx1ZTogZmFsc2VcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGVuYWJsZUF1dG9Hcm93PzogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEBQcm9wZXJ0eSBkYXRhRGlza3M6IHVuZGVmaW5lZFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgZGF0YURpc2tzPzogQXJyYXk8Um9zQXV0b1NjYWxlQ29uZmlnLkRhdGFEaXNrc1Byb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlPiB8IHJvcy5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEBQcm9wZXJ0eSBzeXN0ZW1EaXNrU2l6ZTogVGhlIHNpemUgb2YgdGhlIHN5c3RlbSBkaXNrIHNwZWNpZmllZCBmb3IgdGhlIGNvbXB1dGUgbm9kZXMgdGhhdCBhcmUgYWRkZWQgaW4gdGhlIHF1ZXVlLiBVbml0OiBHQi5cbiAgICAgKiBEZWZhdWx0IHZhbHVlOiA0MFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgc3lzdGVtRGlza1NpemU/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBAUHJvcGVydHkgc3lzdGVtRGlza0xldmVsOiBUaGUgcGVyZm9ybWFuY2UgbGV2ZWwgb2YgdGhlIHN5c3RlbSBkaXNrIHNwZWNpZmllZCBmb3IgdGhlIGNvbXB1dGUgbm9kZXMgdGhhdCBhcmUgYWRkZWQgaW4gdGhlIHF1ZXVlLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogUEwwOiBBIHNpbmdsZSBFU1NEIGNhbiBkZWxpdmVyIHVwIHRvIDEwLDAwMCByYW5kb20gcmVhZFxcL3dyaXRlIElPUFMuXG4gICAgICogUEwxOiBBIHNpbmdsZSBFU1NEIGNhbiBkZWxpdmVyIHVwIHRvIDUwLDAwMCByYW5kb20gcmVhZFxcL3dyaXRlIElPUFMuXG4gICAgICogUEwyOiBBIHNpbmdsZSBFU1NEIGNhbiBkZWxpdmVyIHVwIHRvIDEwMCwwMDAgcmFuZG9tIHJlYWRcXC93cml0ZSBJT1BTLlxuICAgICAqIFBMMzogQSBzaW5nbGUgRVNTRCBjYW4gZGVsaXZlciB1cCB0byAxLDAwMCwwMDAgcmFuZG9tIHJlYWRcXC93cml0ZSBJT1BTLlxuICAgICAqIERlZmF1bHQgdmFsdWU6IFBMMVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgc3lzdGVtRGlza0xldmVsPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogQFByb3BlcnR5IHF1ZXVlSW1hZ2VJZDogVGhlIGltYWdlIElEIG9mIHRoZSBxdWV1ZSB3aGVyZSBzY2FsZS1vdXQgaXMgcGVyZm9ybWVkLlxuICAgICAqIElmIHlvdSBzZXQgYm90aCBRdWV1ZXMuTi5RdWV1ZUltYWdlSWQgYW5kIEltYWdlSWQsIFF1ZXVlcy5OLlF1ZXVlSW1hZ2VJZCBwcmV2YWlscy5cbiAgICAgKiBJZiB5b3Ugc2V0IFF1ZXVlcy5OLlF1ZXVlSW1hZ2VJZCBvciBJbWFnZUlkLCB0aGUgcGFyYW1ldGVyIHRoYXQgeW91IHNldCB0YWtlcyBlZmZlY3QuXG4gICAgICogSWYgeW91IGxlYXZlIGJvdGggUXVldWVzLk4uUXVldWVJbWFnZUlkIGFuZCBJbWFnZUlkIGVtcHR5LCB0aGUgaW1hZ2UgdGhhdCB3YXMgc3BlY2lmaWVkIHdoZW4geW91IGNyZWF0ZWQgdGhlIGNsdXN0ZXIgb3IgdGhlIGxhc3QgdGltZSB3aGVuIHlvdSBzY2FsZWQgb3V0IHRoZSBjbHVzdGVyIGlzIHVzZWQgYnkgZGVmYXVsdC5cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHF1ZXVlSW1hZ2VJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEBQcm9wZXJ0eSBtaW5Ob2Rlc1BlckN5Y2xlOiBUaGUgbWluaW11bSBudW1iZXIgb2YgY29tcHV0ZSBub2RlcyB0aGF0IGNhbiBiZSBhZGRlZCBpbiBlYWNoIHJvdW5kIG9mIHNjYWxlLW91dC5cbiAgICAgKiBEZWZhdWx0IHZhbHVlOiAxXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBtaW5Ob2Rlc1BlckN5Y2xlPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogQFByb3BlcnR5IG1heE5vZGVzUGVyQ3ljbGU6IFRoZSBtYXhpbXVtIG51bWJlciBvZiBjb21wdXRlIG5vZGVzIHRoYXQgY2FuIGJlIGFkZGVkIGluIGVhY2ggcm91bmQgb2Ygc2NhbGUtb3V0LlxuICAgICAqIERlZmF1bHQgdmFsdWU6IDBcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG1heE5vZGVzUGVyQ3ljbGU/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBAUHJvcGVydHkgZW5hYmxlQXV0b1NocmluazogU3BlY2lmaWVzIHdoZXRoZXIgdGhlIHF1ZXVlIGVuYWJsZXMgYXV0byBzY2FsZS1pbi4gVmFsaWQgdmFsdWVzOlxuICAgICAqIHRydWU6IGVuYWJsZXMgYXV0byBzY2FsZS1pbi5cbiAgICAgKiBmYWxzZTogZGlzYWJsZXMgYXV0byBzY2FsZS1pblxuICAgICAqIERlZmF1bHQgdmFsdWU6IGZhbHNlXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBlbmFibGVBdXRvU2hyaW5rPzogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEBQcm9wZXJ0eSBzeXN0ZW1EaXNrQ2F0ZWdvcnk6IFRoZSB0eXBlIG9mIHRoZSBzeXN0ZW0gZGlzayBzcGVjaWZpZWQgZm9yIHRoZSBjb21wdXRlIG5vZGVzIHRoYXQgYXJlIGFkZGVkIGluIHRoZSBxdWV1ZS4gVmFsaWQgdmFsdWVzOlxuICAgICAqIGNsb3VkX2VmZmljaWVuY3k6IHVsdHJhIGRpc2suXG4gICAgICogY2xvdWRfc3NkOiBTU0QuXG4gICAgICogY2xvdWRfZXNzZDogRVNTRC5cbiAgICAgKiBEZWZhdWx0IHZhbHVlOiBjbG91ZF9lZmZpY2llbmN5XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBzeXN0ZW1EaXNrQ2F0ZWdvcnk/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBAUHJvcGVydHkgaG9zdE5hbWVQcmVmaXg6IFRoZSBob3N0bmFtZSBwcmVmaXggb2YgdGhlIGhvc3QgdGhhdCBpcyB1c2VkIHRvIHBlcmZvcm0gc2NhbGUtb3V0IGZvciB0aGUgcXVldWUuIFlvdSBjYW4gbWFuYWdlIGNvbXB1dGUgbm9kZXMgdGhhdCBoYXZlIGEgc3BlY2lmaWVkIGhvc3RuYW1lIHByZWZpeC5cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGhvc3ROYW1lUHJlZml4Pzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogQFByb3BlcnR5IHNwb3RQcmljZUxpbWl0OiBUaGUgbWF4aW11bSBob3VybHkgcHJpY2Ugb2YgdGhlIGNvbXB1dGUgbm9kZXMgdGhhdCBhcmUgYXV0b21hdGljYWxseSBhZGRlZCBpbiB0aGUgcXVldWUuIFRoZSB2YWx1ZSBjYW4gYmUgYWNjdXJhdGUgdG8gdGhyZWUgZGVjaW1hbCBwbGFjZXMuIFRoZSBwYXJhbWV0ZXIgdGFrZXMgZWZmZWN0IG9ubHkgd2hlbiBRdWV1ZXMuTi5TcG90U3RyYXRlZ3kgaXMgc2V0IHRvIFNwb3RXaXRoUHJpY2VMaW1pdC5cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHNwb3RQcmljZUxpbWl0PzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogQFByb3BlcnR5IGluc3RhbmNlVHlwZXM6IHVuZGVmaW5lZFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgaW5zdGFuY2VUeXBlcz86IEFycmF5PFJvc0F1dG9TY2FsZUNvbmZpZy5JbnN0YW5jZVR5cGVzUHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogQFByb3BlcnR5IGluc3RhbmNlVHlwZTogVGhlIGluc3RhbmNlIHR5cGUgb2YgdGhlIGNvbXB1dGUgbm9kZXMgdGhhdCBhcmUgYXV0b21hdGljYWxseSBhZGRlZCBpbiB0aGUgcXVldWUuXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBpbnN0YW5jZVR5cGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBAUHJvcGVydHkgcXVldWVOYW1lOiBUaGUgbmFtZSBvZiB0aGUgcXVldWUuXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBxdWV1ZU5hbWU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBAUHJvcGVydHkgc3BvdFN0cmF0ZWd5OiBUaGUgYmlkZGluZyBtZXRob2Qgb2YgdGhlIGNvbXB1dGUgbm9kZXMgdGhhdCBhcmUgYXV0b21hdGljYWxseSBhZGRlZCBpbiB0aGUgcXVldWUuIFZhbGlkIHZhbHVlczpcbiAgICAgKiBOb1Nwb3Q6IFRoZSBjb21wdXRlIG5vZGVzIGFyZSBwYXktYXMteW91LWdvIGluc3RhbmNlcy5cbiAgICAgKiBTcG90V2l0aFByaWNlTGltaXQ6IFRoZSBjb21wdXRlIG5vZGVzIGFyZSBwcmVlbXB0aWJsZSBpbnN0YW5jZXMgdGhhdCBoYXZlIGEgdXNlci1kZWZpbmVkIG1heGltdW0gaG91cmx5IHByaWNlLlxuICAgICAqIFNwb3RBc1ByaWNlR286IFRoZSBjb21wdXRlIG5vZGVzIGFyZSBwcmVlbXB0aWJsZSBpbnN0YW5jZXMgZm9yIHdoaWNoIHRoZSBtYXJrZXQgcHJpY2UgYXQgdGhlIHRpbWUgb2YgcHVyY2hhc2UgaXMgdXNlZCBhcyB0aGUgYmlkIHByaWNlLlxuICAgICAqIERlZmF1bHQgdmFsdWU6IE5vU3BvdFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgc3BvdFN0cmF0ZWd5Pzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuICAgIH1cbn1cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgUXVldWVzUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFF1ZXVlc1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIFJvc0F1dG9TY2FsZUNvbmZpZ19RdWV1ZXNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiByb3MuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFyb3MuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcm9zLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyByb3MuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2hvc3ROYW1lU3VmZml4Jywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmhvc3ROYW1lU3VmZml4KSk7XG4gICAgaWYocHJvcGVydGllcy5taW5Ob2Rlc0luUXVldWUgJiYgKHR5cGVvZiBwcm9wZXJ0aWVzLm1pbk5vZGVzSW5RdWV1ZSkgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignbWluTm9kZXNJblF1ZXVlJywgcm9zLnZhbGlkYXRlUmFuZ2UpKHtcbiAgICAgICAgICAgIGRhdGE6IHByb3BlcnRpZXMubWluTm9kZXNJblF1ZXVlLFxuICAgICAgICAgICAgbWluOiAwLFxuICAgICAgICAgICAgbWF4OiA1MCxcbiAgICAgICAgICB9KSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignbWluTm9kZXNJblF1ZXVlJywgcm9zLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLm1pbk5vZGVzSW5RdWV1ZSkpO1xuICAgIGlmKHByb3BlcnRpZXMubWF4Tm9kZXNJblF1ZXVlICYmICh0eXBlb2YgcHJvcGVydGllcy5tYXhOb2Rlc0luUXVldWUpICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ21heE5vZGVzSW5RdWV1ZScsIHJvcy52YWxpZGF0ZVJhbmdlKSh7XG4gICAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLm1heE5vZGVzSW5RdWV1ZSxcbiAgICAgICAgICAgIG1pbjogMCxcbiAgICAgICAgICAgIG1heDogNTAwLFxuICAgICAgICAgIH0pKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdtYXhOb2Rlc0luUXVldWUnLCByb3MudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMubWF4Tm9kZXNJblF1ZXVlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdlbmFibGVBdXRvR3JvdycsIHJvcy52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMuZW5hYmxlQXV0b0dyb3cpKTtcbiAgICBpZihwcm9wZXJ0aWVzLmRhdGFEaXNrcyAmJiAoQXJyYXkuaXNBcnJheShwcm9wZXJ0aWVzLmRhdGFEaXNrcykgfHwgKHR5cGVvZiBwcm9wZXJ0aWVzLmRhdGFEaXNrcykgPT09ICdzdHJpbmcnKSkge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2RhdGFEaXNrcycsIHJvcy52YWxpZGF0ZUxlbmd0aCkoe1xuICAgICAgICAgICAgZGF0YTogcHJvcGVydGllcy5kYXRhRGlza3MubGVuZ3RoLFxuICAgICAgICAgICAgbWluOiB1bmRlZmluZWQsXG4gICAgICAgICAgICBtYXg6IDE2LFxuICAgICAgICAgIH0pKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdkYXRhRGlza3MnLCByb3MubGlzdFZhbGlkYXRvcihSb3NBdXRvU2NhbGVDb25maWdfRGF0YURpc2tzUHJvcGVydHlWYWxpZGF0b3IpKShwcm9wZXJ0aWVzLmRhdGFEaXNrcykpO1xuICAgIGlmKHByb3BlcnRpZXMuc3lzdGVtRGlza1NpemUgJiYgKHR5cGVvZiBwcm9wZXJ0aWVzLnN5c3RlbURpc2tTaXplKSAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdzeXN0ZW1EaXNrU2l6ZScsIHJvcy52YWxpZGF0ZVJhbmdlKSh7XG4gICAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLnN5c3RlbURpc2tTaXplLFxuICAgICAgICAgICAgbWluOiA0MCxcbiAgICAgICAgICAgIG1heDogNTAwLFxuICAgICAgICAgIH0pKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdzeXN0ZW1EaXNrU2l6ZScsIHJvcy52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5zeXN0ZW1EaXNrU2l6ZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignc3lzdGVtRGlza0xldmVsJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnN5c3RlbURpc2tMZXZlbCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigncXVldWVJbWFnZUlkJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnF1ZXVlSW1hZ2VJZCkpO1xuICAgIGlmKHByb3BlcnRpZXMubWluTm9kZXNQZXJDeWNsZSAmJiAodHlwZW9mIHByb3BlcnRpZXMubWluTm9kZXNQZXJDeWNsZSkgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignbWluTm9kZXNQZXJDeWNsZScsIHJvcy52YWxpZGF0ZVJhbmdlKSh7XG4gICAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLm1pbk5vZGVzUGVyQ3ljbGUsXG4gICAgICAgICAgICBtaW46IDEsXG4gICAgICAgICAgICBtYXg6IDk5LFxuICAgICAgICAgIH0pKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdtaW5Ob2Rlc1BlckN5Y2xlJywgcm9zLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLm1pbk5vZGVzUGVyQ3ljbGUpKTtcbiAgICBpZihwcm9wZXJ0aWVzLm1heE5vZGVzUGVyQ3ljbGUgJiYgKHR5cGVvZiBwcm9wZXJ0aWVzLm1heE5vZGVzUGVyQ3ljbGUpICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ21heE5vZGVzUGVyQ3ljbGUnLCByb3MudmFsaWRhdGVSYW5nZSkoe1xuICAgICAgICAgICAgZGF0YTogcHJvcGVydGllcy5tYXhOb2Rlc1BlckN5Y2xlLFxuICAgICAgICAgICAgbWluOiAwLFxuICAgICAgICAgICAgbWF4OiA5OSxcbiAgICAgICAgICB9KSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignbWF4Tm9kZXNQZXJDeWNsZScsIHJvcy52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5tYXhOb2Rlc1BlckN5Y2xlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdlbmFibGVBdXRvU2hyaW5rJywgcm9zLnZhbGlkYXRlQm9vbGVhbikocHJvcGVydGllcy5lbmFibGVBdXRvU2hyaW5rKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdzeXN0ZW1EaXNrQ2F0ZWdvcnknLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc3lzdGVtRGlza0NhdGVnb3J5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdob3N0TmFtZVByZWZpeCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5ob3N0TmFtZVByZWZpeCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignc3BvdFByaWNlTGltaXQnLCByb3MudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMuc3BvdFByaWNlTGltaXQpKTtcbiAgICBpZihwcm9wZXJ0aWVzLmluc3RhbmNlVHlwZXMgJiYgKEFycmF5LmlzQXJyYXkocHJvcGVydGllcy5pbnN0YW5jZVR5cGVzKSB8fCAodHlwZW9mIHByb3BlcnRpZXMuaW5zdGFuY2VUeXBlcykgPT09ICdzdHJpbmcnKSkge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2luc3RhbmNlVHlwZXMnLCByb3MudmFsaWRhdGVMZW5ndGgpKHtcbiAgICAgICAgICAgIGRhdGE6IHByb3BlcnRpZXMuaW5zdGFuY2VUeXBlcy5sZW5ndGgsXG4gICAgICAgICAgICBtaW46IHVuZGVmaW5lZCxcbiAgICAgICAgICAgIG1heDogNTAwLFxuICAgICAgICAgIH0pKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdpbnN0YW5jZVR5cGVzJywgcm9zLmxpc3RWYWxpZGF0b3IoUm9zQXV0b1NjYWxlQ29uZmlnX0luc3RhbmNlVHlwZXNQcm9wZXJ0eVZhbGlkYXRvcikpKHByb3BlcnRpZXMuaW5zdGFuY2VUeXBlcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignaW5zdGFuY2VUeXBlJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmluc3RhbmNlVHlwZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigncXVldWVOYW1lJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnF1ZXVlTmFtZSkpO1xuICAgIGlmKHByb3BlcnRpZXMuc3BvdFN0cmF0ZWd5ICYmICh0eXBlb2YgcHJvcGVydGllcy5zcG90U3RyYXRlZ3kpICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3Nwb3RTdHJhdGVneScsIHJvcy52YWxpZGF0ZUFsbG93ZWRWYWx1ZXMpKHtcbiAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLnNwb3RTdHJhdGVneSxcbiAgICAgICAgICBhbGxvd2VkVmFsdWVzOiBbXCJOb1Nwb3RcIixcIlNwb3RXaXRoUHJpY2VMaW1pdFwiLFwiU3BvdEFzUHJpY2VHb1wiXSxcbiAgICAgICAgfSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3Nwb3RTdHJhdGVneScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5zcG90U3RyYXRlZ3kpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiUXVldWVzUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBwcm9wZXJ0aWVzIG9mIGFuIGBBTElZVU46OkVIUEM6OkF1dG9TY2FsZUNvbmZpZy5RdWV1ZXNgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFF1ZXVlc1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgcHJvcGVydGllcyBvZiBhbiBgQUxJWVVOOjpFSFBDOjpBdXRvU2NhbGVDb25maWcuUXVldWVzYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIHJvc0F1dG9TY2FsZUNvbmZpZ1F1ZXVlc1Byb3BlcnR5VG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghcm9zLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBSb3NBdXRvU2NhbGVDb25maWdfUXVldWVzUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAnSG9zdE5hbWVTdWZmaXgnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmhvc3ROYW1lU3VmZml4KSxcbiAgICAgICdNaW5Ob2Rlc0luUXVldWUnOiByb3MubnVtYmVyVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLm1pbk5vZGVzSW5RdWV1ZSksXG4gICAgICAnTWF4Tm9kZXNJblF1ZXVlJzogcm9zLm51bWJlclRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5tYXhOb2Rlc0luUXVldWUpLFxuICAgICAgJ0VuYWJsZUF1dG9Hcm93Jzogcm9zLmJvb2xlYW5Ub1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuZW5hYmxlQXV0b0dyb3cpLFxuICAgICAgJ0RhdGFEaXNrcyc6IHJvcy5saXN0TWFwcGVyKHJvc0F1dG9TY2FsZUNvbmZpZ0RhdGFEaXNrc1Byb3BlcnR5VG9Sb3NUZW1wbGF0ZSkocHJvcGVydGllcy5kYXRhRGlza3MpLFxuICAgICAgJ1N5c3RlbURpc2tTaXplJzogcm9zLm51bWJlclRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5zeXN0ZW1EaXNrU2l6ZSksXG4gICAgICAnU3lzdGVtRGlza0xldmVsJzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5zeXN0ZW1EaXNrTGV2ZWwpLFxuICAgICAgJ1F1ZXVlSW1hZ2VJZCc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMucXVldWVJbWFnZUlkKSxcbiAgICAgICdNaW5Ob2Rlc1BlckN5Y2xlJzogcm9zLm51bWJlclRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5taW5Ob2Rlc1BlckN5Y2xlKSxcbiAgICAgICdNYXhOb2Rlc1BlckN5Y2xlJzogcm9zLm51bWJlclRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5tYXhOb2Rlc1BlckN5Y2xlKSxcbiAgICAgICdFbmFibGVBdXRvU2hyaW5rJzogcm9zLmJvb2xlYW5Ub1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuZW5hYmxlQXV0b1NocmluayksXG4gICAgICAnU3lzdGVtRGlza0NhdGVnb3J5Jzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5zeXN0ZW1EaXNrQ2F0ZWdvcnkpLFxuICAgICAgJ0hvc3ROYW1lUHJlZml4Jzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5ob3N0TmFtZVByZWZpeCksXG4gICAgICAnU3BvdFByaWNlTGltaXQnOiByb3MubnVtYmVyVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnNwb3RQcmljZUxpbWl0KSxcbiAgICAgICdJbnN0YW5jZVR5cGVzJzogcm9zLmxpc3RNYXBwZXIocm9zQXV0b1NjYWxlQ29uZmlnSW5zdGFuY2VUeXBlc1Byb3BlcnR5VG9Sb3NUZW1wbGF0ZSkocHJvcGVydGllcy5pbnN0YW5jZVR5cGVzKSxcbiAgICAgICdJbnN0YW5jZVR5cGUnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmluc3RhbmNlVHlwZSksXG4gICAgICAnUXVldWVOYW1lJzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5xdWV1ZU5hbWUpLFxuICAgICAgJ1Nwb3RTdHJhdGVneSc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuc3BvdFN0cmF0ZWd5KSxcbiAgICB9O1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYFJvc0NsdXN0ZXJgLlxuICogU2VlIGh0dHBzOi8vd3d3LmFsaWJhYmFjbG91ZC5jb20vaGVscC9yb3MvZGV2ZWxvcGVyLXJlZmVyZW5jZS9hbGl5dW4tZWhwYy1jbHVzdGVyXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUm9zQ2x1c3RlclByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBlY3NPcmRlckNvbXB1dGVDb3VudDogQ29tcHV0aW5nIG5vZGUgbnVtYmVyLCB3aGljaCByYW5nZXMgZnJvbTogMC05OS5cbiAgICAgKi9cbiAgICByZWFkb25seSBlY3NPcmRlckNvbXB1dGVDb3VudDogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGVjc09yZGVyQ29tcHV0ZUluc3RhbmNlVHlwZTogQ2x1c3RlciBjb21wdXRpbmcgbm9kZSBpbnN0YW5jZSBzcGVjaWZpY2F0aW9ucy5cbiAgICAgKi9cbiAgICByZWFkb25seSBlY3NPcmRlckNvbXB1dGVJbnN0YW5jZVR5cGU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBlY3NPcmRlckxvZ2luQ291bnQ6IExvZ2luIG5vZGUgbnVtYmVyIGNhbiBvbmx5IGJlIDEuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZWNzT3JkZXJMb2dpbkNvdW50OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZWNzT3JkZXJMb2dpbkluc3RhbmNlVHlwZTogTG9nIGNsdXN0ZXIgbm9kZSBpbnN0YW5jZSBzcGVjaWZpY2F0aW9ucy5cbiAgICAgKi9cbiAgICByZWFkb25seSBlY3NPcmRlckxvZ2luSW5zdGFuY2VUeXBlOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZWNzT3JkZXJNYW5hZ2VySW5zdGFuY2VUeXBlOiBDbHVzdGVyIGNvbnRyb2wgbm9kZSBpbnN0YW5jZSBzcGVjaWZpY2F0aW9ucy5cbiAgICAgKi9cbiAgICByZWFkb25seSBlY3NPcmRlck1hbmFnZXJJbnN0YW5jZVR5cGU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBuYW1lOiBDbHVzdGVyIG5hbWUuIDItNjQgY2hhcmFjdGVycyBpbiBsZW5ndGgsIGFsbG93aW5nIG9ubHkgaW5jbHVkZSBDaGluZXNlLCBsZXR0ZXJzLCBudW1iZXJzLCBkYXNoZXMgKC0pIGFuZCB1bmRlcnNjb3JlIChfKSwgbXVzdCBiZWdpbiB3aXRoIGEgbGV0dGVyIG9yIENoaW5lc2UuXG4gICAgICovXG4gICAgcmVhZG9ubHkgbmFtZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IG9zVGFnOiBPcGVyYXRpbmcgc3lzdGVtIGltYWdlIHRhZy4gWW91IGNhbiBjYWxsIExpc3RJbWFnZXMgQVBJIHRvIHF1ZXJ5LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG9zVGFnOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgdlN3aXRjaElkOiBWUEMgaW4gc3dpdGNoIElELiBQcm9kdWN0cyBjdXJyZW50bHkgb25seSBzdXBwb3J0cyBWUEMgbmV0d29yay5cbiAgICAgKi9cbiAgICByZWFkb25seSB2U3dpdGNoSWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBhY2NvdW50VHlwZTogVGhlIHNlcnZpY2UgdHlwZSBvZiB0aGUgZG9tYWluIGFjY291bnQuIFZhbGlkIHZhbHVlczpcbiAgICAgKiBuaXNcbiAgICAgKiBsZGFwXG4gICAgICogRGVmYXVsdCB2YWx1ZTogbmlzXG4gICAgICovXG4gICAgcmVhZG9ubHkgYWNjb3VudFR5cGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgYWRkaXRpb25hbFZvbHVtZXM6XG4gICAgICovXG4gICAgcmVhZG9ubHkgYWRkaXRpb25hbFZvbHVtZXM/OiBBcnJheTxSb3NDbHVzdGVyLkFkZGl0aW9uYWxWb2x1bWVzUHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGFwcGxpY2F0aW9uOiBBcHBsaWNhdGlvbiBzb2Z0d2FyZSB0YWcgKFNvZnR3YXJlVGFnKSBsaXN0LCBZb3UgY2FuIGNhbGwgTGlzdFNvZnR3YXJlcyBBUEkgdG8gcXVlcnkuXG4gICAgICovXG4gICAgcmVhZG9ubHkgYXBwbGljYXRpb24/OiBBcnJheTxSb3NDbHVzdGVyLkFwcGxpY2F0aW9uUHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGF1dG9SZW5ldzogdHJ1ZTogYXV0b21hdGljIHJlbmV3YWxzOyBmYWxzZTogbm8gYXV0b21hdGljIHJlbmV3YWxzLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGF1dG9SZW5ldz86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgYXV0b1JlbmV3UGVyaW9kOiBEdXJhdGlvbiBvZiBlYWNoIGF1dG9tYXRpYyByZW5ld2FscywgQXV0b1JlbmV3IHRha2UgZWZmZWN0IHdoZW4gQXV0b1JlbmV3IGlzIFRydWUuXG4gICAgICovXG4gICAgcmVhZG9ubHkgYXV0b1JlbmV3UGVyaW9kPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGNsaWVudFZlcnNpb246IFRoZSB2ZXJzaW9uIG9mIHRoZSBFLUhQQyBjbGllbnQuIEJ5IGRlZmF1bHQsIHRoZSBwYXJhbWV0ZXIgaXMgc2V0IHRvIHRoZSBsYXRlc3QgdmVyc2lvbiBudW1iZXIuXG4gICAgICogWW91IGNhbiBjYWxsIHRoZSBMaXN0Q3VycmVudENsaWVudFZlcnNpb24gb3BlcmF0aW9uIHRvIHF1ZXJ5IHRoZSBjdXJyZW50IHZlcnNpb24gb2YgdGhlIEUtSFBDIGNsaWVudC5cbiAgICAgKi9cbiAgICByZWFkb25seSBjbGllbnRWZXJzaW9uPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGNvbXB1dGVFbmFibGVIdDogU3BlY2lmaWVzIHdoZXRoZXIgdGhlIGNvbXB1dGUgbm9kZXMgc3VwcG9ydCBoeXBlci10aHJlYWRpbmcuIFZhbGlkIHZhbHVlczpcbiAgICAgKiB0cnVlOiBIeXBlci10aHJlYWRpbmcgaXMgc3VwcG9ydGVkLlxuICAgICAqIGZhbHNlOiBIeXBlci10aHJlYWRpbmcgaXMgbm90IHN1cHBvcnRlZC5cbiAgICAgKiBEZWZhdWx0IHZhbHVlOiB0cnVlXG4gICAgICovXG4gICAgcmVhZG9ubHkgY29tcHV0ZUVuYWJsZUh0PzogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBjb21wdXRlU3BvdFByaWNlTGltaXQ6IFNldCBhbiBleGFtcGxlIG9mIHRoZSBoaWdoZXN0IHByaWNlIHBlciBob3VyLCBhcmUgZmxvYXRpbmctcG9pbnQgdmFsdWVzLCBpbiB0aGUgcmFuZ2Ugb2YgdGhlIGN1cnJlbnQgcHJpY2UgcmFuZ2UuXG4gICAgICovXG4gICAgcmVhZG9ubHkgY29tcHV0ZVNwb3RQcmljZUxpbWl0Pzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGNvbXB1dGVTcG90U3RyYXRlZ3k6IENvbXB1dGUgbm9kZXMgYmlkZGluZyBzdHJhdGVneSwgdmFsdWUgTm9TcG90LCBTcG90V2l0aFByaWNlTGltaXQgb3IgU3BvdEFzUHJpY2VHb1xuICAgICAqL1xuICAgIHJlYWRvbmx5IGNvbXB1dGVTcG90U3RyYXRlZ3k/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZGVwbG95TW9kZTogVGhlIG1vZGUgaW4gd2hpY2ggdGhlIGNsdXN0ZXIgaXMgZGVwbG95ZWQuIFZhbGlkIHZhbHVlczpcbiAgICAgKiBTdGFuZGFyZDogQW4gYWNjb3VudCBub2RlLCBhIHNjaGVkdWxpbmcgbm9kZSwgYSBsb2dvbiBub2RlLCBhbmQgbXVsdGlwbGUgY29tcHV0ZSBub2RlcyBhcmUgc2VwYXJhdGVseSBkZXBsb3llZC5cbiAgICAgKiBTaW1wbGU6IEEgbWFuYWdlbWVudCBub2RlLCBhIGxvZ29uIG5vZGUsIGFuZCBtdWx0aXBsZSBjb21wdXRlIG5vZGVzIGFyZSBkZXBsb3llZC4gVGhlIG1hbmFnZW1lbnQgbm9kZSBjb25zaXN0cyBvZiBhbiBhY2NvdW50IG5vZGUgYW5kIGEgc2NoZWR1bGluZyBub2RlLiBUaGUgbG9nb24gbm9kZSBhbmQgY29tcHV0ZSBub2RlcyBhcmUgc2VwYXJhdGVseSBkZXBsb3llZC5cbiAgICAgKiBUaW55OiBBIG1hbmFnZW1lbnQgbm9kZSBhbmQgbXVsdGlwbGUgY29tcHV0ZSBub2RlcyBhcmUgZGVwbG95ZWQuIFRoZSBtYW5hZ2VtZW50IG5vZGUgY29uc2lzdHMgb2YgYW4gYWNjb3VudCBub2RlLCBhIHNjaGVkdWxpbmcgbm9kZSwgYW5kIGEgbG9nb24gbm9kZS4gVGhlIGNvbXB1dGUgbm9kZXMgYXJlIHNlcGFyYXRlbHkgZGVwbG95ZWQuXG4gICAgICogRGVmYXVsdCB2YWx1ZTogU3RhbmRhcmRcbiAgICAgKi9cbiAgICByZWFkb25seSBkZXBsb3lNb2RlPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGRlc2NyaXB0aW9uOiBDbHVzdGVyIGRlc2NyaXB0aW9uLCAyIHRvIDEyOCBjaGFyYWN0ZXJzLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGVjc0NoYXJnZVR5cGU6IEVDUyBpbnN0YW5jZSBwYXltZW50IHR5cGUsIFBvc3RQYWlkOiBQYXktQXMtWW91LUdvLlByZVBhaWQ6IFN1YnNjcmlwdGlvbi5JZiB5b3UgY2hvb3NlIFByZVBhaWQsIGF1dG9tYXRpYyByZW5ld2FsIHdpbGwgYmUgZW5hYmxlZCBieSBkZWZhdWx0LCBhbmQgY2xvc2VkIHdoZW4gbm9kZSBpcyByZWxlYXNlZC5cbiAgICAgKi9cbiAgICByZWFkb25seSBlY3NDaGFyZ2VUeXBlPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGVjc09yZGVyTWFuYWdlckNvdW50OiBDb250cm9sIG5vZGUgbnVtYmVyIGNhbiBiZSAxLCAyXG4gICAgICovXG4gICAgcmVhZG9ubHkgZWNzT3JkZXJNYW5hZ2VyQ291bnQ/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZWhwY1ZlcnNpb246IFRoZSB2ZXJzaW9uIG9mIEUtSFBDLiBCeSBkZWZhdWx0LCB0aGUgcGFyYW1ldGVyIGlzIHNldCB0byB0aGUgbGF0ZXN0IHZlcnNpb24gbnVtYmVyLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVocGNWZXJzaW9uPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGhhRW5hYmxlOiBTcGVjaWZpZXMgd2hldGhlciB0byBlbmFibGUgdGhlIGhpZ2ggYXZhaWxhYmlsaXR5IGZlYXR1cmUuIFZhbGlkIHZhbHVlczpcbiAgICAgKiB0cnVlOiBlbmFibGVzIHRoZSBoaWdoIGF2YWlsYWJpbGl0eSBmZWF0dXJlXG4gICAgICogZmFsc2U6IGRpc2FibGVzIHRoZSBoaWdoIGF2YWlsYWJpbGl0eSBmZWF0dXJlXG4gICAgICogRGVmYXVsdCB2YWx1ZTogZmFsc2VcbiAgICAgKiBOb3RlIElmIGhpZ2ggYXZhaWxhYmlsaXR5IGlzIGVuYWJsZWQsIHByaW1hcnkgbWFuYWdlbWVudCBub2RlcyBhbmQgc2Vjb25kYXJ5IG1hbmFnZW1lbnQgbm9kZXMgYXJlIHVzZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgaGFFbmFibGU/OiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGltYWdlSWQ6IE1pcnJvciBJZCwgaWYgSW1hZ2VUeXBlIGEgc3lzdGVtLCBiYXNlZCBvbiB0aGUgaW1hZ2UgSUQgaXMgZGV0ZXJtaW5lZCBvbmx5IGFjY29yZGluZyBPc1RhZzsgaWYgc2VsZiwgb3RoZXJzLCBvciBtYXJrZXRwbGFjZSwgSW1hZ2VJZCBpcyBtYW5kYXRvcnkuXG4gICAgICovXG4gICAgcmVhZG9ubHkgaW1hZ2VJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBpbWFnZU93bmVyQWxpYXM6IE1pcnJvciB0eXBlOiBzeXN0ZW0sIHNlbGYsIG90aGVycyBvciBtYXJrZXRwbGFjZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGltYWdlT3duZXJBbGlhcz86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBpbnB1dEZpbGVVcmw6IFRoZSBVUkwgb2YgdGhlIGpvYiBmaWxlcyB0aGF0IGFyZSB1cGxvYWRlZCB0byBhbiBPYmplY3QgU3RvcmFnZSBTZXJ2aWNlIChPU1MpIGJ1Y2tldC5cbiAgICAgKi9cbiAgICByZWFkb25seSBpbnB1dEZpbGVVcmw/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgaXNDb21wdXRlRXNzOiBTcGVjaWZpZXMgd2hldGhlciB0byBlbmFibGUgYXV0byBzY2FsaW5nLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogdHJ1ZTogZW5hYmxlcyBhdXRvIHNjYWxpbmdcbiAgICAgKiBmYWxzZTogZGlzYWJsZXMgYXV0byBzY2FsaW5nXG4gICAgICogRGVmYXVsdCB2YWx1ZTogZmFsc2VcbiAgICAgKi9cbiAgICByZWFkb25seSBpc0NvbXB1dGVFc3M/OiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGpvYlF1ZXVlOiBcdFRoZSBxdWV1ZSB0byB3aGljaCB0aGUgY29tcHV0ZSBub2RlcyBhcmUgYWRkZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgam9iUXVldWU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkga2V5UGFpck5hbWU6IEtleSBwYWlyIG5hbWUuXG4gICAgICovXG4gICAgcmVhZG9ubHkga2V5UGFpck5hbWU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgbmV0d29ya0ludGVyZmFjZVRyYWZmaWNNb2RlOiBDb21tdW5pY2F0aW9uIG1vZGUgb2YgYW4gZWxhc3RpYyBOSUMuIFZhbHVlIHZhbHVlczpcbiAgICAgKiAtICoqU3RhbmRhcmQqKjogVGhlIFRDUCBjb21tdW5pY2F0aW9uIG1vZGUgaXMgdXNlZC5cbiAgICAgKiAtICoqSGlnaFBlcmZvcm1hbmNlKio6IEVuYWJsZXMgdGhlIEVsYXN0aWMgUkRNQSBJbnRlcmZhY2UgKEVSSSkgYW5kIHVzZXMgdGhlIFJETUEgY29tbXVuaWNhdGlvbiBtb2RlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG5ldHdvcmtJbnRlcmZhY2VUcmFmZmljTW9kZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBwYXNzd29yZDogUm9vdCBwYXNzd29yZCBvZiBqdW1wIHNlcnZlciAobG9naW4gbm9kZSkuIDggdG8gMzAgY2hhcmFjdGVycywgbXVzdCBjb250YWluIHRocmVlICh1cHBlciBhbmQgbG93ZXIgY2FzZSBsZXR0ZXJzLCBudW1iZXJzIGFuZCBzcGVjaWFsIHN5bWJvbHMpLiAhIFN1cHBvcnRzIHRoZSBmb2xsb3dpbmcgc3BlY2lhbCBjaGFyYWN0ZXJzIDooKSBgfiBAICMgJCUgXiAmICogLSArID0gfCB7fSBbXTo7ICc8PiwgXFwvIEJlIHN1cmUgdG8gdXNlIHRoZSBIVFRQUyBwcm90b2NvbCBBUEkgY2FsbCB0byBhdm9pZCBwYXNzd29yZCBsZWFrcyB0aGF0IG1heSBvY2N1ci4/LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHBhc3N3b3JkPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHBlcmlvZDogVGhlIHB1cmNoYXNlIG9mIGxvbmcgcmVzb3VyY2VzLCB1bml0czogd2VlayBcXC8gbW9udGggXFwvIHllYXIuIFdoZW4gdGhlIHZhbHVlIG9mIHRoZSBwYXJhbWV0ZXIgRWNzQ2hhcmdlVHlwZSB3aGVuIFByZVBhaWQgdGFrZSBlZmZlY3QgYW5kIGZvciB0aGUgc2VsZWN0ZWQgdmFsdWUgd2lsbCBiZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBwZXJpb2Q/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgcGVyaW9kVW5pdDogVGhlIHB1cmNoYXNlIG9mIGxvbmctcmVzb3VyY2VzIHVuaXQuIEFsdGVybmF0aXZlbHkgdmFsdWUgV2VlayBcXC8gTW9udGggXFwvIHllYXIuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcGVyaW9kVW5pdD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBwb3N0SW5zdGFsbFNjcmlwdDpcbiAgICAgKi9cbiAgICByZWFkb25seSBwb3N0SW5zdGFsbFNjcmlwdD86IEFycmF5PFJvc0NsdXN0ZXIuUG9zdEluc3RhbGxTY3JpcHRQcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgcmFtTm9kZVR5cGVzOiBXaGVuIGF1dGhvcml6aW5nIGluc3RhbmNlIGNvbmZpZ3VyYXRpb24sIHRoZSBub2RlIHR5cGUgdG8gd2hpY2ggdGhlIFJBTSByb2xlIGlzIGJvdW5kLlxuICAgICAqIFdoZW4gdGhlIHZhbHVlIG9mIERlcGxveU1vZGUgaXMgU3RhbmRhcmQsIHRoZSB2YWx1ZSByYW5nZTogc2NoZWR1bGVyLCBhY2NvdW50LCBsb2dpbiwgY29tcHV0ZS5cbiAgICAgKiBXaGVuIHRoZSB2YWx1ZSBvZiBEZXBsb3lNb2RlIGlzIFNpbXBsZSwgdGhlIHZhbHVlIHJhbmdlOiBtYW5hZ2VyLCBsb2dpbiwgY29tcHV0ZS5cbiAgICAgKiBXaGVuIHRoZSB2YWx1ZSBvZiBEZXBsb3lNb2RlIGlzIFRpbnksIHRoZSB2YWx1ZSByYW5nZTogbWFuYWdlciwgY29tcHV0ZS5cbiAgICAgKi9cbiAgICByZWFkb25seSByYW1Ob2RlVHlwZXM/OiBBcnJheTxzdHJpbmcgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHJhbVJvbGVOYW1lOiBUaGUgbmFtZSBvZiB0aGUgUmVzb3VyY2UgQWNjZXNzIE1hbmFnZW1lbnQgKFJBTSkgcm9sZS5cbiAgICAgKiBZb3UgY2FuIGNhbGwgdGhlIExpc3RSb2xlcyBvcGVyYXRpb24gcHJvdmlkZWQgYnkgUkFNIHRvIHF1ZXJ5IHRoZSBjcmVhdGVkIFJBTSByb2xlcy5cbiAgICAgKi9cbiAgICByZWFkb25seSByYW1Sb2xlTmFtZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSByZW1vdGVEaXJlY3Rvcnk6IE1vdW50IHNoYXJlZCBzdG9yYWdlIHJlbW90ZSBkaXJlY3RvcnkuIFRoZSBmaW5hbCBwYXRoIHRvIHRoZSBtb3VudCBwb2ludCBhbmQgbW91bnQgdGhlIHJlbW90ZSBkaXJlY3RvcnkgY29tcG9zaXRpb246IE5hc01vdW50cG9pbnQ6IFxcLyBSZW1vdGVEaXJlY3RvcnlcbiAgICAgKi9cbiAgICByZWFkb25seSByZW1vdGVEaXJlY3Rvcnk/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgcmVtb3RlVmlzRW5hYmxlOiBTcGVjaWZpZXMgd2hldGhlciB0byBlbmFibGUgVmlydHVhbCBOZXR3b3JrIENvbXB1dGluZyAoVk5DKS4gVmFsaWQgdmFsdWVzOlxuICAgICAqIHRydWU6IGVuYWJsZXMgVk5DXG4gICAgICogZmFsc2U6IGRpc2FibGVzIFZOQ1xuICAgICAqIERlZmF1bHQgdmFsdWU6IGZhbHNlXG4gICAgICovXG4gICAgcmVhZG9ubHkgcmVtb3RlVmlzRW5hYmxlPzogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSByZXNvdXJjZUdyb3VwSWQ6IFRoZSBJRCBvZiB0aGUgcmVzb3VyY2UgZ3JvdXAuXG4gICAgICogWW91IGNhbiBjYWxsIHRoZSBMaXN0UmVzb3VyY2VHcm91cHMgb3BlcmF0aW9uIHRvIG9idGFpbiB0aGUgSUQgb2YgdGhlIHJlc291cmNlIGdyb3VwLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlc291cmNlR3JvdXBJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBzY2NDbHVzdGVySWQ6IFdoZW4gU0NDIG1vZGVscywgaWYgeW91IHBhc3MgdGhpcyBmaWVsZCwgdGhlbiB0aGUgc3BlY2lmaWVkIFNjY0NsdXN0ZXIgY3JlYXRlIFNjYyBpbnN0YW5jZSwgb3RoZXJ3aXNlIGl0IHdpbGwgY3JlYXRlIGFuIGluc3RhbmNlIGZvciB0aGUgdXNlci5cbiAgICAgKi9cbiAgICByZWFkb25seSBzY2NDbHVzdGVySWQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgc2NoZWR1bGVyVHlwZTogVGhlIHR5cGUgb2YgdGhlIHNjaGVkdWxlci4gVmFsaWQgdmFsdWVzOlxuICAgICAqIHBic1xuICAgICAqIHNsdXJtXG4gICAgICogb3BlbmdyaWRzY2hlZHVsZXJcbiAgICAgKiBkZWFkbGluZVxuICAgICAqIERlZmF1bHQgdmFsdWU6IHBic1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHNjaGVkdWxlclR5cGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgc2VjdXJpdHlHcm91cElkOiBTZWN1cml0eSBncm91cCBJRC5cbiAgICAgKi9cbiAgICByZWFkb25seSBzZWN1cml0eUdyb3VwSWQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgc2VjdXJpdHlHcm91cE5hbWU6IElmIHlvdSBkbyBub3QgdXNlIGFuIGV4aXN0aW5nIHNlY3VyaXR5IGdyb3VwIChTZWN1cml0eUdyb3VwSWQgaXMgZW1wdHkpLCB0aGVuIHVzZSB0aGlzIG5hbWUgdG8gY3JlYXRlIGEgbmV3IHNlY3VyaXR5IGdyb3VwLCB0aGUgZGVmYXVsdCBwb2xpY3kuIEZvcm1hdCBSZXF1aXJlbWVudHMgUmVmZXJlbmNlIEVDUyBzZWN1cml0eSBncm91cCBuYW1lLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNlY3VyaXR5R3JvdXBOYW1lPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHN5c3RlbURpc2tMZXZlbDogVGhlIHBlcmZvcm1hbmNlIGxldmVsIG9mIHRoZSBFU1NEIHRoYXQgaXMgY3JlYXRlZCBhcyB0aGUgc3lzdGVtIGRpc2suIFZhbGlkIHZhbHVlczpcbiAgICAgKiBQTDA6IEEgc2luZ2xlIEVTU0QgY2FuIGRlbGl2ZXIgdXAgdG8gMTAsMDAwIGlucHV0XFwvb3V0cHV0IG9wZXJhdGlvbnMgcGVyIHNlY29uZCAoSU9QUykgb2YgcmFuZG9tIHJlYWRcXC93cml0ZS5cbiAgICAgKiBQTDE6IEEgc2luZ2xlIEVTU0QgY2FuIGRlbGl2ZXIgdXAgdG8gNTAsMDAwIElPUFMgb2YgcmFuZG9tIHJlYWRcXC93cml0ZS5cbiAgICAgKiBQTDI6IEEgc2luZ2xlIEVTU0QgY2FuIGRlbGl2ZXIgdXAgdG8gMTAwLDAwMCBJT1BTIG9mIHJhbmRvbSByZWFkXFwvd3JpdGUuXG4gICAgICogUEwzOiBBIHNpbmdsZSBFU1NEIGNhbiBkZWxpdmVyIHVwIHRvIDEsMDAwLDAwMCBJT1BTIG9mIHJhbmRvbSByZWFkXFwvd3JpdGUuXG4gICAgICogRGVmYXVsdCB2YWx1ZTogUEwxXG4gICAgICovXG4gICAgcmVhZG9ubHkgc3lzdGVtRGlza0xldmVsPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHN5c3RlbURpc2tTaXplOiBUaGUgc2l6ZSBvZiB0aGUgc3lzdGVtIGRpc2suIFVuaXQ6IEdCXG4gICAgICogVmFsaWQgdmFsdWVzOiA0MCB0byA1MDBcbiAgICAgKiBEZWZhdWx0IHZhbHVlOiA0MFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHN5c3RlbURpc2tTaXplPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHN5c3RlbURpc2tUeXBlOiBUaGUgdHlwZSBvZiB0aGUgc3lzdGVtIGRpc2suIFZhbGlkIHZhbHVlczpcbiAgICAgKiBjbG91ZF9lZmZpY2llbmN5OiB1bHRyYSBkaXNrLlxuICAgICAqIGNsb3VkX3NzZDogU1NELlxuICAgICAqIGNsb3VkX2Vzc2Q6IEVTU0QuXG4gICAgICogRGVmYXVsdCB2YWx1ZTogY2xvdWRfc3NkXG4gICAgICovXG4gICAgcmVhZG9ubHkgc3lzdGVtRGlza1R5cGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgdm9sdW1lSWQ6IFRoZSBJRCBvZiB0aGUgZmlsZSBzeXN0ZW0uIElmIHlvdSBsZWF2ZSB0aGUgcGFyYW1ldGVyIGVtcHR5LCBhIFBlcmZvcm1hbmNlIE5BUyBmaWxlIHN5c3RlbSBpcyBjcmVhdGVkIGJ5IGRlZmF1bHQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdm9sdW1lSWQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgdm9sdW1lTW91bnRwb2ludDogVGhlIG1vdW50IHRhcmdldCBvZiB0aGUgZmlsZSBzeXN0ZW0uIFRha2Ugbm90ZSBvZiB0aGUgZm9sbG93aW5nIGluZm9ybWF0aW9uOlxuICAgICAqIElmIHlvdSBkbyBub3Qgc3BlY2lmeSB0aGUgVm9sdW1lSWQgcGFyYW1ldGVyLCB5b3UgY2FuIGxlYXZlIHRoZSBWb2x1bWVNb3VudHBvaW50IHBhcmFtZXRlciBlbXB0eS4gQSBtb3VudCB0YXJnZXQgaXMgY3JlYXRlZCBieSBkZWZhdWx0LlxuICAgICAqIElmIHlvdSBzcGVjaWZ5IHRoZSBWb2x1bWVJZCBwYXJhbWV0ZXIsIHRoZSBWb2x1bWVNb3VudHBvaW50IHBhcmFtZXRlciBpcyByZXF1aXJlZC5cbiAgICAgKi9cbiAgICByZWFkb25seSB2b2x1bWVNb3VudHBvaW50Pzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHZvbHVtZVByb3RvY29sOiBUaGUgdHlwZSBvZiB0aGUgcHJvdG9jb2wgdGhhdCBpcyB1c2VkIGJ5IHRoZSBmaWxlIHN5c3RlbS4gVmFsaWQgdmFsdWVzOlxuICAgICAqIG5mc1xuICAgICAqIHNtYlxuICAgICAqIERlZmF1bHQgdmFsdWU6IG5mc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHZvbHVtZVByb3RvY29sPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHZvbHVtZVR5cGU6IFRoZSB0eXBlIG9mIHRoZSBzaGFyZWQgc3RvcmFnZS4gT25seSBBcHNhcmEgRmlsZSBTdG9yYWdlIG5hcyBmaWxlIHN5c3RlbXMgYXJlIHN1cHBvcnRlZC5cbiAgICAgKi9cbiAgICByZWFkb25seSB2b2x1bWVUeXBlPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHZwY0lkOiBUaGUgSUQgb2YgdGhlIHZpcnR1YWwgcHJpdmF0ZSBjbG91ZCAoVlBDKSB0byB3aGljaCB0aGUgRS1IUEMgY2x1c3RlciBiZWxvbmdzLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHZwY0lkPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHdpdGhvdXRFbGFzdGljSXA6IFNwZWNpZmllcyB3aGV0aGVyIHRoZSBsb2dvbiBub2RlIHVzZXMgYW4gZWxhc3RpYyBJUCBhZGRyZXNzIChFSVApLiBEZWZhdWx0IHZhbHVlOiBmYWxzZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHdpdGhvdXRFbGFzdGljSXA/OiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHpvbmVJZDogQXZhaWxhYmxlIGFyZWEgSUQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgem9uZUlkPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFJvc0NsdXN0ZXJQcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUm9zQ2x1c3RlclByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIFJvc0NsdXN0ZXJQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiByb3MuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFyb3MuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcm9zLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyByb3MuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3ZvbHVtZVByb3RvY29sJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnZvbHVtZVByb3RvY29sKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdyZXNvdXJjZUdyb3VwSWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucmVzb3VyY2VHcm91cElkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdjb21wdXRlRW5hYmxlSHQnLCByb3MudmFsaWRhdGVCb29sZWFuKShwcm9wZXJ0aWVzLmNvbXB1dGVFbmFibGVIdCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignd2l0aG91dEVsYXN0aWNJcCcsIHJvcy52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMud2l0aG91dEVsYXN0aWNJcCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignc3lzdGVtRGlza1R5cGUnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc3lzdGVtRGlza1R5cGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3JlbW90ZVZpc0VuYWJsZScsIHJvcy52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMucmVtb3RlVmlzRW5hYmxlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCduYW1lJywgcm9zLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLm5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ25hbWUnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndm9sdW1lSWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudm9sdW1lSWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3JhbVJvbGVOYW1lJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnJhbVJvbGVOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdkZXBsb3lNb2RlJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmRlcGxveU1vZGUpKTtcbiAgICBpZihwcm9wZXJ0aWVzLnBvc3RJbnN0YWxsU2NyaXB0ICYmIChBcnJheS5pc0FycmF5KHByb3BlcnRpZXMucG9zdEluc3RhbGxTY3JpcHQpIHx8ICh0eXBlb2YgcHJvcGVydGllcy5wb3N0SW5zdGFsbFNjcmlwdCkgPT09ICdzdHJpbmcnKSkge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3Bvc3RJbnN0YWxsU2NyaXB0Jywgcm9zLnZhbGlkYXRlTGVuZ3RoKSh7XG4gICAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLnBvc3RJbnN0YWxsU2NyaXB0Lmxlbmd0aCxcbiAgICAgICAgICAgIG1pbjogdW5kZWZpbmVkLFxuICAgICAgICAgICAgbWF4OiAxNixcbiAgICAgICAgICB9KSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigncG9zdEluc3RhbGxTY3JpcHQnLCByb3MubGlzdFZhbGlkYXRvcihSb3NDbHVzdGVyX1Bvc3RJbnN0YWxsU2NyaXB0UHJvcGVydHlWYWxpZGF0b3IpKShwcm9wZXJ0aWVzLnBvc3RJbnN0YWxsU2NyaXB0KSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdpbWFnZUlkJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmltYWdlSWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2lzQ29tcHV0ZUVzcycsIHJvcy52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMuaXNDb21wdXRlRXNzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdlY3NPcmRlckxvZ2luSW5zdGFuY2VUeXBlJywgcm9zLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmVjc09yZGVyTG9naW5JbnN0YW5jZVR5cGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2Vjc09yZGVyTG9naW5JbnN0YW5jZVR5cGUnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZWNzT3JkZXJMb2dpbkluc3RhbmNlVHlwZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignam9iUXVldWUnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuam9iUXVldWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3ZTd2l0Y2hJZCcsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy52U3dpdGNoSWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3ZTd2l0Y2hJZCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy52U3dpdGNoSWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3BlcmlvZCcsIHJvcy52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5wZXJpb2QpKTtcbiAgICBpZihwcm9wZXJ0aWVzLmNvbXB1dGVTcG90U3RyYXRlZ3kgJiYgKHR5cGVvZiBwcm9wZXJ0aWVzLmNvbXB1dGVTcG90U3RyYXRlZ3kpICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2NvbXB1dGVTcG90U3RyYXRlZ3knLCByb3MudmFsaWRhdGVBbGxvd2VkVmFsdWVzKSh7XG4gICAgICAgICAgZGF0YTogcHJvcGVydGllcy5jb21wdXRlU3BvdFN0cmF0ZWd5LFxuICAgICAgICAgIGFsbG93ZWRWYWx1ZXM6IFtcIk5vU3BvdFwiLFwiU3BvdFdpdGhQcmljZUxpbWl0XCIsXCJTcG90QXNQcmljZUdvXCJdLFxuICAgICAgICB9KSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignY29tcHV0ZVNwb3RTdHJhdGVneScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5jb21wdXRlU3BvdFN0cmF0ZWd5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdlY3NPcmRlck1hbmFnZXJJbnN0YW5jZVR5cGUnLCByb3MucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuZWNzT3JkZXJNYW5hZ2VySW5zdGFuY2VUeXBlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdlY3NPcmRlck1hbmFnZXJJbnN0YW5jZVR5cGUnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZWNzT3JkZXJNYW5hZ2VySW5zdGFuY2VUeXBlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdlaHBjVmVyc2lvbicsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5laHBjVmVyc2lvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndm9sdW1lTW91bnRwb2ludCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy52b2x1bWVNb3VudHBvaW50KSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdlY3NPcmRlck1hbmFnZXJDb3VudCcsIHJvcy52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5lY3NPcmRlck1hbmFnZXJDb3VudCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZWNzT3JkZXJDb21wdXRlSW5zdGFuY2VUeXBlJywgcm9zLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmVjc09yZGVyQ29tcHV0ZUluc3RhbmNlVHlwZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZWNzT3JkZXJDb21wdXRlSW5zdGFuY2VUeXBlJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmVjc09yZGVyQ29tcHV0ZUluc3RhbmNlVHlwZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndnBjSWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudnBjSWQpKTtcbiAgICBpZihwcm9wZXJ0aWVzLmFwcGxpY2F0aW9uICYmIChBcnJheS5pc0FycmF5KHByb3BlcnRpZXMuYXBwbGljYXRpb24pIHx8ICh0eXBlb2YgcHJvcGVydGllcy5hcHBsaWNhdGlvbikgPT09ICdzdHJpbmcnKSkge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2FwcGxpY2F0aW9uJywgcm9zLnZhbGlkYXRlTGVuZ3RoKSh7XG4gICAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLmFwcGxpY2F0aW9uLmxlbmd0aCxcbiAgICAgICAgICAgIG1pbjogdW5kZWZpbmVkLFxuICAgICAgICAgICAgbWF4OiAxMCxcbiAgICAgICAgICB9KSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignYXBwbGljYXRpb24nLCByb3MubGlzdFZhbGlkYXRvcihSb3NDbHVzdGVyX0FwcGxpY2F0aW9uUHJvcGVydHlWYWxpZGF0b3IpKShwcm9wZXJ0aWVzLmFwcGxpY2F0aW9uKSk7XG4gICAgaWYocHJvcGVydGllcy5wZXJpb2RVbml0ICYmICh0eXBlb2YgcHJvcGVydGllcy5wZXJpb2RVbml0KSAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdwZXJpb2RVbml0Jywgcm9zLnZhbGlkYXRlQWxsb3dlZFZhbHVlcykoe1xuICAgICAgICAgIGRhdGE6IHByb3BlcnRpZXMucGVyaW9kVW5pdCxcbiAgICAgICAgICBhbGxvd2VkVmFsdWVzOiBbXCJXZWVrXCIsXCJNb250aFwiLFwiWWVhclwiXSxcbiAgICAgICAgfSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3BlcmlvZFVuaXQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucGVyaW9kVW5pdCkpO1xuICAgIGlmKHByb3BlcnRpZXMuaW1hZ2VPd25lckFsaWFzICYmICh0eXBlb2YgcHJvcGVydGllcy5pbWFnZU93bmVyQWxpYXMpICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2ltYWdlT3duZXJBbGlhcycsIHJvcy52YWxpZGF0ZUFsbG93ZWRWYWx1ZXMpKHtcbiAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLmltYWdlT3duZXJBbGlhcyxcbiAgICAgICAgICBhbGxvd2VkVmFsdWVzOiBbXCJzeXN0ZW1cIixcInNlbGZcIixcIm90aGVyc1wiLFwibWFya2V0cGxhY2VcIl0sXG4gICAgICAgIH0pKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdpbWFnZU93bmVyQWxpYXMnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuaW1hZ2VPd25lckFsaWFzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdlY3NPcmRlckNvbXB1dGVDb3VudCcsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5lY3NPcmRlckNvbXB1dGVDb3VudCkpO1xuICAgIGlmKHByb3BlcnRpZXMuZWNzT3JkZXJDb21wdXRlQ291bnQgJiYgKHR5cGVvZiBwcm9wZXJ0aWVzLmVjc09yZGVyQ29tcHV0ZUNvdW50KSAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdlY3NPcmRlckNvbXB1dGVDb3VudCcsIHJvcy52YWxpZGF0ZVJhbmdlKSh7XG4gICAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLmVjc09yZGVyQ29tcHV0ZUNvdW50LFxuICAgICAgICAgICAgbWluOiAwLFxuICAgICAgICAgICAgbWF4OiA5OSxcbiAgICAgICAgICB9KSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZWNzT3JkZXJDb21wdXRlQ291bnQnLCByb3MudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMuZWNzT3JkZXJDb21wdXRlQ291bnQpKTtcbiAgICBpZihwcm9wZXJ0aWVzLmRlc2NyaXB0aW9uICYmIChBcnJheS5pc0FycmF5KHByb3BlcnRpZXMuZGVzY3JpcHRpb24pIHx8ICh0eXBlb2YgcHJvcGVydGllcy5kZXNjcmlwdGlvbikgPT09ICdzdHJpbmcnKSkge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2Rlc2NyaXB0aW9uJywgcm9zLnZhbGlkYXRlTGVuZ3RoKSh7XG4gICAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLmRlc2NyaXB0aW9uLmxlbmd0aCxcbiAgICAgICAgICAgIG1pbjogMixcbiAgICAgICAgICAgIG1heDogMTI4LFxuICAgICAgICAgIH0pKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdkZXNjcmlwdGlvbicsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5kZXNjcmlwdGlvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignc2VjdXJpdHlHcm91cE5hbWUnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc2VjdXJpdHlHcm91cE5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3N5c3RlbURpc2tTaXplJywgcm9zLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLnN5c3RlbURpc2tTaXplKSk7XG4gICAgaWYocHJvcGVydGllcy5hZGRpdGlvbmFsVm9sdW1lcyAmJiAoQXJyYXkuaXNBcnJheShwcm9wZXJ0aWVzLmFkZGl0aW9uYWxWb2x1bWVzKSB8fCAodHlwZW9mIHByb3BlcnRpZXMuYWRkaXRpb25hbFZvbHVtZXMpID09PSAnc3RyaW5nJykpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdhZGRpdGlvbmFsVm9sdW1lcycsIHJvcy52YWxpZGF0ZUxlbmd0aCkoe1xuICAgICAgICAgICAgZGF0YTogcHJvcGVydGllcy5hZGRpdGlvbmFsVm9sdW1lcy5sZW5ndGgsXG4gICAgICAgICAgICBtaW46IHVuZGVmaW5lZCxcbiAgICAgICAgICAgIG1heDogMTAsXG4gICAgICAgICAgfSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2FkZGl0aW9uYWxWb2x1bWVzJywgcm9zLmxpc3RWYWxpZGF0b3IoUm9zQ2x1c3Rlcl9BZGRpdGlvbmFsVm9sdW1lc1Byb3BlcnR5VmFsaWRhdG9yKSkocHJvcGVydGllcy5hZGRpdGlvbmFsVm9sdW1lcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignYXV0b1JlbmV3Jywgcm9zLnZhbGlkYXRlQm9vbGVhbikocHJvcGVydGllcy5hdXRvUmVuZXcpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2NvbXB1dGVTcG90UHJpY2VMaW1pdCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5jb21wdXRlU3BvdFByaWNlTGltaXQpKTtcbiAgICBpZihwcm9wZXJ0aWVzLnJhbU5vZGVUeXBlcyAmJiAoQXJyYXkuaXNBcnJheShwcm9wZXJ0aWVzLnJhbU5vZGVUeXBlcykgfHwgKHR5cGVvZiBwcm9wZXJ0aWVzLnJhbU5vZGVUeXBlcykgPT09ICdzdHJpbmcnKSkge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3JhbU5vZGVUeXBlcycsIHJvcy52YWxpZGF0ZUxlbmd0aCkoe1xuICAgICAgICAgICAgZGF0YTogcHJvcGVydGllcy5yYW1Ob2RlVHlwZXMubGVuZ3RoLFxuICAgICAgICAgICAgbWluOiB1bmRlZmluZWQsXG4gICAgICAgICAgICBtYXg6IDQsXG4gICAgICAgICAgfSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3JhbU5vZGVUeXBlcycsIHJvcy5saXN0VmFsaWRhdG9yKHJvcy52YWxpZGF0ZVN0cmluZykpKHByb3BlcnRpZXMucmFtTm9kZVR5cGVzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdjbGllbnRWZXJzaW9uJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmNsaWVudFZlcnNpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3ZvbHVtZVR5cGUnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudm9sdW1lVHlwZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignaW5wdXRGaWxlVXJsJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmlucHV0RmlsZVVybCkpO1xuICAgIGlmKHByb3BlcnRpZXMucGFzc3dvcmQgJiYgKEFycmF5LmlzQXJyYXkocHJvcGVydGllcy5wYXNzd29yZCkgfHwgKHR5cGVvZiBwcm9wZXJ0aWVzLnBhc3N3b3JkKSA9PT0gJ3N0cmluZycpKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigncGFzc3dvcmQnLCByb3MudmFsaWRhdGVMZW5ndGgpKHtcbiAgICAgICAgICAgIGRhdGE6IHByb3BlcnRpZXMucGFzc3dvcmQubGVuZ3RoLFxuICAgICAgICAgICAgbWluOiA4LFxuICAgICAgICAgICAgbWF4OiAzMCxcbiAgICAgICAgICB9KSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigncGFzc3dvcmQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucGFzc3dvcmQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2F1dG9SZW5ld1BlcmlvZCcsIHJvcy52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5hdXRvUmVuZXdQZXJpb2QpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2tleVBhaXJOYW1lJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmtleVBhaXJOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdyZW1vdGVEaXJlY3RvcnknLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucmVtb3RlRGlyZWN0b3J5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCduZXR3b3JrSW50ZXJmYWNlVHJhZmZpY01vZGUnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubmV0d29ya0ludGVyZmFjZVRyYWZmaWNNb2RlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdzY2NDbHVzdGVySWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc2NjQ2x1c3RlcklkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCd6b25lSWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuem9uZUlkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdzeXN0ZW1EaXNrTGV2ZWwnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc3lzdGVtRGlza0xldmVsKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdlY3NPcmRlckxvZ2luQ291bnQnLCByb3MucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuZWNzT3JkZXJMb2dpbkNvdW50KSk7XG4gICAgaWYocHJvcGVydGllcy5lY3NPcmRlckxvZ2luQ291bnQgJiYgKHR5cGVvZiBwcm9wZXJ0aWVzLmVjc09yZGVyTG9naW5Db3VudCkgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZWNzT3JkZXJMb2dpbkNvdW50Jywgcm9zLnZhbGlkYXRlUmFuZ2UpKHtcbiAgICAgICAgICAgIGRhdGE6IHByb3BlcnRpZXMuZWNzT3JkZXJMb2dpbkNvdW50LFxuICAgICAgICAgICAgbWluOiAxLFxuICAgICAgICAgICAgbWF4OiAxLFxuICAgICAgICAgIH0pKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdlY3NPcmRlckxvZ2luQ291bnQnLCByb3MudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMuZWNzT3JkZXJMb2dpbkNvdW50KSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdzZWN1cml0eUdyb3VwSWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc2VjdXJpdHlHcm91cElkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdzY2hlZHVsZXJUeXBlJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnNjaGVkdWxlclR5cGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2FjY291bnRUeXBlJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmFjY291bnRUeXBlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdoYUVuYWJsZScsIHJvcy52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMuaGFFbmFibGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ29zVGFnJywgcm9zLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLm9zVGFnKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdvc1RhZycsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5vc1RhZykpO1xuICAgIGlmKHByb3BlcnRpZXMuZWNzQ2hhcmdlVHlwZSAmJiAodHlwZW9mIHByb3BlcnRpZXMuZWNzQ2hhcmdlVHlwZSkgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZWNzQ2hhcmdlVHlwZScsIHJvcy52YWxpZGF0ZUFsbG93ZWRWYWx1ZXMpKHtcbiAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLmVjc0NoYXJnZVR5cGUsXG4gICAgICAgICAgYWxsb3dlZFZhbHVlczogW1wiUGF5QXNZb3VHb1wiLFwiUG9zdFBhaWRcIixcIlBheU9uRGVtYW5kXCIsXCJQb3N0cGFpZFwiLFwiUG9zdFBheVwiLFwiUG9zdHBheVwiLFwiUE9TVFBBWVwiLFwiUE9TVFwiLFwiU3Vic2NyaXB0aW9uXCIsXCJQcmVQYWlkXCIsXCJQcmVwYWlkXCIsXCJQcmVQYXlcIixcIlByZXBheVwiLFwiUFJFUEFZXCIsXCJQUkVcIl0sXG4gICAgICAgIH0pKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdlY3NDaGFyZ2VUeXBlJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmVjc0NoYXJnZVR5cGUpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiUm9zQ2x1c3RlclByb3BzXCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgcHJvcGVydGllcyBvZiBhbiBgQUxJWVVOOjpFSFBDOjpDbHVzdGVyYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBSb3NDbHVzdGVyUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBwcm9wZXJ0aWVzIG9mIGFuIGBBTElZVU46OkVIUEM6OkNsdXN0ZXJgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gcm9zQ2x1c3RlclByb3BzVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzOiBhbnksIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OiBib29sZWFuKTogYW55IHtcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgaWYoZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpIHtcbiAgICAgICAgUm9zQ2x1c3RlclByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICB9XG4gICAgcmV0dXJuIHtcbiAgICAgICdFY3NPcmRlckNvbXB1dGVDb3VudCc6IHJvcy5udW1iZXJUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuZWNzT3JkZXJDb21wdXRlQ291bnQpLFxuICAgICAgJ0Vjc09yZGVyQ29tcHV0ZUluc3RhbmNlVHlwZSc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuZWNzT3JkZXJDb21wdXRlSW5zdGFuY2VUeXBlKSxcbiAgICAgICdFY3NPcmRlckxvZ2luQ291bnQnOiByb3MubnVtYmVyVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmVjc09yZGVyTG9naW5Db3VudCksXG4gICAgICAnRWNzT3JkZXJMb2dpbkluc3RhbmNlVHlwZSc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuZWNzT3JkZXJMb2dpbkluc3RhbmNlVHlwZSksXG4gICAgICAnRWNzT3JkZXJNYW5hZ2VySW5zdGFuY2VUeXBlJzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5lY3NPcmRlck1hbmFnZXJJbnN0YW5jZVR5cGUpLFxuICAgICAgJ05hbWUnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLm5hbWUpLFxuICAgICAgJ09zVGFnJzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5vc1RhZyksXG4gICAgICAnVlN3aXRjaElkJzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy52U3dpdGNoSWQpLFxuICAgICAgJ0FjY291bnRUeXBlJzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5hY2NvdW50VHlwZSksXG4gICAgICAnQWRkaXRpb25hbFZvbHVtZXMnOiByb3MubGlzdE1hcHBlcihyb3NDbHVzdGVyQWRkaXRpb25hbFZvbHVtZXNQcm9wZXJ0eVRvUm9zVGVtcGxhdGUpKHByb3BlcnRpZXMuYWRkaXRpb25hbFZvbHVtZXMpLFxuICAgICAgJ0FwcGxpY2F0aW9uJzogcm9zLmxpc3RNYXBwZXIocm9zQ2x1c3RlckFwcGxpY2F0aW9uUHJvcGVydHlUb1Jvc1RlbXBsYXRlKShwcm9wZXJ0aWVzLmFwcGxpY2F0aW9uKSxcbiAgICAgICdBdXRvUmVuZXcnOiByb3MuYm9vbGVhblRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5hdXRvUmVuZXcpLFxuICAgICAgJ0F1dG9SZW5ld1BlcmlvZCc6IHJvcy5udW1iZXJUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuYXV0b1JlbmV3UGVyaW9kKSxcbiAgICAgICdDbGllbnRWZXJzaW9uJzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5jbGllbnRWZXJzaW9uKSxcbiAgICAgICdDb21wdXRlRW5hYmxlSHQnOiByb3MuYm9vbGVhblRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5jb21wdXRlRW5hYmxlSHQpLFxuICAgICAgJ0NvbXB1dGVTcG90UHJpY2VMaW1pdCc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuY29tcHV0ZVNwb3RQcmljZUxpbWl0KSxcbiAgICAgICdDb21wdXRlU3BvdFN0cmF0ZWd5Jzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5jb21wdXRlU3BvdFN0cmF0ZWd5KSxcbiAgICAgICdEZXBsb3lNb2RlJzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5kZXBsb3lNb2RlKSxcbiAgICAgICdEZXNjcmlwdGlvbic6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuZGVzY3JpcHRpb24pLFxuICAgICAgJ0Vjc0NoYXJnZVR5cGUnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmVjc0NoYXJnZVR5cGUpLFxuICAgICAgJ0Vjc09yZGVyTWFuYWdlckNvdW50Jzogcm9zLm51bWJlclRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5lY3NPcmRlck1hbmFnZXJDb3VudCksXG4gICAgICAnRWhwY1ZlcnNpb24nOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmVocGNWZXJzaW9uKSxcbiAgICAgICdIYUVuYWJsZSc6IHJvcy5ib29sZWFuVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmhhRW5hYmxlKSxcbiAgICAgICdJbWFnZUlkJzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5pbWFnZUlkKSxcbiAgICAgICdJbWFnZU93bmVyQWxpYXMnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmltYWdlT3duZXJBbGlhcyksXG4gICAgICAnSW5wdXRGaWxlVXJsJzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5pbnB1dEZpbGVVcmwpLFxuICAgICAgJ0lzQ29tcHV0ZUVzcyc6IHJvcy5ib29sZWFuVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmlzQ29tcHV0ZUVzcyksXG4gICAgICAnSm9iUXVldWUnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmpvYlF1ZXVlKSxcbiAgICAgICdLZXlQYWlyTmFtZSc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMua2V5UGFpck5hbWUpLFxuICAgICAgJ05ldHdvcmtJbnRlcmZhY2VUcmFmZmljTW9kZSc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMubmV0d29ya0ludGVyZmFjZVRyYWZmaWNNb2RlKSxcbiAgICAgICdQYXNzd29yZCc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMucGFzc3dvcmQpLFxuICAgICAgJ1BlcmlvZCc6IHJvcy5udW1iZXJUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMucGVyaW9kKSxcbiAgICAgICdQZXJpb2RVbml0Jzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5wZXJpb2RVbml0KSxcbiAgICAgICdQb3N0SW5zdGFsbFNjcmlwdCc6IHJvcy5saXN0TWFwcGVyKHJvc0NsdXN0ZXJQb3N0SW5zdGFsbFNjcmlwdFByb3BlcnR5VG9Sb3NUZW1wbGF0ZSkocHJvcGVydGllcy5wb3N0SW5zdGFsbFNjcmlwdCksXG4gICAgICAnUmFtTm9kZVR5cGVzJzogcm9zLmxpc3RNYXBwZXIocm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUpKHByb3BlcnRpZXMucmFtTm9kZVR5cGVzKSxcbiAgICAgICdSYW1Sb2xlTmFtZSc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMucmFtUm9sZU5hbWUpLFxuICAgICAgJ1JlbW90ZURpcmVjdG9yeSc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMucmVtb3RlRGlyZWN0b3J5KSxcbiAgICAgICdSZW1vdGVWaXNFbmFibGUnOiByb3MuYm9vbGVhblRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5yZW1vdGVWaXNFbmFibGUpLFxuICAgICAgJ1Jlc291cmNlR3JvdXBJZCc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMucmVzb3VyY2VHcm91cElkKSxcbiAgICAgICdTY2NDbHVzdGVySWQnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnNjY0NsdXN0ZXJJZCksXG4gICAgICAnU2NoZWR1bGVyVHlwZSc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuc2NoZWR1bGVyVHlwZSksXG4gICAgICAnU2VjdXJpdHlHcm91cElkJzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5zZWN1cml0eUdyb3VwSWQpLFxuICAgICAgJ1NlY3VyaXR5R3JvdXBOYW1lJzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5zZWN1cml0eUdyb3VwTmFtZSksXG4gICAgICAnU3lzdGVtRGlza0xldmVsJzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5zeXN0ZW1EaXNrTGV2ZWwpLFxuICAgICAgJ1N5c3RlbURpc2tTaXplJzogcm9zLm51bWJlclRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5zeXN0ZW1EaXNrU2l6ZSksXG4gICAgICAnU3lzdGVtRGlza1R5cGUnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnN5c3RlbURpc2tUeXBlKSxcbiAgICAgICdWb2x1bWVJZCc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMudm9sdW1lSWQpLFxuICAgICAgJ1ZvbHVtZU1vdW50cG9pbnQnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnZvbHVtZU1vdW50cG9pbnQpLFxuICAgICAgJ1ZvbHVtZVByb3RvY29sJzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy52b2x1bWVQcm90b2NvbCksXG4gICAgICAnVm9sdW1lVHlwZSc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMudm9sdW1lVHlwZSksXG4gICAgICAnVnBjSWQnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnZwY0lkKSxcbiAgICAgICdXaXRob3V0RWxhc3RpY0lwJzogcm9zLmJvb2xlYW5Ub1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMud2l0aG91dEVsYXN0aWNJcCksXG4gICAgICAnWm9uZUlkJzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy56b25lSWQpLFxuICAgIH07XG59XG5cbi8qKlxuICogVGhpcyBjbGFzcyBpcyBhIGJhc2UgZW5jYXBzdWxhdGlvbiBhcm91bmQgdGhlIFJPUyByZXNvdXJjZSB0eXBlIGBBTElZVU46OkVIUEM6OkNsdXN0ZXJgLCB3aGljaCBpcyB1c2VkIHRvIGNyZWF0ZSBhbiBFbGFzdGljIEhpZ2ggUGVyZm9ybWFuY2UgQ29tcHV0aW5nIChFLUhQQykgY2x1c3Rlci5cbiAqIEBOb3RlIFRoaXMgY2xhc3MgZG9lcyBub3QgY29udGFpbiBhZGRpdGlvbmFsIGZ1bmN0aW9ucywgc28gaXQgaXMgcmVjb21tZW5kZWQgdG8gdXNlIHRoZSBgQ2x1c3RlcmAgY2xhc3MgaW5zdGVhZCBvZiB0aGlzIGNsYXNzIGZvciBhIG1vcmUgY29udmVuaWVudCBkZXZlbG9wbWVudCBleHBlcmllbmNlLlxuICogU2VlIGh0dHBzOi8vd3d3LmFsaWJhYmFjbG91ZC5jb20vaGVscC9yb3MvZGV2ZWxvcGVyLXJlZmVyZW5jZS9hbGl5dW4tZWhwYy1jbHVzdGVyXG4gKi9cbmV4cG9ydCBjbGFzcyBSb3NDbHVzdGVyIGV4dGVuZHMgcm9zLlJvc1Jlc291cmNlIHtcbiAgICAvKipcbiAgICAgKiBUaGUgcmVzb3VyY2UgdHlwZSBuYW1lIGZvciB0aGlzIHJlc291cmNlIGNsYXNzLlxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUk9TX1JFU09VUkNFX1RZUEVfTkFNRSA9IFwiQUxJWVVOOjpFSFBDOjpDbHVzdGVyXCI7XG5cbiAgICAvKipcbiAgICAgKiBAQXR0cmlidXRlIENsdXN0ZXJJZDogQ2x1c3RlciBJZC5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckNsdXN0ZXJJZDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQEF0dHJpYnV0ZSBFY3NJbmZvOiBBIGRhdGEgc3RydWN0dXJlIGRlc2NyaWJpbmcgdGhlIG51bWJlciBhbmQgc3BlY2lmaWNhdGlvbnMgb2YgRUNTIGZvciB2YXJpb3VzIGNvbXBvbmVudHMgb2YgdGhlIGNsdXN0ZXIuXG5Zb3Ugd2lsbCBnZXQgcmVzdWx0cyBzaW1pbGFyIHRvIHRoZSBmb2xsb3dpbmc6IEVjc0luZm86IHtcIk1hbmFnZXJcIjoge1wiQ291bnRcIjogMiwgXCJJbnN0YW5jZVR5cGVcIjogXCJlY3MubjEubGFyZ2VcIn0sIFwiQ29tcHV0ZVwiOiB7XCJDb3VudFwiOiA4LCBcIkluc3RhbmNlVHlwZVwiOiBcImVjcy5uMS5sYXJnZVwifSwgXCJMb2dpblwiOiB7XCJDb3VudFwiOiAxLCBcIkluc3RhbmNlVHlwZVwiOiBcImVjcy5uMS5sYXJnZVwifX1cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckVjc0luZm86IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBBdHRyaWJ1dGUgTmFtZTogQ2x1c3RlciBuYW1lLlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyTmFtZTogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQEF0dHJpYnV0ZSBTZWN1cml0eUdyb3VwSWQ6IFNlY3VyaXR5IGdyb3VwIElELlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyU2VjdXJpdHlHcm91cElkOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICBwdWJsaWMgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW47XG5cblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBlY3NPcmRlckNvbXB1dGVDb3VudDogQ29tcHV0aW5nIG5vZGUgbnVtYmVyLCB3aGljaCByYW5nZXMgZnJvbTogMC05OS5cbiAgICAgKi9cbiAgICBwdWJsaWMgZWNzT3JkZXJDb21wdXRlQ291bnQ6IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBlY3NPcmRlckNvbXB1dGVJbnN0YW5jZVR5cGU6IENsdXN0ZXIgY29tcHV0aW5nIG5vZGUgaW5zdGFuY2Ugc3BlY2lmaWNhdGlvbnMuXG4gICAgICovXG4gICAgcHVibGljIGVjc09yZGVyQ29tcHV0ZUluc3RhbmNlVHlwZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGVjc09yZGVyTG9naW5Db3VudDogTG9naW4gbm9kZSBudW1iZXIgY2FuIG9ubHkgYmUgMS5cbiAgICAgKi9cbiAgICBwdWJsaWMgZWNzT3JkZXJMb2dpbkNvdW50OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZWNzT3JkZXJMb2dpbkluc3RhbmNlVHlwZTogTG9nIGNsdXN0ZXIgbm9kZSBpbnN0YW5jZSBzcGVjaWZpY2F0aW9ucy5cbiAgICAgKi9cbiAgICBwdWJsaWMgZWNzT3JkZXJMb2dpbkluc3RhbmNlVHlwZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGVjc09yZGVyTWFuYWdlckluc3RhbmNlVHlwZTogQ2x1c3RlciBjb250cm9sIG5vZGUgaW5zdGFuY2Ugc3BlY2lmaWNhdGlvbnMuXG4gICAgICovXG4gICAgcHVibGljIGVjc09yZGVyTWFuYWdlckluc3RhbmNlVHlwZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IG5hbWU6IENsdXN0ZXIgbmFtZS4gMi02NCBjaGFyYWN0ZXJzIGluIGxlbmd0aCwgYWxsb3dpbmcgb25seSBpbmNsdWRlIENoaW5lc2UsIGxldHRlcnMsIG51bWJlcnMsIGRhc2hlcyAoLSkgYW5kIHVuZGVyc2NvcmUgKF8pLCBtdXN0IGJlZ2luIHdpdGggYSBsZXR0ZXIgb3IgQ2hpbmVzZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgbmFtZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IG9zVGFnOiBPcGVyYXRpbmcgc3lzdGVtIGltYWdlIHRhZy4gWW91IGNhbiBjYWxsIExpc3RJbWFnZXMgQVBJIHRvIHF1ZXJ5LlxuICAgICAqL1xuICAgIHB1YmxpYyBvc1RhZzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHZTd2l0Y2hJZDogVlBDIGluIHN3aXRjaCBJRC4gUHJvZHVjdHMgY3VycmVudGx5IG9ubHkgc3VwcG9ydHMgVlBDIG5ldHdvcmsuXG4gICAgICovXG4gICAgcHVibGljIHZTd2l0Y2hJZDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGFjY291bnRUeXBlOiBUaGUgc2VydmljZSB0eXBlIG9mIHRoZSBkb21haW4gYWNjb3VudC4gVmFsaWQgdmFsdWVzOlxuICAgICAqIG5pc1xuICAgICAqIGxkYXBcbiAgICAgKiBEZWZhdWx0IHZhbHVlOiBuaXNcbiAgICAgKi9cbiAgICBwdWJsaWMgYWNjb3VudFR5cGU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBhZGRpdGlvbmFsVm9sdW1lczpcbiAgICAgKi9cbiAgICBwdWJsaWMgYWRkaXRpb25hbFZvbHVtZXM6IEFycmF5PFJvc0NsdXN0ZXIuQWRkaXRpb25hbFZvbHVtZXNQcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgYXBwbGljYXRpb246IEFwcGxpY2F0aW9uIHNvZnR3YXJlIHRhZyAoU29mdHdhcmVUYWcpIGxpc3QsIFlvdSBjYW4gY2FsbCBMaXN0U29mdHdhcmVzIEFQSSB0byBxdWVyeS5cbiAgICAgKi9cbiAgICBwdWJsaWMgYXBwbGljYXRpb246IEFycmF5PFJvc0NsdXN0ZXIuQXBwbGljYXRpb25Qcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgYXV0b1JlbmV3OiB0cnVlOiBhdXRvbWF0aWMgcmVuZXdhbHM7IGZhbHNlOiBubyBhdXRvbWF0aWMgcmVuZXdhbHMuXG4gICAgICovXG4gICAgcHVibGljIGF1dG9SZW5ldzogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBhdXRvUmVuZXdQZXJpb2Q6IER1cmF0aW9uIG9mIGVhY2ggYXV0b21hdGljIHJlbmV3YWxzLCBBdXRvUmVuZXcgdGFrZSBlZmZlY3Qgd2hlbiBBdXRvUmVuZXcgaXMgVHJ1ZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgYXV0b1JlbmV3UGVyaW9kOiBudW1iZXIgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgY2xpZW50VmVyc2lvbjogVGhlIHZlcnNpb24gb2YgdGhlIEUtSFBDIGNsaWVudC4gQnkgZGVmYXVsdCwgdGhlIHBhcmFtZXRlciBpcyBzZXQgdG8gdGhlIGxhdGVzdCB2ZXJzaW9uIG51bWJlci5cbiAgICAgKiBZb3UgY2FuIGNhbGwgdGhlIExpc3RDdXJyZW50Q2xpZW50VmVyc2lvbiBvcGVyYXRpb24gdG8gcXVlcnkgdGhlIGN1cnJlbnQgdmVyc2lvbiBvZiB0aGUgRS1IUEMgY2xpZW50LlxuICAgICAqL1xuICAgIHB1YmxpYyBjbGllbnRWZXJzaW9uOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgY29tcHV0ZUVuYWJsZUh0OiBTcGVjaWZpZXMgd2hldGhlciB0aGUgY29tcHV0ZSBub2RlcyBzdXBwb3J0IGh5cGVyLXRocmVhZGluZy4gVmFsaWQgdmFsdWVzOlxuICAgICAqIHRydWU6IEh5cGVyLXRocmVhZGluZyBpcyBzdXBwb3J0ZWQuXG4gICAgICogZmFsc2U6IEh5cGVyLXRocmVhZGluZyBpcyBub3Qgc3VwcG9ydGVkLlxuICAgICAqIERlZmF1bHQgdmFsdWU6IHRydWVcbiAgICAgKi9cbiAgICBwdWJsaWMgY29tcHV0ZUVuYWJsZUh0OiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGNvbXB1dGVTcG90UHJpY2VMaW1pdDogU2V0IGFuIGV4YW1wbGUgb2YgdGhlIGhpZ2hlc3QgcHJpY2UgcGVyIGhvdXIsIGFyZSBmbG9hdGluZy1wb2ludCB2YWx1ZXMsIGluIHRoZSByYW5nZSBvZiB0aGUgY3VycmVudCBwcmljZSByYW5nZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgY29tcHV0ZVNwb3RQcmljZUxpbWl0OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgY29tcHV0ZVNwb3RTdHJhdGVneTogQ29tcHV0ZSBub2RlcyBiaWRkaW5nIHN0cmF0ZWd5LCB2YWx1ZSBOb1Nwb3QsIFNwb3RXaXRoUHJpY2VMaW1pdCBvciBTcG90QXNQcmljZUdvXG4gICAgICovXG4gICAgcHVibGljIGNvbXB1dGVTcG90U3RyYXRlZ3k6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBkZXBsb3lNb2RlOiBUaGUgbW9kZSBpbiB3aGljaCB0aGUgY2x1c3RlciBpcyBkZXBsb3llZC4gVmFsaWQgdmFsdWVzOlxuICAgICAqIFN0YW5kYXJkOiBBbiBhY2NvdW50IG5vZGUsIGEgc2NoZWR1bGluZyBub2RlLCBhIGxvZ29uIG5vZGUsIGFuZCBtdWx0aXBsZSBjb21wdXRlIG5vZGVzIGFyZSBzZXBhcmF0ZWx5IGRlcGxveWVkLlxuICAgICAqIFNpbXBsZTogQSBtYW5hZ2VtZW50IG5vZGUsIGEgbG9nb24gbm9kZSwgYW5kIG11bHRpcGxlIGNvbXB1dGUgbm9kZXMgYXJlIGRlcGxveWVkLiBUaGUgbWFuYWdlbWVudCBub2RlIGNvbnNpc3RzIG9mIGFuIGFjY291bnQgbm9kZSBhbmQgYSBzY2hlZHVsaW5nIG5vZGUuIFRoZSBsb2dvbiBub2RlIGFuZCBjb21wdXRlIG5vZGVzIGFyZSBzZXBhcmF0ZWx5IGRlcGxveWVkLlxuICAgICAqIFRpbnk6IEEgbWFuYWdlbWVudCBub2RlIGFuZCBtdWx0aXBsZSBjb21wdXRlIG5vZGVzIGFyZSBkZXBsb3llZC4gVGhlIG1hbmFnZW1lbnQgbm9kZSBjb25zaXN0cyBvZiBhbiBhY2NvdW50IG5vZGUsIGEgc2NoZWR1bGluZyBub2RlLCBhbmQgYSBsb2dvbiBub2RlLiBUaGUgY29tcHV0ZSBub2RlcyBhcmUgc2VwYXJhdGVseSBkZXBsb3llZC5cbiAgICAgKiBEZWZhdWx0IHZhbHVlOiBTdGFuZGFyZFxuICAgICAqL1xuICAgIHB1YmxpYyBkZXBsb3lNb2RlOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZGVzY3JpcHRpb246IENsdXN0ZXIgZGVzY3JpcHRpb24sIDIgdG8gMTI4IGNoYXJhY3RlcnMuXG4gICAgICovXG4gICAgcHVibGljIGRlc2NyaXB0aW9uOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZWNzQ2hhcmdlVHlwZTogRUNTIGluc3RhbmNlIHBheW1lbnQgdHlwZSwgUG9zdFBhaWQ6IFBheS1Bcy1Zb3UtR28uUHJlUGFpZDogU3Vic2NyaXB0aW9uLklmIHlvdSBjaG9vc2UgUHJlUGFpZCwgYXV0b21hdGljIHJlbmV3YWwgd2lsbCBiZSBlbmFibGVkIGJ5IGRlZmF1bHQsIGFuZCBjbG9zZWQgd2hlbiBub2RlIGlzIHJlbGVhc2VkLlxuICAgICAqL1xuICAgIHB1YmxpYyBlY3NDaGFyZ2VUeXBlOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZWNzT3JkZXJNYW5hZ2VyQ291bnQ6IENvbnRyb2wgbm9kZSBudW1iZXIgY2FuIGJlIDEsIDJcbiAgICAgKi9cbiAgICBwdWJsaWMgZWNzT3JkZXJNYW5hZ2VyQ291bnQ6IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBlaHBjVmVyc2lvbjogVGhlIHZlcnNpb24gb2YgRS1IUEMuIEJ5IGRlZmF1bHQsIHRoZSBwYXJhbWV0ZXIgaXMgc2V0IHRvIHRoZSBsYXRlc3QgdmVyc2lvbiBudW1iZXIuXG4gICAgICovXG4gICAgcHVibGljIGVocGNWZXJzaW9uOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgaGFFbmFibGU6IFNwZWNpZmllcyB3aGV0aGVyIHRvIGVuYWJsZSB0aGUgaGlnaCBhdmFpbGFiaWxpdHkgZmVhdHVyZS4gVmFsaWQgdmFsdWVzOlxuICAgICAqIHRydWU6IGVuYWJsZXMgdGhlIGhpZ2ggYXZhaWxhYmlsaXR5IGZlYXR1cmVcbiAgICAgKiBmYWxzZTogZGlzYWJsZXMgdGhlIGhpZ2ggYXZhaWxhYmlsaXR5IGZlYXR1cmVcbiAgICAgKiBEZWZhdWx0IHZhbHVlOiBmYWxzZVxuICAgICAqIE5vdGUgSWYgaGlnaCBhdmFpbGFiaWxpdHkgaXMgZW5hYmxlZCwgcHJpbWFyeSBtYW5hZ2VtZW50IG5vZGVzIGFuZCBzZWNvbmRhcnkgbWFuYWdlbWVudCBub2RlcyBhcmUgdXNlZC5cbiAgICAgKi9cbiAgICBwdWJsaWMgaGFFbmFibGU6IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgaW1hZ2VJZDogTWlycm9yIElkLCBpZiBJbWFnZVR5cGUgYSBzeXN0ZW0sIGJhc2VkIG9uIHRoZSBpbWFnZSBJRCBpcyBkZXRlcm1pbmVkIG9ubHkgYWNjb3JkaW5nIE9zVGFnOyBpZiBzZWxmLCBvdGhlcnMsIG9yIG1hcmtldHBsYWNlLCBJbWFnZUlkIGlzIG1hbmRhdG9yeS5cbiAgICAgKi9cbiAgICBwdWJsaWMgaW1hZ2VJZDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGltYWdlT3duZXJBbGlhczogTWlycm9yIHR5cGU6IHN5c3RlbSwgc2VsZiwgb3RoZXJzIG9yIG1hcmtldHBsYWNlXG4gICAgICovXG4gICAgcHVibGljIGltYWdlT3duZXJBbGlhczogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGlucHV0RmlsZVVybDogVGhlIFVSTCBvZiB0aGUgam9iIGZpbGVzIHRoYXQgYXJlIHVwbG9hZGVkIHRvIGFuIE9iamVjdCBTdG9yYWdlIFNlcnZpY2UgKE9TUykgYnVja2V0LlxuICAgICAqL1xuICAgIHB1YmxpYyBpbnB1dEZpbGVVcmw6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBpc0NvbXB1dGVFc3M6IFNwZWNpZmllcyB3aGV0aGVyIHRvIGVuYWJsZSBhdXRvIHNjYWxpbmcuIFZhbGlkIHZhbHVlczpcbiAgICAgKiB0cnVlOiBlbmFibGVzIGF1dG8gc2NhbGluZ1xuICAgICAqIGZhbHNlOiBkaXNhYmxlcyBhdXRvIHNjYWxpbmdcbiAgICAgKiBEZWZhdWx0IHZhbHVlOiBmYWxzZVxuICAgICAqL1xuICAgIHB1YmxpYyBpc0NvbXB1dGVFc3M6IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgam9iUXVldWU6IFx0VGhlIHF1ZXVlIHRvIHdoaWNoIHRoZSBjb21wdXRlIG5vZGVzIGFyZSBhZGRlZC5cbiAgICAgKi9cbiAgICBwdWJsaWMgam9iUXVldWU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBrZXlQYWlyTmFtZTogS2V5IHBhaXIgbmFtZS5cbiAgICAgKi9cbiAgICBwdWJsaWMga2V5UGFpck5hbWU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBuZXR3b3JrSW50ZXJmYWNlVHJhZmZpY01vZGU6IENvbW11bmljYXRpb24gbW9kZSBvZiBhbiBlbGFzdGljIE5JQy4gVmFsdWUgdmFsdWVzOlxuICAgICAqIC0gKipTdGFuZGFyZCoqOiBUaGUgVENQIGNvbW11bmljYXRpb24gbW9kZSBpcyB1c2VkLlxuICAgICAqIC0gKipIaWdoUGVyZm9ybWFuY2UqKjogRW5hYmxlcyB0aGUgRWxhc3RpYyBSRE1BIEludGVyZmFjZSAoRVJJKSBhbmQgdXNlcyB0aGUgUkRNQSBjb21tdW5pY2F0aW9uIG1vZGUuXG4gICAgICovXG4gICAgcHVibGljIG5ldHdvcmtJbnRlcmZhY2VUcmFmZmljTW9kZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHBhc3N3b3JkOiBSb290IHBhc3N3b3JkIG9mIGp1bXAgc2VydmVyIChsb2dpbiBub2RlKS4gOCB0byAzMCBjaGFyYWN0ZXJzLCBtdXN0IGNvbnRhaW4gdGhyZWUgKHVwcGVyIGFuZCBsb3dlciBjYXNlIGxldHRlcnMsIG51bWJlcnMgYW5kIHNwZWNpYWwgc3ltYm9scykuICEgU3VwcG9ydHMgdGhlIGZvbGxvd2luZyBzcGVjaWFsIGNoYXJhY3RlcnMgOigpIGB+IEAgIyAkJSBeICYgKiAtICsgPSB8IHt9IFtdOjsgJzw+LCBcXC8gQmUgc3VyZSB0byB1c2UgdGhlIEhUVFBTIHByb3RvY29sIEFQSSBjYWxsIHRvIGF2b2lkIHBhc3N3b3JkIGxlYWtzIHRoYXQgbWF5IG9jY3VyLj8uXG4gICAgICovXG4gICAgcHVibGljIHBhc3N3b3JkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgcGVyaW9kOiBUaGUgcHVyY2hhc2Ugb2YgbG9uZyByZXNvdXJjZXMsIHVuaXRzOiB3ZWVrIFxcLyBtb250aCBcXC8geWVhci4gV2hlbiB0aGUgdmFsdWUgb2YgdGhlIHBhcmFtZXRlciBFY3NDaGFyZ2VUeXBlIHdoZW4gUHJlUGFpZCB0YWtlIGVmZmVjdCBhbmQgZm9yIHRoZSBzZWxlY3RlZCB2YWx1ZSB3aWxsIGJlLlxuICAgICAqL1xuICAgIHB1YmxpYyBwZXJpb2Q6IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBwZXJpb2RVbml0OiBUaGUgcHVyY2hhc2Ugb2YgbG9uZy1yZXNvdXJjZXMgdW5pdC4gQWx0ZXJuYXRpdmVseSB2YWx1ZSBXZWVrIFxcLyBNb250aCBcXC8geWVhci5cbiAgICAgKi9cbiAgICBwdWJsaWMgcGVyaW9kVW5pdDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHBvc3RJbnN0YWxsU2NyaXB0OlxuICAgICAqL1xuICAgIHB1YmxpYyBwb3N0SW5zdGFsbFNjcmlwdDogQXJyYXk8Um9zQ2x1c3Rlci5Qb3N0SW5zdGFsbFNjcmlwdFByb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlPiB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSByYW1Ob2RlVHlwZXM6IFdoZW4gYXV0aG9yaXppbmcgaW5zdGFuY2UgY29uZmlndXJhdGlvbiwgdGhlIG5vZGUgdHlwZSB0byB3aGljaCB0aGUgUkFNIHJvbGUgaXMgYm91bmQuXG4gICAgICogV2hlbiB0aGUgdmFsdWUgb2YgRGVwbG95TW9kZSBpcyBTdGFuZGFyZCwgdGhlIHZhbHVlIHJhbmdlOiBzY2hlZHVsZXIsIGFjY291bnQsIGxvZ2luLCBjb21wdXRlLlxuICAgICAqIFdoZW4gdGhlIHZhbHVlIG9mIERlcGxveU1vZGUgaXMgU2ltcGxlLCB0aGUgdmFsdWUgcmFuZ2U6IG1hbmFnZXIsIGxvZ2luLCBjb21wdXRlLlxuICAgICAqIFdoZW4gdGhlIHZhbHVlIG9mIERlcGxveU1vZGUgaXMgVGlueSwgdGhlIHZhbHVlIHJhbmdlOiBtYW5hZ2VyLCBjb21wdXRlLlxuICAgICAqL1xuICAgIHB1YmxpYyByYW1Ob2RlVHlwZXM6IEFycmF5PHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgcmFtUm9sZU5hbWU6IFRoZSBuYW1lIG9mIHRoZSBSZXNvdXJjZSBBY2Nlc3MgTWFuYWdlbWVudCAoUkFNKSByb2xlLlxuICAgICAqIFlvdSBjYW4gY2FsbCB0aGUgTGlzdFJvbGVzIG9wZXJhdGlvbiBwcm92aWRlZCBieSBSQU0gdG8gcXVlcnkgdGhlIGNyZWF0ZWQgUkFNIHJvbGVzLlxuICAgICAqL1xuICAgIHB1YmxpYyByYW1Sb2xlTmFtZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHJlbW90ZURpcmVjdG9yeTogTW91bnQgc2hhcmVkIHN0b3JhZ2UgcmVtb3RlIGRpcmVjdG9yeS4gVGhlIGZpbmFsIHBhdGggdG8gdGhlIG1vdW50IHBvaW50IGFuZCBtb3VudCB0aGUgcmVtb3RlIGRpcmVjdG9yeSBjb21wb3NpdGlvbjogTmFzTW91bnRwb2ludDogXFwvIFJlbW90ZURpcmVjdG9yeVxuICAgICAqL1xuICAgIHB1YmxpYyByZW1vdGVEaXJlY3Rvcnk6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSByZW1vdGVWaXNFbmFibGU6IFNwZWNpZmllcyB3aGV0aGVyIHRvIGVuYWJsZSBWaXJ0dWFsIE5ldHdvcmsgQ29tcHV0aW5nIChWTkMpLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogdHJ1ZTogZW5hYmxlcyBWTkNcbiAgICAgKiBmYWxzZTogZGlzYWJsZXMgVk5DXG4gICAgICogRGVmYXVsdCB2YWx1ZTogZmFsc2VcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVtb3RlVmlzRW5hYmxlOiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHJlc291cmNlR3JvdXBJZDogVGhlIElEIG9mIHRoZSByZXNvdXJjZSBncm91cC5cbiAgICAgKiBZb3UgY2FuIGNhbGwgdGhlIExpc3RSZXNvdXJjZUdyb3VwcyBvcGVyYXRpb24gdG8gb2J0YWluIHRoZSBJRCBvZiB0aGUgcmVzb3VyY2UgZ3JvdXAuXG4gICAgICovXG4gICAgcHVibGljIHJlc291cmNlR3JvdXBJZDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHNjY0NsdXN0ZXJJZDogV2hlbiBTQ0MgbW9kZWxzLCBpZiB5b3UgcGFzcyB0aGlzIGZpZWxkLCB0aGVuIHRoZSBzcGVjaWZpZWQgU2NjQ2x1c3RlciBjcmVhdGUgU2NjIGluc3RhbmNlLCBvdGhlcndpc2UgaXQgd2lsbCBjcmVhdGUgYW4gaW5zdGFuY2UgZm9yIHRoZSB1c2VyLlxuICAgICAqL1xuICAgIHB1YmxpYyBzY2NDbHVzdGVySWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBzY2hlZHVsZXJUeXBlOiBUaGUgdHlwZSBvZiB0aGUgc2NoZWR1bGVyLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogcGJzXG4gICAgICogc2x1cm1cbiAgICAgKiBvcGVuZ3JpZHNjaGVkdWxlclxuICAgICAqIGRlYWRsaW5lXG4gICAgICogRGVmYXVsdCB2YWx1ZTogcGJzXG4gICAgICovXG4gICAgcHVibGljIHNjaGVkdWxlclR5cGU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBzZWN1cml0eUdyb3VwSWQ6IFNlY3VyaXR5IGdyb3VwIElELlxuICAgICAqL1xuICAgIHB1YmxpYyBzZWN1cml0eUdyb3VwSWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBzZWN1cml0eUdyb3VwTmFtZTogSWYgeW91IGRvIG5vdCB1c2UgYW4gZXhpc3Rpbmcgc2VjdXJpdHkgZ3JvdXAgKFNlY3VyaXR5R3JvdXBJZCBpcyBlbXB0eSksIHRoZW4gdXNlIHRoaXMgbmFtZSB0byBjcmVhdGUgYSBuZXcgc2VjdXJpdHkgZ3JvdXAsIHRoZSBkZWZhdWx0IHBvbGljeS4gRm9ybWF0IFJlcXVpcmVtZW50cyBSZWZlcmVuY2UgRUNTIHNlY3VyaXR5IGdyb3VwIG5hbWUuXG4gICAgICovXG4gICAgcHVibGljIHNlY3VyaXR5R3JvdXBOYW1lOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgc3lzdGVtRGlza0xldmVsOiBUaGUgcGVyZm9ybWFuY2UgbGV2ZWwgb2YgdGhlIEVTU0QgdGhhdCBpcyBjcmVhdGVkIGFzIHRoZSBzeXN0ZW0gZGlzay4gVmFsaWQgdmFsdWVzOlxuICAgICAqIFBMMDogQSBzaW5nbGUgRVNTRCBjYW4gZGVsaXZlciB1cCB0byAxMCwwMDAgaW5wdXRcXC9vdXRwdXQgb3BlcmF0aW9ucyBwZXIgc2Vjb25kIChJT1BTKSBvZiByYW5kb20gcmVhZFxcL3dyaXRlLlxuICAgICAqIFBMMTogQSBzaW5nbGUgRVNTRCBjYW4gZGVsaXZlciB1cCB0byA1MCwwMDAgSU9QUyBvZiByYW5kb20gcmVhZFxcL3dyaXRlLlxuICAgICAqIFBMMjogQSBzaW5nbGUgRVNTRCBjYW4gZGVsaXZlciB1cCB0byAxMDAsMDAwIElPUFMgb2YgcmFuZG9tIHJlYWRcXC93cml0ZS5cbiAgICAgKiBQTDM6IEEgc2luZ2xlIEVTU0QgY2FuIGRlbGl2ZXIgdXAgdG8gMSwwMDAsMDAwIElPUFMgb2YgcmFuZG9tIHJlYWRcXC93cml0ZS5cbiAgICAgKiBEZWZhdWx0IHZhbHVlOiBQTDFcbiAgICAgKi9cbiAgICBwdWJsaWMgc3lzdGVtRGlza0xldmVsOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgc3lzdGVtRGlza1NpemU6IFRoZSBzaXplIG9mIHRoZSBzeXN0ZW0gZGlzay4gVW5pdDogR0JcbiAgICAgKiBWYWxpZCB2YWx1ZXM6IDQwIHRvIDUwMFxuICAgICAqIERlZmF1bHQgdmFsdWU6IDQwXG4gICAgICovXG4gICAgcHVibGljIHN5c3RlbURpc2tTaXplOiBudW1iZXIgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgc3lzdGVtRGlza1R5cGU6IFRoZSB0eXBlIG9mIHRoZSBzeXN0ZW0gZGlzay4gVmFsaWQgdmFsdWVzOlxuICAgICAqIGNsb3VkX2VmZmljaWVuY3k6IHVsdHJhIGRpc2suXG4gICAgICogY2xvdWRfc3NkOiBTU0QuXG4gICAgICogY2xvdWRfZXNzZDogRVNTRC5cbiAgICAgKiBEZWZhdWx0IHZhbHVlOiBjbG91ZF9zc2RcbiAgICAgKi9cbiAgICBwdWJsaWMgc3lzdGVtRGlza1R5cGU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSB2b2x1bWVJZDogVGhlIElEIG9mIHRoZSBmaWxlIHN5c3RlbS4gSWYgeW91IGxlYXZlIHRoZSBwYXJhbWV0ZXIgZW1wdHksIGEgUGVyZm9ybWFuY2UgTkFTIGZpbGUgc3lzdGVtIGlzIGNyZWF0ZWQgYnkgZGVmYXVsdC5cbiAgICAgKi9cbiAgICBwdWJsaWMgdm9sdW1lSWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSB2b2x1bWVNb3VudHBvaW50OiBUaGUgbW91bnQgdGFyZ2V0IG9mIHRoZSBmaWxlIHN5c3RlbS4gVGFrZSBub3RlIG9mIHRoZSBmb2xsb3dpbmcgaW5mb3JtYXRpb246XG4gICAgICogSWYgeW91IGRvIG5vdCBzcGVjaWZ5IHRoZSBWb2x1bWVJZCBwYXJhbWV0ZXIsIHlvdSBjYW4gbGVhdmUgdGhlIFZvbHVtZU1vdW50cG9pbnQgcGFyYW1ldGVyIGVtcHR5LiBBIG1vdW50IHRhcmdldCBpcyBjcmVhdGVkIGJ5IGRlZmF1bHQuXG4gICAgICogSWYgeW91IHNwZWNpZnkgdGhlIFZvbHVtZUlkIHBhcmFtZXRlciwgdGhlIFZvbHVtZU1vdW50cG9pbnQgcGFyYW1ldGVyIGlzIHJlcXVpcmVkLlxuICAgICAqL1xuICAgIHB1YmxpYyB2b2x1bWVNb3VudHBvaW50OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgdm9sdW1lUHJvdG9jb2w6IFRoZSB0eXBlIG9mIHRoZSBwcm90b2NvbCB0aGF0IGlzIHVzZWQgYnkgdGhlIGZpbGUgc3lzdGVtLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogbmZzXG4gICAgICogc21iXG4gICAgICogRGVmYXVsdCB2YWx1ZTogbmZzXG4gICAgICovXG4gICAgcHVibGljIHZvbHVtZVByb3RvY29sOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgdm9sdW1lVHlwZTogVGhlIHR5cGUgb2YgdGhlIHNoYXJlZCBzdG9yYWdlLiBPbmx5IEFwc2FyYSBGaWxlIFN0b3JhZ2UgbmFzIGZpbGUgc3lzdGVtcyBhcmUgc3VwcG9ydGVkLlxuICAgICAqL1xuICAgIHB1YmxpYyB2b2x1bWVUeXBlOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgdnBjSWQ6IFRoZSBJRCBvZiB0aGUgdmlydHVhbCBwcml2YXRlIGNsb3VkIChWUEMpIHRvIHdoaWNoIHRoZSBFLUhQQyBjbHVzdGVyIGJlbG9uZ3MuXG4gICAgICovXG4gICAgcHVibGljIHZwY0lkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgd2l0aG91dEVsYXN0aWNJcDogU3BlY2lmaWVzIHdoZXRoZXIgdGhlIGxvZ29uIG5vZGUgdXNlcyBhbiBlbGFzdGljIElQIGFkZHJlc3MgKEVJUCkuIERlZmF1bHQgdmFsdWU6IGZhbHNlXG4gICAgICovXG4gICAgcHVibGljIHdpdGhvdXRFbGFzdGljSXA6IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgem9uZUlkOiBBdmFpbGFibGUgYXJlYSBJRC5cbiAgICAgKi9cbiAgICBwdWJsaWMgem9uZUlkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUm9zQ2x1c3RlclByb3BzLCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDogYm9vbGVhbikge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogUm9zQ2x1c3Rlci5ST1NfUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgdGhpcy5hdHRyQ2x1c3RlcklkID0gdGhpcy5nZXRBdHQoJ0NsdXN0ZXJJZCcpO1xuICAgICAgICB0aGlzLmF0dHJFY3NJbmZvID0gdGhpcy5nZXRBdHQoJ0Vjc0luZm8nKTtcbiAgICAgICAgdGhpcy5hdHRyTmFtZSA9IHRoaXMuZ2V0QXR0KCdOYW1lJyk7XG4gICAgICAgIHRoaXMuYXR0clNlY3VyaXR5R3JvdXBJZCA9IHRoaXMuZ2V0QXR0KCdTZWN1cml0eUdyb3VwSWQnKTtcblxuICAgICAgICB0aGlzLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50ID0gZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ7XG4gICAgICAgIHRoaXMuZWNzT3JkZXJDb21wdXRlQ291bnQgPSBwcm9wcy5lY3NPcmRlckNvbXB1dGVDb3VudDtcbiAgICAgICAgdGhpcy5lY3NPcmRlckNvbXB1dGVJbnN0YW5jZVR5cGUgPSBwcm9wcy5lY3NPcmRlckNvbXB1dGVJbnN0YW5jZVR5cGU7XG4gICAgICAgIHRoaXMuZWNzT3JkZXJMb2dpbkNvdW50ID0gcHJvcHMuZWNzT3JkZXJMb2dpbkNvdW50O1xuICAgICAgICB0aGlzLmVjc09yZGVyTG9naW5JbnN0YW5jZVR5cGUgPSBwcm9wcy5lY3NPcmRlckxvZ2luSW5zdGFuY2VUeXBlO1xuICAgICAgICB0aGlzLmVjc09yZGVyTWFuYWdlckluc3RhbmNlVHlwZSA9IHByb3BzLmVjc09yZGVyTWFuYWdlckluc3RhbmNlVHlwZTtcbiAgICAgICAgdGhpcy5uYW1lID0gcHJvcHMubmFtZTtcbiAgICAgICAgdGhpcy5vc1RhZyA9IHByb3BzLm9zVGFnO1xuICAgICAgICB0aGlzLnZTd2l0Y2hJZCA9IHByb3BzLnZTd2l0Y2hJZDtcbiAgICAgICAgdGhpcy5hY2NvdW50VHlwZSA9IHByb3BzLmFjY291bnRUeXBlO1xuICAgICAgICB0aGlzLmFkZGl0aW9uYWxWb2x1bWVzID0gcHJvcHMuYWRkaXRpb25hbFZvbHVtZXM7XG4gICAgICAgIHRoaXMuYXBwbGljYXRpb24gPSBwcm9wcy5hcHBsaWNhdGlvbjtcbiAgICAgICAgdGhpcy5hdXRvUmVuZXcgPSBwcm9wcy5hdXRvUmVuZXc7XG4gICAgICAgIHRoaXMuYXV0b1JlbmV3UGVyaW9kID0gcHJvcHMuYXV0b1JlbmV3UGVyaW9kO1xuICAgICAgICB0aGlzLmNsaWVudFZlcnNpb24gPSBwcm9wcy5jbGllbnRWZXJzaW9uO1xuICAgICAgICB0aGlzLmNvbXB1dGVFbmFibGVIdCA9IHByb3BzLmNvbXB1dGVFbmFibGVIdDtcbiAgICAgICAgdGhpcy5jb21wdXRlU3BvdFByaWNlTGltaXQgPSBwcm9wcy5jb21wdXRlU3BvdFByaWNlTGltaXQ7XG4gICAgICAgIHRoaXMuY29tcHV0ZVNwb3RTdHJhdGVneSA9IHByb3BzLmNvbXB1dGVTcG90U3RyYXRlZ3k7XG4gICAgICAgIHRoaXMuZGVwbG95TW9kZSA9IHByb3BzLmRlcGxveU1vZGU7XG4gICAgICAgIHRoaXMuZGVzY3JpcHRpb24gPSBwcm9wcy5kZXNjcmlwdGlvbjtcbiAgICAgICAgdGhpcy5lY3NDaGFyZ2VUeXBlID0gcHJvcHMuZWNzQ2hhcmdlVHlwZTtcbiAgICAgICAgdGhpcy5lY3NPcmRlck1hbmFnZXJDb3VudCA9IHByb3BzLmVjc09yZGVyTWFuYWdlckNvdW50O1xuICAgICAgICB0aGlzLmVocGNWZXJzaW9uID0gcHJvcHMuZWhwY1ZlcnNpb247XG4gICAgICAgIHRoaXMuaGFFbmFibGUgPSBwcm9wcy5oYUVuYWJsZTtcbiAgICAgICAgdGhpcy5pbWFnZUlkID0gcHJvcHMuaW1hZ2VJZDtcbiAgICAgICAgdGhpcy5pbWFnZU93bmVyQWxpYXMgPSBwcm9wcy5pbWFnZU93bmVyQWxpYXM7XG4gICAgICAgIHRoaXMuaW5wdXRGaWxlVXJsID0gcHJvcHMuaW5wdXRGaWxlVXJsO1xuICAgICAgICB0aGlzLmlzQ29tcHV0ZUVzcyA9IHByb3BzLmlzQ29tcHV0ZUVzcztcbiAgICAgICAgdGhpcy5qb2JRdWV1ZSA9IHByb3BzLmpvYlF1ZXVlO1xuICAgICAgICB0aGlzLmtleVBhaXJOYW1lID0gcHJvcHMua2V5UGFpck5hbWU7XG4gICAgICAgIHRoaXMubmV0d29ya0ludGVyZmFjZVRyYWZmaWNNb2RlID0gcHJvcHMubmV0d29ya0ludGVyZmFjZVRyYWZmaWNNb2RlO1xuICAgICAgICB0aGlzLnBhc3N3b3JkID0gcHJvcHMucGFzc3dvcmQ7XG4gICAgICAgIHRoaXMucGVyaW9kID0gcHJvcHMucGVyaW9kO1xuICAgICAgICB0aGlzLnBlcmlvZFVuaXQgPSBwcm9wcy5wZXJpb2RVbml0O1xuICAgICAgICB0aGlzLnBvc3RJbnN0YWxsU2NyaXB0ID0gcHJvcHMucG9zdEluc3RhbGxTY3JpcHQ7XG4gICAgICAgIHRoaXMucmFtTm9kZVR5cGVzID0gcHJvcHMucmFtTm9kZVR5cGVzO1xuICAgICAgICB0aGlzLnJhbVJvbGVOYW1lID0gcHJvcHMucmFtUm9sZU5hbWU7XG4gICAgICAgIHRoaXMucmVtb3RlRGlyZWN0b3J5ID0gcHJvcHMucmVtb3RlRGlyZWN0b3J5O1xuICAgICAgICB0aGlzLnJlbW90ZVZpc0VuYWJsZSA9IHByb3BzLnJlbW90ZVZpc0VuYWJsZTtcbiAgICAgICAgdGhpcy5yZXNvdXJjZUdyb3VwSWQgPSBwcm9wcy5yZXNvdXJjZUdyb3VwSWQ7XG4gICAgICAgIHRoaXMuc2NjQ2x1c3RlcklkID0gcHJvcHMuc2NjQ2x1c3RlcklkO1xuICAgICAgICB0aGlzLnNjaGVkdWxlclR5cGUgPSBwcm9wcy5zY2hlZHVsZXJUeXBlO1xuICAgICAgICB0aGlzLnNlY3VyaXR5R3JvdXBJZCA9IHByb3BzLnNlY3VyaXR5R3JvdXBJZDtcbiAgICAgICAgdGhpcy5zZWN1cml0eUdyb3VwTmFtZSA9IHByb3BzLnNlY3VyaXR5R3JvdXBOYW1lO1xuICAgICAgICB0aGlzLnN5c3RlbURpc2tMZXZlbCA9IHByb3BzLnN5c3RlbURpc2tMZXZlbDtcbiAgICAgICAgdGhpcy5zeXN0ZW1EaXNrU2l6ZSA9IHByb3BzLnN5c3RlbURpc2tTaXplO1xuICAgICAgICB0aGlzLnN5c3RlbURpc2tUeXBlID0gcHJvcHMuc3lzdGVtRGlza1R5cGU7XG4gICAgICAgIHRoaXMudm9sdW1lSWQgPSBwcm9wcy52b2x1bWVJZDtcbiAgICAgICAgdGhpcy52b2x1bWVNb3VudHBvaW50ID0gcHJvcHMudm9sdW1lTW91bnRwb2ludDtcbiAgICAgICAgdGhpcy52b2x1bWVQcm90b2NvbCA9IHByb3BzLnZvbHVtZVByb3RvY29sO1xuICAgICAgICB0aGlzLnZvbHVtZVR5cGUgPSBwcm9wcy52b2x1bWVUeXBlO1xuICAgICAgICB0aGlzLnZwY0lkID0gcHJvcHMudnBjSWQ7XG4gICAgICAgIHRoaXMud2l0aG91dEVsYXN0aWNJcCA9IHByb3BzLndpdGhvdXRFbGFzdGljSXA7XG4gICAgICAgIHRoaXMuem9uZUlkID0gcHJvcHMuem9uZUlkO1xuICAgIH1cblxuXG4gICAgcHJvdGVjdGVkIGdldCByb3NQcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGVjc09yZGVyQ29tcHV0ZUNvdW50OiB0aGlzLmVjc09yZGVyQ29tcHV0ZUNvdW50LFxuICAgICAgICAgICAgZWNzT3JkZXJDb21wdXRlSW5zdGFuY2VUeXBlOiB0aGlzLmVjc09yZGVyQ29tcHV0ZUluc3RhbmNlVHlwZSxcbiAgICAgICAgICAgIGVjc09yZGVyTG9naW5Db3VudDogdGhpcy5lY3NPcmRlckxvZ2luQ291bnQsXG4gICAgICAgICAgICBlY3NPcmRlckxvZ2luSW5zdGFuY2VUeXBlOiB0aGlzLmVjc09yZGVyTG9naW5JbnN0YW5jZVR5cGUsXG4gICAgICAgICAgICBlY3NPcmRlck1hbmFnZXJJbnN0YW5jZVR5cGU6IHRoaXMuZWNzT3JkZXJNYW5hZ2VySW5zdGFuY2VUeXBlLFxuICAgICAgICAgICAgbmFtZTogdGhpcy5uYW1lLFxuICAgICAgICAgICAgb3NUYWc6IHRoaXMub3NUYWcsXG4gICAgICAgICAgICB2U3dpdGNoSWQ6IHRoaXMudlN3aXRjaElkLFxuICAgICAgICAgICAgYWNjb3VudFR5cGU6IHRoaXMuYWNjb3VudFR5cGUsXG4gICAgICAgICAgICBhZGRpdGlvbmFsVm9sdW1lczogdGhpcy5hZGRpdGlvbmFsVm9sdW1lcyxcbiAgICAgICAgICAgIGFwcGxpY2F0aW9uOiB0aGlzLmFwcGxpY2F0aW9uLFxuICAgICAgICAgICAgYXV0b1JlbmV3OiB0aGlzLmF1dG9SZW5ldyxcbiAgICAgICAgICAgIGF1dG9SZW5ld1BlcmlvZDogdGhpcy5hdXRvUmVuZXdQZXJpb2QsXG4gICAgICAgICAgICBjbGllbnRWZXJzaW9uOiB0aGlzLmNsaWVudFZlcnNpb24sXG4gICAgICAgICAgICBjb21wdXRlRW5hYmxlSHQ6IHRoaXMuY29tcHV0ZUVuYWJsZUh0LFxuICAgICAgICAgICAgY29tcHV0ZVNwb3RQcmljZUxpbWl0OiB0aGlzLmNvbXB1dGVTcG90UHJpY2VMaW1pdCxcbiAgICAgICAgICAgIGNvbXB1dGVTcG90U3RyYXRlZ3k6IHRoaXMuY29tcHV0ZVNwb3RTdHJhdGVneSxcbiAgICAgICAgICAgIGRlcGxveU1vZGU6IHRoaXMuZGVwbG95TW9kZSxcbiAgICAgICAgICAgIGRlc2NyaXB0aW9uOiB0aGlzLmRlc2NyaXB0aW9uLFxuICAgICAgICAgICAgZWNzQ2hhcmdlVHlwZTogdGhpcy5lY3NDaGFyZ2VUeXBlLFxuICAgICAgICAgICAgZWNzT3JkZXJNYW5hZ2VyQ291bnQ6IHRoaXMuZWNzT3JkZXJNYW5hZ2VyQ291bnQsXG4gICAgICAgICAgICBlaHBjVmVyc2lvbjogdGhpcy5laHBjVmVyc2lvbixcbiAgICAgICAgICAgIGhhRW5hYmxlOiB0aGlzLmhhRW5hYmxlLFxuICAgICAgICAgICAgaW1hZ2VJZDogdGhpcy5pbWFnZUlkLFxuICAgICAgICAgICAgaW1hZ2VPd25lckFsaWFzOiB0aGlzLmltYWdlT3duZXJBbGlhcyxcbiAgICAgICAgICAgIGlucHV0RmlsZVVybDogdGhpcy5pbnB1dEZpbGVVcmwsXG4gICAgICAgICAgICBpc0NvbXB1dGVFc3M6IHRoaXMuaXNDb21wdXRlRXNzLFxuICAgICAgICAgICAgam9iUXVldWU6IHRoaXMuam9iUXVldWUsXG4gICAgICAgICAgICBrZXlQYWlyTmFtZTogdGhpcy5rZXlQYWlyTmFtZSxcbiAgICAgICAgICAgIG5ldHdvcmtJbnRlcmZhY2VUcmFmZmljTW9kZTogdGhpcy5uZXR3b3JrSW50ZXJmYWNlVHJhZmZpY01vZGUsXG4gICAgICAgICAgICBwYXNzd29yZDogdGhpcy5wYXNzd29yZCxcbiAgICAgICAgICAgIHBlcmlvZDogdGhpcy5wZXJpb2QsXG4gICAgICAgICAgICBwZXJpb2RVbml0OiB0aGlzLnBlcmlvZFVuaXQsXG4gICAgICAgICAgICBwb3N0SW5zdGFsbFNjcmlwdDogdGhpcy5wb3N0SW5zdGFsbFNjcmlwdCxcbiAgICAgICAgICAgIHJhbU5vZGVUeXBlczogdGhpcy5yYW1Ob2RlVHlwZXMsXG4gICAgICAgICAgICByYW1Sb2xlTmFtZTogdGhpcy5yYW1Sb2xlTmFtZSxcbiAgICAgICAgICAgIHJlbW90ZURpcmVjdG9yeTogdGhpcy5yZW1vdGVEaXJlY3RvcnksXG4gICAgICAgICAgICByZW1vdGVWaXNFbmFibGU6IHRoaXMucmVtb3RlVmlzRW5hYmxlLFxuICAgICAgICAgICAgcmVzb3VyY2VHcm91cElkOiB0aGlzLnJlc291cmNlR3JvdXBJZCxcbiAgICAgICAgICAgIHNjY0NsdXN0ZXJJZDogdGhpcy5zY2NDbHVzdGVySWQsXG4gICAgICAgICAgICBzY2hlZHVsZXJUeXBlOiB0aGlzLnNjaGVkdWxlclR5cGUsXG4gICAgICAgICAgICBzZWN1cml0eUdyb3VwSWQ6IHRoaXMuc2VjdXJpdHlHcm91cElkLFxuICAgICAgICAgICAgc2VjdXJpdHlHcm91cE5hbWU6IHRoaXMuc2VjdXJpdHlHcm91cE5hbWUsXG4gICAgICAgICAgICBzeXN0ZW1EaXNrTGV2ZWw6IHRoaXMuc3lzdGVtRGlza0xldmVsLFxuICAgICAgICAgICAgc3lzdGVtRGlza1NpemU6IHRoaXMuc3lzdGVtRGlza1NpemUsXG4gICAgICAgICAgICBzeXN0ZW1EaXNrVHlwZTogdGhpcy5zeXN0ZW1EaXNrVHlwZSxcbiAgICAgICAgICAgIHZvbHVtZUlkOiB0aGlzLnZvbHVtZUlkLFxuICAgICAgICAgICAgdm9sdW1lTW91bnRwb2ludDogdGhpcy52b2x1bWVNb3VudHBvaW50LFxuICAgICAgICAgICAgdm9sdW1lUHJvdG9jb2w6IHRoaXMudm9sdW1lUHJvdG9jb2wsXG4gICAgICAgICAgICB2b2x1bWVUeXBlOiB0aGlzLnZvbHVtZVR5cGUsXG4gICAgICAgICAgICB2cGNJZDogdGhpcy52cGNJZCxcbiAgICAgICAgICAgIHdpdGhvdXRFbGFzdGljSXA6IHRoaXMud2l0aG91dEVsYXN0aWNJcCxcbiAgICAgICAgICAgIHpvbmVJZDogdGhpcy56b25lSWQsXG4gICAgICAgIH07XG4gICAgfVxuICAgIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7W2tleTogc3RyaW5nXTogYW55fSk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHJvc0NsdXN0ZXJQcm9wc1RvUm9zVGVtcGxhdGUocHJvcHMsIHRoaXMuZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpO1xuICAgIH1cbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBSb3NDbHVzdGVyIHtcbiAgICAvKipcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBBZGRpdGlvbmFsVm9sdW1lc1Byb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEBQcm9wZXJ0eSB2b2x1bWVQcm90b2NvbDogVGhlIHR5cGUgb2YgdGhlIHByb3RvY29sIHRoYXQgaXMgdXNlZCBieSB0aGUgYWRkaXRpb25hbCBmaWxlIHN5c3RlbS4gVmFsaWQgdmFsdWVzOlxuICAgICAqIG5mc1xuICAgICAqIHNtYlxuICAgICAqIERlZmF1bHQgdmFsdWU6IG5mc1xuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgdm9sdW1lUHJvdG9jb2w/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBAUHJvcGVydHkgbG9jYWxEaXJlY3Rvcnk6IFRoZSBsb2NhbCBkaXJlY3RvcnkgdG8gd2hpY2ggdGhlIGFkZGl0aW9uYWwgZmlsZSBzeXN0ZW0gaXMgbW91bnRlZC5cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGxvY2FsRGlyZWN0b3J5OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBAUHJvcGVydHkgdm9sdW1lSWQ6IFRoZSBJRCBvZiB0aGUgYWRkaXRpb25hbCBmaWxlIHN5c3RlbS5cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHZvbHVtZUlkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBAUHJvcGVydHkgcmVtb3RlRGlyZWN0b3J5OiBUaGUgcmVtb3RlIGRpcmVjdG9yeSB0byB3aGljaCB0aGUgYWRkaXRpb25hbCBmaWxlIHN5c3RlbSBpcyBtb3VudGVkLlxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgcmVtb3RlRGlyZWN0b3J5Pzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogQFByb3BlcnR5IHZvbHVtZVR5cGU6IFRoZSB0eXBlIG9mIHRoZSBhZGRpdGlvbmFsIHNoYXJlZCBzdG9yYWdlLiBPbmx5IG5hcyBmaWxlIHN5c3RlbXMgYXJlIHN1cHBvcnRlZC5cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHZvbHVtZVR5cGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBAUHJvcGVydHkgam9iUXVldWU6IFRoZSBxdWV1ZSBvZiB0aGUgbm9kZXMgdG8gd2hpY2ggdGhlIGFkZGl0aW9uYWwgZmlsZSBzeXN0ZW0gaXMgYXR0YWNoZWQuXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBqb2JRdWV1ZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEBQcm9wZXJ0eSB2b2x1bWVNb3VudHBvaW50OiBUaGUgbW91bnQgdGFyZ2V0IG9mIHRoZSBhZGRpdGlvbmFsIGZpbGUgc3lzdGVtLlxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgdm9sdW1lTW91bnRwb2ludDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogQFByb3BlcnR5IGxvY2F0aW9uOiBUaGUgdHlwZSBvZiB0aGUgY2x1c3Rlci4gVmFsaWQgdmFsdWU6IFB1YmxpY0Nsb3VkLlxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbG9jYXRpb24/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG4gICAgfVxufVxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBBZGRpdGlvbmFsVm9sdW1lc1Byb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBBZGRpdGlvbmFsVm9sdW1lc1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIFJvc0NsdXN0ZXJfQWRkaXRpb25hbFZvbHVtZXNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiByb3MuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFyb3MuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcm9zLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyByb3MuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3ZvbHVtZVByb3RvY29sJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnZvbHVtZVByb3RvY29sKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdsb2NhbERpcmVjdG9yeScsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5sb2NhbERpcmVjdG9yeSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignbG9jYWxEaXJlY3RvcnknLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubG9jYWxEaXJlY3RvcnkpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3ZvbHVtZUlkJywgcm9zLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnZvbHVtZUlkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCd2b2x1bWVJZCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy52b2x1bWVJZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigncmVtb3RlRGlyZWN0b3J5Jywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnJlbW90ZURpcmVjdG9yeSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndm9sdW1lVHlwZScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy52b2x1bWVUeXBlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdqb2JRdWV1ZScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5qb2JRdWV1ZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndm9sdW1lTW91bnRwb2ludCcsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy52b2x1bWVNb3VudHBvaW50KSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCd2b2x1bWVNb3VudHBvaW50Jywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnZvbHVtZU1vdW50cG9pbnQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2xvY2F0aW9uJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmxvY2F0aW9uKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkFkZGl0aW9uYWxWb2x1bWVzUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBwcm9wZXJ0aWVzIG9mIGFuIGBBTElZVU46OkVIUEM6OkNsdXN0ZXIuQWRkaXRpb25hbFZvbHVtZXNgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEFkZGl0aW9uYWxWb2x1bWVzUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBwcm9wZXJ0aWVzIG9mIGFuIGBBTElZVU46OkVIUEM6OkNsdXN0ZXIuQWRkaXRpb25hbFZvbHVtZXNgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gcm9zQ2x1c3RlckFkZGl0aW9uYWxWb2x1bWVzUHJvcGVydHlUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFyb3MuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIFJvc0NsdXN0ZXJfQWRkaXRpb25hbFZvbHVtZXNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICdWb2x1bWVQcm90b2NvbCc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMudm9sdW1lUHJvdG9jb2wpLFxuICAgICAgJ0xvY2FsRGlyZWN0b3J5Jzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5sb2NhbERpcmVjdG9yeSksXG4gICAgICAnVm9sdW1lSWQnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnZvbHVtZUlkKSxcbiAgICAgICdSZW1vdGVEaXJlY3RvcnknOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnJlbW90ZURpcmVjdG9yeSksXG4gICAgICAnVm9sdW1lVHlwZSc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMudm9sdW1lVHlwZSksXG4gICAgICAnSm9iUXVldWUnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmpvYlF1ZXVlKSxcbiAgICAgICdWb2x1bWVNb3VudHBvaW50Jzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy52b2x1bWVNb3VudHBvaW50KSxcbiAgICAgICdMb2NhdGlvbic6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMubG9jYXRpb24pLFxuICAgIH07XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgUm9zQ2x1c3RlciB7XG4gICAgLyoqXG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgQXBwbGljYXRpb25Qcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBAUHJvcGVydHkgdGFnOiBBcHBsaWNhdGlvbiBzb2Z0d2FyZSB0YWcgKFNvZnR3YXJlVGFnKSwgZm9yIGV4YW1wbGUgT3Blbk1QSV8xMS4xLlxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgdGFnOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG4gICAgfVxufVxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBBcHBsaWNhdGlvblByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBBcHBsaWNhdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIFJvc0NsdXN0ZXJfQXBwbGljYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiByb3MuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFyb3MuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcm9zLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyByb3MuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3RhZycsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy50YWcpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3RhZycsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy50YWcpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQXBwbGljYXRpb25Qcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIHByb3BlcnRpZXMgb2YgYW4gYEFMSVlVTjo6RUhQQzo6Q2x1c3Rlci5BcHBsaWNhdGlvbmAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQXBwbGljYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIHByb3BlcnRpZXMgb2YgYW4gYEFMSVlVTjo6RUhQQzo6Q2x1c3Rlci5BcHBsaWNhdGlvbmAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiByb3NDbHVzdGVyQXBwbGljYXRpb25Qcm9wZXJ0eVRvUm9zVGVtcGxhdGUocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgUm9zQ2x1c3Rlcl9BcHBsaWNhdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgJ1RhZyc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMudGFnKSxcbiAgICB9O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIFJvc0NsdXN0ZXIge1xuICAgIC8qKlxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIFBvc3RJbnN0YWxsU2NyaXB0UHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogQFByb3BlcnR5IGFyZ3M6IE4tdGggKG4gbnVtYmVyZWQgc3RhcnRpbmcgZnJvbSAxLCB5b3UgY2FuIGhhdmUgbXVsdGlwbGUsIG1heGltdW0gMTYpIGV4ZWN1dGlvbiBwYXJhbWV0ZXJzIGFmdGVyIHRoZSBpbnN0YWxsYXRpb24gc2NyaXB0LlxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgYXJncz86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEBQcm9wZXJ0eSB1cmw6IE4tdGggKG4gbnVtYmVyZWQgc3RhcnRpbmcgd2l0aCAxLCBjYW4gaGF2ZSBtdWx0aXBsZSwgbWF4aW11bSAxNikgYWZ0ZXIgaW5zdGFsbGF0aW9uIHNjcmlwdCBEb3dubG9hZC5cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHVybD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcbiAgICB9XG59XG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFBvc3RJbnN0YWxsU2NyaXB0UHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFBvc3RJbnN0YWxsU2NyaXB0UHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gUm9zQ2x1c3Rlcl9Qb3N0SW5zdGFsbFNjcmlwdFByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IHJvcy5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiByb3MuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IHJvcy5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignYXJncycsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5hcmdzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCd1cmwnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudXJsKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlBvc3RJbnN0YWxsU2NyaXB0UHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBwcm9wZXJ0aWVzIG9mIGFuIGBBTElZVU46OkVIUEM6OkNsdXN0ZXIuUG9zdEluc3RhbGxTY3JpcHRgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFBvc3RJbnN0YWxsU2NyaXB0UHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBwcm9wZXJ0aWVzIG9mIGFuIGBBTElZVU46OkVIUEM6OkNsdXN0ZXIuUG9zdEluc3RhbGxTY3JpcHRgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gcm9zQ2x1c3RlclBvc3RJbnN0YWxsU2NyaXB0UHJvcGVydHlUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFyb3MuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIFJvc0NsdXN0ZXJfUG9zdEluc3RhbGxTY3JpcHRQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICdBcmdzJzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5hcmdzKSxcbiAgICAgICdVcmwnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnVybCksXG4gICAgfTtcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBSb3NVc2Vyc2AuXG4gKiBTZWUgaHR0cHM6Ly93d3cuYWxpYmFiYWNsb3VkLmNvbS9oZWxwL3Jvcy9kZXZlbG9wZXItcmVmZXJlbmNlL2FsaXl1bi1laHBjLXVzZXJzXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUm9zVXNlcnNQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgY2x1c3RlcklkOiBUaGUgY2x1c3RlciBJRC5cbiAgICAgKi9cbiAgICByZWFkb25seSBjbHVzdGVySWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSB1c2VyczogVGhlIGluZm9ybWF0aW9uIGFib3V0IHRoZSB1c2Vycy5cbiAgICAgKi9cbiAgICByZWFkb25seSB1c2VyczogQXJyYXk8Um9zVXNlcnMuVXNlcnNQcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgUm9zVXNlcnNQcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUm9zVXNlcnNQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBSb3NVc2Vyc1Byb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IHJvcy5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiByb3MuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IHJvcy5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignY2x1c3RlcklkJywgcm9zLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmNsdXN0ZXJJZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignY2x1c3RlcklkJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmNsdXN0ZXJJZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndXNlcnMnLCByb3MucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMudXNlcnMpKTtcbiAgICBpZihwcm9wZXJ0aWVzLnVzZXJzICYmIChBcnJheS5pc0FycmF5KHByb3BlcnRpZXMudXNlcnMpIHx8ICh0eXBlb2YgcHJvcGVydGllcy51c2VycykgPT09ICdzdHJpbmcnKSkge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3VzZXJzJywgcm9zLnZhbGlkYXRlTGVuZ3RoKSh7XG4gICAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLnVzZXJzLmxlbmd0aCxcbiAgICAgICAgICAgIG1pbjogdW5kZWZpbmVkLFxuICAgICAgICAgICAgbWF4OiAxMDAsXG4gICAgICAgICAgfSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3VzZXJzJywgcm9zLmxpc3RWYWxpZGF0b3IoUm9zVXNlcnNfVXNlcnNQcm9wZXJ0eVZhbGlkYXRvcikpKHByb3BlcnRpZXMudXNlcnMpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiUm9zVXNlcnNQcm9wc1wiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIHByb3BlcnRpZXMgb2YgYW4gYEFMSVlVTjo6RUhQQzo6VXNlcnNgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFJvc1VzZXJzUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBwcm9wZXJ0aWVzIG9mIGFuIGBBTElZVU46OkVIUEM6OlVzZXJzYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIHJvc1VzZXJzUHJvcHNUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXM6IGFueSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW4pOiBhbnkge1xuICAgIGlmICghcm9zLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBpZihlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCkge1xuICAgICAgICBSb3NVc2Vyc1Byb3BzVmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICB9XG4gICAgcmV0dXJuIHtcbiAgICAgICdDbHVzdGVySWQnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmNsdXN0ZXJJZCksXG4gICAgICAnVXNlcnMnOiByb3MubGlzdE1hcHBlcihyb3NVc2Vyc1VzZXJzUHJvcGVydHlUb1Jvc1RlbXBsYXRlKShwcm9wZXJ0aWVzLnVzZXJzKSxcbiAgICB9O1xufVxuXG4vKipcbiAqIFRoaXMgY2xhc3MgaXMgYSBiYXNlIGVuY2Fwc3VsYXRpb24gYXJvdW5kIHRoZSBST1MgcmVzb3VyY2UgdHlwZSBgQUxJWVVOOjpFSFBDOjpVc2Vyc2AsIHdoaWNoIGlzIHVzZWQgdG8gYWRkIG9uZSBvciBtb3JlIHVzZXJzIHRvIGEgc3BlY2lmaWVkIGNsdXN0ZXIuXG4gKiBATm90ZSBUaGlzIGNsYXNzIGRvZXMgbm90IGNvbnRhaW4gYWRkaXRpb25hbCBmdW5jdGlvbnMsIHNvIGl0IGlzIHJlY29tbWVuZGVkIHRvIHVzZSB0aGUgYFVzZXJzYCBjbGFzcyBpbnN0ZWFkIG9mIHRoaXMgY2xhc3MgZm9yIGEgbW9yZSBjb252ZW5pZW50IGRldmVsb3BtZW50IGV4cGVyaWVuY2UuXG4gKiBTZWUgaHR0cHM6Ly93d3cuYWxpYmFiYWNsb3VkLmNvbS9oZWxwL3Jvcy9kZXZlbG9wZXItcmVmZXJlbmNlL2FsaXl1bi1laHBjLXVzZXJzXG4gKi9cbmV4cG9ydCBjbGFzcyBSb3NVc2VycyBleHRlbmRzIHJvcy5Sb3NSZXNvdXJjZSB7XG4gICAgLyoqXG4gICAgICogVGhlIHJlc291cmNlIHR5cGUgbmFtZSBmb3IgdGhpcyByZXNvdXJjZSBjbGFzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJPU19SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkFMSVlVTjo6RUhQQzo6VXNlcnNcIjtcblxuICAgIHB1YmxpYyBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDogYm9vbGVhbjtcblxuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGNsdXN0ZXJJZDogVGhlIGNsdXN0ZXIgSUQuXG4gICAgICovXG4gICAgcHVibGljIGNsdXN0ZXJJZDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHVzZXJzOiBUaGUgaW5mb3JtYXRpb24gYWJvdXQgdGhlIHVzZXJzLlxuICAgICAqL1xuICAgIHB1YmxpYyB1c2VyczogQXJyYXk8Um9zVXNlcnMuVXNlcnNQcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUm9zVXNlcnNQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW4pIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IFJvc1VzZXJzLlJPU19SRVNPVVJDRV9UWVBFX05BTUUsIHByb3BlcnRpZXM6IHByb3BzIH0pO1xuXG4gICAgICAgIHRoaXMuZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgPSBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDtcbiAgICAgICAgdGhpcy5jbHVzdGVySWQgPSBwcm9wcy5jbHVzdGVySWQ7XG4gICAgICAgIHRoaXMudXNlcnMgPSBwcm9wcy51c2VycztcbiAgICB9XG5cblxuICAgIHByb3RlY3RlZCBnZXQgcm9zUHJvcGVydGllcygpOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBjbHVzdGVySWQ6IHRoaXMuY2x1c3RlcklkLFxuICAgICAgICAgICAgdXNlcnM6IHRoaXMudXNlcnMsXG4gICAgICAgIH07XG4gICAgfVxuICAgIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7W2tleTogc3RyaW5nXTogYW55fSk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHJvc1VzZXJzUHJvcHNUb1Jvc1RlbXBsYXRlKHByb3BzLCB0aGlzLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KTtcbiAgICB9XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgUm9zVXNlcnMge1xuICAgIC8qKlxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIFVzZXJzUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogQFByb3BlcnR5IGdyb3VwOiBUaGUgcGVybWlzc2lvbiBncm91cCB0byB3aGljaCB0aGUgdXNlciBOIGJlbG9uZ3MuIFZhbGlkIHZhbHVlczpcbiAgICAgKiAtICoqdXNlcnMqKjogYW4gb3JkaW5hcnkgcGVybWlzc2lvbiBncm91cC4gSXQgaXMgYXBwbGljYWJsZSB0byBvcmRpbmFyeSB1c2VycyB0aGF0IG5lZWQgb25seSB0byBzdWJtaXQgYW5kIGRlYnVnIGpvYnMuXG4gICAgICogLSAqKndoZWVsKio6IGEgc3VkbyBwZXJtaXNzaW9uIGdyb3VwLiBJdCBpcyBhcHBsaWNhYmxlIHRvIHRoZSBhZG1pbmlzdHJhdG9yIHdobyBuZWVkcyB0byBtYW5hZ2UgdGhlIGNsdXN0ZXIuIEluIGFkZGl0aW9uIHRvIHN1Ym1pdHRpbmcgYW5kIGRlYnVnZ2luZyBqb2JzLCB1c2VycyB3aG8gaGF2ZSBzdWRvIHBlcm1pc3Npb25zIGNhbiBydW4gc3VkbyBjb21tYW5kcyB0byBpbnN0YWxsIHNvZnR3YXJlIGFuZCByZXN0YXJ0IG5vZGVzLlxuICAgICAqIFZhbGlkIHZhbHVlcyBvZiBOOiAxIHRvIDEwMC5cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGdyb3VwOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBAUHJvcGVydHkgcGFzc3dvcmQ6IFRoZSBwYXNzd29yZCBvZiB0aGUgTnRoIHVzZXIuIFRoZSBwYXNzd29yZCBtdXN0IGJlIDggdG8gMzAgY2hhcmFjdGVycyBpbiBsZW5ndGggYW5kIGNvbnRhaW4gdGhyZWUgb2YgdGhlIGZvbGxvd2luZyBpdGVtczpcbiAgICAgKiAtIFVwcGVyY2FzZSBsZXR0ZXJcbiAgICAgKiAtIExvd2VyY2FzZSBsZXR0ZXJcbiAgICAgKiAtIERpZ2l0XG4gICAgICogLSBTcGVjaWFsIGNoYXJhY3RlcjogKCl+IUAjJCVeJiotXys9fHt9W106OydcXC88PiwuP1xcL1xuICAgICAqIFZhbGlkIHZhbHVlcyBvZiBOOiAxIHRvIDEwMC5cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHBhc3N3b3JkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBAUHJvcGVydHkgbmFtZTogVGhlIG5hbWUgb2YgdGhlIHVzZXIgdGhhdCB5b3Ugd2FudCB0byBhZGQuIFRoZSBuYW1lIG11c3QgYmUgNiB0byAzMCBjaGFyYWN0ZXJzIGluIGxlbmd0aCBhbmQgY2FuIGNvbnRhaW4gbGV0dGVycywgZGlnaXRzLCBhbmQgcGVyaW9kcyAoLikuIEl0IG11c3Qgc3RhcnQgd2l0aCBhIGxldHRlci4gXG4gICAgICogVmFsaWQgdmFsdWVzIG9mIE46IDEgdG8gMTAwLlxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbmFtZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuICAgIH1cbn1cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgVXNlcnNQcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgVXNlcnNQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBSb3NVc2Vyc19Vc2Vyc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IHJvcy5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiByb3MuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IHJvcy5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZ3JvdXAnLCByb3MucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuZ3JvdXApKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2dyb3VwJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmdyb3VwKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdwYXNzd29yZCcsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5wYXNzd29yZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigncGFzc3dvcmQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucGFzc3dvcmQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ25hbWUnLCByb3MucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMubmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignbmFtZScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5uYW1lKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlVzZXJzUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBwcm9wZXJ0aWVzIG9mIGFuIGBBTElZVU46OkVIUEM6OlVzZXJzLlVzZXJzYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBVc2Vyc1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgcHJvcGVydGllcyBvZiBhbiBgQUxJWVVOOjpFSFBDOjpVc2Vycy5Vc2Vyc2AgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiByb3NVc2Vyc1VzZXJzUHJvcGVydHlUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFyb3MuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIFJvc1VzZXJzX1VzZXJzUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAnR3JvdXAnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmdyb3VwKSxcbiAgICAgICdQYXNzd29yZCc6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMucGFzc3dvcmQpLFxuICAgICAgJ05hbWUnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLm5hbWUpLFxuICAgIH07XG59XG4iXX0=