"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cluster = exports.ClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ehpc_generated_1 = require("./ehpc.generated");
Object.defineProperty(exports, "ClusterProperty", { enumerable: true, get: function () { return ehpc_generated_1.RosCluster; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::EHPC::Cluster`, which is used to create an Elastic High Performance Computing (E-HPC) cluster.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosCluster`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ehpc-cluster
 */
class Cluster extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosCluster = new ehpc_generated_1.RosCluster(this, id, {
            volumeProtocol: props.volumeProtocol,
            resourceGroupId: props.resourceGroupId,
            computeEnableHt: props.computeEnableHt,
            withoutElasticIp: props.withoutElasticIp,
            systemDiskType: props.systemDiskType,
            remoteVisEnable: props.remoteVisEnable,
            name: props.name,
            volumeId: props.volumeId,
            ramRoleName: props.ramRoleName,
            deployMode: props.deployMode,
            postInstallScript: props.postInstallScript,
            imageId: props.imageId,
            isComputeEss: props.isComputeEss,
            ecsOrderLoginInstanceType: props.ecsOrderLoginInstanceType,
            jobQueue: props.jobQueue,
            vSwitchId: props.vSwitchId,
            period: props.period,
            computeSpotStrategy: props.computeSpotStrategy,
            ecsOrderManagerInstanceType: props.ecsOrderManagerInstanceType,
            ehpcVersion: props.ehpcVersion,
            volumeMountpoint: props.volumeMountpoint,
            ecsOrderManagerCount: props.ecsOrderManagerCount,
            ecsOrderComputeInstanceType: props.ecsOrderComputeInstanceType,
            vpcId: props.vpcId,
            application: props.application,
            periodUnit: props.periodUnit,
            imageOwnerAlias: props.imageOwnerAlias,
            ecsOrderComputeCount: props.ecsOrderComputeCount,
            description: props.description,
            securityGroupName: props.securityGroupName,
            systemDiskSize: props.systemDiskSize,
            additionalVolumes: props.additionalVolumes,
            autoRenew: props.autoRenew,
            computeSpotPriceLimit: props.computeSpotPriceLimit,
            ramNodeTypes: props.ramNodeTypes,
            clientVersion: props.clientVersion,
            volumeType: props.volumeType,
            inputFileUrl: props.inputFileUrl,
            password: props.password,
            autoRenewPeriod: props.autoRenewPeriod,
            keyPairName: props.keyPairName,
            remoteDirectory: props.remoteDirectory,
            networkInterfaceTrafficMode: props.networkInterfaceTrafficMode,
            sccClusterId: props.sccClusterId,
            zoneId: props.zoneId,
            systemDiskLevel: props.systemDiskLevel,
            ecsOrderLoginCount: props.ecsOrderLoginCount,
            securityGroupId: props.securityGroupId,
            schedulerType: props.schedulerType,
            accountType: props.accountType,
            haEnable: props.haEnable,
            osTag: props.osTag,
            ecsChargeType: props.ecsChargeType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCluster;
        this.attrClusterId = rosCluster.attrClusterId;
        this.attrEcsInfo = rosCluster.attrEcsInfo;
        this.attrName = rosCluster.attrName;
        this.attrSecurityGroupId = rosCluster.attrSecurityGroupId;
    }
}
exports.Cluster = Cluster;
//# sourceMappingURL=data:application/json;base64,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