"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoScaleConfig = exports.AutoScaleConfigProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ehpc_generated_1 = require("./ehpc.generated");
Object.defineProperty(exports, "AutoScaleConfigProperty", { enumerable: true, get: function () { return ehpc_generated_1.RosAutoScaleConfig; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::EHPC::AutoScaleConfig`, which is used to configure the auto scaling settings of a cluster.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosAutoScaleConfig`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ehpc-autoscaleconfig
 */
class AutoScaleConfig extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosAutoScaleConfig = new ehpc_generated_1.RosAutoScaleConfig(this, id, {
            extraNodesGrowRatio: props.extraNodesGrowRatio,
            enableAutoGrow: props.enableAutoGrow,
            clusterId: props.clusterId,
            shrinkIdleTimes: props.shrinkIdleTimes,
            maxNodesInCluster: props.maxNodesInCluster === undefined || props.maxNodesInCluster === null ? 100 : props.maxNodesInCluster,
            enableAutoShrink: props.enableAutoShrink,
            growRatio: props.growRatio,
            growIntervalInMinutes: props.growIntervalInMinutes,
            growTimeoutInMinutes: props.growTimeoutInMinutes,
            imageId: props.imageId,
            shrinkIntervalInMinutes: props.shrinkIntervalInMinutes,
            spotPriceLimit: props.spotPriceLimit,
            queues: props.queues,
            excludeNodes: props.excludeNodes,
            spotStrategy: props.spotStrategy,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAutoScaleConfig;
        this.attrClusterId = rosAutoScaleConfig.attrClusterId;
    }
}
exports.AutoScaleConfig = AutoScaleConfig;
//# sourceMappingURL=data:application/json;base64,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