import typing

import httplib2  # type: ignore
import typing_extensions

import googleapiclient.discovery
import googleapiclient.http  # type: ignore

from .schemas import *

class GamesManagementResource(googleapiclient.discovery.Resource):
    class ScoresResource(googleapiclient.discovery.Resource):
        def reset(
            self, *, leaderboardId: str, **kwargs: typing.Any
        ) -> PlayerScoreResetResponseHttpRequest: ...
        def resetForAllPlayers(
            self, *, leaderboardId: str, **kwargs: typing.Any
        ) -> googleapiclient.http.HttpRequest: ...
        def resetAll(
            self, **kwargs: typing.Any
        ) -> PlayerScoreResetAllResponseHttpRequest: ...
        def resetAllForAllPlayers(
            self, **kwargs: typing.Any
        ) -> googleapiclient.http.HttpRequest: ...
        def resetMultipleForAllPlayers(
            self, *, body: ScoresResetMultipleForAllRequest = ..., **kwargs: typing.Any
        ) -> googleapiclient.http.HttpRequest: ...
    class PlayersResource(googleapiclient.discovery.Resource):
        def hide(
            self, *, applicationId: str, playerId: str, **kwargs: typing.Any
        ) -> googleapiclient.http.HttpRequest: ...
        def unhide(
            self, *, applicationId: str, playerId: str, **kwargs: typing.Any
        ) -> googleapiclient.http.HttpRequest: ...
    class EventsResource(googleapiclient.discovery.Resource):
        def resetAll(
            self, **kwargs: typing.Any
        ) -> googleapiclient.http.HttpRequest: ...
        def resetForAllPlayers(
            self, *, eventId: str, **kwargs: typing.Any
        ) -> googleapiclient.http.HttpRequest: ...
        def resetMultipleForAllPlayers(
            self, *, body: EventsResetMultipleForAllRequest = ..., **kwargs: typing.Any
        ) -> googleapiclient.http.HttpRequest: ...
        def resetAllForAllPlayers(
            self, **kwargs: typing.Any
        ) -> googleapiclient.http.HttpRequest: ...
        def reset(
            self, *, eventId: str, **kwargs: typing.Any
        ) -> googleapiclient.http.HttpRequest: ...
    class ApplicationsResource(googleapiclient.discovery.Resource):
        def listHidden(
            self,
            *,
            applicationId: str,
            maxResults: int = ...,
            pageToken: str = ...,
            **kwargs: typing.Any
        ) -> HiddenPlayerListHttpRequest: ...
    class AchievementsResource(googleapiclient.discovery.Resource):
        def resetAll(
            self, **kwargs: typing.Any
        ) -> AchievementResetAllResponseHttpRequest: ...
        def resetAllForAllPlayers(
            self, **kwargs: typing.Any
        ) -> googleapiclient.http.HttpRequest: ...
        def resetForAllPlayers(
            self, *, achievementId: str, **kwargs: typing.Any
        ) -> googleapiclient.http.HttpRequest: ...
        def reset(
            self, *, achievementId: str, **kwargs: typing.Any
        ) -> AchievementResetResponseHttpRequest: ...
        def resetMultipleForAllPlayers(
            self,
            *,
            body: AchievementResetMultipleForAllRequest = ...,
            **kwargs: typing.Any
        ) -> googleapiclient.http.HttpRequest: ...
    def scores(self) -> ScoresResource: ...
    def players(self) -> PlayersResource: ...
    def events(self) -> EventsResource: ...
    def applications(self) -> ApplicationsResource: ...
    def achievements(self) -> AchievementsResource: ...

class AchievementResetResponseHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> AchievementResetResponse: ...

class PlayerScoreResetAllResponseHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> PlayerScoreResetAllResponse: ...

class HiddenPlayerListHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> HiddenPlayerList: ...

class AchievementResetAllResponseHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> AchievementResetAllResponse: ...

class PlayerScoreResetResponseHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> PlayerScoreResetResponse: ...
