import numpy as np

def loc2bbox(src_bbox, loc):
    
    src_height = src_bbox[:, 2] - src_bbox[:, 0]
    src_width = src_bbox[:, 3] - src_bbox[:, 1]
    
    # center
    src_ctr_y = src_bbox[:, 0] + 0.5*src_height
    src_ctr_x = src_bbox[:, 1] + 0.5*src_width
    
    dy = loc[:, [0]] 
    dx = loc[:, [1]]
    dh = loc[:, [2]]
    dw = loc[:, [3]]
    
    ctr_y = dy * src_height[:, None] + src_ctr_y[:, None]
    ctr_x = dx * src_width[:, None] + src_ctr_x[:, None]
#     if len(dh) > 0:
#         print(np.min(dh), np.min(dw), np.max(dh), np.max(dw))
        
    h = np.exp(dh) * src_height[:, None]
    w = np.exp(dw) * src_width[:, None]
    
    dst_bbox = np.zeros(loc.shape, dtype=loc.dtype)
    dst_bbox[:, [0]] = ctr_y - 0.5 * h
    dst_bbox[:, [1]] = ctr_x - 0.5 * w
    dst_bbox[:, [2]] = ctr_y + 0.5 * h
    dst_bbox[:, [3]] = ctr_x + 0.5 * w
    
    return dst_bbox

def bbox2loc(src_bbox, dst_bbox):
    height = src_bbox[:, 2] - src_bbox[:, 0]
    width  = src_bbox[:, 3] - src_bbox[:, 1]

    center_y = src_bbox[:, 0] + 0.5*height
    center_x = src_bbox[:, 1] + 0.5*width

    base_height = dst_bbox[:, 2] - dst_bbox[:, 0]
    base_width = dst_bbox[:, 3] - dst_bbox[:, 1]
    base_center_y = dst_bbox[:, 0] + 0.5*base_height
    base_center_x = dst_bbox[:, 1] + 0.5*base_width

    eps = np.finfo(height.dtype).eps
    height = np.maximum(height, eps)
    width = np.maximum(width, eps)

    dy = (base_center_y - center_y)/height
    dx = (base_center_x - center_x)/width
    dh = np.log(base_height/height)
    dw = np.log(base_width/width)

    loc = np.vstack((dy, dx, dh, dw)).transpose()

    return loc

def bbox_iou(bbox_a, bbox_b):
    if bbox_a.shape[1] != 4 or bbox_b.shape[1] != 4:
        raise IndexError

    tl = np.maximum(bbox_a[:, None, :2], bbox_b[:, :2])
    br = np.minimum(bbox_a[:, None, 2:], bbox_b[:, 2:])

    area_i = np.prod(br-tl, axis=2) * (tl < br).all(axis=2)
    area_a = np.prod(bbox_a[:, 2:] - bbox_a[:, :2], axis=1)
    area_b = np.prod(bbox_b[:, 2:] - bbox_b[:, :2], axis=1)


    return area_i/(area_a[:, None] + area_b - area_i)
