"use strict";
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.RedshiftMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class RedshiftMetrics {
    static cpuUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'CPUUtilization',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static percentageDiskSpaceUsedAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'PercentageDiskSpaceUsed',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static databaseConnectionsAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'DatabaseConnections',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static healthStatusSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'HealthStatus',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static maintenanceModeSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'MaintenanceMode',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static networkReceiveThroughputSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'NetworkReceiveThroughput',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static networkTransmitThroughputSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'NetworkTransmitThroughput',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static queriesCompletedPerSecondSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'QueriesCompletedPerSecond',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static queryDurationAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'QueryDuration',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static queryRuntimeBreakdownSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'QueryRuntimeBreakdown',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static readIopsSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'ReadIOPS',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static readLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'ReadLatency',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static readThroughputSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'ReadThroughput',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static wlmQueriesCompletedPerSecondAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WLMQueriesCompletedPerSecond',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static wlmQueryDurationAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WLMQueryDuration',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static wlmQueueLengthSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WLMQueueLength',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static writeIopsSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WriteIOPS',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static writeLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WriteLatency',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static writeThroughputSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WriteThroughput',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
}
exports.RedshiftMetrics = RedshiftMetrics;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVkc2hpZnQtY2FubmVkLW1ldHJpY3MuZ2VuZXJhdGVkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicmVkc2hpZnQtY2FubmVkLW1ldHJpY3MuZ2VuZXJhdGVkLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSwrRUFBK0U7OztBQUUvRSw0QkFBNEIsQ0FBQyxpRUFBaUU7QUFFOUYsTUFBYSxlQUFlO0lBQ25CLE1BQU0sQ0FBQyxxQkFBcUIsQ0FBQyxVQUF5QztRQUMzRSxPQUFPO1lBQ0wsU0FBUyxFQUFFLGNBQWM7WUFDekIsVUFBVSxFQUFFLGdCQUFnQjtZQUM1QixhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsU0FBUztTQUNyQixDQUFDO0tBQ0g7SUFDTSxNQUFNLENBQUMsOEJBQThCLENBQUMsVUFBeUM7UUFDcEYsT0FBTztZQUNMLFNBQVMsRUFBRSxjQUFjO1lBQ3pCLFVBQVUsRUFBRSx5QkFBeUI7WUFDckMsYUFBYSxFQUFFLFVBQVU7WUFDekIsU0FBUyxFQUFFLFNBQVM7U0FDckIsQ0FBQztLQUNIO0lBQ00sTUFBTSxDQUFDLDBCQUEwQixDQUFDLFVBQXlDO1FBQ2hGLE9BQU87WUFDTCxTQUFTLEVBQUUsY0FBYztZQUN6QixVQUFVLEVBQUUscUJBQXFCO1lBQ2pDLGFBQWEsRUFBRSxVQUFVO1lBQ3pCLFNBQVMsRUFBRSxTQUFTO1NBQ3JCLENBQUM7S0FDSDtJQUNNLE1BQU0sQ0FBQyxlQUFlLENBQUMsVUFBeUM7UUFDckUsT0FBTztZQUNMLFNBQVMsRUFBRSxjQUFjO1lBQ3pCLFVBQVUsRUFBRSxjQUFjO1lBQzFCLGFBQWEsRUFBRSxVQUFVO1lBQ3pCLFNBQVMsRUFBRSxLQUFLO1NBQ2pCLENBQUM7S0FDSDtJQUNNLE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQyxVQUF5QztRQUN4RSxPQUFPO1lBQ0wsU0FBUyxFQUFFLGNBQWM7WUFDekIsVUFBVSxFQUFFLGlCQUFpQjtZQUM3QixhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDO0tBQ0g7SUFDTSxNQUFNLENBQUMsMkJBQTJCLENBQUMsVUFBeUM7UUFDakYsT0FBTztZQUNMLFNBQVMsRUFBRSxjQUFjO1lBQ3pCLFVBQVUsRUFBRSwwQkFBMEI7WUFDdEMsYUFBYSxFQUFFLFVBQVU7WUFDekIsU0FBUyxFQUFFLEtBQUs7U0FDakIsQ0FBQztLQUNIO0lBQ00sTUFBTSxDQUFDLDRCQUE0QixDQUFDLFVBQXlDO1FBQ2xGLE9BQU87WUFDTCxTQUFTLEVBQUUsY0FBYztZQUN6QixVQUFVLEVBQUUsMkJBQTJCO1lBQ3ZDLGFBQWEsRUFBRSxVQUFVO1lBQ3pCLFNBQVMsRUFBRSxLQUFLO1NBQ2pCLENBQUM7S0FDSDtJQUNNLE1BQU0sQ0FBQyw0QkFBNEIsQ0FBQyxVQUF5QztRQUNsRixPQUFPO1lBQ0wsU0FBUyxFQUFFLGNBQWM7WUFDekIsVUFBVSxFQUFFLDJCQUEyQjtZQUN2QyxhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDO0tBQ0g7SUFDTSxNQUFNLENBQUMsb0JBQW9CLENBQUMsVUFBeUM7UUFDMUUsT0FBTztZQUNMLFNBQVMsRUFBRSxjQUFjO1lBQ3pCLFVBQVUsRUFBRSxlQUFlO1lBQzNCLGFBQWEsRUFBRSxVQUFVO1lBQ3pCLFNBQVMsRUFBRSxTQUFTO1NBQ3JCLENBQUM7S0FDSDtJQUNNLE1BQU0sQ0FBQyx3QkFBd0IsQ0FBQyxVQUF5QztRQUM5RSxPQUFPO1lBQ0wsU0FBUyxFQUFFLGNBQWM7WUFDekIsVUFBVSxFQUFFLHVCQUF1QjtZQUNuQyxhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDO0tBQ0g7SUFDTSxNQUFNLENBQUMsV0FBVyxDQUFDLFVBQXlDO1FBQ2pFLE9BQU87WUFDTCxTQUFTLEVBQUUsY0FBYztZQUN6QixVQUFVLEVBQUUsVUFBVTtZQUN0QixhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDO0tBQ0g7SUFDTSxNQUFNLENBQUMsa0JBQWtCLENBQUMsVUFBeUM7UUFDeEUsT0FBTztZQUNMLFNBQVMsRUFBRSxjQUFjO1lBQ3pCLFVBQVUsRUFBRSxhQUFhO1lBQ3pCLGFBQWEsRUFBRSxVQUFVO1lBQ3pCLFNBQVMsRUFBRSxTQUFTO1NBQ3JCLENBQUM7S0FDSDtJQUNNLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQyxVQUF5QztRQUN2RSxPQUFPO1lBQ0wsU0FBUyxFQUFFLGNBQWM7WUFDekIsVUFBVSxFQUFFLGdCQUFnQjtZQUM1QixhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDO0tBQ0g7SUFDTSxNQUFNLENBQUMsbUNBQW1DLENBQUMsVUFBeUM7UUFDekYsT0FBTztZQUNMLFNBQVMsRUFBRSxjQUFjO1lBQ3pCLFVBQVUsRUFBRSw4QkFBOEI7WUFDMUMsYUFBYSxFQUFFLFVBQVU7WUFDekIsU0FBUyxFQUFFLFNBQVM7U0FDckIsQ0FBQztLQUNIO0lBQ00sTUFBTSxDQUFDLHVCQUF1QixDQUFDLFVBQXlDO1FBQzdFLE9BQU87WUFDTCxTQUFTLEVBQUUsY0FBYztZQUN6QixVQUFVLEVBQUUsa0JBQWtCO1lBQzlCLGFBQWEsRUFBRSxVQUFVO1lBQ3pCLFNBQVMsRUFBRSxTQUFTO1NBQ3JCLENBQUM7S0FDSDtJQUNNLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQyxVQUF5QztRQUN2RSxPQUFPO1lBQ0wsU0FBUyxFQUFFLGNBQWM7WUFDekIsVUFBVSxFQUFFLGdCQUFnQjtZQUM1QixhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDO0tBQ0g7SUFDTSxNQUFNLENBQUMsWUFBWSxDQUFDLFVBQXlDO1FBQ2xFLE9BQU87WUFDTCxTQUFTLEVBQUUsY0FBYztZQUN6QixVQUFVLEVBQUUsV0FBVztZQUN2QixhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDO0tBQ0g7SUFDTSxNQUFNLENBQUMsbUJBQW1CLENBQUMsVUFBeUM7UUFDekUsT0FBTztZQUNMLFNBQVMsRUFBRSxjQUFjO1lBQ3pCLFVBQVUsRUFBRSxjQUFjO1lBQzFCLGFBQWEsRUFBRSxVQUFVO1lBQ3pCLFNBQVMsRUFBRSxTQUFTO1NBQ3JCLENBQUM7S0FDSDtJQUNNLE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQyxVQUF5QztRQUN4RSxPQUFPO1lBQ0wsU0FBUyxFQUFFLGNBQWM7WUFDekIsVUFBVSxFQUFFLGlCQUFpQjtZQUM3QixhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDO0tBQ0g7Q0FDRjtBQXpKRCwwQ0F5SkMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxMi0yMDIxIEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4gKi8gLy8gVGhpcyBpcyBnZW5lcmF0ZWQgY29kZSAtIGxpbmUgbGVuZ3RocyBhcmUgZGlmZmljdWx0IHRvIGNvbnRyb2xcblxuZXhwb3J0IGNsYXNzIFJlZHNoaWZ0TWV0cmljcyB7XG4gIHB1YmxpYyBzdGF0aWMgY3B1VXRpbGl6YXRpb25BdmVyYWdlKGRpbWVuc2lvbnM6IHsgQ2x1c3RlcklkZW50aWZpZXI6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9SZWRzaGlmdCcsXG4gICAgICBtZXRyaWNOYW1lOiAnQ1BVVXRpbGl6YXRpb24nLFxuICAgICAgZGltZW5zaW9uc01hcDogZGltZW5zaW9ucyxcbiAgICAgIHN0YXRpc3RpYzogJ0F2ZXJhZ2UnLFxuICAgIH07XG4gIH1cbiAgcHVibGljIHN0YXRpYyBwZXJjZW50YWdlRGlza1NwYWNlVXNlZEF2ZXJhZ2UoZGltZW5zaW9uczogeyBDbHVzdGVySWRlbnRpZmllcjogc3RyaW5nIH0pIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL1JlZHNoaWZ0JyxcbiAgICAgIG1ldHJpY05hbWU6ICdQZXJjZW50YWdlRGlza1NwYWNlVXNlZCcsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnQXZlcmFnZScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIGRhdGFiYXNlQ29ubmVjdGlvbnNBdmVyYWdlKGRpbWVuc2lvbnM6IHsgQ2x1c3RlcklkZW50aWZpZXI6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9SZWRzaGlmdCcsXG4gICAgICBtZXRyaWNOYW1lOiAnRGF0YWJhc2VDb25uZWN0aW9ucycsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnQXZlcmFnZScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIGhlYWx0aFN0YXR1c1N1bShkaW1lbnNpb25zOiB7IENsdXN0ZXJJZGVudGlmaWVyOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvUmVkc2hpZnQnLFxuICAgICAgbWV0cmljTmFtZTogJ0hlYWx0aFN0YXR1cycsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICB9O1xuICB9XG4gIHB1YmxpYyBzdGF0aWMgbWFpbnRlbmFuY2VNb2RlU3VtKGRpbWVuc2lvbnM6IHsgQ2x1c3RlcklkZW50aWZpZXI6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9SZWRzaGlmdCcsXG4gICAgICBtZXRyaWNOYW1lOiAnTWFpbnRlbmFuY2VNb2RlJyxcbiAgICAgIGRpbWVuc2lvbnNNYXA6IGRpbWVuc2lvbnMsXG4gICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgIH07XG4gIH1cbiAgcHVibGljIHN0YXRpYyBuZXR3b3JrUmVjZWl2ZVRocm91Z2hwdXRTdW0oZGltZW5zaW9uczogeyBDbHVzdGVySWRlbnRpZmllcjogc3RyaW5nIH0pIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL1JlZHNoaWZ0JyxcbiAgICAgIG1ldHJpY05hbWU6ICdOZXR3b3JrUmVjZWl2ZVRocm91Z2hwdXQnLFxuICAgICAgZGltZW5zaW9uc01hcDogZGltZW5zaW9ucyxcbiAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIG5ldHdvcmtUcmFuc21pdFRocm91Z2hwdXRTdW0oZGltZW5zaW9uczogeyBDbHVzdGVySWRlbnRpZmllcjogc3RyaW5nIH0pIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL1JlZHNoaWZ0JyxcbiAgICAgIG1ldHJpY05hbWU6ICdOZXR3b3JrVHJhbnNtaXRUaHJvdWdocHV0JyxcbiAgICAgIGRpbWVuc2lvbnNNYXA6IGRpbWVuc2lvbnMsXG4gICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgIH07XG4gIH1cbiAgcHVibGljIHN0YXRpYyBxdWVyaWVzQ29tcGxldGVkUGVyU2Vjb25kU3VtKGRpbWVuc2lvbnM6IHsgQ2x1c3RlcklkZW50aWZpZXI6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9SZWRzaGlmdCcsXG4gICAgICBtZXRyaWNOYW1lOiAnUXVlcmllc0NvbXBsZXRlZFBlclNlY29uZCcsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICB9O1xuICB9XG4gIHB1YmxpYyBzdGF0aWMgcXVlcnlEdXJhdGlvbkF2ZXJhZ2UoZGltZW5zaW9uczogeyBDbHVzdGVySWRlbnRpZmllcjogc3RyaW5nIH0pIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL1JlZHNoaWZ0JyxcbiAgICAgIG1ldHJpY05hbWU6ICdRdWVyeUR1cmF0aW9uJyxcbiAgICAgIGRpbWVuc2lvbnNNYXA6IGRpbWVuc2lvbnMsXG4gICAgICBzdGF0aXN0aWM6ICdBdmVyYWdlJyxcbiAgICB9O1xuICB9XG4gIHB1YmxpYyBzdGF0aWMgcXVlcnlSdW50aW1lQnJlYWtkb3duU3VtKGRpbWVuc2lvbnM6IHsgQ2x1c3RlcklkZW50aWZpZXI6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9SZWRzaGlmdCcsXG4gICAgICBtZXRyaWNOYW1lOiAnUXVlcnlSdW50aW1lQnJlYWtkb3duJyxcbiAgICAgIGRpbWVuc2lvbnNNYXA6IGRpbWVuc2lvbnMsXG4gICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgIH07XG4gIH1cbiAgcHVibGljIHN0YXRpYyByZWFkSW9wc1N1bShkaW1lbnNpb25zOiB7IENsdXN0ZXJJZGVudGlmaWVyOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvUmVkc2hpZnQnLFxuICAgICAgbWV0cmljTmFtZTogJ1JlYWRJT1BTJyxcbiAgICAgIGRpbWVuc2lvbnNNYXA6IGRpbWVuc2lvbnMsXG4gICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgIH07XG4gIH1cbiAgcHVibGljIHN0YXRpYyByZWFkTGF0ZW5jeUF2ZXJhZ2UoZGltZW5zaW9uczogeyBDbHVzdGVySWRlbnRpZmllcjogc3RyaW5nIH0pIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL1JlZHNoaWZ0JyxcbiAgICAgIG1ldHJpY05hbWU6ICdSZWFkTGF0ZW5jeScsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnQXZlcmFnZScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIHJlYWRUaHJvdWdocHV0U3VtKGRpbWVuc2lvbnM6IHsgQ2x1c3RlcklkZW50aWZpZXI6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9SZWRzaGlmdCcsXG4gICAgICBtZXRyaWNOYW1lOiAnUmVhZFRocm91Z2hwdXQnLFxuICAgICAgZGltZW5zaW9uc01hcDogZGltZW5zaW9ucyxcbiAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIHdsbVF1ZXJpZXNDb21wbGV0ZWRQZXJTZWNvbmRBdmVyYWdlKGRpbWVuc2lvbnM6IHsgQ2x1c3RlcklkZW50aWZpZXI6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9SZWRzaGlmdCcsXG4gICAgICBtZXRyaWNOYW1lOiAnV0xNUXVlcmllc0NvbXBsZXRlZFBlclNlY29uZCcsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnQXZlcmFnZScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIHdsbVF1ZXJ5RHVyYXRpb25BdmVyYWdlKGRpbWVuc2lvbnM6IHsgQ2x1c3RlcklkZW50aWZpZXI6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9SZWRzaGlmdCcsXG4gICAgICBtZXRyaWNOYW1lOiAnV0xNUXVlcnlEdXJhdGlvbicsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnQXZlcmFnZScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIHdsbVF1ZXVlTGVuZ3RoU3VtKGRpbWVuc2lvbnM6IHsgQ2x1c3RlcklkZW50aWZpZXI6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9SZWRzaGlmdCcsXG4gICAgICBtZXRyaWNOYW1lOiAnV0xNUXVldWVMZW5ndGgnLFxuICAgICAgZGltZW5zaW9uc01hcDogZGltZW5zaW9ucyxcbiAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIHdyaXRlSW9wc1N1bShkaW1lbnNpb25zOiB7IENsdXN0ZXJJZGVudGlmaWVyOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvUmVkc2hpZnQnLFxuICAgICAgbWV0cmljTmFtZTogJ1dyaXRlSU9QUycsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICB9O1xuICB9XG4gIHB1YmxpYyBzdGF0aWMgd3JpdGVMYXRlbmN5QXZlcmFnZShkaW1lbnNpb25zOiB7IENsdXN0ZXJJZGVudGlmaWVyOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvUmVkc2hpZnQnLFxuICAgICAgbWV0cmljTmFtZTogJ1dyaXRlTGF0ZW5jeScsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnQXZlcmFnZScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIHdyaXRlVGhyb3VnaHB1dFN1bShkaW1lbnNpb25zOiB7IENsdXN0ZXJJZGVudGlmaWVyOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvUmVkc2hpZnQnLFxuICAgICAgbWV0cmljTmFtZTogJ1dyaXRlVGhyb3VnaHB1dCcsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICB9O1xuICB9XG59XG4iXX0=