# How to contribute

## Questions & comments
* Create a new GitHub issue listing your thoughts in an organised & motivated way. This makes it much easier to respond to, and to have meaningful discussion.

## Addition of features
* Make a pull request (PR). Include the relevant issues if it addresses any concerns or comments.

### PR submission guidelines

* Feel free to use the `README` to showcase new functionality, and to summarise useful information. This can be made into more full documentation downstream.
* Keep each PR focused. While it's more convenient, do not combine several unrelated fixes together. Create as many branches as needing to keep each PR focused.
* Label branches according to the [conventional commit style](https://www.conventionalcommits.org/en/v1.0.0/).
* Do not mix style changes/fixes with "functional" changes. It's very difficult to review such PRs and it most likely get rejected.
* Do not add/remove vertical whitespace. Preserve the original style of the file you edit as much as you can.

## Did you find a bug?

* Ensure the bug was not already reported by searching on GitHub under Issues.
* If you're unable to find an open issue addressing the problem, open a new one. Be sure to include a title and clear description, as much relevant information as possible, and a code sample or an executable test case demonstrating the expected behavior that is not occurring.
* Be sure to add the complete error messages.

#### Did you write a patch that fixes a bug?

* Open a new GitHub pull request with the patch.
* Ensure that your PR includes a test that fails without your patch, and pass with it.
* Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.
