# OneWorld

Welcome to OneWorld, a python mapping library intended to make plotting
maps with python easy and accessible to everyone. It combines the
mapping power of
[cartopy] with
the versatility of [leaflet] and
the aesthetics and input structure of  [seaborn]
to create both static and interactive maps.

|            |                 |
|:----------:|:---------------:|
![](docs/build/html/_static/tut_shp4.png)|![](docs/build/html/_static/welcome.png)

OneWorld accepts data inputs as sequences (lists or tuples) or 
[pandas] dataframes, much in the same
way as
[seaborn] does. If you have used seaborn
before, you already know how inputs work in OneWorld. 

### Installation

You can install OneWorld through `pip`, provided you satisfy the
requirements listed below:

```
$ pip install oneworld
```

You can find the source code in Bitbucket https://bitbucket.org/taguilar/oneworld

You'll need the following packages to use OneWorld :

* [matplotlib] 3.2.0 (or later)
* [pandas] 1.0.1 (or later)
* [seaborn] 0.10.0 (or later)
* [cartopy] 0.17.0 (or later)
* [jinja2] 2.11.1 (or later)

Note: Depending on the package manager
          that you use to install [cartopy], you may have to 
          manually install [fiona] (1.8.13 or later) as well.

Note 2: jinja no longer supports pytest and raises an error (although
        this behavior is expected to change in following versions). 
        If at runtime you encounter
        an error with 'PackageLoader', try downgrading your jinja version.

### Documentation

The full documentation packaged with OneWorld can be found
[here](docs/build/html/index.html). It can also be found
in Read the Docs at
[https://oneworld.readthedocs.io](https://oneworld.readthedocs.io).
It includes an introduction, tutorials and API reference.

### License

This software is distributed under a MIT license.

   [matplotlib]: https://matplotlib.org/3.2.0/index.html
   [cartopy]: https://scitools.org.uk/cartopy/docs/latest/
   [leaflet]: https://leafletjs.com
   [seaborn]: https://seaborn.pydata.org
   [pandas]: https://pandas.pydata.org/
   [jinja2]: https://jinja.palletsprojects.com/en/2.11.x/
   [fiona]: https://pypi.org/project/Fiona/

