# Generated by Django 2.2.1 on 2019-05-08 19:08

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Group',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='SubscriptionInfo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('browser', models.CharField(max_length=100)),
                ('endpoint', models.URLField(max_length=255)),
                ('auth', models.CharField(max_length=100)),
                ('p256dh', models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='PushMessage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('active', models.BooleanField(default=True)),
                ('send_on', models.DateTimeField(auto_now_add=True, null=True)),
                ('title', models.CharField(default='Message from MyApp.', max_length=200)),
                ('message', models.TextField(blank=True, null=True)),
                ('url', models.URLField(blank=True, null=True)),
                ('icon', models.URLField(blank=True, null=True)),
                ('sent', models.BooleanField(default=False)),
                ('send_to', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='PushInformation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='webpush_info', to='pwa_webpush.Group')),
                ('subscription', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='webpush_info', to='pwa_webpush.SubscriptionInfo')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='webpush_info', to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
