""" Settings required by django-app. """
import os

from django.conf import settings

# Path to the service worker implementation.  Default implementation is empty.
PWA_SERVICE_WORKER_PATH = getattr(
    settings,
    "PWA_SERVICE_WORKER_PATH",
    os.path.join(os.path.abspath(os.path.dirname(__file__)), "templates", "serviceworker.js"),
)
# App parameters to include in manifest.json and appropriate meta tags
PWA_APP_NAME = getattr(settings, "PWA_APP_NAME", "MyApp")
PWA_APP_DESCRIPTION = getattr(settings, "PWA_APP_DESCRIPTION", "My Progressive Web App")
PWA_APP_ROOT_URL = getattr(settings, "PWA_APP_ROOT_URL", "/")
PWA_APP_THEME_COLOR = getattr(settings, "PWA_APP_THEME_COLOR", "#000")
PWA_APP_BACKGROUND_COLOR = getattr(settings, "PWA_APP_BACKGROUND_COLOR", "#fff")
PWA_APP_DISPLAY = getattr(settings, "PWA_APP_DISPLAY", "standalone")
PWA_APP_SCOPE = getattr(settings, "PWA_APP_SCOPE", "/")
PWA_APP_ORIENTATION = getattr(settings, "PWA_APP_ORIENTATION", "any")
PWA_APP_START_URL = getattr(settings, "PWA_APP_START_URL", "/")
PWA_APP_FETCH_URL = getattr(settings, "PWA_APP_FETCH_URL", "/")
PWA_APP_ICONS = getattr(
    settings,
    "PWA_APP_ICONS",
    [
        {"src": "/static/images/icons/icon-72x72.png", "size": "72x72"},
        {"src": "/static/images/icons/icon-96x96.png", "size": "96x96"},
        {"src": "/static/images/icons/icon-128x128.png", "size": "128x128"},
        {"src": "/static/images/icons/icon-144x144.png", "size": "144x144"},
        {"src": "/static/images/icons/icon-152x152.png", "size": "152x152"},
        {"src": "/static/images/icons/icon-192x192.png", "size": "192x192"},
        {"src": "/static/images/icons/icon-384x384.png", "size": "384x384"},
        {"src": "/static/images/icons/icon-512x512.png", "size": "512x512"},
    ],
)
PWA_APP_SPLASH_SCREEN = getattr(
    settings,
    "PWA_APP_SPLASH_SCREEN",
    [
        {
            "src": "/static/images/icons/splash-640x1136.png",
            "media": "(device-width: 320px) and (device-height: 568px) and (-webkit-device-pixel-ratio: 2)",
        },
        {
            "src": "/static/images/icons/splash-750x1334.png",
            "media": "(device-width: 375px) and (device-height: 667px) and (-webkit-device-pixel-ratio: 2)",
        },
        {
            "src": "/static/images/icons/splash-1242x2208.png",
            "media": "(device-width: 621px) and (device-height: 1104px) and (-webkit-device-pixel-ratio: 3)",
        },
        {
            "src": "/static/images/icons/splash-1125x2436.png",
            "media": "(device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3)",
        },
        {
            "src": "/static/images/icons/splash-828x1792.png",
            "media": "(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 2)",
        },
        {
            "src": "/static/images/icons/splash-1242x2688.png",
            "media": "(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 3)",
        },
        {
            "src": "/static/images/icons/splash-1536x2048.png",
            "media": "(device-width: 768px) and (device-height: 1024px) and (-webkit-device-pixel-ratio: 2)",
        },
        {
            "src": "/static/images/icons/splash-1668x2224.png",
            "media": "(device-width: 834px) and (device-height: 1112px) and (-webkit-device-pixel-ratio: 2)",
        },
        {
            "src": "/static/images/icons/splash-1668x2388.png",
            "media": "(device-width: 834px) and (device-height: 1194px) and (-webkit-device-pixel-ratio: 2)",
        },
        {
            "src": "/static/images/icons/splash-2048x2732.png",
            "media": "(device-width: 1024px) and (device-height: 1366px) and (-webkit-device-pixel-ratio: 2)",
        },
    ],
)
PWA_APP_DIR = getattr(settings, "PWA_APP_DIR", "auto")
PWA_APP_LANG = getattr(settings, "PWA_APP_LANG", "en-US")
