"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cluster = exports.ClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ehpc_generated_1 = require("./ehpc.generated");
Object.defineProperty(exports, "ClusterProperty", { enumerable: true, get: function () { return ehpc_generated_1.RosCluster; } });
/**
 * A ROS resource type:  `ALIYUN::EHPC::Cluster`
 */
class Cluster extends ros.Resource {
    /**
     * Create a new `ALIYUN::EHPC::Cluster`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosCluster = new ehpc_generated_1.RosCluster(this, id, {
            volumeProtocol: props.volumeProtocol,
            resourceGroupId: props.resourceGroupId,
            computeEnableHt: props.computeEnableHt,
            withoutElasticIp: props.withoutElasticIp,
            systemDiskType: props.systemDiskType,
            remoteVisEnable: props.remoteVisEnable,
            name: props.name,
            volumeId: props.volumeId,
            deployMode: props.deployMode,
            postInstallScript: props.postInstallScript,
            imageId: props.imageId,
            isComputeEss: props.isComputeEss,
            ecsOrderLoginInstanceType: props.ecsOrderLoginInstanceType,
            jobQueue: props.jobQueue,
            vSwitchId: props.vSwitchId,
            period: props.period,
            computeSpotStrategy: props.computeSpotStrategy,
            ecsOrderManagerInstanceType: props.ecsOrderManagerInstanceType,
            ehpcVersion: props.ehpcVersion,
            volumeMountpoint: props.volumeMountpoint,
            ecsOrderManagerCount: props.ecsOrderManagerCount,
            ecsOrderComputeInstanceType: props.ecsOrderComputeInstanceType,
            application: props.application,
            periodUnit: props.periodUnit,
            imageOwnerAlias: props.imageOwnerAlias,
            ecsOrderComputeCount: props.ecsOrderComputeCount,
            description: props.description,
            securityGroupName: props.securityGroupName,
            systemDiskSize: props.systemDiskSize,
            additionalVolumes: props.additionalVolumes,
            autoRenew: props.autoRenew,
            computeSpotPriceLimit: props.computeSpotPriceLimit,
            clientVersion: props.clientVersion,
            volumeType: props.volumeType,
            inputFileUrl: props.inputFileUrl,
            password: props.password,
            autoRenewPeriod: props.autoRenewPeriod,
            keyPairName: props.keyPairName,
            remoteDirectory: props.remoteDirectory,
            sccClusterId: props.sccClusterId,
            zoneId: props.zoneId,
            systemDiskLevel: props.systemDiskLevel,
            ecsOrderLoginCount: props.ecsOrderLoginCount,
            securityGroupId: props.securityGroupId,
            schedulerType: props.schedulerType,
            accountType: props.accountType,
            haEnable: props.haEnable,
            osTag: props.osTag,
            ecsChargeType: props.ecsChargeType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCluster;
        this.attrClusterId = rosCluster.attrClusterId;
        this.attrEcsInfo = rosCluster.attrEcsInfo;
        this.attrName = rosCluster.attrName;
        this.attrSecurityGroupId = rosCluster.attrSecurityGroupId;
    }
}
exports.Cluster = Cluster;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2x1c3Rlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNsdXN0ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsOENBQThDO0FBQzlDLHFEQUE4QztBQUV2QixnR0FGZCwyQkFBVSxPQUVtQjtBQXdTdEM7O0dBRUc7QUFDSCxNQUFhLE9BQVEsU0FBUSxHQUFHLENBQUMsUUFBUTtJQTRCckM7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUFtQixFQUFFLG1DQUEyQyxJQUFJO1FBQzlHLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxVQUFVLEdBQUcsSUFBSSwyQkFBVSxDQUFDLElBQUksRUFBRSxFQUFFLEVBQUc7WUFDekMsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO1lBQ3BDLGVBQWUsRUFBRSxLQUFLLENBQUMsZUFBZTtZQUN0QyxlQUFlLEVBQUUsS0FBSyxDQUFDLGVBQWU7WUFDdEMsZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLGdCQUFnQjtZQUN4QyxjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7WUFDcEMsZUFBZSxFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ3RDLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSTtZQUNoQixRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7WUFDeEIsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVO1lBQzVCLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxpQkFBaUI7WUFDMUMsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPO1lBQ3RCLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtZQUNoQyx5QkFBeUIsRUFBRSxLQUFLLENBQUMseUJBQXlCO1lBQzFELFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUTtZQUN4QixTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7WUFDMUIsTUFBTSxFQUFFLEtBQUssQ0FBQyxNQUFNO1lBQ3BCLG1CQUFtQixFQUFFLEtBQUssQ0FBQyxtQkFBbUI7WUFDOUMsMkJBQTJCLEVBQUUsS0FBSyxDQUFDLDJCQUEyQjtZQUM5RCxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLGdCQUFnQjtZQUN4QyxvQkFBb0IsRUFBRSxLQUFLLENBQUMsb0JBQW9CO1lBQ2hELDJCQUEyQixFQUFFLEtBQUssQ0FBQywyQkFBMkI7WUFDOUQsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtZQUM1QixlQUFlLEVBQUUsS0FBSyxDQUFDLGVBQWU7WUFDdEMsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLG9CQUFvQjtZQUNoRCxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQjtZQUMxQyxjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7WUFDcEMsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQjtZQUMxQyxTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7WUFDMUIscUJBQXFCLEVBQUUsS0FBSyxDQUFDLHFCQUFxQjtZQUNsRCxhQUFhLEVBQUUsS0FBSyxDQUFDLGFBQWE7WUFDbEMsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVO1lBQzVCLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtZQUNoQyxRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7WUFDeEIsZUFBZSxFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ3RDLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztZQUM5QixlQUFlLEVBQUUsS0FBSyxDQUFDLGVBQWU7WUFDdEMsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO1lBQ2hDLE1BQU0sRUFBRSxLQUFLLENBQUMsTUFBTTtZQUNwQixlQUFlLEVBQUUsS0FBSyxDQUFDLGVBQWU7WUFDdEMsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQjtZQUM1QyxlQUFlLEVBQUUsS0FBSyxDQUFDLGVBQWU7WUFDdEMsYUFBYSxFQUFFLEtBQUssQ0FBQyxhQUFhO1lBQ2xDLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztZQUM5QixRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7WUFDeEIsS0FBSyxFQUFFLEtBQUssQ0FBQyxLQUFLO1lBQ2xCLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtTQUNyQyxFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLFVBQVUsQ0FBQztRQUMzQixJQUFJLENBQUMsYUFBYSxHQUFHLFVBQVUsQ0FBQyxhQUFhLENBQUM7UUFDOUMsSUFBSSxDQUFDLFdBQVcsR0FBRyxVQUFVLENBQUMsV0FBVyxDQUFDO1FBQzFDLElBQUksQ0FBQyxRQUFRLEdBQUcsVUFBVSxDQUFDLFFBQVEsQ0FBQztRQUNwQyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsVUFBVSxDQUFDLG1CQUFtQixDQUFDO0lBQzlELENBQUM7Q0FDSjtBQS9GRCwwQkErRkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyByb3MgZnJvbSAnQGFsaWNsb3VkL3Jvcy1jZGstY29yZSc7XG5pbXBvcnQgeyBSb3NDbHVzdGVyIH0gZnJvbSAnLi9laHBjLmdlbmVyYXRlZCc7XG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cbmV4cG9ydCB7IFJvc0NsdXN0ZXIgYXMgQ2x1c3RlclByb3BlcnR5IH07XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQUxJWVVOOjpFSFBDOjpDbHVzdGVyYFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENsdXN0ZXJQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBlY3NPcmRlckNvbXB1dGVDb3VudDogQ29tcHV0aW5nIG5vZGUgbnVtYmVyLCB3aGljaCByYW5nZXMgZnJvbTogMS05OS5cbiAgICAgKi9cbiAgICByZWFkb25seSBlY3NPcmRlckNvbXB1dGVDb3VudDogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZWNzT3JkZXJDb21wdXRlSW5zdGFuY2VUeXBlOiBDbHVzdGVyIGNvbXB1dGluZyBub2RlIGluc3RhbmNlIHNwZWNpZmljYXRpb25zLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVjc09yZGVyQ29tcHV0ZUluc3RhbmNlVHlwZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZWNzT3JkZXJMb2dpbkNvdW50OiBMb2dpbiBub2RlIG51bWJlciBjYW4gb25seSBiZSAxLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVjc09yZGVyTG9naW5Db3VudDogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZWNzT3JkZXJMb2dpbkluc3RhbmNlVHlwZTogTG9nIGNsdXN0ZXIgbm9kZSBpbnN0YW5jZSBzcGVjaWZpY2F0aW9ucy5cbiAgICAgKi9cbiAgICByZWFkb25seSBlY3NPcmRlckxvZ2luSW5zdGFuY2VUeXBlOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBlY3NPcmRlck1hbmFnZXJJbnN0YW5jZVR5cGU6IENsdXN0ZXIgY29udHJvbCBub2RlIGluc3RhbmNlIHNwZWNpZmljYXRpb25zLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVjc09yZGVyTWFuYWdlckluc3RhbmNlVHlwZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgbmFtZTogQ2x1c3RlciBuYW1lLiAyLTY0IGNoYXJhY3RlcnMgaW4gbGVuZ3RoLCBhbGxvd2luZyBvbmx5IGluY2x1ZGUgQ2hpbmVzZSwgbGV0dGVycywgbnVtYmVycywgZGFzaGVzICgtKSBhbmQgdW5kZXJzY29yZSAoXyksIG11c3QgYmVnaW4gd2l0aCBhIGxldHRlciBvciBDaGluZXNlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG5hbWU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IG9zVGFnOiBPcGVyYXRpbmcgc3lzdGVtIGltYWdlIHRhZy4gWW91IGNhbiBjYWxsIExpc3RJbWFnZXMgQVBJIHRvIHF1ZXJ5LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG9zVGFnOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB2U3dpdGNoSWQ6IFZQQyBpbiBzd2l0Y2ggSUQuIFByb2R1Y3RzIGN1cnJlbnRseSBvbmx5IHN1cHBvcnRzIFZQQyBuZXR3b3JrLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHZTd2l0Y2hJZDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgYWNjb3VudFR5cGU6IFRoZSBzZXJ2aWNlIHR5cGUgb2YgdGhlIGRvbWFpbiBhY2NvdW50LiBWYWxpZCB2YWx1ZXM6XG4gICAgICogbmlzXG4gICAgICogbGRhcFxuICAgICAqIERlZmF1bHQgdmFsdWU6IG5pc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IGFjY291bnRUeXBlPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgYWRkaXRpb25hbFZvbHVtZXM6XG4gICAgICovXG4gICAgcmVhZG9ubHkgYWRkaXRpb25hbFZvbHVtZXM/OiBBcnJheTxSb3NDbHVzdGVyLkFkZGl0aW9uYWxWb2x1bWVzUHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgYXBwbGljYXRpb246IEFwcGxpY2F0aW9uIHNvZnR3YXJlIHRhZyAoU29mdHdhcmVUYWcpIGxpc3QsIFlvdSBjYW4gY2FsbCBMaXN0U29mdHdhcmVzIEFQSSB0byBxdWVyeS5cbiAgICAgKi9cbiAgICByZWFkb25seSBhcHBsaWNhdGlvbj86IEFycmF5PFJvc0NsdXN0ZXIuQXBwbGljYXRpb25Qcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBhdXRvUmVuZXc6IHRydWU6IGF1dG9tYXRpYyByZW5ld2FsczsgZmFsc2U6IG5vIGF1dG9tYXRpYyByZW5ld2Fscy5cbiAgICAgKi9cbiAgICByZWFkb25seSBhdXRvUmVuZXc/OiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgYXV0b1JlbmV3UGVyaW9kOiBEdXJhdGlvbiBvZiBlYWNoIGF1dG9tYXRpYyByZW5ld2FscywgQXV0b1JlbmV3IHRha2UgZWZmZWN0IHdoZW4gQXV0b1JlbmV3IGlzIFRydWUuXG4gICAgICovXG4gICAgcmVhZG9ubHkgYXV0b1JlbmV3UGVyaW9kPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgY2xpZW50VmVyc2lvbjogVGhlIHZlcnNpb24gb2YgdGhlIEUtSFBDIGNsaWVudC4gQnkgZGVmYXVsdCwgdGhlIHBhcmFtZXRlciBpcyBzZXQgdG8gdGhlIGxhdGVzdCB2ZXJzaW9uIG51bWJlci5cbiAgICAgKiBZb3UgY2FuIGNhbGwgdGhlIExpc3RDdXJyZW50Q2xpZW50VmVyc2lvbiBvcGVyYXRpb24gdG8gcXVlcnkgdGhlIGN1cnJlbnQgdmVyc2lvbiBvZiB0aGUgRS1IUEMgY2xpZW50LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGNsaWVudFZlcnNpb24/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBjb21wdXRlRW5hYmxlSHQ6IFNwZWNpZmllcyB3aGV0aGVyIHRoZSBjb21wdXRlIG5vZGVzIHN1cHBvcnQgaHlwZXItdGhyZWFkaW5nLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogdHJ1ZTogSHlwZXItdGhyZWFkaW5nIGlzIHN1cHBvcnRlZC5cbiAgICAgKiBmYWxzZTogSHlwZXItdGhyZWFkaW5nIGlzIG5vdCBzdXBwb3J0ZWQuXG4gICAgICogRGVmYXVsdCB2YWx1ZTogdHJ1ZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGNvbXB1dGVFbmFibGVIdD86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBjb21wdXRlU3BvdFByaWNlTGltaXQ6IFNldCBhbiBleGFtcGxlIG9mIHRoZSBoaWdoZXN0IHByaWNlIHBlciBob3VyLCBhcmUgZmxvYXRpbmctcG9pbnQgdmFsdWVzLCBpbiB0aGUgcmFuZ2Ugb2YgdGhlIGN1cnJlbnQgcHJpY2UgcmFuZ2UuXG4gICAgICovXG4gICAgcmVhZG9ubHkgY29tcHV0ZVNwb3RQcmljZUxpbWl0Pzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgY29tcHV0ZVNwb3RTdHJhdGVneTogQ29tcHV0ZSBub2RlcyBiaWRkaW5nIHN0cmF0ZWd5LCB2YWx1ZSBOb1Nwb3QsIFNwb3RXaXRoUHJpY2VMaW1pdCBvciBTcG90QXNQcmljZUdvXG4gICAgICovXG4gICAgcmVhZG9ubHkgY29tcHV0ZVNwb3RTdHJhdGVneT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRlcGxveU1vZGU6IFRoZSBtb2RlIGluIHdoaWNoIHRoZSBjbHVzdGVyIGlzIGRlcGxveWVkLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogU3RhbmRhcmQ6IEFuIGFjY291bnQgbm9kZSwgYSBzY2hlZHVsaW5nIG5vZGUsIGEgbG9nb24gbm9kZSwgYW5kIG11bHRpcGxlIGNvbXB1dGUgbm9kZXMgYXJlIHNlcGFyYXRlbHkgZGVwbG95ZWQuXG4gICAgICogU2ltcGxlOiBBIG1hbmFnZW1lbnQgbm9kZSwgYSBsb2dvbiBub2RlLCBhbmQgbXVsdGlwbGUgY29tcHV0ZSBub2RlcyBhcmUgZGVwbG95ZWQuIFRoZSBtYW5hZ2VtZW50IG5vZGUgY29uc2lzdHMgb2YgYW4gYWNjb3VudCBub2RlIGFuZCBhIHNjaGVkdWxpbmcgbm9kZS4gVGhlIGxvZ29uIG5vZGUgYW5kIGNvbXB1dGUgbm9kZXMgYXJlIHNlcGFyYXRlbHkgZGVwbG95ZWQuXG4gICAgICogVGlueTogQSBtYW5hZ2VtZW50IG5vZGUgYW5kIG11bHRpcGxlIGNvbXB1dGUgbm9kZXMgYXJlIGRlcGxveWVkLiBUaGUgbWFuYWdlbWVudCBub2RlIGNvbnNpc3RzIG9mIGFuIGFjY291bnQgbm9kZSwgYSBzY2hlZHVsaW5nIG5vZGUsIGFuZCBhIGxvZ29uIG5vZGUuIFRoZSBjb21wdXRlIG5vZGVzIGFyZSBzZXBhcmF0ZWx5IGRlcGxveWVkLlxuICAgICAqIERlZmF1bHQgdmFsdWU6IFN0YW5kYXJkXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVwbG95TW9kZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRlc2NyaXB0aW9uOiBDbHVzdGVyIGRlc2NyaXB0aW9uLCAyIHRvIDEyOCBjaGFyYWN0ZXJzLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZWNzQ2hhcmdlVHlwZTogRUNTIGluc3RhbmNlIHBheW1lbnQgdHlwZSwgUG9zdFBhaWQ6IFBheS1Bcy1Zb3UtR28uUHJlUGFpZDogU3Vic2NyaXB0aW9uLklmIHlvdSBjaG9vc2UgUHJlUGFpZCwgYXV0b21hdGljIHJlbmV3YWwgd2lsbCBiZSBlbmFibGVkIGJ5IGRlZmF1bHQsIGFuZCBjbG9zZWQgd2hlbiBub2RlIGlzIHJlbGVhc2VkLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVjc0NoYXJnZVR5cGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBlY3NPcmRlck1hbmFnZXJDb3VudDogQ29udHJvbCBub2RlIG51bWJlciBjYW4gYmUgMSwgMlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVjc09yZGVyTWFuYWdlckNvdW50PzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZWhwY1ZlcnNpb246IFRoZSB2ZXJzaW9uIG9mIEUtSFBDLiBCeSBkZWZhdWx0LCB0aGUgcGFyYW1ldGVyIGlzIHNldCB0byB0aGUgbGF0ZXN0IHZlcnNpb24gbnVtYmVyLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVocGNWZXJzaW9uPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgaGFFbmFibGU6IFNwZWNpZmllcyB3aGV0aGVyIHRvIGVuYWJsZSB0aGUgaGlnaCBhdmFpbGFiaWxpdHkgZmVhdHVyZS4gVmFsaWQgdmFsdWVzOlxuICAgICAqIHRydWU6IGVuYWJsZXMgdGhlIGhpZ2ggYXZhaWxhYmlsaXR5IGZlYXR1cmVcbiAgICAgKiBmYWxzZTogZGlzYWJsZXMgdGhlIGhpZ2ggYXZhaWxhYmlsaXR5IGZlYXR1cmVcbiAgICAgKiBEZWZhdWx0IHZhbHVlOiBmYWxzZVxuICAgICAqIE5vdGUgSWYgaGlnaCBhdmFpbGFiaWxpdHkgaXMgZW5hYmxlZCwgcHJpbWFyeSBtYW5hZ2VtZW50IG5vZGVzIGFuZCBzZWNvbmRhcnkgbWFuYWdlbWVudCBub2RlcyBhcmUgdXNlZC5cbiAgICAgKi9cbiAgICByZWFkb25seSBoYUVuYWJsZT86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBpbWFnZUlkOiBNaXJyb3IgSWQsIGlmIEltYWdlVHlwZSBhIHN5c3RlbSwgYmFzZWQgb24gdGhlIGltYWdlIElEIGlzIGRldGVybWluZWQgb25seSBhY2NvcmRpbmcgT3NUYWc7IGlmIHNlbGYsIG90aGVycywgb3IgbWFya2V0cGxhY2UsIEltYWdlSWQgaXMgbWFuZGF0b3J5LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGltYWdlSWQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBpbWFnZU93bmVyQWxpYXM6IE1pcnJvciB0eXBlOiBzeXN0ZW0sIHNlbGYsIG90aGVycyBvciBtYXJrZXRwbGFjZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGltYWdlT3duZXJBbGlhcz86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGlucHV0RmlsZVVybDogVGhlIFVSTCBvZiB0aGUgam9iIGZpbGVzIHRoYXQgYXJlIHVwbG9hZGVkIHRvIGFuIE9iamVjdCBTdG9yYWdlIFNlcnZpY2UgKE9TUykgYnVja2V0LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGlucHV0RmlsZVVybD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGlzQ29tcHV0ZUVzczogU3BlY2lmaWVzIHdoZXRoZXIgdG8gZW5hYmxlIGF1dG8gc2NhbGluZy4gVmFsaWQgdmFsdWVzOlxuICAgICAqIHRydWU6IGVuYWJsZXMgYXV0byBzY2FsaW5nXG4gICAgICogZmFsc2U6IGRpc2FibGVzIGF1dG8gc2NhbGluZ1xuICAgICAqIERlZmF1bHQgdmFsdWU6IGZhbHNlXG4gICAgICovXG4gICAgcmVhZG9ubHkgaXNDb21wdXRlRXNzPzogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGpvYlF1ZXVlOiBcdFRoZSBxdWV1ZSB0byB3aGljaCB0aGUgY29tcHV0ZSBub2RlcyBhcmUgYWRkZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgam9iUXVldWU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBrZXlQYWlyTmFtZTogS2V5IHBhaXIgbmFtZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBrZXlQYWlyTmFtZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHBhc3N3b3JkOiBSb290IHBhc3N3b3JkIG9mIGp1bXAgc2VydmVyIChsb2dpbiBub2RlKS4gOCB0byAzMCBjaGFyYWN0ZXJzLCBtdXN0IGNvbnRhaW4gdGhyZWUgKHVwcGVyIGFuZCBsb3dlciBjYXNlIGxldHRlcnMsIG51bWJlcnMgYW5kIHNwZWNpYWwgc3ltYm9scykuICEgU3VwcG9ydHMgdGhlIGZvbGxvd2luZyBzcGVjaWFsIGNoYXJhY3RlcnMgOigpIGB+IEAgIyAkJSBeICYgKiAtICsgPSB8IHt9IFtdOjsgJzw+LCAvIEJlIHN1cmUgdG8gdXNlIHRoZSBIVFRQUyBwcm90b2NvbCBBUEkgY2FsbCB0byBhdm9pZCBwYXNzd29yZCBsZWFrcyB0aGF0IG1heSBvY2N1ci4/LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHBhc3N3b3JkPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcGVyaW9kOiBUaGUgcHVyY2hhc2Ugb2YgbG9uZyByZXNvdXJjZXMsIHVuaXRzOiB3ZWVrIC8gbW9udGggLyB5ZWFyLiBXaGVuIHRoZSB2YWx1ZSBvZiB0aGUgcGFyYW1ldGVyIEVjc0NoYXJnZVR5cGUgd2hlbiBQcmVQYWlkIHRha2UgZWZmZWN0IGFuZCBmb3IgdGhlIHNlbGVjdGVkIHZhbHVlIHdpbGwgYmUuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcGVyaW9kPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcGVyaW9kVW5pdDogVGhlIHB1cmNoYXNlIG9mIGxvbmctcmVzb3VyY2VzIHVuaXQuIEFsdGVybmF0aXZlbHkgdmFsdWUgV2VlayAvIE1vbnRoIC8geWVhci5cbiAgICAgKi9cbiAgICByZWFkb25seSBwZXJpb2RVbml0Pzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcG9zdEluc3RhbGxTY3JpcHQ6XG4gICAgICovXG4gICAgcmVhZG9ubHkgcG9zdEluc3RhbGxTY3JpcHQ/OiBBcnJheTxSb3NDbHVzdGVyLlBvc3RJbnN0YWxsU2NyaXB0UHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcmVtb3RlRGlyZWN0b3J5OiBNb3VudCBzaGFyZWQgc3RvcmFnZSByZW1vdGUgZGlyZWN0b3J5LiBUaGUgZmluYWwgcGF0aCB0byB0aGUgbW91bnQgcG9pbnQgYW5kIG1vdW50IHRoZSByZW1vdGUgZGlyZWN0b3J5IGNvbXBvc2l0aW9uOiBOYXNNb3VudHBvaW50OiAvIFJlbW90ZURpcmVjdG9yeVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlbW90ZURpcmVjdG9yeT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHJlbW90ZVZpc0VuYWJsZTogU3BlY2lmaWVzIHdoZXRoZXIgdG8gZW5hYmxlIFZpcnR1YWwgTmV0d29yayBDb21wdXRpbmcgKFZOQykuIFZhbGlkIHZhbHVlczpcbiAgICAgKiB0cnVlOiBlbmFibGVzIFZOQ1xuICAgICAqIGZhbHNlOiBkaXNhYmxlcyBWTkNcbiAgICAgKiBEZWZhdWx0IHZhbHVlOiBmYWxzZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlbW90ZVZpc0VuYWJsZT86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSByZXNvdXJjZUdyb3VwSWQ6IFRoZSBJRCBvZiB0aGUgcmVzb3VyY2UgZ3JvdXAuXG4gICAgICogWW91IGNhbiBjYWxsIHRoZSBMaXN0UmVzb3VyY2VHcm91cHMgb3BlcmF0aW9uIHRvIG9idGFpbiB0aGUgSUQgb2YgdGhlIHJlc291cmNlIGdyb3VwLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlc291cmNlR3JvdXBJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHNjY0NsdXN0ZXJJZDogV2hlbiBTQ0MgbW9kZWxzLCBpZiB5b3UgcGFzcyB0aGlzIGZpZWxkLCB0aGVuIHRoZSBzcGVjaWZpZWQgU2NjQ2x1c3RlciBjcmVhdGUgU2NjIGluc3RhbmNlLCBvdGhlcndpc2UgaXQgd2lsbCBjcmVhdGUgYW4gaW5zdGFuY2UgZm9yIHRoZSB1c2VyLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNjY0NsdXN0ZXJJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHNjaGVkdWxlclR5cGU6IFRoZSB0eXBlIG9mIHRoZSBzY2hlZHVsZXIuIFZhbGlkIHZhbHVlczpcbiAgICAgKiBwYnNcbiAgICAgKiBzbHVybVxuICAgICAqIG9wZW5ncmlkc2NoZWR1bGVyXG4gICAgICogZGVhZGxpbmVcbiAgICAgKiBEZWZhdWx0IHZhbHVlOiBwYnNcbiAgICAgKi9cbiAgICByZWFkb25seSBzY2hlZHVsZXJUeXBlPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgc2VjdXJpdHlHcm91cElkOiBTZWN1cml0eSBncm91cCBJRC5cbiAgICAgKi9cbiAgICByZWFkb25seSBzZWN1cml0eUdyb3VwSWQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBzZWN1cml0eUdyb3VwTmFtZTogSWYgeW91IGRvIG5vdCB1c2UgYW4gZXhpc3Rpbmcgc2VjdXJpdHkgZ3JvdXAgKFNlY3VyaXR5R3JvdXBJZCBpcyBlbXB0eSksIHRoZW4gdXNlIHRoaXMgbmFtZSB0byBjcmVhdGUgYSBuZXcgc2VjdXJpdHkgZ3JvdXAsIHRoZSBkZWZhdWx0IHBvbGljeS4gRm9ybWF0IFJlcXVpcmVtZW50cyBSZWZlcmVuY2UgRUNTIHNlY3VyaXR5IGdyb3VwIG5hbWUuXG4gICAgICovXG4gICAgcmVhZG9ubHkgc2VjdXJpdHlHcm91cE5hbWU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBzeXN0ZW1EaXNrTGV2ZWw6IFRoZSBwZXJmb3JtYW5jZSBsZXZlbCBvZiB0aGUgRVNTRCB0aGF0IGlzIGNyZWF0ZWQgYXMgdGhlIHN5c3RlbSBkaXNrLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogUEwwOiBBIHNpbmdsZSBFU1NEIGNhbiBkZWxpdmVyIHVwIHRvIDEwLDAwMCBpbnB1dC9vdXRwdXQgb3BlcmF0aW9ucyBwZXIgc2Vjb25kIChJT1BTKSBvZiByYW5kb20gcmVhZC93cml0ZS5cbiAgICAgKiBQTDE6IEEgc2luZ2xlIEVTU0QgY2FuIGRlbGl2ZXIgdXAgdG8gNTAsMDAwIElPUFMgb2YgcmFuZG9tIHJlYWQvd3JpdGUuXG4gICAgICogUEwyOiBBIHNpbmdsZSBFU1NEIGNhbiBkZWxpdmVyIHVwIHRvIDEwMCwwMDAgSU9QUyBvZiByYW5kb20gcmVhZC93cml0ZS5cbiAgICAgKiBQTDM6IEEgc2luZ2xlIEVTU0QgY2FuIGRlbGl2ZXIgdXAgdG8gMSwwMDAsMDAwIElPUFMgb2YgcmFuZG9tIHJlYWQvd3JpdGUuXG4gICAgICogRGVmYXVsdCB2YWx1ZTogUEwxXG4gICAgICovXG4gICAgcmVhZG9ubHkgc3lzdGVtRGlza0xldmVsPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgc3lzdGVtRGlza1NpemU6IFRoZSBzaXplIG9mIHRoZSBzeXN0ZW0gZGlzay4gVW5pdDogR0JcbiAgICAgKiBWYWxpZCB2YWx1ZXM6IDQwIHRvIDUwMFxuICAgICAqIERlZmF1bHQgdmFsdWU6IDQwXG4gICAgICovXG4gICAgcmVhZG9ubHkgc3lzdGVtRGlza1NpemU/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBzeXN0ZW1EaXNrVHlwZTogVGhlIHR5cGUgb2YgdGhlIHN5c3RlbSBkaXNrLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogY2xvdWRfZWZmaWNpZW5jeTogdWx0cmEgZGlzay5cbiAgICAgKiBjbG91ZF9zc2Q6IFNTRC5cbiAgICAgKiBjbG91ZF9lc3NkOiBFU1NELlxuICAgICAqIERlZmF1bHQgdmFsdWU6IGNsb3VkX3NzZFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHN5c3RlbURpc2tUeXBlPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgdm9sdW1lSWQ6IFRoZSBJRCBvZiB0aGUgZmlsZSBzeXN0ZW0uIElmIHlvdSBsZWF2ZSB0aGUgcGFyYW1ldGVyIGVtcHR5LCBhIFBlcmZvcm1hbmNlIE5BUyBmaWxlIHN5c3RlbSBpcyBjcmVhdGVkIGJ5IGRlZmF1bHQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdm9sdW1lSWQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB2b2x1bWVNb3VudHBvaW50OiBUaGUgbW91bnQgdGFyZ2V0IG9mIHRoZSBmaWxlIHN5c3RlbS4gVGFrZSBub3RlIG9mIHRoZSBmb2xsb3dpbmcgaW5mb3JtYXRpb246XG4gICAgICogSWYgeW91IGRvIG5vdCBzcGVjaWZ5IHRoZSBWb2x1bWVJZCBwYXJhbWV0ZXIsIHlvdSBjYW4gbGVhdmUgdGhlIFZvbHVtZU1vdW50cG9pbnQgcGFyYW1ldGVyIGVtcHR5LiBBIG1vdW50IHRhcmdldCBpcyBjcmVhdGVkIGJ5IGRlZmF1bHQuXG4gICAgICogSWYgeW91IHNwZWNpZnkgdGhlIFZvbHVtZUlkIHBhcmFtZXRlciwgdGhlIFZvbHVtZU1vdW50cG9pbnQgcGFyYW1ldGVyIGlzIHJlcXVpcmVkLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHZvbHVtZU1vdW50cG9pbnQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB2b2x1bWVQcm90b2NvbDogVGhlIHR5cGUgb2YgdGhlIHByb3RvY29sIHRoYXQgaXMgdXNlZCBieSB0aGUgZmlsZSBzeXN0ZW0uIFZhbGlkIHZhbHVlczpcbiAgICAgKiBuZnNcbiAgICAgKiBzbWJcbiAgICAgKiBEZWZhdWx0IHZhbHVlOiBuZnNcbiAgICAgKi9cbiAgICByZWFkb25seSB2b2x1bWVQcm90b2NvbD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHZvbHVtZVR5cGU6IFRoZSB0eXBlIG9mIHRoZSBzaGFyZWQgc3RvcmFnZS4gT25seSBBcHNhcmEgRmlsZSBTdG9yYWdlIG5hcyBmaWxlIHN5c3RlbXMgYXJlIHN1cHBvcnRlZC5cbiAgICAgKi9cbiAgICByZWFkb25seSB2b2x1bWVUeXBlPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgd2l0aG91dEVsYXN0aWNJcDogU3BlY2lmaWVzIHdoZXRoZXIgdGhlIGxvZ29uIG5vZGUgdXNlcyBhbiBlbGFzdGljIElQIGFkZHJlc3MgKEVJUCkuIERlZmF1bHQgdmFsdWU6IGZhbHNlXG4gICAgICovXG4gICAgcmVhZG9ubHkgd2l0aG91dEVsYXN0aWNJcD86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB6b25lSWQ6IEF2YWlsYWJsZSBhcmVhIElELlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHpvbmVJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcbn1cblxuLyoqXG4gKiBBIFJPUyByZXNvdXJjZSB0eXBlOiAgYEFMSVlVTjo6RUhQQzo6Q2x1c3RlcmBcbiAqL1xuZXhwb3J0IGNsYXNzIENsdXN0ZXIgZXh0ZW5kcyByb3MuUmVzb3VyY2Uge1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIHByb3BlcnRpZXMgb2YgdGhpcyBST1MgcmVzb3VyY2UsIHdoaWNoIHdpbGwgYmUgYXNzaWduZWQgdG8gUk9TIHJlc291cmNlLlxuICAgICAqL1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIENsdXN0ZXJJZDogQ2x1c3RlciBJZC5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckNsdXN0ZXJJZDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIEVjc0luZm86IEEgZGF0YSBzdHJ1Y3R1cmUgZGVzY3JpYmluZyB0aGUgbnVtYmVyIGFuZCBzcGVjaWZpY2F0aW9ucyBvZiBFQ1MgZm9yIHZhcmlvdXMgY29tcG9uZW50cyBvZiB0aGUgY2x1c3Rlci5cbllvdSB3aWxsIGdldCByZXN1bHRzIHNpbWlsYXIgdG8gdGhlIGZvbGxvd2luZzogRWNzSW5mbzoge1wiTWFuYWdlclwiOiB7XCJDb3VudFwiOiAyLCBcIkluc3RhbmNlVHlwZVwiOiBcImVjcy5uMS5sYXJnZVwifSwgXCJDb21wdXRlXCI6IHtcIkNvdW50XCI6IDgsIFwiSW5zdGFuY2VUeXBlXCI6IFwiZWNzLm4xLmxhcmdlXCJ9LCBcIkxvZ2luXCI6IHtcIkNvdW50XCI6IDEsIFwiSW5zdGFuY2VUeXBlXCI6IFwiZWNzLm4xLmxhcmdlXCJ9fVxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyRWNzSW5mbzogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIE5hbWU6IENsdXN0ZXIgbmFtZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ck5hbWU6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBTZWN1cml0eUdyb3VwSWQ6IFNlY3VyaXR5IGdyb3VwIElELlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyU2VjdXJpdHlHcm91cElkOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFMSVlVTjo6RUhQQzo6Q2x1c3RlcmAuXG4gICAgICpcbiAgICAgKiBQYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIFBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIFBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2x1c3RlclByb3BzLCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDpib29sZWFuID0gdHJ1ZSkge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgICAgIGNvbnN0IHJvc0NsdXN0ZXIgPSBuZXcgUm9zQ2x1c3Rlcih0aGlzLCBpZCwgIHtcbiAgICAgICAgICAgIHZvbHVtZVByb3RvY29sOiBwcm9wcy52b2x1bWVQcm90b2NvbCxcbiAgICAgICAgICAgIHJlc291cmNlR3JvdXBJZDogcHJvcHMucmVzb3VyY2VHcm91cElkLFxuICAgICAgICAgICAgY29tcHV0ZUVuYWJsZUh0OiBwcm9wcy5jb21wdXRlRW5hYmxlSHQsXG4gICAgICAgICAgICB3aXRob3V0RWxhc3RpY0lwOiBwcm9wcy53aXRob3V0RWxhc3RpY0lwLFxuICAgICAgICAgICAgc3lzdGVtRGlza1R5cGU6IHByb3BzLnN5c3RlbURpc2tUeXBlLFxuICAgICAgICAgICAgcmVtb3RlVmlzRW5hYmxlOiBwcm9wcy5yZW1vdGVWaXNFbmFibGUsXG4gICAgICAgICAgICBuYW1lOiBwcm9wcy5uYW1lLFxuICAgICAgICAgICAgdm9sdW1lSWQ6IHByb3BzLnZvbHVtZUlkLFxuICAgICAgICAgICAgZGVwbG95TW9kZTogcHJvcHMuZGVwbG95TW9kZSxcbiAgICAgICAgICAgIHBvc3RJbnN0YWxsU2NyaXB0OiBwcm9wcy5wb3N0SW5zdGFsbFNjcmlwdCxcbiAgICAgICAgICAgIGltYWdlSWQ6IHByb3BzLmltYWdlSWQsXG4gICAgICAgICAgICBpc0NvbXB1dGVFc3M6IHByb3BzLmlzQ29tcHV0ZUVzcyxcbiAgICAgICAgICAgIGVjc09yZGVyTG9naW5JbnN0YW5jZVR5cGU6IHByb3BzLmVjc09yZGVyTG9naW5JbnN0YW5jZVR5cGUsXG4gICAgICAgICAgICBqb2JRdWV1ZTogcHJvcHMuam9iUXVldWUsXG4gICAgICAgICAgICB2U3dpdGNoSWQ6IHByb3BzLnZTd2l0Y2hJZCxcbiAgICAgICAgICAgIHBlcmlvZDogcHJvcHMucGVyaW9kLFxuICAgICAgICAgICAgY29tcHV0ZVNwb3RTdHJhdGVneTogcHJvcHMuY29tcHV0ZVNwb3RTdHJhdGVneSxcbiAgICAgICAgICAgIGVjc09yZGVyTWFuYWdlckluc3RhbmNlVHlwZTogcHJvcHMuZWNzT3JkZXJNYW5hZ2VySW5zdGFuY2VUeXBlLFxuICAgICAgICAgICAgZWhwY1ZlcnNpb246IHByb3BzLmVocGNWZXJzaW9uLFxuICAgICAgICAgICAgdm9sdW1lTW91bnRwb2ludDogcHJvcHMudm9sdW1lTW91bnRwb2ludCxcbiAgICAgICAgICAgIGVjc09yZGVyTWFuYWdlckNvdW50OiBwcm9wcy5lY3NPcmRlck1hbmFnZXJDb3VudCxcbiAgICAgICAgICAgIGVjc09yZGVyQ29tcHV0ZUluc3RhbmNlVHlwZTogcHJvcHMuZWNzT3JkZXJDb21wdXRlSW5zdGFuY2VUeXBlLFxuICAgICAgICAgICAgYXBwbGljYXRpb246IHByb3BzLmFwcGxpY2F0aW9uLFxuICAgICAgICAgICAgcGVyaW9kVW5pdDogcHJvcHMucGVyaW9kVW5pdCxcbiAgICAgICAgICAgIGltYWdlT3duZXJBbGlhczogcHJvcHMuaW1hZ2VPd25lckFsaWFzLFxuICAgICAgICAgICAgZWNzT3JkZXJDb21wdXRlQ291bnQ6IHByb3BzLmVjc09yZGVyQ29tcHV0ZUNvdW50LFxuICAgICAgICAgICAgZGVzY3JpcHRpb246IHByb3BzLmRlc2NyaXB0aW9uLFxuICAgICAgICAgICAgc2VjdXJpdHlHcm91cE5hbWU6IHByb3BzLnNlY3VyaXR5R3JvdXBOYW1lLFxuICAgICAgICAgICAgc3lzdGVtRGlza1NpemU6IHByb3BzLnN5c3RlbURpc2tTaXplLFxuICAgICAgICAgICAgYWRkaXRpb25hbFZvbHVtZXM6IHByb3BzLmFkZGl0aW9uYWxWb2x1bWVzLFxuICAgICAgICAgICAgYXV0b1JlbmV3OiBwcm9wcy5hdXRvUmVuZXcsXG4gICAgICAgICAgICBjb21wdXRlU3BvdFByaWNlTGltaXQ6IHByb3BzLmNvbXB1dGVTcG90UHJpY2VMaW1pdCxcbiAgICAgICAgICAgIGNsaWVudFZlcnNpb246IHByb3BzLmNsaWVudFZlcnNpb24sXG4gICAgICAgICAgICB2b2x1bWVUeXBlOiBwcm9wcy52b2x1bWVUeXBlLFxuICAgICAgICAgICAgaW5wdXRGaWxlVXJsOiBwcm9wcy5pbnB1dEZpbGVVcmwsXG4gICAgICAgICAgICBwYXNzd29yZDogcHJvcHMucGFzc3dvcmQsXG4gICAgICAgICAgICBhdXRvUmVuZXdQZXJpb2Q6IHByb3BzLmF1dG9SZW5ld1BlcmlvZCxcbiAgICAgICAgICAgIGtleVBhaXJOYW1lOiBwcm9wcy5rZXlQYWlyTmFtZSxcbiAgICAgICAgICAgIHJlbW90ZURpcmVjdG9yeTogcHJvcHMucmVtb3RlRGlyZWN0b3J5LFxuICAgICAgICAgICAgc2NjQ2x1c3RlcklkOiBwcm9wcy5zY2NDbHVzdGVySWQsXG4gICAgICAgICAgICB6b25lSWQ6IHByb3BzLnpvbmVJZCxcbiAgICAgICAgICAgIHN5c3RlbURpc2tMZXZlbDogcHJvcHMuc3lzdGVtRGlza0xldmVsLFxuICAgICAgICAgICAgZWNzT3JkZXJMb2dpbkNvdW50OiBwcm9wcy5lY3NPcmRlckxvZ2luQ291bnQsXG4gICAgICAgICAgICBzZWN1cml0eUdyb3VwSWQ6IHByb3BzLnNlY3VyaXR5R3JvdXBJZCxcbiAgICAgICAgICAgIHNjaGVkdWxlclR5cGU6IHByb3BzLnNjaGVkdWxlclR5cGUsXG4gICAgICAgICAgICBhY2NvdW50VHlwZTogcHJvcHMuYWNjb3VudFR5cGUsXG4gICAgICAgICAgICBoYUVuYWJsZTogcHJvcHMuaGFFbmFibGUsXG4gICAgICAgICAgICBvc1RhZzogcHJvcHMub3NUYWcsXG4gICAgICAgICAgICBlY3NDaGFyZ2VUeXBlOiBwcm9wcy5lY3NDaGFyZ2VUeXBlLFxuICAgICAgICB9LCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCAmJiB0aGlzLnN0YWNrLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KTtcbiAgICAgICAgdGhpcy5yZXNvdXJjZSA9IHJvc0NsdXN0ZXI7XG4gICAgICAgIHRoaXMuYXR0ckNsdXN0ZXJJZCA9IHJvc0NsdXN0ZXIuYXR0ckNsdXN0ZXJJZDtcbiAgICAgICAgdGhpcy5hdHRyRWNzSW5mbyA9IHJvc0NsdXN0ZXIuYXR0ckVjc0luZm87XG4gICAgICAgIHRoaXMuYXR0ck5hbWUgPSByb3NDbHVzdGVyLmF0dHJOYW1lO1xuICAgICAgICB0aGlzLmF0dHJTZWN1cml0eUdyb3VwSWQgPSByb3NDbHVzdGVyLmF0dHJTZWN1cml0eUdyb3VwSWQ7XG4gICAgfVxufVxuIl19