/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.codepolicy.SASScope;
import com.sas.models.HyperlinkInterface;
import com.sas.util.LocalizableString;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.ValidateArg;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;

@SASScope
public class Hyperlink
implements HyperlinkInterface,
Serializable {
    private static final String SEPARATOR = " :: ";
    private static final long serialVersionUID = 7145264839777715784L;
    private String location;
    private transient LocalizableString label = new LocalizableString();

    public Hyperlink() {
        this.init();
    }

    public Hyperlink(String text, Locale locale) {
        this.init();
        this.parseString(text, locale);
    }

    public Hyperlink(String location, String label, Locale locale) {
        this.init();
        this.setLinkLocation(location);
        this.setLinkLabel(label, locale);
    }

    private void init() {
        this.label = new LocalizableString();
        this.location = null;
    }

    @Override
    public String getLinkLocation() {
        return this.location;
    }

    public void setLinkLocation(String location) {
        this.location = location;
    }

    @Override
    public String getLinkLabel(Locale locale) {
        return this.label.getText(locale);
    }

    @Override
    public LocalizableString getLinkLabel() {
        try {
            return (LocalizableString)this.label.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setLinkLabel(LocalizableString label) {
        ValidateArg.notNull(label, "label");
        this.label = label;
    }

    public void setLinkLabel(String label, Locale locale) {
        this.label.setText(label, locale);
    }

    public boolean equals(Object otherItem) {
        if (otherItem instanceof HyperlinkInterface) {
            HyperlinkInterface other = (HyperlinkInterface)otherItem;
            if (!Strings.equal(this.getLinkLocation(), other.getLinkLocation(), true, false)) {
                return false;
            }
            return Util.equal(this.getLinkLabel(), other.getLinkLabel());
        }
        return false;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(this.getLinkLocation());
        text.append(SEPARATOR);
        text.append(this.getLinkLabel());
        return text.toString();
    }

    public void parseString(String text, Locale locale) {
        if (text == null) {
            return;
        }
        String textTrimmed = text.trim();
        String[] parts = textTrimmed.split(SEPARATOR);
        if (parts.length < 1) {
            throw new IllegalStateException("Invalid hyperlink: " + text);
        }
        this.init();
        this.setLinkLocation(parts[0]);
        if (parts.length > 1) {
            this.setLinkLabel(parts[1], locale);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.location);
        String text = null;
        Locale locale = null;
        List<Locale> list = this.label.getLocales();
        if (!list.isEmpty()) {
            locale = list.get(0);
            text = this.label.getText(locale);
        }
        out.writeObject(locale);
        out.writeObject(text);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.init();
        in.defaultReadObject();
        this.location = (String)in.readObject();
        Locale locale = (Locale)in.readObject();
        String text = (String)in.readObject();
        if (null != locale && null != text) {
            this.label.setText(text, locale);
        }
    }
}

