/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.dmg.pmml.Array;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasDataType;
import org.dmg.pmml.HasDefaultValue;
import org.dmg.pmml.HasMapMissingTo;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.PMMLElements;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.Value;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.baseline.FieldValue;
import org.dmg.pmml.baseline.FieldValueCount;
import org.dmg.pmml.general_regression.BaselineStratum;
import org.dmg.pmml.general_regression.Category;
import org.dmg.pmml.general_regression.PMMLAttributes;
import org.dmg.pmml.general_regression.PPCell;
import org.dmg.pmml.naive_bayes.PairCounts;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.RichComplexArray;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.visitors.AbstractParser;
import org.jpmml.model.XPathUtil;

public class ValueParser
extends AbstractParser {
    private Mode mode = null;
    public static final ThreadLocal<Mode> MODE_PROVIDER = new ThreadLocal<Mode>(){

        @Override
        public Mode initialValue() {
            return Mode.LOOSE;
        }
    };

    public ValueParser() {
        this(MODE_PROVIDER.get());
    }

    public ValueParser(Mode mode) {
        this.setMode(mode);
    }

    public VisitorAction visit(BaselineStratum baselineStartum) {
        return super.visit(baselineStartum);
    }

    public VisitorAction visit(CategoricalPredictor categoricalPredictor) {
        FieldName name = categoricalPredictor.getField();
        if (name == null) {
            throw new MissingAttributeException((PMMLObject)categoricalPredictor, org.dmg.pmml.regression.PMMLAttributes.CATEGORICALPREDICTOR_FIELD);
        }
        this.parseValue(name, categoricalPredictor);
        return super.visit(categoricalPredictor);
    }

    public VisitorAction visit(Category category) {
        return super.visit(category);
    }

    public VisitorAction visit(Constant constant) {
        Object value;
        boolean missing = constant.isMissing();
        if (!missing && !ExpressionUtil.isEmptyContent(value = constant.getValue())) {
            DataType dataType = constant.getDataType();
            if (dataType == null) {
                dataType = TypeUtil.getConstantDataType(value);
            }
            value = this.parseOrCast(dataType, value);
            constant.setValue(value);
        }
        return super.visit(constant);
    }

    public VisitorAction visit(Discretize discretize) {
        this.parseExpressionValues(discretize);
        return super.visit(discretize);
    }

    public VisitorAction visit(DiscretizeBin discretizeBin) {
        Object binValue;
        Discretize discretize = (Discretize)this.getParent();
        DataType dataType = discretize.getDataType();
        if (dataType != null && (binValue = discretizeBin.getBinValue()) != null) {
            binValue = this.parseOrCast(dataType, binValue);
            discretizeBin.setBinValue(binValue);
        }
        return super.visit(discretizeBin);
    }

    public VisitorAction visit(FieldValue fieldValue) {
        return super.visit(fieldValue);
    }

    public VisitorAction visit(FieldValueCount fieldValueCount) {
        return super.visit(fieldValueCount);
    }

    public VisitorAction visit(MapValues mapValues) {
        this.parseExpressionValues(mapValues);
        return super.visit(mapValues);
    }

    public VisitorAction visit(MiningField miningField) {
        FieldName name = miningField.getName();
        if (name == null) {
            throw new MissingAttributeException((PMMLObject)miningField, org.dmg.pmml.PMMLAttributes.MININGFIELD_NAME);
        }
        DataType dataType = this.resolveDataType(name);
        if (dataType != null) {
            Object invalidValueReplacement;
            Object missingValueReplacement = miningField.getMissingValueReplacement();
            if (missingValueReplacement != null) {
                missingValueReplacement = this.safeParseOrCast(dataType, missingValueReplacement);
                miningField.setMissingValueReplacement(missingValueReplacement);
            }
            if ((invalidValueReplacement = miningField.getInvalidValueReplacement()) != null) {
                invalidValueReplacement = this.safeParseOrCast(dataType, invalidValueReplacement);
                miningField.setInvalidValueReplacement(invalidValueReplacement);
            }
        }
        return super.visit(miningField);
    }

    public VisitorAction visit(NormDiscrete normDiscrete) {
        FieldName name = normDiscrete.getField();
        if (name == null) {
            throw new MissingAttributeException((PMMLObject)normDiscrete, org.dmg.pmml.PMMLAttributes.NORMDISCRETE_FIELD);
        }
        this.parseValue(name, normDiscrete);
        return super.visit(normDiscrete);
    }

    public VisitorAction visit(PairCounts pairCounts) {
        return super.visit(pairCounts);
    }

    public VisitorAction visit(PPCell ppCell) {
        FieldName name = ppCell.getField();
        if (name == null) {
            throw new MissingAttributeException((PMMLObject)ppCell, PMMLAttributes.PPCELL_FIELD);
        }
        this.parseValue(name, ppCell);
        return super.visit(ppCell);
    }

    public VisitorAction visit(SimplePredicate simplePredicate) {
        FieldName name = simplePredicate.getField();
        if (name == null) {
            throw new MissingAttributeException((PMMLObject)simplePredicate, org.dmg.pmml.PMMLAttributes.SIMPLEPREDICATE_FIELD);
        }
        if (simplePredicate.hasValue()) {
            this.parseValue(name, simplePredicate);
        }
        return super.visit(simplePredicate);
    }

    public VisitorAction visit(SimpleSetPredicate simpleSetPredicate) {
        FieldName name = simpleSetPredicate.getField();
        if (name == null) {
            throw new MissingAttributeException((PMMLObject)simpleSetPredicate, org.dmg.pmml.PMMLAttributes.SIMPLESETPREDICATE_FIELD);
        }
        Array array = simpleSetPredicate.getArray();
        if (array == null) {
            throw new MissingElementException((PMMLObject)simpleSetPredicate, PMMLElements.SIMPLESETPREDICATE_ARRAY);
        }
        DataType dataType = this.resolveDataType(name);
        if (dataType != null) {
            Object value = array.getValue();
            Set<Object> values = value instanceof List ? new LinkedHashSet((List)value) : (value instanceof Set ? (Set)value : new LinkedHashSet(ArrayUtil.parse(array)));
            try {
                array = new RichComplexArray(dataType).setType(array.getType()).setValue(values);
            }
            catch (IllegalArgumentException | TypeCheckException e) {
                Mode mode = this.getMode();
                if (Mode.LOOSE.equals((Object)mode)) {
                    return super.visit(simpleSetPredicate);
                }
                throw e;
            }
            simpleSetPredicate.setArray(array);
        }
        return super.visit(simpleSetPredicate);
    }

    public VisitorAction visit(Value value) {
        Field field;
        DataType dataType;
        PMMLObject parent = this.getParent();
        Object simpleValue = value.getValue();
        if (simpleValue == null) {
            throw new MissingAttributeException((PMMLObject)value, org.dmg.pmml.PMMLAttributes.VALUE_VALUE);
        }
        if (parent instanceof Field && (dataType = (field = (Field)parent).getDataType()) != null) {
            simpleValue = this.safeParseOrCast(dataType, simpleValue);
            value.setValue(simpleValue);
        }
        return super.visit(value);
    }

    private <E extends PMMLObject> void parseValue(FieldName name, E hasValue) {
        Object value = ((HasValue)hasValue).getValue();
        if (value == null) {
            throw new MissingAttributeException(MissingAttributeException.formatMessage(XPathUtil.formatElement(hasValue.getClass()) + "@value"), hasValue);
        }
        DataType dataType = this.resolveDataType(name);
        if (dataType != null) {
            value = this.parseOrCast(dataType, value);
            ((HasValue)hasValue).setValue(value);
        }
    }

    private <E extends Expression & HasDefaultValue<E, Object>> void parseExpressionValues(E expression) {
        DataType dataType = ((HasDataType)expression).getDataType();
        if (dataType != null) {
            Object mapMissingTo;
            Object defaultValue = ((HasDefaultValue<E, Object>)expression).getDefaultValue();
            if (defaultValue != null) {
                defaultValue = this.parseOrCast(dataType, defaultValue);
                ((HasDefaultValue<E, Object>)expression).setDefaultValue(defaultValue);
            }
            if ((mapMissingTo = ((HasMapMissingTo)expression).getMapMissingTo()) != null) {
                mapMissingTo = this.parseOrCast(dataType, mapMissingTo);
                ((HasMapMissingTo)expression).setMapMissingTo(mapMissingTo);
            }
        }
    }

    private Object parseOrCast(DataType dataType, Object value) {
        try {
            return TypeUtil.parseOrCast(dataType, value);
        }
        catch (IllegalArgumentException | TypeCheckException e) {
            if (Mode.LOOSE.equals((Object)this.mode)) {
                return value;
            }
            throw e;
        }
    }

    private Object safeParseOrCast(DataType dataType, Object value) {
        try {
            return TypeUtil.parseOrCast(dataType, value);
        }
        catch (IllegalArgumentException | TypeCheckException e) {
            return value;
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = Objects.requireNonNull(mode);
    }

    public static enum Mode {
        LOOSE,
        STRICT;

    }
}

