/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.general_regression;

import com.google.common.base.Function;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.general_regression.BaseCumHazardTables;
import org.dmg.pmml.general_regression.BaselineCell;
import org.dmg.pmml.general_regression.BaselineStratum;
import org.dmg.pmml.general_regression.Categories;
import org.dmg.pmml.general_regression.Category;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.dmg.pmml.general_regression.PCell;
import org.dmg.pmml.general_regression.PMMLAttributes;
import org.dmg.pmml.general_regression.PMMLElements;
import org.dmg.pmml.general_regression.PPCell;
import org.dmg.pmml.general_regression.PPMatrix;
import org.dmg.pmml.general_regression.ParamMatrix;
import org.dmg.pmml.general_regression.Parameter;
import org.dmg.pmml.general_regression.ParameterCell;
import org.dmg.pmml.general_regression.ParameterList;
import org.dmg.pmml.general_regression.Predictor;
import org.dmg.pmml.general_regression.PredictorList;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidAttributeException;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.MapHolder;
import org.jpmml.evaluator.MatrixUtil;
import org.jpmml.evaluator.MisplacedAttributeException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.MissingValueException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.NumberUtil;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.UnsupportedElementException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.ValueUtil;
import org.jpmml.evaluator.general_regression.GeneralRegressionModelUtil;

public class GeneralRegressionModelEvaluator
extends ModelEvaluator<GeneralRegressionModel> {
    private transient BiMap<String, Parameter> parameterRegistry = null;
    private transient Map<Object, Map<String, Row>> ppMatrixMap = null;
    private transient Map<Object, List<PCell>> paramMatrixMap = null;
    private transient List<Object> targetCategories = null;
    private static final LoadingCache<GeneralRegressionModel, BiMap<String, Parameter>> parameterCache = CacheUtil.buildLoadingCache(new CacheLoader<GeneralRegressionModel, BiMap<String, Parameter>>(){

        public BiMap<String, Parameter> load(GeneralRegressionModel generalRegressionModel) {
            return ImmutableBiMap.copyOf((Map)GeneralRegressionModelEvaluator.parseParameterRegistry(generalRegressionModel.getParameterList()));
        }
    });
    private static final LoadingCache<GeneralRegressionModel, BiMap<FieldName, Predictor>> factorCache = CacheUtil.buildLoadingCache(new CacheLoader<GeneralRegressionModel, BiMap<FieldName, Predictor>>(){

        public BiMap<FieldName, Predictor> load(GeneralRegressionModel generalRegressionModel) {
            return ImmutableBiMap.copyOf((Map)GeneralRegressionModelEvaluator.parsePredictorRegistry((PredictorList)generalRegressionModel.getFactorList()));
        }
    });
    private static final LoadingCache<GeneralRegressionModel, BiMap<FieldName, Predictor>> covariateCache = CacheUtil.buildLoadingCache(new CacheLoader<GeneralRegressionModel, BiMap<FieldName, Predictor>>(){

        public BiMap<FieldName, Predictor> load(GeneralRegressionModel generalRegressionModel) {
            return ImmutableBiMap.copyOf((Map)GeneralRegressionModelEvaluator.parsePredictorRegistry((PredictorList)generalRegressionModel.getCovariateList()));
        }
    });
    private static final LoadingCache<GeneralRegressionModel, Map<Object, Map<String, Row>>> ppMatrixCache = CacheUtil.buildLoadingCache(new CacheLoader<GeneralRegressionModel, Map<Object, Map<String, Row>>>(){

        public Map<Object, Map<String, Row>> load(GeneralRegressionModel generalRegressionModel) {
            return Collections.unmodifiableMap(GeneralRegressionModelEvaluator.parsePPMatrix(generalRegressionModel));
        }
    });
    private static final LoadingCache<GeneralRegressionModel, Map<Object, List<PCell>>> paramMatrixCache = CacheUtil.buildLoadingCache(new CacheLoader<GeneralRegressionModel, Map<Object, List<PCell>>>(){

        public Map<Object, List<PCell>> load(GeneralRegressionModel generalRegressionModel) {
            return Collections.unmodifiableMap(GeneralRegressionModelEvaluator.parseParamMatrix(generalRegressionModel));
        }
    });

    public GeneralRegressionModelEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, GeneralRegressionModel.class));
    }

    public GeneralRegressionModelEvaluator(PMML pmml, GeneralRegressionModel generalRegressionModel) {
        super(pmml, generalRegressionModel);
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        if (modelType == null) {
            throw new MissingAttributeException((PMMLObject)generalRegressionModel, PMMLAttributes.GENERALREGRESSIONMODEL_MODELTYPE);
        }
        ParameterList parameterList = generalRegressionModel.getParameterList();
        if (parameterList == null) {
            throw new MissingElementException((PMMLObject)generalRegressionModel, PMMLElements.GENERALREGRESSIONMODEL_PARAMETERLIST);
        }
        PPMatrix ppMatrix = generalRegressionModel.getPPMatrix();
        if (ppMatrix == null) {
            throw new MissingElementException((PMMLObject)generalRegressionModel, PMMLElements.GENERALREGRESSIONMODEL_PPMATRIX);
        }
        ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
        if (paramMatrix == null) {
            throw new MissingElementException((PMMLObject)generalRegressionModel, PMMLElements.GENERALREGRESSIONMODEL_PARAMMATRIX);
        }
    }

    @Override
    public String getSummary() {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        switch (modelType) {
            case COX_REGRESSION: {
                return "Cox regression";
            }
        }
        return "General regression";
    }

    @Override
    protected <V extends Number> Map<FieldName, ?> evaluateRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        switch (modelType) {
            case COX_REGRESSION: {
                return this.evaluateCoxRegression(valueFactory, context);
            }
        }
        return this.evaluateGeneralRegression(valueFactory, context);
    }

    private <V extends Number> Map<FieldName, ?> evaluateCoxRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        Number maxTime;
        List baselineCells;
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        TargetField targetField = this.getTargetField();
        FieldName startTimeVariable = generalRegressionModel.getStartTimeVariable();
        FieldName endTimeVariable = generalRegressionModel.getEndTimeVariable();
        if (endTimeVariable == null) {
            throw new MissingAttributeException((PMMLObject)generalRegressionModel, PMMLAttributes.GENERALREGRESSIONMODEL_ENDTIMEVARIABLE);
        }
        BaseCumHazardTables baseCumHazardTables = generalRegressionModel.getBaseCumHazardTables();
        if (baseCumHazardTables == null) {
            throw new MissingElementException((PMMLObject)generalRegressionModel, PMMLElements.GENERALREGRESSIONMODEL_BASECUMHAZARDTABLES);
        }
        FieldName baselineStrataVariable = generalRegressionModel.getBaselineStrataVariable();
        if (baselineStrataVariable != null) {
            FieldValue value = GeneralRegressionModelEvaluator.getVariable(baselineStrataVariable, context);
            BaselineStratum baselineStratum = GeneralRegressionModelEvaluator.getBaselineStratum(baseCumHazardTables, value);
            if (baselineStratum == null) {
                return TargetUtil.evaluateRegressionDefault(valueFactory, targetField);
            }
            baselineCells = baselineStratum.getBaselineCells();
            if (baselineCells.isEmpty()) {
                throw new MissingElementException((PMMLObject)baselineStratum, PMMLElements.BASELINESTRATUM_BASELINECELLS);
            }
            maxTime = baselineStratum.getMaxTime();
            if (maxTime == null) {
                throw new MissingAttributeException((PMMLObject)baselineStratum, PMMLAttributes.BASELINESTRATUM_MAXTIME);
            }
        } else {
            baselineCells = baseCumHazardTables.getBaselineCells();
            if (baselineCells.isEmpty()) {
                throw new MissingElementException((PMMLObject)baseCumHazardTables, PMMLElements.BASECUMHAZARDTABLES_BASELINECELLS);
            }
            maxTime = baseCumHazardTables.getMaxTime();
            if (maxTime == null) {
                throw new MissingAttributeException((PMMLObject)baseCumHazardTables, PMMLAttributes.BASECUMHAZARDTABLES_MAXTIME);
            }
        }
        Comparator<BaselineCell> comparator = new Comparator<BaselineCell>(){

            @Override
            public int compare(BaselineCell left, BaselineCell right) {
                Number leftTime = this.getTime(left);
                Number rightTime = this.getTime(right);
                return NumberUtil.compare(leftTime, rightTime);
            }

            private Number getTime(BaselineCell baselineCell) {
                Number time = baselineCell.getTime();
                if (time == null) {
                    throw new MissingAttributeException((PMMLObject)baselineCell, PMMLAttributes.BASELINECELL_TIME);
                }
                return time;
            }
        };
        BaselineCell minBaselineCell = baselineCells.stream().min(comparator).get();
        Number minTime = minBaselineCell.getTime();
        FieldValue value = GeneralRegressionModelEvaluator.getVariable(endTimeVariable, context);
        if (value.compareToValue(maxTime) > 0) {
            return TargetUtil.evaluateRegressionDefault(valueFactory, targetField);
        }
        if (value.compareToValue(minTime) < 0) {
            Value<V> cumHazard = valueFactory.newValue(Numbers.DOUBLE_ZERO);
            return TargetUtil.evaluateRegression(targetField, cumHazard);
        }
        Number time = value.asNumber();
        BaselineCell maxTimeBaselineCell = baselineCells.stream().filter(baselineCell -> NumberUtil.compare(baselineCell.getTime(), time) <= 0).max(comparator).get();
        Number maxTimeCumHazard = maxTimeBaselineCell.getCumHazard();
        if (maxTimeCumHazard == null) {
            throw new MissingAttributeException((PMMLObject)maxTimeBaselineCell, PMMLAttributes.BASELINECELL_CUMHAZARD);
        }
        Value<V> r = this.computeDotProduct(valueFactory, context);
        Value<V> s = this.computeReferencePoint(valueFactory);
        if (r == null || s == null) {
            return TargetUtil.evaluateRegressionDefault(valueFactory, targetField);
        }
        Value<V> cumHazard = r.subtract(s).exp().multiply(maxTimeCumHazard);
        return TargetUtil.evaluateRegression(targetField, cumHazard);
    }

    private <V extends Number> Map<FieldName, ?> evaluateGeneralRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        TargetField targetField = this.getTargetField();
        Value<V> result = this.computeDotProduct(valueFactory, context);
        if (result == null) {
            return TargetUtil.evaluateRegressionDefault(valueFactory, targetField);
        }
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        switch (modelType) {
            case REGRESSION: 
            case GENERAL_LINEAR: {
                break;
            }
            case GENERALIZED_LINEAR: {
                result = this.computeLink(result, context);
                break;
            }
            case COX_REGRESSION: 
            case MULTINOMIAL_LOGISTIC: 
            case ORDINAL_MULTINOMIAL: {
                throw new InvalidAttributeException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
            }
        }
        return TargetUtil.evaluateRegression(targetField, result);
    }

    @Override
    protected <V extends Number> Map<FieldName, ? extends Classification<?, V>> evaluateClassification(ValueFactory<V> valueFactory, EvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        TargetField targetField = this.getTargetField();
        List<Object> targetCategories = this.getTargetCategories();
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        Map<Object, Map<String, Row>> ppMatrixMap = this.getPPMatrixMap();
        Map<Object, List<PCell>> paramMatrixMap = this.getParamMatrixMap();
        ValueMap<Object, Value<V>> values = new ValueMap<Object, Value<V>>(2 * targetCategories.size());
        Value<V> previousLinkValue = null;
        Value<V> previousCumulativeLinkValue = null;
        for (int i = 0; i < targetCategories.size(); ++i) {
            Value<V> value;
            Object targetCategory = targetCategories.get(i);
            if (i < targetCategories.size() - 1) {
                Iterable parameterCells;
                Map<String, Row> parameterPredictorRows;
                if (ppMatrixMap.isEmpty()) {
                    parameterPredictorRows = Collections.emptyMap();
                } else {
                    parameterPredictorRows = ppMatrixMap.get(targetCategory);
                    if (parameterPredictorRows == null) {
                        parameterPredictorRows = ppMatrixMap.get(null);
                    }
                    if (parameterPredictorRows == null) {
                        PPMatrix ppMatrix = generalRegressionModel.getPPMatrix();
                        throw new InvalidElementException((PMMLObject)ppMatrix);
                    }
                }
                switch (modelType) {
                    case GENERALIZED_LINEAR: 
                    case MULTINOMIAL_LOGISTIC: {
                        parameterCells = paramMatrixMap.get(targetCategory);
                        if (parameterCells == null && targetCategories.size() == 2) {
                            parameterCells = paramMatrixMap.get(null);
                        }
                        if (parameterCells != null) break;
                        ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
                        throw new InvalidElementException((PMMLObject)paramMatrix);
                    }
                    case ORDINAL_MULTINOMIAL: {
                        List<PCell> interceptCells = paramMatrixMap.get(targetCategory);
                        if (interceptCells == null || interceptCells.size() != 1) {
                            ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
                            throw new InvalidElementException((PMMLObject)paramMatrix);
                        }
                        parameterCells = paramMatrixMap.get(null);
                        if (parameterCells == null) {
                            ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
                            throw new InvalidElementException((PMMLObject)paramMatrix);
                        }
                        parameterCells = Iterables.concat(interceptCells, (Iterable)parameterCells);
                        break;
                    }
                    case COX_REGRESSION: 
                    case REGRESSION: 
                    case GENERAL_LINEAR: {
                        throw new InvalidAttributeException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
                    }
                    default: {
                        throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
                    }
                }
                if ((value = this.computeDotProduct(valueFactory, parameterCells, parameterPredictorRows, context)) == null) {
                    return TargetUtil.evaluateClassificationDefault(valueFactory, targetField);
                }
                switch (modelType) {
                    case GENERALIZED_LINEAR: {
                        value = this.computeLink(value, context);
                        break;
                    }
                    case MULTINOMIAL_LOGISTIC: {
                        value.exp();
                        break;
                    }
                    case ORDINAL_MULTINOMIAL: {
                        value = this.computeCumulativeLink(value, context);
                        break;
                    }
                    case COX_REGRESSION: 
                    case REGRESSION: 
                    case GENERAL_LINEAR: {
                        throw new InvalidAttributeException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
                    }
                    default: {
                        throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
                    }
                }
            } else {
                switch (modelType) {
                    case GENERALIZED_LINEAR: {
                        value = valueFactory.newValue(Numbers.DOUBLE_ONE);
                        if (previousLinkValue == null) break;
                        value.subtract(previousLinkValue);
                        break;
                    }
                    case MULTINOMIAL_LOGISTIC: {
                        value = valueFactory.newValue(Numbers.DOUBLE_ZERO).exp();
                        break;
                    }
                    case ORDINAL_MULTINOMIAL: {
                        value = valueFactory.newValue(Numbers.DOUBLE_ONE);
                        break;
                    }
                    case COX_REGRESSION: 
                    case REGRESSION: 
                    case GENERAL_LINEAR: {
                        throw new InvalidAttributeException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
                    }
                    default: {
                        throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
                    }
                }
            }
            switch (modelType) {
                case GENERALIZED_LINEAR: {
                    previousLinkValue = value;
                    break;
                }
                case MULTINOMIAL_LOGISTIC: {
                    break;
                }
                case ORDINAL_MULTINOMIAL: {
                    Value<V> cumulativeLinkValue = value.copy();
                    if (previousCumulativeLinkValue != null) {
                        value.subtract(previousCumulativeLinkValue);
                    }
                    previousCumulativeLinkValue = cumulativeLinkValue;
                    break;
                }
                case COX_REGRESSION: 
                case REGRESSION: 
                case GENERAL_LINEAR: {
                    throw new InvalidAttributeException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
                }
            }
            values.put(targetCategory, value);
        }
        switch (modelType) {
            case GENERALIZED_LINEAR: {
                break;
            }
            case MULTINOMIAL_LOGISTIC: {
                ValueUtil.normalizeSimpleMax(values);
                break;
            }
            case ORDINAL_MULTINOMIAL: {
                break;
            }
            case COX_REGRESSION: 
            case REGRESSION: 
            case GENERAL_LINEAR: {
                throw new InvalidAttributeException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
            }
        }
        Classification result = this.createClassification(values);
        return TargetUtil.evaluateClassification(targetField, result);
    }

    private <V extends Number> Value<V> computeDotProduct(ValueFactory<V> valueFactory, EvaluationContext context) {
        Map<String, Row> parameterPredictorRows;
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        Map<Object, Map<String, Row>> ppMatrixMap = this.getPPMatrixMap();
        if (ppMatrixMap.isEmpty()) {
            parameterPredictorRows = Collections.emptyMap();
        } else {
            parameterPredictorRows = ppMatrixMap.get(null);
            if (parameterPredictorRows == null) {
                PPMatrix ppMatrix = generalRegressionModel.getPPMatrix();
                throw new InvalidElementException((PMMLObject)ppMatrix);
            }
        }
        Map<Object, List<PCell>> paramMatrixMap = this.getParamMatrixMap();
        List<PCell> parameterCells = paramMatrixMap.get(null);
        if (paramMatrixMap.size() != 1 || parameterCells == null) {
            ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
            throw new InvalidElementException((PMMLObject)paramMatrix);
        }
        return this.computeDotProduct(valueFactory, parameterCells, parameterPredictorRows, context);
    }

    private <V extends Number> Value<V> computeDotProduct(ValueFactory<V> valueFactory, Iterable<PCell> parameterCells, Map<String, Row> parameterPredictorRows, EvaluationContext context) {
        Value<V> result = null;
        for (PCell parameterCell : parameterCells) {
            Row parameterPredictorRow;
            String parameterName = parameterCell.getParameterName();
            if (parameterName == null) {
                throw new MissingAttributeException((PMMLObject)parameterCell, PMMLAttributes.PCELL_PARAMETERNAME);
            }
            Number beta = parameterCell.getBeta();
            if (beta == null) {
                throw new MissingAttributeException((PMMLObject)parameterCell, PMMLAttributes.PCELL_BETA);
            }
            if (result == null) {
                result = valueFactory.newValue();
            }
            if ((parameterPredictorRow = parameterPredictorRows.get(parameterName)) != null) {
                Value<V> x = parameterPredictorRow.evaluate(valueFactory, context);
                if (x == null) {
                    return null;
                }
                result.add(beta, (Number)x.getValue());
                continue;
            }
            result.add(beta);
        }
        return result;
    }

    private <V extends Number> Value<V> computeReferencePoint(ValueFactory<V> valueFactory) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        BiMap<String, Parameter> parameters = this.getParameterRegistry();
        Map<Object, List<PCell>> paramMatrixMap = this.getParamMatrixMap();
        Iterable parameterCells = paramMatrixMap.get(null);
        if (paramMatrixMap.size() != 1 || parameterCells == null) {
            ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
            throw new InvalidElementException((PMMLObject)paramMatrix);
        }
        Value<V> result = null;
        for (PCell parameterCell : parameterCells) {
            Parameter parameter;
            String parameterName = parameterCell.getParameterName();
            if (parameterName == null) {
                throw new MissingAttributeException((PMMLObject)parameterCell, PMMLAttributes.PCELL_PARAMETERNAME);
            }
            Number beta = parameterCell.getBeta();
            if (beta == null) {
                throw new MissingAttributeException((PMMLObject)parameterCell, PMMLAttributes.PCELL_BETA);
            }
            if (result == null) {
                result = valueFactory.newValue();
            }
            if ((parameter = (Parameter)parameters.get((Object)parameterName)) != null) {
                result.add(beta, parameter.getReferencePoint());
                continue;
            }
            return null;
        }
        return result;
    }

    private <V extends Number> Value<V> computeLink(Value<V> value, EvaluationContext context) {
        Number offset;
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        GeneralRegressionModel.LinkFunction linkFunction = generalRegressionModel.getLinkFunction();
        if (linkFunction == null) {
            throw new MissingAttributeException((PMMLObject)generalRegressionModel, PMMLAttributes.GENERALREGRESSIONMODEL_LINKFUNCTION);
        }
        Number distParameter = generalRegressionModel.getDistParameter();
        Number linkParameter = generalRegressionModel.getLinkParameter();
        switch (linkFunction) {
            case CLOGLOG: 
            case IDENTITY: 
            case LOG: 
            case LOGC: 
            case LOGIT: 
            case LOGLOG: 
            case PROBIT: {
                if (distParameter != null) {
                    throw new MisplacedAttributeException((PMMLObject)generalRegressionModel, PMMLAttributes.GENERALREGRESSIONMODEL_DISTPARAMETER, distParameter);
                }
                if (linkParameter == null) break;
                throw new MisplacedAttributeException((PMMLObject)generalRegressionModel, PMMLAttributes.GENERALREGRESSIONMODEL_LINKPARAMETER, linkParameter);
            }
            case NEGBIN: {
                if (distParameter == null) {
                    throw new MissingAttributeException((PMMLObject)generalRegressionModel, PMMLAttributes.GENERALREGRESSIONMODEL_DISTPARAMETER);
                }
                if (linkParameter == null) break;
                throw new MisplacedAttributeException((PMMLObject)generalRegressionModel, PMMLAttributes.GENERALREGRESSIONMODEL_LINKPARAMETER, linkParameter);
            }
            case ODDSPOWER: 
            case POWER: {
                if (distParameter != null) {
                    throw new MisplacedAttributeException((PMMLObject)generalRegressionModel, PMMLAttributes.GENERALREGRESSIONMODEL_DISTPARAMETER, distParameter);
                }
                if (linkParameter != null) break;
                throw new MissingAttributeException((PMMLObject)generalRegressionModel, PMMLAttributes.GENERALREGRESSIONMODEL_LINKPARAMETER);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum<?>)linkFunction);
            }
        }
        if ((offset = GeneralRegressionModelEvaluator.getOffset(generalRegressionModel, context)) != null) {
            value.add(offset);
        }
        switch (linkFunction) {
            case CLOGLOG: 
            case IDENTITY: 
            case LOG: 
            case LOGC: 
            case LOGIT: 
            case LOGLOG: 
            case PROBIT: 
            case NEGBIN: 
            case ODDSPOWER: 
            case POWER: {
                GeneralRegressionModelUtil.computeLink(linkFunction, distParameter, linkParameter, value);
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum<?>)linkFunction);
            }
        }
        Integer trials = GeneralRegressionModelEvaluator.getTrials(generalRegressionModel, context);
        if (trials != null) {
            value.multiply(trials);
        }
        return value;
    }

    private <V extends Number> Value<V> computeCumulativeLink(Value<V> value, EvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        GeneralRegressionModel.CumulativeLinkFunction cumulativeLinkFunction = generalRegressionModel.getCumulativeLinkFunction();
        if (cumulativeLinkFunction == null) {
            throw new MissingAttributeException((PMMLObject)generalRegressionModel, PMMLAttributes.GENERALREGRESSIONMODEL_CUMULATIVELINKFUNCTION);
        }
        Number offset = GeneralRegressionModelEvaluator.getOffset(generalRegressionModel, context);
        if (offset != null) {
            value.add(offset);
        }
        switch (cumulativeLinkFunction) {
            case LOGIT: 
            case PROBIT: 
            case CLOGLOG: 
            case LOGLOG: 
            case CAUCHIT: {
                GeneralRegressionModelUtil.computeCumulativeLink(cumulativeLinkFunction, value);
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum<?>)cumulativeLinkFunction);
            }
        }
        return value;
    }

    public BiMap<String, Parameter> getParameterRegistry() {
        if (this.parameterRegistry == null) {
            this.parameterRegistry = this.getValue(parameterCache);
        }
        return this.parameterRegistry;
    }

    private Map<Object, Map<String, Row>> getPPMatrixMap() {
        if (this.ppMatrixMap == null) {
            this.ppMatrixMap = this.getValue(ppMatrixCache);
        }
        return this.ppMatrixMap;
    }

    private Map<Object, List<PCell>> getParamMatrixMap() {
        if (this.paramMatrixMap == null) {
            this.paramMatrixMap = this.getValue(paramMatrixCache);
        }
        return this.paramMatrixMap;
    }

    private List<Object> getTargetCategories() {
        if (this.targetCategories == null) {
            this.targetCategories = ImmutableList.copyOf(this.parseTargetCategories());
        }
        return this.targetCategories;
    }

    private List<Object> parseTargetCategories() {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        TargetField targetField = this.getTargetField();
        OpType opType = targetField.getOpType();
        switch (opType) {
            case CATEGORICAL: 
            case ORDINAL: {
                break;
            }
            default: {
                throw new InvalidElementException((PMMLObject)generalRegressionModel);
            }
        }
        List<Object> targetCategories = targetField.getCategories();
        if (targetCategories == null || targetCategories.size() < 2) {
            throw new InvalidElementException((PMMLObject)generalRegressionModel);
        }
        Object targetReferenceCategory = generalRegressionModel.getTargetReferenceCategory();
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        switch (modelType) {
            case GENERALIZED_LINEAR: 
            case MULTINOMIAL_LOGISTIC: {
                if (targetReferenceCategory != null) break;
                Map<Object, List<PCell>> paramMatrixMap = this.getParamMatrixMap();
                Set targetReferenceCategories = targetCategories.stream().filter(targetCategory -> !paramMatrixMap.containsKey(targetCategory)).collect(Collectors.toSet());
                if (targetReferenceCategories.size() != 1) {
                    ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
                    throw new InvalidElementException((PMMLObject)paramMatrix);
                }
                targetReferenceCategory = Iterables.getOnlyElement(targetReferenceCategories);
                break;
            }
            case ORDINAL_MULTINOMIAL: {
                break;
            }
            case COX_REGRESSION: 
            case REGRESSION: 
            case GENERAL_LINEAR: {
                throw new InvalidAttributeException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
            }
        }
        if (targetReferenceCategory != null && (targetCategories = new ArrayList<Object>(targetCategories)).remove(targetReferenceCategory)) {
            targetCategories.add(targetReferenceCategory);
        }
        return targetCategories;
    }

    private static Number getOffset(GeneralRegressionModel generalRegressionModel, EvaluationContext context) {
        FieldName offsetVariable = generalRegressionModel.getOffsetVariable();
        if (offsetVariable != null) {
            FieldValue value = GeneralRegressionModelEvaluator.getVariable(offsetVariable, context);
            return value.asNumber();
        }
        return generalRegressionModel.getOffsetValue();
    }

    private static Integer getTrials(GeneralRegressionModel generalRegressionModel, EvaluationContext context) {
        FieldName trialsVariable = generalRegressionModel.getTrialsVariable();
        if (trialsVariable != null) {
            FieldValue value = GeneralRegressionModelEvaluator.getVariable(trialsVariable, context);
            return value.asInteger();
        }
        return generalRegressionModel.getTrialsValue();
    }

    private static FieldValue getVariable(FieldName name, EvaluationContext context) {
        FieldValue value = context.evaluate(name);
        if (FieldValueUtil.isMissing(value)) {
            throw new MissingValueException(name);
        }
        return value;
    }

    private static BaselineStratum getBaselineStratum(BaseCumHazardTables baseCumHazardTables, FieldValue value) {
        if (baseCumHazardTables instanceof MapHolder) {
            MapHolder mapHolder = (MapHolder)baseCumHazardTables;
            return (BaselineStratum)mapHolder.get(value.getDataType(), value.getValue());
        }
        List baselineStrata = baseCumHazardTables.getBaselineStrata();
        for (BaselineStratum baselineStratum : baselineStrata) {
            Object category = baselineStratum.getValue();
            if (category == null) {
                throw new MissingAttributeException((PMMLObject)baselineStratum, PMMLAttributes.BASELINESTRATUM_VALUE);
            }
            if (!value.equalsValue(category)) continue;
            return baselineStratum;
        }
        return null;
    }

    private static BiMap<String, Parameter> parseParameterRegistry(ParameterList parameterList) {
        HashBiMap result = HashBiMap.create();
        if (!parameterList.hasParameters()) {
            return result;
        }
        List parameters = parameterList.getParameters();
        for (Parameter parameter : parameters) {
            result.put((Object)parameter.getName(), (Object)parameter);
        }
        return result;
    }

    private static BiMap<FieldName, Predictor> parsePredictorRegistry(PredictorList predictorList) {
        HashBiMap result = HashBiMap.create();
        if (predictorList == null || !predictorList.hasPredictors()) {
            return result;
        }
        List predictors = predictorList.getPredictors();
        for (Predictor predictor : predictors) {
            result.put((Object)predictor.getField(), (Object)predictor);
        }
        return result;
    }

    private static Map<Object, Map<String, Row>> parsePPMatrix(final GeneralRegressionModel generalRegressionModel) {
        Function<List<PPCell>, Row> function = new Function<List<PPCell>, Row>(){
            private BiMap<FieldName, Predictor> factors;
            private BiMap<FieldName, Predictor> covariates;
            {
                this.factors = (BiMap)CacheUtil.getValue(generalRegressionModel, factorCache);
                this.covariates = (BiMap)CacheUtil.getValue(generalRegressionModel, covariateCache);
            }

            public Row apply(List<PPCell> ppCells) {
                Row result = new Row();
                for (PPCell ppCell : ppCells) {
                    FieldName name = ppCell.getField();
                    if (name == null) {
                        throw new MissingAttributeException((PMMLObject)ppCell, PMMLAttributes.PPCELL_FIELD);
                    }
                    Predictor factor = (Predictor)this.factors.get((Object)name);
                    if (factor != null) {
                        result.addFactor(ppCell, factor);
                        continue;
                    }
                    Predictor covariate = (Predictor)this.covariates.get((Object)name);
                    if (covariate != null) {
                        result.addCovariate(ppCell);
                        continue;
                    }
                    throw new InvalidAttributeException((PMMLObject)ppCell, PMMLAttributes.PPCELL_FIELD, name);
                }
                return result;
            }
        };
        PPMatrix ppMatrix = generalRegressionModel.getPPMatrix();
        ListMultimap targetCategoryMap = GeneralRegressionModelEvaluator.groupByTargetCategory(ppMatrix.getPPCells());
        LinkedHashMap<Object, Map<String, Row>> result = new LinkedHashMap<Object, Map<String, Row>>();
        Set targetCategoryEntries = GeneralRegressionModelEvaluator.asMap(targetCategoryMap).entrySet();
        for (Map.Entry entry : targetCategoryEntries) {
            LinkedHashMap predictorMap = new LinkedHashMap();
            ListMultimap parameterNameMap = GeneralRegressionModelEvaluator.groupByParameterName((List)entry.getValue());
            Set parameterNameEntries = GeneralRegressionModelEvaluator.asMap(parameterNameMap).entrySet();
            for (Map.Entry entry2 : parameterNameEntries) {
                predictorMap.put(entry2.getKey(), function.apply(entry2.getValue()));
            }
            result.put(entry.getKey(), predictorMap);
        }
        return result;
    }

    private static Map<Object, List<PCell>> parseParamMatrix(GeneralRegressionModel generalRegressionModel) {
        ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
        ListMultimap targetCategoryCells = GeneralRegressionModelEvaluator.groupByTargetCategory(paramMatrix.getPCells());
        return GeneralRegressionModelEvaluator.asMap(targetCategoryCells);
    }

    private static <K, C extends ParameterCell> Map<K, List<C>> asMap(ListMultimap<K, C> multimap) {
        return multimap.asMap();
    }

    private static <C extends ParameterCell> ListMultimap<String, C> groupByParameterName(List<C> cells) {
        return GeneralRegressionModelEvaluator.groupCells(cells, ParameterCell::getParameterName);
    }

    private static <C extends ParameterCell> ListMultimap<Object, C> groupByTargetCategory(List<C> cells) {
        return GeneralRegressionModelEvaluator.groupCells(cells, ParameterCell::getTargetCategory);
    }

    private static <K, C extends ParameterCell> ListMultimap<K, C> groupCells(List<C> cells, Function<C, K> function) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (ParameterCell cell : cells) {
            result.put(function.apply((Object)cell), (Object)cell);
        }
        return result;
    }

    private static class Row {
        private List<FactorHandler> factorHandlers = new ArrayList<FactorHandler>();
        private List<CovariateHandler> covariateHandlers = new ArrayList<CovariateHandler>();

        private Row() {
        }

        public <V extends Number> Value<V> evaluate(ValueFactory<V> valueFactory, EvaluationContext context) {
            Value<V> result = valueFactory.newValue(Numbers.DOUBLE_ONE);
            List<FactorHandler> factorHandlers = this.getFactorHandlers();
            int max = factorHandlers.size();
            for (int i = 0; i < max; ++i) {
                FactorHandler factorHandler = factorHandlers.get(i);
                FieldValue value = context.evaluate(factorHandler.getField());
                if (FieldValueUtil.isMissing(value)) {
                    return null;
                }
                factorHandler.updateProduct(result, value);
            }
            if (result.isZero()) {
                return result;
            }
            List<CovariateHandler> covariateHandlers = this.getCovariateHandlers();
            int max2 = covariateHandlers.size();
            for (int i = 0; i < max2; ++i) {
                CovariateHandler covariateHandler = covariateHandlers.get(i);
                FieldValue value = context.evaluate(covariateHandler.getField());
                if (FieldValueUtil.isMissing(value)) {
                    return null;
                }
                covariateHandler.updateProduct(result, value);
            }
            return result;
        }

        public void addFactor(PPCell ppCell, Predictor predictor) {
            List<FactorHandler> factorHandlers = this.getFactorHandlers();
            Matrix matrix = predictor.getMatrix();
            if (matrix != null) {
                Categories categories = predictor.getCategories();
                if (categories == null) {
                    throw new UnsupportedElementException((PMMLObject)predictor);
                }
                Function<Category, Object> function = new Function<Category, Object>(){

                    public Object apply(Category category) {
                        Object value = category.getValue();
                        if (value == null) {
                            throw new MissingAttributeException((PMMLObject)category, PMMLAttributes.CATEGORY_VALUE);
                        }
                        return value;
                    }
                };
                List values = Lists.transform((List)categories.getCategories(), (Function)function);
                factorHandlers.add(new ContrastMatrixHandler(ppCell, matrix, values));
            } else {
                factorHandlers.add(new FactorHandler(ppCell));
            }
        }

        private void addCovariate(PPCell ppCell) {
            List<CovariateHandler> covariateHandlers = this.getCovariateHandlers();
            covariateHandlers.add(new CovariateHandler(ppCell));
        }

        public List<FactorHandler> getFactorHandlers() {
            return this.factorHandlers;
        }

        public List<CovariateHandler> getCovariateHandlers() {
            return this.covariateHandlers;
        }

        private class CovariateHandler
        extends PredictorHandler {
            private Number exponent;

            private CovariateHandler(PPCell ppCell) {
                super(ppCell);
                this.exponent = null;
                Object value = ppCell.getValue();
                if (value == null) {
                    throw new MissingAttributeException((PMMLObject)ppCell, PMMLAttributes.PPCELL_VALUE);
                }
                Number exponent = (Number)TypeUtil.parseOrCast(DataType.DOUBLE, value);
                if (exponent.doubleValue() == 1.0) {
                    exponent = null;
                }
                this.setExponent(exponent);
            }

            @Override
            public <V extends Number> Value<V> updateProduct(Value<V> product, FieldValue value) {
                Number exponent = this.getExponent();
                if (exponent != null) {
                    return product.multiply(value.asNumber(), exponent);
                }
                return product.multiply(value.asNumber());
            }

            public Number getExponent() {
                return this.exponent;
            }

            private void setExponent(Number exponent) {
                this.exponent = exponent;
            }
        }

        private class ContrastMatrixHandler
        extends FactorHandler {
            private Matrix matrix;
            private List<Object> categories;
            private List<FieldValue> parsedCategories;

            private ContrastMatrixHandler(PPCell ppCell, Matrix matrix, List<Object> categories) {
                super(ppCell);
                this.matrix = null;
                this.categories = null;
                this.parsedCategories = null;
                this.setMatrix(matrix);
                this.setCategories(categories);
            }

            @Override
            public <V extends Number> Value<V> updateProduct(Value<V> product, FieldValue value) {
                Matrix matrix = this.getMatrix();
                int row = this.getIndex(value);
                int column = this.getIndex(this.getCategory());
                if (row < 0 || column < 0) {
                    PPCell ppCell = this.getPPCell();
                    throw new InvalidElementException((PMMLObject)ppCell);
                }
                Number result = MatrixUtil.getElementAt(matrix, row + 1, column + 1);
                if (result == null) {
                    throw new InvalidElementException((PMMLObject)matrix);
                }
                return product.multiply(result);
            }

            public int getIndex(FieldValue value) {
                if (this.parsedCategories == null) {
                    this.parsedCategories = ImmutableList.copyOf(this.parseCategories(value));
                }
                return this.parsedCategories.indexOf(value);
            }

            public int getIndex(Object category) {
                List<Object> categories = this.getCategories();
                return categories.indexOf(category);
            }

            private List<FieldValue> parseCategories(TypeInfo typeInfo) {
                List<Object> categories = this.getCategories();
                return Lists.transform(categories, category -> FieldValueUtil.create(typeInfo, category));
            }

            public Matrix getMatrix() {
                return this.matrix;
            }

            private void setMatrix(Matrix matrix) {
                this.matrix = matrix;
            }

            public List<Object> getCategories() {
                return this.categories;
            }

            private void setCategories(List<Object> categories) {
                this.categories = categories;
            }
        }

        private class FactorHandler
        extends PredictorHandler {
            private Object category;

            private FactorHandler(PPCell ppCell) {
                super(ppCell);
                this.category = null;
                Object value = ppCell.getValue();
                if (value == null) {
                    throw new MissingAttributeException((PMMLObject)ppCell, PMMLAttributes.PPCELL_VALUE);
                }
                this.setCategory(value);
            }

            @Override
            public <V extends Number> Value<V> updateProduct(Value<V> product, FieldValue value) {
                PPCell ppCell = this.getPPCell();
                boolean equals = value.equals((HasValue<?>)ppCell);
                return equals ? product : product.multiply(Numbers.DOUBLE_ZERO);
            }

            public Object getCategory() {
                return this.category;
            }

            private void setCategory(Object category) {
                this.category = category;
            }
        }

        private abstract class PredictorHandler {
            private PPCell ppCell = null;

            private PredictorHandler(PPCell ppCell) {
                this.setPPCell(ppCell);
                FieldName name = ppCell.getField();
                if (name == null) {
                    throw new MissingAttributeException((PMMLObject)ppCell, PMMLAttributes.PPCELL_FIELD);
                }
            }

            public abstract <V extends Number> Value<V> updateProduct(Value<V> var1, FieldValue var2);

            public FieldName getField() {
                PPCell ppCell = this.getPPCell();
                return ppCell.getField();
            }

            public PPCell getPPCell() {
                return this.ppCell;
            }

            private void setPPCell(PPCell ppCell) {
                this.ppCell = ppCell;
            }
        }
    }
}

