/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.jpmml.evaluator.ModelEvaluatorBuilder;
import org.jpmml.evaluator.PMMLUtil;

public class ServiceLoadingModelEvaluatorBuilder
extends ModelEvaluatorBuilder {
    public ServiceLoadingModelEvaluatorBuilder loadService(URL url) throws IOException {
        try (URLClassLoader clazzLoader = new URLClassLoader(new URL[]{url});){
            ServiceLoadingModelEvaluatorBuilder serviceLoadingModelEvaluatorBuilder = this.loadService(clazzLoader, (String)null);
            return serviceLoadingModelEvaluatorBuilder;
        }
    }

    public ServiceLoadingModelEvaluatorBuilder loadService(URL url, String modelName) throws IOException {
        try (URLClassLoader clazzLoader = new URLClassLoader(new URL[]{url});){
            ServiceLoadingModelEvaluatorBuilder serviceLoadingModelEvaluatorBuilder = this.loadService(clazzLoader, modelName);
            return serviceLoadingModelEvaluatorBuilder;
        }
    }

    public ServiceLoadingModelEvaluatorBuilder loadService(ClassLoader clazzLoader, String modelName) {
        PMML pmml;
        Iterator<PMML> pmmlIt;
        try {
            ServiceLoader<PMML> serviceLoader = ServiceLoader.load(PMML.class, clazzLoader);
            pmmlIt = serviceLoader.iterator();
        }
        catch (ServiceConfigurationError sce) {
            throw new IllegalArgumentException("PMML service provider configuration is not loadable", sce);
        }
        if (pmmlIt.hasNext()) {
            try {
                pmml = pmmlIt.next();
            }
            catch (ServiceConfigurationError sce) {
                throw new IllegalArgumentException("PMML service provider is not instantiable", sce);
            }
            if (pmmlIt.hasNext()) {
                throw new IllegalArgumentException("Expected one PMML service provider, got more than one PMML service providers");
            }
        } else {
            throw new IllegalArgumentException("Expected one PMML service provider, got zero PMML service providers");
        }
        Model model = PMMLUtil.findModel(pmml, modelName);
        this.setPMML(pmml);
        this.setModel(model);
        return this;
    }
}

