/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.jpmml.evaluator.FloatVector;
import org.jpmml.evaluator.Value;

public class ComplexFloatVector
extends FloatVector {
    private int size = 0;
    private float[] values = null;

    public ComplexFloatVector(int capacity) {
        this.values = new float[capacity];
    }

    @Override
    public int size() {
        return this.size;
    }

    public FloatVector add(Number value) {
        return this.addInternal(value.floatValue());
    }

    public FloatVector add(Value<? extends Number> value) {
        return this.addInternal(value.floatValue());
    }

    public FloatVector add(Number coefficient, Number factor) {
        return this.addInternal(coefficient.floatValue() * factor.floatValue());
    }

    private FloatVector addInternal(float value) {
        this.values[this.size] = value;
        ++this.size;
        return this;
    }

    @Override
    public float floatValue(int index) {
        if (this.size <= index) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[index];
    }

    @Override
    public float floatSum() {
        float[] values = this.values;
        float result = 0.0f;
        int max = this.size;
        for (int i = 0; i < max; ++i) {
            result += values[i];
        }
        return result;
    }

    @Override
    public float floatMax() {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        float[] values = this.values;
        float result = values[0];
        int max = this.size;
        for (int i = 1; i < max; ++i) {
            result = Math.max(result, values[i]);
        }
        return result;
    }

    @Override
    public float floatMedian() {
        throw new UnsupportedOperationException();
    }
}

