# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['koinput']

package_data = \
{'': ['*']}

install_requires = \
['colorama>=0.4.4,<0.5.0']

setup_kwargs = {
    'name': 'koinput',
    'version': '0.3.0.2',
    'description': 'Maximal simplification of Input / Output for text programs.',
    'long_description': '.. image:: https://img.shields.io/pypi/v/koinput.svg\n    :target: https://pypi.org/project/koinput/\n    :alt: Latest Version\n\n.. image:: https://img.shields.io/pypi/pyversions/koinput.svg\n    :target: https://pypi.org/project/koinput/\n    :alt: Supported Python versions\n\n.. contents:: Table of contents\n    :depth: 3\n\nkoinput\n=======\n\nMaximal simplification of Input / Output for text programs.\n\n`PyPI for releases <https://pypi.org/project/koinput/>`_ |\n`Github for source <https://github.com/k0perX-X/koinput>`_\n\n\nWhat\'s new?\n===========\n\n0.3.0\n    * Added a new ProgressBar function. How to use see below.\n    * Added input_suggestion_style for Menu and Inputs.\n\nInstallation\n============\n\nRequirements `colorama <https://pypi.org/project/colorama/>`_ library.\n\n.. code-block:: bash\n\n    pip install koinput\n\nHow to use\n==========\n\nInputs\n------\n\nThe library has two types of inputs:\n\n* int_input\n* float_input\n\nThey have the same settings and differ only in the type of output.\n\nExplanation of input parameters\n+++++++++++++++++++++++++++++++\n\n.. code-block:: python\n\n    def int_input(input_suggestion="", greater=float(\'-inf\'), less=float(\'inf\'), console_style=colorama.Fore.RESET,\n                  error_message=\'Invalid number format.\\n\', error_message_style=colorama.Fore.RED,\n                  input_is_greater_than_less_error="The number is greater than acceptable.\\n",\n                  input_is_less_than_greater_error="The number is less than acceptable.\\n",\n                  input_is_less_error_style=None, input_is_greater_error_style=None,\n                  strictly_greater=True, strictly_less=True, input_suggestion_style=None):\n\n``input_suggestion=""``\n    Input suggestion that will be displayed when the function is run.\n\n``greater=float(\'-inf\'), less=float(\'inf\')``\n    The range in which the entered number should be included.\n\n``strictly_greater=True, strictly_less=True``\n    Controlling the mathematical strictly of comparisons.\n\n``console_style=colorama.Fore.RESET``\n    Sets the base display style for the terminal. I recommend using the colorama library for easier style customization. You can also use standard sequences (example: "\\x1b[39m").\n\n``error_message=\'Invalid number format.\\n\'``\n    Error message when converting input to number.\n\n``error_message_style=colorama.Fore.RED``\n    Error message style.\n\n``input_is_greater_than_less_error="The number is greater than acceptable.\\n"``\n    The message issued when the number is greater than allowed.\n\n``input_is_less_than_greater_error="The number is less than acceptable.\\n"``\n    The message issued when the number is less than allowed.\n\n``input_is_less_error_style=None, input_is_greater_error_style=None``\n    Out of range error styles.\n\n``input_suggestion_style=None``\n    Input suggestion style.\n\nUsage example\n+++++++++++++\n\n.. code-block:: python\n\n    def area_triangle(base, height):\n        return 0.5 * base * height\n\n    print(area_triangle(float_input(input_suggestion=\'Enter the base of the triangle: \'),\n                        float_input(input_suggestion=\'\xd0\x92\xd0\xb2\xd0\xb5\xd0\xb4\xd0\xb8\xd1\x82\xd0\xb5 \xd0\xb2\xd1\x8b\xd1\x81\xd0\xbe\xd1\x82\xd1\x83 \xd1\x82\xd1\x80\xd0\xb5\xd1\x83\xd0\xb3\xd0\xbe\xd0\xbb\xd1\x8c\xd0\xbd\xd0\xb8\xd0\xba\xd0\xb0: \')))\n\n.. code-block:: python\n\n    mas = [randint(0, 999) for i in range(int_input(input_suggestion="Enter the size of the array: "))]\n\nMenu\n----\n\nThe menu class is used to quickly create a text menu based on existing functions.\n\nFirst, you need to create an instance of the class:\n\n.. code-block:: python\n\n    from koinput import Menu\n\n    menu = Menu()\n\nThe next step is to add function calls to the menu. This can be done in 2 ways: using a decorator or a function.\n\n.. code-block:: python\n\n    @menu.add_to_menu_dec(\'Name shown in the menu\', *arguments_passed_to_the_function)\n    def z2(a, b, c):\n        def area_circle(radius):\n            return math.pi * radius ** 2\n        print(area_circle(float_input(input_suggestion=\'\xd0\x92\xd0\xb2\xd0\xb5\xd0\xb4\xd0\xb8\xd1\x82\xd0\xb5 \xd1\x80\xd0\xb0\xd0\xb4\xd0\xb8\xd1\x83\xd1\x81 \xd0\xba\xd1\x80\xd1\x83\xd0\xb3\xd0\xb0: \')))\n\n    OR\n\n    def z2(a, b, c):\n        def area_circle(radius):\n            return math.pi * radius ** 2\n        print(area_circle(float_input(input_suggestion=\'\xd0\x92\xd0\xb2\xd0\xb5\xd0\xb4\xd0\xb8\xd1\x82\xd0\xb5 \xd1\x80\xd0\xb0\xd0\xb4\xd0\xb8\xd1\x83\xd1\x81 \xd0\xba\xd1\x80\xd1\x83\xd0\xb3\xd0\xb0: \')))\n\n    menu.add_to_menu(\'Name shown in the menu\', z2, *arguments_passed_to_the_function)\n\nUse the show_menu command to display the menu.\n\n.. code-block:: python\n\n    menu.show_menu(title=None, title_style=None, number_of_leading_spaces_title=2, console_style=Fore.RESET,\n                   order_of_items=None, number_of_leading_spaces=4, separator=\' - \', items_style=None,\n                   input_suggestion=\'Select a menu item: \', enable_menu_item_exit=True, menu_item_exit=\'Exit\',\n                   exit_offer=\'Press Enter to exit...\', input_suggestion_style=None):\n\n``title=None``\n    Menu title.\n\n``title_style=None``\n    Sets the title display style. I recommend using the colorama library for easier style customization. You can also use standard sequences (example: "\\x1b[39m").\n\n``number_of_leading_spaces_title=2``\n    Sets the number of spaces before the menu title.\n\n``console_style=Fore.RESET``\n    Sets the base display style for the terminal. I recommend using the colorama library for easier style customization. You can also use standard sequences (example: "\\x1b[39m").\n\n``number_of_leading_spaces=4``\n    Sets the number of spaces before the menu items.\n\n``separator=\' - \'``\n    Separator between number and menu item name.\n\n``items_style=None``\n    Sets the menu item display style.\n\n``input_suggestion=\'Select a menu item: \'``\n    Input suggestion at the end of the menu.\n\n``input_suggestion_style=None``\n    Input suggestion style.\n\n``enable_menu_item_exit=True``\n    Enabling the menu item exit. If False, then after selecting one of the items the menu will close.\n\n``menu_item_exit=\'Exit\'``\n    The name of the menu exit item.\n\n``exit_offer=\'Press Enter to exit...\'``\n    Exit message.\n\n``order_of_items=None``\n    Custom order of issuing menu items. It is either a tuple of int or a tuple of str. A tuple of int must contain the ordinal numbers of items starting from 0 (the numbers are given in the order in which they are declared). The str tuple must contain the names of the menu items in the order they appear.\n\nChange the function of output from the menu.\n\nThis is necessary when you do not need an exit confirmation or when you exit you need to launch another menu or some function.\n\nExample with disabling the exit confirmation:\n\n.. code-block:: python\n\n    @menu.reassign_menu_exit()\n    def menu_exit(exit_offer):\n        def f():\n            pass\n    return f\n\nExample with displaying another menu:\n\n.. code-block:: python\n\n    @menu.reassign_menu_exit()\n    def menu_exit(exit_offer):\n        def f():\n            menu2.show_menu(title=\'MENU\', title_colour=colorama.Fore.BLUE, enable_menu_item_exit=False)\n        return f\n\nUsage example\n+++++++++++++\n\n.. code-block:: python\n\n    import math\n    from koinput import float_input, Menu\n    import colorama\n\n    menu = Menu()\n\n\n    @menu.add_to_menu_dec(\'\xd0\x9f\xd0\xbb\xd0\xbe\xd1\x89\xd0\xb0\xd0\xb4\xd1\x8c \xd1\x82\xd1\x80\xd0\xb5\xd1\x83\xd0\xb3\xd0\xbe\xd0\xbb\xd1\x8c\xd0\xbd\xd0\xb8\xd0\xba\xd0\xb0\')\n    def z1():\n        def area_triangle(base, height):\n            return 0.5 * base * height\n        print(area_triangle(float_input(input_suggestion=\'\xd0\x92\xd0\xb2\xd0\xb5\xd0\xb4\xd0\xb8\xd1\x82\xd0\xb5 \xd0\xbe\xd1\x81\xd0\xbd\xd0\xbe\xd0\xb2\xd0\xb0\xd0\xbd\xd0\xb8\xd0\xb5 \xd1\x82\xd1\x80\xd0\xb5\xd1\x83\xd0\xb3\xd0\xbe\xd0\xbb\xd1\x8c\xd0\xbd\xd0\xb8\xd0\xba\xd0\xb0: \'),\n                            float_input(input_suggestion=\'\xd0\x92\xd0\xb2\xd0\xb5\xd0\xb4\xd0\xb8\xd1\x82\xd0\xb5 \xd0\xb2\xd1\x8b\xd1\x81\xd0\xbe\xd1\x82\xd1\x83 \xd1\x82\xd1\x80\xd0\xb5\xd1\x83\xd0\xb3\xd0\xbe\xd0\xbb\xd1\x8c\xd0\xbd\xd0\xb8\xd0\xba\xd0\xb0: \')))\n\n\n    @menu.add_to_menu_dec(\'\xd0\x9f\xd0\xbb\xd0\xbe\xd1\x89\xd0\xb0\xd0\xb4\xd1\x8c \xd0\xba\xd1\x80\xd1\x83\xd0\xb3\xd0\xb0\')\n        def z2():\n            def area_circle(radius):\n                return math.pi * radius ** 2\n        print(area_circle(float_input(input_suggestion=\'\xd0\x92\xd0\xb2\xd0\xb5\xd0\xb4\xd0\xb8\xd1\x82\xd0\xb5 \xd1\x80\xd0\xb0\xd0\xb4\xd0\xb8\xd1\x83\xd1\x81 \xd0\xba\xd1\x80\xd1\x83\xd0\xb3\xd0\xb0: \')))\n\n\n    @menu.add_to_menu_dec(\'\xd0\xa0\xd0\xb0\xd1\x81\xd1\x81\xd1\x82\xd0\xbe\xd1\x8f\xd0\xbd\xd0\xb8\xd0\xb5 \xd0\xbe\xd1\x82 \xd1\x82\xd0\xbe\xd1\x87\xd0\xba\xd0\xb8 \xd0\xb4\xd0\xbe \xd1\x82\xd0\xbe\xd1\x87\xd0\xba\xd0\xb8\')\n    def z3():\n        def distance(x1, y1, x2, y2):\n            return math.sqrt((x2 - x1) ** 2 + (y2 - y1) ** 2)\n        print(distance(float_input(input_suggestion=\'\xd0\x92\xd0\xb2\xd0\xb5\xd0\xb4\xd0\xb8\xd1\x82\xd0\xb5 X \xd0\xbf\xd0\xb5\xd1\x80\xd0\xb2\xd0\xbe\xd0\xb9 \xd1\x82\xd0\xbe\xd1\x87\xd0\xba\xd0\xb8: \'),\n                       float_input(input_suggestion=\'\xd0\x92\xd0\xb2\xd0\xb5\xd0\xb4\xd0\xb8\xd1\x82\xd0\xb5 Y \xd0\xbf\xd0\xb5\xd1\x80\xd0\xb2\xd0\xbe\xd0\xb9 \xd1\x82\xd0\xbe\xd1\x87\xd0\xba\xd0\xb8: \'),\n                       float_input(input_suggestion=\'\xd0\x92\xd0\xb2\xd0\xb5\xd0\xb4\xd0\xb8\xd1\x82\xd0\xb5 X \xd0\xb2\xd1\x82\xd0\xbe\xd1\x80\xd0\xbe\xd0\xb9 \xd1\x82\xd0\xbe\xd1\x87\xd0\xba\xd0\xb8: \'),\n                       float_input(input_suggestion=\'\xd0\x92\xd0\xb2\xd0\xb5\xd0\xb4\xd0\xb8\xd1\x82\xd0\xb5 Y \xd0\xb2\xd1\x82\xd0\xbe\xd1\x80\xd0\xbe\xd0\xb9 \xd1\x82\xd0\xbe\xd1\x87\xd0\xba\xd0\xb8: \')))\n\n\n    def z4():\n        def capitalize_word(word):\n            return word[0].upper() + word[1::]\n\n        def capitalize_string(s):\n            ss = s.split()\n            for word in ss:\n                s = s.replace(word, capitalize_word(word))\n            return s\n        print(\'\xd0\x92\xd0\xb2\xd0\xb5\xd0\xb4\xd0\xb8\xd1\x82\xd0\xb5 \xd1\x81\xd1\x82\xd1\x80\xd0\xbe\xd0\xba\xd1\x83 \xd0\xb4\xd0\xbb\xd1\x8f \xd0\xb8\xd0\xb7\xd0\xbc\xd0\xb5\xd0\xbd\xd0\xb5\xd0\xbd\xd0\xb8\xd1\x8f: \')\n        print(capitalize_string(input()))\n\n\n    @menu.reassign_menu_exit()\n    def menu_exit(exit_offer):\n        def f():\n            pass\n        return f\n\n\n    def main():\n        menu.add_to_menu(\'Capitalize\', z4)\n        menu.show_menu(title=\'\xd0\x9c\xd0\x95\xd0\x9d\xd0\xae\', title_colour=colorama.Fore.BLUE)\n\n\n    if __name__ == \'__main__\':\n        main()\n\nProgressBar\n-----------\n\nThe progress bar is designed to show the progress of long-running tasks.\n\nFirst, we import the ProgressBar class.\n\n.. code-block:: python\n\n    from koinput import ProgressBar\n\nThe class has properties:\n\n``ProgressBar.max_value = 100``\n    The maximum value from which the percentage is calculated or indicated in the counter mode.\n\n``ProgressBar.counter = False``\n    Enables counter mode. It displays not percentages, but value from max_value.\n\n``ProgressBar.string = "[########################################] @@@%"``\n    Indicates the view of the Progress Bar.\n\n``ProgressBar.progressbar_symbol = "#"``\n    A symbol indicating the placement of a progress bar.\n\n``ProgressBar.percent_symbol = "@"``\n    The symbol indicating the placement of percent (as well as the number of decimal places) or in counter mode only indicates its location.\n\n``ProgressBar.counter_separator = \'/\'``\n    A character or string to be displayed between value and max_value in counter mode.\n\nTo display the progress bar, use the show function.\n\n.. code-block:: python\n\n    ProgressBar.show(value, text=None)\n\n``value``\n    The current value of the progress bar.\n\n``text=None``\n    Comment for the current operation.\n\nUsage example\n+++++++++++++\n\n.. code-block:: python\n\n    from koinput import ProgressBar\n    from time import sleep\n\n    ProgressBar.max_value = 123\n    for i in range(124):\n        ProgressBar.show(i)\n        sleep(0.07)\n\n    ProgressBar.max_value = 10\n    ProgressBar.counter = True\n    ProgressBar.string = "|&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&| {*}"\n    ProgressBar.progressbar_symbol = "&"\n    ProgressBar.percent_symbol = "*"\n    ProgressBar.counter_separator = \' element of \'\n    for i in range(11):\n        ProgressBar.show(i, f"Element {i}")\n        sleep(0.7)\n\n',
    'author': '\xd0\x9d\xd0\xb8\xd0\xba\xd0\xbe\xd0\xbb\xd0\xb0\xd0\xb9 \xd0\x9f\xd0\xb5\xd1\x80\xd0\xbc\xd0\xb8\xd0\xbd\xd0\xbe\xd0\xb2',
    'author_email': 'kolya-perminov@ya.ru',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/k0perX-X/koinput',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
