╔═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╗
║                                                                      Scratch                                                                      ║
╚═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╝

It’s time to choose your own adventure! Your assignment, quite simply, is to implement in Scratch, at scratch.mit.edu , any project of your choice,  
be it an interactive story, game, animation, or anything else, subject only to the following requirements:                                           

 • Your project must use at least two sprites, at least one of which must not be a cat.                                                              
 • Your project must have at least three scripts total (i.e., not necessarily three per sprite).                                                     
 • Your project must use at least one conditional, at least one loop, and at least one variable.                                                     
 • Your project must use at least one custom block that you have made yourself (via Make a Block ), which must take at least one input.              
 • Your project should be more complex than most of those demonstrated in lecture (many of which, though instructive, were quite short) but it can be
   less complex than Oscartime and Ivy’s Hardest Game .                                                                                              

To meet these requirements, your project should probably use a few dozen puzzle pieces overall. And your code should ideally be not only correct but 
also well-designed. If one of your scripts is getting a bit long, try to break it up into multiple scripts (each of which does something specific).  
And try to leverage “abstraction” where possible: if you can imagine giving a descriptive name to a sequence of blocks (e.g., meow ), those could    
probably be moved to a custom block!                                                                                                                 

If you’d like some inspiration from past students, here are just a few:                                                                              

 • It’s Raining Men , from lecture                                                                                                                   
 • Soccer , a game                                                                                                                                   
 • Cookie Love Story , an animation                                                                                                                  
 • Gingerbread tales , an interactive story                                                                                                          
 • Intersection , a game                                                                                                                             
 • Hogwarts , a game                                                                                                                                 

You might find these tutorials or starter projects helpful. And you’re welcome to explore scratch.mit.edu for inspiration. But try to think of an    
idea on your own, and then set out to implement it. However, don’t try to implement the entirety of your project all at once: tackle one piece at a  
time, just as we did in lecture. In other words, take baby steps: write a bit of code (i.e., drag and drop a few puzzle pieces), test, write a bit   
more, test, and so forth. And select File > Save now every few minutes so that you don’t lose any work!                                              

If, along the way, you find it too difficult to implement some feature, try not to fret; alter your design or work around the problem. If you set out
to implement an idea that you find fun, odds are you won’t find it too hard to satisfy the above requirements.                                       

Alright, off you go. Make us proud!                                                                                                                  

Once finished with your project, select File > Save now one last time. Then select File > Save to your computer and keep that file so that you can   
submit it. If prompted by your computer to Open or Save the file, be sure to Save it.                                                                


                                                                    Hello, World                                                                     

Suffice it to say it’s a bit harder to meet classmates when taking a course online. But, thanks to technology, everyone can at least say hello!      

If you have a phone (or digital camera) and would like to say hello to classmates, record a 1- to 2-minute video of yourself saying hello, perhaps   
stating where in the world you are, why you’re taking CS50x, and something interesting about you! Try to begin your video by saying “hello, world”   
and end it with “my name is…, and this is CS50.” But, ultimately, it’s totally up to you.                                                            

If you do record a video, upload it to YouTube (unless blocked in your country, in which case you’re welcome to upload it elsewhere) so that you can 
provide us with its URL when you submit!                                                                                                             


                                                                    How to Submit                                                                    

Be sure to complete both steps below, in order!                                                                                                      

                                                                                                                                                     

Step 1 of 2                                                                                                                                          

Submit this form .                                                                                                                                   

                                                                                                                                                     

Step 2 of 2                                                                                                                                          

This step assumes that you’ve downloaded your Scratch project as a file whose name ends in .sb3 . And this step also assumes that you’ve signed up   
for a GitHub account, per the above form.                                                                                                            

 1 Visit this link , log in with your GitHub account, and click Authorize cs50 .                                                                     
 2 Check the box indicating that you’d like to grant course staff access to your submissions, and click Join course .                                
 3 Go to submit.cs50.io/upload/cs50/problems/2022/x/scratch .                                                                                        
 4 Click “Choose File” and choose your .sb3 file. Click Submit .                                                                                     

That’s it! Once your submission uploads, you should be redirected to your submission page. Click the submission link and then the check50 link to see
which requirements your project met. You are welcome to resubmit as many times as you’d like (before the deadline)! Note that if you upload a file   
whose size is larger than 10MB (which is quite large for a Scratch project) check50 may struggle to process it. Best to make sure your file is       
smaller than that limit.                                                                                                                             

To view your current progress in the course, visit the course gradebook at cs50.me/cs50x !                                                           
