╔════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╗
║                                                               [1mLecture 0[0m                                                                ║
╚════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╝

[1;33m • [0m]8;id=992005;#introduction\[94mIntroduction[0m]8;;\                                                                                                                           
[1;33m • [0m]8;id=501588;#web-programming\[94mWeb Programming[0m]8;;\                                                                                                                        
[1;33m • [0m]8;id=137846;#html-hypertext-markup-language\[94mHTML (Hypertext Markup Language)[0m]8;;\                                                                                                       
[1;33m   [0m[1;33m • [0m]8;id=941697;#document-object-model-dom\[94mDocument Object Model (DOM)[0m]8;;\                                                                                                         
[1;33m   [0m[1;33m • [0m]8;id=848992;#more-html-elements\[94mMore HTML Elements[0m]8;;\                                                                                                                  
[1;33m   [0m[1;33m • [0m]8;id=495045;#forms\[94mForms[0m]8;;\                                                                                                                               
[1;33m • [0m]8;id=425905;#css-cascading-style-sheets\[94mCSS (Cascading Style Sheets)[0m]8;;\                                                                                                           
[1;33m • [0m]8;id=374600;#responsive-design\[94mResponsive Design[0m]8;;\                                                                                                                      
[1;33m • [0m]8;id=610287;#bootstrap\[94mBootstrap[0m]8;;\                                                                                                                              
[1;33m • [0m]8;id=304347;#sass-syntactically-awesome-style-sheets\[94mSass (Syntactically Awesome Style Sheets)[0m]8;;\                                                                                              


                                                               [1;4mIntroduction[0m                                                               

In this course, we’re picking up where CS50 left off and diving into the design and creation of web applications. We’ll build our         
web-design skills by working on a number of projects throughout the course, including an open-ended final project where you’ll have the   
chance to create a website of your own!                                                                                                   

In this course, you’ll need a text editor where you can write code locally on your computer. Some popular ones include ]8;id=957512;https://code.visualstudio.com/\[94mVisual Studios Code[0m]8;;\
, ]8;id=718222;https://www.sublimetext.com/\[94mSublime Text[0m]8;;\ , ]8;id=847139;https://atom.io/\[94mAtom[0m]8;;\ , and ]8;id=759386;https://www.vim.org/\[94mVim[0m]8;;\ , but there are many more to choose from!                                                                 


                                                             [1;4mWeb Programming[0m                                                              

[1mCourse Topics:[0m We’ll go into more detail later, but here’s a brief overview of what we’ll be working on during this course:               

[1;33m  1 [0m[1mHTML and CSS[0m (a markup language used to outline a webpage, and a procedure for making our sites more visually appealing)              
[1;33m  2 [0m[1mGit[0m (used for version control and collaboration)                                                                                      
[1;33m  3 [0m[1mPython[0m (a widely-used programming language we’ll use to make our sites more dynamic)                                                  
[1;33m  4 [0m[1mDjango[0m (a popular web framework we’ll use for the backend of our sites)                                                               
[1;33m  5 [0m[1mSQL, Models, and Migrations[0m (a language used for storing and retrieving data, and Django-specific methods that make it easier to      
[1;33m    [0minteract with SQL databases)                                                                                                          
[1;33m  6 [0m[1mJavaScript[0m (a programming language used to make websites faster and more interactive)                                                 
[1;33m  7 [0m[1mUser Interfaces[0m (methods used to make a website as easy to use as possible)                                                           
[1;33m  8 [0m[1mTesting, CI, CD[0m (learning about different methods used to make sure updates to web pages proceed smoothly)                            
[1;33m  9 [0m[1mScalability and Security[0m (making sure our websites can be accessed by many users at once, and that they are safe from malicious       
[1;33m    [0mintent)                                                                                                                               


                                                     [1;4mHTML (Hypertext Markup Language)[0m                                                     

[1;33m • [0mHTML is a markup language that defines the structure of a web page. It is interpreted by your web browser (Safari, Google Chrome,      
[1;33m   [0mFirefox, etc.) in order to display content on your screen.                                                                             
[1;33m • [0mLet’s get started by writing a simple HTML file!                                                                                       

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m<!DOCTYPE html>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html lang="en">                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <head>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <title>Hello!</title>                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </head>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <body>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        Hello, world!                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </body>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html>                                                                                                                                [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[1;33m • [0mWhen we open up this file in our browser, we get:                                                                                      

🌆 ]8;id=518065;images/hello0.png\Hello Page]8;;\                                                                                                                             

[1;33m • [0mNow, let’s take some time to talk about the file we just wrote, which seems to be pretty complicated for such a simple page.           
[1;33m   [0m[1;33m • [0mIn the first line, we are declaring (to the web browser) that we are writing the document in the latest version of HTML: HTML5.     
[1;33m   [0m[1;33m • [0mAfter that, the page consists of nested [1mHTML elements[0m (such as html and body), each with an [1mopening and closing tag[0m marked with     
[1;33m   [0m[1;33m   [0meither [97;40m<element>[0m for an opening and [97;40m</element>[0m for a closing.                                                                       
[1;33m   [0m[1;33m • [0mNotice how each of the inner elements is indented just a bit further than the last. While this is not necessarily required by the   
[1;33m   [0m[1;33m   [0mbrowser, it will be very helpful to keep this up in your own code.                                                                  
[1;33m   [0m[1;33m • [0mHTML elements can include [1mattributes[0m , which give the browser extra information about the element. For example, when we include     
[1;33m   [0m[1;33m   [0m[97;40mlang="en"[0m in our initial tag, we are telling the browser that we are using English as our primary language.                         
[1;33m   [0m[1;33m • [0mInside the HTML element, we typically want to include both a [97;40mhead[0m and a [97;40mbody[0m tag. The head element will include information about   
[1;33m   [0m[1;33m   [0myour page that is not necessarily displayed, and the body element will contain what is actually visible to users who visit the site.
[1;33m   [0m[1;33m • [0mWithin the head, we have included a [97;40mtitle[0m for our webpage, which you’ll notice is displayed in the tab at the top of our web        
[1;33m   [0m[1;33m   [0mbrowser.                                                                                                                            
[1;33m   [0m[1;33m • [0mFinally, we’ve included the text “Hello, world!” in the body, which is the visible part of our page.                                

                                                                                                                                          

Document Object Model (DOM)                                                                                                               

🌆 ]8;id=792340;images/dom.png\DOM]8;;\                                                                                                                                    

[1;33m • [0mThe DOM is a convenient way of visualizing the way HTML elements relate to each other using a tree-like structure. Above is an example 
[1;33m   [0mof the DOM layout for the page we just wrote.                                                                                          

                                                                                                                                          

More HTML Elements                                                                                                                        

[1;33m • [0mThere are many HTML elements you may want to use to customize your page, including headings, lists, and bolded sections. In this next  
[1;33m   [0mexample, we’ll see a few of of these in action.                                                                                        
[1;33m • [0mOne more thing to note: [97;40m<!-- -->[0m gives us a comment in HTML, so we’ll use that below to explain some of the elements.                  

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m<!DOCTYPE html>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html lang="en">                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <head>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <title>HTML Elements</title>                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </head>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <body>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <!-- We can create headings using h1 through h6 as tags. -->                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <h1>A Large Heading</h1>                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <h2>A Smaller Heading</h2>                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <h6>The Smallest Heading</h6>                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <!-- The strong and i tags give us bold and italics respectively. -->                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        A <strong>bold</strong> word and an <i>italicized</i> word!                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <!-- We can link to another page (such as cs50's page) using a. -->                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        View the <a href="https://cs50.harvard.edu/">CS50 Website</a>!                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <!-- We used ul for an unordered list and ol for an ordered one. both ordered and unordered lists contain li, or list items.  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m-->                                                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        An unordered list:                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <ul>                                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <li>foo</li>                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <li>bar</li>                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <li>baz</li>                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </ul>                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        An ordered list:                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <ol>                                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <li>foo</li>                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <li>bar</li>                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <li>baz</li>                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </ol>                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <!-- Images require a src attribute, which can be either the path to a file on your computer or the link to an image online.  [0m [2m│[0m
[2m│[0m [48;2;39;40;34mIt also includes an alt attribute, which gives a description in case the image can't be loaded. -->                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        An image:                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <img src="../../images/duck.jpeg" alt="Rubber Duck Picture">                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <!-- We can also see above that for some elements that don't contain other ones, closing tags are not necessary. -->          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <!-- Here, we use a br tag to add white space to the page. -->                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <br/> <br/>                                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <!-- A few different tags are necessary to create a table. -->                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <table>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <thead>                                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <th>Ocean</th>                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <th>Average Depth</th>                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <th>Maximum Depth</th>                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            </thead>                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <tbody>                                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <tr>                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    <td>Pacific</td>                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    <td>4280 m</td>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    <td>10911 m</td>                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                </tr>                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <tr>                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    <td>Atlantic</td>                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    <td>3646 m</td>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    <td>8486 m</td>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                </tr>                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            </tbody>                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </table>                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </body>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html>                                                                                                                                [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

This page, when rendered, looks something like this:                                                                                      

🌆 ]8;id=86831;images/elements.png\Elements]8;;\                                                                                                                               

[1;33m • [0mIn case you’re worried about it, know that you’ll never have to memorize these elements. It’s very easy to simply search something like
[1;33m   [0m“image in HTML” to find the [97;40mimg[0m tag. One resource that’s especially helpful for learning about these elements is ]8;id=81773;https://www.w3schools.com/html/html_elements.asp\[94mW3 Schools[0m]8;;\ .          

                                                                                                                                          

Forms                                                                                                                                     

[1;33m • [0mAnother set of elements that is really important when creating a website is how to collect information from users. You can allow users 
[1;33m   [0mto enter information using an HTML form, which can contain several different types of input. Later in the course, we’ll learn about how
[1;33m   [0mto handle information once a form has been submitted.                                                                                  
[1;33m • [0mJust as with other HTML elements, there’s no need to memorize these, and W3 Schools is a great resource for learning about them!       

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m<!DOCTYPE html>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html lang="en">                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<head>                                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <title>Forms</title>                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m</head>                                                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<body>                                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <form>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <input type="text" placeholder="First Name" name="first">                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <input type="password" placeholder="Password" name="password">                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <div>                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            Favorite Color:                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <input name="color" type="radio" value="blue"> Blue                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <input name="color" type="radio" value="green"> Green                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <input name="color" type="radio" value="yellow"> Yellow                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <input name="color" type="radio" value="red"> Red                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </div>                                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <input type="submit">                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </form>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m</body>                                                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34m</html>                                                                                                                               [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

🌆 ]8;id=390141;images/form.png\form]8;;\                                                                                                                                   


                                                       [1;4mCSS (Cascading Style Sheets)[0m                                                       

[1;33m • [0mCSS is used to customize the appearance of a website.                                                                                  
[1;33m • [0mWhile we’re just getting, started, we can add a style attribute to any HTML element in order to apply some CSS to it.                  
[1;33m • [0mWe change style by altering the CSS properties of an element, writing something like [97;40mcolor: blue[0m or [97;40mtext-align: center[0m                 
[1;33m • [0mIn this example below, we make a slight change to our very first file to give it a colorful heading:                                   

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m<!DOCTYPE html>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html lang="en">                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <head>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <title>Hello!</title>                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </head>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <body>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <h1 style="color: blue; text-align: center;">A Colorful Heading!</h1>                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        Hello, world!                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </body>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html>                                                                                                                                [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

🌆 ]8;id=363457;images/style0.png\blue heading]8;;\                                                                                                                           

[1;33m • [0mIf we style an outer element, all of the inner elements automatically take on that style. We can see this if we move the styling we    
[1;33m   [0mjust applied from the header tag to the body tag:                                                                                      

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m<!DOCTYPE html>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html lang="en">                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <head>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <title>Hello!</title>                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </head>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <body style="color: blue; text-align: center;">                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <h1 >A Colorful Heading!</h1>                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        Hello, world!                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </body>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html>                                                                                                                                [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

🌆 ]8;id=181761;images/style1.png\blue everywhere]8;;\                                                                                                                        

[1;33m • [0mWhile we can style our web page as we’ve done above, to achieve better design, we should be able to move our styling away from the     
[1;33m   [0mindividual lines.                                                                                                                      
[1;33m   [0m[1;33m • [0mOne way of doing this is to add your styling between [97;40m<style>[0m tags in the [97;40mhead[0m . Inside these tags, we write which types of elements 
[1;33m   [0m[1;33m   [0mwe want to be style, and the styling we wish to apply to them. For example:                                                         

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m  <html lang="en">                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m  <!DOCTYPE html>                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m  <head>                                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m      <title>Hello!</title>                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m      <style>                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m          h1 {                                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m              color: blue;                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m              text-align: center;                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m          }                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m      </style>                                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m  </head>                                                                                                                             [0m [2m│[0m
[2m│[0m [48;2;39;40;34m  <body>                                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m      <h1 >A Colorful Heading!</h1>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m      Hello, world!                                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m  </body>                                                                                                                             [0m [2m│[0m
[2m│[0m [48;2;39;40;34m  </html>                                                                                                                             [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m+ Another way is to include in a                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m `<link>`                                                                                                                             [0m [2m│[0m
[2m│[0m [48;2;39;40;34m element in your                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m `head`                                                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34m with a link to a styles.css file that contains some styling. This means the HTML file would look like:                               [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m  <html lang="en">                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m  <!DOCTYPE html>                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m  <head>                                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m      <title>Hello!</title>                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m      <link rel="stylesheet" href="styles.css">                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m  </head>                                                                                                                             [0m [2m│[0m
[2m│[0m [48;2;39;40;34m  <body>                                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m      <h1 >A Colorful Heading!</h1>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m      Hello, world!                                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m  </body>                                                                                                                             [0m [2m│[0m
[2m│[0m [48;2;39;40;34m  </html>                                                                                                                             [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

And our file called [97;40mstyles.css[0m would look like:                                                                                           

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m  h1 {                                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m      color: blue;                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m      text-align: center;                                                                                                             [0m [2m│[0m
[2m│[0m [48;2;39;40;34m  }                                                                                                                                   [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[1;33m • [0mThere are far too many CSS properties to go over here, but just like HTML elements, it’s typically easy to Google something along the  
[1;33m   [0mlines of “change font to blue CSS” to get the result. Some of the most common ones though are:                                         
[1;33m   [0m[1;33m • [0m[97;40mcolor[0m : the color of text                                                                                                           
[1;33m   [0m[1;33m • [0m[97;40mtext-align[0m : where elements are placed on the page                                                                                  
[1;33m   [0m[1;33m • [0m[97;40mbackground-color[0m : can be set to any color                                                                                          
[1;33m   [0m[1;33m • [0m[97;40mwidth[0m : in pixels or percent of a page                                                                                              
[1;33m   [0m[1;33m • [0m[97;40mheight[0m : in pixels or percent of a page                                                                                             
[1;33m   [0m[1;33m • [0m[97;40mpadding[0m : how much space should be left inside an element                                                                           
[1;33m   [0m[1;33m • [0m[97;40mmargin[0m : how much space should be left outside an element                                                                           
[1;33m   [0m[1;33m • [0m[97;40mfont-family[0m : type of font for text on page                                                                                         
[1;33m   [0m[1;33m • [0m[97;40mfont-size[0m : in pixels                                                                                                               
[1;33m   [0m[1;33m • [0m[97;40mborder[0m : size type (solid, dashed, etc) color                                                                                       
[1;33m • [0mLet’s use some of what we just learned to improve upon our oceans table from above. Here’s some HTML to start us off:                  

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m<!DOCTYPE html>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html lang="en">                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <head>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <title>Nicer Table</title>                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </head>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <body>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <table>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <thead>                                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <th>Ocean</th>                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <th>Average Depth</th>                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <th>Maximum Depth</th>                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            </thead>                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <tbody>                                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <tr>                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    <td>Pacific</td>                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    <td>4280 m</td>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    <td>10911 m</td>                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                </tr>                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <tr>                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    <td>Atlantic</td>                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    <td>3646 m</td>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    <td>8486 m</td>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                </tr>                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            </tbody>                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </table>                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </body>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html>                                                                                                                                [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

🌆 ]8;id=814033;images/table0.png\table bad]8;;\                                                                                                                              

[1;33m • [0mThe above looks a lot like what we had before, but now, either by including a [97;40mstyle[0m tag or a [97;40mlink[0m to a stylesheet in the head element, 
[1;33m   [0mwe add the following css:                                                                                                              

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34mtable {                                                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    border: 1px solid black;                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    border-collapse: collapse;                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m}                                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mtd {                                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    border: 1px solid black;                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    padding: 2px;                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m}                                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mth {                                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    border: 1px solid black;                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    padding: 2px;                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m}                                                                                                                                     [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

Which leaves us with this nicer-looking table:                                                                                            

🌆 ]8;id=971683;images/table1.png\table good]8;;\                                                                                                                             

[1;33m • [0mYou may already be thinking that there’s some needless repetition in our CSS at the moment, as [97;40mtd[0m and [97;40mth[0m have the same styling. We can 
[1;33m   [0m(and should) condense this down to the following code, using a comma to show the styling should apply to more than one element type.   

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34mtable {                                                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    border: 1px solid black;                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    border-collapse: collapse;                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m}                                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mtd, th {                                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    border: 1px solid black;                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    padding: 2px;                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m}                                                                                                                                     [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[1;33m • [0mThis is a good introduction into what are known as ]8;id=570413;https://www.w3schools.com/cssref/css_selectors.asp\[94mCSS selectors[0m]8;;\ . There are many ways to determine which HTML elements you are        
[1;33m   [0mstyling, some of which we’ll mention here:                                                                                             
[1;33m   [0m[1;33m • [0m[1melement type[0m : this is what we’ve been doing so far: styling all elements of the same type.                                         
[1;33m   [0m[1;33m • [0m[1mid[0m : Another option is to give our HTML elements an id like so: [97;40m<h1 id="first-header">Hello!</h1>[0m and then applying styling using   
[1;33m   [0m[1;33m   [0m[97;40m#first-header{...}[0m using the hashtag to show that we’re searching by id. Importantly, no two elements can have the same id, and no  
[1;33m   [0m[1;33m   [0melement can have more than one id.                                                                                                  
[1;33m   [0m[1;33m • [0m[1mclass[0m : This is similar to id, but a class can be shared by more than one element, and a single element can have more than one      
[1;33m   [0m[1;33m   [0mclass. We add classes to an HTML element like this: [97;40m<h1 class="page-text muted">Hello!</h1>[0m (note that we just added two classes to 
[1;33m   [0m[1;33m   [0mthe element: [97;40mpage-text[0m and [97;40mmuted[0m ). We then style based on class using a period instead of a hashtag: [97;40m.muted {...}[0m                  
[1;33m • [0mNow, we also have to deal with the problem of potentially conflicting CSS. What happens when a header should be red based on its class 
[1;33m   [0mbut blue based on its id? CSS has a specificity order that goes:                                                                       
[1;33m   [0m[1;33m 1 [0mIn-line styling                                                                                                                     
[1;33m   [0m[1;33m 2 [0mid                                                                                                                                  
[1;33m   [0m[1;33m 3 [0mclass                                                                                                                               
[1;33m   [0m[1;33m 4 [0melement type                                                                                                                        
[1;33m • [0mIn addition to the comma for multiple selectors, there are several other ways to specify which elements you would like to style. This  
[1;33m   [0mtable from lecture provides a few, and we’ll go through a few examples below:                                                          

🌆 ]8;id=45952;images/selectors.png\selectors]8;;\                                                                                                                              

[1mDescendant Selector[0m : Here, we use the descendant selector to only apply styling to list items found within an unordered list:            

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m<!DOCTYPE html>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html lang="en">                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <head>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <title>Using Selectors</title>                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <style>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            ul li {                                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                color: blue;                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            }                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </style>                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </head>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <body>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <ol>                                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <li>foo</li>                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <li> bar                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <ul>                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    <li>hello</li>                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    <li>goodbye</li>                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    <li>hello</li>                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                </ul>                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            </li>                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <li>baz</li>                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </ol>                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </body>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html>                                                                                                                                [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

🌆 ]8;id=597164;images/selectors0.png\list selector]8;;\                                                                                                                          

[1mAttributes as Selectors[0m : We can also narrow down our selection based on the attributes we assign to HTML elements using brackets. For    
example, in the following list of links, we choose to only make the link to Amazon red:                                                   

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m<!DOCTYPE html>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html lang="en">                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <head>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <title>Using Selectors</title>                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <style>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            a[href="https://www.amazon.com/"] {                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                color: red;                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            }                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </style>                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </head>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <body>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <ol>                                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <li><a href="https://www.google.com/">Google</a></li>                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <li><a href="https://www.amazon.com/">Amazon</a> </li>                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <li><a href="https://www.facebook.com/">Facebook</a></li>                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </ol>                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </body>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html>                                                                                                                                [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

🌆 ]8;id=561315;images/selectors2.png\link selectors]8;;\                                                                                                                         

[1;33m • [0mNot only can we use CSS to change what an element looks like permanently, but also what it looks like under certain conditions. For    
[1;33m   [0mexample, what if we wanted a button to change color when we hover over it? We can acheive this using a ]8;id=785807;https://www.w3schools.com/css/css_pseudo_classes.asp\[94mCSS pseudoclass[0m]8;;\ , which provides
[1;33m   [0madditional styling during special circumstances. We write this by adding a colon after our selector, and then adding the circumstance  
[1;33m   [0mafter that colon.                                                                                                                      
[1;33m • [0mIn the case of the button, we would add [97;40m:hover[0m to the button selector to specify the design only when hovering:                        

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m<!DOCTYPE html>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html lang="en">                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <head>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <title>Pseudoclasses</title>                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <style>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            button {                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                background-color: red;                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                width: 200px;                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                height: 50px;                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                font-size: 24px;                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            }                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            button:hover {                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                background-color: green;                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            }                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </style>                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </head>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <body>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <button>Button 1</button>                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <button>Button 2</button>                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <button>Button 3</button>                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </body>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html>                                                                                                                                [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

🌆 ]8;id=916104;images/buttons.gif\buttons]8;;\                                                                                                                                


                                                            [1;4mResponsive Design[0m                                                             

[1;33m • [0mToday, many people view websites on devices other than computers, such as smartphones and tablets. It’s important to make sure your    
[1;33m   [0mwebsite is readable to people on all devices.                                                                                          
[1;33m • [0mOne way we can achieve this is through knowledge of the [1mviewport[0m . The viewport is the part of the screen that is actually visible to  
[1;33m   [0mthe user at any given time. By default, many webpages assume that the viewport is the same on any device, which is what leads to many  
[1;33m   [0msites (especially older ones) being difficult to interact with on mobile devices.                                                      
[1;33m • [0mOne simple way to improve the appearance of a site on a mobile device is to add the following line in the head of our HTML files. This 
[1;33m   [0mline tells the mobile device to use a viewport that is the same width as that of the device you’re using rather than a much larger one.

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m<meta name="viewport" content="width=device-width, initial-scale=1.0">                                                                [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[1;33m • [0mAnother way we can deal with different devices is through ]8;id=163627;https://www.w3schools.com/cssref/css3_pr_mediaquery.asp\[94mmedia queries[0m]8;;\ . Media queries are ways of changing the style of a page based 
[1;33m   [0mon how the page is being viewed.                                                                                                       
[1;33m • [0mFor an example of a media query, let’s try to simply change the color of the screen when it shrinks down to a certain size. We signal a
[1;33m   [0mmedia query by typing [97;40m@media[0m followed by the type of query in parentheses:                                                             

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m<!DOCTYPE html>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html lang="en">                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <head>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <title>Screen Size</title>                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <style>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            @media (min-width: 600px) {                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                body {                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    background-color: red;                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                }                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            }                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            @media (max-width: 599px) {                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                body {                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    background-color: blue;                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                }                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            }                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </style>                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </head>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <body>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <h1>Welcome to the page!</h1>                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </body>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m</html>                                                                                                                               [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

🌆 ]8;id=725810;images/responsive0.gif\screen size]8;;\                                                                                                                            

[1;33m • [0mAnother way to deal with differing screen size is using a new CSS attribute known as a ]8;id=710243;https://www.w3schools.com/css/css3_flexbox.asp\[94mflexbox[0m]8;;\ . This allows us to easily have elements
[1;33m   [0mwrap around to the next line if they don’t fit horizontally. We do this by putting all of our elements in a [97;40mdiv[0m that we’ll call our    
[1;33m   [0mcontainer. We then add some styling to that div specifying that we want to use a flexbox display for the elements inside of it. We’ve  
[1;33m   [0malso added some additional styling to the inner divs to better illustrate the wrapping that’s occuring here.                           

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m<!DOCTYPE html>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html lang="en">                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <head>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <title>Screen Size</title>                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <style>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            #container {                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                display: flex;                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                flex-wrap: wrap;                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            }                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            #container > div {                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                background-color: green;                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                font-size: 20px;                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                margin: 20px;                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                padding: 20px;                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                width: 200px;                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            }                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </style>                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </head>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <body>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <div id="container">                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div>Some text 1!</div>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div>Some text 2!</div>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div>Some text 3!</div>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div>Some text 4!</div>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div>Some text 5!</div>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div>Some text 6!</div>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div>Some text 7!</div>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div>Some text 8!</div>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div>Some text 9!</div>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div>Some text 10!</div>                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div>Some text 11!</div>                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div>Some text 12!</div>                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </div>                                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </body>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m</html>                                                                                                                               [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

🌆 ]8;id=56763;images/flexbox.gif\flexbox]8;;\                                                                                                                                

[1;33m • [0mAnother popular way of styling a page is using an HTML ]8;id=938665;https://www.w3schools.com/css/css_grid.asp\[94mgrid[0m]8;;\ . In this grid, we can specify style attributes such as column widths and  
[1;33m   [0mgaps between columns and rows, as demonstrated below. Note that when we specify column widths, we say the third one is [97;40mauto[0m , meaning  
[1;33m   [0mit should fill the rest of the page.                                                                                                   

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m<!DOCTYPE html>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html lang="en">                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <head>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <title>My Web Page!</title>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <meta name="viewport" content="width=device-width, initial-scale=1.0">                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <style>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            .grid {                                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                background-color: green;                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                display: grid;                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                padding: 20px;                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                grid-column-gap: 20px;                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                grid-row-gap: 10px;                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                grid-template-columns: 200px 200px auto;                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            }                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            .grid-item {                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                background-color: white;                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                font-size: 20px;                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                padding: 20px;                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                text-align: center;                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            }                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </style>                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </head>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <body>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <div class="grid">                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div class="grid-item">1</div>                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div class="grid-item">2</div>                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div class="grid-item">3</div>                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div class="grid-item">4</div>                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div class="grid-item">5</div>                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div class="grid-item">6</div>                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div class="grid-item">7</div>                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div class="grid-item">8</div>                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div class="grid-item">9</div>                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div class="grid-item">10</div>                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div class="grid-item">11</div>                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div class="grid-item">12</div>                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </div>                                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </body>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m</html>                                                                                                                               [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

🌆 ]8;id=585442;images/grid.gif\grid]8;;\                                                                                                                                   


                                                                [1;4mBootstrap[0m                                                                 

[1;33m • [0mIt turns out that there are many libraries that other people have already written that can make the styling of a webpage even simpler. 
[1;33m   [0mOne popular library that we’ll use throughout the course is known as ]8;id=352659;https://getbootstrap.com/\[94mbootstrap[0m]8;;\ .                                                       
[1;33m • [0mWe can include bootstrap in our code by adding a single line to the head of our HTML file:                                             

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css"                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34mintegrity="sha384-9aIt2nRpC12Uk9gS9baDl411NQApFmC26EwAOH8WgZl5MYYxFfc+NcPb1dKGj7Sk" crossorigin="anonymous">                          [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[1;33m • [0mNext, we can look at some of bootstrap’s features by navigating to the ]8;id=333159;https://getbootstrap.com/docs/4.5/components/\[94mdocumentation[0m]8;;\ portion of their website. On this page, you’ll    
[1;33m   [0mfind many examples of classes you can add to elements that allow them to be styled with bootstrap.                                     
[1;33m • [0mOne popular bootstrap feature is their ]8;id=46250;https://getbootstrap.com/docs/4.0/layout/grid/\[94mgrid system[0m]8;;\ . Bootstrap automatically splits a page into 12 columns, and we can decide how many 
[1;33m   [0mcolumns an element takes up by adding the class [97;40mcol-x[0m where [97;40mx[0m is a number between 1 and 12. For example, in the following page, we have
[1;33m   [0ma row of columns of equal width, and then a row where the center column is larger:                                                     

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m<!DOCTYPE html>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html lang="en">                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <head>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <title>My Web Page!</title>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css"                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34mintegrity="sha384-Vkoo8x4CGsO3+Hhxv8T/Q5PaXtkKtu6ug5TOeNV6gBiFeWPGFN9MuhOf23Q9Ifjh" crossorigin="anonymous">                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <style>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            .row > div {                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                padding: 20px;                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                background-color: teal;                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                border: 2px solid black;                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            }                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </style>                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </head>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <body>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <div class="container">                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div class="row">                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <div class="col-4">                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    This is a section.                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                </div>                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <div class="col-4">                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    This is another section.                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                </div>                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <div class="col-4">                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    This is a third section.                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                </div>                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            </div>                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </div>                                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <br/>                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <div class="container">                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div class="row">                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <div class="col-3">                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    This is a section.                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                </div>                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <div class="col-6">                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    This is another section.                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                </div>                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <div class="col-3">                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    This is a third section.                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                </div>                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            </div>                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </div>                                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </body>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m</html>                                                                                                                               [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

🌆 ]8;id=223428;images/cols1.gif\columns]8;;\                                                                                                                                

[1;33m • [0mTo improve mobile-responsiveness, bootstrap also allows us to specify column sizes that differ depending on the screen size. In the    
[1;33m   [0mfollowing example, we use [97;40mcol-lg-3[0m to show that an element should take up 3 columns on a large screen, and [97;40mcol-sm-6[0m to show an element 
[1;33m   [0mshould take up 6 columns when the screen is small:                                                                                     

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m<!DOCTYPE html>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m<html lang="en">                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <head>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <title>My Web Page!</title>                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css"                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34mintegrity="sha384-Vkoo8x4CGsO3+Hhxv8T/Q5PaXtkKtu6ug5TOeNV6gBiFeWPGFN9MuhOf23Q9Ifjh" crossorigin="anonymous">                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <style>                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            .row > div {                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                padding: 20px;                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                background-color: teal;                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                border: 2px solid black;                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            }                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </style>                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </head>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    <body>                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        <div class="container">                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            <div class="row">                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <div class="col-lg-3 col-sm-6">                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    This is a section.                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                </div>                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <div class="col-lg-3 col-sm-6">                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    This is another section.                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                </div>                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <div class="col-lg-3 col-sm-6">                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    This is a third section.                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                </div>                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                <div class="col-lg-3 col-sm-6">                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                    This is a fourth section.                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                </div>                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m            </div>                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        </div>                                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    </body>                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m</html>                                                                                                                               [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

🌆 ]8;id=668284;images/cols2.gif\wrap columns]8;;\                                                                                                                           


                                                [1;4mSass (Syntactically Awesome Style Sheets)[0m                                                 

[1;33m • [0mSo far, we’ve found a few ways to eliminate redundancy in CSS such as moving it to separate files or using bootstrap, but there are    
[1;33m   [0mstill quite a few places where we can still make improvements. For example, what if we want several elements to have different styles, 
[1;33m   [0mbut for all of them to be the same color? If we decide later we want to change the color, then we would have to change it within       
[1;33m   [0mseveral different elements.                                                                                                            
[1;33m • [0m]8;id=701440;https://sass-lang.com/\[94mSass[0m]8;;\ is a language that allows us to write CSS more efficiently in several ways, one of which is by allowing us to have variables, as  
[1;33m   [0min the following example.                                                                                                              
[1;33m • [0mWhen writing in Sass, we create a new file with the extension [97;40mfilename.scss[0m . In this file, we can create a new variable by adding a [97;40m$[0m 
[1;33m   [0mbefore a name, then a colon, then a value. For example, we would write [97;40m$color: red[0m to set the variable color to the value red. We then 
[1;33m   [0maccess that variable using [97;40m$color[0m . Here’s an example of our variables.scss file:                                                      

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m$color: red;                                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mul {                                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    font-size: 14px;                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    color: $color;                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m}                                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mol {                                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    font-size: 18px;                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    color: $color;                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m}                                                                                                                                     [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[1;33m • [0mNow, in order to link this styling to our HTML file, we can’t just link to the [97;40m.scss[0m file because most web browsers only recognize [97;40m.css[0m
[1;33m   [0mfiles. To deal with this problem, we have to ]8;id=648824;https://sass-lang.com/install\[94mdownload a program called Sass[0m]8;;\ onto our computers. Then, in our terminal, we write [97;40msass [0m  
[1;33m   [0m[97;40mvariables.scss:variables.css[0m This command will compile a .scss file named [97;40mvariables.scss[0m into a .css file named [97;40mvariables.css[0m , to     
[1;33m   [0mwhich you can add a link in your HTML page.                                                                                            
[1;33m • [0mTo speed up this process, we can use the command [97;40msass --watch variables.scss:variables.css[0m which automatically changes the [97;40m.css[0m file   
[1;33m   [0mevery time a change is detected in the [97;40m.scss[0m file.                                                                                     
[1;33m • [0mWhile using Sass, we can also physically nest our styling rather than use the CSS selectors we talked about earlier. For example, if we
[1;33m   [0mwant to apply some styling only to paragraphs and unordered lists within a div, we can write the following:                            

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34mdiv {                                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    font-size: 18px;                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    p {                                                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        color: blue;                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    }                                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    ul {                                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m        color: green;                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    }                                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m}                                                                                                                                     [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

Once compiled into CSS, we would get a file that looks like:                                                                              

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34mdiv {                                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    font-size: 18px;                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m}                                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mdiv p {                                                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    color: blue;                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m}                                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mdiv ul {                                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    color: green;                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m}                                                                                                                                     [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[1;33m • [0mOne more feature that Sass gives us is known as ]8;id=511673;https://sass-lang.com/guide\[94minheritance[0m]8;;\ . This allows us to create a basic set of styling that can be shared by    
[1;33m   [0mseveral different elements. We do this by adding a [97;40m%[0m before a name of a class, adding some styling, and then later adding the line     
[1;33m   [0m[97;40m@extend %classname[0m to the beginning of some styling. For example, the following code applies the styling within the [97;40mmessage[0m class to   
[1;33m   [0meach of the different classes below, resulting in a webpage that looks like the one below.                                             

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m%message {                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    font-family: sans-serif;                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    font-size: 18px;                                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    font-weight: bold;                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    border: 1px solid black;                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    padding: 20px;                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    margin: 20px;                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m}                                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m.success {                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    @extend %message;                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    background-color: green;                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m}                                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m.warning {                                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    @extend %message;                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    background-color: orange;                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34m}                                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m.error {                                                                                                                              [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    @extend %message;                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    background-color: red;                                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34m}                                                                                                                                     [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

🌆 ]8;id=860827;images/inherit.png\inheritance]8;;\                                                                                                                            

[1;33m • [0mThat wraps up our content for today!                                                                                                   
