╔════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╗
║                                                               [1mLecture 0[0m                                                                ║
╚════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╝

[1;33m • [0m]8;id=405793;#creating-code-with-python\[94mCreating Code with Python[0m]8;;\                                                                                                              
[1;33m • [0m]8;id=759699;#functions\[94mFunctions[0m]8;;\                                                                                                                              
[1;33m • [0m]8;id=814786;#bugs\[94mBugs[0m]8;;\                                                                                                                                   
[1;33m • [0m]8;id=581669;#improving-your-first-python-program\[94mImproving Your First Python Program[0m]8;;\                                                                                                    
[1;33m   [0m[1;33m • [0m]8;id=363487;#variables\[94mVariables[0m]8;;\                                                                                                                           
[1;33m   [0m[1;33m • [0m]8;id=998183;#comments\[94mComments[0m]8;;\                                                                                                                            
[1;33m   [0m[1;33m • [0m]8;id=552069;#pseudocode\[94mPseudocode[0m]8;;\                                                                                                                          
[1;33m • [0m]8;id=528077;#further-improving-your-first-python-program\[94mFurther Improving Your First Python Program[0m]8;;\                                                                                            
[1;33m • [0m]8;id=848640;#strings-and-paremeters\[94mStrings and Paremeters[0m]8;;\                                                                                                                 
[1;33m   [0m[1;33m • [0m]8;id=852682;#a-small-problem-with-quotation-marks\[94mA small problem with quotation marks[0m]8;;\                                                                                                
[1;33m • [0m]8;id=591660;#formatting-strings\[94mFormatting Strings[0m]8;;\                                                                                                                     
[1;33m • [0m]8;id=437107;#more-on-strings\[94mMore on Strings[0m]8;;\                                                                                                                        
[1;33m • [0m]8;id=771005;#integers-or-int\[94mIntegers or int[0m]8;;\                                                                                                                        
[1;33m • [0m]8;id=180402;#readability-wins\[94mReadability Wins[0m]8;;\                                                                                                                       
[1;33m • [0m]8;id=341506;#float-basics\[94mFloat Basics[0m]8;;\                                                                                                                           
[1;33m • [0m]8;id=841757;#more-on-floats\[94mMore on Floats[0m]8;;\                                                                                                                         
[1;33m • [0m]8;id=262730;#def\[94mDef[0m]8;;\                                                                                                                                    
[1;33m • [0m]8;id=900768;#returning-values\[94mReturning Values[0m]8;;\                                                                                                                       
[1;33m • [0m]8;id=110040;#summing-up\[94mSumming Up[0m]8;;\                                                                                                                             


                                                        [1;4mCreating Code with Python[0m                                                         

[1;33m • [0mVS Code is a special type of text editor that is called a compiler. At the top, you’ll notice a text editor and, at the bottom you will
[1;33m   [0msee a terminal where you can execute commands.                                                                                         
[1;33m • [0mIn the terminal, you can execute [97;40mcode hello.py[0m to start coding.                                                                        
[1;33m • [0mIn the text editor above, you can type [97;40mprint("hello, world")[0m . This is a famous canonical program that nearly all coders write during  
[1;33m   [0mtheir learning process.                                                                                                                
[1;33m • [0mIn the terminal window, you can execute commands. To run this program, you are going to need to move your cursor to the bottom of the  
[1;33m   [0mscreen, clicking in the terminal window. You can now type a second command in the terminal window. Next to the dollar sign, type [97;40mpython[0m
[1;33m   [0m[97;40mhello.py[0m and press the enter key on your keyboard.                                                                                     
[1;33m • [0mRecall, computers really only understand zeros and ones. Therefore, when you run [97;40mpython hello.py[0m , python will interpret the text that 
[1;33m   [0myou created in [97;40mhello.py[0m and translate it into the zeros and ones that the computer can understand.                                     
[1;33m • [0mThe result of running the [97;40mpython hello.py[0m program is [97;40mhello, world[0m .                                                                    
[1;33m • [0mCongrats! You just created your first program.                                                                                         


                                                                [1;4mFunctions[0m                                                                 

[1;33m • [0mFunctions are verbs or actions that the computer or computer language will already know how to perform.                                
[1;33m • [0mIn your [97;40mhello.py[0m program, the [97;40mprint[0m function knows how to print to the terminal window.                                                
[1;33m • [0mThe [97;40mprint[0m function takes arguments. In this case, [97;40m"hello, world"[0m are the arguments that the [97;40mprint[0m function takes.                      


                                                                   [1;4mBugs[0m                                                                   

[1;33m • [0mBugs are a natural part of coding. These are mistakes, problems for you to solve! Don’t get discouraged! This is part of the process of
[1;33m   [0mbecoming a great programmer.                                                                                                           
[1;33m • [0mImagine in our [97;40mhello.py[0m program that accidentally typed [97;40mprint("hello, world"[0m notice that we missed the final [97;40m)[0m required by the         
[1;33m   [0mcompiler. If I purposefully make this mistake, you’ll the compiler will output an error in the terminal window!                        
[1;33m • [0mOften, the error messages will inform you of your mistake and provide you clues on how to fix them. However, there will be many times  
[1;33m   [0mthat the compiler is not this kind.                                                                                                    


                                                   [1;4mImproving Your First Python Program[0m                                                    

[1;33m • [0mWe can personalize your first Python program.                                                                                          
[1;33m • [0mIn our text editor in [97;40mhello.py[0m we can add another function. [97;40minput[0m is a function that takes a prompt as an argument. We can edit our    
[1;33m   [0mcode to say                                                                                                                            

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34minput("What's your name? ")                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint("hello, world")                                                                                                                 [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[1;33m • [0mThis edit alone, however, will not allow your program to output what your user inputs. For that, we will need to introduce you to      
[1;33m   [0mvariables                                                                                                                              

                                                                                                                                          

Variables                                                                                                                                 

[1;33m • [0mA variable is just a container for a value within your own program.                                                                    
[1;33m • [0mIn your program, you can introduce your own variable in your program by editing it to read                                             

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ")                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint("hello, world")                                                                                                                 [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

Notice that this equal [97;40m=[0m sign in the middle of [97;40mname = input("What's your name? ")[0m has a special role in programming. This equal sign      
literally assigns what is on the right to what is on the left. Therefore, the value returned by [97;40minput("What's your name? ")[0m is assigned to
[97;40mname[0m .                                                                                                                                    

[1;33m • [0mIf you edit your code as follows, you will notice an error                                                                             

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ")                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint("hello, name")                                                                                                                  [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[1;33m • [0mThe program will return [97;40mhello, name[0m in the terminal window regardless of what the user types.                                          
[1;33m • [0mFurther editing our code, you could type                                                                                               

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ")                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint("hello,")                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(name)                                                                                                                           [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[1;33m • [0mThe result in the terminal window would be                                                                                             

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34mWhat's your name? David                                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34mhello                                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34mDavid                                                                                                                                 [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[1;33m • [0mWe are getting closer to the result we might intend!                                                                                   
[1;33m • [0mYou can learn more in Python’s documentation on ]8;id=63668;https://docs.python.org/3/library/datatypes.html\[94mdata types[0m]8;;\ .                                                                           

                                                                                                                                          

Comments                                                                                                                                  

[1;33m • [0mComments are a way for programmers to track what they are doing in their programs and even inform others about their intentions for a  
[1;33m   [0mblock of code. In short, they are notes for yourself and others that will see your code!                                               
[1;33m • [0mYou can add comments to your program to be able to see what it is that your program is doing. You might edit your code as follows:     

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m# Ask the user for their name                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ")                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint("hello,")                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(name)                                                                                                                           [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[1;33m • [0mComments can also serve as to-do list for you.                                                                                         

                                                                                                                                          

Pseudocode                                                                                                                                

[1;33m • [0mPseudocode is an important type of comment that becomes a special type of to-do list, especially when you don’t understand how to      
[1;33m   [0maccomplish a coding task. For example, in your code, you might edit your code to say:                                                  

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m# Ask the user for their name                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ")                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Print hello                                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint("hello,")                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Print the name inputted                                                                                                             [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(name)                                                                                                                           [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m


                                               [1;4mFurther Improving Your First Python Program[0m                                                

[1;33m • [0mWe can further edit our code as follows:                                                                                               

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m# Ask the user for their name                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ")                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Print hello and the inputted name                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint("hello, " + name)                                                                                                               [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[1;33m • [0mIt turns out that some functions take many arguments.                                                                                  
[1;33m • [0mWe can use a comma [97;40m,[0m to pass in multiple arguments by editing our code as follows:                                                     

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m# Ask the user for their name                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ")                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Print hello and the inputted name                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint("hello,", name)                                                                                                                 [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

The output in the terminal, if we typed “David” we would be [97;40mhello, David[0m . Success.                                                       


                                                          [1;4mStrings and Paremeters[0m                                                          

[1;33m • [0mA string, known as a [97;40mstr[0m in Python, is a sequence of text.                                                                             
[1;33m • [0mRewinding a bit in our code back to the following, there was a visual side effect of having the result appear on multiple lines:       

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m# Ask the user for their name                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ")                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint("hello,")                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(name)                                                                                                                           [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[1;33m • [0mFunctions take arguments that influence their behavior. If we look at the documentation for ]8;id=622313;https://docs.python.org/3/library/functions.html#print\[97;40mprint[0m]8;;\ you’ll notice we can learn a lot     
[1;33m   [0mabout the arguments that the print function takes.                                                                                     
[1;33m • [0mLooking at this documentation, you’ll learn that the print function automatically include a piece of code [97;40mend='\n'. This[0m \n [97;40mindicates [0m 
[1;33m   [0m[97;40mthat the print function will automatically create a line break when run. The print function takes an argument called[0m end` and the      
[1;33m   [0mdefault is to create a new line.                                                                                                       
[1;33m • [0mHowever, we can technically provide an argument for [97;40mend[0m ourselves such that a new line is not created!                                 
[1;33m • [0mWe can modify our code as follows:                                                                                                     

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m# Ask the user for their name                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ")                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint("hello,", end="")                                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(name)                                                                                                                           [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

By providing [97;40mend=""[0m we are over-writing the default value of [97;40mend[0m such that it never creates a new line after this first print statement.  
Providing the name as “David”, the output in the terminal window will be [97;40mhello, David[0m .                                                   

[1;33m • [0mParameters, therefore, are arguments that can be taken by a function.                                                                  
[1;33m • [0mYou can learn more in Python’s documentation on ]8;id=299758;https://docs.python.org/3/library/functions.html#print\[97;40mprint[0m]8;;\ .                                                                                

                                                                                                                                          

A small problem with quotation marks                                                                                                      

[1;33m • [0mNotice how adding quotation marks as part of your string is challenging.                                                               
[1;33m • [0m[97;40mprint("hello,"friend"")[0m will not work and the compiler will throw an error.                                                            
[1;33m • [0mGenerally, there are two approaches to fixing this. First, you could simply change the quotes to single quote marks.                   
[1;33m • [0mAnother, more commonly used approach would be code as [97;40mprint("hello, \"friend\"")[0m . The backslashes tell the compiler that the following
[1;33m   [0mcharacter should be considered a quotation mark in the string and avoid a compiler error.                                              


                                                            [1;4mFormatting Strings[0m                                                            

[1;33m • [0mProbably the most elegant way to use strings would be as follows:                                                                      

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m# Ask the user for their name                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ")                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(f"hello, {name}")                                                                                                               [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

Notice the [97;40mf[0m in [97;40mprint(f"hello, {name}")[0m . This [97;40mf[0m is a special indicator to Python to treat this string a special way, different than      
previous approaches we have illustrated in this lecture. Expect that you will be using this style of strings quite frequently in this     
course.                                                                                                                                   


                                                             [1;4mMore on Strings[0m                                                              

[1;33m • [0mYou should never expect your user will cooperate as intended. Therefore, you will need to ensure that the input of your user is        
[1;33m   [0mcorrected or checked.                                                                                                                  
[1;33m • [0mIt turns out that built into strings is the ability to remove whitespace from a string.                                                
[1;33m • [0mBy utilizing the method [97;40mstrip[0m on [97;40mname[0m as [97;40mname = name.strip()[0m , it will strip all the whitespaces on the left and right of the users    
[1;33m   [0minput. You can modify your code to be:                                                                                                 

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m# Ask the user for their name                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ")                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Remove whitespace from the str                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = name.strip()                                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Print the output                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(f"hello, {name}")                                                                                                               [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

Rerunning this program, regardless of how many spaces you type before or after the name, it will strip off all the whitespace.            

[1;33m • [0mUsing the [97;40mtitle[0m method, it would title case the user’s name:                                                                           

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m# Ask the user for their name                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ")                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Remove whitespace from the str                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = name.strip()                                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Capitalize the first letter of each word                                                                                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = name.title()                                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Print the output                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(f"hello, {name}")                                                                                                               [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[1;33m • [0mBy this point, you might be very tired of typing [97;40mpython[0m repeatedly in the terminal window. You cause us the up arrow of your keyboard  
[1;33m   [0mto recall the most recent terminal commands you have made.                                                                             
[1;33m • [0mNotice that you can modify your code to be more efficient:                                                                             

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m# Ask the user for their name                                                                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ")                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Remove whitespace from the str and capitalize the first letter of each word                                                         [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = name.strip().title()                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Print the output                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(f"hello, {name}")                                                                                                               [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

This creates the same result as your previous code.                                                                                       

[1;33m • [0mWe could even go further!                                                                                                              

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m# Ask the user for their name, remove whitespace from the str and capitalize the first letter of each word                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ").strip().title()                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Print the output                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(f"hello, {name}")                                                                                                               [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[1;33m • [0mYou can learn more about strings in Python’s documentation on ]8;id=14575;https://docs.python.org/3/library/stdtypes.html#str\[97;40mstr[0m]8;;\                                                                      


                                                             [1;4mIntegers or int[0m                                                              

[1;33m • [0mIn Python, an integer is referred to as an [97;40mint[0m .                                                                                       
[1;33m • [0mIn the world of mathematics, we are familiar with +, -, *, /, and % operators. That last operator [97;40m%[0m or modulo operator may not be very 
[1;33m   [0mfamiliar to you.                                                                                                                       
[1;33m • [0mYou don’t have to use the text editor window in your compiler to run Python code. Down in your terminal, you can run [97;40mpython[0m alone. You 
[1;33m   [0mwill be presented with [97;40m>>>[0m in the terminal window. You can then run live, interactive code. You could type [97;40m1+1[0m and it will run that    
[1;33m   [0mcalculation. This mode will not commonly be used during this course.                                                                   
[1;33m • [0mOpening up VS Code again, we can type [97;40mcode calculator.py[0m in the terminal. This will create a new file in which we will create our own  
[1;33m   [0mcalculator.                                                                                                                            
[1;33m • [0mFirst, we can declare a few variables.                                                                                                 

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34mx = 1                                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34my = 2                                                                                                                                 [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mz = x + y                                                                                                                             [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(z)                                                                                                                              [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

Naturally, when we run [97;40mpython calculator.py[0m we get the result in the terminal window of [97;40m3[0m . We can make this more interactive using the   
[97;40minput[0m function.                                                                                                                           

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34mx = input("What's x? ")                                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34my = input("What's y? ")                                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mz = x + y                                                                                                                             [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(z)                                                                                                                              [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

[1;33m • [0mRunning this program, we discover that the output is incorrect as [97;40m12[0m . Why might this be?                                              
[1;33m • [0mPrior, we have seen how the [97;40m+[0m sign concatenates two strings. Because your input from your keyboard on your computer comes into the     
[1;33m   [0mcompiler as text, it is treated a string. We, therefore, need to convert this input from a string to an integer. We can do so as       
[1;33m   [0mfollows:                                                                                                                               

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34mx = input("What's x? ")                                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34my = input("What's y? ")                                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mz = int(x) + int(y)                                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(z)                                                                                                                              [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

The result is now correct. The use of [97;40mint(x)[0m , is called “casting” where a value is temporarily changed from one type of variable (in this
case a string) to another (here, an integer).                                                                                             

[1;33m • [0mWe can further improve our program as follows:                                                                                         

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34mx = int(input("What's x? "))                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34my = int(input("What's y? "))                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(x + y)                                                                                                                          [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

This illustrates that you can run functions on functions. The most inner function is run first, and then the outer one is run. First, the 
[97;40minput[0m function is run. Then, the [97;40mint[0m function.                                                                                            

[1;33m • [0mYou can learn more in Python’s Documenation of ]8;id=667880;https://docs.python.org/3/library/functions.html?highlight=float#int\[97;40mint[0m]8;;\ .                                                                                   


                                                             [1;4mReadability Wins[0m                                                             

[1;33m • [0mWhen deciding on your approach to a coding task, remember that one could make a reasonable argument for many approaches to the same    
[1;33m   [0mproblem.                                                                                                                               
[1;33m • [0mRegardless of what approach you take to a programming task, remember that your code must be readable. You should use comments to give  
[1;33m   [0myourself and others clues about what your code is doing. Further, you should create code in a way that is readable.                    


                                                               [1;4mFloat Basics[0m                                                               

[1;33m • [0mA floating point value is a real number that has a decimal point in it, such as [97;40m0.52[0m .                                                 
[1;33m • [0mYou can change your code to support floats as follows:                                                                                 

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34mx = float(input("What's x? "))                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34my = float(input("What's y? "))                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(x + y)                                                                                                                          [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

This change allows your user to enter [97;40m1.2[0m and [97;40m3.4[0m to present a total of [97;40m4.6[0m .                                                             

[1;33m • [0mLet’s imagine, however, that you want to round the total to the nearest integer. Looking at the Python documentation for [97;40mround[0m you’ll  
[1;33m   [0msee that the available arguments are [97;40mround(number[n, ndigits])[0m . Those square brackets indicate that something optional can be         
[1;33m   [0mspecified by the programmer. Therefore, you could do [97;40mround(n)[0m to round a digit to its nearest integer. Alternatively, you could code as
[1;33m   [0mfollows:                                                                                                                               

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m# Get the user's input                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34mx = float(input("What's x? "))                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34my = float(input("What's y? "))                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Create a rounded result                                                                                                             [0m [2m│[0m
[2m│[0m [48;2;39;40;34mz = round(x + y)                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Print the result                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(z)                                                                                                                              [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

The output will be rounded to the nearest integer.                                                                                        

[1;33m • [0mWhat if we wanted to format the output of long numbers? For example, rather than seeing [97;40m1000[0m , you may wish to see [97;40m1,000[0m . You could   
[1;33m   [0mmodify your code as follows:                                                                                                           

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m# Get the user's input                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34mx = float(input("What's x? "))                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34my = float(input("What's y? "))                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Create a rounded result                                                                                                             [0m [2m│[0m
[2m│[0m [48;2;39;40;34mz = round(x + y)                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Print the formatted result                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(f"{z:,}")                                                                                                                       [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

Though quite cryptic, that [97;40mprint(f"{z:,}")[0m creates a scenario where the outputted [97;40mz[0m will include commas where the result could look like  
[97;40m1,000[0m or [97;40m2,500[0m .                                                                                                                          


                                                              [1;4mMore on Floats[0m                                                              

[1;33m • [0mHow can we round floating point values? First, modify your code as follows:                                                            

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m# Get the user's input                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34mx = float(input("What's x? "))                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34my = float(input("What's y? "))                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Calculate the result                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34mz = x / y                                                                                                                             [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Print the result                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(z)                                                                                                                              [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

When inputting [97;40m2[0m as x and [97;40m3[0m as y, the result z is [97;40m0.6666666666[0m seemingly going on to infinite as we might expect.                         

[1;33m • [0mLet’s imagine that we want to round this down, we could modify our code as follows:                                                    

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m# Get the user's input                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34mx = float(input("What's x? "))                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34my = float(input("What's y? "))                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Calculate the result and round                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mz = round(x / y, 2)                                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Print the result                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(z)                                                                                                                              [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

As we might expect, this will round the result to the nearest two decimal points.                                                         

[1;33m • [0mWe could also use [97;40mfstring[0m to format the output as follows:                                                                             

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m# Get the user's input                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34mx = float(input("What's x? "))                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34my = float(input("What's y? "))                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Calculate the result                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34mz = x / y                                                                                                                             [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Print the result                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(f"{z:.2f}")                                                                                                                     [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

This cryptic [97;40mfstring[0m code displays the same as our prior rounding strategy.                                                               

[1;33m • [0mYou can learn more in Python’s documentation of ]8;id=197056;https://docs.python.org/3/library/functions.html?highlight=float#float\[97;40mfloat[0m]8;;\ .                                                                                


                                                                   [1;4mDef[0m                                                                    

[1;33m • [0mWouldn’t it be nice to create our own functions?                                                                                       
[1;33m • [0mLet’s bring back our final code of [97;40mhello.py[0m by typing [97;40mcode hello.py[0m into the terminal window. Your starting code should look as        
[1;33m   [0mfollows:                                                                                                                               

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m# Ask the user for their name, remove whitespace from the str and capitalize the first letter of each word                            [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ").strip().title()                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Print the output                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(f"hello, {name}")                                                                                                               [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

We can better our code to create our own special function that says “hello” for us!                                                       

[1;33m • [0mErasing all our code in our text editor, let’s start from scratch:                                                                     

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ")                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mhello()                                                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(name)                                                                                                                           [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

Attempting to run this code, your compiler will throw an error. After all, there is no defined function for [97;40mhello[0m .                       

[1;33m • [0mWe can create our own function called [97;40mhello[0m as follows:                                                                                

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34mdef hello():                                                                                                                          [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    print("hello")                                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ")                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mhello()                                                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34mprint(name)                                                                                                                           [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

Notice that everything under [97;40mdef hello()[0m is indented. Python is an indented language. It uses indentation to understand what is part of   
the above function. Therefore, everything in the [97;40mhello[0m function must be indented. When something is not indented, it treats it as if it is
not inside the [97;40mhello[0m function. Running [97;40mpython hello.py[0m in the terminal window, you’ll see that your output is not exactly as you may want.

[1;33m • [0mWe can further improve our code:                                                                                                       

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Create our own function                                                                                                             [0m [2m│[0m
[2m│[0m [48;2;39;40;34mdef hello(to):                                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    print("hello,", to)                                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Output using our own function                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ")                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mhello(name)                                                                                                                           [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

Here, in the first lines, you are creating your [97;40mhello[0m function. This time, however, you are telling the compiler that this function takes 
a single parameter: a variable called [97;40mto[0m . Therefore, when you call [97;40mhello(name)[0m the computer passes [97;40mname[0m into the [97;40mhello[0m function as [97;40mto[0m .  
This is how we pass values into functions. Very useful! Running [97;40mpython hello.py[0m in the terminal window, you’ll see that the output is much
closer to our ideal presented earlier in this lecture.                                                                                    

[1;33m • [0mWe can change our code to add a default value to [97;40mhello[0m :                                                                               

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34m# Create our own function                                                                                                             [0m [2m│[0m
[2m│[0m [48;2;39;40;34mdef hello(to="world"):                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    print("hello,", to)                                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Output using our own function                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34mname = input("What's your name? ")                                                                                                    [0m [2m│[0m
[2m│[0m [48;2;39;40;34mhello(name)                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Output without passing the expected arguments                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34mhello()                                                                                                                               [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

Test out your code yourself. Notice how the first [97;40mhello[0m will behave as you might expect and the second hello, which is not passed a value,
will by default output [97;40mhello, world[0m .                                                                                                     

[1;33m • [0mWe don’t have to have our function at the start of our program. We can move it down, but we need to tell the compiler that we have a   
[1;33m   [0m[97;40mmain[0m function and we have a separate [97;40mhello[0m function.                                                                                   

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34mdef main():                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    # Output using our own function                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    name = input("What's your name? ")                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    hello(name)                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    # Output without passing the expected arguments                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    hello()                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Create our own function                                                                                                             [0m [2m│[0m
[2m│[0m [48;2;39;40;34mdef hello(to="world"):                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    print("hello,", to)                                                                                                               [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

This alone, however, will create an error of sorts. If we run [97;40mpython hello.py[0m nothing happens! The reason for this is that nothing in this
code is actually calling the [97;40mmain[0m function and bringing our program to life.                                                              

[1;33m • [0mThe following very small modification will call the [97;40mmain[0m function and restore our program to working order:                            

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34mdef main():                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    # Output using our own function                                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    name = input("What's your name? ")                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    hello(name)                                                                                                                       [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    # Output without passing the expected arguments                                                                                   [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    hello()                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m# Create our own function                                                                                                             [0m [2m│[0m
[2m│[0m [48;2;39;40;34mdef hello(to="world"):                                                                                                                [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    print("hello,", to)                                                                                                               [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mmain()                                                                                                                                [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m


                                                             [1;4mReturning Values[0m                                                             

[1;33m • [0mYou can imagine many scenarios where you don’t just want a function to perform an action, but also to return a value back to the main  
[1;33m   [0mfunction. For example, rather than simply printing the calculation of [97;40mx + y[0m , you may want a function to return the value of this      
[1;33m   [0mcalculation back to another part of your program. This “passing back” of a value we call a [97;40mreturn[0m value.                               
[1;33m • [0mReturning to our [97;40mcalculator.py[0m code by typing [97;40mcode calculator.py[0m . Erase all code there. Rework the code as follows:                   

[2m┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐[0m
[2m│[0m [48;2;39;40;34mdef main():                                                                                                                           [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    x = int(input("What's x? "))                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    print("x squared is", square(x))                                                                                                  [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mdef square(n):                                                                                                                        [0m [2m│[0m
[2m│[0m [48;2;39;40;34m    return n \* n                                                                                                                     [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34m                                                                                                                                      [0m [2m│[0m
[2m│[0m [48;2;39;40;34mmain()                                                                                                                                [0m [2m│[0m
[2m└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘[0m

Effectively, [97;40mx[0m is passed to [97;40msquare[0m . Then, the calculation of [97;40mx * x[0m is returned back to the main function.                                


                                                                [1;4mSumming Up[0m                                                                

Through the work of this single lecture, you have learned abilities that you will use countless times in your own programs. You have      
learned about…                                                                                                                            

[1;33m • [0mCreating your first programs in Python;                                                                                                
[1;33m • [0mFunctions;                                                                                                                             
[1;33m • [0mBugs;                                                                                                                                  
[1;33m • [0mVariables;                                                                                                                             
[1;33m • [0mComments;                                                                                                                              
[1;33m • [0mPseudocode;                                                                                                                            
[1;33m • [0mStrings;                                                                                                                               
[1;33m • [0mParameters;                                                                                                                            
[1;33m • [0mFormatted Strings;                                                                                                                     
[1;33m • [0mIntegers;                                                                                                                              
[1;33m • [0mPrinciples of readability;                                                                                                             
[1;33m • [0mFloats;                                                                                                                                
[1;33m • [0mCreating your own functions; and                                                                                                       
[1;33m • [0mReturn values.                                                                                                                         
