/**
 * Too many naming conventions?
 *
 * @stability stable
 */
export declare enum Format {
    /**
     * @stability stable
     */
    KEBAB = "kebab",
    /**
     * @stability stable
     */
    PASCAL = "pascal",
    /**
     * @stability stable
     */
    SNAKE = "snake",
    /**
     * @stability stable
     */
    CAMEL = "camel"
}
/**
 * @stability stable
 */
export interface NamerProps {
    /**
     * Characters to strip from name parts.
     *
     * @default '-_'
     * @stability stable
     */
    readonly deleteCharacters?: string;
    /**
     * Characters which will cause an error if included in a name part tested AFTER deleteCharacters.
     *
     * @default '!
     * @stability stable
     * @todo implement me
     * @ #$%^&*()~`"' maybe more??? needs thought. Should be DNS compliant, I think.
     */
    readonly illegalCharacters?: string;
    /**
     * How long can the name be?
     *
     * @default - no limit
     * @stability stable
     */
    readonly maxLength?: number;
    /**
     * If the name exceeds maxLength, should I snip the head or the tail?
     *
     * @default false
     * @stability stable
     */
    readonly maxLengthTruncateHead?: boolean;
    /**
     * How long can a part of the name be?
     *
     * @default - no limit
     * @stability stable
     */
    readonly maxPartLength?: number;
    /**
     * If the part exceeds maxPartLength, should I snip the head or the tail?
     *
     * @default false
     * @stability stable
     */
    readonly maxPartLengthTruncateHead?: boolean;
    /**
     * When using toString(), which format should be provided?
     *
     * @default - raise an error if no default specified and toString invoked
     * @stability stable
     */
    readonly defaultFormat?: Format;
    /**
     * Include a uniquifying suffix?
     *
     * If so, this is the seed for that suffix.
     *
     * @default - do not include a uniquifier
     * @stability stable
     */
    readonly uniqueSeed?: any;
}
/**
 * @stability stable
 */
export declare class Namer {
    /**
     * @stability stable
     */
    readonly parts: string[];
    private _parts;
    private _camel?;
    private _kebab?;
    private _pascal?;
    private _snake?;
    private _unique?;
    /**
     * @stability stable
     */
    readonly props?: NamerProps;
    /**
     * Create a namer.
     *
     * @param parts an array of strings to be composed into a name.
     * @param props modify the behavior of namer.
     * @stability stable
     */
    constructor(parts: string[], props?: NamerProps);
    private splitParts;
    /**
     * @stability stable
     */
    get partsWithUnique(): string[];
    /**
     * @stability stable
     */
    enforceMaxLength(raw: string): string;
    /**
     * camelCase.
     *
     * @stability stable
     */
    get camel(): string;
    /**
     * kebab-case.
     *
     * @stability stable
     */
    get kebab(): string;
    /**
     * PascalCase.
     *
     * @stability stable
     */
    get pascal(): string;
    /**
     * snake_case.
     *
     * @stability stable
     */
    get snake(): string;
    /**
     * Create a new Namer with the added prefix.
     *
     * @param prefix the prefix to add.
     * @param props properties to over-ride the parent props.
     * @stability stable
     */
    addPrefix(prefix: Namer | string[], props?: NamerProps): Namer;
    /**
     * Create a new Namer with the added suffix.
     *
     * @param suffix the suffix to add.
     * @param props properties to over-ride the parent props.
     * @stability stable
     */
    addSuffix(suffix: Namer | string[], props?: NamerProps): Namer;
    /**
     * Create a new Namer with a unique suffix.
     *
     * @param uniqueItem : any value to use as the seed for generating a unique hash.
     * @stability stable
     */
    unique(uniqueItem: any): Namer;
    /**
     * @stability stable
     */
    toString(): string;
}
