/// autogenerated analytical inverse kinematics code from ikfast program part of OpenRAVE
/// \author Rosen Diankov
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///     http://www.apache.org/licenses/LICENSE-2.0
/// 
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// ikfast version 0x10000049 generated on 2019-09-26 13:20:29.249476
/// To compile with gcc:
///     gcc -lstdc++ ik.cpp
/// To compile without any main function as a shared object (might need -llapack):
///     gcc -fPIC -lstdc++ -DIKFAST_NO_MAIN -DIKFAST_CLIBRARY -shared -Wl,-soname,libik.so -o libik.so ik.cpp
#define IKFAST_HAS_LIBRARY
#include "ikfast.h" // found inside share/openrave-X.Y/python/ikfast.h
using namespace ikfast;

// check if the included ikfast version matches what this file was compiled with
#define IKFAST_COMPILE_ASSERT(x) extern int __dummy[(int)x]
IKFAST_COMPILE_ASSERT(IKFAST_VERSION==0x10000049);

#include <cmath>
#include <vector>
#include <limits>
#include <algorithm>
#include <complex>

#ifndef IKFAST_ASSERT
#include <stdexcept>
#include <sstream>
#include <iostream>

#ifdef _MSC_VER
#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __FUNCDNAME__
#endif
#endif

#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __func__
#endif

#define IKFAST_ASSERT(b) { if( !(b) ) { std::stringstream ss; ss << "ikfast exception: " << __FILE__ << ":" << __LINE__ << ": " <<__PRETTY_FUNCTION__ << ": Assertion '" << #b << "' failed"; throw std::runtime_error(ss.str()); } }

#endif

#if defined(_MSC_VER)
#define IKFAST_ALIGNED16(x) __declspec(align(16)) x
#else
#define IKFAST_ALIGNED16(x) x __attribute((aligned(16)))
#endif

#define IK2PI  ((IkReal)6.28318530717959)
#define IKPI  ((IkReal)3.14159265358979)
#define IKPI_2  ((IkReal)1.57079632679490)

#ifdef _MSC_VER
#ifndef isnan
#define isnan _isnan
#endif
#ifndef isinf
#define isinf _isinf
#endif
//#ifndef isfinite
//#define isfinite _isfinite
//#endif
#endif // _MSC_VER

// lapack routines
extern "C" {
  void dgetrf_ (const int* m, const int* n, double* a, const int* lda, int* ipiv, int* info);
  void zgetrf_ (const int* m, const int* n, std::complex<double>* a, const int* lda, int* ipiv, int* info);
  void dgetri_(const int* n, const double* a, const int* lda, int* ipiv, double* work, const int* lwork, int* info);
  void dgesv_ (const int* n, const int* nrhs, double* a, const int* lda, int* ipiv, double* b, const int* ldb, int* info);
  void dgetrs_(const char *trans, const int *n, const int *nrhs, double *a, const int *lda, int *ipiv, double *b, const int *ldb, int *info);
  void dgeev_(const char *jobvl, const char *jobvr, const int *n, double *a, const int *lda, double *wr, double *wi,double *vl, const int *ldvl, double *vr, const int *ldvr, double *work, const int *lwork, int *info);
}

using namespace std; // necessary to get std math routines

#ifdef IKFAST_NAMESPACE
namespace IKFAST_NAMESPACE {
#endif

inline float IKabs(float f) { return fabsf(f); }
inline double IKabs(double f) { return fabs(f); }

inline float IKsqr(float f) { return f*f; }
inline double IKsqr(double f) { return f*f; }

inline float IKlog(float f) { return logf(f); }
inline double IKlog(double f) { return log(f); }

// allows asin and acos to exceed 1. has to be smaller than thresholds used for branch conds and evaluation
#ifndef IKFAST_SINCOS_THRESH
#define IKFAST_SINCOS_THRESH ((IkReal)1e-7)
#endif

// used to check input to atan2 for degenerate cases. has to be smaller than thresholds used for branch conds and evaluation
#ifndef IKFAST_ATAN2_MAGTHRESH
#define IKFAST_ATAN2_MAGTHRESH ((IkReal)1e-7)
#endif

// minimum distance of separate solutions
#ifndef IKFAST_SOLUTION_THRESH
#define IKFAST_SOLUTION_THRESH ((IkReal)1e-6)
#endif

// there are checkpoints in ikfast that are evaluated to make sure they are 0. This threshold speicfies by how much they can deviate
#ifndef IKFAST_EVALCOND_THRESH
#define IKFAST_EVALCOND_THRESH ((IkReal)0.00001)
#endif


inline float IKasin(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(-IKPI_2);
else if( f >= 1 ) return float(IKPI_2);
return asinf(f);
}
inline double IKasin(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return -IKPI_2;
else if( f >= 1 ) return IKPI_2;
return asin(f);
}

// return positive value in [0,y)
inline float IKfmod(float x, float y)
{
    while(x < 0) {
        x += y;
    }
    return fmodf(x,y);
}

// return positive value in [0,y)
inline double IKfmod(double x, double y)
{
    while(x < 0) {
        x += y;
    }
    return fmod(x,y);
}

inline float IKacos(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(IKPI);
else if( f >= 1 ) return float(0);
return acosf(f);
}
inline double IKacos(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return IKPI;
else if( f >= 1 ) return 0;
return acos(f);
}
inline float IKsin(float f) { return sinf(f); }
inline double IKsin(double f) { return sin(f); }
inline float IKcos(float f) { return cosf(f); }
inline double IKcos(double f) { return cos(f); }
inline float IKtan(float f) { return tanf(f); }
inline double IKtan(double f) { return tan(f); }
inline float IKsqrt(float f) { if( f <= 0.0f ) return 0.0f; return sqrtf(f); }
inline double IKsqrt(double f) { if( f <= 0.0 ) return 0.0; return sqrt(f); }
inline float IKatan2Simple(float fy, float fx) {
    return atan2f(fy,fx);
}
inline float IKatan2(float fy, float fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return float(IKPI_2);
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2f(fy,fx);
}
inline double IKatan2Simple(double fy, double fx) {
    return atan2(fy,fx);
}
inline double IKatan2(double fy, double fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return IKPI_2;
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2(fy,fx);
}

template <typename T>
struct CheckValue
{
    T value;
    bool valid;
};

template <typename T>
inline CheckValue<T> IKatan2WithCheck(T fy, T fx, T epsilon)
{
    CheckValue<T> ret;
    ret.valid = false;
    ret.value = 0;
    if( !isnan(fy) && !isnan(fx) ) {
        if( IKabs(fy) >= IKFAST_ATAN2_MAGTHRESH || IKabs(fx) > IKFAST_ATAN2_MAGTHRESH ) {
            ret.value = IKatan2Simple(fy,fx);
            ret.valid = true;
        }
    }
    return ret;
}

inline float IKsign(float f) {
    if( f > 0 ) {
        return float(1);
    }
    else if( f < 0 ) {
        return float(-1);
    }
    return 0;
}

inline double IKsign(double f) {
    if( f > 0 ) {
        return 1.0;
    }
    else if( f < 0 ) {
        return -1.0;
    }
    return 0;
}

template <typename T>
inline CheckValue<T> IKPowWithIntegerCheck(T f, int n)
{
    CheckValue<T> ret;
    ret.valid = true;
    if( n == 0 ) {
        ret.value = 1.0;
        return ret;
    }
    else if( n == 1 )
    {
        ret.value = f;
        return ret;
    }
    else if( n < 0 )
    {
        if( f == 0 )
        {
            ret.valid = false;
            ret.value = (T)1.0e30;
            return ret;
        }
        if( n == -1 ) {
            ret.value = T(1.0)/f;
            return ret;
        }
    }

    int num = n > 0 ? n : -n;
    if( num == 2 ) {
        ret.value = f*f;
    }
    else if( num == 3 ) {
        ret.value = f*f*f;
    }
    else {
        ret.value = 1.0;
        while(num>0) {
            if( num & 1 ) {
                ret.value *= f;
            }
            num >>= 1;
            f *= f;
        }
    }
    
    if( n < 0 ) {
        ret.value = T(1.0)/ret.value;
    }
    return ret;
}

/// solves the forward kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API void ComputeFk(const IkReal* j, IkReal* eetrans, IkReal* eerot) {
IkReal x0,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,x21,x22,x23,x24,x25,x26,x27,x28,x29,x30,x31,x32,x33,x34,x35,x36,x37,x38,x39,x40,x41,x42,x43,x44,x45,x46,x47,x48,x49,x50,x51,x52,x53,x54,x55,x56,x57,x58,x59,x60,x61,x62,x63,x64,x65,x66,x67,x68,x69,x70;
x0=IKcos(j[0]);
x1=IKcos(j[1]);
x2=IKsin(j[2]);
x3=IKcos(j[2]);
x4=IKsin(j[0]);
x5=IKcos(j[3]);
x6=IKsin(j[1]);
x7=IKsin(j[3]);
x8=IKsin(j[4]);
x9=IKcos(j[4]);
x10=IKcos(j[6]);
x11=IKsin(j[6]);
x12=IKsin(j[5]);
x13=IKcos(j[5]);
x14=((0.088)*x8);
x15=((0.0825)*x3);
x16=((1.0)*x13);
x17=((1.0)*x7);
x18=((1.0)*x4);
x19=((0.0825)*x4);
x20=((0.107)*x7);
x21=((0.384)*x3);
x22=((0.088)*x7);
x23=((0.384)*x4);
x24=((1.0)*x3);
x25=((0.088)*x9);
x26=((0.316)*x6);
x27=((0.107)*x9);
x28=((0.107)*x8);
x29=((1.0)*x12);
x30=(x5*x6);
x31=(x6*x7);
x32=(x0*x1);
x33=(x0*x2);
x34=(x1*x5);
x35=(x1*x3);
x36=(x0*x3);
x37=(x1*x7);
x38=(x2*x6);
x39=(x18*x2);
x40=(x19*x2);
x41=((0.0825)*x33);
x42=(x38*x8);
x43=(x15*x32);
x44=(x1*x39);
x45=(x1*x15*x4);
x46=((((-1.0)*x44))+x36);
x47=(x37+(((-1.0)*x24*x30)));
x48=(((x3*x31))+x34);
x49=(x39+(((-1.0)*x24*x32)));
x50=(((x18*x3))+(((1.0)*x2*x32)));
x51=((-1.0)*x50);
x52=((((-1.0)*x33))+(((-1.0)*x18*x35)));
x53=(x45+x41);
x54=(x12*x48);
x55=(x46*x8);
x56=(x52*x7);
x57=(x51*x8);
x58=(((x5*(((((-1.0)*x39))+((x3*x32))))))+((x0*x31)));
x59=(((x31*x4))+((x5*((((x35*x4))+x33)))));
x60=(((x47*x9))+x42);
x61=(((x49*x7))+((x0*x30)));
x62=(((x47*x8))+(((-1.0)*x38*x9)));
x63=(((x30*x4))+x56);
x64=(x58*x9);
x65=(x59*x9);
x66=(x12*x61);
x67=(x55+x65);
x68=(((x59*x8))+((x9*(((((-1.0)*x0*x24))+x44)))));
x69=(((x50*x9))+((x58*x8)));
x70=(x57+x64);
eerot[0]=(((x10*((x66+((x13*x70))))))+((x11*x69)));
eerot[1]=(((x10*x69))+((x11*(((((-1.0)*x29*x61))+(((-1.0)*x16*x70)))))));
eerot[2]=(((x13*(((((-1.0)*x0*x30))+(((-1.0)*x17*x49))))))+((x12*x70)));
IkReal x71=(x0*x30);
eetrans[0]=((((-1.0)*x40))+((x12*((((x27*x58))+((x28*x51))))))+((x0*x26))+((x13*((((x14*x51))+((x25*x58))))))+((x13*(((((-1.0)*x20*x49))+(((-0.107)*x71))))))+(((-0.0825)*x0*x31))+((x7*((((x2*x23))+(((-1.0)*x21*x32))))))+((x12*(((((0.088)*x71))+((x22*x49))))))+x43+(((0.384)*x71))+((x5*(((((-1.0)*x43))+x40)))));
eerot[3]=(((x11*x68))+((x10*((((x12*x63))+((x13*x67)))))));
eerot[4]=(((x11*(((((-1.0)*x29*x63))+(((-1.0)*x16*x67))))))+((x10*x68)));
eerot[5]=(((x12*x67))+((x13*(((((-1.0)*x18*x30))+(((-1.0)*x17*x52)))))));
IkReal x72=(x30*x4);
eetrans[1]=((((-1.0)*x5*x53))+((x23*x30))+((x12*(((((0.088)*x72))+((x22*x52))))))+((x7*(((((-1.0)*x1*x21*x4))+(((-0.384)*x33))))))+((x12*((((x27*x59))+((x28*x46))))))+((x13*(((((-1.0)*x20*x52))+(((-0.107)*x72))))))+((x13*((((x14*x46))+((x25*x59))))))+(((-1.0)*x19*x31))+x53+((x26*x4)));
eerot[6]=(((x10*((((x13*x60))+x54))))+((x11*x62)));
eerot[7]=(((x10*x62))+((x11*(((((-1.0)*x29*x48))+(((-1.0)*x16*x60)))))));
eerot[8]=(((x12*x60))+((x13*(((((-1.0)*x34))+(((-1.0)*x17*x3*x6)))))));
IkReal x73=(x3*x6);
eetrans[2]=((0.333)+((x12*(((((0.088)*x34))+((x22*x73))))))+((x13*((((x14*x38))+((x25*x47))))))+((x21*x31))+((x12*((((x27*x47))+((x28*x38))))))+((x15*x30))+((x13*(((((-1.0)*x20*x73))+(((-0.107)*x34))))))+(((0.384)*x34))+(((-0.0825)*x37))+(((0.316)*x1))+(((-1.0)*x15*x6)));
}

IKFAST_API int GetNumFreeParameters() { return 1; }
IKFAST_API int* GetFreeParameters() { static int freeparams[] = {6}; return freeparams; }
IKFAST_API int GetNumJoints() { return 7; }

IKFAST_API int GetIkRealSize() { return sizeof(IkReal); }

IKFAST_API int GetIkType() { return 0x67000001; }

class IKSolver {
public:
IkReal j0,cj0,sj0,htj0,j0mul,j1,cj1,sj1,htj1,j1mul,j2,cj2,sj2,htj2,j2mul,j3,cj3,sj3,htj3,j3mul,j4,cj4,sj4,htj4,j4mul,j5,cj5,sj5,htj5,j5mul,j6,cj6,sj6,htj6,new_r00,r00,rxp0_0,new_r01,r01,rxp0_1,new_r02,r02,rxp0_2,new_r10,r10,rxp1_0,new_r11,r11,rxp1_1,new_r12,r12,rxp1_2,new_r20,r20,rxp2_0,new_r21,r21,rxp2_1,new_r22,r22,rxp2_2,new_px,px,npx,new_py,py,npy,new_pz,pz,npz,pp;
unsigned char _ij0[2], _nj0,_ij1[2], _nj1,_ij2[2], _nj2,_ij3[2], _nj3,_ij4[2], _nj4,_ij5[2], _nj5,_ij6[2], _nj6;

IkReal j100, cj100, sj100;
unsigned char _ij100[2], _nj100;
bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
j0=numeric_limits<IkReal>::quiet_NaN(); _ij0[0] = -1; _ij0[1] = -1; _nj0 = -1; j1=numeric_limits<IkReal>::quiet_NaN(); _ij1[0] = -1; _ij1[1] = -1; _nj1 = -1; j2=numeric_limits<IkReal>::quiet_NaN(); _ij2[0] = -1; _ij2[1] = -1; _nj2 = -1; j3=numeric_limits<IkReal>::quiet_NaN(); _ij3[0] = -1; _ij3[1] = -1; _nj3 = -1; j4=numeric_limits<IkReal>::quiet_NaN(); _ij4[0] = -1; _ij4[1] = -1; _nj4 = -1; j5=numeric_limits<IkReal>::quiet_NaN(); _ij5[0] = -1; _ij5[1] = -1; _nj5 = -1;  _ij6[0] = -1; _ij6[1] = -1; _nj6 = 0; 
for(int dummyiter = 0; dummyiter < 1; ++dummyiter) {
    solutions.Clear();
j6=pfree[0]; cj6=cos(pfree[0]); sj6=sin(pfree[0]), htj6=tan(pfree[0]*0.5);
r00 = eerot[0*3+0];
r01 = eerot[0*3+1];
r02 = eerot[0*3+2];
r10 = eerot[1*3+0];
r11 = eerot[1*3+1];
r12 = eerot[1*3+2];
r20 = eerot[2*3+0];
r21 = eerot[2*3+1];
r22 = eerot[2*3+2];
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];

new_r00=r00;
new_r01=r01;
new_r02=r02;
new_px=(px+(((-0.107)*r02)));
new_r10=r10;
new_r11=r11;
new_r12=r12;
new_py=((((-0.107)*r12))+py);
new_r20=r20;
new_r21=r21;
new_r22=r22;
new_pz=((-0.333)+pz+(((-0.107)*r22)));
r00 = new_r00; r01 = new_r01; r02 = new_r02; r10 = new_r10; r11 = new_r11; r12 = new_r12; r20 = new_r20; r21 = new_r21; r22 = new_r22; px = new_px; py = new_py; pz = new_pz;
IkReal x74=((1.0)*px);
IkReal x75=((1.0)*pz);
IkReal x76=((1.0)*py);
pp=((px*px)+(py*py)+(pz*pz));
npx=(((px*r00))+((py*r10))+((pz*r20)));
npy=(((px*r01))+((py*r11))+((pz*r21)));
npz=(((px*r02))+((py*r12))+((pz*r22)));
rxp0_0=((((-1.0)*r20*x76))+((pz*r10)));
rxp0_1=(((px*r20))+(((-1.0)*r00*x75)));
rxp0_2=((((-1.0)*r10*x74))+((py*r00)));
rxp1_0=((((-1.0)*r21*x76))+((pz*r11)));
rxp1_1=(((px*r21))+(((-1.0)*r01*x75)));
rxp1_2=(((py*r01))+(((-1.0)*r11*x74)));
rxp2_0=((((-1.0)*r22*x76))+((pz*r12)));
rxp2_1=(((px*r22))+(((-1.0)*r02*x75)));
rxp2_2=(((py*r02))+(((-1.0)*r12*x74)));
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
if( (((0.986881610513004)+(((-3.89793688895078)*pp))+(((0.686036892455338)*cj6*npx))+(((-0.686036892455338)*npy*sj6)))) < -1-IKFAST_SINCOS_THRESH || (((0.986881610513004)+(((-3.89793688895078)*pp))+(((0.686036892455338)*cj6*npx))+(((-0.686036892455338)*npy*sj6)))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x77=IKasin(((0.986881610513004)+(((-3.89793688895078)*pp))+(((0.686036892455338)*cj6*npx))+(((-0.686036892455338)*npy*sj6))));
j3array[0]=((1.10379390314189)+(((1.0)*x77)));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
j3array[1]=((4.24538655673168)+(((-1.0)*x77)));
sj3array[1]=IKsin(j3array[1]);
cj3array[1]=IKcos(j3array[1]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
if( j3array[1] > IKPI )
{
    j3array[1]-=IK2PI;
}
else if( j3array[1] < -IKPI )
{    j3array[1]+=IK2PI;
}
j3valid[1] = true;
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];

{
IkReal j5eval[2];
IkReal x78=(cj6*npx);
IkReal x79=(npy*sj6);
j5eval[0]=((1.0)+(((129.132231404959)*(x78*x78)))+(((22.7272727272727)*x79))+(((129.132231404959)*(x79*x79)))+(((-258.264462809917)*x78*x79))+(((129.132231404959)*(npz*npz)))+(((-22.7272727272727)*x78)));
j5eval[1]=((IKabs(((0.088)+x79+(((-1.0)*x78)))))+(IKabs(npz)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j4eval[1];
j4eval[0]=((-1.0)+cj3+(((3.83030303030303)*sj3)));
if( IKabs(j4eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-2.63084142381503)+j3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j4array[2], cj4array[2], sj4array[2];
bool j4valid[2]={false};
_nj4 = 2;
sj4array[0]=((((-2597402597.4026)*npx*sj6))+(((-2597402597.4026)*cj6*npy)));
if( sj4array[0] >= -1-IKFAST_SINCOS_THRESH && sj4array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j4valid[0] = j4valid[1] = true;
    j4array[0] = IKasin(sj4array[0]);
    cj4array[0] = IKcos(j4array[0]);
    sj4array[1] = sj4array[0];
    j4array[1] = j4array[0] > 0 ? (IKPI-j4array[0]) : (-IKPI-j4array[0]);
    cj4array[1] = -cj4array[0];
}
else if( isnan(sj4array[0]) )
{
    // probably any value will work
    j4valid[0] = true;
    cj4array[0] = 1; sj4array[0] = 0; j4array[0] = 0;
}
for(int ij4 = 0; ij4 < 2; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 2; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];

{
IkReal j5eval[3];
sj3=0.48883274;
cj3=-0.87237753;
j3=2.63084416569479;
IkReal x80=npz*npz;
IkReal x81=pp*pp;
j5eval[0]=((-1.0)+(((161.707637091607)*pp))+(((-202.500643017207)*x80))+(((-6537.33997343774)*x81)));
j5eval[1]=IKsign(((-987651184.806386)+(((-6456611570247.93)*x81))+(((-200000000000.0)*x80))+(((159710739365.767)*pp))));
j5eval[2]=((IKabs(((955709056.915841)+(((-77272726670.4545)*pp))+(((77.0)*cj4*npz)))))+(IKabs(((((437.5)*cj4*pp))+(((13599999894.0)*npz))+(((-5.41099984971219)*cj4))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[3];
sj3=0.48883274;
cj3=-0.87237753;
j3=2.63084416569479;
IkReal x82=npz*npz;
IkReal x83=(npx*sj6);
IkReal x84=(cj6*npy);
IkReal x85=(pp*sj4);
IkReal x86=((7027272532.09375)*cj4);
IkReal x87=((568181818181.818)*cj4*pp);
IkReal x88=(cj6*npx*sj4);
IkReal x89=(npy*sj4*sj6);
IkReal x90=(sj4*x82);
IkReal x91=((100000000000.0)*cj4*npz);
IkReal x92=(npy*sj6*x85);
j5eval[0]=((((11.3636363636364)*x89))+(((161.707637091607)*x90))+sj4+(((918.793392565951)*cj6*npx*x85))+(((-11.3636363636364)*x88))+(((-918.793392565951)*x92))+(((-80.8538185458036)*x85)));
j5eval[1]=IKsign(((((-568181818181.818)*x92))+(((568181818181.818)*cj6*npx*x85))+(((618399982.82425)*sj4))+(((7027272532.09375)*x89))+(((-7027272532.09375)*x88))+(((-50000000000.0)*x85))+(((100000000000.0)*x90))));
j5eval[2]=((IKabs(((((-6799999947.0)*x89))+(((6799999947.0)*x88))+(((-598399995.336)*sj4))+((x83*x91))+((x84*x91)))))+(IKabs((((x84*x87))+(((-1.0)*x83*x86))+(((-6799999947.0)*npz*sj4))+(((-1.0)*x84*x86))+((x83*x87))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
sj3=0.48883274;
cj3=-0.87237753;
j3=2.63084416569479;
IkReal x93=npz*npz;
IkReal x94=((568181818181.818)*pp);
IkReal x95=(cj4*pp);
IkReal x96=((918.793392565951)*pp);
IkReal x97=(cj4*npy*sj6);
IkReal x98=(cj4*cj6*npx);
IkReal x99=(cj4*x93);
j5eval[0]=((((-80.8538185458036)*x95))+(((-918.793392565951)*npy*sj6*x95))+(((161.707637091607)*x99))+cj4+(((918.793392565951)*cj6*npx*x95))+(((-11.3636363636364)*x98))+(((11.3636363636364)*x97)));
j5eval[1]=IKsign(((((-1.0)*x94*x97))+(((618399982.82425)*cj4))+(((7027272532.09375)*x97))+(((-7027272532.09375)*x98))+(((-50000000000.0)*x95))+((x94*x98))+(((100000000000.0)*x99))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j4)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
sj3=0.48883274;
cj3=-0.87237753;
j3=2.63084416569479;
sj4=1.0;
cj4=0;
j4=1.5707963267949;
IkReal x100=npz*npz;
IkReal x101=pp*pp;
j5eval[0]=((-1.0)+(((-202.500643017207)*x100))+(((161.707637091607)*pp))+(((-6537.33997343774)*x101)));
j5eval[1]=IKsign(((-493825592.403193)+(((-100000000000.0)*x100))+(((-3228305785123.97)*x101))+(((79855369682.8835)*pp))));
j5eval[2]=((IKabs(npz))+(((1.47058824675606e-10)*(IKabs(((477854528.457921)+(((-38636363335.2273)*pp))))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[3];
sj3=0.48883274;
cj3=-0.87237753;
j3=2.63084416569479;
sj4=1.0;
cj4=0;
j4=1.5707963267949;
IkReal x102=npz*npz;
IkReal x103=(cj6*npx);
IkReal x104=(npy*sj6);
IkReal x105=(pp*x104);
j5eval[0]=((-1.0)+(((-11.3636363636364)*x104))+(((918.793392565951)*x105))+(((-918.793392565951)*pp*x103))+(((11.3636363636364)*x103))+(((-161.707637091607)*x102))+(((80.8538185458036)*pp)));
j5eval[1]=IKsign(((-618399982.82425)+(((568181818181.818)*x105))+(((-100000000000.0)*x102))+(((50000000000.0)*pp))+(((7027272532.09375)*x103))+(((-7027272532.09375)*x104))+(((-568181818181.818)*pp*x103))));
j5eval[2]=((IKabs(npz))+(((1.47058824675606e-10)*(IKabs(((598399995.336)+(((-6799999947.0)*x103))+(((6799999947.0)*x104))))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
continue; // no branches [j5]

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x106=(cj6*npx);
IkReal x107=(npy*sj6);
IkReal x108=((568181818181.818)*pp);
CheckValue<IkReal> x109 = IKatan2WithCheck(IkReal(((598399995.336)+(((-6799999947.0)*x106))+(((6799999947.0)*x107)))),IkReal(((6799999947.0)*npz)),IKFAST_ATAN2_MAGTHRESH);
if(!x109.valid){
continue;
}
CheckValue<IkReal> x110=IKPowWithIntegerCheck(IKsign(((-618399982.82425)+((x107*x108))+(((50000000000.0)*pp))+(((7027272532.09375)*x106))+(((-1.0)*x106*x108))+(((-7027272532.09375)*x107))+(((-100000000000.0)*(npz*npz))))),-1);
if(!x110.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x109.value)+(((1.5707963267949)*(x110.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[3];
IkReal x111=IKsin(j5);
IkReal x112=IKcos(j5);
IkReal x113=((5.68181818181818)*pp);
IkReal x114=((1.0)*npz*x111);
evalcond[0]=((0.06799999947)+(((-1.0)*x111*x113))+(((0.0702727253209375)*x111))+((npz*x112)));
evalcond[1]=((((0.0702727253209375)*x112))+(((-1.0)*x112*x113))+(((-1.0)*x114)));
evalcond[2]=((((-1.0)*cj6*npx*x112))+(((-1.0)*x114))+(((0.088)*x112))+((npy*sj6*x112)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x654 = IKatan2WithCheck(IkReal(((477854528.457921)+(((-38636363335.2273)*pp)))),IkReal(((6799999947.0)*npz)),IKFAST_ATAN2_MAGTHRESH);
if(!x654.valid){
continue;
}
CheckValue<IkReal> x655=IKPowWithIntegerCheck(IKsign(((-493825592.403193)+(((79855369682.8835)*pp))+(((-3228305785123.97)*(pp*pp)))+(((-100000000000.0)*(npz*npz))))),-1);
if(!x655.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x654.value)+(((1.5707963267949)*(x655.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[3];
IkReal x656=IKsin(j5);
IkReal x657=IKcos(j5);
IkReal x658=((5.68181818181818)*pp);
IkReal x659=((1.0)*npz*x656);
evalcond[0]=((0.06799999947)+((npz*x657))+(((0.0702727253209375)*x656))+(((-1.0)*x656*x658)));
evalcond[1]=((((0.0702727253209375)*x657))+(((-1.0)*x657*x658))+(((-1.0)*x659)));
evalcond[2]=(((npy*sj6*x657))+(((0.088)*x657))+(((-1.0)*cj6*npx*x657))+(((-1.0)*x659)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j4)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
sj3=0.48883274;
cj3=-0.87237753;
j3=2.63084416569479;
sj4=-1.0;
cj4=0;
j4=-1.5707963267949;
IkReal x660=npz*npz;
IkReal x661=pp*pp;
j5eval[0]=((-1.0)+(((161.707637091607)*pp))+(((-202.500643017207)*x660))+(((-6537.33997343774)*x661)));
j5eval[1]=IKsign(((-493825592.403193)+(((79855369682.8835)*pp))+(((-100000000000.0)*x660))+(((-3228305785123.97)*x661))));
j5eval[2]=((IKabs(npz))+(((1.47058824675606e-10)*(IKabs(((477854528.457921)+(((-38636363335.2273)*pp))))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[3];
sj3=0.48883274;
cj3=-0.87237753;
j3=2.63084416569479;
sj4=-1.0;
cj4=0;
j4=-1.5707963267949;
IkReal x662=npz*npz;
IkReal x663=(cj6*npx);
IkReal x664=(npy*sj6);
IkReal x665=(pp*x664);
j5eval[0]=((1.0)+(((-918.793392565951)*x665))+(((918.793392565951)*pp*x663))+(((11.3636363636364)*x664))+(((161.707637091607)*x662))+(((-80.8538185458036)*pp))+(((-11.3636363636364)*x663)));
j5eval[1]=IKsign(((618399982.82425)+(((-7027272532.09375)*x663))+(((568181818181.818)*pp*x663))+(((100000000000.0)*x662))+(((-50000000000.0)*pp))+(((-568181818181.818)*x665))+(((7027272532.09375)*x664))));
j5eval[2]=((IKabs(npz))+(((1.47058824675606e-10)*(IKabs(((-598399995.336)+(((-6799999947.0)*x664))+(((6799999947.0)*x663))))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
continue; // no branches [j5]

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x666=(npy*sj6);
IkReal x667=(cj6*npx);
IkReal x668=((568181818181.818)*pp);
CheckValue<IkReal> x669 = IKatan2WithCheck(IkReal(((-598399995.336)+(((-6799999947.0)*x666))+(((6799999947.0)*x667)))),IkReal(((-6799999947.0)*npz)),IKFAST_ATAN2_MAGTHRESH);
if(!x669.valid){
continue;
}
CheckValue<IkReal> x670=IKPowWithIntegerCheck(IKsign(((618399982.82425)+((x667*x668))+(((-7027272532.09375)*x667))+(((-50000000000.0)*pp))+(((100000000000.0)*(npz*npz)))+(((-1.0)*x666*x668))+(((7027272532.09375)*x666)))),-1);
if(!x670.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x669.value)+(((1.5707963267949)*(x670.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[3];
IkReal x671=IKsin(j5);
IkReal x672=IKcos(j5);
IkReal x673=((5.68181818181818)*pp);
IkReal x674=(npz*x671);
evalcond[0]=((0.06799999947)+(((0.0702727253209375)*x671))+(((-1.0)*x671*x673))+((npz*x672)));
evalcond[1]=((((0.0702727253209375)*x672))+(((-1.0)*x674))+(((-1.0)*x672*x673)));
evalcond[2]=((((-0.088)*x672))+((cj6*npx*x672))+x674+(((-1.0)*npy*sj6*x672)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x675 = IKatan2WithCheck(IkReal(((477854528.457921)+(((-38636363335.2273)*pp)))),IkReal(((6799999947.0)*npz)),IKFAST_ATAN2_MAGTHRESH);
if(!x675.valid){
continue;
}
CheckValue<IkReal> x676=IKPowWithIntegerCheck(IKsign(((-493825592.403193)+(((79855369682.8835)*pp))+(((-3228305785123.97)*(pp*pp)))+(((-100000000000.0)*(npz*npz))))),-1);
if(!x676.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x675.value)+(((1.5707963267949)*(x676.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[3];
IkReal x677=IKsin(j5);
IkReal x678=IKcos(j5);
IkReal x679=((5.68181818181818)*pp);
IkReal x680=(npz*x677);
evalcond[0]=((0.06799999947)+(((0.0702727253209375)*x677))+((npz*x678))+(((-1.0)*x677*x679)));
evalcond[1]=((((-1.0)*x678*x679))+(((0.0702727253209375)*x678))+(((-1.0)*x680)));
evalcond[2]=((((-0.088)*x678))+((cj6*npx*x678))+x680+(((-1.0)*npy*sj6*x678)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j4))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[2];
sj3=0.48883274;
cj3=-0.87237753;
j3=2.63084416569479;
sj4=0;
cj4=1.0;
j4=0;
IkReal x681=npz*npz;
IkReal x682=pp*pp;
j5eval[0]=((-1.0)+(((161.707637091607)*pp))+(((-6537.33997343774)*x682))+(((-202.500643017207)*x681)));
j5eval[1]=IKsign(((-987651184.806386)+(((-200000000000.0)*x681))+(((-6456611570247.93)*x682))+(((159710739365.767)*pp))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[3];
sj3=0.48883274;
cj3=-0.87237753;
j3=2.63084416569479;
sj4=0;
cj4=1.0;
j4=0;
IkReal x683=npz*npz;
IkReal x684=(npy*sj6);
IkReal x685=(cj6*npx);
IkReal x686=((918.793392565951)*pp);
IkReal x687=((1136363636363.64)*pp);
j5eval[0]=((-1.0)+(((-1.0)*x685*x686))+(((-161.707637091607)*x683))+(((11.3636363636364)*x685))+(((-11.3636363636364)*x684))+((x684*x686))+(((80.8538185458036)*pp)));
j5eval[1]=IKsign(((-1236799965.6485)+(((-200000000000.0)*x683))+(((-1.0)*x685*x687))+(((100000000000.0)*pp))+(((-14054545064.1875)*x684))+(((14054545064.1875)*x685))+((x684*x687))));
j5eval[2]=((IKabs(((-5.41099984971219)+(((13599999894.0)*npz))+(((437.5)*pp)))))+(IKabs(((1196799990.672)+(((13599999894.0)*x684))+(((77.0)*npz))+(((-13599999894.0)*x685))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
continue; // no branches [j5]

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x688=(npy*sj6);
IkReal x689=((1136363636363.64)*pp);
IkReal x690=(cj6*npx);
CheckValue<IkReal> x691=IKPowWithIntegerCheck(IKsign(((-1236799965.6485)+((x688*x689))+(((100000000000.0)*pp))+(((-14054545064.1875)*x688))+(((-200000000000.0)*(npz*npz)))+(((-1.0)*x689*x690))+(((14054545064.1875)*x690)))),-1);
if(!x691.valid){
continue;
}
CheckValue<IkReal> x692 = IKatan2WithCheck(IkReal(((1196799990.672)+(((13599999894.0)*x688))+(((77.0)*npz))+(((-13599999894.0)*x690)))),IkReal(((-5.41099984971219)+(((13599999894.0)*npz))+(((437.5)*pp)))),IKFAST_ATAN2_MAGTHRESH);
if(!x692.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x691.value)))+(x692.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[3];
IkReal x693=IKsin(j5);
IkReal x694=IKcos(j5);
IkReal x695=((5.68181818181818)*pp);
IkReal x696=((1.0)*npz*x693);
evalcond[0]=((0.06799999947)+((npz*x694))+(((-1.0)*x693*x695))+(((0.0702727253209375)*x693)));
evalcond[1]=((-3.85e-10)+(((-1.0)*x696))+(((-1.0)*x694*x695))+(((0.0702727253209375)*x694)));
evalcond[2]=((-3.85e-10)+(((0.088)*x694))+(((-1.0)*x696))+((npy*sj6*x694))+(((-1.0)*cj6*npx*x694)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x697 = IKatan2WithCheck(IkReal(((955709056.915841)+(((77.0)*npz))+(((-77272726670.4545)*pp)))),IkReal(((-5.41099984971219)+(((13599999894.0)*npz))+(((437.5)*pp)))),IKFAST_ATAN2_MAGTHRESH);
if(!x697.valid){
continue;
}
CheckValue<IkReal> x698=IKPowWithIntegerCheck(IKsign(((-987651184.806386)+(((-6456611570247.93)*(pp*pp)))+(((-200000000000.0)*(npz*npz)))+(((159710739365.767)*pp)))),-1);
if(!x698.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x697.value)+(((1.5707963267949)*(x698.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[3];
IkReal x699=IKsin(j5);
IkReal x700=IKcos(j5);
IkReal x701=((5.68181818181818)*pp);
IkReal x702=((1.0)*npz*x699);
evalcond[0]=((0.06799999947)+((npz*x700))+(((-1.0)*x699*x701))+(((0.0702727253209375)*x699)));
evalcond[1]=((-3.85e-10)+(((-1.0)*x702))+(((0.0702727253209375)*x700))+(((-1.0)*x700*x701)));
evalcond[2]=((-3.85e-10)+(((-1.0)*cj6*npx*x700))+(((-1.0)*x702))+(((0.088)*x700))+((npy*sj6*x700)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j4)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[2];
sj3=0.48883274;
cj3=-0.87237753;
j3=2.63084416569479;
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
IkReal x703=npz*npz;
IkReal x704=pp*pp;
j5eval[0]=((1.0)+(((6537.33997343774)*x704))+(((202.500643017207)*x703))+(((-161.707637091607)*pp)));
j5eval[1]=IKsign(((987651184.806386)+(((6456611570247.93)*x704))+(((200000000000.0)*x703))+(((-159710739365.767)*pp))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[3];
sj3=0.48883274;
cj3=-0.87237753;
j3=2.63084416569479;
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
IkReal x705=npz*npz;
IkReal x706=(cj6*npx);
IkReal x707=(npy*sj6);
IkReal x708=((918.793392565951)*pp);
IkReal x709=((1136363636363.64)*pp);
j5eval[0]=((1.0)+(((-1.0)*x707*x708))+(((-11.3636363636364)*x706))+(((11.3636363636364)*x707))+((x706*x708))+(((161.707637091607)*x705))+(((-80.8538185458036)*pp)));
j5eval[1]=((IKabs(((-1196799990.672)+(((77.0)*npz))+(((-13599999894.0)*x707))+(((13599999894.0)*x706)))))+(IKabs(((-5.41099984971219)+(((-13599999894.0)*npz))+(((437.5)*pp))))));
j5eval[2]=IKsign(((1236799965.6485)+(((-14054545064.1875)*x706))+(((-1.0)*x707*x709))+((x706*x709))+(((-100000000000.0)*pp))+(((200000000000.0)*x705))+(((14054545064.1875)*x707))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
continue; // no branches [j5]

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x710=(npy*sj6);
IkReal x711=((1136363636363.64)*pp);
IkReal x712=(cj6*npx);
CheckValue<IkReal> x713 = IKatan2WithCheck(IkReal(((-1196799990.672)+(((-13599999894.0)*x710))+(((77.0)*npz))+(((13599999894.0)*x712)))),IkReal(((-5.41099984971219)+(((-13599999894.0)*npz))+(((437.5)*pp)))),IKFAST_ATAN2_MAGTHRESH);
if(!x713.valid){
continue;
}
CheckValue<IkReal> x714=IKPowWithIntegerCheck(IKsign(((1236799965.6485)+(((200000000000.0)*(npz*npz)))+(((-1.0)*x710*x711))+((x711*x712))+(((-100000000000.0)*pp))+(((14054545064.1875)*x710))+(((-14054545064.1875)*x712)))),-1);
if(!x714.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x713.value)+(((1.5707963267949)*(x714.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[3];
IkReal x715=IKsin(j5);
IkReal x716=IKcos(j5);
IkReal x717=((5.68181818181818)*pp);
IkReal x718=(npz*x715);
evalcond[0]=((0.06799999947)+((npz*x716))+(((0.0702727253209375)*x715))+(((-1.0)*x715*x717)));
evalcond[1]=((3.85e-10)+(((-1.0)*x718))+(((-1.0)*x716*x717))+(((0.0702727253209375)*x716)));
evalcond[2]=((-3.85e-10)+((cj6*npx*x716))+(((-1.0)*npy*sj6*x716))+x718+(((-0.088)*x716)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x719=IKPowWithIntegerCheck(IKsign(((987651184.806386)+(((200000000000.0)*(npz*npz)))+(((6456611570247.93)*(pp*pp)))+(((-159710739365.767)*pp)))),-1);
if(!x719.valid){
continue;
}
CheckValue<IkReal> x720 = IKatan2WithCheck(IkReal(((-955709056.915841)+(((77272726670.4545)*pp))+(((77.0)*npz)))),IkReal(((-5.41099984971219)+(((-13599999894.0)*npz))+(((437.5)*pp)))),IKFAST_ATAN2_MAGTHRESH);
if(!x720.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x719.value)))+(x720.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[3];
IkReal x721=IKsin(j5);
IkReal x722=IKcos(j5);
IkReal x723=((5.68181818181818)*pp);
IkReal x724=(npz*x721);
evalcond[0]=((0.06799999947)+((npz*x722))+(((-1.0)*x721*x723))+(((0.0702727253209375)*x721)));
evalcond[1]=((3.85e-10)+(((-1.0)*x722*x723))+(((-1.0)*x724))+(((0.0702727253209375)*x722)));
evalcond[2]=((-3.85e-10)+((cj6*npx*x722))+(((-1.0)*npy*sj6*x722))+x724+(((-0.088)*x722)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x725=((568181818181.818)*pp);
IkReal x726=((6799999947.0)*cj4);
IkReal x727=((100000000000.0)*npz);
IkReal x728=(cj6*npy*sj4);
IkReal x729=(cj4*cj6*npx);
IkReal x730=(npx*sj4*sj6);
IkReal x731=(cj4*npy*sj6);
CheckValue<IkReal> x732 = IKatan2WithCheck(IkReal(((((-1.0)*x727*x728))+(((-1.0)*x727*x730))+((cj6*npx*x726))+(((-1.0)*npy*sj6*x726))+(((-598399995.336)*cj4))+(((-38.5)*npz)))),IkReal(((2.70549992485609)+(((-1.0)*npz*x726))+(((-218.75)*pp))+(((-1.0)*x725*x730))+(((-1.0)*x725*x728))+(((7027272532.09375)*x730))+(((7027272532.09375)*x728)))),IKFAST_ATAN2_MAGTHRESH);
if(!x732.valid){
continue;
}
CheckValue<IkReal> x733=IKPowWithIntegerCheck(IKsign(((((-50000000000.0)*cj4*pp))+(((618399982.82425)*cj4))+(((-7027272532.09375)*x729))+(((-1.0)*x725*x731))+((cj4*npz*x727))+(((7027272532.09375)*x731))+((x725*x729)))),-1);
if(!x733.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x732.value)+(((1.5707963267949)*(x733.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[4];
IkReal x734=IKsin(j5);
IkReal x735=IKcos(j5);
IkReal x736=(npy*sj4);
IkReal x737=((1.0)*cj6);
IkReal x738=((5.68181818181818)*pp);
IkReal x739=(cj4*npy);
IkReal x740=(npx*sj6);
IkReal x741=(sj6*x735);
IkReal x742=(cj4*x735);
IkReal x743=(sj4*x735);
IkReal x744=((1.0)*npz*x734);
evalcond[0]=((0.06799999947)+((npz*x735))+(((-1.0)*x734*x738))+(((0.0702727253209375)*x734)));
evalcond[1]=((((-1.0)*x735*x738))+(((-3.85e-10)*cj4))+(((-1.0)*x744))+(((0.0702727253209375)*x735)));
evalcond[2]=((((-1.0)*sj4*x744))+(((-1.0)*npx*x737*x743))+(((0.088)*x743))+((cj6*x739))+((cj4*x740))+((x736*x741)));
evalcond[3]=((-3.85e-10)+(((-1.0)*x736*x737))+(((-1.0)*sj4*x740))+(((-1.0)*npx*x737*x742))+(((0.088)*x742))+((x739*x741))+(((-1.0)*cj4*x744)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x745=((6799999947.0)*sj4);
IkReal x746=(cj6*npx);
IkReal x747=(cj4*npx);
IkReal x748=(npy*sj4);
IkReal x749=((7027272532.09375)*sj6);
IkReal x750=((568181818181.818)*pp);
IkReal x751=((100000000000.0)*npz);
IkReal x752=(sj6*x750);
IkReal x753=(cj4*cj6*npy);
CheckValue<IkReal> x754 = IKatan2WithCheck(IkReal((((x745*x746))+(((-1.0)*npy*sj6*x745))+((x751*x753))+(((-598399995.336)*sj4))+((sj6*x747*x751)))),IkReal((((x747*x752))+(((-1.0)*x747*x749))+((x750*x753))+(((-1.0)*npz*x745))+(((-7027272532.09375)*x753)))),IKFAST_ATAN2_MAGTHRESH);
if(!x754.valid){
continue;
}
CheckValue<IkReal> x755=IKPowWithIntegerCheck(IKsign(((((-7027272532.09375)*sj4*x746))+(((-50000000000.0)*pp*sj4))+(((618399982.82425)*sj4))+((sj4*x746*x750))+((npz*sj4*x751))+(((-1.0)*x748*x752))+((x748*x749)))),-1);
if(!x755.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x754.value)+(((1.5707963267949)*(x755.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[4];
IkReal x756=IKsin(j5);
IkReal x757=IKcos(j5);
IkReal x758=(npy*sj4);
IkReal x759=((1.0)*cj6);
IkReal x760=((5.68181818181818)*pp);
IkReal x761=(cj4*npy);
IkReal x762=(npx*sj6);
IkReal x763=(sj6*x757);
IkReal x764=(cj4*x757);
IkReal x765=(sj4*x757);
IkReal x766=((1.0)*npz*x756);
evalcond[0]=((0.06799999947)+((npz*x757))+(((-1.0)*x756*x760))+(((0.0702727253209375)*x756)));
evalcond[1]=((((-1.0)*x766))+(((0.0702727253209375)*x757))+(((-1.0)*x757*x760))+(((-3.85e-10)*cj4)));
evalcond[2]=((((-1.0)*npx*x759*x765))+(((0.088)*x765))+((x758*x763))+((cj4*x762))+((cj6*x761))+(((-1.0)*sj4*x766)));
evalcond[3]=((-3.85e-10)+(((-1.0)*npx*x759*x764))+((x761*x763))+(((0.088)*x764))+(((-1.0)*x758*x759))+(((-1.0)*cj4*x766))+(((-1.0)*sj4*x762)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x767 = IKatan2WithCheck(IkReal(((955709056.915841)+(((-77272726670.4545)*pp))+(((77.0)*cj4*npz)))),IkReal(((((437.5)*cj4*pp))+(((13599999894.0)*npz))+(((-5.41099984971219)*cj4)))),IKFAST_ATAN2_MAGTHRESH);
if(!x767.valid){
continue;
}
CheckValue<IkReal> x768=IKPowWithIntegerCheck(IKsign(((-987651184.806386)+(((-6456611570247.93)*(pp*pp)))+(((-200000000000.0)*(npz*npz)))+(((159710739365.767)*pp)))),-1);
if(!x768.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x767.value)+(((1.5707963267949)*(x768.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[4];
IkReal x769=IKsin(j5);
IkReal x770=IKcos(j5);
IkReal x771=(npy*sj4);
IkReal x772=((1.0)*cj6);
IkReal x773=((5.68181818181818)*pp);
IkReal x774=(cj4*npy);
IkReal x775=(npx*sj6);
IkReal x776=(sj6*x770);
IkReal x777=(cj4*x770);
IkReal x778=(sj4*x770);
IkReal x779=((1.0)*npz*x769);
evalcond[0]=((0.06799999947)+(((0.0702727253209375)*x769))+(((-1.0)*x769*x773))+((npz*x770)));
evalcond[1]=((((0.0702727253209375)*x770))+(((-1.0)*x779))+(((-3.85e-10)*cj4))+(((-1.0)*x770*x773)));
evalcond[2]=((((-1.0)*sj4*x779))+((x771*x776))+(((0.088)*x778))+(((-1.0)*npx*x772*x778))+((cj6*x774))+((cj4*x775)));
evalcond[3]=((-3.85e-10)+((x774*x776))+(((-1.0)*cj4*x779))+(((-1.0)*sj4*x775))+(((0.088)*x777))+(((-1.0)*npx*x772*x777))+(((-1.0)*x771*x772)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j4, j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}

} else
{
{
IkReal j4array[2], cj4array[2], sj4array[2];
bool j4valid[2]={false};
_nj4 = 2;
CheckValue<IkReal> x780=IKPowWithIntegerCheck(((-0.0825)+(((0.0825)*cj3))+(((0.316)*sj3))),-1);
if(!x780.valid){
continue;
}
sj4array[0]=((-1.0)*(x780.value)*(((((-1.0)*cj6*npy))+(((-1.0)*npx*sj6)))));
if( sj4array[0] >= -1-IKFAST_SINCOS_THRESH && sj4array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j4valid[0] = j4valid[1] = true;
    j4array[0] = IKasin(sj4array[0]);
    cj4array[0] = IKcos(j4array[0]);
    sj4array[1] = sj4array[0];
    j4array[1] = j4array[0] > 0 ? (IKPI-j4array[0]) : (-IKPI-j4array[0]);
    cj4array[1] = -cj4array[0];
}
else if( isnan(sj4array[0]) )
{
    // probably any value will work
    j4valid[0] = true;
    cj4array[0] = 1; sj4array[0] = 0; j4array[0] = 0;
}
for(int ij4 = 0; ij4 < 2; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 2; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];

{
IkReal j5eval[2];
IkReal x781=cj6*cj6;
IkReal x782=npy*npy;
IkReal x783=npx*npx;
IkReal x784=npz*npz;
IkReal x785=(npy*sj6);
IkReal x786=(cj6*npx);
IkReal x787=((129.132231404959)*x782);
IkReal x788=(x781*x783);
j5eval[0]=((1.0)+(((-22.7272727272727)*x786))+(((129.132231404959)*x788))+(((129.132231404959)*x784))+(((22.7272727272727)*x785))+(((-1.0)*x781*x787))+(((-258.264462809917)*x785*x786))+x787);
j5eval[1]=IKsign(((0.007744)+(((-2.0)*x785*x786))+(((-0.176)*x786))+(((0.176)*x785))+(((-1.0)*x781*x782))+x782+x784+x788));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x789=cj6*cj6;
IkReal x790=npy*npy;
IkReal x791=npz*npz;
IkReal x792=npx*npx;
IkReal x793=((129.132231404959)*sj4);
IkReal x794=(npy*sj6);
IkReal x795=(sj4*x789);
IkReal x796=(cj6*npx*sj4);
j5eval[0]=(sj4+(((-22.7272727272727)*x796))+((x790*x793))+((x789*x792*x793))+(((-1.0)*x789*x790*x793))+(((-258.264462809917)*x794*x796))+(((22.7272727272727)*sj4*x794))+((x791*x793)));
j5eval[1]=IKsign(((((-0.176)*x796))+(((0.007744)*sj4))+(((-2.0)*x794*x796))+((sj4*x790))+((sj4*x791))+((x792*x795))+(((-1.0)*x790*x795))+(((0.176)*sj4*x794))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x797=cj6*cj6;
IkReal x798=npy*npy;
IkReal x799=npz*npz;
IkReal x800=npx*npx;
IkReal x801=(cj6*npx);
IkReal x802=(cj4*x798);
IkReal x803=((129.132231404959)*x797);
IkReal x804=(cj4*x799);
IkReal x805=(cj4*x800);
IkReal x806=(cj4*npy*sj6);
j5eval[0]=((((22.7272727272727)*x806))+cj4+((x803*x805))+(((-22.7272727272727)*cj4*x801))+(((129.132231404959)*x802))+(((129.132231404959)*x804))+(((-258.264462809917)*x801*x806))+(((-1.0)*x802*x803)));
j5eval[1]=IKsign(((((0.176)*x806))+(((-2.0)*x801*x806))+((x797*x805))+(((-1.0)*x797*x802))+(((-0.176)*cj4*x801))+x804+x802+(((0.007744)*cj4))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j4)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[2];
sj4=1.0;
cj4=0;
j4=1.5707963267949;
IkReal x807=cj6*cj6;
IkReal x808=npy*npy;
IkReal x809=npz*npz;
IkReal x810=npx*npx;
IkReal x811=(npy*sj6);
IkReal x812=(cj6*npx);
IkReal x813=((129.132231404959)*x808);
IkReal x814=(x807*x810);
j5eval[0]=((-1.0)+(((258.264462809917)*x811*x812))+(((-1.0)*x813))+(((-129.132231404959)*x814))+((x807*x813))+(((22.7272727272727)*x812))+(((-22.7272727272727)*x811))+(((-129.132231404959)*x809)));
j5eval[1]=IKsign(((-0.007744)+(((-1.0)*x808))+(((-1.0)*x809))+(((-0.176)*x811))+(((0.176)*x812))+(((-1.0)*x814))+(((2.0)*x811*x812))+((x807*x808))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
continue; // no branches [j5]

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x815=cj6*cj6;
IkReal x816=npy*npy;
IkReal x817=(npy*sj6);
IkReal x818=(cj6*npx);
IkReal x819=((0.316)*cj3);
IkReal x820=((0.0825)*sj3);
CheckValue<IkReal> x821 = IKatan2WithCheck(IkReal(((0.033792)+(((0.027808)*cj3))+(((-1.0)*x818*x819))+(((-1.0)*x817*x820))+((x817*x819))+((x818*x820))+(((-0.384)*x818))+(((-0.00726)*sj3))+(((0.384)*x817)))),IkReal(((((-1.0)*npz*x820))+((npz*x819))+(((0.384)*npz)))),IKFAST_ATAN2_MAGTHRESH);
if(!x821.valid){
continue;
}
CheckValue<IkReal> x822=IKPowWithIntegerCheck(IKsign(((-0.007744)+((x815*x816))+(((2.0)*x817*x818))+(((-1.0)*(npz*npz)))+(((-0.176)*x817))+(((0.176)*x818))+(((-1.0)*x816))+(((-1.0)*x815*(npx*npx))))),-1);
if(!x822.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x821.value)+(((1.5707963267949)*(x822.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[2];
IkReal x823=IKcos(j5);
IkReal x824=IKsin(j5);
IkReal x825=(npy*sj6);
IkReal x826=(cj6*npx);
IkReal x827=((1.0)*x824);
evalcond[0]=((((0.088)*x823))+(((-1.0)*x823*x826))+(((-1.0)*npz*x827))+((x823*x825)));
evalcond[1]=((0.384)+(((0.088)*x824))+(((-0.0825)*sj3))+((x824*x825))+(((0.316)*cj3))+(((-1.0)*x826*x827))+((npz*x823)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j4)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[2];
sj4=-1.0;
cj4=0;
j4=-1.5707963267949;
IkReal x828=cj6*cj6;
IkReal x829=npy*npy;
IkReal x830=npz*npz;
IkReal x831=npx*npx;
IkReal x832=(npy*sj6);
IkReal x833=(cj6*npx);
IkReal x834=((129.132231404959)*x829);
IkReal x835=(x828*x831);
j5eval[0]=((-1.0)+(((-129.132231404959)*x830))+(((-129.132231404959)*x835))+(((22.7272727272727)*x833))+(((258.264462809917)*x832*x833))+(((-1.0)*x834))+((x828*x834))+(((-22.7272727272727)*x832)));
j5eval[1]=IKsign(((-0.007744)+(((0.176)*x833))+(((2.0)*x832*x833))+(((-1.0)*x829))+(((-1.0)*x835))+(((-1.0)*x830))+((x828*x829))+(((-0.176)*x832))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
continue; // no branches [j5]

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x836=cj6*cj6;
IkReal x837=npy*npy;
IkReal x838=(npy*sj6);
IkReal x839=(cj6*npx);
IkReal x840=((0.316)*cj3);
IkReal x841=((0.0825)*sj3);
CheckValue<IkReal> x842 = IKatan2WithCheck(IkReal(((0.033792)+(((0.027808)*cj3))+((x838*x840))+((x839*x841))+(((0.384)*x838))+(((-0.384)*x839))+(((-0.00726)*sj3))+(((-1.0)*x839*x840))+(((-1.0)*x838*x841)))),IkReal(((((-1.0)*npz*x841))+((npz*x840))+(((0.384)*npz)))),IKFAST_ATAN2_MAGTHRESH);
if(!x842.valid){
continue;
}
CheckValue<IkReal> x843=IKPowWithIntegerCheck(IKsign(((-0.007744)+(((2.0)*x838*x839))+(((-1.0)*(npz*npz)))+(((0.176)*x839))+((x836*x837))+(((-1.0)*x837))+(((-1.0)*x836*(npx*npx)))+(((-0.176)*x838)))),-1);
if(!x843.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x842.value)+(((1.5707963267949)*(x843.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[2];
IkReal x844=IKcos(j5);
IkReal x845=IKsin(j5);
IkReal x846=(npy*sj6);
IkReal x847=(cj6*npx);
IkReal x848=((1.0)*x845);
evalcond[0]=((((0.088)*x844))+(((-1.0)*npz*x848))+(((-1.0)*x844*x847))+((x844*x846)));
evalcond[1]=((0.384)+(((-1.0)*x847*x848))+(((-0.0825)*sj3))+(((0.088)*x845))+(((0.316)*cj3))+((npz*x844))+((x845*x846)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j4))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[2];
sj4=0;
cj4=1.0;
j4=0;
IkReal x849=cj6*cj6;
IkReal x850=npy*npy;
IkReal x851=npx*npx;
IkReal x852=npz*npz;
IkReal x853=(npy*sj6);
IkReal x854=(cj6*npx);
IkReal x855=((129.132231404959)*x850);
IkReal x856=(x849*x851);
j5eval[0]=((1.0)+(((-1.0)*x849*x855))+(((-258.264462809917)*x853*x854))+(((129.132231404959)*x856))+(((129.132231404959)*x852))+(((-22.7272727272727)*x854))+x855+(((22.7272727272727)*x853)));
j5eval[1]=IKsign(((0.007744)+(((-2.0)*x853*x854))+(((-1.0)*x849*x850))+(((-0.176)*x854))+(((0.176)*x853))+x852+x850+x856));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
continue; // no branches [j5]

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x857=cj6*cj6;
IkReal x858=npy*npy;
IkReal x859=(cj6*npx);
IkReal x860=((0.316)*cj3);
IkReal x861=(npy*sj6);
IkReal x862=((0.0825)*npz);
IkReal x863=((0.316)*sj3);
IkReal x864=((0.0825)*sj3);
IkReal x865=((0.0825)*cj3);
CheckValue<IkReal> x866 = IKatan2WithCheck(IkReal(((-0.033792)+(((0.384)*x859))+(((-1.0)*x862))+(((-0.384)*x861))+((cj3*x862))+(((-1.0)*x860*x861))+(((-0.027808)*cj3))+(((0.00726)*sj3))+((x859*x860))+((x861*x864))+(((-1.0)*x859*x864))+((npz*x863)))),IkReal(((0.00726)+(((-0.0825)*x859))+((sj3*x862))+(((-0.027808)*sj3))+(((-1.0)*x861*x863))+(((-1.0)*x861*x865))+(((0.0825)*x861))+(((-1.0)*npz*x860))+(((-0.384)*npz))+((x859*x865))+((x859*x863))+(((-0.00726)*cj3)))),IKFAST_ATAN2_MAGTHRESH);
if(!x866.valid){
continue;
}
CheckValue<IkReal> x867=IKPowWithIntegerCheck(IKsign(((0.007744)+(((-2.0)*x859*x861))+(((-1.0)*x857*x858))+(((-0.176)*x859))+x858+(npz*npz)+(((0.176)*x861))+((x857*(npx*npx))))),-1);
if(!x867.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x866.value)+(((1.5707963267949)*(x867.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[2];
IkReal x868=IKsin(j5);
IkReal x869=IKcos(j5);
IkReal x870=(npy*sj6);
IkReal x871=(cj6*npx);
IkReal x872=((1.0)*x868);
evalcond[0]=((0.384)+((x868*x870))+(((-1.0)*x871*x872))+(((-0.0825)*sj3))+(((0.316)*cj3))+((npz*x869))+(((0.088)*x868)));
evalcond[1]=((-0.0825)+(((-1.0)*x869*x871))+(((-1.0)*npz*x872))+((x869*x870))+(((0.0825)*cj3))+(((0.316)*sj3))+(((0.088)*x869)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j4)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[2];
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
IkReal x873=cj6*cj6;
IkReal x874=npy*npy;
IkReal x875=npx*npx;
IkReal x876=npz*npz;
IkReal x877=(npy*sj6);
IkReal x878=(cj6*npx);
IkReal x879=((129.132231404959)*x874);
IkReal x880=(x873*x875);
j5eval[0]=((1.0)+(((22.7272727272727)*x877))+(((129.132231404959)*x880))+(((-258.264462809917)*x877*x878))+(((-1.0)*x873*x879))+(((129.132231404959)*x876))+(((-22.7272727272727)*x878))+x879);
j5eval[1]=IKsign(((0.007744)+(((-2.0)*x877*x878))+(((-1.0)*x873*x874))+(((-0.176)*x878))+x874+x876+x880+(((0.176)*x877))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
continue; // no branches [j5]

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x881=cj6*cj6;
IkReal x882=npy*npy;
IkReal x883=(cj6*npx);
IkReal x884=((0.316)*cj3);
IkReal x885=(npy*sj6);
IkReal x886=((0.0825)*npz);
IkReal x887=((0.316)*sj3);
IkReal x888=((0.0825)*sj3);
IkReal x889=((0.0825)*cj3);
CheckValue<IkReal> x890=IKPowWithIntegerCheck(IKsign(((0.007744)+(((-1.0)*x881*x882))+(((-0.176)*x883))+((x881*(npx*npx)))+(((0.176)*x885))+x882+(npz*npz)+(((-2.0)*x883*x885)))),-1);
if(!x890.valid){
continue;
}
CheckValue<IkReal> x891 = IKatan2WithCheck(IkReal(((-0.033792)+(((-1.0)*cj3*x886))+(((-1.0)*x883*x888))+((x883*x884))+(((-1.0)*npz*x887))+(((-0.027808)*cj3))+(((0.00726)*sj3))+(((0.384)*x883))+(((-0.384)*x885))+x886+((x885*x888))+(((-1.0)*x884*x885)))),IkReal(((-0.00726)+(((-1.0)*x883*x889))+(((-1.0)*x883*x887))+(((0.027808)*sj3))+(((-1.0)*npz*x884))+(((-0.0825)*x885))+((sj3*x886))+(((-0.384)*npz))+(((0.00726)*cj3))+((x885*x887))+((x885*x889))+(((0.0825)*x883)))),IKFAST_ATAN2_MAGTHRESH);
if(!x891.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x890.value)))+(x891.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[2];
IkReal x892=IKsin(j5);
IkReal x893=IKcos(j5);
IkReal x894=(npy*sj6);
IkReal x895=(cj6*npx);
IkReal x896=((1.0)*x892);
evalcond[0]=((0.384)+(((0.088)*x892))+(((-0.0825)*sj3))+(((-1.0)*x895*x896))+(((0.316)*cj3))+((x892*x894))+((npz*x893)));
evalcond[1]=((0.0825)+(((0.088)*x893))+(((-0.0825)*cj3))+(((-1.0)*npz*x896))+((x893*x894))+(((-1.0)*x893*x895))+(((-0.316)*sj3)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x897=cj6*cj6;
IkReal x898=npy*npy;
IkReal x899=npx*npx;
IkReal x900=((1.0)*npz);
IkReal x901=(cj6*npx);
IkReal x902=(cj4*sj3);
IkReal x903=((0.0825)*cj3);
IkReal x904=(npy*sj6);
IkReal x905=(cj6*sj4);
IkReal x906=((0.0825)*npz);
IkReal x907=((0.384)*cj4);
IkReal x908=((0.316)*sj3);
IkReal x909=((0.176)*cj4);
IkReal x910=(npx*sj4*sj6);
IkReal x911=((0.316)*cj3*cj4);
IkReal x912=(cj4*x897);
IkReal x913=(npx*npy*sj4);
CheckValue<IkReal> x914=IKPowWithIntegerCheck(IKsign(((((-1.0)*x898*x912))+(((-2.0)*cj4*x901*x904))+((cj4*(npz*npz)))+((cj4*x898))+((x899*x912))+(((-1.0)*x901*x909))+(((0.007744)*cj4))+((x904*x909)))),-1);
if(!x914.valid){
continue;
}
CheckValue<IkReal> x915 = IKatan2WithCheck(IkReal((((x901*x911))+(((0.00726)*x902))+((x901*x907))+(((-1.0)*x906))+(((0.0825)*x902*x904))+((npz*x903))+((npz*x908))+(((-0.0825)*x901*x902))+(((-1.0)*x904*x911))+(((-1.0)*x900*x910))+(((-0.033792)*cj4))+(((-1.0)*x904*x907))+(((-0.027808)*cj3*cj4))+(((-1.0)*npy*x900*x905)))),IkReal(((0.00726)+(((-1.0)*x903*x904))+(((0.088)*npy*x905))+(((-0.027808)*sj3))+((x901*x908))+((x901*x903))+(((0.088)*x910))+((x902*x906))+(((0.0825)*x904))+((sj6*x898*x905))+(((-1.0)*npz*x907))+(((-1.0)*sj6*x899*x905))+(((-0.00726)*cj3))+(((-2.0)*x897*x913))+(((-1.0)*x904*x908))+(((-1.0)*npz*x911))+x913+(((-0.0825)*x901)))),IKFAST_ATAN2_MAGTHRESH);
if(!x915.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x914.value)))+(x915.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[4];
IkReal x916=IKsin(j5);
IkReal x917=IKcos(j5);
IkReal x918=(cj6*npy);
IkReal x919=((1.0)*sj4);
IkReal x920=((0.0825)*cj4);
IkReal x921=((0.316)*sj3);
IkReal x922=(npx*sj6);
IkReal x923=((0.088)*x917);
IkReal x924=(npy*sj6*x917);
IkReal x925=((1.0)*npz*x916);
IkReal x926=(cj6*npx*x917);
evalcond[0]=((0.384)+(((-1.0)*cj6*npx*x916))+(((-0.0825)*sj3))+(((0.088)*x916))+(((0.316)*cj3))+((npy*sj6*x916))+((npz*x917)));
evalcond[1]=((((-1.0)*x920))+(((-1.0)*x925))+(((-1.0)*x926))+((cj3*x920))+((cj4*x921))+x924+x923);
evalcond[2]=((((-1.0)*npz*x916*x919))+((sj4*x924))+((sj4*x923))+(((-1.0)*x919*x926))+((cj4*x918))+((cj4*x922)));
evalcond[3]=((-0.0825)+(((-1.0)*x918*x919))+(((-1.0)*cj4*x926))+(((0.0825)*cj3))+(((-1.0)*x919*x922))+(((-1.0)*cj4*x925))+((cj4*x923))+((cj4*x924))+x921);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x927=cj6*cj6;
IkReal x928=npy*npy;
IkReal x929=npx*npx;
IkReal x930=((0.0825)*sj3);
IkReal x931=(npz*sj4);
IkReal x932=(cj4*npx);
IkReal x933=((0.316)*cj3);
IkReal x934=((2.0)*npy);
IkReal x935=(cj4*cj6);
IkReal x936=(cj6*npx*sj4);
IkReal x937=(sj4*x928);
IkReal x938=(npy*sj4*sj6);
CheckValue<IkReal> x939=IKPowWithIntegerCheck(IKsign((((npz*x931))+(((0.007744)*sj4))+(((-0.176)*x936))+((sj4*x927*x929))+(((-1.0)*sj6*x934*x936))+(((0.176)*x938))+x937+(((-1.0)*x927*x937)))),-1);
if(!x939.valid){
continue;
}
CheckValue<IkReal> x940 = IKatan2WithCheck(IkReal(((((-1.0)*x930*x936))+(((-0.384)*x938))+(((-0.027808)*cj3*sj4))+((x930*x938))+(((0.384)*x936))+(((-0.033792)*sj4))+(((-1.0)*x933*x938))+(((0.00726)*sj3*sj4))+((npz*sj6*x932))+((npy*npz*x935))+((x933*x936)))),IkReal(((((-0.088)*npy*x935))+(((-0.088)*sj6*x932))+(((-1.0)*x931*x933))+(((-0.384)*x931))+(((-1.0)*npy*x932))+((x930*x931))+((x927*x932*x934))+(((-1.0)*sj6*x928*x935))+((sj6*x929*x935)))),IKFAST_ATAN2_MAGTHRESH);
if(!x940.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x939.value)))+(x940.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[4];
IkReal x941=IKsin(j5);
IkReal x942=IKcos(j5);
IkReal x943=(cj6*npy);
IkReal x944=((1.0)*sj4);
IkReal x945=((0.0825)*cj4);
IkReal x946=((0.316)*sj3);
IkReal x947=(npx*sj6);
IkReal x948=((0.088)*x942);
IkReal x949=(npy*sj6*x942);
IkReal x950=((1.0)*npz*x941);
IkReal x951=(cj6*npx*x942);
evalcond[0]=((0.384)+((npz*x942))+(((-0.0825)*sj3))+((npy*sj6*x941))+(((0.316)*cj3))+(((-1.0)*cj6*npx*x941))+(((0.088)*x941)));
evalcond[1]=((((-1.0)*x945))+(((-1.0)*x951))+((cj3*x945))+(((-1.0)*x950))+x948+x949+((cj4*x946)));
evalcond[2]=((((-1.0)*x944*x951))+(((-1.0)*npz*x941*x944))+((sj4*x949))+((sj4*x948))+((cj4*x943))+((cj4*x947)));
evalcond[3]=((-0.0825)+(((-1.0)*cj4*x951))+(((-1.0)*x944*x947))+(((-1.0)*x943*x944))+(((0.0825)*cj3))+(((-1.0)*cj4*x950))+x946+((cj4*x949))+((cj4*x948)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x952=cj6*cj6;
IkReal x953=npy*npy;
IkReal x954=((0.0825)*cj4);
IkReal x955=(npy*sj6);
IkReal x956=(cj4*sj3);
IkReal x957=(cj3*npz);
IkReal x958=(cj6*npx);
IkReal x959=((0.00726)*cj4);
IkReal x960=((0.0825)*sj3);
IkReal x961=((0.316)*cj3);
CheckValue<IkReal> x962=IKPowWithIntegerCheck(IKsign(((0.007744)+(((0.176)*x955))+((x952*(npx*npx)))+(((-2.0)*x955*x958))+(((-0.176)*x958))+(((-1.0)*x952*x953))+(npz*npz)+x953)),-1);
if(!x962.valid){
continue;
}
CheckValue<IkReal> x963 = IKatan2WithCheck(IkReal(((-0.033792)+(((0.316)*npz*x956))+(((-1.0)*npz*x954))+(((-0.384)*x955))+(((-0.027808)*cj3))+(((0.00726)*sj3))+(((-1.0)*x958*x960))+((x958*x961))+(((-1.0)*x955*x961))+(((0.384)*x958))+((x955*x960))+((x954*x957)))),IkReal((((cj3*x954*x958))+((npz*x960))+(((-0.027808)*x956))+(((-1.0)*cj3*x954*x955))+(((-1.0)*cj3*x959))+(((0.316)*x956*x958))+(((-0.384)*npz))+(((-0.316)*x955*x956))+(((-1.0)*x954*x958))+x959+(((-0.316)*x957))+((x954*x955)))),IKFAST_ATAN2_MAGTHRESH);
if(!x963.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x962.value)))+(x963.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[4];
IkReal x964=IKsin(j5);
IkReal x965=IKcos(j5);
IkReal x966=(cj6*npy);
IkReal x967=((1.0)*sj4);
IkReal x968=((0.0825)*cj4);
IkReal x969=((0.316)*sj3);
IkReal x970=(npx*sj6);
IkReal x971=((0.088)*x965);
IkReal x972=(npy*sj6*x965);
IkReal x973=((1.0)*npz*x964);
IkReal x974=(cj6*npx*x965);
evalcond[0]=((0.384)+((npz*x965))+(((-1.0)*cj6*npx*x964))+(((-0.0825)*sj3))+(((0.316)*cj3))+((npy*sj6*x964))+(((0.088)*x964)));
evalcond[1]=((((-1.0)*x974))+((cj3*x968))+x971+x972+(((-1.0)*x968))+(((-1.0)*x973))+((cj4*x969)));
evalcond[2]=(((cj4*x970))+((sj4*x971))+((sj4*x972))+(((-1.0)*x967*x974))+(((-1.0)*npz*x964*x967))+((cj4*x966)));
evalcond[3]=((-0.0825)+((cj4*x971))+((cj4*x972))+(((-1.0)*x966*x967))+(((-1.0)*x967*x970))+(((-1.0)*cj4*x974))+(((0.0825)*cj3))+x969+(((-1.0)*cj4*x973)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}

}

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
IkReal x975=((0.088)+(((-1.0)*cj6*npx))+((npy*sj6)));
CheckValue<IkReal> x978 = IKatan2WithCheck(IkReal(npz),IkReal(x975),IKFAST_ATAN2_MAGTHRESH);
if(!x978.valid){
continue;
}
IkReal x976=((1.0)*(x978.value));
if((((x975*x975)+(npz*npz))) < -0.00001)
continue;
CheckValue<IkReal> x979=IKPowWithIntegerCheck(IKabs(IKsqrt(((x975*x975)+(npz*npz)))),-1);
if(!x979.valid){
continue;
}
if( (((x979.value)*(((0.384)+(((-0.0825)*sj3))+(((0.316)*cj3)))))) < -1-IKFAST_SINCOS_THRESH || (((x979.value)*(((0.384)+(((-0.0825)*sj3))+(((0.316)*cj3)))))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x977=IKasin(((x979.value)*(((0.384)+(((-0.0825)*sj3))+(((0.316)*cj3))))));
j5array[0]=((((-1.0)*x977))+(((-1.0)*x976)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
j5array[1]=((3.14159265358979)+x977+(((-1.0)*x976)));
sj5array[1]=IKsin(j5array[1]);
cj5array[1]=IKcos(j5array[1]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
if( j5array[1] > IKPI )
{
    j5array[1]-=IK2PI;
}
else if( j5array[1] < -IKPI )
{    j5array[1]+=IK2PI;
}
j5valid[1] = true;
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];

{
IkReal j4eval[3];
j4eval[0]=((-1.0)+cj3+(((3.83030303030303)*sj3)));
j4eval[1]=((IKabs((((cj6*npy))+((npx*sj6)))))+(IKabs(((((-0.088)*cj5))+(((-1.0)*cj5*npy*sj6))+((npz*sj5))+((cj5*cj6*npx))))));
j4eval[2]=IKsign(((-0.0825)+(((0.0825)*cj3))+(((0.316)*sj3))));
if( IKabs(j4eval[0]) < 0.0000010000000000  || IKabs(j4eval[1]) < 0.0000010000000000  || IKabs(j4eval[2]) < 0.0000010000000000  )
{
{
IkReal j4eval[2];
IkReal x980=(cj6*npy);
IkReal x981=(npx*sj6);
IkReal x982=((3.83030303030303)*sj3);
j4eval[0]=((-1.0)+cj3+x982);
j4eval[1]=(((x981*x982))+(((-1.0)*x980))+(((-1.0)*x981))+((cj3*x980))+((cj3*x981))+((x980*x982)));
if( IKabs(j4eval[0]) < 0.0000010000000000  || IKabs(j4eval[1]) < 0.0000010000000000  )
{
{
IkReal j4eval[2];
IkReal x983=((43.5261707988981)*sj3);
IkReal x984=(cj3*cj5);
IkReal x985=((3.83030303030303)*sj3);
IkReal x986=(cj5*cj6*npx);
IkReal x987=((11.3636363636364)*npz*sj5);
IkReal x988=(cj5*npy*sj6);
j4eval[0]=((-1.0)+cj3+x985);
j4eval[1]=(((x983*x988))+(((-11.3636363636364)*x988))+(((-1.0)*npz*sj5*x983))+((cj5*x985))+(((11.3636363636364)*npy*sj6*x984))+(((-1.0)*cj3*x987))+(((11.3636363636364)*x986))+(((-11.3636363636364)*cj6*npx*x984))+x984+x987+(((-1.0)*cj5))+(((-1.0)*x983*x986)));
if( IKabs(j4eval[0]) < 0.0000010000000000  || IKabs(j4eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j3))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j4eval[1];
sj3=0;
cj3=1.0;
j3=0;
j4eval[0]=((IKabs((((cj6*npy))+((npx*sj6)))))+(IKabs(((((-1.0)*npz*sj5))+((cj5*npy*sj6))+(((0.088)*cj5))+(((-1.0)*cj5*cj6*npx))))));
if( IKabs(j4eval[0]) < 0.0000010000000000  )
{
{
IkReal j4eval[1];
sj3=0;
cj3=1.0;
j3=0;
IkReal x989=((1.0)*cj6);
j4eval[0]=((IKabs(((((-1.0)*npz*sj5))+(((-1.0)*cj5*npx*x989))+((cj5*npy*sj6))+(((0.088)*cj5)))))+(IKabs(((((-1.0)*npy*x989))+(((-1.0)*npx*sj6))))));
if( IKabs(j4eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j4]

} else
{
{
IkReal j4array[2], cj4array[2], sj4array[2];
bool j4valid[2]={false};
_nj4 = 2;
IkReal x990=((1.0)*cj6);
CheckValue<IkReal> x992 = IKatan2WithCheck(IkReal(((((-1.0)*cj5*npx*x990))+(((-1.0)*npz*sj5))+((cj5*npy*sj6))+(((0.088)*cj5)))),IkReal(((((-1.0)*npx*sj6))+(((-1.0)*npy*x990)))),IKFAST_ATAN2_MAGTHRESH);
if(!x992.valid){
continue;
}
IkReal x991=x992.value;
j4array[0]=((-1.0)*x991);
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
j4array[1]=((3.14159265358979)+(((-1.0)*x991)));
sj4array[1]=IKsin(j4array[1]);
cj4array[1]=IKcos(j4array[1]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
if( j4array[1] > IKPI )
{
    j4array[1]-=IK2PI;
}
else if( j4array[1] < -IKPI )
{    j4array[1]+=IK2PI;
}
j4valid[1] = true;
for(int ij4 = 0; ij4 < 2; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 2; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[1];
IkReal x993=IKcos(j4);
IkReal x994=IKsin(j4);
IkReal x995=((1.0)*x994);
IkReal x996=(cj5*x994);
evalcond[0]=(((npx*sj6*x993))+(((0.088)*x996))+(((-1.0)*npz*sj5*x995))+(((-1.0)*cj5*cj6*npx*x995))+((cj6*npy*x993))+((npy*sj6*x996)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j4array[2], cj4array[2], sj4array[2];
bool j4valid[2]={false};
_nj4 = 2;
CheckValue<IkReal> x998 = IKatan2WithCheck(IkReal((((cj6*npy))+((npx*sj6)))),IkReal(((((-1.0)*npz*sj5))+((cj5*npy*sj6))+(((0.088)*cj5))+(((-1.0)*cj5*cj6*npx)))),IKFAST_ATAN2_MAGTHRESH);
if(!x998.valid){
continue;
}
IkReal x997=x998.value;
j4array[0]=((-1.0)*x997);
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
j4array[1]=((3.14159265358979)+(((-1.0)*x997)));
sj4array[1]=IKsin(j4array[1]);
cj4array[1]=IKcos(j4array[1]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
if( j4array[1] > IKPI )
{
    j4array[1]-=IK2PI;
}
else if( j4array[1] < -IKPI )
{    j4array[1]+=IK2PI;
}
j4valid[1] = true;
for(int ij4 = 0; ij4 < 2; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 2; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[1];
IkReal x999=IKcos(j4);
IkReal x1000=IKsin(j4);
IkReal x1001=((1.0)*cj6);
IkReal x1002=(cj5*x999);
evalcond[0]=((((-1.0)*npz*sj5*x999))+(((-1.0)*npx*x1001*x1002))+((npy*sj6*x1002))+(((0.088)*x1002))+(((-1.0)*npx*sj6*x1000))+(((-1.0)*npy*x1000*x1001)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((7.39491075446515e-18)+j3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j4eval[1];
sj3=0;
cj3=1.0;
j3=-2.7408962440214e-6;
j4eval[0]=((IKabs((((cj6*npy))+((npx*sj6)))))+(IKabs(((((-1.0)*npz*sj5))+((cj5*npy*sj6))+(((0.088)*cj5))+(((-1.0)*cj5*cj6*npx))))));
if( IKabs(j4eval[0]) < 0.0000010000000000  )
{
{
IkReal j4eval[1];
sj3=0;
cj3=1.0;
j3=-2.7408962440214e-6;
IkReal x1003=((1.0)*cj6);
j4eval[0]=((IKabs(((((-1.0)*npz*sj5))+((cj5*npy*sj6))+(((-1.0)*cj5*npx*x1003))+(((0.088)*cj5)))))+(IKabs(((((-1.0)*npx*sj6))+(((-1.0)*npy*x1003))))));
if( IKabs(j4eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j4]

} else
{
{
IkReal j4array[2], cj4array[2], sj4array[2];
bool j4valid[2]={false};
_nj4 = 2;
IkReal x1004=((1.0)*cj6);
CheckValue<IkReal> x1006 = IKatan2WithCheck(IkReal(((((-1.0)*npz*sj5))+((cj5*npy*sj6))+(((-1.0)*cj5*npx*x1004))+(((0.088)*cj5)))),IkReal(((((-1.0)*npx*sj6))+(((-1.0)*npy*x1004)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1006.valid){
continue;
}
IkReal x1005=x1006.value;
j4array[0]=((-1.0)*x1005);
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
j4array[1]=((3.14159265358979)+(((-1.0)*x1005)));
sj4array[1]=IKsin(j4array[1]);
cj4array[1]=IKcos(j4array[1]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
if( j4array[1] > IKPI )
{
    j4array[1]-=IK2PI;
}
else if( j4array[1] < -IKPI )
{    j4array[1]+=IK2PI;
}
j4valid[1] = true;
for(int ij4 = 0; ij4 < 2; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 2; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[1];
IkReal x1007=IKcos(j4);
IkReal x1008=IKsin(j4);
IkReal x1009=((1.0)*x1008);
IkReal x1010=(cj5*x1008);
evalcond[0]=(((npx*sj6*x1007))+((cj6*npy*x1007))+((npy*sj6*x1010))+(((0.088)*x1010))+(((-1.0)*cj5*cj6*npx*x1009))+(((-1.0)*npz*sj5*x1009)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j4array[2], cj4array[2], sj4array[2];
bool j4valid[2]={false};
_nj4 = 2;
CheckValue<IkReal> x1012 = IKatan2WithCheck(IkReal((((cj6*npy))+((npx*sj6)))),IkReal(((((-1.0)*npz*sj5))+((cj5*npy*sj6))+(((0.088)*cj5))+(((-1.0)*cj5*cj6*npx)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1012.valid){
continue;
}
IkReal x1011=x1012.value;
j4array[0]=((-1.0)*x1011);
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
j4array[1]=((3.14159265358979)+(((-1.0)*x1011)));
sj4array[1]=IKsin(j4array[1]);
cj4array[1]=IKcos(j4array[1]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
if( j4array[1] > IKPI )
{
    j4array[1]-=IK2PI;
}
else if( j4array[1] < -IKPI )
{    j4array[1]+=IK2PI;
}
j4valid[1] = true;
for(int ij4 = 0; ij4 < 2; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 2; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[1];
IkReal x1013=IKcos(j4);
IkReal x1014=IKsin(j4);
IkReal x1015=((1.0)*cj6);
IkReal x1016=(cj5*x1013);
evalcond[0]=((((-1.0)*npy*x1014*x1015))+((npy*sj6*x1016))+(((0.088)*x1016))+(((-1.0)*npz*sj5*x1013))+(((-1.0)*npx*x1015*x1016))+(((-1.0)*npx*sj6*x1014)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-2.63084142381503)+j3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1017=((2597402597.4026)*sj6);
IkReal x1018=((2597402597.4026)*cj6);
if( IKabs(((((-1.0)*npy*x1018))+(((-1.0)*npx*x1017)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((228571428.571429)*cj5))+(((-1.0)*cj5*npx*x1018))+(((-2597402597.4026)*npz*sj5))+((cj5*npy*x1017)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*npy*x1018))+(((-1.0)*npx*x1017))))+IKsqr(((((228571428.571429)*cj5))+(((-1.0)*cj5*npx*x1018))+(((-2597402597.4026)*npz*sj5))+((cj5*npy*x1017))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j4array[0]=IKatan2(((((-1.0)*npy*x1018))+(((-1.0)*npx*x1017))), ((((228571428.571429)*cj5))+(((-1.0)*cj5*npx*x1018))+(((-2597402597.4026)*npz*sj5))+((cj5*npy*x1017))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[4];
IkReal x1019=IKcos(j4);
IkReal x1020=IKsin(j4);
IkReal x1021=((1.0)*cj6);
IkReal x1022=(npx*sj6);
IkReal x1023=(cj5*sj6);
IkReal x1024=((0.088)*cj5);
IkReal x1025=((1.0)*npz*sj5);
IkReal x1026=(npx*x1020);
IkReal x1027=(npy*x1019);
IkReal x1028=(cj5*x1019);
IkReal x1029=(npy*x1020);
evalcond[0]=((((-1.0)*x1022))+(((-3.85e-10)*x1020))+(((-1.0)*npy*x1021)));
evalcond[1]=((((-3.85e-10)*x1019))+x1024+((npy*x1023))+(((-1.0)*x1025))+(((-1.0)*cj5*npx*x1021)));
evalcond[2]=((((-1.0)*cj5*x1021*x1026))+(((-1.0)*x1020*x1025))+((x1023*x1029))+((x1019*x1022))+((x1020*x1024))+((cj6*x1027)));
evalcond[3]=((-3.85e-10)+(((-1.0)*x1019*x1025))+(((-1.0)*x1021*x1029))+((x1023*x1027))+((x1019*x1024))+(((-1.0)*npx*x1021*x1028))+(((-1.0)*x1020*x1022)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j4]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1030=cj6*cj6;
IkReal x1031=npx*npx;
IkReal x1032=((0.0825)*cj3);
IkReal x1033=((0.05214)*sj3);
IkReal x1034=((0.00726)*cj5);
IkReal x1035=(npx*sj6);
IkReal x1036=((0.316)*sj3);
IkReal x1037=(npz*sj5);
IkReal x1038=(cj6*npy);
IkReal x1039=(cj5*npy*sj6);
IkReal x1040=(cj5*cj6*npx);
CheckValue<IkReal> x1041=IKPowWithIntegerCheck(((-0.0825)+x1032+x1036),-1);
if(!x1041.valid){
continue;
}
CheckValue<IkReal> x1042=IKPowWithIntegerCheck(((((-1.0)*x1032*x1040))+((x1036*x1039))+(((-1.0)*x1034))+((cj3*x1034))+(((-1.0)*x1032*x1037))+(((-1.0)*x1036*x1037))+(((0.0825)*x1037))+(((0.027808)*cj5*sj3))+(((0.0825)*x1040))+(((-0.0825)*x1039))+(((-1.0)*x1036*x1040))+((x1032*x1039))),-1);
if(!x1042.valid){
continue;
}
if( IKabs(((x1041.value)*((x1038+x1035)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x1042.value)*(((-0.10666225)+x1033+x1031+((x1030*(npy*npy)))+(((2.0)*x1035*x1038))+(((-1.0)*cj3*x1033))+(((0.0136125)*cj3))+(((0.09304975)*(cj3*cj3)))+(((-1.0)*x1030*x1031)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1041.value)*((x1038+x1035))))+IKsqr(((x1042.value)*(((-0.10666225)+x1033+x1031+((x1030*(npy*npy)))+(((2.0)*x1035*x1038))+(((-1.0)*cj3*x1033))+(((0.0136125)*cj3))+(((0.09304975)*(cj3*cj3)))+(((-1.0)*x1030*x1031))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j4array[0]=IKatan2(((x1041.value)*((x1038+x1035))), ((x1042.value)*(((-0.10666225)+x1033+x1031+((x1030*(npy*npy)))+(((2.0)*x1035*x1038))+(((-1.0)*cj3*x1033))+(((0.0136125)*cj3))+(((0.09304975)*(cj3*cj3)))+(((-1.0)*x1030*x1031))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[4];
IkReal x1043=IKsin(j4);
IkReal x1044=IKcos(j4);
IkReal x1045=(npx*sj6);
IkReal x1046=((0.316)*sj3);
IkReal x1047=((0.0825)*cj3);
IkReal x1048=(npy*sj6);
IkReal x1049=((0.088)*cj5);
IkReal x1050=((1.0)*npy);
IkReal x1051=((0.0825)*x1043);
IkReal x1052=(cj6*x1044);
IkReal x1053=((1.0)*npz*sj5);
IkReal x1054=((1.0)*cj5*npx);
IkReal x1055=(cj5*x1043);
IkReal x1056=(cj6*x1043);
evalcond[0]=((((-1.0)*x1051))+((x1043*x1046))+((x1043*x1047))+(((-1.0)*x1045))+(((-1.0)*cj6*x1050)));
evalcond[1]=((((-1.0)*x1053))+x1049+(((-0.0825)*x1044))+((cj5*x1048))+(((-1.0)*cj6*x1054))+((x1044*x1047))+((x1044*x1046)));
evalcond[2]=(((x1043*x1049))+(((-1.0)*x1043*x1053))+((x1048*x1055))+(((-1.0)*x1054*x1056))+((npy*x1052))+((x1044*x1045)));
evalcond[3]=((-0.0825)+(((-1.0)*x1052*x1054))+x1047+x1046+(((-1.0)*x1044*x1053))+(((-1.0)*x1043*x1045))+((cj5*x1044*x1048))+(((-1.0)*x1050*x1056))+((x1044*x1049)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1057=(cj5*npx);
IkReal x1058=(cj6*npy);
IkReal x1059=((0.316)*sj3);
IkReal x1060=((0.0825)*cj3);
IkReal x1061=(npx*sj6);
IkReal x1062=(npz*sj5);
IkReal x1063=(cj5*cj6*sj6);
CheckValue<IkReal> x1064=IKPowWithIntegerCheck(((-0.0825)+x1059+x1060),-1);
if(!x1064.valid){
continue;
}
CheckValue<IkReal> x1065=IKPowWithIntegerCheck((((x1060*x1061))+(((-0.0825)*x1061))+(((-0.0825)*x1058))+((x1059*x1061))+((x1058*x1059))+((x1058*x1060))),-1);
if(!x1065.valid){
continue;
}
if( IKabs(((x1064.value)*((x1058+x1061)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x1065.value)*(((((-0.088)*cj5*x1058))+(((2.0)*cj6*x1057*x1058))+((x1061*x1062))+(((-1.0)*npy*x1057))+((cj6*x1057*x1061))+(((-0.088)*sj6*x1057))+(((-1.0)*cj5*npy*sj6*x1058))+((x1058*x1062)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1064.value)*((x1058+x1061))))+IKsqr(((x1065.value)*(((((-0.088)*cj5*x1058))+(((2.0)*cj6*x1057*x1058))+((x1061*x1062))+(((-1.0)*npy*x1057))+((cj6*x1057*x1061))+(((-0.088)*sj6*x1057))+(((-1.0)*cj5*npy*sj6*x1058))+((x1058*x1062))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j4array[0]=IKatan2(((x1064.value)*((x1058+x1061))), ((x1065.value)*(((((-0.088)*cj5*x1058))+(((2.0)*cj6*x1057*x1058))+((x1061*x1062))+(((-1.0)*npy*x1057))+((cj6*x1057*x1061))+(((-0.088)*sj6*x1057))+(((-1.0)*cj5*npy*sj6*x1058))+((x1058*x1062))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[4];
IkReal x1066=IKsin(j4);
IkReal x1067=IKcos(j4);
IkReal x1068=(npx*sj6);
IkReal x1069=((0.316)*sj3);
IkReal x1070=((0.0825)*cj3);
IkReal x1071=(npy*sj6);
IkReal x1072=((0.088)*cj5);
IkReal x1073=((1.0)*npy);
IkReal x1074=((0.0825)*x1066);
IkReal x1075=(cj6*x1067);
IkReal x1076=((1.0)*npz*sj5);
IkReal x1077=((1.0)*cj5*npx);
IkReal x1078=(cj5*x1066);
IkReal x1079=(cj6*x1066);
evalcond[0]=((((-1.0)*cj6*x1073))+((x1066*x1069))+((x1066*x1070))+(((-1.0)*x1068))+(((-1.0)*x1074)));
evalcond[1]=((((-1.0)*cj6*x1077))+x1072+((x1067*x1070))+((x1067*x1069))+(((-0.0825)*x1067))+((cj5*x1071))+(((-1.0)*x1076)));
evalcond[2]=((((-1.0)*x1077*x1079))+((x1071*x1078))+((x1066*x1072))+((x1067*x1068))+(((-1.0)*x1066*x1076))+((npy*x1075)));
evalcond[3]=((-0.0825)+(((-1.0)*x1075*x1077))+x1070+x1069+(((-1.0)*x1073*x1079))+((x1067*x1072))+(((-1.0)*x1066*x1068))+(((-1.0)*x1067*x1076))+((cj5*x1067*x1071)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
CheckValue<IkReal> x1080 = IKatan2WithCheck(IkReal((((cj6*npy))+((npx*sj6)))),IkReal(((((-0.088)*cj5))+(((-1.0)*cj5*npy*sj6))+((npz*sj5))+((cj5*cj6*npx)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1080.valid){
continue;
}
CheckValue<IkReal> x1081=IKPowWithIntegerCheck(IKsign(((-0.0825)+(((0.0825)*cj3))+(((0.316)*sj3)))),-1);
if(!x1081.valid){
continue;
}
j4array[0]=((-1.5707963267949)+(x1080.value)+(((1.5707963267949)*(x1081.value))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[4];
IkReal x1082=IKsin(j4);
IkReal x1083=IKcos(j4);
IkReal x1084=(npx*sj6);
IkReal x1085=((0.316)*sj3);
IkReal x1086=((0.0825)*cj3);
IkReal x1087=(npy*sj6);
IkReal x1088=((0.088)*cj5);
IkReal x1089=((1.0)*npy);
IkReal x1090=((0.0825)*x1082);
IkReal x1091=(cj6*x1083);
IkReal x1092=((1.0)*npz*sj5);
IkReal x1093=((1.0)*cj5*npx);
IkReal x1094=(cj5*x1082);
IkReal x1095=(cj6*x1082);
evalcond[0]=(((x1082*x1086))+((x1082*x1085))+(((-1.0)*x1090))+(((-1.0)*x1084))+(((-1.0)*cj6*x1089)));
evalcond[1]=(((cj5*x1087))+x1088+(((-1.0)*cj6*x1093))+(((-1.0)*x1092))+(((-0.0825)*x1083))+((x1083*x1086))+((x1083*x1085)));
evalcond[2]=(((x1082*x1088))+((x1087*x1094))+((npy*x1091))+(((-1.0)*x1093*x1095))+(((-1.0)*x1082*x1092))+((x1083*x1084)));
evalcond[3]=((-0.0825)+(((-1.0)*x1082*x1084))+x1086+x1085+(((-1.0)*x1091*x1093))+(((-1.0)*x1083*x1092))+(((-1.0)*x1089*x1095))+((cj5*x1083*x1087))+((x1083*x1088)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}

}
}
}
}
return solutions.GetNumSolutions()>0;
}
inline void rotationfunction0(IkSolutionListBase<IkReal>& solutions) {
for(int rotationiter = 0; rotationiter < 1; ++rotationiter) {
IkReal x115=((1.0)*sj6);
IkReal x116=((1.0)*sj3);
IkReal x117=((1.0)*cj5);
IkReal x118=((1.0)*sj4);
IkReal x119=((1.0)*cj6);
IkReal x120=((-1.0)*sj4);
IkReal x121=((-1.0)*cj5);
IkReal x122=((((-1.0)*r01*x115))+((cj6*r00)));
IkReal x123=((((-1.0)*r11*x115))+((cj6*r10)));
IkReal x124=((((-1.0)*r21*x115))+((cj6*r20)));
IkReal x125=(sj5*x122);
IkReal x126=((((-1.0)*r00*x115))+(((-1.0)*r01*x119)));
IkReal x127=((((-1.0)*r11*x119))+(((-1.0)*r10*x115)));
IkReal x128=((((-1.0)*r20*x115))+(((-1.0)*r21*x119)));
IkReal x129=(((r02*sj5))+((cj5*x122)));
IkReal x130=(((r12*sj5))+((cj5*x123)));
IkReal x131=(((r22*sj5))+((cj5*x124)));
IkReal x132=(((sj5*x124))+(((-1.0)*r22*x117)));
IkReal x133=(cj4*x129);
IkReal x134=(((sj5*x123))+((r12*x121)));
IkReal x135=((((-1.0)*x118*x127))+((cj4*x130)));
IkReal x136=(((x120*x128))+((cj4*x131)));
new_r00=(((cj3*((x133+((x120*x126))))))+(((-1.0)*x116*((x125+(((-1.0)*r02*x117)))))));
new_r01=(((sj4*x129))+((cj4*x126)));
new_r02=(((cj3*((((r02*x121))+x125))))+((sj3*(((((-1.0)*x118*x126))+x133)))));
new_r10=(((cj3*x135))+(((-1.0)*x116*x134)));
new_r11=(((sj4*x130))+((cj4*x127)));
new_r12=(((cj3*x134))+((sj3*x135)));
new_r20=(((cj3*x136))+(((-1.0)*x116*x132)));
new_r21=(((sj4*x131))+((cj4*x128)));
new_r22=(((cj3*x132))+((sj3*x136)));
{
IkReal j1array[2], cj1array[2], sj1array[2];
bool j1valid[2]={false};
_nj1 = 2;
cj1array[0]=new_r22;
if( cj1array[0] >= -1-IKFAST_SINCOS_THRESH && cj1array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j1valid[0] = j1valid[1] = true;
    j1array[0] = IKacos(cj1array[0]);
    sj1array[0] = IKsin(j1array[0]);
    cj1array[1] = cj1array[0];
    j1array[1] = -j1array[0];
    sj1array[1] = -sj1array[0];
}
else if( isnan(cj1array[0]) )
{
    // probably any value will work
    j1valid[0] = true;
    cj1array[0] = 1; sj1array[0] = 0; j1array[0] = 0;
}
for(int ij1 = 0; ij1 < 2; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 2; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];

{
IkReal j0eval[3];
j0eval[0]=sj1;
j0eval[1]=((IKabs(new_r12))+(IKabs(new_r02)));
j0eval[2]=IKsign(sj1);
if( IKabs(j0eval[0]) < 0.0000010000000000  || IKabs(j0eval[1]) < 0.0000010000000000  || IKabs(j0eval[2]) < 0.0000010000000000  )
{
{
IkReal j2eval[3];
j2eval[0]=sj1;
j2eval[1]=IKsign(sj1);
j2eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  || IKabs(j2eval[2]) < 0.0000010000000000  )
{
{
IkReal j0eval[2];
j0eval[0]=new_r12;
j0eval[1]=sj1;
if( IKabs(j0eval[0]) < 0.0000010000000000  || IKabs(j0eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j1))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
IkReal j2mul = 1;
j2=0;
j0mul=-1.0;
if( IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r01))+IKsqr(new_r00)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j0=IKatan2(((-1.0)*new_r01), new_r00);
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].fmul = j0mul;
vinfos[0].freeind = 0;
vinfos[0].maxsolutions = 0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].fmul = j2mul;
vinfos[2].freeind = 0;
vinfos[2].maxsolutions = 0;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(1);
vfree[0] = 2;
solutions.AddSolution(vinfos,vfree);
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j1)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
IkReal j2mul = 1;
j2=0;
j0mul=1.0;
if( IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r01))+IKsqr(((-1.0)*new_r00))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j0=IKatan2(((-1.0)*new_r01), ((-1.0)*new_r00));
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].fmul = j0mul;
vinfos[0].freeind = 0;
vinfos[0].maxsolutions = 0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].fmul = j2mul;
vinfos[2].freeind = 0;
vinfos[2].maxsolutions = 0;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(1);
vfree[0] = 2;
solutions.AddSolution(vinfos,vfree);
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r12))+(IKabs(new_r02)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
IkReal x137=new_r22*new_r22;
IkReal x138=((16.0)*new_r10);
IkReal x139=((16.0)*new_r01);
IkReal x140=((16.0)*new_r22);
IkReal x141=((8.0)*new_r11);
IkReal x142=((8.0)*new_r00);
IkReal x143=(x137*x138);
IkReal x144=(x137*x139);
j0eval[0]=((IKabs((((new_r11*x140))+(((16.0)*new_r00))+(((-32.0)*new_r00*x137)))))+(IKabs((((x137*x141))+(((-1.0)*new_r22*x142)))))+(IKabs(((((-1.0)*x143))+x138)))+(IKabs(((((32.0)*new_r11))+(((-16.0)*new_r11*x137))+(((-1.0)*new_r00*x140)))))+(IKabs((x143+(((-1.0)*x138)))))+(IKabs(((((-1.0)*x144))+x139)))+(IKabs(((((-1.0)*x142))+((new_r22*x141)))))+(IKabs((x144+(((-1.0)*x139))))));
if( IKabs(j0eval[0]) < 0.0000000010000000  )
{
continue; // no branches [j0, j2]

} else
{
IkReal op[4+1], zeror[4];
int numroots;
IkReal j0evalpoly[1];
IkReal x145=new_r22*new_r22;
IkReal x146=((16.0)*new_r10);
IkReal x147=(new_r11*new_r22);
IkReal x148=(x145*x146);
IkReal x149=((((8.0)*x147))+(((-8.0)*new_r00)));
op[0]=x149;
op[1]=((((-1.0)*x148))+x146);
op[2]=((((16.0)*new_r00))+(((16.0)*x147))+(((-32.0)*new_r00*x145)));
op[3]=((((-1.0)*x146))+x148);
op[4]=x149;
polyroots4(op,zeror,numroots);
IkReal j0array[4], cj0array[4], sj0array[4], tempj0array[1];
int numsolutions = 0;
for(int ij0 = 0; ij0 < numroots; ++ij0)
{
IkReal htj0 = zeror[ij0];
tempj0array[0]=((2.0)*(atan(htj0)));
for(int kj0 = 0; kj0 < 1; ++kj0)
{
j0array[numsolutions] = tempj0array[kj0];
if( j0array[numsolutions] > IKPI )
{
    j0array[numsolutions]-=IK2PI;
}
else if( j0array[numsolutions] < -IKPI )
{
    j0array[numsolutions]+=IK2PI;
}
sj0array[numsolutions] = IKsin(j0array[numsolutions]);
cj0array[numsolutions] = IKcos(j0array[numsolutions]);
numsolutions++;
}
}
bool j0valid[4]={true,true,true,true};
_nj0 = 4;
for(int ij0 = 0; ij0 < numsolutions; ++ij0)
    {
if( !j0valid[ij0] )
{
    continue;
}
    j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
htj0 = IKtan(j0/2);

IkReal x150=((16.0)*new_r01);
IkReal x151=new_r22*new_r22;
IkReal x152=(new_r00*new_r22);
IkReal x153=((8.0)*x152);
IkReal x154=(new_r11*x151);
IkReal x155=(x150*x151);
IkReal x156=((8.0)*x154);
j0evalpoly[0]=((((-1.0)*x153))+((htj0*(((((-1.0)*x155))+x150))))+x156+(((htj0*htj0)*(((((32.0)*new_r11))+(((-16.0)*x152))+(((-16.0)*x154))))))+(((htj0*htj0*htj0)*(((((-1.0)*x150))+x155))))+(((htj0*htj0*htj0*htj0)*(((((-1.0)*x153))+x156)))));
if( IKabs(j0evalpoly[0]) > 0.0000000010000000  )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < numsolutions; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
{
IkReal j2eval[3];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
IkReal x157=cj0*cj0;
IkReal x158=(cj0*new_r22);
IkReal x159=((-1.0)+x157+(((-1.0)*x157*(new_r22*new_r22))));
j2eval[0]=x159;
j2eval[1]=IKsign(x159);
j2eval[2]=((IKabs((((new_r01*sj0))+(((-1.0)*new_r00*x158)))))+(IKabs((((new_r01*x158))+((new_r00*sj0))))));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  || IKabs(j2eval[2]) < 0.0000010000000000  )
{
{
IkReal j2eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j2eval[0]=new_r22;
if( IKabs(j2eval[0]) < 0.0000010000000000  )
{
{
IkReal j2eval[2];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
IkReal x160=new_r22*new_r22;
j2eval[0]=(((cj0*x160))+(((-1.0)*cj0)));
j2eval[1]=((((-1.0)*sj0))+((sj0*x160)));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j0)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r00))+IKsqr(((-1.0)*new_r01))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.0)*new_r00), ((-1.0)*new_r01));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x161=IKsin(j2);
IkReal x162=IKcos(j2);
evalcond[0]=x161;
evalcond[1]=((-1.0)*x162);
evalcond[2]=((((-1.0)*x161))+(((-1.0)*new_r00)));
evalcond[3]=((((-1.0)*x162))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j0)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r00)+IKsqr(new_r01)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(new_r00, new_r01);
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x163=IKsin(j2);
IkReal x164=IKcos(j2);
evalcond[0]=x163;
evalcond[1]=((-1.0)*x164);
evalcond[2]=((((-1.0)*x163))+new_r00);
evalcond[3]=((((-1.0)*x164))+new_r01);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j0))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r10)+IKsqr(new_r11)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(new_r10, new_r11);
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x165=IKsin(j2);
IkReal x166=IKcos(j2);
evalcond[0]=x165;
evalcond[1]=((-1.0)*x166);
evalcond[2]=((((-1.0)*x165))+new_r10);
evalcond[3]=((((-1.0)*x166))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j0)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.0)*new_r10), ((-1.0)*new_r11));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x167=IKsin(j2);
IkReal x168=IKcos(j2);
evalcond[0]=x167;
evalcond[1]=((-1.0)*x168);
evalcond[2]=((((-1.0)*x167))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x168))+(((-1.0)*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
CheckValue<IkReal> x169=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x169.valid){
continue;
}
if((x169.value) < -0.00001)
continue;
IkReal gconst0=((-1.0)*(IKsqrt(x169.value)));
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs((cj0+(((-1.0)*gconst0)))))+(IKabs(((-1.0)+(IKsign(sj0)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
if((((1.0)+(((-1.0)*(gconst0*gconst0))))) < -0.00001)
continue;
sj0=IKsqrt(((1.0)+(((-1.0)*(gconst0*gconst0)))));
cj0=gconst0;
if( (gconst0) < -1-IKFAST_SINCOS_THRESH || (gconst0) > 1+IKFAST_SINCOS_THRESH )
    continue;
j0=IKacos(gconst0);
CheckValue<IkReal> x170=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x170.valid){
continue;
}
if((x170.value) < -0.00001)
continue;
IkReal gconst0=((-1.0)*(IKsqrt(x170.value)));
j2eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j2eval[0]) < 0.0000010000000000  )
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if((((1.0)+(((-1.0)*(gconst0*gconst0))))) < -0.00001)
continue;
CheckValue<IkReal> x171=IKPowWithIntegerCheck(gconst0,-1);
if(!x171.valid){
continue;
}
if( IKabs(((((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst0*gconst0))))))))+((gconst0*new_r10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r11*(x171.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst0*gconst0))))))))+((gconst0*new_r10))))+IKsqr((new_r11*(x171.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst0*gconst0))))))))+((gconst0*new_r10))), (new_r11*(x171.value)));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x172=IKcos(j2);
IkReal x173=IKsin(j2);
IkReal x174=((1.0)*gconst0);
if((((1.0)+(((-1.0)*gconst0*x174)))) < -0.00001)
continue;
IkReal x175=IKsqrt(((1.0)+(((-1.0)*gconst0*x174))));
IkReal x176=((1.0)*x175);
evalcond[0]=x173;
evalcond[1]=((-1.0)*x172);
evalcond[2]=(new_r11+(((-1.0)*x172*x174)));
evalcond[3]=(new_r10+(((-1.0)*x173*x174)));
evalcond[4]=(((x172*x175))+new_r01);
evalcond[5]=(((x173*x175))+new_r00);
evalcond[6]=((((-1.0)*x173))+((gconst0*new_r10))+(((-1.0)*new_r00*x176)));
evalcond[7]=((((-1.0)*x172))+((gconst0*new_r11))+(((-1.0)*new_r01*x176)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x177=IKPowWithIntegerCheck(IKsign(gconst0),-1);
if(!x177.valid){
continue;
}
CheckValue<IkReal> x178 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x178.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x177.value)))+(x178.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x179=IKcos(j2);
IkReal x180=IKsin(j2);
IkReal x181=((1.0)*gconst0);
if((((1.0)+(((-1.0)*gconst0*x181)))) < -0.00001)
continue;
IkReal x182=IKsqrt(((1.0)+(((-1.0)*gconst0*x181))));
IkReal x183=((1.0)*x182);
evalcond[0]=x180;
evalcond[1]=((-1.0)*x179);
evalcond[2]=(new_r11+(((-1.0)*x179*x181)));
evalcond[3]=((((-1.0)*x180*x181))+new_r10);
evalcond[4]=(((x179*x182))+new_r01);
evalcond[5]=(((x180*x182))+new_r00);
evalcond[6]=((((-1.0)*x180))+((gconst0*new_r10))+(((-1.0)*new_r00*x183)));
evalcond[7]=((((-1.0)*x179))+(((-1.0)*new_r01*x183))+((gconst0*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
CheckValue<IkReal> x184=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x184.valid){
continue;
}
if((x184.value) < -0.00001)
continue;
IkReal gconst0=((-1.0)*(IKsqrt(x184.value)));
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.0)+(IKsign(sj0)))))+(IKabs((cj0+(((-1.0)*gconst0)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
if((((1.0)+(((-1.0)*(gconst0*gconst0))))) < -0.00001)
continue;
sj0=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst0*gconst0)))))));
cj0=gconst0;
if( (gconst0) < -1-IKFAST_SINCOS_THRESH || (gconst0) > 1+IKFAST_SINCOS_THRESH )
    continue;
j0=((-1.0)*(IKacos(gconst0)));
CheckValue<IkReal> x185=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x185.valid){
continue;
}
if((x185.value) < -0.00001)
continue;
IkReal gconst0=((-1.0)*(IKsqrt(x185.value)));
j2eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j2eval[0]) < 0.0000010000000000  )
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if((((1.0)+(((-1.0)*(gconst0*gconst0))))) < -0.00001)
continue;
CheckValue<IkReal> x186=IKPowWithIntegerCheck(gconst0,-1);
if(!x186.valid){
continue;
}
if( IKabs((((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst0*gconst0))))))))+((gconst0*new_r10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r11*(x186.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst0*gconst0))))))))+((gconst0*new_r10))))+IKsqr((new_r11*(x186.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2((((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst0*gconst0))))))))+((gconst0*new_r10))), (new_r11*(x186.value)));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x187=IKcos(j2);
IkReal x188=IKsin(j2);
IkReal x189=((1.0)*x188);
IkReal x190=((1.0)*x187);
if((((1.0)+(((-1.0)*(gconst0*gconst0))))) < -0.00001)
continue;
IkReal x191=IKsqrt(((1.0)+(((-1.0)*(gconst0*gconst0)))));
evalcond[0]=x188;
evalcond[1]=((-1.0)*x187);
evalcond[2]=((((-1.0)*gconst0*x190))+new_r11);
evalcond[3]=(new_r10+(((-1.0)*gconst0*x189)));
evalcond[4]=((((-1.0)*x190*x191))+new_r01);
evalcond[5]=((((-1.0)*x189*x191))+new_r00);
evalcond[6]=(((new_r00*x191))+(((-1.0)*x189))+((gconst0*new_r10)));
evalcond[7]=(((new_r01*x191))+(((-1.0)*x190))+((gconst0*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x192=IKPowWithIntegerCheck(IKsign(gconst0),-1);
if(!x192.valid){
continue;
}
CheckValue<IkReal> x193 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x193.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x192.value)))+(x193.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x194=IKcos(j2);
IkReal x195=IKsin(j2);
IkReal x196=((1.0)*x195);
IkReal x197=((1.0)*x194);
if((((1.0)+(((-1.0)*(gconst0*gconst0))))) < -0.00001)
continue;
IkReal x198=IKsqrt(((1.0)+(((-1.0)*(gconst0*gconst0)))));
evalcond[0]=x195;
evalcond[1]=((-1.0)*x194);
evalcond[2]=((((-1.0)*gconst0*x197))+new_r11);
evalcond[3]=((((-1.0)*gconst0*x196))+new_r10);
evalcond[4]=((((-1.0)*x197*x198))+new_r01);
evalcond[5]=((((-1.0)*x196*x198))+new_r00);
evalcond[6]=(((new_r00*x198))+(((-1.0)*x196))+((gconst0*new_r10)));
evalcond[7]=(((new_r01*x198))+(((-1.0)*x197))+((gconst0*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
CheckValue<IkReal> x199=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x199.valid){
continue;
}
if((x199.value) < -0.00001)
continue;
IkReal gconst1=IKsqrt(x199.value);
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs((cj0+(((-1.0)*gconst1)))))+(IKabs(((-1.0)+(IKsign(sj0)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
if((((1.0)+(((-1.0)*(gconst1*gconst1))))) < -0.00001)
continue;
sj0=IKsqrt(((1.0)+(((-1.0)*(gconst1*gconst1)))));
cj0=gconst1;
if( (gconst1) < -1-IKFAST_SINCOS_THRESH || (gconst1) > 1+IKFAST_SINCOS_THRESH )
    continue;
j0=IKacos(gconst1);
CheckValue<IkReal> x200=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x200.valid){
continue;
}
if((x200.value) < -0.00001)
continue;
IkReal gconst1=IKsqrt(x200.value);
j2eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j2eval[0]) < 0.0000010000000000  )
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if((((1.0)+(((-1.0)*(gconst1*gconst1))))) < -0.00001)
continue;
CheckValue<IkReal> x201=IKPowWithIntegerCheck(gconst1,-1);
if(!x201.valid){
continue;
}
if( IKabs((((gconst1*new_r10))+(((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst1*gconst1)))))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r11*(x201.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((gconst1*new_r10))+(((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst1*gconst1))))))))))+IKsqr((new_r11*(x201.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2((((gconst1*new_r10))+(((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst1*gconst1))))))))), (new_r11*(x201.value)));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x202=IKcos(j2);
IkReal x203=IKsin(j2);
IkReal x204=((1.0)*gconst1);
if((((1.0)+(((-1.0)*gconst1*x204)))) < -0.00001)
continue;
IkReal x205=IKsqrt(((1.0)+(((-1.0)*gconst1*x204))));
IkReal x206=((1.0)*x205);
evalcond[0]=x203;
evalcond[1]=((-1.0)*x202);
evalcond[2]=((((-1.0)*x202*x204))+new_r11);
evalcond[3]=((((-1.0)*x203*x204))+new_r10);
evalcond[4]=(((x202*x205))+new_r01);
evalcond[5]=(((x203*x205))+new_r00);
evalcond[6]=((((-1.0)*new_r00*x206))+((gconst1*new_r10))+(((-1.0)*x203)));
evalcond[7]=(((gconst1*new_r11))+(((-1.0)*x202))+(((-1.0)*new_r01*x206)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x207=IKPowWithIntegerCheck(IKsign(gconst1),-1);
if(!x207.valid){
continue;
}
CheckValue<IkReal> x208 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x208.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x207.value)))+(x208.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x209=IKcos(j2);
IkReal x210=IKsin(j2);
IkReal x211=((1.0)*gconst1);
if((((1.0)+(((-1.0)*gconst1*x211)))) < -0.00001)
continue;
IkReal x212=IKsqrt(((1.0)+(((-1.0)*gconst1*x211))));
IkReal x213=((1.0)*x212);
evalcond[0]=x210;
evalcond[1]=((-1.0)*x209);
evalcond[2]=(new_r11+(((-1.0)*x209*x211)));
evalcond[3]=((((-1.0)*x210*x211))+new_r10);
evalcond[4]=(((x209*x212))+new_r01);
evalcond[5]=(((x210*x212))+new_r00);
evalcond[6]=(((gconst1*new_r10))+(((-1.0)*x210))+(((-1.0)*new_r00*x213)));
evalcond[7]=(((gconst1*new_r11))+(((-1.0)*new_r01*x213))+(((-1.0)*x209)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
CheckValue<IkReal> x214=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x214.valid){
continue;
}
if((x214.value) < -0.00001)
continue;
IkReal gconst1=IKsqrt(x214.value);
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.0)+(IKsign(sj0)))))+(IKabs((cj0+(((-1.0)*gconst1)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
if((((1.0)+(((-1.0)*(gconst1*gconst1))))) < -0.00001)
continue;
sj0=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst1*gconst1)))))));
cj0=gconst1;
if( (gconst1) < -1-IKFAST_SINCOS_THRESH || (gconst1) > 1+IKFAST_SINCOS_THRESH )
    continue;
j0=((-1.0)*(IKacos(gconst1)));
CheckValue<IkReal> x215=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x215.valid){
continue;
}
if((x215.value) < -0.00001)
continue;
IkReal gconst1=IKsqrt(x215.value);
j2eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j2eval[0]) < 0.0000010000000000  )
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if((((1.0)+(((-1.0)*(gconst1*gconst1))))) < -0.00001)
continue;
CheckValue<IkReal> x216=IKPowWithIntegerCheck(gconst1,-1);
if(!x216.valid){
continue;
}
if( IKabs((((gconst1*new_r10))+((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst1*gconst1)))))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r11*(x216.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((gconst1*new_r10))+((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst1*gconst1))))))))))+IKsqr((new_r11*(x216.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2((((gconst1*new_r10))+((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst1*gconst1))))))))), (new_r11*(x216.value)));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x217=IKcos(j2);
IkReal x218=IKsin(j2);
IkReal x219=((1.0)*x217);
IkReal x220=((1.0)*x218);
if((((1.0)+(((-1.0)*(gconst1*gconst1))))) < -0.00001)
continue;
IkReal x221=IKsqrt(((1.0)+(((-1.0)*(gconst1*gconst1)))));
evalcond[0]=x218;
evalcond[1]=((-1.0)*x217);
evalcond[2]=((((-1.0)*gconst1*x219))+new_r11);
evalcond[3]=((((-1.0)*gconst1*x220))+new_r10);
evalcond[4]=((((-1.0)*x219*x221))+new_r01);
evalcond[5]=((((-1.0)*x220*x221))+new_r00);
evalcond[6]=(((new_r00*x221))+((gconst1*new_r10))+(((-1.0)*x220)));
evalcond[7]=(((new_r01*x221))+((gconst1*new_r11))+(((-1.0)*x219)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x222=IKPowWithIntegerCheck(IKsign(gconst1),-1);
if(!x222.valid){
continue;
}
CheckValue<IkReal> x223 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x223.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x222.value)))+(x223.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x224=IKcos(j2);
IkReal x225=IKsin(j2);
IkReal x226=((1.0)*x224);
IkReal x227=((1.0)*x225);
if((((1.0)+(((-1.0)*(gconst1*gconst1))))) < -0.00001)
continue;
IkReal x228=IKsqrt(((1.0)+(((-1.0)*(gconst1*gconst1)))));
evalcond[0]=x225;
evalcond[1]=((-1.0)*x224);
evalcond[2]=((((-1.0)*gconst1*x226))+new_r11);
evalcond[3]=((((-1.0)*gconst1*x227))+new_r10);
evalcond[4]=(new_r01+(((-1.0)*x226*x228)));
evalcond[5]=((((-1.0)*x227*x228))+new_r00);
evalcond[6]=(((new_r00*x228))+((gconst1*new_r10))+(((-1.0)*x227)));
evalcond[7]=(((new_r01*x228))+((gconst1*new_r11))+(((-1.0)*x226)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j2]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x229=new_r22*new_r22;
CheckValue<IkReal> x230=IKPowWithIntegerCheck((((cj0*x229))+(((-1.0)*cj0))),-1);
if(!x230.valid){
continue;
}
CheckValue<IkReal> x231=IKPowWithIntegerCheck(((((-1.0)*sj0))+((sj0*x229))),-1);
if(!x231.valid){
continue;
}
if( IKabs(((x230.value)*(((((-1.0)*new_r01*new_r22))+(((-1.0)*new_r10)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x231.value)*((((new_r10*new_r22))+new_r01)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x230.value)*(((((-1.0)*new_r01*new_r22))+(((-1.0)*new_r10))))))+IKsqr(((x231.value)*((((new_r10*new_r22))+new_r01))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((x230.value)*(((((-1.0)*new_r01*new_r22))+(((-1.0)*new_r10))))), ((x231.value)*((((new_r10*new_r22))+new_r01))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[10];
IkReal x232=IKsin(j2);
IkReal x233=IKcos(j2);
IkReal x234=(cj0*new_r22);
IkReal x235=(new_r22*sj0);
IkReal x236=((1.0)*sj0);
IkReal x237=((1.0)*x233);
IkReal x238=((1.0)*x232);
evalcond[0]=(((new_r11*sj0))+((new_r22*x232))+((cj0*new_r01)));
evalcond[1]=(((new_r11*x235))+((new_r01*x234))+x232);
evalcond[2]=((((-1.0)*x238))+((cj0*new_r10))+(((-1.0)*new_r00*x236)));
evalcond[3]=((((-1.0)*x237))+(((-1.0)*new_r01*x236))+((cj0*new_r11)));
evalcond[4]=(((sj0*x233))+((x232*x234))+new_r01);
evalcond[5]=((((-1.0)*new_r22*x237))+((new_r10*sj0))+((cj0*new_r00)));
evalcond[6]=(((sj0*x232))+new_r00+(((-1.0)*x234*x237)));
evalcond[7]=(((x232*x235))+(((-1.0)*cj0*x237))+new_r11);
evalcond[8]=(((new_r10*x235))+((new_r00*x234))+(((-1.0)*x237)));
evalcond[9]=((((-1.0)*x235*x237))+(((-1.0)*cj0*x238))+new_r10);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x239=((1.0)*new_r01);
CheckValue<IkReal> x240=IKPowWithIntegerCheck(new_r22,-1);
if(!x240.valid){
continue;
}
if( IKabs(((x240.value)*(((((-1.0)*cj0*x239))+(((-1.0)*new_r11*sj0)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj0*new_r11))+(((-1.0)*sj0*x239)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x240.value)*(((((-1.0)*cj0*x239))+(((-1.0)*new_r11*sj0))))))+IKsqr((((cj0*new_r11))+(((-1.0)*sj0*x239))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((x240.value)*(((((-1.0)*cj0*x239))+(((-1.0)*new_r11*sj0))))), (((cj0*new_r11))+(((-1.0)*sj0*x239))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[10];
IkReal x241=IKsin(j2);
IkReal x242=IKcos(j2);
IkReal x243=(cj0*new_r22);
IkReal x244=(new_r22*sj0);
IkReal x245=((1.0)*sj0);
IkReal x246=((1.0)*x242);
IkReal x247=((1.0)*x241);
evalcond[0]=(((new_r11*sj0))+((new_r22*x241))+((cj0*new_r01)));
evalcond[1]=(x241+((new_r01*x243))+((new_r11*x244)));
evalcond[2]=((((-1.0)*new_r00*x245))+(((-1.0)*x247))+((cj0*new_r10)));
evalcond[3]=((((-1.0)*new_r01*x245))+(((-1.0)*x246))+((cj0*new_r11)));
evalcond[4]=(((x241*x243))+new_r01+((sj0*x242)));
evalcond[5]=(((new_r10*sj0))+(((-1.0)*new_r22*x246))+((cj0*new_r00)));
evalcond[6]=((((-1.0)*x243*x246))+new_r00+((sj0*x241)));
evalcond[7]=(((x241*x244))+(((-1.0)*cj0*x246))+new_r11);
evalcond[8]=(((new_r00*x243))+(((-1.0)*x246))+((new_r10*x244)));
evalcond[9]=((((-1.0)*cj0*x247))+new_r10+(((-1.0)*x244*x246)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x248=cj0*cj0;
IkReal x249=(cj0*new_r22);
CheckValue<IkReal> x250 = IKatan2WithCheck(IkReal((((new_r00*sj0))+((new_r01*x249)))),IkReal(((((-1.0)*new_r00*x249))+((new_r01*sj0)))),IKFAST_ATAN2_MAGTHRESH);
if(!x250.valid){
continue;
}
CheckValue<IkReal> x251=IKPowWithIntegerCheck(IKsign(((-1.0)+x248+(((-1.0)*x248*(new_r22*new_r22))))),-1);
if(!x251.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(x250.value)+(((1.5707963267949)*(x251.value))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[10];
IkReal x252=IKsin(j2);
IkReal x253=IKcos(j2);
IkReal x254=(cj0*new_r22);
IkReal x255=(new_r22*sj0);
IkReal x256=((1.0)*sj0);
IkReal x257=((1.0)*x253);
IkReal x258=((1.0)*x252);
evalcond[0]=(((new_r11*sj0))+((new_r22*x252))+((cj0*new_r01)));
evalcond[1]=(((new_r01*x254))+x252+((new_r11*x255)));
evalcond[2]=(((cj0*new_r10))+(((-1.0)*new_r00*x256))+(((-1.0)*x258)));
evalcond[3]=((((-1.0)*new_r01*x256))+((cj0*new_r11))+(((-1.0)*x257)));
evalcond[4]=(((sj0*x253))+((x252*x254))+new_r01);
evalcond[5]=(((new_r10*sj0))+((cj0*new_r00))+(((-1.0)*new_r22*x257)));
evalcond[6]=(((sj0*x252))+(((-1.0)*x254*x257))+new_r00);
evalcond[7]=((((-1.0)*cj0*x257))+((x252*x255))+new_r11);
evalcond[8]=(((new_r00*x254))+((new_r10*x255))+(((-1.0)*x257)));
evalcond[9]=((((-1.0)*cj0*x258))+(((-1.0)*x255*x257))+new_r10);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j0, j2]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
CheckValue<IkReal> x260=IKPowWithIntegerCheck(sj1,-1);
if(!x260.valid){
continue;
}
IkReal x259=x260.value;
CheckValue<IkReal> x261=IKPowWithIntegerCheck(new_r12,-1);
if(!x261.valid){
continue;
}
if( IKabs((x259*(x261.value)*(((1.0)+(((-1.0)*(new_r02*new_r02)))+(((-1.0)*(cj1*cj1))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r02*x259)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x259*(x261.value)*(((1.0)+(((-1.0)*(new_r02*new_r02)))+(((-1.0)*(cj1*cj1)))))))+IKsqr((new_r02*x259))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j0array[0]=IKatan2((x259*(x261.value)*(((1.0)+(((-1.0)*(new_r02*new_r02)))+(((-1.0)*(cj1*cj1)))))), (new_r02*x259));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[8];
IkReal x262=IKcos(j0);
IkReal x263=IKsin(j0);
IkReal x264=((1.0)*cj1);
IkReal x265=((1.0)*sj1);
IkReal x266=(new_r12*x263);
IkReal x267=(new_r02*x262);
evalcond[0]=((((-1.0)*x262*x265))+new_r02);
evalcond[1]=((((-1.0)*x263*x265))+new_r12);
evalcond[2]=(((new_r12*x262))+(((-1.0)*new_r02*x263)));
evalcond[3]=(x267+x266+(((-1.0)*x265)));
evalcond[4]=(((cj1*x267))+((cj1*x266))+(((-1.0)*new_r22*x265)));
evalcond[5]=((((-1.0)*new_r00*x262*x265))+(((-1.0)*new_r20*x264))+(((-1.0)*new_r10*x263*x265)));
evalcond[6]=((((-1.0)*new_r01*x262*x265))+(((-1.0)*new_r11*x263*x265))+(((-1.0)*new_r21*x264)));
evalcond[7]=((1.0)+(((-1.0)*new_r22*x264))+(((-1.0)*x265*x266))+(((-1.0)*x265*x267)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j2eval[3];
j2eval[0]=sj1;
j2eval[1]=IKsign(sj1);
j2eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  || IKabs(j2eval[2]) < 0.0000010000000000  )
{
{
IkReal j2eval[2];
j2eval[0]=sj0;
j2eval[1]=sj1;
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
{
IkReal j2eval[3];
j2eval[0]=cj0;
j2eval[1]=cj1;
j2eval[2]=sj1;
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  || IKabs(j2eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j0)))), 6.28318530717959)));
evalcond[1]=new_r02;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2eval[3];
sj0=1.0;
cj0=0;
j0=1.5707963267949;
j2eval[0]=sj1;
j2eval[1]=IKsign(sj1);
j2eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  || IKabs(j2eval[2]) < 0.0000010000000000  )
{
{
IkReal j2eval[3];
sj0=1.0;
cj0=0;
j0=1.5707963267949;
j2eval[0]=cj1;
j2eval[1]=IKsign(cj1);
j2eval[2]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  || IKabs(j2eval[2]) < 0.0000010000000000  )
{
{
IkReal j2eval[1];
sj0=1.0;
cj0=0;
j0=1.5707963267949;
j2eval[0]=sj1;
if( IKabs(j2eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[4];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j1))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r12;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r11))+IKsqr(new_r10)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.0)*new_r11), new_r10);
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x268=IKsin(j2);
IkReal x269=((1.0)*(IKcos(j2)));
evalcond[0]=(x268+new_r11);
evalcond[1]=(new_r10+(((-1.0)*x269)));
evalcond[2]=((((-1.0)*x268))+(((-1.0)*new_r00)));
evalcond[3]=((((-1.0)*new_r01))+(((-1.0)*x269)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j1)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r12;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r11)+IKsqr(((-1.0)*new_r10))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(new_r11, ((-1.0)*new_r10));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x270=IKcos(j2);
IkReal x271=((1.0)*(IKsin(j2)));
evalcond[0]=(x270+new_r10);
evalcond[1]=((((-1.0)*x271))+new_r11);
evalcond[2]=((((-1.0)*x271))+(((-1.0)*new_r00)));
evalcond[3]=((((-1.0)*x270))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j1)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r11;
evalcond[3]=new_r10;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x272=IKcos(j2);
IkReal x273=((1.0)*(IKsin(j2)));
evalcond[0]=(x272+new_r20);
evalcond[1]=((((-1.0)*x273))+new_r21);
evalcond[2]=((((-1.0)*x273))+(((-1.0)*new_r00)));
evalcond[3]=((((-1.0)*x272))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j1)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r11;
evalcond[3]=new_r10;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x274=IKsin(j2);
IkReal x275=((1.0)*(IKcos(j2)));
evalcond[0]=(x274+new_r21);
evalcond[1]=((((-1.0)*x275))+new_r20);
evalcond[2]=((((-1.0)*x274))+(((-1.0)*new_r00)));
evalcond[3]=((((-1.0)*x275))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r00))+IKsqr(((-1.0)*new_r01))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.0)*new_r00), ((-1.0)*new_r01));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[6];
IkReal x276=IKsin(j2);
IkReal x277=IKcos(j2);
IkReal x278=((-1.0)*x277);
evalcond[0]=x276;
evalcond[1]=(new_r22*x276);
evalcond[2]=x278;
evalcond[3]=(new_r22*x278);
evalcond[4]=((((-1.0)*x276))+(((-1.0)*new_r00)));
evalcond[5]=((((-1.0)*x277))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j2]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x279=IKPowWithIntegerCheck(sj1,-1);
if(!x279.valid){
continue;
}
if( IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*(x279.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r00))+IKsqr(((-1.0)*new_r20*(x279.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.0)*new_r00), ((-1.0)*new_r20*(x279.value)));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x280=IKsin(j2);
IkReal x281=IKcos(j2);
IkReal x282=((1.0)*sj1);
IkReal x283=((1.0)*x281);
evalcond[0]=(new_r20+((sj1*x281)));
evalcond[1]=(new_r11+((cj1*x280)));
evalcond[2]=((((-1.0)*x280*x282))+new_r21);
evalcond[3]=((((-1.0)*cj1*x283))+new_r10);
evalcond[4]=((((-1.0)*x280))+(((-1.0)*new_r00)));
evalcond[5]=((((-1.0)*x283))+(((-1.0)*new_r01)));
evalcond[6]=(((cj1*new_r11))+x280+(((-1.0)*new_r21*x282)));
evalcond[7]=(((cj1*new_r10))+(((-1.0)*x283))+(((-1.0)*new_r20*x282)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x284=IKPowWithIntegerCheck(IKsign(cj1),-1);
if(!x284.valid){
continue;
}
CheckValue<IkReal> x285 = IKatan2WithCheck(IkReal(((-1.0)*new_r11)),IkReal(new_r10),IKFAST_ATAN2_MAGTHRESH);
if(!x285.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x284.value)))+(x285.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x286=IKsin(j2);
IkReal x287=IKcos(j2);
IkReal x288=((1.0)*sj1);
IkReal x289=((1.0)*x287);
evalcond[0]=(new_r20+((sj1*x287)));
evalcond[1]=(new_r11+((cj1*x286)));
evalcond[2]=(new_r21+(((-1.0)*x286*x288)));
evalcond[3]=((((-1.0)*cj1*x289))+new_r10);
evalcond[4]=((((-1.0)*x286))+(((-1.0)*new_r00)));
evalcond[5]=((((-1.0)*x289))+(((-1.0)*new_r01)));
evalcond[6]=(((cj1*new_r11))+x286+(((-1.0)*new_r21*x288)));
evalcond[7]=(((cj1*new_r10))+(((-1.0)*x289))+(((-1.0)*new_r20*x288)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x290=IKPowWithIntegerCheck(IKsign(sj1),-1);
if(!x290.valid){
continue;
}
CheckValue<IkReal> x291 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x291.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x290.value)))+(x291.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x292=IKsin(j2);
IkReal x293=IKcos(j2);
IkReal x294=((1.0)*sj1);
IkReal x295=((1.0)*x293);
evalcond[0]=(((sj1*x293))+new_r20);
evalcond[1]=(((cj1*x292))+new_r11);
evalcond[2]=(new_r21+(((-1.0)*x292*x294)));
evalcond[3]=((((-1.0)*cj1*x295))+new_r10);
evalcond[4]=((((-1.0)*x292))+(((-1.0)*new_r00)));
evalcond[5]=((((-1.0)*x295))+(((-1.0)*new_r01)));
evalcond[6]=((((-1.0)*new_r21*x294))+((cj1*new_r11))+x292);
evalcond[7]=((((-1.0)*new_r20*x294))+(((-1.0)*x295))+((cj1*new_r10)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j0)))), 6.28318530717959)));
evalcond[1]=new_r02;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r00)+IKsqr(new_r01)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(new_r00, new_r01);
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x296=IKcos(j2);
IkReal x297=IKsin(j2);
IkReal x298=((1.0)*sj1);
IkReal x299=((1.0)*new_r11);
IkReal x300=((1.0)*new_r10);
IkReal x301=((1.0)*x296);
evalcond[0]=(((sj1*x296))+new_r20);
evalcond[1]=((((-1.0)*x297))+new_r00);
evalcond[2]=(new_r01+(((-1.0)*x301)));
evalcond[3]=((((-1.0)*x297*x298))+new_r21);
evalcond[4]=(((cj1*x297))+(((-1.0)*x299)));
evalcond[5]=((((-1.0)*cj1*x301))+(((-1.0)*x300)));
evalcond[6]=((((-1.0)*cj1*x299))+(((-1.0)*new_r21*x298))+x297);
evalcond[7]=((((-1.0)*new_r20*x298))+(((-1.0)*cj1*x300))+(((-1.0)*x301)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j1)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x302=IKcos(j2);
IkReal x303=IKsin(j2);
IkReal x304=((1.0)*sj0);
IkReal x305=((1.0)*x303);
IkReal x306=((1.0)*x302);
evalcond[0]=(x302+new_r20);
evalcond[1]=(new_r21+(((-1.0)*x305)));
evalcond[2]=(((sj0*x302))+new_r01);
evalcond[3]=(((sj0*x303))+new_r00);
evalcond[4]=((((-1.0)*cj0*x306))+new_r11);
evalcond[5]=((((-1.0)*new_r02*x305))+new_r10);
evalcond[6]=((((-1.0)*new_r00*x304))+((cj0*new_r10))+(((-1.0)*x305)));
evalcond[7]=((((-1.0)*new_r01*x304))+((cj0*new_r11))+(((-1.0)*x306)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j1)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x307=IKcos(j2);
IkReal x308=IKsin(j2);
IkReal x309=((1.0)*sj0);
IkReal x310=((1.0)*x307);
evalcond[0]=(x308+new_r21);
evalcond[1]=((((-1.0)*x310))+new_r20);
evalcond[2]=(((sj0*x307))+new_r01);
evalcond[3]=(((sj0*x308))+new_r00);
evalcond[4]=(((new_r02*x308))+new_r10);
evalcond[5]=((((-1.0)*cj0*x310))+new_r11);
evalcond[6]=((((-1.0)*x308))+(((-1.0)*new_r00*x309))+((cj0*new_r10)));
evalcond[7]=((((-1.0)*x310))+(((-1.0)*new_r01*x309))+((cj0*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j1))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x311=((1.0)*new_r01);
if( IKabs(((((-1.0)*cj0*x311))+(((-1.0)*new_r00*sj0)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj0*new_r00))+(((-1.0)*sj0*x311)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*cj0*x311))+(((-1.0)*new_r00*sj0))))+IKsqr((((cj0*new_r00))+(((-1.0)*sj0*x311))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((-1.0)*cj0*x311))+(((-1.0)*new_r00*sj0))), (((cj0*new_r00))+(((-1.0)*sj0*x311))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x312=IKsin(j2);
IkReal x313=IKcos(j2);
IkReal x314=((1.0)*sj0);
IkReal x315=((1.0)*x313);
IkReal x316=(sj0*x312);
IkReal x317=(cj0*x312);
IkReal x318=(cj0*x315);
evalcond[0]=(((new_r11*sj0))+x312+((cj0*new_r01)));
evalcond[1]=(((sj0*x313))+x317+new_r01);
evalcond[2]=(((new_r10*sj0))+(((-1.0)*x315))+((cj0*new_r00)));
evalcond[3]=((((-1.0)*new_r00*x314))+(((-1.0)*x312))+((cj0*new_r10)));
evalcond[4]=((((-1.0)*x315))+((cj0*new_r11))+(((-1.0)*new_r01*x314)));
evalcond[5]=(x316+(((-1.0)*x318))+new_r00);
evalcond[6]=(x316+(((-1.0)*x318))+new_r11);
evalcond[7]=((((-1.0)*x313*x314))+(((-1.0)*x317))+new_r10);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j1)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x319=((1.0)*sj0);
if( IKabs(((((-1.0)*new_r00*x319))+((cj0*new_r01)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*cj0*new_r00))+(((-1.0)*new_r01*x319)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*x319))+((cj0*new_r01))))+IKsqr(((((-1.0)*cj0*new_r00))+(((-1.0)*new_r01*x319))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((-1.0)*new_r00*x319))+((cj0*new_r01))), ((((-1.0)*cj0*new_r00))+(((-1.0)*new_r01*x319))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x320=IKsin(j2);
IkReal x321=IKcos(j2);
IkReal x322=((1.0)*sj0);
IkReal x323=((1.0)*x320);
IkReal x324=(sj0*x321);
IkReal x325=((1.0)*x321);
IkReal x326=(cj0*x323);
evalcond[0]=(((new_r10*sj0))+x321+((cj0*new_r00)));
evalcond[1]=(((new_r11*sj0))+(((-1.0)*x323))+((cj0*new_r01)));
evalcond[2]=(((cj0*x321))+((sj0*x320))+new_r00);
evalcond[3]=((((-1.0)*x323))+(((-1.0)*new_r00*x322))+((cj0*new_r10)));
evalcond[4]=((((-1.0)*x325))+(((-1.0)*new_r01*x322))+((cj0*new_r11)));
evalcond[5]=((((-1.0)*x326))+x324+new_r01);
evalcond[6]=((((-1.0)*x326))+x324+new_r10);
evalcond[7]=((((-1.0)*x320*x322))+(((-1.0)*cj0*x325))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j0))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r10)+IKsqr(new_r11)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(new_r10, new_r11);
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x327=IKcos(j2);
IkReal x328=IKsin(j2);
IkReal x329=((1.0)*sj1);
IkReal x330=((1.0)*x327);
evalcond[0]=(((sj1*x327))+new_r20);
evalcond[1]=((((-1.0)*x328))+new_r10);
evalcond[2]=((((-1.0)*x330))+new_r11);
evalcond[3]=(((cj1*x328))+new_r01);
evalcond[4]=(new_r21+(((-1.0)*x328*x329)));
evalcond[5]=(new_r00+(((-1.0)*cj1*x330)));
evalcond[6]=(((cj1*new_r01))+x328+(((-1.0)*new_r21*x329)));
evalcond[7]=(((cj1*new_r00))+(((-1.0)*x330))+(((-1.0)*new_r20*x329)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j0)))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2eval[3];
sj0=0;
cj0=-1.0;
j0=3.14159265358979;
j2eval[0]=sj1;
j2eval[1]=IKsign(sj1);
j2eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  || IKabs(j2eval[2]) < 0.0000010000000000  )
{
{
IkReal j2eval[1];
sj0=0;
cj0=-1.0;
j0=3.14159265358979;
j2eval[0]=sj1;
if( IKabs(j2eval[0]) < 0.0000010000000000  )
{
{
IkReal j2eval[2];
sj0=0;
cj0=-1.0;
j0=3.14159265358979;
j2eval[0]=cj1;
j2eval[1]=sj1;
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[4];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j1)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x331=IKcos(j2);
IkReal x332=((1.0)*(IKsin(j2)));
evalcond[0]=(x331+new_r20);
evalcond[1]=((((-1.0)*x332))+new_r21);
evalcond[2]=((((-1.0)*new_r10))+(((-1.0)*x332)));
evalcond[3]=((((-1.0)*x331))+(((-1.0)*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j1)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x333=IKsin(j2);
IkReal x334=((1.0)*(IKcos(j2)));
evalcond[0]=(x333+new_r21);
evalcond[1]=((((-1.0)*x334))+new_r20);
evalcond[2]=((((-1.0)*x333))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*new_r11))+(((-1.0)*x334)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j1))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r01)+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(new_r01, ((-1.0)*new_r11));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x335=IKsin(j2);
IkReal x336=((1.0)*(IKcos(j2)));
evalcond[0]=(x335+(((-1.0)*new_r01)));
evalcond[1]=((((-1.0)*x335))+(((-1.0)*new_r10)));
evalcond[2]=((((-1.0)*new_r11))+(((-1.0)*x336)));
evalcond[3]=((((-1.0)*x336))+(((-1.0)*new_r00)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j1)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(new_r00)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.0)*new_r10), new_r00);
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x337=IKcos(j2);
IkReal x338=((1.0)*(IKsin(j2)));
evalcond[0]=(x337+(((-1.0)*new_r00)));
evalcond[1]=((((-1.0)*new_r10))+(((-1.0)*x338)));
evalcond[2]=((((-1.0)*x337))+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*x338))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.0)*new_r10), ((-1.0)*new_r11));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[6];
IkReal x339=IKsin(j2);
IkReal x340=IKcos(j2);
IkReal x341=((-1.0)*x340);
evalcond[0]=x339;
evalcond[1]=(new_r22*x339);
evalcond[2]=x341;
evalcond[3]=(new_r22*x341);
evalcond[4]=((((-1.0)*x339))+(((-1.0)*new_r10)));
evalcond[5]=((((-1.0)*new_r11))+(((-1.0)*x340)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j2]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x342=IKPowWithIntegerCheck(cj1,-1);
if(!x342.valid){
continue;
}
CheckValue<IkReal> x343=IKPowWithIntegerCheck(sj1,-1);
if(!x343.valid){
continue;
}
if( IKabs((new_r01*(x342.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*(x343.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r01*(x342.value)))+IKsqr(((-1.0)*new_r20*(x343.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2((new_r01*(x342.value)), ((-1.0)*new_r20*(x343.value)));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x344=IKsin(j2);
IkReal x345=IKcos(j2);
IkReal x346=((1.0)*new_r00);
IkReal x347=((1.0)*sj1);
IkReal x348=((1.0)*new_r01);
IkReal x349=((1.0)*x345);
evalcond[0]=(((sj1*x345))+new_r20);
evalcond[1]=((((-1.0)*x344*x347))+new_r21);
evalcond[2]=((((-1.0)*new_r10))+(((-1.0)*x344)));
evalcond[3]=((((-1.0)*new_r11))+(((-1.0)*x349)));
evalcond[4]=(((cj1*x344))+(((-1.0)*x348)));
evalcond[5]=((((-1.0)*cj1*x349))+(((-1.0)*x346)));
evalcond[6]=((((-1.0)*cj1*x348))+x344+(((-1.0)*new_r21*x347)));
evalcond[7]=((((-1.0)*cj1*x346))+(((-1.0)*new_r20*x347))+(((-1.0)*x349)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x350=IKPowWithIntegerCheck(sj1,-1);
if(!x350.valid){
continue;
}
if( IKabs((new_r21*(x350.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r21*(x350.value)))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2((new_r21*(x350.value)), ((-1.0)*new_r11));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x351=IKsin(j2);
IkReal x352=IKcos(j2);
IkReal x353=((1.0)*new_r00);
IkReal x354=((1.0)*sj1);
IkReal x355=((1.0)*new_r01);
IkReal x356=((1.0)*x352);
evalcond[0]=(((sj1*x352))+new_r20);
evalcond[1]=((((-1.0)*x351*x354))+new_r21);
evalcond[2]=((((-1.0)*x351))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x356))+(((-1.0)*new_r11)));
evalcond[4]=(((cj1*x351))+(((-1.0)*x355)));
evalcond[5]=((((-1.0)*x353))+(((-1.0)*cj1*x356)));
evalcond[6]=((((-1.0)*cj1*x355))+x351+(((-1.0)*new_r21*x354)));
evalcond[7]=((((-1.0)*x356))+(((-1.0)*cj1*x353))+(((-1.0)*new_r20*x354)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x357=IKPowWithIntegerCheck(IKsign(sj1),-1);
if(!x357.valid){
continue;
}
CheckValue<IkReal> x358 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x358.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x357.value)))+(x358.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x359=IKsin(j2);
IkReal x360=IKcos(j2);
IkReal x361=((1.0)*new_r00);
IkReal x362=((1.0)*sj1);
IkReal x363=((1.0)*new_r01);
IkReal x364=((1.0)*x360);
evalcond[0]=(((sj1*x360))+new_r20);
evalcond[1]=((((-1.0)*x359*x362))+new_r21);
evalcond[2]=((((-1.0)*x359))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x364))+(((-1.0)*new_r11)));
evalcond[4]=(((cj1*x359))+(((-1.0)*x363)));
evalcond[5]=((((-1.0)*x361))+(((-1.0)*cj1*x364)));
evalcond[6]=((((-1.0)*cj1*x363))+x359+(((-1.0)*new_r21*x362)));
evalcond[7]=((((-1.0)*new_r20*x362))+(((-1.0)*x364))+(((-1.0)*cj1*x361)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2eval[1];
new_r21=0;
new_r20=0;
new_r02=0;
new_r12=0;
j2eval[0]=IKabs(new_r22);
if( IKabs(j2eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j2]

} else
{
IkReal op[2+1], zeror[2];
int numroots;
op[0]=new_r22;
op[1]=0;
op[2]=((-1.0)*new_r22);
polyroots2(op,zeror,numroots);
IkReal j2array[2], cj2array[2], sj2array[2], tempj2array[1];
int numsolutions = 0;
for(int ij2 = 0; ij2 < numroots; ++ij2)
{
IkReal htj2 = zeror[ij2];
tempj2array[0]=((2.0)*(atan(htj2)));
for(int kj2 = 0; kj2 < 1; ++kj2)
{
j2array[numsolutions] = tempj2array[kj2];
if( j2array[numsolutions] > IKPI )
{
    j2array[numsolutions]-=IK2PI;
}
else if( j2array[numsolutions] < -IKPI )
{
    j2array[numsolutions]+=IK2PI;
}
sj2array[numsolutions] = IKsin(j2array[numsolutions]);
cj2array[numsolutions] = IKcos(j2array[numsolutions]);
numsolutions++;
}
}
bool j2valid[2]={true,true};
_nj2 = 2;
for(int ij2 = 0; ij2 < numsolutions; ++ij2)
    {
if( !j2valid[ij2] )
{
    continue;
}
    j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
htj2 = IKtan(j2/2);

_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < numsolutions; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j2]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x366=IKPowWithIntegerCheck(sj1,-1);
if(!x366.valid){
continue;
}
IkReal x365=x366.value;
CheckValue<IkReal> x367=IKPowWithIntegerCheck(cj0,-1);
if(!x367.valid){
continue;
}
CheckValue<IkReal> x368=IKPowWithIntegerCheck(cj1,-1);
if(!x368.valid){
continue;
}
if( IKabs((x365*(x367.value)*(x368.value)*((((new_r20*sj0))+(((-1.0)*new_r01*sj1)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*x365)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x365*(x367.value)*(x368.value)*((((new_r20*sj0))+(((-1.0)*new_r01*sj1))))))+IKsqr(((-1.0)*new_r20*x365))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2((x365*(x367.value)*(x368.value)*((((new_r20*sj0))+(((-1.0)*new_r01*sj1))))), ((-1.0)*new_r20*x365));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[12];
IkReal x369=IKsin(j2);
IkReal x370=IKcos(j2);
IkReal x371=((1.0)*sj1);
IkReal x372=((1.0)*sj0);
IkReal x373=(cj0*new_r00);
IkReal x374=(cj0*cj1);
IkReal x375=(new_r11*sj0);
IkReal x376=(new_r10*sj0);
IkReal x377=((1.0)*x370);
IkReal x378=(cj1*x369);
IkReal x379=((1.0)*x369);
evalcond[0]=(((sj1*x370))+new_r20);
evalcond[1]=((((-1.0)*x369*x371))+new_r21);
evalcond[2]=(x378+x375+((cj0*new_r01)));
evalcond[3]=((((-1.0)*new_r00*x372))+(((-1.0)*x379))+((cj0*new_r10)));
evalcond[4]=((((-1.0)*x377))+((cj0*new_r11))+(((-1.0)*new_r01*x372)));
evalcond[5]=(((x369*x374))+((sj0*x370))+new_r01);
evalcond[6]=((((-1.0)*cj1*x377))+x376+x373);
evalcond[7]=(((sj0*x369))+(((-1.0)*x374*x377))+new_r00);
evalcond[8]=(((sj0*x378))+new_r11+(((-1.0)*cj0*x377)));
evalcond[9]=((((-1.0)*cj1*x370*x372))+new_r10+(((-1.0)*cj0*x379)));
evalcond[10]=((((-1.0)*new_r21*x371))+((new_r01*x374))+x369+((cj1*x375)));
evalcond[11]=((((-1.0)*new_r20*x371))+(((-1.0)*x377))+((cj1*x373))+((cj1*x376)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x381=IKPowWithIntegerCheck(sj1,-1);
if(!x381.valid){
continue;
}
IkReal x380=x381.value;
CheckValue<IkReal> x382=IKPowWithIntegerCheck(sj0,-1);
if(!x382.valid){
continue;
}
if( IKabs((x380*(x382.value)*(((((-1.0)*cj0*cj1*new_r20))+(((-1.0)*new_r00*sj1)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*x380)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x380*(x382.value)*(((((-1.0)*cj0*cj1*new_r20))+(((-1.0)*new_r00*sj1))))))+IKsqr(((-1.0)*new_r20*x380))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2((x380*(x382.value)*(((((-1.0)*cj0*cj1*new_r20))+(((-1.0)*new_r00*sj1))))), ((-1.0)*new_r20*x380));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[12];
IkReal x383=IKsin(j2);
IkReal x384=IKcos(j2);
IkReal x385=((1.0)*sj1);
IkReal x386=((1.0)*sj0);
IkReal x387=(cj0*new_r00);
IkReal x388=(cj0*cj1);
IkReal x389=(new_r11*sj0);
IkReal x390=(new_r10*sj0);
IkReal x391=((1.0)*x384);
IkReal x392=(cj1*x383);
IkReal x393=((1.0)*x383);
evalcond[0]=(new_r20+((sj1*x384)));
evalcond[1]=(new_r21+(((-1.0)*x383*x385)));
evalcond[2]=(x389+x392+((cj0*new_r01)));
evalcond[3]=((((-1.0)*x393))+(((-1.0)*new_r00*x386))+((cj0*new_r10)));
evalcond[4]=((((-1.0)*x391))+(((-1.0)*new_r01*x386))+((cj0*new_r11)));
evalcond[5]=(((x383*x388))+new_r01+((sj0*x384)));
evalcond[6]=((((-1.0)*cj1*x391))+x387+x390);
evalcond[7]=((((-1.0)*x388*x391))+new_r00+((sj0*x383)));
evalcond[8]=((((-1.0)*cj0*x391))+((sj0*x392))+new_r11);
evalcond[9]=((((-1.0)*cj0*x393))+(((-1.0)*cj1*x384*x386))+new_r10);
evalcond[10]=(((cj1*x389))+((new_r01*x388))+x383+(((-1.0)*new_r21*x385)));
evalcond[11]=((((-1.0)*x391))+((cj1*x387))+(((-1.0)*new_r20*x385))+((cj1*x390)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x394=IKPowWithIntegerCheck(IKsign(sj1),-1);
if(!x394.valid){
continue;
}
CheckValue<IkReal> x395 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x395.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x394.value)))+(x395.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[12];
IkReal x396=IKsin(j2);
IkReal x397=IKcos(j2);
IkReal x398=((1.0)*sj1);
IkReal x399=((1.0)*sj0);
IkReal x400=(cj0*new_r00);
IkReal x401=(cj0*cj1);
IkReal x402=(new_r11*sj0);
IkReal x403=(new_r10*sj0);
IkReal x404=((1.0)*x397);
IkReal x405=(cj1*x396);
IkReal x406=((1.0)*x396);
evalcond[0]=(((sj1*x397))+new_r20);
evalcond[1]=((((-1.0)*x396*x398))+new_r21);
evalcond[2]=(x402+x405+((cj0*new_r01)));
evalcond[3]=((((-1.0)*new_r00*x399))+((cj0*new_r10))+(((-1.0)*x406)));
evalcond[4]=((((-1.0)*new_r01*x399))+((cj0*new_r11))+(((-1.0)*x404)));
evalcond[5]=(((sj0*x397))+new_r01+((x396*x401)));
evalcond[6]=((((-1.0)*cj1*x404))+x400+x403);
evalcond[7]=(((sj0*x396))+(((-1.0)*x401*x404))+new_r00);
evalcond[8]=(((sj0*x405))+(((-1.0)*cj0*x404))+new_r11);
evalcond[9]=((((-1.0)*cj0*x406))+new_r10+(((-1.0)*cj1*x397*x399)));
evalcond[10]=((((-1.0)*new_r21*x398))+x396+((cj1*x402))+((new_r01*x401)));
evalcond[11]=(((cj1*x400))+((cj1*x403))+(((-1.0)*x404))+(((-1.0)*new_r20*x398)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x407=IKPowWithIntegerCheck(IKsign(sj1),-1);
if(!x407.valid){
continue;
}
CheckValue<IkReal> x408 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x408.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x407.value)))+(x408.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[2];
evalcond[0]=(((sj1*(IKcos(j2))))+new_r20);
evalcond[1]=((((-1.0)*sj1*(IKsin(j2))))+new_r21);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j0eval[3];
j0eval[0]=sj1;
j0eval[1]=((IKabs(new_r12))+(IKabs(new_r02)));
j0eval[2]=IKsign(sj1);
if( IKabs(j0eval[0]) < 0.0000010000000000  || IKabs(j0eval[1]) < 0.0000010000000000  || IKabs(j0eval[2]) < 0.0000010000000000  )
{
{
IkReal j0eval[2];
j0eval[0]=cj2;
j0eval[1]=sj1;
if( IKabs(j0eval[0]) < 0.0000010000000000  || IKabs(j0eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j2)))), 6.28318530717959)));
evalcond[1]=new_r20;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
if( IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r00))+IKsqr(new_r10)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j0array[0]=IKatan2(((-1.0)*new_r00), new_r10);
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[18];
IkReal x409=IKsin(j0);
IkReal x410=IKcos(j0);
IkReal x411=((1.0)*sj1);
IkReal x412=((1.0)*cj1);
IkReal x413=(new_r10*x409);
IkReal x414=(new_r01*x410);
IkReal x415=(new_r00*x410);
IkReal x416=((1.0)*x409);
IkReal x417=(new_r11*x409);
IkReal x418=(new_r12*x409);
IkReal x419=(cj1*x410);
IkReal x420=(new_r02*x410);
evalcond[0]=(x409+new_r00);
evalcond[1]=(x419+new_r01);
evalcond[2]=(new_r11+((cj1*x409)));
evalcond[3]=(new_r10+(((-1.0)*x410)));
evalcond[4]=((((-1.0)*x410*x411))+new_r02);
evalcond[5]=(new_r12+(((-1.0)*x409*x411)));
evalcond[6]=(x413+x415);
evalcond[7]=(((new_r12*x410))+(((-1.0)*new_r02*x416)));
evalcond[8]=(((new_r11*x410))+(((-1.0)*new_r01*x416)));
evalcond[9]=(cj1+x417+x414);
evalcond[10]=((-1.0)+((new_r10*x410))+(((-1.0)*new_r00*x416)));
evalcond[11]=(((cj1*x415))+((cj1*x413)));
evalcond[12]=(x418+x420+(((-1.0)*x411)));
evalcond[13]=((((-1.0)*x411*x413))+(((-1.0)*x411*x415)));
evalcond[14]=((((-1.0)*new_r22*x411))+((new_r02*x419))+((cj1*x418)));
evalcond[15]=((1.0)+(((-1.0)*new_r21*x411))+((cj1*x417))+((cj1*x414)));
evalcond[16]=((((-1.0)*new_r21*x412))+(((-1.0)*x411*x414))+(((-1.0)*x411*x417)));
evalcond[17]=((1.0)+(((-1.0)*x411*x418))+(((-1.0)*new_r22*x412))+(((-1.0)*x411*x420)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j2)))), 6.28318530717959)));
evalcond[1]=new_r20;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
if( IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r00)+IKsqr(((-1.0)*new_r10))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j0array[0]=IKatan2(new_r00, ((-1.0)*new_r10));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[18];
IkReal x421=IKcos(j0);
IkReal x422=IKsin(j0);
IkReal x423=((1.0)*sj1);
IkReal x424=((1.0)*cj1);
IkReal x425=(new_r10*x422);
IkReal x426=(new_r01*x421);
IkReal x427=(new_r00*x421);
IkReal x428=((1.0)*x422);
IkReal x429=(new_r11*x422);
IkReal x430=(new_r12*x422);
IkReal x431=(new_r02*x421);
evalcond[0]=(x421+new_r10);
evalcond[1]=((((-1.0)*x428))+new_r00);
evalcond[2]=((((-1.0)*x421*x423))+new_r02);
evalcond[3]=((((-1.0)*x422*x423))+new_r12);
evalcond[4]=((((-1.0)*x421*x424))+new_r01);
evalcond[5]=((((-1.0)*x422*x424))+new_r11);
evalcond[6]=(x427+x425);
evalcond[7]=(((new_r12*x421))+(((-1.0)*new_r02*x428)));
evalcond[8]=(((new_r11*x421))+(((-1.0)*new_r01*x428)));
evalcond[9]=((1.0)+(((-1.0)*new_r00*x428))+((new_r10*x421)));
evalcond[10]=(((cj1*x427))+((cj1*x425)));
evalcond[11]=((((-1.0)*x423))+x430+x431);
evalcond[12]=((((-1.0)*x424))+x429+x426);
evalcond[13]=((((-1.0)*x423*x427))+(((-1.0)*x423*x425)));
evalcond[14]=(((cj1*x430))+((cj1*x431))+(((-1.0)*new_r22*x423)));
evalcond[15]=((-1.0)+(sj1*sj1)+((cj1*x429))+((cj1*x426)));
evalcond[16]=((((-1.0)*x423*x429))+(((-1.0)*x423*x426))+(((-1.0)*new_r21*x424)));
evalcond[17]=((1.0)+(((-1.0)*new_r22*x424))+(((-1.0)*x423*x431))+(((-1.0)*x423*x430)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j1))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x432=((1.0)*sj2);
if( IKabs(((((-1.0)*new_r00*x432))+(((-1.0)*cj2*new_r01)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*new_r01*x432))+((cj2*new_r00)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*x432))+(((-1.0)*cj2*new_r01))))+IKsqr(((((-1.0)*new_r01*x432))+((cj2*new_r00))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j0array[0]=IKatan2(((((-1.0)*new_r00*x432))+(((-1.0)*cj2*new_r01))), ((((-1.0)*new_r01*x432))+((cj2*new_r00))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[8];
IkReal x433=IKcos(j0);
IkReal x434=IKsin(j0);
IkReal x435=((1.0)*cj2);
IkReal x436=((1.0)*sj2);
IkReal x437=(sj2*x434);
IkReal x438=((1.0)*x434);
IkReal x439=(x433*x435);
evalcond[0]=(((new_r01*x433))+sj2+((new_r11*x434)));
evalcond[1]=(((sj2*x433))+((cj2*x434))+new_r01);
evalcond[2]=((((-1.0)*x439))+x437+new_r00);
evalcond[3]=((((-1.0)*x439))+x437+new_r11);
evalcond[4]=((((-1.0)*x435))+((new_r00*x433))+((new_r10*x434)));
evalcond[5]=((((-1.0)*x433*x436))+(((-1.0)*x434*x435))+new_r10);
evalcond[6]=((((-1.0)*new_r00*x438))+(((-1.0)*x436))+((new_r10*x433)));
evalcond[7]=((((-1.0)*x435))+(((-1.0)*new_r01*x438))+((new_r11*x433)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j1)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x440=((1.0)*new_r00);
if( IKabs(((((-1.0)*sj2*x440))+(((-1.0)*cj2*new_r01)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*cj2*x440))+((new_r01*sj2)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*sj2*x440))+(((-1.0)*cj2*new_r01))))+IKsqr(((((-1.0)*cj2*x440))+((new_r01*sj2))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j0array[0]=IKatan2(((((-1.0)*sj2*x440))+(((-1.0)*cj2*new_r01))), ((((-1.0)*cj2*x440))+((new_r01*sj2))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[8];
IkReal x441=IKcos(j0);
IkReal x442=IKsin(j0);
IkReal x443=((1.0)*sj2);
IkReal x444=(cj2*x442);
IkReal x445=(sj2*x442);
IkReal x446=((1.0)*x441);
IkReal x447=((1.0)*x442);
IkReal x448=(x441*x443);
evalcond[0]=(((new_r00*x441))+cj2+((new_r10*x442)));
evalcond[1]=(x445+((cj2*x441))+new_r00);
evalcond[2]=((((-1.0)*x448))+x444+new_r01);
evalcond[3]=((((-1.0)*x448))+x444+new_r10);
evalcond[4]=((((-1.0)*x443))+((new_r01*x441))+((new_r11*x442)));
evalcond[5]=((((-1.0)*cj2*x446))+new_r11+(((-1.0)*x442*x443)));
evalcond[6]=((((-1.0)*x443))+(((-1.0)*new_r00*x447))+((new_r10*x441)));
evalcond[7]=((((-1.0)*new_r01*x447))+((new_r11*x441))+(((-1.0)*cj2)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r12))+(IKabs(new_r02)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j0eval[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(j0eval[0]) < 0.0000010000000000  )
{
{
IkReal j0eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j0eval[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(j0eval[0]) < 0.0000010000000000  )
{
{
IkReal j0eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j0eval[0]=((IKabs((new_r11*new_r22)))+(IKabs((new_r01*new_r22))));
if( IKabs(j0eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j0]

} else
{
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
CheckValue<IkReal> x450 = IKatan2WithCheck(IkReal((new_r01*new_r22)),IkReal((new_r11*new_r22)),IKFAST_ATAN2_MAGTHRESH);
if(!x450.valid){
continue;
}
IkReal x449=x450.value;
j0array[0]=((-1.0)*x449);
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((3.14159265358979)+(((-1.0)*x449)));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[5];
IkReal x451=IKcos(j0);
IkReal x452=IKsin(j0);
IkReal x453=(new_r10*x452);
IkReal x454=((1.0)*x452);
IkReal x455=(new_r00*x451);
evalcond[0]=(((new_r11*x452))+((new_r01*x451)));
evalcond[1]=(x455+x453);
evalcond[2]=(((new_r10*x451))+(((-1.0)*new_r00*x454)));
evalcond[3]=(((new_r11*x451))+(((-1.0)*new_r01*x454)));
evalcond[4]=(((new_r22*x453))+((new_r22*x455)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
CheckValue<IkReal> x457 = IKatan2WithCheck(IkReal(new_r00),IkReal(new_r10),IKFAST_ATAN2_MAGTHRESH);
if(!x457.valid){
continue;
}
IkReal x456=x457.value;
j0array[0]=((-1.0)*x456);
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((3.14159265358979)+(((-1.0)*x456)));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[5];
IkReal x458=IKcos(j0);
IkReal x459=IKsin(j0);
IkReal x460=((1.0)*x459);
IkReal x461=(new_r11*x459);
IkReal x462=(new_r22*x458);
evalcond[0]=(((new_r01*x458))+x461);
evalcond[1]=(((new_r10*x458))+(((-1.0)*new_r00*x460)));
evalcond[2]=(((new_r11*x458))+(((-1.0)*new_r01*x460)));
evalcond[3]=(((new_r01*x462))+((new_r22*x461)));
evalcond[4]=(((new_r10*new_r22*x459))+((new_r00*x462)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
CheckValue<IkReal> x464 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x464.valid){
continue;
}
IkReal x463=x464.value;
j0array[0]=((-1.0)*x463);
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((3.14159265358979)+(((-1.0)*x463)));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[5];
IkReal x465=IKcos(j0);
IkReal x466=IKsin(j0);
IkReal x467=(new_r10*x466);
IkReal x468=((1.0)*x466);
IkReal x469=(new_r00*x465);
evalcond[0]=(x469+x467);
evalcond[1]=(((new_r10*x465))+(((-1.0)*new_r00*x468)));
evalcond[2]=(((new_r11*x465))+(((-1.0)*new_r01*x468)));
evalcond[3]=(((new_r11*new_r22*x466))+((new_r01*new_r22*x465)));
evalcond[4]=(((new_r22*x467))+((new_r22*x469)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j0]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
CheckValue<IkReal> x471=IKPowWithIntegerCheck(sj1,-1);
if(!x471.valid){
continue;
}
IkReal x470=x471.value;
CheckValue<IkReal> x472=IKPowWithIntegerCheck(cj2,-1);
if(!x472.valid){
continue;
}
if( IKabs((x470*(x472.value)*(((((-1.0)*new_r01*sj1))+(((-1.0)*cj1*new_r02*sj2)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r02*x470)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x470*(x472.value)*(((((-1.0)*new_r01*sj1))+(((-1.0)*cj1*new_r02*sj2))))))+IKsqr((new_r02*x470))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j0array[0]=IKatan2((x470*(x472.value)*(((((-1.0)*new_r01*sj1))+(((-1.0)*cj1*new_r02*sj2))))), (new_r02*x470));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[18];
IkReal x473=IKcos(j0);
IkReal x474=IKsin(j0);
IkReal x475=((1.0)*cj2);
IkReal x476=((1.0)*sj1);
IkReal x477=((1.0)*cj1);
IkReal x478=((1.0)*sj2);
IkReal x479=(new_r10*x474);
IkReal x480=(new_r01*x473);
IkReal x481=(new_r00*x473);
IkReal x482=((1.0)*x474);
IkReal x483=(new_r11*x474);
IkReal x484=(new_r12*x474);
IkReal x485=(sj2*x474);
IkReal x486=(cj1*x473);
IkReal x487=(cj2*x474);
IkReal x488=(new_r02*x473);
evalcond[0]=((((-1.0)*x473*x476))+new_r02);
evalcond[1]=(new_r12+(((-1.0)*x474*x476)));
evalcond[2]=(((new_r12*x473))+(((-1.0)*new_r02*x482)));
evalcond[3]=(x487+((sj2*x486))+new_r01);
evalcond[4]=((((-1.0)*x476))+x488+x484);
evalcond[5]=(((cj1*sj2))+x480+x483);
evalcond[6]=((((-1.0)*x475*x486))+x485+new_r00);
evalcond[7]=((((-1.0)*x473*x475))+((cj1*x485))+new_r11);
evalcond[8]=((((-1.0)*new_r00*x482))+((new_r10*x473))+(((-1.0)*x478)));
evalcond[9]=((((-1.0)*new_r01*x482))+((new_r11*x473))+(((-1.0)*x475)));
evalcond[10]=((((-1.0)*cj1*x475))+x481+x479);
evalcond[11]=((((-1.0)*cj1*x474*x475))+(((-1.0)*x473*x478))+new_r10);
evalcond[12]=(((new_r02*x486))+(((-1.0)*new_r22*x476))+((cj1*x484)));
evalcond[13]=(sj2+(((-1.0)*new_r21*x476))+((cj1*x480))+((cj1*x483)));
evalcond[14]=((((-1.0)*x476*x481))+(((-1.0)*x476*x479))+(((-1.0)*new_r20*x477)));
evalcond[15]=((((-1.0)*x476*x480))+(((-1.0)*x476*x483))+(((-1.0)*new_r21*x477)));
evalcond[16]=((1.0)+(((-1.0)*x476*x484))+(((-1.0)*x476*x488))+(((-1.0)*new_r22*x477)));
evalcond[17]=((((-1.0)*x475))+((cj1*x479))+((cj1*x481))+(((-1.0)*new_r20*x476)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
CheckValue<IkReal> x489=IKPowWithIntegerCheck(IKsign(sj1),-1);
if(!x489.valid){
continue;
}
CheckValue<IkReal> x490 = IKatan2WithCheck(IkReal(new_r12),IkReal(new_r02),IKFAST_ATAN2_MAGTHRESH);
if(!x490.valid){
continue;
}
j0array[0]=((-1.5707963267949)+(((1.5707963267949)*(x489.value)))+(x490.value));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[18];
IkReal x491=IKcos(j0);
IkReal x492=IKsin(j0);
IkReal x493=((1.0)*cj2);
IkReal x494=((1.0)*sj1);
IkReal x495=((1.0)*cj1);
IkReal x496=((1.0)*sj2);
IkReal x497=(new_r10*x492);
IkReal x498=(new_r01*x491);
IkReal x499=(new_r00*x491);
IkReal x500=((1.0)*x492);
IkReal x501=(new_r11*x492);
IkReal x502=(new_r12*x492);
IkReal x503=(sj2*x492);
IkReal x504=(cj1*x491);
IkReal x505=(cj2*x492);
IkReal x506=(new_r02*x491);
evalcond[0]=((((-1.0)*x491*x494))+new_r02);
evalcond[1]=(new_r12+(((-1.0)*x492*x494)));
evalcond[2]=((((-1.0)*new_r02*x500))+((new_r12*x491)));
evalcond[3]=(((sj2*x504))+x505+new_r01);
evalcond[4]=((((-1.0)*x494))+x502+x506);
evalcond[5]=(((cj1*sj2))+x498+x501);
evalcond[6]=(x503+(((-1.0)*x493*x504))+new_r00);
evalcond[7]=(((cj1*x503))+(((-1.0)*x491*x493))+new_r11);
evalcond[8]=((((-1.0)*x496))+(((-1.0)*new_r00*x500))+((new_r10*x491)));
evalcond[9]=((((-1.0)*new_r01*x500))+(((-1.0)*x493))+((new_r11*x491)));
evalcond[10]=((((-1.0)*cj1*x493))+x499+x497);
evalcond[11]=((((-1.0)*x491*x496))+(((-1.0)*cj1*x492*x493))+new_r10);
evalcond[12]=(((cj1*x502))+((new_r02*x504))+(((-1.0)*new_r22*x494)));
evalcond[13]=(sj2+((cj1*x501))+(((-1.0)*new_r21*x494))+((cj1*x498)));
evalcond[14]=((((-1.0)*new_r20*x495))+(((-1.0)*x494*x499))+(((-1.0)*x494*x497)));
evalcond[15]=((((-1.0)*x494*x498))+(((-1.0)*new_r21*x495))+(((-1.0)*x494*x501)));
evalcond[16]=((1.0)+(((-1.0)*x494*x502))+(((-1.0)*x494*x506))+(((-1.0)*new_r22*x495)));
evalcond[17]=((((-1.0)*new_r20*x494))+(((-1.0)*x493))+((cj1*x499))+((cj1*x497)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
CheckValue<IkReal> x507=IKPowWithIntegerCheck(IKsign(sj1),-1);
if(!x507.valid){
continue;
}
CheckValue<IkReal> x508 = IKatan2WithCheck(IkReal(new_r12),IkReal(new_r02),IKFAST_ATAN2_MAGTHRESH);
if(!x508.valid){
continue;
}
j0array[0]=((-1.5707963267949)+(((1.5707963267949)*(x507.value)))+(x508.value));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[8];
IkReal x509=IKcos(j0);
IkReal x510=IKsin(j0);
IkReal x511=((1.0)*cj1);
IkReal x512=((1.0)*sj1);
IkReal x513=(new_r12*x510);
IkReal x514=(new_r02*x509);
evalcond[0]=(new_r02+(((-1.0)*x509*x512)));
evalcond[1]=(new_r12+(((-1.0)*x510*x512)));
evalcond[2]=(((new_r12*x509))+(((-1.0)*new_r02*x510)));
evalcond[3]=(x514+x513+(((-1.0)*x512)));
evalcond[4]=((((-1.0)*new_r22*x512))+((cj1*x514))+((cj1*x513)));
evalcond[5]=((((-1.0)*new_r20*x511))+(((-1.0)*new_r00*x509*x512))+(((-1.0)*new_r10*x510*x512)));
evalcond[6]=((((-1.0)*new_r11*x510*x512))+(((-1.0)*new_r21*x511))+(((-1.0)*new_r01*x509*x512)));
evalcond[7]=((1.0)+(((-1.0)*new_r22*x511))+(((-1.0)*x512*x514))+(((-1.0)*x512*x513)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j2eval[3];
j2eval[0]=sj1;
j2eval[1]=IKsign(sj1);
j2eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  || IKabs(j2eval[2]) < 0.0000010000000000  )
{
{
IkReal j2eval[2];
j2eval[0]=sj0;
j2eval[1]=sj1;
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
{
IkReal j2eval[3];
j2eval[0]=cj0;
j2eval[1]=cj1;
j2eval[2]=sj1;
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  || IKabs(j2eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j0)))), 6.28318530717959)));
evalcond[1]=new_r02;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2eval[3];
sj0=1.0;
cj0=0;
j0=1.5707963267949;
j2eval[0]=sj1;
j2eval[1]=IKsign(sj1);
j2eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  || IKabs(j2eval[2]) < 0.0000010000000000  )
{
{
IkReal j2eval[3];
sj0=1.0;
cj0=0;
j0=1.5707963267949;
j2eval[0]=cj1;
j2eval[1]=IKsign(cj1);
j2eval[2]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  || IKabs(j2eval[2]) < 0.0000010000000000  )
{
{
IkReal j2eval[1];
sj0=1.0;
cj0=0;
j0=1.5707963267949;
j2eval[0]=sj1;
if( IKabs(j2eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[4];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j1))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r12;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r11))+IKsqr(new_r10)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.0)*new_r11), new_r10);
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x515=IKsin(j2);
IkReal x516=((1.0)*(IKcos(j2)));
evalcond[0]=(x515+new_r11);
evalcond[1]=(new_r10+(((-1.0)*x516)));
evalcond[2]=((((-1.0)*x515))+(((-1.0)*new_r00)));
evalcond[3]=((((-1.0)*new_r01))+(((-1.0)*x516)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j1)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r12;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r11)+IKsqr(((-1.0)*new_r10))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(new_r11, ((-1.0)*new_r10));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x517=IKcos(j2);
IkReal x518=((1.0)*(IKsin(j2)));
evalcond[0]=(x517+new_r10);
evalcond[1]=(new_r11+(((-1.0)*x518)));
evalcond[2]=((((-1.0)*new_r00))+(((-1.0)*x518)));
evalcond[3]=((((-1.0)*x517))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j1)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r11;
evalcond[3]=new_r10;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x519=IKcos(j2);
IkReal x520=((1.0)*(IKsin(j2)));
evalcond[0]=(x519+new_r20);
evalcond[1]=((((-1.0)*x520))+new_r21);
evalcond[2]=((((-1.0)*x520))+(((-1.0)*new_r00)));
evalcond[3]=((((-1.0)*x519))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j1)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r11;
evalcond[3]=new_r10;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x521=IKsin(j2);
IkReal x522=((1.0)*(IKcos(j2)));
evalcond[0]=(x521+new_r21);
evalcond[1]=((((-1.0)*x522))+new_r20);
evalcond[2]=((((-1.0)*x521))+(((-1.0)*new_r00)));
evalcond[3]=((((-1.0)*x522))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r00))+IKsqr(((-1.0)*new_r01))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.0)*new_r00), ((-1.0)*new_r01));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[6];
IkReal x523=IKsin(j2);
IkReal x524=IKcos(j2);
IkReal x525=((-1.0)*x524);
evalcond[0]=x523;
evalcond[1]=(new_r22*x523);
evalcond[2]=x525;
evalcond[3]=(new_r22*x525);
evalcond[4]=((((-1.0)*x523))+(((-1.0)*new_r00)));
evalcond[5]=((((-1.0)*x524))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j2]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x526=IKPowWithIntegerCheck(sj1,-1);
if(!x526.valid){
continue;
}
if( IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*(x526.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r00))+IKsqr(((-1.0)*new_r20*(x526.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.0)*new_r00), ((-1.0)*new_r20*(x526.value)));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x527=IKsin(j2);
IkReal x528=IKcos(j2);
IkReal x529=((1.0)*sj1);
IkReal x530=((1.0)*x528);
evalcond[0]=(((sj1*x528))+new_r20);
evalcond[1]=(((cj1*x527))+new_r11);
evalcond[2]=((((-1.0)*x527*x529))+new_r21);
evalcond[3]=((((-1.0)*cj1*x530))+new_r10);
evalcond[4]=((((-1.0)*x527))+(((-1.0)*new_r00)));
evalcond[5]=((((-1.0)*x530))+(((-1.0)*new_r01)));
evalcond[6]=(((cj1*new_r11))+(((-1.0)*new_r21*x529))+x527);
evalcond[7]=(((cj1*new_r10))+(((-1.0)*new_r20*x529))+(((-1.0)*x530)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x531=IKPowWithIntegerCheck(IKsign(cj1),-1);
if(!x531.valid){
continue;
}
CheckValue<IkReal> x532 = IKatan2WithCheck(IkReal(((-1.0)*new_r11)),IkReal(new_r10),IKFAST_ATAN2_MAGTHRESH);
if(!x532.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x531.value)))+(x532.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x533=IKsin(j2);
IkReal x534=IKcos(j2);
IkReal x535=((1.0)*sj1);
IkReal x536=((1.0)*x534);
evalcond[0]=(((sj1*x534))+new_r20);
evalcond[1]=(((cj1*x533))+new_r11);
evalcond[2]=((((-1.0)*x533*x535))+new_r21);
evalcond[3]=((((-1.0)*cj1*x536))+new_r10);
evalcond[4]=((((-1.0)*x533))+(((-1.0)*new_r00)));
evalcond[5]=((((-1.0)*x536))+(((-1.0)*new_r01)));
evalcond[6]=(((cj1*new_r11))+(((-1.0)*new_r21*x535))+x533);
evalcond[7]=(((cj1*new_r10))+(((-1.0)*x536))+(((-1.0)*new_r20*x535)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x537=IKPowWithIntegerCheck(IKsign(sj1),-1);
if(!x537.valid){
continue;
}
CheckValue<IkReal> x538 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x538.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x537.value)))+(x538.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x539=IKsin(j2);
IkReal x540=IKcos(j2);
IkReal x541=((1.0)*sj1);
IkReal x542=((1.0)*x540);
evalcond[0]=(((sj1*x540))+new_r20);
evalcond[1]=(((cj1*x539))+new_r11);
evalcond[2]=((((-1.0)*x539*x541))+new_r21);
evalcond[3]=((((-1.0)*cj1*x542))+new_r10);
evalcond[4]=((((-1.0)*x539))+(((-1.0)*new_r00)));
evalcond[5]=((((-1.0)*x542))+(((-1.0)*new_r01)));
evalcond[6]=(((cj1*new_r11))+(((-1.0)*new_r21*x541))+x539);
evalcond[7]=(((cj1*new_r10))+(((-1.0)*new_r20*x541))+(((-1.0)*x542)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j0)))), 6.28318530717959)));
evalcond[1]=new_r02;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r00)+IKsqr(new_r01)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(new_r00, new_r01);
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x543=IKcos(j2);
IkReal x544=IKsin(j2);
IkReal x545=((1.0)*sj1);
IkReal x546=((1.0)*new_r11);
IkReal x547=((1.0)*new_r10);
IkReal x548=((1.0)*x543);
evalcond[0]=(((sj1*x543))+new_r20);
evalcond[1]=((((-1.0)*x544))+new_r00);
evalcond[2]=((((-1.0)*x548))+new_r01);
evalcond[3]=((((-1.0)*x544*x545))+new_r21);
evalcond[4]=((((-1.0)*x546))+((cj1*x544)));
evalcond[5]=((((-1.0)*cj1*x548))+(((-1.0)*x547)));
evalcond[6]=((((-1.0)*cj1*x546))+(((-1.0)*new_r21*x545))+x544);
evalcond[7]=((((-1.0)*cj1*x547))+(((-1.0)*new_r20*x545))+(((-1.0)*x548)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j1)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x549=IKcos(j2);
IkReal x550=IKsin(j2);
IkReal x551=((1.0)*sj0);
IkReal x552=((1.0)*x550);
IkReal x553=((1.0)*x549);
evalcond[0]=(x549+new_r20);
evalcond[1]=((((-1.0)*x552))+new_r21);
evalcond[2]=(((sj0*x549))+new_r01);
evalcond[3]=(new_r00+((sj0*x550)));
evalcond[4]=((((-1.0)*cj0*x553))+new_r11);
evalcond[5]=(new_r10+(((-1.0)*new_r02*x552)));
evalcond[6]=((((-1.0)*new_r00*x551))+(((-1.0)*x552))+((cj0*new_r10)));
evalcond[7]=((((-1.0)*new_r01*x551))+(((-1.0)*x553))+((cj0*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j1)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x554=IKcos(j2);
IkReal x555=IKsin(j2);
IkReal x556=((1.0)*sj0);
IkReal x557=((1.0)*x554);
evalcond[0]=(x555+new_r21);
evalcond[1]=((((-1.0)*x557))+new_r20);
evalcond[2]=(new_r01+((sj0*x554)));
evalcond[3]=(new_r00+((sj0*x555)));
evalcond[4]=(((new_r02*x555))+new_r10);
evalcond[5]=((((-1.0)*cj0*x557))+new_r11);
evalcond[6]=((((-1.0)*x555))+(((-1.0)*new_r00*x556))+((cj0*new_r10)));
evalcond[7]=((((-1.0)*new_r01*x556))+(((-1.0)*x557))+((cj0*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j1))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x558=((1.0)*new_r01);
if( IKabs(((((-1.0)*cj0*x558))+(((-1.0)*new_r00*sj0)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj0*new_r00))+(((-1.0)*sj0*x558)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*cj0*x558))+(((-1.0)*new_r00*sj0))))+IKsqr((((cj0*new_r00))+(((-1.0)*sj0*x558))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((-1.0)*cj0*x558))+(((-1.0)*new_r00*sj0))), (((cj0*new_r00))+(((-1.0)*sj0*x558))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x559=IKsin(j2);
IkReal x560=IKcos(j2);
IkReal x561=((1.0)*sj0);
IkReal x562=((1.0)*x560);
IkReal x563=(sj0*x559);
IkReal x564=(cj0*x559);
IkReal x565=(cj0*x562);
evalcond[0]=(((new_r11*sj0))+x559+((cj0*new_r01)));
evalcond[1]=(((sj0*x560))+x564+new_r01);
evalcond[2]=(((new_r10*sj0))+((cj0*new_r00))+(((-1.0)*x562)));
evalcond[3]=((((-1.0)*new_r00*x561))+(((-1.0)*x559))+((cj0*new_r10)));
evalcond[4]=(((cj0*new_r11))+(((-1.0)*x562))+(((-1.0)*new_r01*x561)));
evalcond[5]=(x563+new_r00+(((-1.0)*x565)));
evalcond[6]=(x563+new_r11+(((-1.0)*x565)));
evalcond[7]=((((-1.0)*x560*x561))+(((-1.0)*x564))+new_r10);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j1)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x566=((1.0)*sj0);
if( IKabs(((((-1.0)*new_r00*x566))+((cj0*new_r01)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*cj0*new_r00))+(((-1.0)*new_r01*x566)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*x566))+((cj0*new_r01))))+IKsqr(((((-1.0)*cj0*new_r00))+(((-1.0)*new_r01*x566))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((-1.0)*new_r00*x566))+((cj0*new_r01))), ((((-1.0)*cj0*new_r00))+(((-1.0)*new_r01*x566))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x567=IKsin(j2);
IkReal x568=IKcos(j2);
IkReal x569=((1.0)*sj0);
IkReal x570=((1.0)*x567);
IkReal x571=(sj0*x568);
IkReal x572=((1.0)*x568);
IkReal x573=(cj0*x570);
evalcond[0]=(((new_r10*sj0))+x568+((cj0*new_r00)));
evalcond[1]=(((new_r11*sj0))+(((-1.0)*x570))+((cj0*new_r01)));
evalcond[2]=(((cj0*x568))+((sj0*x567))+new_r00);
evalcond[3]=((((-1.0)*new_r00*x569))+(((-1.0)*x570))+((cj0*new_r10)));
evalcond[4]=((((-1.0)*x572))+((cj0*new_r11))+(((-1.0)*new_r01*x569)));
evalcond[5]=((((-1.0)*x573))+x571+new_r01);
evalcond[6]=((((-1.0)*x573))+x571+new_r10);
evalcond[7]=((((-1.0)*cj0*x572))+(((-1.0)*x567*x569))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j0))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r10)+IKsqr(new_r11)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(new_r10, new_r11);
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x574=IKcos(j2);
IkReal x575=IKsin(j2);
IkReal x576=((1.0)*sj1);
IkReal x577=((1.0)*x574);
evalcond[0]=(((sj1*x574))+new_r20);
evalcond[1]=((((-1.0)*x575))+new_r10);
evalcond[2]=((((-1.0)*x577))+new_r11);
evalcond[3]=(new_r01+((cj1*x575)));
evalcond[4]=((((-1.0)*x575*x576))+new_r21);
evalcond[5]=((((-1.0)*cj1*x577))+new_r00);
evalcond[6]=(((cj1*new_r01))+x575+(((-1.0)*new_r21*x576)));
evalcond[7]=(((cj1*new_r00))+(((-1.0)*x577))+(((-1.0)*new_r20*x576)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j0)))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2eval[3];
sj0=0;
cj0=-1.0;
j0=3.14159265358979;
j2eval[0]=sj1;
j2eval[1]=IKsign(sj1);
j2eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  || IKabs(j2eval[2]) < 0.0000010000000000  )
{
{
IkReal j2eval[1];
sj0=0;
cj0=-1.0;
j0=3.14159265358979;
j2eval[0]=sj1;
if( IKabs(j2eval[0]) < 0.0000010000000000  )
{
{
IkReal j2eval[2];
sj0=0;
cj0=-1.0;
j0=3.14159265358979;
j2eval[0]=cj1;
j2eval[1]=sj1;
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[4];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j1)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x578=IKcos(j2);
IkReal x579=((1.0)*(IKsin(j2)));
evalcond[0]=(x578+new_r20);
evalcond[1]=((((-1.0)*x579))+new_r21);
evalcond[2]=((((-1.0)*x579))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x578))+(((-1.0)*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j1)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x580=IKsin(j2);
IkReal x581=((1.0)*(IKcos(j2)));
evalcond[0]=(x580+new_r21);
evalcond[1]=(new_r20+(((-1.0)*x581)));
evalcond[2]=((((-1.0)*x580))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*new_r11))+(((-1.0)*x581)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j1))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r01)+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(new_r01, ((-1.0)*new_r11));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x582=IKsin(j2);
IkReal x583=((1.0)*(IKcos(j2)));
evalcond[0]=(x582+(((-1.0)*new_r01)));
evalcond[1]=((((-1.0)*x582))+(((-1.0)*new_r10)));
evalcond[2]=((((-1.0)*new_r11))+(((-1.0)*x583)));
evalcond[3]=((((-1.0)*new_r00))+(((-1.0)*x583)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j1)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(new_r00)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.0)*new_r10), new_r00);
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x584=IKcos(j2);
IkReal x585=((1.0)*(IKsin(j2)));
evalcond[0]=(x584+(((-1.0)*new_r00)));
evalcond[1]=((((-1.0)*new_r10))+(((-1.0)*x585)));
evalcond[2]=((((-1.0)*x584))+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*new_r01))+(((-1.0)*x585)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.0)*new_r10), ((-1.0)*new_r11));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[6];
IkReal x586=IKsin(j2);
IkReal x587=IKcos(j2);
IkReal x588=((-1.0)*x587);
evalcond[0]=x586;
evalcond[1]=(new_r22*x586);
evalcond[2]=x588;
evalcond[3]=(new_r22*x588);
evalcond[4]=((((-1.0)*x586))+(((-1.0)*new_r10)));
evalcond[5]=((((-1.0)*x587))+(((-1.0)*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j2]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x589=IKPowWithIntegerCheck(cj1,-1);
if(!x589.valid){
continue;
}
CheckValue<IkReal> x590=IKPowWithIntegerCheck(sj1,-1);
if(!x590.valid){
continue;
}
if( IKabs((new_r01*(x589.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*(x590.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r01*(x589.value)))+IKsqr(((-1.0)*new_r20*(x590.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2((new_r01*(x589.value)), ((-1.0)*new_r20*(x590.value)));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x591=IKsin(j2);
IkReal x592=IKcos(j2);
IkReal x593=((1.0)*new_r00);
IkReal x594=((1.0)*sj1);
IkReal x595=((1.0)*new_r01);
IkReal x596=((1.0)*x592);
evalcond[0]=(((sj1*x592))+new_r20);
evalcond[1]=(new_r21+(((-1.0)*x591*x594)));
evalcond[2]=((((-1.0)*x591))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x596))+(((-1.0)*new_r11)));
evalcond[4]=(((cj1*x591))+(((-1.0)*x595)));
evalcond[5]=((((-1.0)*x593))+(((-1.0)*cj1*x596)));
evalcond[6]=((((-1.0)*new_r21*x594))+(((-1.0)*cj1*x595))+x591);
evalcond[7]=((((-1.0)*new_r20*x594))+(((-1.0)*x596))+(((-1.0)*cj1*x593)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x597=IKPowWithIntegerCheck(sj1,-1);
if(!x597.valid){
continue;
}
if( IKabs((new_r21*(x597.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r21*(x597.value)))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2((new_r21*(x597.value)), ((-1.0)*new_r11));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x598=IKsin(j2);
IkReal x599=IKcos(j2);
IkReal x600=((1.0)*new_r00);
IkReal x601=((1.0)*sj1);
IkReal x602=((1.0)*new_r01);
IkReal x603=((1.0)*x599);
evalcond[0]=(((sj1*x599))+new_r20);
evalcond[1]=((((-1.0)*x598*x601))+new_r21);
evalcond[2]=((((-1.0)*x598))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*new_r11))+(((-1.0)*x603)));
evalcond[4]=(((cj1*x598))+(((-1.0)*x602)));
evalcond[5]=((((-1.0)*cj1*x603))+(((-1.0)*x600)));
evalcond[6]=((((-1.0)*cj1*x602))+x598+(((-1.0)*new_r21*x601)));
evalcond[7]=((((-1.0)*new_r20*x601))+(((-1.0)*cj1*x600))+(((-1.0)*x603)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x604=IKPowWithIntegerCheck(IKsign(sj1),-1);
if(!x604.valid){
continue;
}
CheckValue<IkReal> x605 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x605.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x604.value)))+(x605.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x606=IKsin(j2);
IkReal x607=IKcos(j2);
IkReal x608=((1.0)*new_r00);
IkReal x609=((1.0)*sj1);
IkReal x610=((1.0)*new_r01);
IkReal x611=((1.0)*x607);
evalcond[0]=(((sj1*x607))+new_r20);
evalcond[1]=(new_r21+(((-1.0)*x606*x609)));
evalcond[2]=((((-1.0)*x606))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x611))+(((-1.0)*new_r11)));
evalcond[4]=(((cj1*x606))+(((-1.0)*x610)));
evalcond[5]=((((-1.0)*cj1*x611))+(((-1.0)*x608)));
evalcond[6]=((((-1.0)*cj1*x610))+x606+(((-1.0)*new_r21*x609)));
evalcond[7]=((((-1.0)*new_r20*x609))+(((-1.0)*cj1*x608))+(((-1.0)*x611)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2eval[1];
new_r21=0;
new_r20=0;
new_r02=0;
new_r12=0;
j2eval[0]=IKabs(new_r22);
if( IKabs(j2eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j2]

} else
{
IkReal op[2+1], zeror[2];
int numroots;
op[0]=new_r22;
op[1]=0;
op[2]=((-1.0)*new_r22);
polyroots2(op,zeror,numroots);
IkReal j2array[2], cj2array[2], sj2array[2], tempj2array[1];
int numsolutions = 0;
for(int ij2 = 0; ij2 < numroots; ++ij2)
{
IkReal htj2 = zeror[ij2];
tempj2array[0]=((2.0)*(atan(htj2)));
for(int kj2 = 0; kj2 < 1; ++kj2)
{
j2array[numsolutions] = tempj2array[kj2];
if( j2array[numsolutions] > IKPI )
{
    j2array[numsolutions]-=IK2PI;
}
else if( j2array[numsolutions] < -IKPI )
{
    j2array[numsolutions]+=IK2PI;
}
sj2array[numsolutions] = IKsin(j2array[numsolutions]);
cj2array[numsolutions] = IKcos(j2array[numsolutions]);
numsolutions++;
}
}
bool j2valid[2]={true,true};
_nj2 = 2;
for(int ij2 = 0; ij2 < numsolutions; ++ij2)
    {
if( !j2valid[ij2] )
{
    continue;
}
    j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
htj2 = IKtan(j2/2);

_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < numsolutions; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j2]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x613=IKPowWithIntegerCheck(sj1,-1);
if(!x613.valid){
continue;
}
IkReal x612=x613.value;
CheckValue<IkReal> x614=IKPowWithIntegerCheck(cj0,-1);
if(!x614.valid){
continue;
}
CheckValue<IkReal> x615=IKPowWithIntegerCheck(cj1,-1);
if(!x615.valid){
continue;
}
if( IKabs((x612*(x614.value)*(x615.value)*((((new_r20*sj0))+(((-1.0)*new_r01*sj1)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*x612)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x612*(x614.value)*(x615.value)*((((new_r20*sj0))+(((-1.0)*new_r01*sj1))))))+IKsqr(((-1.0)*new_r20*x612))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2((x612*(x614.value)*(x615.value)*((((new_r20*sj0))+(((-1.0)*new_r01*sj1))))), ((-1.0)*new_r20*x612));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[12];
IkReal x616=IKsin(j2);
IkReal x617=IKcos(j2);
IkReal x618=((1.0)*sj1);
IkReal x619=((1.0)*sj0);
IkReal x620=(cj0*new_r00);
IkReal x621=(cj0*cj1);
IkReal x622=(new_r11*sj0);
IkReal x623=(new_r10*sj0);
IkReal x624=((1.0)*x617);
IkReal x625=(cj1*x616);
IkReal x626=((1.0)*x616);
evalcond[0]=(((sj1*x617))+new_r20);
evalcond[1]=(new_r21+(((-1.0)*x616*x618)));
evalcond[2]=(x625+x622+((cj0*new_r01)));
evalcond[3]=((((-1.0)*x626))+(((-1.0)*new_r00*x619))+((cj0*new_r10)));
evalcond[4]=((((-1.0)*x624))+((cj0*new_r11))+(((-1.0)*new_r01*x619)));
evalcond[5]=(((x616*x621))+((sj0*x617))+new_r01);
evalcond[6]=((((-1.0)*cj1*x624))+x620+x623);
evalcond[7]=((((-1.0)*x621*x624))+((sj0*x616))+new_r00);
evalcond[8]=((((-1.0)*cj0*x624))+((sj0*x625))+new_r11);
evalcond[9]=((((-1.0)*cj0*x626))+(((-1.0)*cj1*x617*x619))+new_r10);
evalcond[10]=((((-1.0)*new_r21*x618))+((new_r01*x621))+x616+((cj1*x622)));
evalcond[11]=((((-1.0)*x624))+(((-1.0)*new_r20*x618))+((cj1*x620))+((cj1*x623)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x628=IKPowWithIntegerCheck(sj1,-1);
if(!x628.valid){
continue;
}
IkReal x627=x628.value;
CheckValue<IkReal> x629=IKPowWithIntegerCheck(sj0,-1);
if(!x629.valid){
continue;
}
if( IKabs((x627*(x629.value)*(((((-1.0)*cj0*cj1*new_r20))+(((-1.0)*new_r00*sj1)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*x627)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x627*(x629.value)*(((((-1.0)*cj0*cj1*new_r20))+(((-1.0)*new_r00*sj1))))))+IKsqr(((-1.0)*new_r20*x627))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2((x627*(x629.value)*(((((-1.0)*cj0*cj1*new_r20))+(((-1.0)*new_r00*sj1))))), ((-1.0)*new_r20*x627));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[12];
IkReal x630=IKsin(j2);
IkReal x631=IKcos(j2);
IkReal x632=((1.0)*sj1);
IkReal x633=((1.0)*sj0);
IkReal x634=(cj0*new_r00);
IkReal x635=(cj0*cj1);
IkReal x636=(new_r11*sj0);
IkReal x637=(new_r10*sj0);
IkReal x638=((1.0)*x631);
IkReal x639=(cj1*x630);
IkReal x640=((1.0)*x630);
evalcond[0]=(((sj1*x631))+new_r20);
evalcond[1]=((((-1.0)*x630*x632))+new_r21);
evalcond[2]=(x636+x639+((cj0*new_r01)));
evalcond[3]=((((-1.0)*new_r00*x633))+(((-1.0)*x640))+((cj0*new_r10)));
evalcond[4]=((((-1.0)*new_r01*x633))+(((-1.0)*x638))+((cj0*new_r11)));
evalcond[5]=(((sj0*x631))+new_r01+((x630*x635)));
evalcond[6]=((((-1.0)*cj1*x638))+x637+x634);
evalcond[7]=((((-1.0)*x635*x638))+((sj0*x630))+new_r00);
evalcond[8]=((((-1.0)*cj0*x638))+((sj0*x639))+new_r11);
evalcond[9]=((((-1.0)*cj0*x640))+new_r10+(((-1.0)*cj1*x631*x633)));
evalcond[10]=(((new_r01*x635))+(((-1.0)*new_r21*x632))+x630+((cj1*x636)));
evalcond[11]=((((-1.0)*x638))+(((-1.0)*new_r20*x632))+((cj1*x637))+((cj1*x634)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x641=IKPowWithIntegerCheck(IKsign(sj1),-1);
if(!x641.valid){
continue;
}
CheckValue<IkReal> x642 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x642.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x641.value)))+(x642.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[12];
IkReal x643=IKsin(j2);
IkReal x644=IKcos(j2);
IkReal x645=((1.0)*sj1);
IkReal x646=((1.0)*sj0);
IkReal x647=(cj0*new_r00);
IkReal x648=(cj0*cj1);
IkReal x649=(new_r11*sj0);
IkReal x650=(new_r10*sj0);
IkReal x651=((1.0)*x644);
IkReal x652=(cj1*x643);
IkReal x653=((1.0)*x643);
evalcond[0]=(((sj1*x644))+new_r20);
evalcond[1]=((((-1.0)*x643*x645))+new_r21);
evalcond[2]=(x649+x652+((cj0*new_r01)));
evalcond[3]=((((-1.0)*x653))+(((-1.0)*new_r00*x646))+((cj0*new_r10)));
evalcond[4]=((((-1.0)*x651))+(((-1.0)*new_r01*x646))+((cj0*new_r11)));
evalcond[5]=(((sj0*x644))+((x643*x648))+new_r01);
evalcond[6]=((((-1.0)*cj1*x651))+x647+x650);
evalcond[7]=(((sj0*x643))+new_r00+(((-1.0)*x648*x651)));
evalcond[8]=(((sj0*x652))+(((-1.0)*cj0*x651))+new_r11);
evalcond[9]=((((-1.0)*cj1*x644*x646))+(((-1.0)*cj0*x653))+new_r10);
evalcond[10]=(((cj1*x649))+(((-1.0)*new_r21*x645))+((new_r01*x648))+x643);
evalcond[11]=(((cj1*x647))+((cj1*x650))+(((-1.0)*x651))+(((-1.0)*new_r20*x645)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}
}
}
}
}static inline void polyroots3(IkReal rawcoeffs[3+1], IkReal rawroots[3], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots2(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[3];
    const int maxsteps = 110;
    for(int i = 0; i < 3; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[3];
    IkReal err[3];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 3; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 3; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 3; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 3; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[3] = {false};
    for(int i = 0; i < 3; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 3; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots2(IkReal rawcoeffs[2+1], IkReal rawroots[2], int& numroots) {
    IkReal det = rawcoeffs[1]*rawcoeffs[1]-4*rawcoeffs[0]*rawcoeffs[2];
    if( det < 0 ) {
        numroots=0;
    }
    else if( det == 0 ) {
        rawroots[0] = -0.5*rawcoeffs[1]/rawcoeffs[0];
        numroots = 1;
    }
    else {
        det = IKsqrt(det);
        rawroots[0] = (-rawcoeffs[1]+det)/(2*rawcoeffs[0]);
        rawroots[1] = (-rawcoeffs[1]-det)/(2*rawcoeffs[0]);//rawcoeffs[2]/(rawcoeffs[0]*rawroots[0]);
        numroots = 2;
    }
}
static inline void polyroots4(IkReal rawcoeffs[4+1], IkReal rawroots[4], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots3(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[4];
    const int maxsteps = 110;
    for(int i = 0; i < 4; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[4];
    IkReal err[4];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 4; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 4; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 4; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 4; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[4] = {false};
    for(int i = 0; i < 4; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 4; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
};


/// solves the inverse kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API bool ComputeIk2(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions, void* pOpenRAVEManip) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API const char* GetKinematicsHash() { return "bf50724965d11d261f26d50529e90097"; }

IKFAST_API const char* GetIkFastVersion() { return "0x10000049"; }

#ifdef IKFAST_NAMESPACE
} // end namespace
#endif

#ifndef IKFAST_NO_MAIN
#include <stdio.h>
#include <stdlib.h>
#ifdef IKFAST_NAMESPACE
using namespace IKFAST_NAMESPACE;
#endif
int main(int argc, char** argv)
{
    if( argc != 12+GetNumFreeParameters()+1 ) {
        printf("\nUsage: ./ik r00 r01 r02 t0 r10 r11 r12 t1 r20 r21 r22 t2 free0 ...\n\n"
               "Returns the ik solutions given the transformation of the end effector specified by\n"
               "a 3x3 rotation R (rXX), and a 3x1 translation (tX).\n"
               "There are %d free parameters that have to be specified.\n\n",GetNumFreeParameters());
        return 1;
    }

    IkSolutionList<IkReal> solutions;
    std::vector<IkReal> vfree(GetNumFreeParameters());
    IkReal eerot[9],eetrans[3];
    eerot[0] = atof(argv[1]); eerot[1] = atof(argv[2]); eerot[2] = atof(argv[3]); eetrans[0] = atof(argv[4]);
    eerot[3] = atof(argv[5]); eerot[4] = atof(argv[6]); eerot[5] = atof(argv[7]); eetrans[1] = atof(argv[8]);
    eerot[6] = atof(argv[9]); eerot[7] = atof(argv[10]); eerot[8] = atof(argv[11]); eetrans[2] = atof(argv[12]);
    for(std::size_t i = 0; i < vfree.size(); ++i)
        vfree[i] = atof(argv[13+i]);
    bool bSuccess = ComputeIk(eetrans, eerot, vfree.size() > 0 ? &vfree[0] : NULL, solutions);

    if( !bSuccess ) {
        fprintf(stderr,"Failed to get ik solution\n");
        return -1;
    }

    printf("Found %d ik solutions:\n", (int)solutions.GetNumSolutions());
    std::vector<IkReal> solvalues(GetNumJoints());
    for(std::size_t i = 0; i < solutions.GetNumSolutions(); ++i) {
        const IkSolutionBase<IkReal>& sol = solutions.GetSolution(i);
        printf("sol%d (free=%d): ", (int)i, (int)sol.GetFree().size());
        std::vector<IkReal> vsolfree(sol.GetFree().size());
        sol.GetSolution(&solvalues[0],vsolfree.size()>0?&vsolfree[0]:NULL);
        for( std::size_t j = 0; j < solvalues.size(); ++j)
            printf("%.15f, ", solvalues[j]);
        printf("\n");
    }
    return 0;
}

#endif

// start python bindings
#include <Python.h>

// https://github.com/caelan/ss-pybullet/blob/c5efe7ad32381a7a7a15c2bd147b5a8731d21342/pybullet_tools/ikfast/pr2/left_arm_ik.cpp#L12972
// https://github.com/yijiangh/conrob_pybullet/blob/master/utils/ikfast/kuka_kr6_r900/ikfast0x1000004a.Transform6D.0_1_2_3_4_5.cpp#L9923

static PyObject *get_ik(PyObject *self, PyObject *args)
{
    IkSolutionList<IkReal> solutions;

    std::vector<IkReal> vfree(GetNumFreeParameters());
    IkReal eerot[9], eetrans[3];

    // First list if 3x3 rotation matrix, easier to compute in Python.
    // Next list is [x, y, z] translation matrix.
    // Last list is free joints.
    PyObject *rotList; // 3x3 rotation matrix
    PyObject *transList; // [x,y,z]
    PyObject *freeList; // can be empty

    // format 'O!': pass C object pointer with the pointer's address.
    if(!PyArg_ParseTuple(args, "O!O!O!", &PyList_Type, &rotList, &PyList_Type, &transList, &PyList_Type, &freeList))
    {
        fprintf(stderr,"Failed to parse input to python objects\n");
        return NULL;
    }

    for(std::size_t i = 0; i < 3; ++i)
    {
        eetrans[i] = PyFloat_AsDouble(PyList_GetItem(transList, i));

        PyObject* rowList = PyList_GetItem(rotList, i);
        for( std::size_t j = 0; j < 3; ++j)
        {
            eerot[3*i + j] = PyFloat_AsDouble(PyList_GetItem(rowList, j));
        }
    }

    for(int i = 0; i < GetNumFreeParameters(); ++i)
    {
        vfree[i] = PyFloat_AsDouble(PyList_GetItem(freeList, i));
    }

    // call ikfast routine
    bool bSuccess = ComputeIk(eetrans, eerot, &vfree[0], solutions);

    if (!bSuccess)
    {
        //fprintf(stderr,"Failed to get ik solution\n");
        return Py_BuildValue(""); // Equivalent to returning None in python
    }

    std::vector<IkReal> solvalues(GetNumJoints());
    PyObject *solutionList = PyList_New(solutions.GetNumSolutions());

    // convert all ikfast solutions into a python list
    for(std::size_t i = 0; i < solutions.GetNumSolutions(); ++i)
    {
        const IkSolutionBase<IkReal>& sol = solutions.GetSolution(i);
        std::vector<IkReal> vsolfree(sol.GetFree().size());
        sol.GetSolution(&solvalues[0],vsolfree.size()>0?&vsolfree[0]:NULL);

        PyObject *individualSolution = PyList_New(GetNumJoints());
        for( std::size_t j = 0; j < solvalues.size(); ++j)
        {
            // I think IkReal is just a wrapper for double. So this should work.
            PyList_SetItem(individualSolution, j, PyFloat_FromDouble(solvalues[j]));
        }
        PyList_SetItem(solutionList, i, individualSolution);
    }

    return solutionList;
}

static PyObject *get_fk(PyObject *self, PyObject *args)
{
    std::vector<IkReal> joints(GetNumJoints());
    // eerot is a flattened 3x3 rotation matrix
    IkReal eerot[9], eetrans[3];

    PyObject *jointList;
    if(!PyArg_ParseTuple(args, "O!", &PyList_Type, &jointList))
    {
        return NULL;
    }

    for(std::size_t i = 0; i < GetNumJoints(); ++i)
    {
        joints[i] = PyFloat_AsDouble(PyList_GetItem(jointList, i));
    }

    // call ikfast routine
    ComputeFk(&joints[0], eetrans, eerot);

    // convert computed EE pose to a python object
    PyObject *pose = PyList_New(2);
    PyObject *pos = PyList_New(3);
    PyObject *rot = PyList_New(3);

    for(std::size_t i = 0; i < 3; ++i)
    {
        PyList_SetItem(pos, i, PyFloat_FromDouble(eetrans[i]));

        PyObject *row = PyList_New(3);
        for( std::size_t j = 0; j < 3; ++j)
        {
            PyList_SetItem(row, j, PyFloat_FromDouble(eerot[3*i + j]));
        }
        PyList_SetItem(rot, i, row);
    }

    PyList_SetItem(pose, 0, pos);
    PyList_SetItem(pose, 1, rot);

    return pose;
}

static PyMethodDef ikfast_methods[] =
{
    {"get_ik", get_ik, METH_VARARGS, "Compute ik solutions using ikfast."},
    {"get_fk", get_fk, METH_VARARGS, "Compute fk solutions using ikfast."},
    {NULL, NULL, 0, NULL}
    // Not sure why/if this is needed. It shows up in the examples though(something about Sentinel).
};

#if PY_MAJOR_VERSION >= 3

static struct PyModuleDef ikfast_panda_arm_module = {
    PyModuleDef_HEAD_INIT,
    "ikfast_panda_arm",   /* name of module */
    NULL, /* module documentation, may be NULL */
    -1,       /* size of per-interpreter state of the module,
                 or -1 if the module keeps state in global variables. */
    ikfast_methods
};

#define INITERROR return NULL

PyMODINIT_FUNC
PyInit_ikfast_panda_arm(void)

#else // PY_MAJOR_VERSION < 3
#define INITERROR return

PyMODINIT_FUNC
initikfast_panda_arm(void)
#endif
{
#if PY_MAJOR_VERSION >= 3
    PyObject *module = PyModule_Create(&ikfast_panda_arm_module);
#else
    PyObject *module = Py_InitModule("ikfast_panda_arm", ikfast_methods);
#endif

if (module == NULL)
    INITERROR;

#if PY_MAJOR_VERSION >= 3
    return module;
#endif
}

// end python bindings