import React from 'react';
import { createUseStyles } from 'react-jss';
import { TextField } from '../TextField';
const useStyles = createUseStyles({
    container: {
        padding: '8px 16px 8px 16px'
    },
    textFieldContainer: {
        margin: '8px 0 8px 0'
    },
    warning: {
        margin: '8px 8px 16px 8px',
        color: '#808080',
        fontSize: '9pt'
    }
});
export const X509Auth = ({ params = { certificate: '', key: '', account: '' }, onChange }) => {
    const classes = useStyles();
    const onCertPathChange = (path) => {
        onChange(Object.assign(Object.assign({}, params), { certificate: path }));
    };
    const onKeyPathChange = (path) => {
        onChange(Object.assign(Object.assign({}, params), { key: path }));
    };
    const onAccountChange = (account) => {
        onChange(Object.assign(Object.assign({}, params), { account }));
    };
    return (React.createElement(React.Fragment, null,
        React.createElement("div", { className: classes.container },
            React.createElement("div", { className: classes.textFieldContainer },
                React.createElement(TextField, { placeholder: "Path to certificate file", outlineColor: "#d5d5d5", value: params.certificate, onChange: e => onCertPathChange(e.target.value) })),
            React.createElement("div", { className: classes.textFieldContainer },
                React.createElement(TextField, { placeholder: "Path to key file (optional)", outlineColor: "#d5d5d5", value: params.key, onChange: e => onKeyPathChange(e.target.value) })),
            React.createElement("div", { className: classes.warning }, "Enter the private key path if the certificate file does not include it. Passphrase-protected certificate is not supported."),
            React.createElement("div", { className: classes.textFieldContainer },
                React.createElement(TextField, { placeholder: "Account (optional)", outlineColor: "#d5d5d5", value: params.account, onChange: e => onAccountChange(e.target.value) })))));
};
