import React from 'react';
import { createUseStyles } from 'react-jss';
import { TextField } from '../TextField';
const useStyles = createUseStyles({
    container: {
        padding: '8px 16px 8px 16px'
    },
    label: {
        margin: '4px 0 4px 0'
    },
    textFieldContainer: {
        margin: '8px 0 8px 0'
    },
    warning: {
        margin: '8px 8px 16px 8px',
        color: '#808080',
        fontSize: '9pt'
    }
});
export const UserPassAuth = ({ params = { username: '', password: '', account: '' }, onChange }) => {
    const classes = useStyles();
    const onUsernameChange = (username) => {
        onChange(Object.assign(Object.assign({}, params), { username }));
    };
    const onPasswordChange = (password) => {
        onChange(Object.assign(Object.assign({}, params), { password }));
    };
    const onAccountChange = (account) => {
        onChange(Object.assign(Object.assign({}, params), { account }));
    };
    return (React.createElement(React.Fragment, null,
        React.createElement("div", { className: classes.container },
            React.createElement("div", { className: classes.textFieldContainer },
                React.createElement("div", { className: classes.label }, "Username"),
                React.createElement(TextField, { placeholder: "Username", outlineColor: "#d5d5d5", value: params.username, onChange: e => onUsernameChange(e.target.value) })),
            React.createElement("div", { className: classes.textFieldContainer },
                React.createElement("div", { className: classes.label }, "Password"),
                React.createElement(TextField, { placeholder: "Password", type: "password", outlineColor: "#d5d5d5", value: params.password, onChange: e => onPasswordChange(e.target.value) })),
            React.createElement("div", { className: classes.warning }, "Your password will be stored in plain text inside your user directory."),
            React.createElement("div", { className: classes.textFieldContainer },
                React.createElement("div", { className: classes.label }, "Account (optional)"),
                React.createElement(TextField, { placeholder: "Account (optional)", outlineColor: "#d5d5d5", value: params.account, onChange: e => onAccountChange(e.target.value) })))));
};
