var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { useEffect } from 'react';
import { createUseStyles } from 'react-jss';
import CopyToClipboard from 'react-copy-to-clipboard';
import { useStoreState } from 'pullstate';
import { UIStore } from '../../stores/UIStore';
import { Spinning } from '../Spinning';
import { withRequestAPI } from '../../utils/Actions';
import { AddToNotebookPopover } from './AddToNotebookPopover';
const useStyles = createUseStyles({
    container: {
        padding: '0 16px 8px 16px',
        backgroundColor: '#F8F8F8'
    },
    icon: {
        fontSize: '10pt',
        verticalAlign: 'middle'
    },
    loading: {
        color: '#808080',
        alignItems: 'center'
    },
    statusText: {
        fontSize: '9pt',
        verticalAlign: 'middle',
        paddingLeft: '4px'
    },
    statusAvailable: {
        color: '#5a9216',
        flex: 1
    },
    statusNotAvailable: {
        color: '#dd2c00',
        flex: 1
    },
    statusReplicating: {
        color: '#ffa000'
    },
    statusContainer: {
        display: 'flex',
        flexDirection: 'row',
        alignItems: 'center'
    },
    path: {
        fontSize: '9pt',
        padding: 0,
        margin: '8px 0 8px 0',
        overflowWrap: 'break-word',
        cursor: 'pointer',
        '&:hover': {
            color: '#2196F3'
        },
        '& .copy': {
            display: 'none',
            fontSize: '12px'
        },
        '&:hover .copy': {
            display: 'inline'
        }
    },
    action: {
        fontSize: '9pt',
        color: '#2196F3',
        cursor: 'pointer'
    }
});
const _FileDIDItemDetails = (_a) => {
    var { did } = _a, props = __rest(_a, ["did"]);
    const { actions } = props;
    const classes = useStyles();
    const activeInstance = useStoreState(UIStore, s => s.activeInstance);
    const fileDetails = useStoreState(UIStore, s => s.fileDetails[did]);
    const stillMounted = { value: false };
    useEffect(() => {
        stillMounted.value = true;
        return () => (stillMounted.value = false);
    }, []);
    const fetchFileDetails = (poll = false) => {
        return actions.getFileDIDDetails(activeInstance.name, did, poll).then(file => {
            if (file.status === 'REPLICATING') {
                if (stillMounted.value) {
                    enablePolling();
                }
            }
            else {
                disablePolling();
            }
            return file;
        });
    };
    let pollInterval = undefined;
    const poll = () => {
        fetchFileDetails(true);
    };
    const enablePolling = () => {
        if (pollInterval === undefined) {
            poll();
            pollInterval = window.setInterval(() => {
                poll();
            }, 10000); // TODO change 10s?
        }
    };
    const disablePolling = () => {
        if (pollInterval !== undefined) {
            window.clearInterval(pollInterval);
            pollInterval = undefined;
        }
    };
    useEffect(() => {
        fetchFileDetails();
        return () => {
            disablePolling();
        };
    }, []);
    const makeAvailable = () => {
        actions
            .makeFileAvailable(activeInstance.name, did)
            .then(() => enablePolling())
            .catch(e => console.log(e)); // TODO handle error
    };
    return (React.createElement("div", { className: classes.container },
        !fileDetails && (React.createElement("div", { className: classes.loading },
            React.createElement(Spinning, { className: `${classes.icon} material-icons` }, "hourglass_top"),
            React.createElement("span", { className: classes.statusText }, "Loading..."))),
        !!fileDetails && fileDetails.status === 'OK' && React.createElement(FileAvailable, { did: did, path: fileDetails.path }),
        !!fileDetails && fileDetails.status === 'NOT_AVAILABLE' && React.createElement(FileNotAvailable, { onMakeAvailableClicked: makeAvailable }),
        !!fileDetails && fileDetails.status === 'REPLICATING' && React.createElement(FileReplicating, null),
        !!fileDetails && fileDetails.status === 'STUCK' && React.createElement(FileStuck, null)));
};
const FileAvailable = ({ did, path }) => {
    const classes = useStyles();
    return (React.createElement(React.Fragment, null,
        React.createElement("div", { className: classes.statusContainer },
            React.createElement("div", { className: classes.statusAvailable },
                React.createElement("i", { className: `${classes.icon} material-icons` }, "check_circle"),
                React.createElement("span", { className: classes.statusText }, "Available")),
            React.createElement("div", { className: classes.action },
                React.createElement(AddToNotebookPopover, { did: did, type: "file" }, "Add to Notebook"))),
        React.createElement(CopyToClipboard, { text: path },
            React.createElement("div", { className: classes.path },
                path,
                " ",
                React.createElement("i", { className: "material-icons copy" }, "file_copy")))));
};
const FileNotAvailable = ({ onMakeAvailableClicked }) => {
    const classes = useStyles();
    return (React.createElement("div", { className: classes.statusContainer },
        React.createElement("div", { className: classes.statusNotAvailable },
            React.createElement("i", { className: `${classes.icon} material-icons` }, "cancel"),
            React.createElement("span", { className: classes.statusText }, "Not Available")),
        React.createElement("div", { className: classes.action, onClick: onMakeAvailableClicked }, "Make Available")));
};
const FileReplicating = () => {
    const classes = useStyles();
    return (React.createElement("div", { className: classes.statusReplicating },
        React.createElement(Spinning, { className: `${classes.icon} material-icons` }, "hourglass_top"),
        React.createElement("span", { className: classes.statusText }, "Replicating file...")));
};
const FileStuck = () => {
    const classes = useStyles();
    return (React.createElement("div", { className: classes.statusNotAvailable },
        React.createElement("i", { className: `${classes.icon} material-icons` }, "error"),
        React.createElement("span", { className: classes.statusText }, "Someting went wrong")));
};
export const FileDIDItemDetails = withRequestAPI(_FileDIDItemDetails);
