var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { useEffect, useMemo } from 'react';
import { createUseStyles } from 'react-jss';
import { useStoreState } from 'pullstate';
import { UIStore } from '../../stores/UIStore';
import { Spinning } from '../Spinning';
import { withRequestAPI } from '../../utils/Actions';
import { AddToNotebookPopover } from './AddToNotebookPopover';
import { computeContainerState } from '../../utils/Helpers';
const useStyles = createUseStyles({
    container: {
        padding: '0 16px 8px 16px',
        backgroundColor: '#F8F8F8'
    },
    icon: {
        fontSize: '10pt',
        verticalAlign: 'middle'
    },
    loading: {
        color: '#808080',
        alignItems: 'center'
    },
    statusText: {
        fontSize: '9pt',
        verticalAlign: 'middle',
        paddingLeft: '4px'
    },
    statusAvailable: {
        color: '#5a9216',
        flex: 1
    },
    statusPartiallyAvailable: {
        color: '#ffa000',
        flex: 1
    },
    statusNotAvailable: {
        color: '#dd2c00',
        flex: 1
    },
    statusReplicating: {
        color: '#ffa000'
    },
    statusContainer: {
        display: 'flex',
        flexDirection: 'row',
        alignItems: 'center'
    },
    action: {
        fontSize: '9pt',
        color: '#2196F3',
        cursor: 'pointer'
    }
});
const _ContainerDIDItemDetails = (_a) => {
    var { did } = _a, props = __rest(_a, ["did"]);
    const classes = useStyles();
    const { actions } = props;
    const activeInstance = useStoreState(UIStore, s => s.activeInstance);
    const containerAttachedFiles = useStoreState(UIStore, s => s.containerDetails[did]);
    const stillMounted = { value: false };
    useEffect(() => {
        stillMounted.value = true;
        return () => (stillMounted.value = false);
    }, []);
    const fetchDIDDetails = (poll = false) => {
        return actions.getContainerDIDDetails(activeInstance.name, did, poll).then(files => {
            const containerState = computeContainerState(files);
            if (containerState === 'REPLICATING') {
                if (stillMounted.value) {
                    enablePolling();
                }
            }
            else {
                disablePolling();
            }
            return files;
        });
    };
    let pollInterval = undefined;
    const poll = () => {
        fetchDIDDetails(true);
    };
    const enablePolling = () => {
        if (pollInterval === undefined) {
            poll();
            pollInterval = window.setInterval(() => {
                poll();
            }, 10000); // TODO change 10s?
        }
    };
    const disablePolling = () => {
        if (pollInterval !== undefined) {
            window.clearInterval(pollInterval);
            pollInterval = undefined;
        }
    };
    useEffect(() => {
        fetchDIDDetails();
        return () => {
            disablePolling();
        };
    }, []);
    const makeAvailable = () => {
        actions
            .makeContainerAvailable(activeInstance.name, did)
            .then(() => enablePolling())
            .catch(e => console.log(e)); // TODO handle error
    };
    const containerState = useMemo(() => {
        return containerAttachedFiles ? computeContainerState(containerAttachedFiles) : undefined;
    }, [containerAttachedFiles]);
    return (React.createElement("div", { className: classes.container },
        !containerAttachedFiles && (React.createElement("div", { className: classes.loading },
            React.createElement(Spinning, { className: `${classes.icon} material-icons` }, "hourglass_top"),
            React.createElement("span", { className: classes.statusText }, "Loading..."))),
        containerState === 'AVAILABLE' && React.createElement(FileAvailable, { did: did }),
        containerState === 'PARTIALLY_AVAILABLE' && React.createElement(FilePartiallyAvailable, { onMakeAvailableClicked: makeAvailable }),
        containerState === 'NOT_AVAILABLE' && React.createElement(FileNotAvailable, { onMakeAvailableClicked: makeAvailable }),
        containerState === 'REPLICATING' && React.createElement(FileReplicating, null),
        containerState === 'STUCK' && React.createElement(FileStuck, null)));
};
const FileAvailable = ({ did }) => {
    const classes = useStyles();
    return (React.createElement(React.Fragment, null,
        React.createElement("div", { className: classes.statusContainer },
            React.createElement("div", { className: classes.statusAvailable },
                React.createElement("i", { className: `${classes.icon} material-icons` }, "check_circle"),
                React.createElement("span", { className: classes.statusText }, "All files available")),
            React.createElement("div", { className: classes.action },
                React.createElement(AddToNotebookPopover, { did: did, type: "container" }, "Add to Notebook")))));
};
const FileNotAvailable = ({ onMakeAvailableClicked }) => {
    const classes = useStyles();
    return (React.createElement("div", { className: classes.statusContainer },
        React.createElement("div", { className: classes.statusNotAvailable },
            React.createElement("i", { className: `${classes.icon} material-icons` }, "cancel"),
            React.createElement("span", { className: classes.statusText }, "Not available")),
        React.createElement("div", { className: classes.action, onClick: onMakeAvailableClicked }, "Make Available")));
};
const FilePartiallyAvailable = ({ onMakeAvailableClicked }) => {
    const classes = useStyles();
    return (React.createElement("div", { className: classes.statusContainer },
        React.createElement("div", { className: classes.statusPartiallyAvailable },
            React.createElement("i", { className: `${classes.icon} material-icons` }, "cancel"),
            React.createElement("span", { className: classes.statusText }, "Partially available")),
        React.createElement("div", { className: classes.action, onClick: onMakeAvailableClicked }, "Make Available")));
};
const FileReplicating = () => {
    const classes = useStyles();
    return (React.createElement("div", { className: classes.statusReplicating },
        React.createElement(Spinning, { className: `${classes.icon} material-icons` }, "hourglass_top"),
        React.createElement("span", { className: classes.statusText }, "Replicating files...")));
};
const FileStuck = () => {
    const classes = useStyles();
    return (React.createElement("div", { className: classes.statusNotAvailable },
        React.createElement("i", { className: `${classes.icon} material-icons` }, "error"),
        React.createElement("span", { className: classes.statusText }, "Someting went wrong")));
};
export const ContainerDIDItemDetails = withRequestAPI(_ContainerDIDItemDetails);
