import React, { useEffect, useState } from 'react';
import { createUseStyles } from 'react-jss';
import { VDomRenderer } from '@jupyterlab/apputils';
import { NotebookListener } from './utils/NotebookListener';
import { ActiveNotebookListener } from './utils/ActiveNotebookListener';
import { Header } from './components/Header';
import { MainPanel } from './pages/MainPanel';
import { Spinning } from './components/Spinning';
import { UIStore } from './stores/UIStore';
const useStyles = createUseStyles({
    panel: {
        height: '100%',
        display: 'flex',
        flexDirection: 'column'
    },
    section: {
        flex: 1
    },
    loading: {
        padding: '8px 16px 8px 16px'
    },
    icon: {
        fontSize: '10pt',
        verticalAlign: 'middle'
    },
    iconText: {
        verticalAlign: 'middle',
        paddingLeft: '4px'
    }
});
const Panel = ({ instanceConfig }) => {
    const classes = useStyles();
    const { activeInstance, authType, instances } = instanceConfig;
    const [configLoaded, setConfigLoaded] = useState(false);
    useEffect(() => {
        const objActiveInstance = instances.find(i => i.name === activeInstance);
        UIStore.update(s => {
            s.activeInstance = objActiveInstance;
            s.activeAuthType = authType;
            s.instances = instances;
        });
        setConfigLoaded(true);
    }, [instanceConfig]);
    return (React.createElement("div", { className: classes.panel },
        React.createElement(Header, null),
        !!configLoaded && React.createElement(MainPanel, null),
        !configLoaded && (React.createElement("div", { className: classes.loading },
            React.createElement(Spinning, { className: `${classes.icon} material-icons` }, "hourglass_top"),
            React.createElement("span", { className: classes.iconText }, "Loading...")))));
};
const PANEL_CLASS = 'jp-RucioExtensionPanel';
export class SidebarPanel extends VDomRenderer {
    constructor(options) {
        super();
        super.addClass(PANEL_CLASS);
        const { app, settingRegistry, labShell, notebookTracker, widgetId, instanceConfig } = options;
        super.id = widgetId;
        super.title.closable = true;
        super.title.iconClass += 'jp-icon-rucio';
        this.app = app;
        this.settingRegistry = settingRegistry;
        this.instanceConfig = instanceConfig;
        this.notebookListener = new NotebookListener({
            labShell,
            notebookTracker,
            sessionManager: app.serviceManager.sessions
        });
        this.activeNotebookListener = new ActiveNotebookListener({
            labShell,
            notebookTracker,
            sessionManager: app.serviceManager.sessions,
            notebookListener: this.notebookListener
        });
    }
    render() {
        return React.createElement(Panel, { instanceConfig: this.instanceConfig });
    }
}
