/*
 * Decompiled with CFR 0.152.
 */
package spire.math.poly;

import algebra.ring.AdditiveCommutativeGroup;
import algebra.ring.AdditiveCommutativeMonoid;
import algebra.ring.AdditiveCommutativeSemigroup;
import algebra.ring.AdditiveGroup;
import algebra.ring.AdditiveMonoid;
import algebra.ring.AdditiveSemigroup;
import cats.kernel.CommutativeGroup;
import cats.kernel.Comparison;
import cats.kernel.Eq;
import cats.kernel.Order;
import cats.kernel.PartialOrder;
import java.io.Serializable;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import spire.algebra.Sign;
import spire.algebra.Signed;
import spire.algebra.SignedAdditiveAbGroup;
import spire.algebra.SignedAdditiveCMonoid;
import spire.math.Polynomial;
import spire.math.Polynomial$;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.package$;
import spire.math.poly.BigDecimalRootRefinement;
import spire.math.poly.BigDecimalRootRefinement$AbsoluteContext$;
import spire.math.poly.Term;
import spire.std.package$bigDecimal$;

public final class BigDecimalRootRefinement$
implements scala.Serializable {
    public static BigDecimalRootRefinement$ MODULE$;
    private final Signed<java.math.BigDecimal> JBigDecimalOrder;
    private final double spire$math$poly$BigDecimalRootRefinement$$bits2dec;

    static {
        new BigDecimalRootRefinement$();
    }

    public BigDecimalRootRefinement apply(Polynomial<BigDecimal> poly, Rational lowerBound, Rational upperBound) {
        Polynomial<BigDecimal> upoly = poly.map((Function1<BigDecimal, BigDecimal> & Serializable & scala.Serializable)n -> new BigDecimal(n.bigDecimal(), MathContext.UNLIMITED), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), ClassTag$.MODULE$.apply(BigDecimal.class), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra());
        return new BigDecimalRootRefinement(BigDecimalRootRefinement$AbsoluteContext$.MODULE$.apply(upoly, BigDecimalRootRefinement$AbsoluteContext$.MODULE$.apply$default$2()), new BigDecimalRootRefinement.Unbounded(lowerBound, upperBound));
    }

    public BigDecimalRootRefinement apply(Polynomial<BigDecimal> poly, Rational lowerBound, Rational upperBound, int scale) {
        return this.apply(poly, lowerBound, upperBound).refine(scale);
    }

    public BigDecimalRootRefinement apply(Polynomial<BigDecimal> poly, Rational lowerBound, Rational upperBound, MathContext mc) {
        return this.apply(poly, lowerBound, upperBound).refine(mc);
    }

    private Signed<java.math.BigDecimal> JBigDecimalOrder() {
        return this.JBigDecimalOrder;
    }

    public double spire$math$poly$BigDecimalRootRefinement$$bits2dec() {
        return this.spire$math$poly$BigDecimalRootRefinement$$bits2dec;
    }

    public BigDecimalRootRefinement.Approximation spire$math$poly$BigDecimalRootRefinement$$QIR(BigDecimalRootRefinement.ApproximationContext context, Rational lowerBound, Rational upperBound, java.math.BigDecimal lb, java.math.BigDecimal ub) {
        return this.adjust$1(lb, None$.MODULE$, ub, None$.MODULE$, context, lowerBound, upperBound);
    }

    public BigDecimalRootRefinement.Approximation spire$math$poly$BigDecimalRootRefinement$$QIR(BigDecimalRootRefinement.ApproximationContext context, java.math.BigDecimal lowerBound, java.math.BigDecimal lowerBoundValue, java.math.BigDecimal upperBound, java.math.BigDecimal upperBoundValue, int n0) {
        java.math.BigDecimal lx = lowerBound;
        java.math.BigDecimal ly = lowerBoundValue;
        java.math.BigDecimal rx = upperBound;
        java.math.BigDecimal ry = upperBoundValue;
        return n0 <= 0 ? this.loop0$1(lx, ly, rx, ry, context) : this.loop$1(lx, ly, rx, ry, n0, context);
    }

    private int QIR$default$6() {
        return 0;
    }

    public BigDecimalRootRefinement apply(BigDecimalRootRefinement.ApproximationContext context, BigDecimalRootRefinement.Approximation approximation) {
        return new BigDecimalRootRefinement(context, approximation);
    }

    public Option<Tuple2<BigDecimalRootRefinement.ApproximationContext, BigDecimalRootRefinement.Approximation>> unapply(BigDecimalRootRefinement x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple2<BigDecimalRootRefinement.ApproximationContext, BigDecimalRootRefinement.Approximation>>(new Tuple2<BigDecimalRootRefinement.ApproximationContext, BigDecimalRootRefinement.Approximation>(x$0.context(), x$0.approximation()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final Polynomial shift$1(Polynomial poly, Rational h) {
        int n = poly.degree();
        return poly.mapTerms((Function1<Term, Term> & Serializable & scala.Serializable)x0$1 -> {
            Term term = x0$1;
            if (term == null) {
                throw new MatchError(term);
            }
            BigDecimal coeff = (BigDecimal)term.coeff();
            int k = term.exp();
            BigDecimal a = scala.package$.MODULE$.BigDecimal().apply(BigInt$.MODULE$.javaBigInteger2bigInt(h.denominator().toBigInteger().pow(n - k)), MathContext.UNLIMITED);
            Term<BigDecimal> term2 = new Term<BigDecimal>(coeff.$times(a), k);
            return term2;
        }, package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), ClassTag$.MODULE$.apply(BigDecimal.class), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra()).compose(Polynomial$.MODULE$.linear(scala.package$.MODULE$.BigDecimal().apply(BigInt$.MODULE$.javaBigInteger2bigInt(h.denominator().toBigInteger()), MathContext.UNLIMITED), scala.package$.MODULE$.BigDecimal().apply(BigInt$.MODULE$.javaBigInteger2bigInt(h.numerator().toBigInteger()), MathContext.UNLIMITED), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), ClassTag$.MODULE$.apply(BigDecimal.class)), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra()).removeZeroRoots(package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra());
    }

    private static final Polynomial mult$1(Polynomial poly, Rational s) {
        int n = poly.degree();
        return poly.mapTerms((Function1<Term, Term> & Serializable & scala.Serializable)x0$2 -> {
            Term term = x0$2;
            if (term == null) {
                throw new MatchError(term);
            }
            BigDecimal coeff = (BigDecimal)term.coeff();
            int k = term.exp();
            BigDecimal a = scala.package$.MODULE$.BigDecimal().apply(BigInt$.MODULE$.javaBigInteger2bigInt(s.denominator().toBigInteger().pow(n - k)), MathContext.UNLIMITED);
            Term<BigDecimal> term2 = new Term<BigDecimal>(coeff.$times(a), k);
            return term2;
        }, package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), ClassTag$.MODULE$.apply(BigDecimal.class), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra()).compose(Polynomial$.MODULE$.linear(scala.package$.MODULE$.BigDecimal().apply(BigInt$.MODULE$.javaBigInteger2bigInt(s.numerator().toBigInteger()), MathContext.UNLIMITED), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), ClassTag$.MODULE$.apply(BigDecimal.class)), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra()).removeZeroRoots(package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra());
    }

    private static final boolean hasRoot$1(Rational l, Rational r, BigDecimalRootRefinement.ApproximationContext context$2) {
        Polynomial<BigDecimal> poly0;
        return !BoxesRunTime.equalsNumNum(l, r) ? (poly0 = BigDecimalRootRefinement$.mult$1(BigDecimalRootRefinement$.shift$1(context$2.poly(), l), r.$minus(l)).reciprocal(package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra()).shift(BigDecimal$.MODULE$.int2bigDecimal(1), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra()).removeZeroRoots(package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra())).signVariations(package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra()) % 2 == 1 : false;
    }

    private static final Rational qlx$1(java.math.BigDecimal lx$1) {
        return Rational$.MODULE$.apply(new BigDecimal(lx$1, MathContext.UNLIMITED));
    }

    private static final Rational qrx$1(java.math.BigDecimal rx$1) {
        return Rational$.MODULE$.apply(new BigDecimal(rx$1, MathContext.UNLIMITED));
    }

    public static final /* synthetic */ java.math.BigDecimal $anonfun$QIR$3(BigDecimalRootRefinement.ApproximationContext context$2, java.math.BigDecimal lx$1) {
        return context$2.evalExact(lx$1);
    }

    public static final /* synthetic */ java.math.BigDecimal $anonfun$QIR$4(BigDecimalRootRefinement.ApproximationContext context$2, java.math.BigDecimal rx$1) {
        return context$2.evalExact(rx$1);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final BigDecimalRootRefinement.Approximation adjust$1(java.math.BigDecimal lx, Option lyOpt, java.math.BigDecimal rx, Option ryOpt2, BigDecimalRootRefinement.ApproximationContext context$2, Rational lowerBound$1, Rational upperBound$1) {
        java.math.BigDecimal ry;
        java.math.BigDecimal ly;
        BigDecimalRootRefinement.Approximation approximation;
        while (true) {
            if (lx.compareTo(rx) >= 0) {
                approximation = new BigDecimalRootRefinement.Unbounded((Rational)lowerBound$1, (Rational)upperBound$1);
                return approximation;
            }
            ly = (java.math.BigDecimal)lyOpt.getOrElse(() -> BigDecimalRootRefinement$.$anonfun$QIR$3((BigDecimalRootRefinement.ApproximationContext)context$2, lx));
            ry = (java.math.BigDecimal)ryOpt2.getOrElse(() -> BigDecimalRootRefinement$.$anonfun$QIR$4((BigDecimalRootRefinement.ApproximationContext)context$2, rx));
            if (ly.signum() == 0) {
                if (BigDecimalRootRefinement$.qlx$1(lx).$greater((Object)lowerBound$1)) {
                    approximation = new BigDecimalRootRefinement.ExactRoot(lx);
                    return approximation;
                }
                Some<java.math.BigDecimal> ryOpt2 = new Some<java.math.BigDecimal>(ry);
                lyOpt = None$.MODULE$;
                lx = lx.add(java.math.BigDecimal.valueOf(1L, context$2.getEps(lx)));
                continue;
            }
            if (ry.signum() != 0) break;
            if (BigDecimalRootRefinement$.qrx$1(rx).$less((Object)upperBound$1)) {
                approximation = new BigDecimalRootRefinement.ExactRoot(rx);
                return approximation;
            }
            None$ ryOpt2 = None$.MODULE$;
            rx = rx.subtract(java.math.BigDecimal.valueOf(1L, context$2.getEps(rx)));
            lyOpt = new Some<java.math.BigDecimal>(ly);
        }
        if (ry.signum() != ly.signum()) {
            approximation = this.spire$math$poly$BigDecimalRootRefinement$$QIR((BigDecimalRootRefinement.ApproximationContext)context$2, lx, ly, rx, ry, this.QIR$default$6());
            return approximation;
        }
        if (BigDecimalRootRefinement$.hasRoot$1((Rational)lowerBound$1, BigDecimalRootRefinement$.qlx$1(lx), (BigDecimalRootRefinement.ApproximationContext)context$2)) {
            approximation = new BigDecimalRootRefinement.BoundedLeft((Rational)lowerBound$1, lx);
            return approximation;
        }
        approximation = new BigDecimalRootRefinement.BoundedRight(rx, (Rational)upperBound$1);
        return approximation;
    }

    private final BigDecimalRootRefinement.Approximation loop$1(java.math.BigDecimal lx, java.math.BigDecimal ly, java.math.BigDecimal rx, java.math.BigDecimal ry, int n, BigDecimalRootRefinement.ApproximationContext context$1) {
        BigDecimalRootRefinement.Approximation approximation;
        block7: {
            java.math.BigDecimal x1;
            block8: {
                java.math.BigDecimal x0;
                while (true) {
                    Sign s0;
                    Sign s1;
                    int scale;
                    java.math.BigDecimal eps;
                    java.math.BigDecimal dx;
                    if ((dx = rx.subtract(lx)).compareTo(eps = java.math.BigDecimal.valueOf(1L, scale = package$.MODULE$.max(context$1.getEps(lx), context$1.getEps(rx)))) <= 0) {
                        approximation = new BigDecimalRootRefinement.Bounded(lx, ly, rx, ry, n);
                        break block7;
                    }
                    java.math.BigDecimal dy = ly.subtract(ry);
                    java.math.BigDecimal s = ly.divide(dy, n, RoundingMode.HALF_UP);
                    java.math.BigDecimal delta = dx.multiply(s.ulp());
                    BigInteger k = s.unscaledValue();
                    x1 = lx.add(delta.multiply(new java.math.BigDecimal(k)));
                    java.math.BigDecimal y1 = context$1.evalExact(x1);
                    Sign sign = s1 = this.JBigDecimalOrder().sign(y1);
                    Sign sign2 = this.JBigDecimalOrder().sign(ly);
                    if (!(sign != null ? !sign.equals(sign2) : sign2 != null)) {
                        Sign s2;
                        java.math.BigDecimal x2 = x1.add(delta);
                        java.math.BigDecimal y2 = context$1.evalExact(x2);
                        Sign sign3 = s2 = this.JBigDecimalOrder().sign(y2);
                        Sign sign4 = s1;
                        if (!(sign3 != null ? !sign3.equals(sign4) : sign4 != null)) {
                            approximation = this.loop0$1(lx, ly, rx, ry, context$1);
                        } else {
                            Sign sign5 = s2;
                            Sign sign6 = this.JBigDecimalOrder().sign(ry);
                            if (!(sign5 != null ? !sign5.equals(sign6) : sign6 != null)) {
                                n = 2 * n;
                                ry = y2;
                                rx = x2;
                                ly = y1;
                                lx = x1;
                                continue;
                            }
                            approximation = new BigDecimalRootRefinement.ExactRoot(x2);
                        }
                        break block7;
                    }
                    Sign sign7 = s1;
                    Sign sign8 = this.JBigDecimalOrder().sign(ry);
                    if (sign7 != null ? !sign7.equals(sign8) : sign8 != null) break block8;
                    x0 = x1.subtract(delta);
                    java.math.BigDecimal y0 = context$1.evalExact(x0);
                    Sign sign9 = s0 = this.JBigDecimalOrder().sign(y0);
                    Sign sign10 = s1;
                    if (!(sign9 != null ? !sign9.equals(sign10) : sign10 != null)) {
                        approximation = this.loop0$1(lx, ly, rx, ry, context$1);
                        break block7;
                    }
                    Sign sign11 = s0;
                    Sign sign12 = this.JBigDecimalOrder().sign(ly);
                    if (sign11 != null ? !sign11.equals(sign12) : sign12 != null) break;
                    n = 2 * n;
                    ry = y1;
                    rx = x1;
                    ly = y0;
                    lx = x0;
                }
                approximation = new BigDecimalRootRefinement.ExactRoot(x0);
                break block7;
            }
            approximation = new BigDecimalRootRefinement.ExactRoot(x1);
        }
        return approximation;
    }

    private final BigDecimalRootRefinement.Approximation bisect$1(java.math.BigDecimal x0, java.math.BigDecimal y0, java.math.BigDecimal x1, java.math.BigDecimal y1, java.math.BigDecimal x2, java.math.BigDecimal y2, BigDecimalRootRefinement.ApproximationContext context$1) {
        BigDecimalRootRefinement.Approximation approximation;
        if (y0.signum() == 0) {
            approximation = new BigDecimalRootRefinement.ExactRoot(x0);
        } else if (y1.signum() == 0) {
            approximation = new BigDecimalRootRefinement.ExactRoot(x1);
        } else if (y2.signum() == 0) {
            approximation = new BigDecimalRootRefinement.ExactRoot(x2);
        } else {
            Sign sign = this.JBigDecimalOrder().sign(y0);
            Sign sign2 = this.JBigDecimalOrder().sign(y1);
            approximation = (sign == null ? sign2 != null : !sign.equals(sign2)) ? this.loop$1(x0, y0, x1, y1, 1, context$1) : this.loop$1(x1, y1, x2, y2, 1, context$1);
        }
        return approximation;
    }

    private static final Tuple2 eval$1(int k, BigDecimalRootRefinement.ApproximationContext context$1, java.math.BigDecimal x0$3, java.math.BigDecimal eps$1) {
        java.math.BigDecimal x = new java.math.BigDecimal(k).multiply(eps$1).add(x0$3);
        java.math.BigDecimal y = context$1.evalExact(x);
        return new Tuple2<java.math.BigDecimal, java.math.BigDecimal>(x, y);
    }

    private final BigDecimalRootRefinement.Approximation loop0$1(java.math.BigDecimal x0, java.math.BigDecimal y0, java.math.BigDecimal x5, java.math.BigDecimal y5, BigDecimalRootRefinement.ApproximationContext context$1) {
        BigDecimalRootRefinement.Approximation approximation;
        java.math.BigDecimal dy = y0.subtract(y5);
        int k = y0.divide(dy, 1, RoundingMode.HALF_UP).unscaledValue().intValue();
        java.math.BigDecimal eps = x5.subtract(x0).divide(new java.math.BigDecimal(5));
        if (k < 5) {
            Tuple2 tuple2 = BigDecimalRootRefinement$.eval$1(2, context$1, x0, eps);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            java.math.BigDecimal x2 = (java.math.BigDecimal)tuple2._1();
            java.math.BigDecimal y2 = (java.math.BigDecimal)tuple2._2();
            Tuple2<java.math.BigDecimal, java.math.BigDecimal> tuple22 = new Tuple2<java.math.BigDecimal, java.math.BigDecimal>(x2, y2);
            Tuple2<java.math.BigDecimal, java.math.BigDecimal> tuple23 = tuple22;
            java.math.BigDecimal x22 = tuple23._1();
            java.math.BigDecimal y22 = tuple23._2();
            Sign sign = this.JBigDecimalOrder().sign(y22);
            Sign sign2 = this.JBigDecimalOrder().sign(y0);
            if (sign == null ? sign2 != null : !sign.equals(sign2)) {
                Tuple2 tuple24 = BigDecimalRootRefinement$.eval$1(1, context$1, x0, eps);
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                java.math.BigDecimal x1 = (java.math.BigDecimal)tuple24._1();
                java.math.BigDecimal y1 = (java.math.BigDecimal)tuple24._2();
                Tuple2<java.math.BigDecimal, java.math.BigDecimal> tuple25 = new Tuple2<java.math.BigDecimal, java.math.BigDecimal>(x1, y1);
                Tuple2<java.math.BigDecimal, java.math.BigDecimal> tuple26 = tuple25;
                java.math.BigDecimal x12 = tuple26._1();
                java.math.BigDecimal y12 = tuple26._2();
                approximation = this.bisect$1(x0, y0, x12, y12, x22, y22, context$1);
            } else {
                Tuple2 tuple27 = BigDecimalRootRefinement$.eval$1(3, context$1, x0, eps);
                if (tuple27 == null) {
                    throw new MatchError(tuple27);
                }
                java.math.BigDecimal x3 = (java.math.BigDecimal)tuple27._1();
                java.math.BigDecimal y3 = (java.math.BigDecimal)tuple27._2();
                Tuple2<java.math.BigDecimal, java.math.BigDecimal> tuple28 = new Tuple2<java.math.BigDecimal, java.math.BigDecimal>(x3, y3);
                Tuple2<java.math.BigDecimal, java.math.BigDecimal> tuple29 = tuple28;
                java.math.BigDecimal x32 = tuple29._1();
                java.math.BigDecimal y32 = tuple29._2();
                Sign sign3 = this.JBigDecimalOrder().sign(y32);
                Sign sign4 = this.JBigDecimalOrder().sign(y5);
                if (!(sign3 != null ? !sign3.equals(sign4) : sign4 != null)) {
                    approximation = this.loop$1(x22, y22, x32, y32, 1, context$1);
                } else {
                    Tuple2 tuple210 = BigDecimalRootRefinement$.eval$1(4, context$1, x0, eps);
                    if (tuple210 == null) {
                        throw new MatchError(tuple210);
                    }
                    java.math.BigDecimal x4 = (java.math.BigDecimal)tuple210._1();
                    java.math.BigDecimal y4 = (java.math.BigDecimal)tuple210._2();
                    Tuple2<java.math.BigDecimal, java.math.BigDecimal> tuple211 = new Tuple2<java.math.BigDecimal, java.math.BigDecimal>(x4, y4);
                    Tuple2<java.math.BigDecimal, java.math.BigDecimal> tuple212 = tuple211;
                    java.math.BigDecimal x42 = tuple212._1();
                    java.math.BigDecimal y42 = tuple212._2();
                    approximation = this.bisect$1(x32, y32, x42, y42, x5, y5, context$1);
                }
            }
        } else {
            Tuple2 tuple2 = BigDecimalRootRefinement$.eval$1(3, context$1, x0, eps);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            java.math.BigDecimal x3 = (java.math.BigDecimal)tuple2._1();
            java.math.BigDecimal y3 = (java.math.BigDecimal)tuple2._2();
            Tuple2<java.math.BigDecimal, java.math.BigDecimal> tuple213 = new Tuple2<java.math.BigDecimal, java.math.BigDecimal>(x3, y3);
            Tuple2<java.math.BigDecimal, java.math.BigDecimal> tuple214 = tuple213;
            java.math.BigDecimal x33 = tuple214._1();
            java.math.BigDecimal y33 = tuple214._2();
            Sign sign = this.JBigDecimalOrder().sign(y33);
            Sign sign5 = this.JBigDecimalOrder().sign(y5);
            if (sign == null ? sign5 != null : !sign.equals(sign5)) {
                Tuple2 tuple215 = BigDecimalRootRefinement$.eval$1(4, context$1, x0, eps);
                if (tuple215 == null) {
                    throw new MatchError(tuple215);
                }
                java.math.BigDecimal x4 = (java.math.BigDecimal)tuple215._1();
                java.math.BigDecimal y4 = (java.math.BigDecimal)tuple215._2();
                Tuple2<java.math.BigDecimal, java.math.BigDecimal> tuple216 = new Tuple2<java.math.BigDecimal, java.math.BigDecimal>(x4, y4);
                Tuple2<java.math.BigDecimal, java.math.BigDecimal> tuple217 = tuple216;
                java.math.BigDecimal x43 = tuple217._1();
                java.math.BigDecimal y43 = tuple217._2();
                approximation = this.bisect$1(x33, y33, x43, y43, x5, y5, context$1);
            } else {
                Tuple2 tuple218 = BigDecimalRootRefinement$.eval$1(2, context$1, x0, eps);
                if (tuple218 == null) {
                    throw new MatchError(tuple218);
                }
                java.math.BigDecimal x2 = (java.math.BigDecimal)tuple218._1();
                java.math.BigDecimal y2 = (java.math.BigDecimal)tuple218._2();
                Tuple2<java.math.BigDecimal, java.math.BigDecimal> tuple219 = new Tuple2<java.math.BigDecimal, java.math.BigDecimal>(x2, y2);
                Tuple2<java.math.BigDecimal, java.math.BigDecimal> tuple220 = tuple219;
                java.math.BigDecimal x23 = tuple220._1();
                java.math.BigDecimal y23 = tuple220._2();
                Sign sign6 = this.JBigDecimalOrder().sign(y23);
                Sign sign7 = this.JBigDecimalOrder().sign(y0);
                if (!(sign6 != null ? !sign6.equals(sign7) : sign7 != null)) {
                    approximation = this.loop$1(x23, y23, x33, y33, 1, context$1);
                } else {
                    Tuple2 tuple221 = BigDecimalRootRefinement$.eval$1(1, context$1, x0, eps);
                    if (tuple221 == null) {
                        throw new MatchError(tuple221);
                    }
                    java.math.BigDecimal x1 = (java.math.BigDecimal)tuple221._1();
                    java.math.BigDecimal y1 = (java.math.BigDecimal)tuple221._2();
                    Tuple2<java.math.BigDecimal, java.math.BigDecimal> tuple222 = new Tuple2<java.math.BigDecimal, java.math.BigDecimal>(x1, y1);
                    Tuple2<java.math.BigDecimal, java.math.BigDecimal> tuple223 = tuple222;
                    java.math.BigDecimal x13 = tuple223._1();
                    java.math.BigDecimal y13 = tuple223._2();
                    approximation = this.bisect$1(x0, y0, x13, y13, x23, y23, context$1);
                }
            }
        }
        return approximation;
    }

    private BigDecimalRootRefinement$() {
        MODULE$ = this;
        this.JBigDecimalOrder = new SignedAdditiveAbGroup<java.math.BigDecimal>(){

            public byte abs$mcB$sp(byte a) {
                return SignedAdditiveAbGroup.abs$mcB$sp$(this, a);
            }

            public double abs$mcD$sp(double a) {
                return SignedAdditiveAbGroup.abs$mcD$sp$(this, a);
            }

            public float abs$mcF$sp(float a) {
                return SignedAdditiveAbGroup.abs$mcF$sp$(this, a);
            }

            public int abs$mcI$sp(int a) {
                return SignedAdditiveAbGroup.abs$mcI$sp$(this, a);
            }

            public long abs$mcJ$sp(long a) {
                return SignedAdditiveAbGroup.abs$mcJ$sp$(this, a);
            }

            public short abs$mcS$sp(short a) {
                return SignedAdditiveAbGroup.abs$mcS$sp$(this, a);
            }

            public CommutativeGroup<java.math.BigDecimal> additive() {
                return AdditiveCommutativeGroup.additive$(this);
            }

            public CommutativeGroup<Object> additive$mcD$sp() {
                return AdditiveCommutativeGroup.additive$mcD$sp$(this);
            }

            public CommutativeGroup<Object> additive$mcF$sp() {
                return AdditiveCommutativeGroup.additive$mcF$sp$(this);
            }

            public CommutativeGroup<Object> additive$mcI$sp() {
                return AdditiveCommutativeGroup.additive$mcI$sp$(this);
            }

            public CommutativeGroup<Object> additive$mcJ$sp() {
                return AdditiveCommutativeGroup.additive$mcJ$sp$(this);
            }

            public double negate$mcD$sp(double x) {
                return AdditiveGroup.negate$mcD$sp$(this, x);
            }

            public float negate$mcF$sp(float x) {
                return AdditiveGroup.negate$mcF$sp$(this, x);
            }

            public int negate$mcI$sp(int x) {
                return AdditiveGroup.negate$mcI$sp$(this, x);
            }

            public long negate$mcJ$sp(long x) {
                return AdditiveGroup.negate$mcJ$sp$(this, x);
            }

            public Object minus(Object x, Object y) {
                return AdditiveGroup.minus$(this, x, y);
            }

            public double minus$mcD$sp(double x, double y) {
                return AdditiveGroup.minus$mcD$sp$(this, x, y);
            }

            public float minus$mcF$sp(float x, float y) {
                return AdditiveGroup.minus$mcF$sp$(this, x, y);
            }

            public int minus$mcI$sp(int x, int y) {
                return AdditiveGroup.minus$mcI$sp$(this, x, y);
            }

            public long minus$mcJ$sp(long x, long y) {
                return AdditiveGroup.minus$mcJ$sp$(this, x, y);
            }

            public Object sumN(Object a, int n) {
                return AdditiveGroup.sumN$(this, a, n);
            }

            public double sumN$mcD$sp(double a, int n) {
                return AdditiveGroup.sumN$mcD$sp$(this, a, n);
            }

            public float sumN$mcF$sp(float a, int n) {
                return AdditiveGroup.sumN$mcF$sp$(this, a, n);
            }

            public int sumN$mcI$sp(int a, int n) {
                return AdditiveGroup.sumN$mcI$sp$(this, a, n);
            }

            public long sumN$mcJ$sp(long a, int n) {
                return AdditiveGroup.sumN$mcJ$sp$(this, a, n);
            }

            public int signum$mcB$sp(byte a) {
                return SignedAdditiveCMonoid.signum$mcB$sp$(this, a);
            }

            public int signum$mcD$sp(double a) {
                return SignedAdditiveCMonoid.signum$mcD$sp$(this, a);
            }

            public int signum$mcF$sp(float a) {
                return SignedAdditiveCMonoid.signum$mcF$sp$(this, a);
            }

            public int signum$mcI$sp(int a) {
                return SignedAdditiveCMonoid.signum$mcI$sp$(this, a);
            }

            public int signum$mcJ$sp(long a) {
                return SignedAdditiveCMonoid.signum$mcJ$sp$(this, a);
            }

            public int signum$mcS$sp(short a) {
                return SignedAdditiveCMonoid.signum$mcS$sp$(this, a);
            }

            public double zero$mcD$sp() {
                return AdditiveMonoid.zero$mcD$sp$(this);
            }

            public float zero$mcF$sp() {
                return AdditiveMonoid.zero$mcF$sp$(this);
            }

            public int zero$mcI$sp() {
                return AdditiveMonoid.zero$mcI$sp$(this);
            }

            public long zero$mcJ$sp() {
                return AdditiveMonoid.zero$mcJ$sp$(this);
            }

            public boolean isZero(Object a, Eq ev) {
                return AdditiveMonoid.isZero$(this, a, ev);
            }

            public boolean isZero$mcD$sp(double a, Eq<Object> ev) {
                return AdditiveMonoid.isZero$mcD$sp$(this, a, ev);
            }

            public boolean isZero$mcF$sp(float a, Eq<Object> ev) {
                return AdditiveMonoid.isZero$mcF$sp$(this, a, ev);
            }

            public boolean isZero$mcI$sp(int a, Eq<Object> ev) {
                return AdditiveMonoid.isZero$mcI$sp$(this, a, ev);
            }

            public boolean isZero$mcJ$sp(long a, Eq<Object> ev) {
                return AdditiveMonoid.isZero$mcJ$sp$(this, a, ev);
            }

            public Object sum(TraversableOnce as) {
                return AdditiveMonoid.sum$(this, as);
            }

            public double sum$mcD$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid.sum$mcD$sp$(this, as);
            }

            public float sum$mcF$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid.sum$mcF$sp$(this, as);
            }

            public int sum$mcI$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid.sum$mcI$sp$(this, as);
            }

            public long sum$mcJ$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid.sum$mcJ$sp$(this, as);
            }

            public Option<java.math.BigDecimal> trySum(TraversableOnce<java.math.BigDecimal> as) {
                return AdditiveMonoid.trySum$(this, as);
            }

            public double plus$mcD$sp(double x, double y) {
                return AdditiveSemigroup.plus$mcD$sp$(this, x, y);
            }

            public float plus$mcF$sp(float x, float y) {
                return AdditiveSemigroup.plus$mcF$sp$(this, x, y);
            }

            public int plus$mcI$sp(int x, int y) {
                return AdditiveSemigroup.plus$mcI$sp$(this, x, y);
            }

            public long plus$mcJ$sp(long x, long y) {
                return AdditiveSemigroup.plus$mcJ$sp$(this, x, y);
            }

            public Object positiveSumN(Object a, int n) {
                return AdditiveSemigroup.positiveSumN$(this, a, n);
            }

            public double positiveSumN$mcD$sp(double a, int n) {
                return AdditiveSemigroup.positiveSumN$mcD$sp$(this, a, n);
            }

            public float positiveSumN$mcF$sp(float a, int n) {
                return AdditiveSemigroup.positiveSumN$mcF$sp$(this, a, n);
            }

            public int positiveSumN$mcI$sp(int a, int n) {
                return AdditiveSemigroup.positiveSumN$mcI$sp$(this, a, n);
            }

            public long positiveSumN$mcJ$sp(long a, int n) {
                return AdditiveSemigroup.positiveSumN$mcJ$sp$(this, a, n);
            }

            public Sign sign(Object a) {
                return Signed.sign$(this, a);
            }

            public Sign sign$mcB$sp(byte a) {
                return Signed.sign$mcB$sp$(this, a);
            }

            public Sign sign$mcD$sp(double a) {
                return Signed.sign$mcD$sp$(this, a);
            }

            public Sign sign$mcF$sp(float a) {
                return Signed.sign$mcF$sp$(this, a);
            }

            public Sign sign$mcI$sp(int a) {
                return Signed.sign$mcI$sp$(this, a);
            }

            public Sign sign$mcJ$sp(long a) {
                return Signed.sign$mcJ$sp$(this, a);
            }

            public Sign sign$mcS$sp(short a) {
                return Signed.sign$mcS$sp$(this, a);
            }

            public boolean isSignZero(Object a) {
                return Signed.isSignZero$(this, a);
            }

            public boolean isSignZero$mcB$sp(byte a) {
                return Signed.isSignZero$mcB$sp$(this, a);
            }

            public boolean isSignZero$mcD$sp(double a) {
                return Signed.isSignZero$mcD$sp$(this, a);
            }

            public boolean isSignZero$mcF$sp(float a) {
                return Signed.isSignZero$mcF$sp$(this, a);
            }

            public boolean isSignZero$mcI$sp(int a) {
                return Signed.isSignZero$mcI$sp$(this, a);
            }

            public boolean isSignZero$mcJ$sp(long a) {
                return Signed.isSignZero$mcJ$sp$(this, a);
            }

            public boolean isSignZero$mcS$sp(short a) {
                return Signed.isSignZero$mcS$sp$(this, a);
            }

            public boolean isSignPositive(Object a) {
                return Signed.isSignPositive$(this, a);
            }

            public boolean isSignPositive$mcB$sp(byte a) {
                return Signed.isSignPositive$mcB$sp$(this, a);
            }

            public boolean isSignPositive$mcD$sp(double a) {
                return Signed.isSignPositive$mcD$sp$(this, a);
            }

            public boolean isSignPositive$mcF$sp(float a) {
                return Signed.isSignPositive$mcF$sp$(this, a);
            }

            public boolean isSignPositive$mcI$sp(int a) {
                return Signed.isSignPositive$mcI$sp$(this, a);
            }

            public boolean isSignPositive$mcJ$sp(long a) {
                return Signed.isSignPositive$mcJ$sp$(this, a);
            }

            public boolean isSignPositive$mcS$sp(short a) {
                return Signed.isSignPositive$mcS$sp$(this, a);
            }

            public boolean isSignNegative(Object a) {
                return Signed.isSignNegative$(this, a);
            }

            public boolean isSignNegative$mcB$sp(byte a) {
                return Signed.isSignNegative$mcB$sp$(this, a);
            }

            public boolean isSignNegative$mcD$sp(double a) {
                return Signed.isSignNegative$mcD$sp$(this, a);
            }

            public boolean isSignNegative$mcF$sp(float a) {
                return Signed.isSignNegative$mcF$sp$(this, a);
            }

            public boolean isSignNegative$mcI$sp(int a) {
                return Signed.isSignNegative$mcI$sp$(this, a);
            }

            public boolean isSignNegative$mcJ$sp(long a) {
                return Signed.isSignNegative$mcJ$sp$(this, a);
            }

            public boolean isSignNegative$mcS$sp(short a) {
                return Signed.isSignNegative$mcS$sp$(this, a);
            }

            public boolean isSignNonZero(Object a) {
                return Signed.isSignNonZero$(this, a);
            }

            public boolean isSignNonZero$mcB$sp(byte a) {
                return Signed.isSignNonZero$mcB$sp$(this, a);
            }

            public boolean isSignNonZero$mcD$sp(double a) {
                return Signed.isSignNonZero$mcD$sp$(this, a);
            }

            public boolean isSignNonZero$mcF$sp(float a) {
                return Signed.isSignNonZero$mcF$sp$(this, a);
            }

            public boolean isSignNonZero$mcI$sp(int a) {
                return Signed.isSignNonZero$mcI$sp$(this, a);
            }

            public boolean isSignNonZero$mcJ$sp(long a) {
                return Signed.isSignNonZero$mcJ$sp$(this, a);
            }

            public boolean isSignNonZero$mcS$sp(short a) {
                return Signed.isSignNonZero$mcS$sp$(this, a);
            }

            public boolean isSignNonPositive(Object a) {
                return Signed.isSignNonPositive$(this, a);
            }

            public boolean isSignNonPositive$mcB$sp(byte a) {
                return Signed.isSignNonPositive$mcB$sp$(this, a);
            }

            public boolean isSignNonPositive$mcD$sp(double a) {
                return Signed.isSignNonPositive$mcD$sp$(this, a);
            }

            public boolean isSignNonPositive$mcF$sp(float a) {
                return Signed.isSignNonPositive$mcF$sp$(this, a);
            }

            public boolean isSignNonPositive$mcI$sp(int a) {
                return Signed.isSignNonPositive$mcI$sp$(this, a);
            }

            public boolean isSignNonPositive$mcJ$sp(long a) {
                return Signed.isSignNonPositive$mcJ$sp$(this, a);
            }

            public boolean isSignNonPositive$mcS$sp(short a) {
                return Signed.isSignNonPositive$mcS$sp$(this, a);
            }

            public boolean isSignNonNegative(Object a) {
                return Signed.isSignNonNegative$(this, a);
            }

            public boolean isSignNonNegative$mcB$sp(byte a) {
                return Signed.isSignNonNegative$mcB$sp$(this, a);
            }

            public boolean isSignNonNegative$mcD$sp(double a) {
                return Signed.isSignNonNegative$mcD$sp$(this, a);
            }

            public boolean isSignNonNegative$mcF$sp(float a) {
                return Signed.isSignNonNegative$mcF$sp$(this, a);
            }

            public boolean isSignNonNegative$mcI$sp(int a) {
                return Signed.isSignNonNegative$mcI$sp$(this, a);
            }

            public boolean isSignNonNegative$mcJ$sp(long a) {
                return Signed.isSignNonNegative$mcJ$sp$(this, a);
            }

            public boolean isSignNonNegative$mcS$sp(short a) {
                return Signed.isSignNonNegative$mcS$sp$(this, a);
            }

            public int compare$mcZ$sp(boolean x, boolean y) {
                return Order.compare$mcZ$sp$(this, x, y);
            }

            public int compare$mcB$sp(byte x, byte y) {
                return Order.compare$mcB$sp$(this, x, y);
            }

            public int compare$mcC$sp(char x, char y) {
                return Order.compare$mcC$sp$(this, x, y);
            }

            public int compare$mcD$sp(double x, double y) {
                return Order.compare$mcD$sp$(this, x, y);
            }

            public int compare$mcF$sp(float x, float y) {
                return Order.compare$mcF$sp$(this, x, y);
            }

            public int compare$mcI$sp(int x, int y) {
                return Order.compare$mcI$sp$(this, x, y);
            }

            public int compare$mcJ$sp(long x, long y) {
                return Order.compare$mcJ$sp$(this, x, y);
            }

            public int compare$mcS$sp(short x, short y) {
                return Order.compare$mcS$sp$(this, x, y);
            }

            public int compare$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order.compare$mcV$sp$(this, x, y);
            }

            public Comparison comparison(Object x, Object y) {
                return Order.comparison$(this, x, y);
            }

            public Comparison comparison$mcZ$sp(boolean x, boolean y) {
                return Order.comparison$mcZ$sp$(this, x, y);
            }

            public Comparison comparison$mcB$sp(byte x, byte y) {
                return Order.comparison$mcB$sp$(this, x, y);
            }

            public Comparison comparison$mcC$sp(char x, char y) {
                return Order.comparison$mcC$sp$(this, x, y);
            }

            public Comparison comparison$mcD$sp(double x, double y) {
                return Order.comparison$mcD$sp$(this, x, y);
            }

            public Comparison comparison$mcF$sp(float x, float y) {
                return Order.comparison$mcF$sp$(this, x, y);
            }

            public Comparison comparison$mcI$sp(int x, int y) {
                return Order.comparison$mcI$sp$(this, x, y);
            }

            public Comparison comparison$mcJ$sp(long x, long y) {
                return Order.comparison$mcJ$sp$(this, x, y);
            }

            public Comparison comparison$mcS$sp(short x, short y) {
                return Order.comparison$mcS$sp$(this, x, y);
            }

            public Comparison comparison$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order.comparison$mcV$sp$(this, x, y);
            }

            public double partialCompare(Object x, Object y) {
                return Order.partialCompare$(this, x, y);
            }

            public double partialCompare$mcZ$sp(boolean x, boolean y) {
                return Order.partialCompare$mcZ$sp$(this, x, y);
            }

            public double partialCompare$mcB$sp(byte x, byte y) {
                return Order.partialCompare$mcB$sp$(this, x, y);
            }

            public double partialCompare$mcC$sp(char x, char y) {
                return Order.partialCompare$mcC$sp$(this, x, y);
            }

            public double partialCompare$mcD$sp(double x, double y) {
                return Order.partialCompare$mcD$sp$(this, x, y);
            }

            public double partialCompare$mcF$sp(float x, float y) {
                return Order.partialCompare$mcF$sp$(this, x, y);
            }

            public double partialCompare$mcI$sp(int x, int y) {
                return Order.partialCompare$mcI$sp$(this, x, y);
            }

            public double partialCompare$mcJ$sp(long x, long y) {
                return Order.partialCompare$mcJ$sp$(this, x, y);
            }

            public double partialCompare$mcS$sp(short x, short y) {
                return Order.partialCompare$mcS$sp$(this, x, y);
            }

            public double partialCompare$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order.partialCompare$mcV$sp$(this, x, y);
            }

            public Object min(Object x, Object y) {
                return Order.min$(this, x, y);
            }

            public boolean min$mcZ$sp(boolean x, boolean y) {
                return Order.min$mcZ$sp$(this, x, y);
            }

            public byte min$mcB$sp(byte x, byte y) {
                return Order.min$mcB$sp$(this, x, y);
            }

            public char min$mcC$sp(char x, char y) {
                return Order.min$mcC$sp$(this, x, y);
            }

            public double min$mcD$sp(double x, double y) {
                return Order.min$mcD$sp$(this, x, y);
            }

            public float min$mcF$sp(float x, float y) {
                return Order.min$mcF$sp$(this, x, y);
            }

            public int min$mcI$sp(int x, int y) {
                return Order.min$mcI$sp$(this, x, y);
            }

            public long min$mcJ$sp(long x, long y) {
                return Order.min$mcJ$sp$(this, x, y);
            }

            public short min$mcS$sp(short x, short y) {
                return Order.min$mcS$sp$(this, x, y);
            }

            public void min$mcV$sp(BoxedUnit x, BoxedUnit y) {
                Order.min$mcV$sp$(this, x, y);
            }

            public Object max(Object x, Object y) {
                return Order.max$(this, x, y);
            }

            public boolean max$mcZ$sp(boolean x, boolean y) {
                return Order.max$mcZ$sp$(this, x, y);
            }

            public byte max$mcB$sp(byte x, byte y) {
                return Order.max$mcB$sp$(this, x, y);
            }

            public char max$mcC$sp(char x, char y) {
                return Order.max$mcC$sp$(this, x, y);
            }

            public double max$mcD$sp(double x, double y) {
                return Order.max$mcD$sp$(this, x, y);
            }

            public float max$mcF$sp(float x, float y) {
                return Order.max$mcF$sp$(this, x, y);
            }

            public int max$mcI$sp(int x, int y) {
                return Order.max$mcI$sp$(this, x, y);
            }

            public long max$mcJ$sp(long x, long y) {
                return Order.max$mcJ$sp$(this, x, y);
            }

            public short max$mcS$sp(short x, short y) {
                return Order.max$mcS$sp$(this, x, y);
            }

            public void max$mcV$sp(BoxedUnit x, BoxedUnit y) {
                Order.max$mcV$sp$(this, x, y);
            }

            public <B> Order<B> on(Function1<B, java.math.BigDecimal> f) {
                return Order.on$((Order)this, f);
            }

            public <B> Order<B> on$mcZ$sp(Function1<B, Object> f) {
                return Order.on$mcZ$sp$((Order)this, f);
            }

            public <B> Order<B> on$mcB$sp(Function1<B, Object> f) {
                return Order.on$mcB$sp$((Order)this, f);
            }

            public <B> Order<B> on$mcC$sp(Function1<B, Object> f) {
                return Order.on$mcC$sp$((Order)this, f);
            }

            public <B> Order<B> on$mcD$sp(Function1<B, Object> f) {
                return Order.on$mcD$sp$((Order)this, f);
            }

            public <B> Order<B> on$mcF$sp(Function1<B, Object> f) {
                return Order.on$mcF$sp$((Order)this, f);
            }

            public <B> Order<B> on$mcI$sp(Function1<B, Object> f) {
                return Order.on$mcI$sp$((Order)this, f);
            }

            public <B> Order<B> on$mcJ$sp(Function1<B, Object> f) {
                return Order.on$mcJ$sp$((Order)this, f);
            }

            public <B> Order<B> on$mcS$sp(Function1<B, Object> f) {
                return Order.on$mcS$sp$((Order)this, f);
            }

            public <B> Order<B> on$mcV$sp(Function1<B, BoxedUnit> f) {
                return Order.on$mcV$sp$((Order)this, f);
            }

            public Order<Object> on$mZc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order.on$mZc$sp$((Order)this, f);
            }

            public Order<Object> on$mZcZ$sp(Function1<Object, Object> f) {
                return Order.on$mZcZ$sp$((Order)this, f);
            }

            public Order<Object> on$mZcB$sp(Function1<Object, Object> f) {
                return Order.on$mZcB$sp$((Order)this, f);
            }

            public Order<Object> on$mZcC$sp(Function1<Object, Object> f) {
                return Order.on$mZcC$sp$((Order)this, f);
            }

            public Order<Object> on$mZcD$sp(Function1<Object, Object> f) {
                return Order.on$mZcD$sp$((Order)this, f);
            }

            public Order<Object> on$mZcF$sp(Function1<Object, Object> f) {
                return Order.on$mZcF$sp$((Order)this, f);
            }

            public Order<Object> on$mZcI$sp(Function1<Object, Object> f) {
                return Order.on$mZcI$sp$((Order)this, f);
            }

            public Order<Object> on$mZcJ$sp(Function1<Object, Object> f) {
                return Order.on$mZcJ$sp$((Order)this, f);
            }

            public Order<Object> on$mZcS$sp(Function1<Object, Object> f) {
                return Order.on$mZcS$sp$((Order)this, f);
            }

            public Order<Object> on$mZcV$sp(Function1<Object, BoxedUnit> f) {
                return Order.on$mZcV$sp$((Order)this, f);
            }

            public Order<Object> on$mBc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order.on$mBc$sp$((Order)this, f);
            }

            public Order<Object> on$mBcZ$sp(Function1<Object, Object> f) {
                return Order.on$mBcZ$sp$((Order)this, f);
            }

            public Order<Object> on$mBcB$sp(Function1<Object, Object> f) {
                return Order.on$mBcB$sp$((Order)this, f);
            }

            public Order<Object> on$mBcC$sp(Function1<Object, Object> f) {
                return Order.on$mBcC$sp$((Order)this, f);
            }

            public Order<Object> on$mBcD$sp(Function1<Object, Object> f) {
                return Order.on$mBcD$sp$((Order)this, f);
            }

            public Order<Object> on$mBcF$sp(Function1<Object, Object> f) {
                return Order.on$mBcF$sp$((Order)this, f);
            }

            public Order<Object> on$mBcI$sp(Function1<Object, Object> f) {
                return Order.on$mBcI$sp$((Order)this, f);
            }

            public Order<Object> on$mBcJ$sp(Function1<Object, Object> f) {
                return Order.on$mBcJ$sp$((Order)this, f);
            }

            public Order<Object> on$mBcS$sp(Function1<Object, Object> f) {
                return Order.on$mBcS$sp$((Order)this, f);
            }

            public Order<Object> on$mBcV$sp(Function1<Object, BoxedUnit> f) {
                return Order.on$mBcV$sp$((Order)this, f);
            }

            public Order<Object> on$mCc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order.on$mCc$sp$((Order)this, f);
            }

            public Order<Object> on$mCcZ$sp(Function1<Object, Object> f) {
                return Order.on$mCcZ$sp$((Order)this, f);
            }

            public Order<Object> on$mCcB$sp(Function1<Object, Object> f) {
                return Order.on$mCcB$sp$((Order)this, f);
            }

            public Order<Object> on$mCcC$sp(Function1<Object, Object> f) {
                return Order.on$mCcC$sp$((Order)this, f);
            }

            public Order<Object> on$mCcD$sp(Function1<Object, Object> f) {
                return Order.on$mCcD$sp$((Order)this, f);
            }

            public Order<Object> on$mCcF$sp(Function1<Object, Object> f) {
                return Order.on$mCcF$sp$((Order)this, f);
            }

            public Order<Object> on$mCcI$sp(Function1<Object, Object> f) {
                return Order.on$mCcI$sp$((Order)this, f);
            }

            public Order<Object> on$mCcJ$sp(Function1<Object, Object> f) {
                return Order.on$mCcJ$sp$((Order)this, f);
            }

            public Order<Object> on$mCcS$sp(Function1<Object, Object> f) {
                return Order.on$mCcS$sp$((Order)this, f);
            }

            public Order<Object> on$mCcV$sp(Function1<Object, BoxedUnit> f) {
                return Order.on$mCcV$sp$((Order)this, f);
            }

            public Order<Object> on$mDc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order.on$mDc$sp$((Order)this, f);
            }

            public Order<Object> on$mDcZ$sp(Function1<Object, Object> f) {
                return Order.on$mDcZ$sp$((Order)this, f);
            }

            public Order<Object> on$mDcB$sp(Function1<Object, Object> f) {
                return Order.on$mDcB$sp$((Order)this, f);
            }

            public Order<Object> on$mDcC$sp(Function1<Object, Object> f) {
                return Order.on$mDcC$sp$((Order)this, f);
            }

            public Order<Object> on$mDcD$sp(Function1<Object, Object> f) {
                return Order.on$mDcD$sp$((Order)this, f);
            }

            public Order<Object> on$mDcF$sp(Function1<Object, Object> f) {
                return Order.on$mDcF$sp$((Order)this, f);
            }

            public Order<Object> on$mDcI$sp(Function1<Object, Object> f) {
                return Order.on$mDcI$sp$((Order)this, f);
            }

            public Order<Object> on$mDcJ$sp(Function1<Object, Object> f) {
                return Order.on$mDcJ$sp$((Order)this, f);
            }

            public Order<Object> on$mDcS$sp(Function1<Object, Object> f) {
                return Order.on$mDcS$sp$((Order)this, f);
            }

            public Order<Object> on$mDcV$sp(Function1<Object, BoxedUnit> f) {
                return Order.on$mDcV$sp$((Order)this, f);
            }

            public Order<Object> on$mFc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order.on$mFc$sp$((Order)this, f);
            }

            public Order<Object> on$mFcZ$sp(Function1<Object, Object> f) {
                return Order.on$mFcZ$sp$((Order)this, f);
            }

            public Order<Object> on$mFcB$sp(Function1<Object, Object> f) {
                return Order.on$mFcB$sp$((Order)this, f);
            }

            public Order<Object> on$mFcC$sp(Function1<Object, Object> f) {
                return Order.on$mFcC$sp$((Order)this, f);
            }

            public Order<Object> on$mFcD$sp(Function1<Object, Object> f) {
                return Order.on$mFcD$sp$((Order)this, f);
            }

            public Order<Object> on$mFcF$sp(Function1<Object, Object> f) {
                return Order.on$mFcF$sp$((Order)this, f);
            }

            public Order<Object> on$mFcI$sp(Function1<Object, Object> f) {
                return Order.on$mFcI$sp$((Order)this, f);
            }

            public Order<Object> on$mFcJ$sp(Function1<Object, Object> f) {
                return Order.on$mFcJ$sp$((Order)this, f);
            }

            public Order<Object> on$mFcS$sp(Function1<Object, Object> f) {
                return Order.on$mFcS$sp$((Order)this, f);
            }

            public Order<Object> on$mFcV$sp(Function1<Object, BoxedUnit> f) {
                return Order.on$mFcV$sp$((Order)this, f);
            }

            public Order<Object> on$mIc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order.on$mIc$sp$((Order)this, f);
            }

            public Order<Object> on$mIcZ$sp(Function1<Object, Object> f) {
                return Order.on$mIcZ$sp$((Order)this, f);
            }

            public Order<Object> on$mIcB$sp(Function1<Object, Object> f) {
                return Order.on$mIcB$sp$((Order)this, f);
            }

            public Order<Object> on$mIcC$sp(Function1<Object, Object> f) {
                return Order.on$mIcC$sp$((Order)this, f);
            }

            public Order<Object> on$mIcD$sp(Function1<Object, Object> f) {
                return Order.on$mIcD$sp$((Order)this, f);
            }

            public Order<Object> on$mIcF$sp(Function1<Object, Object> f) {
                return Order.on$mIcF$sp$((Order)this, f);
            }

            public Order<Object> on$mIcI$sp(Function1<Object, Object> f) {
                return Order.on$mIcI$sp$((Order)this, f);
            }

            public Order<Object> on$mIcJ$sp(Function1<Object, Object> f) {
                return Order.on$mIcJ$sp$((Order)this, f);
            }

            public Order<Object> on$mIcS$sp(Function1<Object, Object> f) {
                return Order.on$mIcS$sp$((Order)this, f);
            }

            public Order<Object> on$mIcV$sp(Function1<Object, BoxedUnit> f) {
                return Order.on$mIcV$sp$((Order)this, f);
            }

            public Order<Object> on$mJc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order.on$mJc$sp$((Order)this, f);
            }

            public Order<Object> on$mJcZ$sp(Function1<Object, Object> f) {
                return Order.on$mJcZ$sp$((Order)this, f);
            }

            public Order<Object> on$mJcB$sp(Function1<Object, Object> f) {
                return Order.on$mJcB$sp$((Order)this, f);
            }

            public Order<Object> on$mJcC$sp(Function1<Object, Object> f) {
                return Order.on$mJcC$sp$((Order)this, f);
            }

            public Order<Object> on$mJcD$sp(Function1<Object, Object> f) {
                return Order.on$mJcD$sp$((Order)this, f);
            }

            public Order<Object> on$mJcF$sp(Function1<Object, Object> f) {
                return Order.on$mJcF$sp$((Order)this, f);
            }

            public Order<Object> on$mJcI$sp(Function1<Object, Object> f) {
                return Order.on$mJcI$sp$((Order)this, f);
            }

            public Order<Object> on$mJcJ$sp(Function1<Object, Object> f) {
                return Order.on$mJcJ$sp$((Order)this, f);
            }

            public Order<Object> on$mJcS$sp(Function1<Object, Object> f) {
                return Order.on$mJcS$sp$((Order)this, f);
            }

            public Order<Object> on$mJcV$sp(Function1<Object, BoxedUnit> f) {
                return Order.on$mJcV$sp$((Order)this, f);
            }

            public Order<Object> on$mSc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order.on$mSc$sp$((Order)this, f);
            }

            public Order<Object> on$mScZ$sp(Function1<Object, Object> f) {
                return Order.on$mScZ$sp$((Order)this, f);
            }

            public Order<Object> on$mScB$sp(Function1<Object, Object> f) {
                return Order.on$mScB$sp$((Order)this, f);
            }

            public Order<Object> on$mScC$sp(Function1<Object, Object> f) {
                return Order.on$mScC$sp$((Order)this, f);
            }

            public Order<Object> on$mScD$sp(Function1<Object, Object> f) {
                return Order.on$mScD$sp$((Order)this, f);
            }

            public Order<Object> on$mScF$sp(Function1<Object, Object> f) {
                return Order.on$mScF$sp$((Order)this, f);
            }

            public Order<Object> on$mScI$sp(Function1<Object, Object> f) {
                return Order.on$mScI$sp$((Order)this, f);
            }

            public Order<Object> on$mScJ$sp(Function1<Object, Object> f) {
                return Order.on$mScJ$sp$((Order)this, f);
            }

            public Order<Object> on$mScS$sp(Function1<Object, Object> f) {
                return Order.on$mScS$sp$((Order)this, f);
            }

            public Order<Object> on$mScV$sp(Function1<Object, BoxedUnit> f) {
                return Order.on$mScV$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVc$sp(Function1<BoxedUnit, java.math.BigDecimal> f) {
                return Order.on$mVc$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVcZ$sp(Function1<BoxedUnit, Object> f) {
                return Order.on$mVcZ$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVcB$sp(Function1<BoxedUnit, Object> f) {
                return Order.on$mVcB$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVcC$sp(Function1<BoxedUnit, Object> f) {
                return Order.on$mVcC$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVcD$sp(Function1<BoxedUnit, Object> f) {
                return Order.on$mVcD$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVcF$sp(Function1<BoxedUnit, Object> f) {
                return Order.on$mVcF$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVcI$sp(Function1<BoxedUnit, Object> f) {
                return Order.on$mVcI$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVcJ$sp(Function1<BoxedUnit, Object> f) {
                return Order.on$mVcJ$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVcS$sp(Function1<BoxedUnit, Object> f) {
                return Order.on$mVcS$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVcV$sp(Function1<BoxedUnit, BoxedUnit> f) {
                return Order.on$mVcV$sp$((Order)this, f);
            }

            public Order<java.math.BigDecimal> reverse() {
                return Order.reverse$((Order)this);
            }

            public Order<Object> reverse$mcZ$sp() {
                return Order.reverse$mcZ$sp$((Order)this);
            }

            public Order<Object> reverse$mcB$sp() {
                return Order.reverse$mcB$sp$((Order)this);
            }

            public Order<Object> reverse$mcC$sp() {
                return Order.reverse$mcC$sp$((Order)this);
            }

            public Order<Object> reverse$mcD$sp() {
                return Order.reverse$mcD$sp$((Order)this);
            }

            public Order<Object> reverse$mcF$sp() {
                return Order.reverse$mcF$sp$((Order)this);
            }

            public Order<Object> reverse$mcI$sp() {
                return Order.reverse$mcI$sp$((Order)this);
            }

            public Order<Object> reverse$mcJ$sp() {
                return Order.reverse$mcJ$sp$((Order)this);
            }

            public Order<Object> reverse$mcS$sp() {
                return Order.reverse$mcS$sp$((Order)this);
            }

            public Order<BoxedUnit> reverse$mcV$sp() {
                return Order.reverse$mcV$sp$((Order)this);
            }

            public boolean eqv(Object x, Object y) {
                return Order.eqv$(this, x, y);
            }

            public boolean eqv$mcZ$sp(boolean x, boolean y) {
                return Order.eqv$mcZ$sp$(this, x, y);
            }

            public boolean eqv$mcB$sp(byte x, byte y) {
                return Order.eqv$mcB$sp$(this, x, y);
            }

            public boolean eqv$mcC$sp(char x, char y) {
                return Order.eqv$mcC$sp$(this, x, y);
            }

            public boolean eqv$mcD$sp(double x, double y) {
                return Order.eqv$mcD$sp$(this, x, y);
            }

            public boolean eqv$mcF$sp(float x, float y) {
                return Order.eqv$mcF$sp$(this, x, y);
            }

            public boolean eqv$mcI$sp(int x, int y) {
                return Order.eqv$mcI$sp$(this, x, y);
            }

            public boolean eqv$mcJ$sp(long x, long y) {
                return Order.eqv$mcJ$sp$(this, x, y);
            }

            public boolean eqv$mcS$sp(short x, short y) {
                return Order.eqv$mcS$sp$(this, x, y);
            }

            public boolean eqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order.eqv$mcV$sp$(this, x, y);
            }

            public boolean neqv(Object x, Object y) {
                return Order.neqv$(this, x, y);
            }

            public boolean neqv$mcZ$sp(boolean x, boolean y) {
                return Order.neqv$mcZ$sp$(this, x, y);
            }

            public boolean neqv$mcB$sp(byte x, byte y) {
                return Order.neqv$mcB$sp$(this, x, y);
            }

            public boolean neqv$mcC$sp(char x, char y) {
                return Order.neqv$mcC$sp$(this, x, y);
            }

            public boolean neqv$mcD$sp(double x, double y) {
                return Order.neqv$mcD$sp$(this, x, y);
            }

            public boolean neqv$mcF$sp(float x, float y) {
                return Order.neqv$mcF$sp$(this, x, y);
            }

            public boolean neqv$mcI$sp(int x, int y) {
                return Order.neqv$mcI$sp$(this, x, y);
            }

            public boolean neqv$mcJ$sp(long x, long y) {
                return Order.neqv$mcJ$sp$(this, x, y);
            }

            public boolean neqv$mcS$sp(short x, short y) {
                return Order.neqv$mcS$sp$(this, x, y);
            }

            public boolean neqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order.neqv$mcV$sp$(this, x, y);
            }

            public boolean lteqv(Object x, Object y) {
                return Order.lteqv$(this, x, y);
            }

            public boolean lteqv$mcZ$sp(boolean x, boolean y) {
                return Order.lteqv$mcZ$sp$(this, x, y);
            }

            public boolean lteqv$mcB$sp(byte x, byte y) {
                return Order.lteqv$mcB$sp$(this, x, y);
            }

            public boolean lteqv$mcC$sp(char x, char y) {
                return Order.lteqv$mcC$sp$(this, x, y);
            }

            public boolean lteqv$mcD$sp(double x, double y) {
                return Order.lteqv$mcD$sp$(this, x, y);
            }

            public boolean lteqv$mcF$sp(float x, float y) {
                return Order.lteqv$mcF$sp$(this, x, y);
            }

            public boolean lteqv$mcI$sp(int x, int y) {
                return Order.lteqv$mcI$sp$(this, x, y);
            }

            public boolean lteqv$mcJ$sp(long x, long y) {
                return Order.lteqv$mcJ$sp$(this, x, y);
            }

            public boolean lteqv$mcS$sp(short x, short y) {
                return Order.lteqv$mcS$sp$(this, x, y);
            }

            public boolean lteqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order.lteqv$mcV$sp$(this, x, y);
            }

            public boolean lt(Object x, Object y) {
                return Order.lt$(this, x, y);
            }

            public boolean lt$mcZ$sp(boolean x, boolean y) {
                return Order.lt$mcZ$sp$(this, x, y);
            }

            public boolean lt$mcB$sp(byte x, byte y) {
                return Order.lt$mcB$sp$(this, x, y);
            }

            public boolean lt$mcC$sp(char x, char y) {
                return Order.lt$mcC$sp$(this, x, y);
            }

            public boolean lt$mcD$sp(double x, double y) {
                return Order.lt$mcD$sp$(this, x, y);
            }

            public boolean lt$mcF$sp(float x, float y) {
                return Order.lt$mcF$sp$(this, x, y);
            }

            public boolean lt$mcI$sp(int x, int y) {
                return Order.lt$mcI$sp$(this, x, y);
            }

            public boolean lt$mcJ$sp(long x, long y) {
                return Order.lt$mcJ$sp$(this, x, y);
            }

            public boolean lt$mcS$sp(short x, short y) {
                return Order.lt$mcS$sp$(this, x, y);
            }

            public boolean lt$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order.lt$mcV$sp$(this, x, y);
            }

            public boolean gteqv(Object x, Object y) {
                return Order.gteqv$(this, x, y);
            }

            public boolean gteqv$mcZ$sp(boolean x, boolean y) {
                return Order.gteqv$mcZ$sp$(this, x, y);
            }

            public boolean gteqv$mcB$sp(byte x, byte y) {
                return Order.gteqv$mcB$sp$(this, x, y);
            }

            public boolean gteqv$mcC$sp(char x, char y) {
                return Order.gteqv$mcC$sp$(this, x, y);
            }

            public boolean gteqv$mcD$sp(double x, double y) {
                return Order.gteqv$mcD$sp$(this, x, y);
            }

            public boolean gteqv$mcF$sp(float x, float y) {
                return Order.gteqv$mcF$sp$(this, x, y);
            }

            public boolean gteqv$mcI$sp(int x, int y) {
                return Order.gteqv$mcI$sp$(this, x, y);
            }

            public boolean gteqv$mcJ$sp(long x, long y) {
                return Order.gteqv$mcJ$sp$(this, x, y);
            }

            public boolean gteqv$mcS$sp(short x, short y) {
                return Order.gteqv$mcS$sp$(this, x, y);
            }

            public boolean gteqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order.gteqv$mcV$sp$(this, x, y);
            }

            public boolean gt(Object x, Object y) {
                return Order.gt$(this, x, y);
            }

            public boolean gt$mcZ$sp(boolean x, boolean y) {
                return Order.gt$mcZ$sp$(this, x, y);
            }

            public boolean gt$mcB$sp(byte x, byte y) {
                return Order.gt$mcB$sp$(this, x, y);
            }

            public boolean gt$mcC$sp(char x, char y) {
                return Order.gt$mcC$sp$(this, x, y);
            }

            public boolean gt$mcD$sp(double x, double y) {
                return Order.gt$mcD$sp$(this, x, y);
            }

            public boolean gt$mcF$sp(float x, float y) {
                return Order.gt$mcF$sp$(this, x, y);
            }

            public boolean gt$mcI$sp(int x, int y) {
                return Order.gt$mcI$sp$(this, x, y);
            }

            public boolean gt$mcJ$sp(long x, long y) {
                return Order.gt$mcJ$sp$(this, x, y);
            }

            public boolean gt$mcS$sp(short x, short y) {
                return Order.gt$mcS$sp$(this, x, y);
            }

            public boolean gt$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order.gt$mcV$sp$(this, x, y);
            }

            public Order<java.math.BigDecimal> whenEqual(Order<java.math.BigDecimal> o) {
                return Order.whenEqual$((Order)this, o);
            }

            public Order<Object> whenEqual$mcZ$sp(Order<Object> o) {
                return Order.whenEqual$mcZ$sp$((Order)this, o);
            }

            public Order<Object> whenEqual$mcB$sp(Order<Object> o) {
                return Order.whenEqual$mcB$sp$((Order)this, o);
            }

            public Order<Object> whenEqual$mcC$sp(Order<Object> o) {
                return Order.whenEqual$mcC$sp$((Order)this, o);
            }

            public Order<Object> whenEqual$mcD$sp(Order<Object> o) {
                return Order.whenEqual$mcD$sp$((Order)this, o);
            }

            public Order<Object> whenEqual$mcF$sp(Order<Object> o) {
                return Order.whenEqual$mcF$sp$((Order)this, o);
            }

            public Order<Object> whenEqual$mcI$sp(Order<Object> o) {
                return Order.whenEqual$mcI$sp$((Order)this, o);
            }

            public Order<Object> whenEqual$mcJ$sp(Order<Object> o) {
                return Order.whenEqual$mcJ$sp$((Order)this, o);
            }

            public Order<Object> whenEqual$mcS$sp(Order<Object> o) {
                return Order.whenEqual$mcS$sp$((Order)this, o);
            }

            public Order<BoxedUnit> whenEqual$mcV$sp(Order<BoxedUnit> o) {
                return Order.whenEqual$mcV$sp$((Order)this, o);
            }

            public Ordering<java.math.BigDecimal> toOrdering() {
                return Order.toOrdering$(this);
            }

            public Option partialComparison(Object x, Object y) {
                return PartialOrder.partialComparison$(this, x, y);
            }

            public Option<Comparison> partialComparison$mcZ$sp(boolean x, boolean y) {
                return PartialOrder.partialComparison$mcZ$sp$(this, x, y);
            }

            public Option<Comparison> partialComparison$mcB$sp(byte x, byte y) {
                return PartialOrder.partialComparison$mcB$sp$(this, x, y);
            }

            public Option<Comparison> partialComparison$mcC$sp(char x, char y) {
                return PartialOrder.partialComparison$mcC$sp$(this, x, y);
            }

            public Option<Comparison> partialComparison$mcD$sp(double x, double y) {
                return PartialOrder.partialComparison$mcD$sp$(this, x, y);
            }

            public Option<Comparison> partialComparison$mcF$sp(float x, float y) {
                return PartialOrder.partialComparison$mcF$sp$(this, x, y);
            }

            public Option<Comparison> partialComparison$mcI$sp(int x, int y) {
                return PartialOrder.partialComparison$mcI$sp$(this, x, y);
            }

            public Option<Comparison> partialComparison$mcJ$sp(long x, long y) {
                return PartialOrder.partialComparison$mcJ$sp$(this, x, y);
            }

            public Option<Comparison> partialComparison$mcS$sp(short x, short y) {
                return PartialOrder.partialComparison$mcS$sp$(this, x, y);
            }

            public Option<Comparison> partialComparison$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return PartialOrder.partialComparison$mcV$sp$(this, x, y);
            }

            public Option tryCompare(Object x, Object y) {
                return PartialOrder.tryCompare$(this, x, y);
            }

            public Option<Object> tryCompare$mcZ$sp(boolean x, boolean y) {
                return PartialOrder.tryCompare$mcZ$sp$(this, x, y);
            }

            public Option<Object> tryCompare$mcB$sp(byte x, byte y) {
                return PartialOrder.tryCompare$mcB$sp$(this, x, y);
            }

            public Option<Object> tryCompare$mcC$sp(char x, char y) {
                return PartialOrder.tryCompare$mcC$sp$(this, x, y);
            }

            public Option<Object> tryCompare$mcD$sp(double x, double y) {
                return PartialOrder.tryCompare$mcD$sp$(this, x, y);
            }

            public Option<Object> tryCompare$mcF$sp(float x, float y) {
                return PartialOrder.tryCompare$mcF$sp$(this, x, y);
            }

            public Option<Object> tryCompare$mcI$sp(int x, int y) {
                return PartialOrder.tryCompare$mcI$sp$(this, x, y);
            }

            public Option<Object> tryCompare$mcJ$sp(long x, long y) {
                return PartialOrder.tryCompare$mcJ$sp$(this, x, y);
            }

            public Option<Object> tryCompare$mcS$sp(short x, short y) {
                return PartialOrder.tryCompare$mcS$sp$(this, x, y);
            }

            public Option<Object> tryCompare$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return PartialOrder.tryCompare$mcV$sp$(this, x, y);
            }

            public Option pmin(Object x, Object y) {
                return PartialOrder.pmin$(this, x, y);
            }

            public Option<Object> pmin$mcZ$sp(boolean x, boolean y) {
                return PartialOrder.pmin$mcZ$sp$(this, x, y);
            }

            public Option<Object> pmin$mcB$sp(byte x, byte y) {
                return PartialOrder.pmin$mcB$sp$(this, x, y);
            }

            public Option<Object> pmin$mcC$sp(char x, char y) {
                return PartialOrder.pmin$mcC$sp$(this, x, y);
            }

            public Option<Object> pmin$mcD$sp(double x, double y) {
                return PartialOrder.pmin$mcD$sp$(this, x, y);
            }

            public Option<Object> pmin$mcF$sp(float x, float y) {
                return PartialOrder.pmin$mcF$sp$(this, x, y);
            }

            public Option<Object> pmin$mcI$sp(int x, int y) {
                return PartialOrder.pmin$mcI$sp$(this, x, y);
            }

            public Option<Object> pmin$mcJ$sp(long x, long y) {
                return PartialOrder.pmin$mcJ$sp$(this, x, y);
            }

            public Option<Object> pmin$mcS$sp(short x, short y) {
                return PartialOrder.pmin$mcS$sp$(this, x, y);
            }

            public Option<BoxedUnit> pmin$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return PartialOrder.pmin$mcV$sp$(this, x, y);
            }

            public Option pmax(Object x, Object y) {
                return PartialOrder.pmax$(this, x, y);
            }

            public Option<Object> pmax$mcZ$sp(boolean x, boolean y) {
                return PartialOrder.pmax$mcZ$sp$(this, x, y);
            }

            public Option<Object> pmax$mcB$sp(byte x, byte y) {
                return PartialOrder.pmax$mcB$sp$(this, x, y);
            }

            public Option<Object> pmax$mcC$sp(char x, char y) {
                return PartialOrder.pmax$mcC$sp$(this, x, y);
            }

            public Option<Object> pmax$mcD$sp(double x, double y) {
                return PartialOrder.pmax$mcD$sp$(this, x, y);
            }

            public Option<Object> pmax$mcF$sp(float x, float y) {
                return PartialOrder.pmax$mcF$sp$(this, x, y);
            }

            public Option<Object> pmax$mcI$sp(int x, int y) {
                return PartialOrder.pmax$mcI$sp$(this, x, y);
            }

            public Option<Object> pmax$mcJ$sp(long x, long y) {
                return PartialOrder.pmax$mcJ$sp$(this, x, y);
            }

            public Option<Object> pmax$mcS$sp(short x, short y) {
                return PartialOrder.pmax$mcS$sp$(this, x, y);
            }

            public Option<BoxedUnit> pmax$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return PartialOrder.pmax$mcV$sp$(this, x, y);
            }

            public Eq<java.math.BigDecimal> and(Eq<java.math.BigDecimal> that) {
                return Eq.and$((Eq)this, that);
            }

            public Eq<Object> and$mcZ$sp(Eq<Object> that) {
                return Eq.and$mcZ$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcB$sp(Eq<Object> that) {
                return Eq.and$mcB$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcC$sp(Eq<Object> that) {
                return Eq.and$mcC$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcD$sp(Eq<Object> that) {
                return Eq.and$mcD$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcF$sp(Eq<Object> that) {
                return Eq.and$mcF$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcI$sp(Eq<Object> that) {
                return Eq.and$mcI$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcJ$sp(Eq<Object> that) {
                return Eq.and$mcJ$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcS$sp(Eq<Object> that) {
                return Eq.and$mcS$sp$((Eq)this, that);
            }

            public Eq<BoxedUnit> and$mcV$sp(Eq<BoxedUnit> that) {
                return Eq.and$mcV$sp$((Eq)this, that);
            }

            public Eq<java.math.BigDecimal> or(Eq<java.math.BigDecimal> that) {
                return Eq.or$((Eq)this, that);
            }

            public Eq<Object> or$mcZ$sp(Eq<Object> that) {
                return Eq.or$mcZ$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcB$sp(Eq<Object> that) {
                return Eq.or$mcB$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcC$sp(Eq<Object> that) {
                return Eq.or$mcC$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcD$sp(Eq<Object> that) {
                return Eq.or$mcD$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcF$sp(Eq<Object> that) {
                return Eq.or$mcF$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcI$sp(Eq<Object> that) {
                return Eq.or$mcI$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcJ$sp(Eq<Object> that) {
                return Eq.or$mcJ$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcS$sp(Eq<Object> that) {
                return Eq.or$mcS$sp$((Eq)this, that);
            }

            public Eq<BoxedUnit> or$mcV$sp(Eq<BoxedUnit> that) {
                return Eq.or$mcV$sp$((Eq)this, that);
            }

            public java.math.BigDecimal negate(java.math.BigDecimal x) {
                return x.negate();
            }

            public java.math.BigDecimal zero() {
                return java.math.BigDecimal.ZERO;
            }

            public java.math.BigDecimal plus(java.math.BigDecimal x, java.math.BigDecimal y) {
                return x.add(y);
            }

            public int signum(java.math.BigDecimal a) {
                return a.signum();
            }

            public java.math.BigDecimal abs(java.math.BigDecimal a) {
                return a.abs();
            }

            public int compare(java.math.BigDecimal x, java.math.BigDecimal y) {
                return x.compareTo(y);
            }
            {
                Eq.$init$(this);
                PartialOrder.$init$(this);
                Order.$init$(this);
                Signed.$init$(this);
                AdditiveSemigroup.$init$(this);
                AdditiveMonoid.$init$(this);
                AdditiveCommutativeSemigroup.$init$(this);
                AdditiveCommutativeMonoid.$init$(this);
                SignedAdditiveCMonoid.$init$(this);
                AdditiveGroup.$init$(this);
                AdditiveCommutativeGroup.$init$(this);
                SignedAdditiveAbGroup.$init$(this);
            }
        };
        this.spire$math$poly$BigDecimalRootRefinement$$bits2dec = package$.MODULE$.log(2.0, 10);
    }
}

