/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gsonfire.ClassConfig;
import io.gsonfire.PostProcessor;
import io.gsonfire.PreProcessor;
import io.gsonfire.gson.HooksInvoker;
import io.gsonfire.util.JsonUtils;
import java.io.IOException;

public final class HooksTypeAdapter<T>
extends TypeAdapter<T> {
    private final Class<T> clazz;
    private final ClassConfig<? super T> classConfig;
    private final Gson gson;
    private final TypeAdapter<T> originalTypeAdapter;
    private final HooksInvoker hooksInvoker = new HooksInvoker();

    public HooksTypeAdapter(Class<T> classAdapter, ClassConfig<? super T> classConfig, TypeAdapter<T> originalTypeAdapter, Gson gson) {
        this.classConfig = classConfig;
        this.gson = gson;
        this.originalTypeAdapter = originalTypeAdapter;
        this.clazz = classAdapter;
    }

    @Override
    public void write(JsonWriter out, T value) throws IOException {
        if (this.classConfig.isHooksEnabled()) {
            this.hooksInvoker.preSerialize(value);
        }
        JsonElement res = JsonUtils.toJsonTree(this.originalTypeAdapter, out, value);
        this.runPostSerialize(res, value);
        this.gson.toJson(res, out);
    }

    @Override
    public T read(JsonReader in) throws IOException {
        JsonElement json = new JsonParser().parse(in);
        this.runPreDeserialize(json);
        T result2 = this.deserialize(json, in.isLenient());
        if (this.classConfig.isHooksEnabled()) {
            this.hooksInvoker.postDeserialize(result2, json, this.gson);
        }
        this.runPostDeserialize(result2, json);
        return result2;
    }

    private void runPostSerialize(JsonElement json, T src) {
        for (PostProcessor<T> postProcessor : this.classConfig.getPostProcessors()) {
            postProcessor.postSerialize(json, src, this.gson);
        }
    }

    private void runPostDeserialize(T res, JsonElement src) {
        for (PostProcessor<T> postProcessor : this.classConfig.getPostProcessors()) {
            postProcessor.postDeserialize(res, src, this.gson);
        }
    }

    private void runPreDeserialize(JsonElement json) {
        for (PreProcessor<T> preProcessor : this.classConfig.getPreProcessors()) {
            preProcessor.preDeserialize(this.clazz, json, this.gson);
        }
    }

    private T deserialize(JsonElement json, boolean lenient) throws IOException {
        JsonTreeReader jsonReader = new JsonTreeReader(json);
        jsonReader.setLenient(lenient);
        T deserialized = this.originalTypeAdapter.read(jsonReader);
        return deserialized;
    }
}

