"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BillingAlarm = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const cw = require("aws-cdk-lib/aws-cloudwatch");
const cwa = require("aws-cdk-lib/aws-cloudwatch-actions");
const sns = require("aws-cdk-lib/aws-sns");
const sub = require("aws-cdk-lib/aws-sns-subscriptions");
/**
 * A CDK construct that sets up email notification for when you exceed a given AWS estimated charges amount.
 *
 * Note: The email addresses used as SNS Topic endpoint must be manually confirmed
 * once the stack is deployed.
 *
 * @stability stable
 */
class BillingAlarm extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (props.emails.length === 0) {
            throw new Error('Cannot supply an empty array of email subscriptions');
        }
        const billingAlarmTopic = new sns.Topic(this, 'Topic');
        props.emails.forEach((email) => {
            billingAlarmTopic.addSubscription(
            // TODO: support DLQ
            new sub.EmailSubscription(email));
        });
        const billingAlarmMetric = new cw.Metric({
            metricName: 'EstimatedCharges',
            namespace: 'AWS/Billing',
            statistic: 'Maximum',
            dimensionsMap: {
                Currency: 'USD',
            },
        }).with({
            // Evaluates the metric every 9 hours. This is needed because
            // `EstimatedCharges` metrics is updated every 6 hours
            // See: https://forums.aws.amazon.com/thread.jspa?threadID=135955
            period: aws_cdk_lib_1.Duration.hours(9),
        });
        const billingAlarm = new cw.Alarm(this, 'EstimatedChargesAlarm', {
            alarmDescription: 'Upper monthly billing cost limit',
            comparisonOperator: cw.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
            evaluationPeriods: 1,
            metric: billingAlarmMetric,
            threshold: props.monthlyThreshold,
        });
        const alarmAction = new cwa.SnsAction(billingAlarmTopic);
        billingAlarm.addAlarmAction(alarmAction);
    }
}
exports.BillingAlarm = BillingAlarm;
_a = JSII_RTTI_SYMBOL_1;
BillingAlarm[_a] = { fqn: "aws-cdk-billing-alarm.BillingAlarm", version: "1.1.0" };
//# sourceMappingURL=data:application/json;base64,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