import { Construct } from 'constructs';
/**
 * Properties for a BillingAlarm.
 *
 * @stability stable
 */
export interface BillingAlarmProps {
    /**
     * Monetary amount threshold in USD that represents the maximum exclusive limit before which the alarm is triggered and the notification sent.
     *
     * @stability stable
     */
    readonly monthlyThreshold: number;
    /**
     * The emails to which the alarm-triggered notification will be sent.
     *
     * @stability stable
     */
    readonly emails: Array<string>;
}
/**
 * A CDK construct that sets up email notification for when you exceed a given AWS estimated charges amount.
 *
 * Note: The email addresses used as SNS Topic endpoint must be manually confirmed
 * once the stack is deployed.
 *
 * @stability stable
 */
export declare class BillingAlarm extends Construct {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: BillingAlarmProps);
}
