# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['vcfstats']

package_data = \
{'': ['*']}

install_requires = \
['cmdy',
 'cyvcf2<1.0.0',
 'lark-parser>=0.9,<0.10',
 'pyparam',
 'rich>=6.0.0,<7.0.0',
 'toml<1.0.0']

entry_points = \
{'console_scripts': ['vcfstats = vcfstats.cli:main']}

setup_kwargs = {
    'name': 'vcfstats',
    'version': '0.1.0',
    'description': 'Powerful statistics for VCF files',
    'long_description': '# vcfstats - powerful statistics for VCF files\n\n[![Pypi][1]][2] [![Github][3]][4] [![PythonVers][5]][2] [![docs][6]][13] [![Travis building][7]][8] [![Codacy][9]][10] [![Codacy coverage][11]][10]\n\n[Documentation][13] | [CHANGELOG][12]\n\n## Motivation\nThere are a couple of tools that can plot some statistics of VCF files, including [`bcftools`][14] and [`jvarkit`][15]. However, none of them could:\n1. plot specific metrics\n2. customize the plots\n3. focus on variants with certain filters\n\nR package [`vcfR`][19] can do some of the above. However, it has to load entire VCF into memory, which is not friendly to large VCF files.\n\n## Installation\n`vcfstats` also requires [`R`][16] with [`ggplot2`][17] to be installed. \\\nIf you are doing `pie` chart, [`ggrepel`][18] is also required.\n```shell\npip install vcfstats\n```\n\nOr run with docker or singularity:\n```shell\ndocker run --rm justold/vcfstats:first vcfstats\n# or\nsingularity run docker://justold/vcfstats:first vcfstats\n```\n\n## Gallery\n\n### Number of variants on each chromosome\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'COUNT(1) ~ CONTIG\' \\\n\t--title \'Number of variants on each chromosome\' \\\n\t--config examples/config.toml\n```\n\n![Number of variants on each chromosome](https://github.com/pwwang/vcfstats/raw/master/examples/Number_of_variants_on_each_chromosome.col.png)\n\n#### Changing labels and ticks\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'COUNT(1) ~ CONTIG\' \\\n\t--title \'Number of variants on each chromosome (modified)\' \\\n\t--config examples/config.toml \\\n\t--ggs \'scale_x_discrete(name ="Chromosome", \\\n\t\tlimits=c("1","2","3","4","5","6","7","8","9","10","X")) + \\\n\t\tylab("# Variants")\'\n```\n\n![Number of variants on each chromosome (modified)](https://github.com/pwwang/vcfstats/raw/master/examples/Number_of_variants_on_each_chromosome_(modified).col.png)\n\n#### Number of variants on first 5 chromosome\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'COUNT(1) ~ CONTIG[1,2,3,4,5]\' \\\n\t--title \'Number of variants on each chromosome (first 5)\' \\\n\t--config examples/config.toml\n# or\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'COUNT(1) ~ CONTIG[1-5]\' \\\n\t--title \'Number of variants on each chromosome (first 5)\' \\\n\t--config examples/config.toml\n# or\n# require vcf file to be tabix-indexed.\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'COUNT(1) ~ CONTIG\' \\\n\t--title \'Number of variants on each chromosome (first 5)\' \\\n\t--config examples/config.toml -r 1 2 3 4 5\n```\n\n![Number of variants on each chromosome (first 5)](https://github.com/pwwang/vcfstats/raw/master/examples/Number_of_variants_on_each_chromosome_(first_5).col.png)\n\n### Number of substitutions of SNPs\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'COUNT(1, VARTYPE[snp]) ~ SUBST[A>T,A>G,A>C,T>A,T>G,T>C,G>A,G>T,G>C,C>A,C>T,C>G]\' \\\n\t--title \'Number of substitutions of SNPs\' \\\n\t--config examples/config.toml\n```\n![Number of substitutions of SNPs](https://github.com/pwwang/vcfstats/raw/master/examples/Number_of_substitutions_of_SNPs.col.png)\n\n#### Only with SNPs PASS all filters\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'COUNT(1, VARTYPE[snp]) ~ SUBST[A>T,A>G,A>C,T>A,T>G,T>C,G>A,G>T,G>C,C>A,C>T,C>G]\' \\\n\t--title \'Number of substitutions of SNPs (passed)\' \\\n\t--config examples/config.toml \\\n\t--passed\n```\n\n![Number of substitutions of SNPs (passed)](https://github.com/pwwang/vcfstats/raw/master/examples/Number_of_substitutions_of_SNPs_(passed).col.png)\n\n### Alternative allele frequency on each chromosome\n```shell\n# using a dark theme\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'AAF ~ CONTIG\' \\\n\t--title \'Allele frequency on each chromosome\' \\\n\t--config examples/config.toml --ggs \'theme_dark()\'\n```\n\n![Allele frequency on each chromosome](https://github.com/pwwang/vcfstats/raw/master/examples/Allele_frequency_on_each_chromosome.violin.png)\n\n#### Using boxplot\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'AAF ~ CONTIG\' \\\n\t--title \'Allele frequency on each chromosome (boxplot)\' \\\n\t--config examples/config.toml \\\n\t--figtype boxplot\n```\n\n![Allele frequency on each chromosome](https://github.com/pwwang/vcfstats/raw/master/examples/Allele_frequency_on_each_chromosome.boxplot.png)\n\n#### Using density plot/histogram to investigate the distribution:\nYou can plot the distribution, using density plot or histogram\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'AAF ~ CONTIG[1,2]\' \\\n\t--title \'Allele frequency on chromosome 1,2\' \\\n\t--config examples/config.toml \\\n\t--figtype density\n```\n![Allele frequency on chromosome 1,2](https://github.com/pwwang/vcfstats/raw/master/examples/Allele_frequency_on_chromosome_1_2.density.png)\n\n### Overall distribution of allele frequency\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'AAF ~ 1\' \\\n\t--title \'Overall allele frequency distribution\' \\\n\t--config examples/config.toml\n```\n![Overall allele frequency distribution](https://github.com/pwwang/vcfstats/raw/master/examples/Overall_allele_frequency_distribution.histogram.png)\n\n#### Excluding some low/high frequency variants\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'AAF[0.05, 0.95] ~ 1\' \\\n\t--title \'Overall allele frequency distribution (0.05-0.95)\' \\\n\t--config examples/config.toml\n```\n![Overall allele frequency distribution](https://github.com/pwwang/vcfstats/raw/master/examples/Overall_allele_frequency_distribution_(0.05-0.95).histogram.png)\n\n### Counting types of variants on each chromosome\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'COUNT(1, group=VARTYPE) ~ CHROM\' \\\n\t# or simply\n\t# --formula \'VARTYPE ~ CHROM\' \\\n\t--title \'Types of variants on each chromosome\' \\\n\t--config examples/config.toml\n```\n\n![Types of variants on each chromosome](https://github.com/pwwang/vcfstats/raw/master/examples/Types_of_variants_on_each_chromosome.col.png)\n\n#### Using pie chart if there is only one chromosome\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'COUNT(1, group=VARTYPE) ~ CHROM[1]\' \\\n\t# or simply\n\t# --formula \'VARTYPE ~ CHROM[1]\' \\\n\t--title \'Types of variants on each chromosome 1\' \\\n\t--config examples/config.toml \\\n\t--figtype pie\n```\n![Types of variants on each chromosome 1](https://github.com/pwwang/vcfstats/raw/master/examples/Types_of_variants_on_each_chromosome_1.pie.png)\n\n#### Counting variant types on whole genome\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t# or simply\n\t# --formula \'VARTYPE ~ 1\' \\\n\t--formula \'COUNT(1, group=VARTYPE) ~ 1\' \\\n\t--title \'Types of variants on whole genome\' \\\n\t--config examples/config.toml\n```\n![Types of variants on whole genome](https://github.com/pwwang/vcfstats/raw/master/examples/Types_of_variants_on_whole_genome.pie.png)\n\n### Counting type of mutant genotypes (HET, HOM_ALT) for sample 1 on each chromosome\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t# or simply\n\t# --formula \'GTTYPEs[HET,HOM_ALT]{0} ~ CHROM\' \\\n\t--formula \'COUNT(1, group=GTTYPEs[HET,HOM_ALT]{0}) ~ CHROM\' \\\n\t--title \'Mutant genotypes on each chromosome (sample 1)\' \\\n\t--config examples/config.toml\n```\n\n![Mutant genotypes on each chromosome](https://github.com/pwwang/vcfstats/raw/master/examples/Mutant_genotypes_on_each_chromosome_(sample_1).col.png)\n\n\n### Exploration of mean(genotype quality) and mean(depth) on each chromosome for sample 1\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'MEAN(GQs{0}) ~ MEAN(DEPTHs{0}, group=CHROM)\' \\\n\t--title \'GQ vs depth (sample 1)\' \\\n\t--config examples/config.toml\n```\n![GQ vs depth (sample 1)](https://github.com/pwwang/vcfstats/raw/master/examples/GQ_vs_depth_(sample_1).scatter.png)\n\n### Exploration of depths for sample 1,2\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'DEPTHs{0} ~ DEPTHs{1}\' \\\n\t--title \'Depths between sample 1 and 2\' \\\n\t--config examples/config.toml\n```\n![Depths between sample 1 and 2](https://github.com/pwwang/vcfstats/raw/master/examples/Depths_between_sample_1_and_2.scatter.png)\n\n[1]: https://img.shields.io/pypi/v/vcfstats?style=flat-square\n[2]: https://pypi.org/project/vcfstats/\n[3]: https://img.shields.io/github/v/tag/pwwang/vcfstats?style=flat-square\n[4]: https://github.com/pwwang/vcfstats\n[5]: https://img.shields.io/pypi/pyversions/vcfstats?style=flat-square\n[6]: https://img.shields.io/readthedocs/vcfstats?style=flat-square\n[7]: https://img.shields.io/travis/pwwang/vcfstats?style=flat-square\n[8]: https://travis-ci.org/pwwang/vcfstats\n[9]: https://img.shields.io/codacy/grade/76b84a4cba794f1d925ba98913203c05?style=flat-square\n[10]: https://app.codacy.com/manual/pwwang/vcfstats\n[11]: https://img.shields.io/codacy/coverage/76b84a4cba794f1d925ba98913203c05?style=flat-square\n[12]: https://vcfstats.readthedocs.io/en/latest/CHANGELOG/\n[13]: https://vcfstats.readthedocs.io/en/latest/\n[14]: https://samtools.github.io/bcftools/bcftools.html#stats\n[15]: http://lindenb.github.io/jvarkit/VcfStatsJfx.html\n[16]: https://www.r-project.org/\n[17]: https://ggplot2.tidyverse.org/\n[18]: https://cran.r-project.org/web/packages/ggrepel/vignettes/ggrepel.html\n[19]: https://knausb.github.io/vcfR_documentation/visualization_1.html\n',
    'author': 'pwwang',
    'author_email': 'pwwang@pwwang.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/pwwang/vcfstats',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
