/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.preprocessing;

import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

public class ArithmeticProblem {
    private final int num1;
    private final int num2;
    private final String operation;
    private final int[] manualDistractors;

    public int num1() {
        return this.num1;
    }

    public int num2() {
        return this.num2;
    }

    public String operation() {
        return this.operation;
    }

    public int[] manualDistractors() {
        return this.manualDistractors;
    }

    public String generateText() {
        String string = this.operation();
        String string2 = "+";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return new StringBuilder(9).append("add ").append(this.num1()).append(" and ").append(this.num2()).toString();
        }
        String string3 = this.operation();
        String string4 = "-";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            return new StringBuilder(15).append("subtract ").append(this.num2()).append(" from ").append(this.num1()).toString();
        }
        String string5 = this.operation();
        String string6 = "*";
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            return new StringBuilder(13).append("multipy ").append(this.num1()).append(" and ").append(this.num2()).toString();
        }
        String string7 = this.operation();
        String string8 = "/";
        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
            return new StringBuilder(11).append("divide ").append(this.num2()).append(" by ").append(this.num1()).toString();
        }
        throw new RuntimeException(new StringBuilder(27).append("ERROR: Unknown operation (").append(this.operation()).append(")").toString());
    }

    public Option<Object> generateResult() {
        String string = this.operation();
        String string2 = "+";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return new Some<Object>(BoxesRunTime.boxToInteger(this.num1() + this.num2()));
        }
        String string3 = this.operation();
        String string4 = "-";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            int result = this.num1() - this.num2();
            if (result > 0) {
                return new Some<Object>(BoxesRunTime.boxToInteger(this.num1() - this.num2()));
            }
            return None$.MODULE$;
        }
        String string5 = this.operation();
        String string6 = "*";
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            return new Some<Object>(BoxesRunTime.boxToInteger(this.num1() * this.num2()));
        }
        String string7 = this.operation();
        String string8 = "/";
        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
            double result = (double)this.num2() / (double)this.num1();
            if (result % 1.0 == 0.0) {
                return new Some<Object>(BoxesRunTime.boxToInteger((int)result));
            }
            return None$.MODULE$;
        }
        throw new RuntimeException(new StringBuilder(27).append("ERROR: Unknown operation (").append(this.operation()).append(")").toString());
    }

    public int[] generateDistractors() {
        if (!ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.intArrayOps(this.manualDistractors()))) {
            return this.manualDistractors();
        }
        int minDistractors = 5;
        Option<Object> result = this.generateResult();
        if (result.isEmpty()) {
            return (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int());
        }
        int[] unfilteredDistractors = this.generateDistractorsHelper();
        ArrayBuffer<Integer> filteredDistractors = new ArrayBuffer<Integer>();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(unfilteredDistractors), (Function1<Object, Object> & Serializable)distractor -> ArithmeticProblem.$anonfun$generateDistractors$1(result, filteredDistractors, BoxesRunTime.unboxToInt(distractor)));
        while (filteredDistractors.length() < minDistractors) {
            int randDistractor = Random$.MODULE$.nextInt(49) + 1;
            Object object = randDistractor != BoxesRunTime.unboxToInt(result.get()) && !filteredDistractors.contains(BoxesRunTime.boxToInteger(randDistractor)) ? filteredDistractors.append(BoxesRunTime.boxToInteger(randDistractor)) : BoxedUnit.UNIT;
        }
        return (int[])filteredDistractors.toArray(ClassTag$.MODULE$.Int());
    }

    private int[] generateDistractorsHelper() {
        String string = this.operation();
        String string2 = "+";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return new int[]{this.num1() - this.num2(), this.num2() - this.num1(), this.num1() * this.num2(), (int)package$.MODULE$.round(this.num2() / this.num1()), (int)package$.MODULE$.round(this.num1() / this.num2())};
        }
        String string3 = this.operation();
        String string4 = "-";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            return new int[]{this.num1() + this.num2(), this.num2() - this.num1(), this.num1() * this.num2(), (int)package$.MODULE$.round(this.num2() / this.num1()), (int)package$.MODULE$.round(this.num1() / this.num2())};
        }
        String string5 = this.operation();
        String string6 = "*";
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            return new int[]{this.num1() + this.num2(), this.num1() - this.num2(), this.num2() - this.num1(), (int)package$.MODULE$.round(this.num2() / this.num1()), (int)package$.MODULE$.round(this.num1() / this.num2())};
        }
        String string7 = this.operation();
        String string8 = "/";
        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
            return new int[]{this.num1() + this.num2(), this.num1() - this.num2(), this.num2() - this.num1(), this.num1() * this.num2(), (int)package$.MODULE$.round(this.num1() / this.num2())};
        }
        throw new RuntimeException(new StringBuilder(27).append("ERROR: Unknown operation (").append(this.operation()).append(")").toString());
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof ArithmeticProblem) {
            ArithmeticProblem arithmeticProblem = (ArithmeticProblem)object;
            String string = this.operation();
            String string2 = arithmeticProblem.operation();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            String string3 = this.operation();
            String string4 = "+";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                if (this.num1() == arithmeticProblem.num1() && this.num2() == arithmeticProblem.num2()) {
                    return true;
                }
                return this.num1() == arithmeticProblem.num2() && this.num2() == arithmeticProblem.num1();
            }
            String string5 = this.operation();
            String string6 = "-";
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                return this.num1() == arithmeticProblem.num1() && this.num2() == arithmeticProblem.num2();
            }
            String string7 = this.operation();
            String string8 = "*";
            if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                if (this.num1() == arithmeticProblem.num1() && this.num2() == arithmeticProblem.num2()) {
                    return true;
                }
                return this.num1() == arithmeticProblem.num2() && this.num2() == arithmeticProblem.num1();
            }
            String string9 = this.operation();
            String string10 = "/";
            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                return this.num1() == arithmeticProblem.num1() && this.num2() == arithmeticProblem.num2();
            }
        } else {
            return false;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return false;
    }

    public String toString() {
        return this.generateText();
    }

    public static final /* synthetic */ Object $anonfun$generateDistractors$1(Option result$1, ArrayBuffer filteredDistractors$1, int distractor) {
        return distractor != BoxesRunTime.unboxToInt(result$1.get()) && distractor > 0 ? filteredDistractors$1.append(BoxesRunTime.boxToInteger(distractor)) : BoxedUnit.UNIT;
    }

    public ArithmeticProblem(int num1, int num2, String operation, int[] manualDistractors) {
        this.num1 = num1;
        this.num2 = num2;
        this.operation = operation;
        this.manualDistractors = manualDistractors;
    }
}

