/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.goldagent;

import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcZ$sp;
import scala.util.Random;
import textworldexpress.games.MapReaderGame;
import textworldexpress.goldagent.TreeNode;
import textworldexpress.goldagent.TreeNode$;
import textworldexpress.objects.Room;
import textworldexpress.struct.ActionHistory;
import textworldexpress.struct.StepResult;

public class MapReaderGoldAgent {
    private final MapReaderGame game;
    private final Set<String> knownLocations;

    private boolean findCoinUsingMap(Random r, int numIterations, String lastLocation) {
        Room agentLocation = this.game.agentLocation();
        this.game.step("task");
        this.game.step("read map");
        if (!this.navigateToLocation(this.game.locations(), this.game.startLocation(), this.game.endLocation())) {
            // empty if block
        }
        this.game.step("take coin");
        if (!this.navigateToLocation(this.game.locations(), this.game.endLocation(), this.game.startLocation())) {
            // empty if block
        }
        this.game.step("put coin in box");
        return true;
    }

    private int findCoinUsingMap$default$2() {
        return 0;
    }

    private String findCoinUsingMap$default$3() {
        return "";
    }

    private boolean mkGoldPathCoin(Random r) {
        StepResult stepResult = this.game.initalStep();
        boolean success = this.findCoinUsingMap(r, this.findCoinUsingMap$default$2(), this.findCoinUsingMap$default$3());
        return success;
    }

    public Tuple2<Object, String[]> mkGoldPath(Random r) {
        boolean success = this.mkGoldPathCoin(r);
        if (!success) {
            return new Tuple2<Boolean, Object>(BoxesRunTime.boxToBoolean(false), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        }
        String[] path = (String[])((IterableOnceOps)this.game.history().map((Function1<ActionHistory, String> & Serializable)x$1 -> x$1.actionStr())).toArray(ClassTag$.MODULE$.apply(String.class));
        return new Tuple2<Object, String[]>(BoxesRunTime.boxToBoolean(true), path);
    }

    private boolean navigateToLocation(Room[] locations, Room startLocation, Room endLocation) {
        Object object = new Object();
        try {
            String[] locationSteps = (String[])ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.refArrayOps(this.getLocationPath(this.game.locations(), startLocation, endLocation)));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(locationSteps), (Function1<String, Object> & Serializable)locationStep -> {
                Object object;
                if ($this.game.agentLocation().locationNorth() != null) {
                    String string = $this.game.agentLocation().locationNorth().name();
                    String string2 = locationStep;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        Object object2 = $this.game.agentLocation().doorNorth() != null && !$this.game.agentLocation().doorNorth().isOpen() ? $this.game.step("open door to north") : BoxedUnit.UNIT;
                        object = $this.game.step("move north");
                        return object;
                    }
                }
                if ($this.game.agentLocation().locationSouth() != null) {
                    String string = $this.game.agentLocation().locationSouth().name();
                    String string3 = locationStep;
                    if (!(string != null ? !string.equals(string3) : string3 != null)) {
                        Object object3 = $this.game.agentLocation().doorSouth() != null && !$this.game.agentLocation().doorSouth().isOpen() ? $this.game.step("open door to south") : BoxedUnit.UNIT;
                        object = $this.game.step("move south");
                        return object;
                    }
                }
                if ($this.game.agentLocation().locationEast() != null) {
                    String string = $this.game.agentLocation().locationEast().name();
                    String string4 = locationStep;
                    if (!(string != null ? !string.equals(string4) : string4 != null)) {
                        Object object4 = $this.game.agentLocation().doorEast() != null && !$this.game.agentLocation().doorEast().isOpen() ? $this.game.step("open door to east") : BoxedUnit.UNIT;
                        object = $this.game.step("move east");
                        return object;
                    }
                }
                if ($this.game.agentLocation().locationWest() != null) {
                    String string = $this.game.agentLocation().locationWest().name();
                    String string5 = locationStep;
                    if (!(string != null ? !string.equals(string5) : string5 != null)) {
                        Object object5 = $this.game.agentLocation().doorWest() != null && !$this.game.agentLocation().doorWest().isOpen() ? $this.game.step("open door to west") : BoxedUnit.UNIT;
                        object = $this.game.step("move west");
                        return object;
                    }
                }
                String string = $this.game.agentLocation().name();
                String string6 = locationStep;
                if (!(string != null ? !string.equals(string6) : string6 != null)) {
                    object = BoxedUnit.UNIT;
                    return object;
                }
                Predef$.MODULE$.println(new StringBuilder(33).append("ERROR: Unable to find location (").append((String)locationStep).append(")").toString());
                Predef$.MODULE$.println(new StringBuilder(15).append("FROM Location: ").append($this.game.agentLocation().getDescription()).toString());
                Predef$.MODULE$.println("");
                throw new NonLocalReturnControl$mcZ$sp(object, false);
            });
            return true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return ex.value$mcZ$sp();
        }
    }

    private String[] getLocationPath(Room[] locations, Room startLocation, Room endLocation) {
        Object object = new Object();
        try {
            Set alreadyExplored = (Set)Set$.MODULE$.apply(Nil$.MODULE$);
            TreeNode root = new TreeNode(startLocation, TreeNode$.MODULE$.$lessinit$greater$default$2(), TreeNode$.MODULE$.$lessinit$greater$default$3());
            ArrayBuffer<TreeNode> locationsToCheck = new ArrayBuffer<TreeNode>();
            locationsToCheck.append(root);
            while (locationsToCheck.length() > 0) {
                ArrayBuffer nextLocations = new ArrayBuffer();
                locationsToCheck.foreach((Function1<TreeNode, Object> & Serializable)node -> {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Room location = node.location();
                    String string = location.name();
                    String string2 = endLocation.name();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        throw new NonLocalReturnControl<String[]>(object, node.getPathToRoot());
                    }
                    if (location.locationNorth() != null) {
                        if (!alreadyExplored.contains(location.locationNorth().name())) {
                            TreeNode newNode = new TreeNode(location.locationNorth(), new Some<TreeNode>((TreeNode)node), TreeNode$.MODULE$.$lessinit$greater$default$3());
                            node.addChild(newNode);
                            object4 = nextLocations.append(newNode);
                        } else {
                            object4 = BoxedUnit.UNIT;
                        }
                    } else {
                        object4 = BoxedUnit.UNIT;
                    }
                    if (location.locationSouth() != null) {
                        if (!alreadyExplored.contains(location.locationSouth().name())) {
                            TreeNode newNode = new TreeNode(location.locationSouth(), new Some<TreeNode>((TreeNode)node), TreeNode$.MODULE$.$lessinit$greater$default$3());
                            node.addChild(newNode);
                            object3 = nextLocations.append(newNode);
                        } else {
                            object3 = BoxedUnit.UNIT;
                        }
                    } else {
                        object3 = BoxedUnit.UNIT;
                    }
                    if (location.locationEast() != null) {
                        if (!alreadyExplored.contains(location.locationEast().name())) {
                            TreeNode newNode = new TreeNode(location.locationEast(), new Some<TreeNode>((TreeNode)node), TreeNode$.MODULE$.$lessinit$greater$default$3());
                            node.addChild(newNode);
                            object2 = nextLocations.append(newNode);
                        } else {
                            object2 = BoxedUnit.UNIT;
                        }
                    } else {
                        object2 = BoxedUnit.UNIT;
                    }
                    if (location.locationWest() != null) {
                        if (!alreadyExplored.contains(location.locationWest().name())) {
                            TreeNode newNode = new TreeNode(location.locationWest(), new Some<TreeNode>((TreeNode)node), TreeNode$.MODULE$.$lessinit$greater$default$3());
                            node.addChild(newNode);
                            object = nextLocations.append(newNode);
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                });
                locationsToCheck = nextLocations;
            }
            return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (String[])ex.value();
        }
    }

    public MapReaderGoldAgent(MapReaderGame game) {
        this.game = game;
        this.knownLocations = (Set)Set$.MODULE$.apply(Nil$.MODULE$);
    }
}

