/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.generator;

import java.io.Serializable;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import textworldexpress.games.TWCGameGenerator;
import textworldexpress.generator.GameGenerator;
import textworldexpress.struct.TextGame;

public class GameGeneratorTWC
extends GameGenerator {
    private final int numLocations;
    private final int numItemsToPutAway;
    private final boolean includeDoors;
    private final boolean limitInventorySize;
    private final TWCGameGenerator generator;

    public TWCGameGenerator generator() {
        return this.generator;
    }

    private String checkValidConfiguration() {
        scala.collection.mutable.StringBuilder os = new scala.collection.mutable.StringBuilder();
        Serializable serializable = this.numLocations < 1 ? os.append(new StringBuilder(67).append("Number of locations must be greater than one (specified value = ").append(this.numLocations).append("). ").toString()) : BoxedUnit.UNIT;
        Serializable serializable2 = this.numLocations > 3 ? os.append(new StringBuilder(62).append("Number of locations must be less than 3 (specified value = ").append(this.numLocations).append("). ").toString()) : BoxedUnit.UNIT;
        Serializable serializable3 = this.numItemsToPutAway < 0 ? os.append(new StringBuilder(69).append("Number of items to put away must be at least 1 (specified value = ").append(this.numItemsToPutAway).append("). ").toString()) : BoxedUnit.UNIT;
        Serializable serializable4 = this.numItemsToPutAway > 4 ? os.append(new StringBuilder(69).append("Number of items to put away must be 4 or fewer (specified value = ").append(this.numItemsToPutAway).append("). ").toString()) : BoxedUnit.UNIT;
        return os.toString();
    }

    @Override
    public boolean isInvalid() {
        return this.errorStr().length() > 0;
    }

    @Override
    public TextGame mkGame(long seed, String fold) {
        return this.generator().mkGame(seed, this.numLocations, this.numItemsToPutAway, this.includeDoors, this.limitInventorySize, fold);
    }

    @Override
    public Tuple2<TextGame, String[]> mkGameWithGoldPath(long seed, String fold) {
        return this.generator().mkGameWithGoldPath(seed, this.numLocations, this.numItemsToPutAway, this.includeDoors, this.limitInventorySize, fold);
    }

    public GameGeneratorTWC(int numLocations, int numItemsToPutAway, boolean includeDoors, boolean limitInventorySize) {
        this.numLocations = numLocations;
        this.numItemsToPutAway = numItemsToPutAway;
        this.includeDoors = includeDoors;
        this.limitInventorySize = limitInventorySize;
        this.generator = new TWCGameGenerator();
        this.errorStr_$eq(this.checkValidConfiguration());
    }
}

