/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.games;

import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;
import scala.util.control.Breaks$;
import textworldexpress.data.LoadTWCDataJSON;
import textworldexpress.data.LoadTWCDataJSON$;
import textworldexpress.games.TWCGame;
import textworldexpress.games.TWCGame$;
import textworldexpress.goldagent.TWCGoldAgent;
import textworldexpress.objects.Bathroom;
import textworldexpress.objects.Bedroom;
import textworldexpress.objects.Corridor;
import textworldexpress.objects.Door;
import textworldexpress.objects.DoorMaker;
import textworldexpress.objects.FastObject;
import textworldexpress.objects.Kitchen;
import textworldexpress.objects.LaundryRoom;
import textworldexpress.objects.LivingRoom;
import textworldexpress.objects.Pantry;
import textworldexpress.objects.Room;

public class TWCGameGenerator {
    private final LoadTWCDataJSON TWCObjectDatabase = new LoadTWCDataJSON(LoadTWCDataJSON$.MODULE$.$lessinit$greater$default$1());
    private final DoorMaker doorMaker = new DoorMaker();

    public LoadTWCDataJSON TWCObjectDatabase() {
        return this.TWCObjectDatabase;
    }

    public DoorMaker doorMaker() {
        return this.doorMaker;
    }

    public Tuple2<ArrayBuffer<Room>, ArrayBuffer<FastObject>> mkEnvironment(Random r, int numLocations, int numItemsToPutAway, boolean includeDoors, String fold) {
        ObjectRef locations = ObjectRef.create(new ArrayBuffer());
        ((ArrayBuffer)locations.elem).append(new Kitchen(r, false));
        ((ArrayBuffer)locations.elem).append(new Pantry(r));
        ((ArrayBuffer)locations.elem).append(new Corridor(r));
        ((ArrayBuffer)locations.elem).append(new Bedroom(r));
        ((ArrayBuffer)locations.elem).append(new LivingRoom(r));
        ((ArrayBuffer)locations.elem).append(new Bathroom(r));
        ((ArrayBuffer)locations.elem).append(new LaundryRoom(r));
        Option map = None$.MODULE$;
        for (int attempts = 0; map.isEmpty() && attempts < 50; ++attempts) {
            map = this.mkConnections(r, (ArrayBuffer)locations.elem);
        }
        if (map.isEmpty()) {
            throw new RuntimeException("ERROR: Could not generate connection map");
        }
        this.connectRoomsFromMap(r, (Room[][])((Option)map).get(), includeDoors);
        int attempts1 = 0;
        ArrayBuffer<Room> locationsSubset = ArrayBuffer$.MODULE$.empty();
        while (locationsSubset.isEmpty() && attempts1 < 50) {
            ArrayBuffer<Room> _locationsSubset;
            Tuple2<Object, ArrayBuffer<Room>> tuple2 = this.pickInterconnectedRooms(r, numLocations, (ArrayBuffer)locations.elem);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean success = tuple2._1$mcZ$sp();
            ArrayBuffer<Room> _locationsSubset2 = tuple2._2();
            Tuple2<Boolean, ArrayBuffer<Room>> tuple22 = new Tuple2<Boolean, ArrayBuffer<Room>>(BoxesRunTime.boxToBoolean(success), _locationsSubset2);
            Tuple2<Boolean, ArrayBuffer<Room>> tuple23 = tuple22;
            boolean success2 = tuple23._1$mcZ$sp();
            locationsSubset = _locationsSubset = tuple23._2();
        }
        if (locationsSubset.isEmpty()) {
            throw new RuntimeException("ERROR: Could not generate connection map subset");
        }
        locations.elem = locationsSubset;
        ArrayBuffer<FastObject> taskObjects = this.addTWCItems(r, (ArrayBuffer)locations.elem, numItemsToPutAway, fold);
        if (taskObjects.length() < numItemsToPutAway) {
            throw new RuntimeException(new StringBuilder(28).append("ERROR: Could not add ").append(numItemsToPutAway).append(" items.").toString());
        }
        taskObjects.foreach((Function1<FastObject, Object> & Serializable)taskObject -> {
            TWCGameGenerator.$anonfun$mkEnvironment$1(locations, r, taskObject);
            return BoxedUnit.UNIT;
        });
        return new Tuple2<ArrayBuffer<Room>, ArrayBuffer<FastObject>>((ArrayBuffer)locations.elem, taskObjects);
    }

    public Tuple2<Object, ArrayBuffer<Room>> pickInterconnectedRooms(Random r, int numRoomsDesired, ArrayBuffer<Room> locations) {
        int startRoomIdx = r.nextInt(locations.length());
        Room startRoom = locations.apply(startRoomIdx);
        ArrayBuffer<Room> includedRooms = new ArrayBuffer<Room>();
        includedRooms.append(startRoom);
        int attempts = 0;
        while (includedRooms.length() < numRoomsDesired && attempts < 10) {
            Room randRoom = (Room)includedRooms.apply(r.nextInt(includedRooms.length()));
            Option<Room> connectedRoom = this.getRandomConnectedRoom(r, randRoom, includedRooms);
            Object object = connectedRoom.isDefined() ? includedRooms.append(connectedRoom.get()) : BoxedUnit.UNIT;
        }
        if (includedRooms.length() != numRoomsDesired) {
            return new Tuple2<Boolean, Object>(BoxesRunTime.boxToBoolean(false), ArrayBuffer$.MODULE$.empty());
        }
        ArrayBuffer validRoomNames = (ArrayBuffer)includedRooms.map((Function1<Room, String> & Serializable)x$3 -> x$3.name());
        includedRooms.foreach((Function1<Room, Object> & Serializable)room -> {
            TWCGameGenerator.$anonfun$pickInterconnectedRooms$2(validRoomNames, room);
            return BoxedUnit.UNIT;
        });
        return new Tuple2<Object, ArrayBuffer<Room>>(BoxesRunTime.boxToBoolean(true), includedRooms);
    }

    public Option<Room> getRandomConnectedRoom(Random r, Room room, ArrayBuffer<Room> discludeRooms) {
        ArrayBuffer<Room> possibleRooms = new ArrayBuffer<Room>();
        ArrayBuffer discludedRoomNames = (ArrayBuffer)discludeRooms.map((Function1<Room, String> & Serializable)x$4 -> x$4.name());
        Object object = room.locationNorth() != null && !discludedRoomNames.contains(room.locationNorth().name()) ? possibleRooms.append(room.locationNorth()) : BoxedUnit.UNIT;
        Object object2 = room.locationSouth() != null && !discludedRoomNames.contains(room.locationSouth().name()) ? possibleRooms.append(room.locationSouth()) : BoxedUnit.UNIT;
        Object object3 = room.locationEast() != null && !discludedRoomNames.contains(room.locationEast().name()) ? possibleRooms.append(room.locationEast()) : BoxedUnit.UNIT;
        Object object4 = room.locationWest() != null && !discludedRoomNames.contains(room.locationWest().name()) ? possibleRooms.append(room.locationWest()) : BoxedUnit.UNIT;
        if (possibleRooms.length() == 0) {
            return None$.MODULE$;
        }
        Room randRoom = (Room)possibleRooms.apply(r.nextInt(possibleRooms.length()));
        return new Some<Room>(randRoom);
    }

    public ArrayBuffer<FastObject> addTWCItems(Random r, ArrayBuffer<Room> locations, int numToAdd, String fold) {
        ArrayBuffer<FastObject> objectsAdded = new ArrayBuffer<FastObject>();
        ArrayBuffer<String> objectNamesAdded = new ArrayBuffer<String>();
        for (int attempts = 0; objectsAdded.length() < numToAdd && attempts < 100; ++attempts) {
            BoxedUnit boxedUnit;
            int randLocIdx = r.nextInt(locations.length());
            Room location = locations.apply(randLocIdx);
            FastObject[] objects = (FastObject[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])location.contents().toArray(ClassTag$.MODULE$.apply(FastObject.class))), (Function1<FastObject, String> & Serializable)x$5 -> x$5.name(), Ordering$String$.MODULE$);
            if (objects.length > 0) {
                int randObjIdx = r.nextInt(objects.length);
                FastObject container = objects[randObjIdx];
                Option<FastObject> item = this.TWCObjectDatabase().mkRandomObjectByLocation(r, container.name(), fold);
                if (item.isDefined()) {
                    if (!objectNamesAdded.contains(item.get().name())) {
                        Object object;
                        FastObject containerRoom = container.currentContainer();
                        FastObject fastObject = containerRoom;
                        if (fastObject instanceof Room) {
                            Room room = (Room)fastObject;
                            room.addObject(item.get());
                            objectNamesAdded.append(item.get().name());
                            object = objectsAdded.append(item.get());
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        boxedUnit = object;
                        continue;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return objectsAdded;
    }

    public void connectRoomsFromMap(Random r, Room[][] map, boolean includeDoors) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), map.length).foreach$mVc$sp(i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), map[i].length).foreach$mVc$sp(j -> {
            block8: {
                Room queryLoc;
                Room queryLoc2;
                Room queryLoc3;
                Room queryLoc4;
                Room cell = map[i][j];
                if (cell == null) break block8;
                if (i < map.length - 1 && (queryLoc4 = map[i + 1][j]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc4.name())) {
                    Option<Door> door;
                    cell.locationNorth_$eq(queryLoc4);
                    queryLoc4.locationSouth_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc4.name(), false)).isDefined()) {
                        cell.doorNorth_$eq(door.get());
                        queryLoc4.doorSouth_$eq(door.get());
                    }
                }
                if (i >= 1 && (queryLoc3 = map[i - 1][j]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc3.name())) {
                    Option<Door> door;
                    cell.locationSouth_$eq(queryLoc3);
                    queryLoc3.locationNorth_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc3.name(), false)).isDefined()) {
                        cell.doorSouth_$eq(door.get());
                        queryLoc3.doorNorth_$eq(door.get());
                    }
                }
                if (j >= 1 && (queryLoc2 = map[i][j - 1]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc2.name())) {
                    Option<Door> door;
                    cell.locationEast_$eq(queryLoc2);
                    queryLoc2.locationWest_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc2.name(), false)).isDefined()) {
                        cell.doorEast_$eq(door.get());
                        queryLoc2.doorWest_$eq(door.get());
                    }
                }
                if (j < map[i].length - 1 && (queryLoc = map[i][j + 1]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc.name())) {
                    Option<Door> door;
                    cell.locationWest_$eq(queryLoc);
                    queryLoc.locationEast_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc.name(), false)).isDefined()) {
                        cell.doorWest_$eq(door.get());
                        queryLoc.doorEast_$eq(door.get());
                    }
                }
            }
        }));
    }

    public Tuple2<Object, Object> findEmptyDirection(Random r, Room[][] map, int locX, int locY) {
        Object object = new Object();
        try {
            ArrayBuffer orderToCheck = (ArrayBuffer)r.shuffle((IterableOnce)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})), BuildFrom$.MODULE$.buildFromIterableOps());
            orderToCheck.foreach(directionRef -> {
                if (directionRef == 0) {
                    if (locX - 1 >= 0 && map[locX - 1][locY] == null) {
                        throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX - 1, locY));
                    }
                } else if (directionRef == 1) {
                    if (locX + 1 < map.length && map[locX + 1][locY] == null) {
                        throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX + 1, locY));
                    }
                } else if (directionRef == 2) {
                    if (locY - 1 >= 0 && map[locX][locY - 1] == null) {
                        throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX, locY - 1));
                    }
                } else if (directionRef == 3 && locY + 1 < map.length && map[locX][locY + 1] == null) {
                    throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX, locY + 1));
                }
            });
            return new Tuple2$mcII$sp(-1, -1);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Tuple2)ex.value();
        }
    }

    public Option<Room[][]> mkConnections(Random r, ArrayBuffer<Room> locations) {
        int GRID_SIZE = 7;
        Room[][] map = (Room[][])Array$.MODULE$.ofDim(GRID_SIZE, GRID_SIZE, ClassTag$.MODULE$.apply(Room.class));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), GRID_SIZE).foreach$mVc$sp(i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), GRID_SIZE).foreach$mVc$sp(j -> {
            map$4[i$3][j] = null;
        }));
        ArrayBuffer locationsLeft = new ArrayBuffer();
        locationsLeft.insertAll(0, (IterableOnce)r.shuffle(locations, BuildFrom$.MODULE$.buildFromIterableOps()));
        IntRef lastX = IntRef.create(3);
        IntRef lastY = IntRef.create(3);
        map[lastX.elem][lastY.elem] = (Room)locationsLeft.last();
        locationsLeft.remove(locationsLeft.size() - 1);
        ObjectRef<Room> lastLocation = ObjectRef.create(map[lastX.elem][lastY.elem]);
        IntRef attempts = IntRef.create(0);
        ArrayBuffer<Tuple2$mcII$sp> populatedLocations = new ArrayBuffer<Tuple2$mcII$sp>();
        populatedLocations.append(new Tuple2$mcII$sp(lastX.elem, lastY.elem));
        Breaks$.MODULE$.breakable(() -> {
            while (locationsLeft.length() > 0) {
                Object object;
                int refIdx = r.nextInt(populatedLocations.length());
                lastX$1.elem = ((Tuple2)populatedLocations.apply(refIdx))._1$mcI$sp();
                lastY$1.elem = ((Tuple2)populatedLocations.apply(refIdx))._2$mcI$sp();
                lastLocation$1.elem = map[lastX$1.elem][lastY$1.elem];
                int locationIdx = r.nextInt(locationsLeft.length());
                Room location = (Room)locationsLeft.apply(locationIdx);
                if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(location.prefersConnectingTo()), ((Room)lastLocation$1.elem).name())) {
                    Tuple2<Object, Object> tuple2 = this.findEmptyDirection(r, map, lastX$1.elem, lastY$1.elem);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    int newX = tuple2._1$mcI$sp();
                    int newY = tuple2._2$mcI$sp();
                    Tuple2$mcII$sp tuple2$mcII$sp = new Tuple2$mcII$sp(newX, newY);
                    Tuple2$mcII$sp tuple2$mcII$sp2 = tuple2$mcII$sp;
                    int newX2 = ((Tuple2)tuple2$mcII$sp2)._1$mcI$sp();
                    int newY2 = ((Tuple2)tuple2$mcII$sp2)._2$mcI$sp();
                    if (newX2 != -1) {
                        map$4[newX2][newY2] = location;
                        locationsLeft.remove(locationIdx);
                        object = populatedLocations.append(new Tuple2$mcII$sp(newX2, newY2));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else {
                    object = BoxedUnit.UNIT;
                }
                ++attempts$1.elem;
                if (attempts$1.elem <= 100) continue;
                throw Breaks$.MODULE$.break();
            }
        });
        if (locationsLeft.length() > 0) {
            return None$.MODULE$;
        }
        return new Some<Room[][]>(map);
    }

    public TWCGame mkGame(long seed, int numLocations, int numItemsToPutAway, boolean includeDoors, boolean limitInventorySize, String fold) {
        Integer n;
        Map props = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        props.update("seed", BoxesRunTime.boxToInteger((int)seed));
        props.update("numLocations", BoxesRunTime.boxToInteger(numLocations));
        props.update("numItemsToPutAway", BoxesRunTime.boxToInteger(numItemsToPutAway));
        props.update("includeDoors", includeDoors ? BoxesRunTime.boxToInteger(1) : BoxesRunTime.boxToInteger(0));
        props.update("limitInventorySize", limitInventorySize ? BoxesRunTime.boxToInteger(1) : BoxesRunTime.boxToInteger(0));
        String string = fold;
        String string2 = "train";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            n = BoxesRunTime.boxToInteger(1);
        } else {
            String string3 = fold;
            String string4 = "dev";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                n = BoxesRunTime.boxToInteger(2);
            } else {
                String string5 = fold;
                String string6 = "test";
                n = !(string5 != null ? !string5.equals(string6) : string6 != null) ? BoxesRunTime.boxToInteger(3) : BoxesRunTime.boxToInteger(-1);
            }
        }
        props.update("gameSet", n);
        Random r = new Random(seed);
        Tuple2<ArrayBuffer<Room>, ArrayBuffer<FastObject>> tuple2 = this.mkEnvironment(r, numLocations, numItemsToPutAway, includeDoors, fold);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ArrayBuffer<Room> locations = tuple2._1();
        ArrayBuffer<FastObject> taskObjects = tuple2._2();
        Tuple2<ArrayBuffer<Room>, ArrayBuffer<FastObject>> tuple22 = new Tuple2<ArrayBuffer<Room>, ArrayBuffer<FastObject>>(locations, taskObjects);
        Tuple2<ArrayBuffer<Room>, ArrayBuffer<FastObject>> tuple23 = tuple22;
        ArrayBuffer<Room> locations2 = tuple23._1();
        ArrayBuffer<FastObject> taskObjects2 = tuple23._2();
        Room[] x$1 = (Room[])locations2.toArray(ClassTag$.MODULE$.apply(Room.class));
        ArrayBuffer<FastObject> x$2 = taskObjects2;
        boolean x$3 = limitInventorySize;
        scala.collection.immutable.Map<String, Object> x$4 = props.toMap($less$colon$less$.MODULE$.refl());
        long x$5 = TWCGame$.MODULE$.$lessinit$greater$default$4();
        TWCGame game = new TWCGame(x$1, x$2, x$3, x$5, x$4);
        return game;
    }

    public Tuple2<TWCGame, String[]> mkGameWithGoldPath(long seed, int numLocations, int numItemsToPutAway, boolean includeDoors, boolean limitInventorySize, String fold) {
        int MAX_ATTEMPTS = 50;
        Random rg = new Random();
        IntRef attempts = IntRef.create(0);
        ObjectRef<String[]> goldPath = ObjectRef.create((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        Breaks$.MODULE$.breakable(() -> {
            while (attempts$2.elem < MAX_ATTEMPTS) {
                TWCGame game = this.mkGame(seed, numLocations, numItemsToPutAway, includeDoors, limitInventorySize, fold);
                TWCGoldAgent goldAgent = new TWCGoldAgent(game);
                Tuple2<Object, String[]> tuple2 = goldAgent.mkGoldPath(rg);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                boolean success = tuple2._1$mcZ$sp();
                String[] _goldPath = tuple2._2();
                Tuple2<Boolean, String[]> tuple22 = new Tuple2<Boolean, String[]>(BoxesRunTime.boxToBoolean(success), _goldPath);
                Tuple2<Boolean, String[]> tuple23 = tuple22;
                boolean success2 = tuple23._1$mcZ$sp();
                String[] _goldPath2 = tuple23._2();
                if (success2) {
                    goldPath$1.elem = _goldPath2;
                }
                if (success2) {
                    throw Breaks$.MODULE$.break();
                }
                ++attempts$2.elem;
            }
            Predef$.MODULE$.println(new StringBuilder(91).append("ERROR: Unknown error: Gold path could not be generated after maximum number of attempts (").append(MAX_ATTEMPTS).append(").").toString());
        });
        TWCGame game = this.mkGame(seed, numLocations, numItemsToPutAway, includeDoors, limitInventorySize, fold);
        return new Tuple2<TWCGame, String[]>(game, (String[])goldPath.elem);
    }

    public static final /* synthetic */ void $anonfun$mkEnvironment$1(ObjectRef locations$1, Random r$1, FastObject taskObject) {
        Room randomRoom = (Room)((ArrayBuffer)locations$1.elem).apply(r$1.nextInt(((ArrayBuffer)locations$1.elem).length()));
        randomRoom.addObject(taskObject);
    }

    public static final /* synthetic */ void $anonfun$pickInterconnectedRooms$2(ArrayBuffer validRoomNames$1, Room room) {
        block3: {
            if (room.locationNorth() != null && !validRoomNames$1.contains(room.locationNorth().name())) {
                room.locationNorth_$eq(null);
                room.doorNorth_$eq(null);
            }
            if (room.locationSouth() != null && !validRoomNames$1.contains(room.locationSouth().name())) {
                room.locationSouth_$eq(null);
                room.doorSouth_$eq(null);
            }
            if (room.locationEast() != null && !validRoomNames$1.contains(room.locationEast().name())) {
                room.locationEast_$eq(null);
                room.doorEast_$eq(null);
            }
            if (room.locationWest() == null || validRoomNames$1.contains(room.locationWest().name())) break block3;
            room.locationWest_$eq(null);
            room.doorWest_$eq(null);
        }
    }
}

