/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.games;

import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BooleanRef;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import textworldexpress.data.RecipeIngredient;
import textworldexpress.objects.FastObject;
import textworldexpress.struct.GameScore;
import textworldexpress.struct.Scorer;

public class KitchenGameScoring
extends Scorer {
    private final ArrayBuffer<RecipeIngredient> recipe;
    private final ArrayBuffer<FastObject> taskObjects;
    private double maxScoreFromPrep;
    private Option<FastObject> preparedMeal;

    public ArrayBuffer<RecipeIngredient> recipe() {
        return this.recipe;
    }

    public ArrayBuffer<FastObject> taskObjects() {
        return this.taskObjects;
    }

    public double maxScoreFromPrep() {
        return this.maxScoreFromPrep;
    }

    public void maxScoreFromPrep_$eq(double x$1) {
        this.maxScoreFromPrep = x$1;
    }

    public Option<FastObject> preparedMeal() {
        return this.preparedMeal;
    }

    public void preparedMeal_$eq(Option<FastObject> x$1) {
        this.preparedMeal = x$1;
    }

    public void doScoring(Option<FastObject> preparedMeal) {
        this.preparedMeal_$eq(preparedMeal);
        this.doScoring();
    }

    @Override
    public void doScoring() {
        DoubleRef curScore = DoubleRef.create(0.0);
        BooleanRef taskFailure = BooleanRef.create(false);
        boolean taskSuccess = false;
        if (this.preparedMeal().isEmpty()) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.recipe().length()).foreach$mVc$sp(i -> {
                block4: {
                    if (this.taskObjects().apply(i).isDeleted()) {
                        taskFailure$1.elem = true;
                    }
                    if (this.taskObjects().apply(i).isPreparedIncorrectly(this.recipe().apply(i).preparation())) {
                        taskFailure$1.elem = true;
                    }
                    if (this.taskObjects().apply(i).currentContainer() != null) {
                        String string = this.taskObjects().apply(i).currentContainer().name();
                        String string2 = "inventory";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            curScore$1.elem += 1.0;
                        }
                    }
                    if (!this.recipe().apply(i).requiresPrep()) break block4;
                    curScore$1.elem += this.taskObjects().apply(i).scorePreparedCorrectly(this.recipe().apply(i).preparation());
                }
            });
            this.maxScoreFromPrep_$eq(curScore.elem);
        } else {
            curScore.elem = this.maxScoreFromPrep() + 1.0;
            if (this.preparedMeal().get().isEaten()) {
                curScore.elem += 1.0;
                taskSuccess = true;
            }
        }
        double normalizedScore = curScore.elem / this.maxScore();
        GameScore scores = new GameScore(curScore.elem, normalizedScore, taskSuccess, taskFailure.elem);
        this.curScore_$eq(scores);
    }

    @Override
    public double calculateMaxScore() {
        DoubleRef maxScore = DoubleRef.create(0.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.recipe().length()).foreach$mVc$sp(i -> {
            block1: {
                Set<String> ingredient = this.recipe().apply(i).preparation();
                maxScore$1.elem += 1.0;
                if (!this.recipe().apply(i).preparation().contains("uncut")) {
                    maxScore$1.elem += 1.0;
                }
                if (this.recipe().apply(i).preparation().contains("raw")) break block1;
                maxScore$1.elem += 1.0;
            }
        });
        maxScore.elem += 2.0;
        return maxScore.elem;
    }

    public KitchenGameScoring(ArrayBuffer<RecipeIngredient> recipe, ArrayBuffer<FastObject> taskObjects) {
        this.recipe = recipe;
        this.taskObjects = taskObjects;
        this.maxScoreFromPrep = 0.0;
        this.preparedMeal = None$.MODULE$;
    }
}

