/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.games;

import java.io.Serializable;
import scala.Function1;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.DoubleRef;
import textworldexpress.objects.Box;
import textworldexpress.objects.FastObject;
import textworldexpress.objects.MathProblem;
import textworldexpress.struct.GameScore;
import textworldexpress.struct.Scorer;

public class ArithmeticGameScoring
extends Scorer {
    private final MathProblem mathProblemObj;
    private final Box answerBox;
    private final FastObject correctObject;

    public MathProblem mathProblemObj() {
        return this.mathProblemObj;
    }

    public Box answerBox() {
        return this.answerBox;
    }

    public FastObject correctObject() {
        return this.correctObject;
    }

    @Override
    public void doScoring() {
        DoubleRef curScore = DoubleRef.create(0.0);
        BooleanRef taskFailure = BooleanRef.create(false);
        boolean taskSuccess = false;
        if (this.mathProblemObj().hasBeenRead()) {
            curScore.elem += 1.0;
        }
        this.answerBox().contents().foreach((Function1<FastObject, Object> & Serializable)obj -> {
            ArithmeticGameScoring.$anonfun$doScoring$1(this, curScore, taskFailure, obj);
            return BoxedUnit.UNIT;
        });
        if (taskFailure.elem) {
            curScore.elem = -2.0;
        }
        if (curScore.elem >= this.calculateMaxScore()) {
            taskSuccess = true;
        }
        double normalizedScore = curScore.elem / this.maxScore();
        GameScore scores = new GameScore(curScore.elem, normalizedScore, taskSuccess, taskFailure.elem);
        this.curScore_$eq(scores);
    }

    @Override
    public double calculateMaxScore() {
        double maxScore = 2.0;
        return maxScore;
    }

    public static final /* synthetic */ void $anonfun$doScoring$1(ArithmeticGameScoring $this, DoubleRef curScore$1, BooleanRef taskFailure$1, FastObject obj) {
        String string = obj.name();
        String string2 = $this.correctObject().name();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            curScore$1.elem += 1.0;
        } else {
            taskFailure$1.elem = true;
        }
    }

    public ArithmeticGameScoring(MathProblem mathProblemObj, Box answerBox, FastObject correctObject) {
        this.mathProblemObj = mathProblemObj;
        this.answerBox = answerBox;
        this.correctObject = correctObject;
    }
}

